# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2019 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtCore, except for defaults which are replaced by "...".
"""

# Module PySide2.QtCore
import PySide2
from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken2 as Shiboken
Shiboken.Object = Object

import PySide2.QtCore


def QT_TRANSLATE_NOOP(arg__1: object, arg__2: object) -> object: ...
def QT_TRANSLATE_NOOP3(arg__1: object, arg__2: object, arg__3: object) -> object: ...
def QT_TRANSLATE_NOOP_UTF8(arg__1: object) -> object: ...
def QT_TR_NOOP(arg__1: object) -> object: ...
def QT_TR_NOOP_UTF8(arg__1: object) -> object: ...
def SIGNAL(arg__1: str) -> str: ...
def SLOT(arg__1: str) -> str: ...
def __moduleShutdown(): ...
def qAbs(arg__1: float) -> float: ...
def qAcos(v: float) -> float: ...
def qAddPostRoutine(arg__1: object): ...
def qAsin(v: float) -> float: ...
def qAtan(v: float) -> float: ...
def qAtan2(y: float, x: float) -> float: ...
def qChecksum(s: str, len: int) -> int: ...
@typing.overload
def qCompress(data: PySide2.QtCore.QByteArray, compressionLevel: int = ...) -> PySide2.QtCore.QByteArray: ...
@typing.overload
def qCompress(data: typing.Char, nbytes: int, compressionLevel: int = ...) -> PySide2.QtCore.QByteArray: ...
def qCritical(arg__1: str): ...
def qDebug(arg__1: str): ...
def qExp(v: float) -> float: ...
def qFabs(v: float) -> float: ...
def qFastCos(x: float) -> float: ...
def qFastSin(x: float) -> float: ...
def qFatal(arg__1: str): ...
def qFuzzyCompare(p1: float, p2: float) -> bool: ...
def qFuzzyIsNull(d: float) -> bool: ...
def qInstallMessageHandler(arg__1: object) -> object: ...
def qIsFinite(d: float) -> bool: ...
def qIsInf(d: float) -> bool: ...
def qIsNaN(d: float) -> bool: ...
def qIsNull(d: float) -> bool: ...
def qRegisterResourceData(arg__1: int, arg__2: bytes, arg__3: bytes, arg__4: bytes) -> bool: ...
def qTan(v: float) -> float: ...
@typing.overload
def qUncompress(data: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
@typing.overload
def qUncompress(data: typing.Char, nbytes: int) -> PySide2.QtCore.QByteArray: ...
def qUnregisterResourceData(arg__1: int, arg__2: bytes, arg__3: bytes, arg__4: bytes) -> bool: ...
def qVersion() -> str: ...
def qWarning(arg__1: str): ...
def qrand() -> int: ...
def qsrand(seed: int): ...
def qtTrId(id: str, n: int = ...) -> str: ...


class QAbstractAnimation(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def currentLoop(self) -> int: ...
    def currentLoopTime(self) -> int: ...
    def currentTime(self) -> int: ...
    def direction(self) -> PySide2.QtCore.QAbstractAnimation.Direction: ...
    def duration(self) -> int: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def group(self) -> PySide2.QtCore.QAnimationGroup: ...
    def loopCount(self) -> int: ...
    def pause(self): ...
    def resume(self): ...
    def setCurrentTime(self, msecs: int): ...
    def setDirection(self, direction: PySide2.QtCore.QAbstractAnimation.Direction): ...
    def setLoopCount(self, loopCount: int): ...
    def setPaused(self, arg__1: bool): ...
    def start(self, policy: PySide2.QtCore.QAbstractAnimation.DeletionPolicy = ...): ...
    def state(self) -> PySide2.QtCore.QAbstractAnimation.State: ...
    def stop(self): ...
    def totalDuration(self) -> int: ...
    def updateCurrentTime(self, currentTime: int): ...
    def updateDirection(self, direction: PySide2.QtCore.QAbstractAnimation.Direction): ...
    def updateState(self, newState: PySide2.QtCore.QAbstractAnimation.State, oldState: PySide2.QtCore.QAbstractAnimation.State): ...


class QAbstractEventDispatcher(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def closingDown(self): ...
    def filterNativeEvent(self, eventType: PySide2.QtCore.QByteArray, message: int, result: int) -> bool: ...
    def flush(self): ...
    def hasPendingEvents(self) -> bool: ...
    def installNativeEventFilter(self, filterObj: PySide2.QtCore.QAbstractNativeEventFilter): ...
    @staticmethod
    def instance(thread: PySide2.QtCore.QThread = ...) -> PySide2.QtCore.QAbstractEventDispatcher: ...
    def interrupt(self): ...
    def processEvents(self, flags: PySide2.QtCore.QEventLoop.ProcessEventsFlags) -> bool: ...
    def registerSocketNotifier(self, notifier: PySide2.QtCore.QSocketNotifier): ...
    @typing.overload
    def registerTimer(self, interval: int, timerType: PySide2.QtCore.Qt.TimerType, object: PySide2.QtCore.QObject) -> int: ...
    @typing.overload
    def registerTimer(self, timerId: int, interval: int, timerType: PySide2.QtCore.Qt.TimerType, object: PySide2.QtCore.QObject): ...
    def registeredTimers(self, object: PySide2.QtCore.QObject) -> typing.List[PySide2.QtCore.QAbstractEventDispatcher.TimerInfo]: ...
    def remainingTime(self, timerId: int) -> int: ...
    def removeNativeEventFilter(self, filterObj: PySide2.QtCore.QAbstractNativeEventFilter): ...
    def startingUp(self): ...
    def unregisterSocketNotifier(self, notifier: PySide2.QtCore.QSocketNotifier): ...
    def unregisterTimer(self, timerId: int) -> bool: ...
    def unregisterTimers(self, object: PySide2.QtCore.QObject) -> bool: ...
    def wakeUp(self): ...

    class TimerInfo(Shiboken.Object):

        def __init__(self, id: int, i: int, t: PySide2.QtCore.Qt.TimerType): ...


class QAbstractItemModel(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def beginInsertColumns(self, parent: PySide2.QtCore.QModelIndex, first: int, last: int): ...
    def beginInsertRows(self, parent: PySide2.QtCore.QModelIndex, first: int, last: int): ...
    def beginMoveColumns(self, sourceParent: PySide2.QtCore.QModelIndex, sourceFirst: int, sourceLast: int, destinationParent: PySide2.QtCore.QModelIndex, destinationColumn: int) -> bool: ...
    def beginMoveRows(self, sourceParent: PySide2.QtCore.QModelIndex, sourceFirst: int, sourceLast: int, destinationParent: PySide2.QtCore.QModelIndex, destinationRow: int) -> bool: ...
    def beginRemoveColumns(self, parent: PySide2.QtCore.QModelIndex, first: int, last: int): ...
    def beginRemoveRows(self, parent: PySide2.QtCore.QModelIndex, first: int, last: int): ...
    def beginResetModel(self): ...
    def buddy(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def canDropMimeData(self, data: PySide2.QtCore.QMimeData, action: PySide2.QtCore.Qt.DropAction, row: int, column: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def canFetchMore(self, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def changePersistentIndex(self, from_: PySide2.QtCore.QModelIndex, to: PySide2.QtCore.QModelIndex): ...
    def changePersistentIndexList(self, from_: typing.List[int], to: typing.List[int]): ...
    def checkIndex(self, index: PySide2.QtCore.QModelIndex, options: PySide2.QtCore.QAbstractItemModel.CheckIndexOptions = ...) -> bool: ...
    def columnCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    @typing.overload
    def createIndex(self, row: int, column: int, id: int = ...) -> PySide2.QtCore.QModelIndex: ...
    @typing.overload
    def createIndex(self, row: int, column: int, ptr: object) -> PySide2.QtCore.QModelIndex: ...
    def data(self, index: PySide2.QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def decodeData(self, row: int, column: int, parent: PySide2.QtCore.QModelIndex, stream: PySide2.QtCore.QDataStream) -> bool: ...
    def dropMimeData(self, data: PySide2.QtCore.QMimeData, action: PySide2.QtCore.Qt.DropAction, row: int, column: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def encodeData(self, indexes: typing.List[int], stream: PySide2.QtCore.QDataStream): ...
    def endInsertColumns(self): ...
    def endInsertRows(self): ...
    def endMoveColumns(self): ...
    def endMoveRows(self): ...
    def endRemoveColumns(self): ...
    def endRemoveRows(self): ...
    def endResetModel(self): ...
    def fetchMore(self, parent: PySide2.QtCore.QModelIndex): ...
    def flags(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.Qt.ItemFlags: ...
    def hasChildren(self, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def hasIndex(self, row: int, column: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def headerData(self, section: int, orientation: PySide2.QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def index(self, row: int, column: int, parent: PySide2.QtCore.QModelIndex = ...) -> PySide2.QtCore.QModelIndex: ...
    def insertColumn(self, column: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def insertColumns(self, column: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def insertRow(self, row: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def insertRows(self, row: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def itemData(self, index: PySide2.QtCore.QModelIndex) -> typing.Dict: ...
    def match(self, start: PySide2.QtCore.QModelIndex, role: int, value: typing.Any, hits: int = ..., flags: PySide2.QtCore.Qt.MatchFlags = ...) -> typing.List[int]: ...
    def mimeData(self, indexes: typing.List[int]) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    def moveColumn(self, sourceParent: PySide2.QtCore.QModelIndex, sourceColumn: int, destinationParent: PySide2.QtCore.QModelIndex, destinationChild: int) -> bool: ...
    def moveColumns(self, sourceParent: PySide2.QtCore.QModelIndex, sourceColumn: int, count: int, destinationParent: PySide2.QtCore.QModelIndex, destinationChild: int) -> bool: ...
    def moveRow(self, sourceParent: PySide2.QtCore.QModelIndex, sourceRow: int, destinationParent: PySide2.QtCore.QModelIndex, destinationChild: int) -> bool: ...
    def moveRows(self, sourceParent: PySide2.QtCore.QModelIndex, sourceRow: int, count: int, destinationParent: PySide2.QtCore.QModelIndex, destinationChild: int) -> bool: ...
    @typing.overload
    def parent(self) -> PySide2.QtCore.QObject: ...
    @typing.overload
    def parent(self, child: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def persistentIndexList(self) -> typing.List[int]: ...
    def removeColumn(self, column: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def removeColumns(self, column: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def removeRow(self, row: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def removeRows(self, row: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def resetInternalData(self): ...
    def revert(self): ...
    def roleNames(self) -> typing.Dict: ...
    def rowCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def setData(self, index: PySide2.QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def setHeaderData(self, section: int, orientation: PySide2.QtCore.Qt.Orientation, value: typing.Any, role: int = ...) -> bool: ...
    def setItemData(self, index: PySide2.QtCore.QModelIndex, roles: typing.Dict) -> bool: ...
    def sibling(self, row: int, column: int, idx: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def sort(self, column: int, order: PySide2.QtCore.Qt.SortOrder = ...): ...
    def span(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QSize: ...
    def submit(self) -> bool: ...
    def supportedDragActions(self) -> PySide2.QtCore.Qt.DropActions: ...
    def supportedDropActions(self) -> PySide2.QtCore.Qt.DropActions: ...


class QAbstractListModel(PySide2.QtCore.QAbstractItemModel):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def columnCount(self, parent: PySide2.QtCore.QModelIndex) -> int: ...
    def dropMimeData(self, data: PySide2.QtCore.QMimeData, action: PySide2.QtCore.Qt.DropAction, row: int, column: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def flags(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.Qt.ItemFlags: ...
    def hasChildren(self, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def index(self, row: int, column: int = ..., parent: PySide2.QtCore.QModelIndex = ...) -> PySide2.QtCore.QModelIndex: ...
    @typing.overload
    def parent(self) -> PySide2.QtCore.QObject: ...
    @typing.overload
    def parent(self, child: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def sibling(self, row: int, column: int, idx: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...


class QAbstractNativeEventFilter(Shiboken.Object):

    def __init__(self): ...
    def nativeEventFilter(self, eventType: PySide2.QtCore.QByteArray, message: int, result: int) -> bool: ...


class QAbstractProxyModel(PySide2.QtCore.QAbstractItemModel):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def buddy(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def canDropMimeData(self, data: PySide2.QtCore.QMimeData, action: PySide2.QtCore.Qt.DropAction, row: int, column: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def canFetchMore(self, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def data(self, proxyIndex: PySide2.QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def dropMimeData(self, data: PySide2.QtCore.QMimeData, action: PySide2.QtCore.Qt.DropAction, row: int, column: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def fetchMore(self, parent: PySide2.QtCore.QModelIndex): ...
    def flags(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.Qt.ItemFlags: ...
    def hasChildren(self, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def headerData(self, section: int, orientation: PySide2.QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def itemData(self, index: PySide2.QtCore.QModelIndex) -> typing.Dict: ...
    def mapFromSource(self, sourceIndex: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def mapSelectionFromSource(self, selection: PySide2.QtCore.QItemSelection) -> PySide2.QtCore.QItemSelection: ...
    def mapSelectionToSource(self, selection: PySide2.QtCore.QItemSelection) -> PySide2.QtCore.QItemSelection: ...
    def mapToSource(self, proxyIndex: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def mimeData(self, indexes: typing.List[int]) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    def resetInternalData(self): ...
    def revert(self): ...
    def setData(self, index: PySide2.QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def setHeaderData(self, section: int, orientation: PySide2.QtCore.Qt.Orientation, value: typing.Any, role: int = ...) -> bool: ...
    def setItemData(self, index: PySide2.QtCore.QModelIndex, roles: typing.Dict) -> bool: ...
    def setSourceModel(self, sourceModel: PySide2.QtCore.QAbstractItemModel): ...
    def sibling(self, row: int, column: int, idx: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def sort(self, column: int, order: PySide2.QtCore.Qt.SortOrder = ...): ...
    def sourceModel(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def span(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QSize: ...
    def submit(self) -> bool: ...
    def supportedDragActions(self) -> PySide2.QtCore.Qt.DropActions: ...
    def supportedDropActions(self) -> PySide2.QtCore.Qt.DropActions: ...


class QAbstractState(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QState = ...): ...
    def active(self) -> bool: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def machine(self) -> PySide2.QtCore.QStateMachine: ...
    def onEntry(self, event: PySide2.QtCore.QEvent): ...
    def onExit(self, event: PySide2.QtCore.QEvent): ...
    def parentState(self) -> PySide2.QtCore.QState: ...


class QAbstractTableModel(PySide2.QtCore.QAbstractItemModel):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def dropMimeData(self, data: PySide2.QtCore.QMimeData, action: PySide2.QtCore.Qt.DropAction, row: int, column: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def flags(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.Qt.ItemFlags: ...
    def hasChildren(self, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def index(self, row: int, column: int, parent: PySide2.QtCore.QModelIndex = ...) -> PySide2.QtCore.QModelIndex: ...
    @typing.overload
    def parent(self) -> PySide2.QtCore.QObject: ...
    @typing.overload
    def parent(self, child: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def sibling(self, row: int, column: int, idx: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...


class QAbstractTransition(PySide2.QtCore.QObject):

    def __init__(self, sourceState: PySide2.QtCore.QState = ...): ...
    def addAnimation(self, animation: PySide2.QtCore.QAbstractAnimation): ...
    def animations(self) -> typing.List[PySide2.QtCore.QAbstractAnimation]: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def eventTest(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def machine(self) -> PySide2.QtCore.QStateMachine: ...
    def onTransition(self, event: PySide2.QtCore.QEvent): ...
    def removeAnimation(self, animation: PySide2.QtCore.QAbstractAnimation): ...
    def setTargetState(self, target: PySide2.QtCore.QAbstractState): ...
    def setTargetStates(self, targets: typing.List[PySide2.QtCore.QAbstractState]): ...
    def setTransitionType(self, type: PySide2.QtCore.QAbstractTransition.TransitionType): ...
    def sourceState(self) -> PySide2.QtCore.QState: ...
    def targetState(self) -> PySide2.QtCore.QAbstractState: ...
    def targetStates(self) -> typing.List[PySide2.QtCore.QAbstractState]: ...
    def transitionType(self) -> PySide2.QtCore.QAbstractTransition.TransitionType: ...


class QAnimationGroup(PySide2.QtCore.QAbstractAnimation):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def addAnimation(self, animation: PySide2.QtCore.QAbstractAnimation): ...
    def animationAt(self, index: int) -> PySide2.QtCore.QAbstractAnimation: ...
    def animationCount(self) -> int: ...
    def clear(self): ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def indexOfAnimation(self, animation: PySide2.QtCore.QAbstractAnimation) -> int: ...
    def insertAnimation(self, index: int, animation: PySide2.QtCore.QAbstractAnimation): ...
    def removeAnimation(self, animation: PySide2.QtCore.QAbstractAnimation): ...
    def takeAnimation(self, index: int) -> PySide2.QtCore.QAbstractAnimation: ...


class QBasicMutex(Shiboken.Object):

    def __init__(self): ...
    def isRecursive(self) -> bool: ...
    def lock(self): ...
    def tryLock(self) -> bool: ...
    def try_lock(self) -> bool: ...
    def unlock(self): ...


class QBasicTimer(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QBasicTimer: PySide2.QtCore.QBasicTimer): ...
    def __copy__(self): ...
    def isActive(self) -> bool: ...
    @typing.overload
    def start(self, msec: int, obj: PySide2.QtCore.QObject): ...
    @typing.overload
    def start(self, msec: int, timerType: PySide2.QtCore.Qt.TimerType, obj: PySide2.QtCore.QObject): ...
    def stop(self): ...
    def timerId(self) -> int: ...


class QBitArray(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QBitArray): ...
    @typing.overload
    def __init__(self, size: int, val: bool = ...): ...
    def __and__(self, arg__2: PySide2.QtCore.QBitArray) -> PySide2.QtCore.QBitArray: ...
    def __copy__(self): ...
    def __iand__(self, arg__1: PySide2.QtCore.QBitArray) -> PySide2.QtCore.QBitArray: ...
    def __invert__(self) -> PySide2.QtCore.QBitArray: ...
    def __ior__(self, arg__1: PySide2.QtCore.QBitArray) -> PySide2.QtCore.QBitArray: ...
    def __ixor__(self, arg__1: PySide2.QtCore.QBitArray) -> PySide2.QtCore.QBitArray: ...
    def __or__(self, arg__2: PySide2.QtCore.QBitArray) -> PySide2.QtCore.QBitArray: ...
    def __xor__(self, arg__2: PySide2.QtCore.QBitArray) -> PySide2.QtCore.QBitArray: ...
    def at(self, i: int) -> bool: ...
    def bits(self) -> str: ...
    def clear(self): ...
    def clearBit(self, i: int): ...
    @typing.overload
    def count(self) -> int: ...
    @typing.overload
    def count(self, on: bool) -> int: ...
    @typing.overload
    def fill(self, val: bool, first: int, last: int): ...
    @typing.overload
    def fill(self, val: bool, size: int = ...) -> bool: ...
    @staticmethod
    def fromBits(data: str, len: int) -> PySide2.QtCore.QBitArray: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def resize(self, size: int): ...
    @typing.overload
    def setBit(self, i: int): ...
    @typing.overload
    def setBit(self, i: int, val: bool): ...
    def size(self) -> int: ...
    def swap(self, other: PySide2.QtCore.QBitArray): ...
    def testBit(self, i: int) -> bool: ...
    def toggleBit(self, i: int) -> bool: ...
    def truncate(self, pos: int): ...


class QBuffer(PySide2.QtCore.QIODevice):

    @typing.overload
    def __init__(self, buf: PySide2.QtCore.QByteArray, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def atEnd(self) -> bool: ...
    def buffer(self) -> PySide2.QtCore.QByteArray: ...
    def canReadLine(self) -> bool: ...
    def close(self): ...
    def connectNotify(self, arg__1: PySide2.QtCore.QMetaMethod): ...
    def data(self) -> PySide2.QtCore.QByteArray: ...
    def disconnectNotify(self, arg__1: PySide2.QtCore.QMetaMethod): ...
    def open(self, openMode: PySide2.QtCore.QIODevice.OpenMode) -> bool: ...
    def pos(self) -> int: ...
    def readData(self, data: str, maxlen: int) -> int: ...
    def seek(self, off: int) -> bool: ...
    def setBuffer(self, a: PySide2.QtCore.QByteArray): ...
    def setData(self, data: PySide2.QtCore.QByteArray): ...
    def size(self) -> int: ...
    def writeData(self, data: str, len: int) -> int: ...


class QByteArray(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arg__1: bytearray): ...
    @typing.overload
    def __init__(self, arg__1: bytes): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QByteArray): ...
    @typing.overload
    def __init__(self, size: int, c: typing.Char): ...
    @typing.overload
    def __add__(self, a2: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def __add__(self, a2: typing.Char) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def __add__(self, arg__1: bytearray) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def __add__(self, arg__1: bytes): ...
    def __copy__(self): ...
    @typing.overload
    def __iadd__(self, a: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def __iadd__(self, arg__1: bytearray) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def __iadd__(self, c: typing.Char) -> PySide2.QtCore.QByteArray: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __str__(self) -> object: ...
    @typing.overload
    def append(self, a: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def append(self, c: typing.Char) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def append(self, count: int, c: typing.Char) -> PySide2.QtCore.QByteArray: ...
    def at(self, i: int) -> typing.Char: ...
    def back(self) -> typing.Char: ...
    def capacity(self) -> int: ...
    def cbegin(self) -> str: ...
    def cend(self) -> str: ...
    def chop(self, n: int): ...
    def chopped(self, len: int) -> PySide2.QtCore.QByteArray: ...
    def clear(self): ...
    @typing.overload
    def compare(self, a: PySide2.QtCore.QByteArray, cs: PySide2.QtCore.Qt.CaseSensitivity = ...) -> int: ...
    @typing.overload
    def compare(self, c: str, cs: PySide2.QtCore.Qt.CaseSensitivity = ...) -> int: ...
    @typing.overload
    def contains(self, a: PySide2.QtCore.QByteArray) -> bool: ...
    @typing.overload
    def contains(self, c: typing.Char) -> bool: ...
    @typing.overload
    def count(self) -> int: ...
    @typing.overload
    def count(self, a: PySide2.QtCore.QByteArray) -> int: ...
    @typing.overload
    def count(self, c: typing.Char) -> int: ...
    def data(self) -> str: ...
    @typing.overload
    def endsWith(self, a: PySide2.QtCore.QByteArray) -> bool: ...
    @typing.overload
    def endsWith(self, c: typing.Char) -> bool: ...
    def fill(self, c: typing.Char, size: int = ...) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def fromBase64(base64: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def fromBase64(base64: PySide2.QtCore.QByteArray, options: PySide2.QtCore.QByteArray.Base64Options) -> PySide2.QtCore.QByteArray: ...
    @staticmethod
    def fromHex(hexEncoded: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    @staticmethod
    def fromPercentEncoding(pctEncoded: PySide2.QtCore.QByteArray, percent: typing.Char = ...) -> PySide2.QtCore.QByteArray: ...
    @staticmethod
    def fromRawData(arg__1: str, size: int) -> PySide2.QtCore.QByteArray: ...
    def front(self) -> typing.Char: ...
    def indexOf(self, a: PySide2.QtCore.QByteArray, from_: int = ...) -> int: ...
    @typing.overload
    def insert(self, i: int, a: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def insert(self, i: int, count: int, c: typing.Char) -> PySide2.QtCore.QByteArray: ...
    def isEmpty(self) -> bool: ...
    def isLower(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isSharedWith(self, other: PySide2.QtCore.QByteArray) -> bool: ...
    def isUpper(self) -> bool: ...
    def lastIndexOf(self, a: PySide2.QtCore.QByteArray, from_: int = ...) -> int: ...
    def left(self, len: int) -> PySide2.QtCore.QByteArray: ...
    def leftJustified(self, width: int, fill: typing.Char = ..., truncate: bool = ...) -> PySide2.QtCore.QByteArray: ...
    def length(self) -> int: ...
    def mid(self, index: int, len: int = ...) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def number(arg__1: float, f: typing.Char = ..., prec: int = ...) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def number(arg__1: int, base: int = ...) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def number(arg__1: int, base: int = ...) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def prepend(self, a: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def prepend(self, c: typing.Char) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def prepend(self, count: int, c: typing.Char) -> PySide2.QtCore.QByteArray: ...
    def remove(self, index: int, len: int) -> PySide2.QtCore.QByteArray: ...
    def repeated(self, times: int) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def replace(self, before: PySide2.QtCore.QByteArray, after: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def replace(self, before: str, after: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def replace(self, before: typing.Char, after: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def replace(self, before: typing.Char, after: typing.Char) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def replace(self, index: int, len: int, s: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    def reserve(self, size: int): ...
    def resize(self, size: int): ...
    def right(self, len: int) -> PySide2.QtCore.QByteArray: ...
    def rightJustified(self, width: int, fill: typing.Char = ..., truncate: bool = ...) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def setNum(self, arg__1: float, f: typing.Char = ..., prec: int = ...) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def setNum(self, arg__1: int, base: int = ...) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def setNum(self, arg__1: int, base: int = ...) -> PySide2.QtCore.QByteArray: ...
    def setRawData(self, a: str, n: int) -> PySide2.QtCore.QByteArray: ...
    def shrink_to_fit(self): ...
    def simplified(self) -> PySide2.QtCore.QByteArray: ...
    def size(self) -> int: ...
    def split(self, sep: typing.Char) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def squeeze(self): ...
    @typing.overload
    def startsWith(self, a: PySide2.QtCore.QByteArray) -> bool: ...
    @typing.overload
    def startsWith(self, c: typing.Char) -> bool: ...
    def swap(self, other: PySide2.QtCore.QByteArray): ...
    @typing.overload
    def toBase64(self) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def toBase64(self, options: PySide2.QtCore.QByteArray.Base64Options) -> PySide2.QtCore.QByteArray: ...
    def toDouble(self, ok: bool = ...) -> float: ...
    def toFloat(self, ok: bool = ...) -> float: ...
    @typing.overload
    def toHex(self) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def toHex(self, separator: typing.Char) -> PySide2.QtCore.QByteArray: ...
    def toInt(self, ok: bool = ..., base: int = ...) -> int: ...
    def toLong(self, ok: bool = ..., base: int = ...) -> int: ...
    def toLongLong(self, ok: bool = ..., base: int = ...) -> int: ...
    def toLower(self) -> PySide2.QtCore.QByteArray: ...
    def toPercentEncoding(self, exclude: PySide2.QtCore.QByteArray = ..., include: PySide2.QtCore.QByteArray = ..., percent: typing.Char = ...) -> PySide2.QtCore.QByteArray: ...
    def toShort(self, ok: bool = ..., base: int = ...) -> int: ...
    def toUInt(self, ok: bool = ..., base: int = ...) -> int: ...
    def toULong(self, ok: bool = ..., base: int = ...) -> int: ...
    def toULongLong(self, ok: bool = ..., base: int = ...) -> int: ...
    def toUShort(self, ok: bool = ..., base: int = ...) -> int: ...
    def toUpper(self) -> PySide2.QtCore.QByteArray: ...
    def trimmed(self) -> PySide2.QtCore.QByteArray: ...
    def truncate(self, pos: int): ...


class QByteArrayMatcher(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QByteArrayMatcher): ...
    @typing.overload
    def __init__(self, pattern: PySide2.QtCore.QByteArray): ...
    @typing.overload
    def __init__(self, pattern: str, length: int): ...
    def __copy__(self): ...
    @typing.overload
    def indexIn(self, ba: PySide2.QtCore.QByteArray, from_: int = ...) -> int: ...
    @typing.overload
    def indexIn(self, str: str, len: int, from_: int = ...) -> int: ...
    def pattern(self) -> PySide2.QtCore.QByteArray: ...
    def setPattern(self, pattern: PySide2.QtCore.QByteArray): ...


class QCborArray(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QCborArray): ...
    def __add__(self, v: PySide2.QtCore.QCborValue) -> PySide2.QtCore.QCborArray: ...
    def __copy__(self): ...
    def __iadd__(self, v: PySide2.QtCore.QCborValue) -> PySide2.QtCore.QCborArray: ...
    def __lshift__(self, v: PySide2.QtCore.QCborValue) -> PySide2.QtCore.QCborArray: ...
    def append(self, value: PySide2.QtCore.QCborValue): ...
    def at(self, i: int) -> PySide2.QtCore.QCborValue: ...
    def clear(self): ...
    def compare(self, other: PySide2.QtCore.QCborArray) -> int: ...
    def contains(self, value: PySide2.QtCore.QCborValue) -> bool: ...
    def empty(self) -> bool: ...
    def first(self) -> PySide2.QtCore.QCborValue: ...
    @staticmethod
    def fromJsonArray(array: PySide2.QtCore.QJsonArray) -> PySide2.QtCore.QCborArray: ...
    @staticmethod
    def fromStringList(list: typing.List[str]) -> PySide2.QtCore.QCborArray: ...
    @staticmethod
    def fromVariantList(list: typing.List[typing.Any]) -> PySide2.QtCore.QCborArray: ...
    def insert(self, i: int, value: PySide2.QtCore.QCborValue): ...
    def isEmpty(self) -> bool: ...
    def last(self) -> PySide2.QtCore.QCborValue: ...
    def pop_back(self): ...
    def pop_front(self): ...
    def prepend(self, value: PySide2.QtCore.QCborValue): ...
    def push_back(self, t: PySide2.QtCore.QCborValue): ...
    def push_front(self, t: PySide2.QtCore.QCborValue): ...
    def removeAt(self, i: int): ...
    def removeFirst(self): ...
    def removeLast(self): ...
    def size(self) -> int: ...
    def swap(self, other: PySide2.QtCore.QCborArray): ...
    def takeAt(self, i: int) -> PySide2.QtCore.QCborValue: ...
    def takeFirst(self) -> PySide2.QtCore.QCborValue: ...
    def takeLast(self) -> PySide2.QtCore.QCborValue: ...
    def toCborValue(self) -> PySide2.QtCore.QCborValue: ...
    def toJsonArray(self) -> PySide2.QtCore.QJsonArray: ...
    def toVariantList(self) -> typing.List[typing.Any]: ...


class QCborError(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QCborError: PySide2.QtCore.QCborError): ...
    def __copy__(self): ...
    def toString(self) -> str: ...


class QCborMap(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QCborMap): ...
    def __copy__(self): ...
    def clear(self): ...
    def compare(self, other: PySide2.QtCore.QCborMap) -> int: ...
    @typing.overload
    def contains(self, key: PySide2.QtCore.QCborValue) -> bool: ...
    @typing.overload
    def contains(self, key: str) -> bool: ...
    @typing.overload
    def contains(self, key: int) -> bool: ...
    def empty(self) -> bool: ...
    @staticmethod
    def fromJsonObject(o: typing.Dict[str, PySide2.QtCore.QJsonValue]) -> PySide2.QtCore.QCborMap: ...
    @staticmethod
    def fromVariantHash(hash: typing.Dict) -> PySide2.QtCore.QCborMap: ...
    @staticmethod
    def fromVariantMap(map: typing.Dict) -> PySide2.QtCore.QCborMap: ...
    def isEmpty(self) -> bool: ...
    def keys(self) -> typing.List[PySide2.QtCore.QCborValue]: ...
    @typing.overload
    def remove(self, key: PySide2.QtCore.QCborValue): ...
    @typing.overload
    def remove(self, key: str): ...
    @typing.overload
    def remove(self, key: int): ...
    def size(self) -> int: ...
    def swap(self, other: PySide2.QtCore.QCborMap): ...
    @typing.overload
    def take(self, key: PySide2.QtCore.QCborValue) -> PySide2.QtCore.QCborValue: ...
    @typing.overload
    def take(self, key: str) -> PySide2.QtCore.QCborValue: ...
    @typing.overload
    def take(self, key: int) -> PySide2.QtCore.QCborValue: ...
    def toCborValue(self) -> PySide2.QtCore.QCborValue: ...
    def toJsonObject(self) -> typing.Dict[str, PySide2.QtCore.QJsonValue]: ...
    def toVariantHash(self) -> typing.Dict: ...
    def toVariantMap(self) -> typing.Dict: ...
    @typing.overload
    def value(self, key: PySide2.QtCore.QCborValue) -> PySide2.QtCore.QCborValue: ...
    @typing.overload
    def value(self, key: str) -> PySide2.QtCore.QCborValue: ...
    @typing.overload
    def value(self, key: int) -> PySide2.QtCore.QCborValue: ...


class QCborParserError(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QCborParserError: PySide2.QtCore.QCborParserError): ...
    def __copy__(self): ...
    def errorString(self) -> str: ...


class QCborStreamReader(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, data: PySide2.QtCore.QByteArray): ...
    @typing.overload
    def __init__(self, data: int, len: int): ...
    @typing.overload
    def __init__(self, data: str, len: int): ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice): ...
    @typing.overload
    def addData(self, data: PySide2.QtCore.QByteArray): ...
    @typing.overload
    def addData(self, data: int, len: int): ...
    @typing.overload
    def addData(self, data: str, len: int): ...
    def clear(self): ...
    def containerDepth(self) -> int: ...
    def currentOffset(self) -> int: ...
    def currentStringChunkSize(self) -> int: ...
    def device(self) -> PySide2.QtCore.QIODevice: ...
    def enterContainer(self) -> bool: ...
    def hasNext(self) -> bool: ...
    def isArray(self) -> bool: ...
    def isBool(self) -> bool: ...
    def isByteArray(self) -> bool: ...
    def isContainer(self) -> bool: ...
    def isDouble(self) -> bool: ...
    def isFalse(self) -> bool: ...
    def isFloat(self) -> bool: ...
    def isFloat16(self) -> bool: ...
    def isInteger(self) -> bool: ...
    def isInvalid(self) -> bool: ...
    def isLengthKnown(self) -> bool: ...
    def isMap(self) -> bool: ...
    def isNegativeInteger(self) -> bool: ...
    def isNull(self) -> bool: ...
    @typing.overload
    def isSimpleType(self) -> bool: ...
    @typing.overload
    def isSimpleType(self, st: PySide2.QtCore.QCborSimpleType) -> bool: ...
    def isString(self) -> bool: ...
    def isTag(self) -> bool: ...
    def isTrue(self) -> bool: ...
    def isUndefined(self) -> bool: ...
    def isUnsignedInteger(self) -> bool: ...
    def isValid(self) -> bool: ...
    def lastError(self) -> PySide2.QtCore.QCborError: ...
    def leaveContainer(self) -> bool: ...
    def length(self) -> int: ...
    def next(self, maxRecursion: int = ...) -> bool: ...
    def parentContainerType(self) -> PySide2.QtCore.QCborStreamReader.Type: ...
    def readByteArray(self) -> typing.AnyStr: ...
    def readString(self) -> typing.AnyStr: ...
    def reparse(self): ...
    def reset(self): ...
    def setDevice(self, device: PySide2.QtCore.QIODevice): ...
    def toBool(self) -> bool: ...
    def toDouble(self) -> float: ...
    def toFloat(self) -> float: ...
    def toInteger(self) -> int: ...
    def toSimpleType(self) -> PySide2.QtCore.QCborSimpleType: ...
    def toUnsignedInteger(self) -> int: ...
    def type(self) -> PySide2.QtCore.QCborStreamReader.Type: ...


class QCborStreamWriter(Shiboken.Object):

    @typing.overload
    def __init__(self, data: PySide2.QtCore.QByteArray): ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice): ...
    @typing.overload
    def append(self, b: bool): ...
    @typing.overload
    def append(self, ba: PySide2.QtCore.QByteArray): ...
    @typing.overload
    def append(self, d: float): ...
    @typing.overload
    def append(self, f: float): ...
    @typing.overload
    def append(self, i: int): ...
    @typing.overload
    def append(self, i: int): ...
    @typing.overload
    def append(self, st: PySide2.QtCore.QCborSimpleType): ...
    @typing.overload
    def append(self, str: str, size: int = ...): ...
    @typing.overload
    def append(self, tag: PySide2.QtCore.QCborKnownTags): ...
    @typing.overload
    def append(self, u: int): ...
    @typing.overload
    def append(self, u: int): ...
    def appendByteString(self, data: str, len: int): ...
    def appendNull(self): ...
    def appendTextString(self, utf8: str, len: int): ...
    def appendUndefined(self): ...
    def device(self) -> PySide2.QtCore.QIODevice: ...
    def endArray(self) -> bool: ...
    def endMap(self) -> bool: ...
    def setDevice(self, device: PySide2.QtCore.QIODevice): ...
    @typing.overload
    def startArray(self): ...
    @typing.overload
    def startArray(self, count: int): ...
    @typing.overload
    def startMap(self): ...
    @typing.overload
    def startMap(self, count: int): ...


class QCborStringResultByteArray(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QCborStringResultByteArray: PySide2.QtCore.QCborStringResultByteArray): ...
    def __copy__(self): ...


class QCborStringResultString(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QCborStringResultString: PySide2.QtCore.QCborStringResultString): ...
    def __copy__(self): ...


class QCborValue(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, a: PySide2.QtCore.QCborArray): ...
    @typing.overload
    def __init__(self, b_: bool): ...
    @typing.overload
    def __init__(self, ba: PySide2.QtCore.QByteArray): ...
    @typing.overload
    def __init__(self, dt: PySide2.QtCore.QDateTime): ...
    @typing.overload
    def __init__(self, i: int): ...
    @typing.overload
    def __init__(self, i: int): ...
    @typing.overload
    def __init__(self, m: PySide2.QtCore.QCborMap): ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QCborValue): ...
    @typing.overload
    def __init__(self, rx: PySide2.QtCore.QRegularExpression): ...
    @typing.overload
    def __init__(self, s: str): ...
    @typing.overload
    def __init__(self, s: str): ...
    @typing.overload
    def __init__(self, st: PySide2.QtCore.QCborSimpleType): ...
    @typing.overload
    def __init__(self, t_: PySide2.QtCore.QCborKnownTags, tv: PySide2.QtCore.QCborValue = ...): ...
    @typing.overload
    def __init__(self, t_: PySide2.QtCore.QCborValue.Type): ...
    @typing.overload
    def __init__(self, u: int): ...
    @typing.overload
    def __init__(self, url: PySide2.QtCore.QUrl): ...
    @typing.overload
    def __init__(self, uuid: PySide2.QtCore.QUuid): ...
    @typing.overload
    def __init__(self, v: float): ...
    def __copy__(self): ...
    def compare(self, other: PySide2.QtCore.QCborValue) -> int: ...
    @typing.overload
    @staticmethod
    def fromCbor(ba: PySide2.QtCore.QByteArray, error: PySide2.QtCore.QCborParserError = ...) -> PySide2.QtCore.QCborValue: ...
    @typing.overload
    @staticmethod
    def fromCbor(data: int, len: int, error: PySide2.QtCore.QCborParserError = ...) -> PySide2.QtCore.QCborValue: ...
    @typing.overload
    @staticmethod
    def fromCbor(data: str, len: int, error: PySide2.QtCore.QCborParserError = ...) -> PySide2.QtCore.QCborValue: ...
    @typing.overload
    @staticmethod
    def fromCbor(reader: PySide2.QtCore.QCborStreamReader) -> PySide2.QtCore.QCborValue: ...
    @staticmethod
    def fromJsonValue(v: PySide2.QtCore.QJsonValue) -> PySide2.QtCore.QCborValue: ...
    @staticmethod
    def fromVariant(variant: typing.Any) -> PySide2.QtCore.QCborValue: ...
    def isArray(self) -> bool: ...
    def isBool(self) -> bool: ...
    def isByteArray(self) -> bool: ...
    def isContainer(self) -> bool: ...
    def isDateTime(self) -> bool: ...
    def isDouble(self) -> bool: ...
    def isFalse(self) -> bool: ...
    def isInteger(self) -> bool: ...
    def isInvalid(self) -> bool: ...
    def isMap(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isRegularExpression(self) -> bool: ...
    @typing.overload
    def isSimpleType(self) -> bool: ...
    @typing.overload
    def isSimpleType(self, st: PySide2.QtCore.QCborSimpleType) -> bool: ...
    def isString(self) -> bool: ...
    def isTag(self) -> bool: ...
    def isTrue(self) -> bool: ...
    def isUndefined(self) -> bool: ...
    def isUrl(self) -> bool: ...
    def isUuid(self) -> bool: ...
    def swap(self, other: PySide2.QtCore.QCborValue): ...
    def taggedValue(self, defaultValue: PySide2.QtCore.QCborValue = ...) -> PySide2.QtCore.QCborValue: ...
    @typing.overload
    def toArray(self) -> PySide2.QtCore.QCborArray: ...
    @typing.overload
    def toArray(self, defaultValue: PySide2.QtCore.QCborArray) -> PySide2.QtCore.QCborArray: ...
    def toBool(self, defaultValue: bool = ...) -> bool: ...
    def toByteArray(self, defaultValue: PySide2.QtCore.QByteArray = ...) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def toCbor(self, opt: PySide2.QtCore.QCborValue.EncodingOptions = ...) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def toCbor(self, writer: PySide2.QtCore.QCborStreamWriter, opt: PySide2.QtCore.QCborValue.EncodingOptions = ...): ...
    def toDateTime(self, defaultValue: PySide2.QtCore.QDateTime = ...) -> PySide2.QtCore.QDateTime: ...
    def toDiagnosticNotation(self, opts: PySide2.QtCore.QCborValue.DiagnosticNotationOptions = ...) -> str: ...
    def toDouble(self, defaultValue: float = ...) -> float: ...
    def toInteger(self, defaultValue: int = ...) -> int: ...
    def toJsonValue(self) -> PySide2.QtCore.QJsonValue: ...
    @typing.overload
    def toMap(self) -> PySide2.QtCore.QCborMap: ...
    @typing.overload
    def toMap(self, defaultValue: PySide2.QtCore.QCborMap) -> PySide2.QtCore.QCborMap: ...
    def toRegularExpression(self, defaultValue: PySide2.QtCore.QRegularExpression = ...) -> PySide2.QtCore.QRegularExpression: ...
    def toSimpleType(self, defaultValue: PySide2.QtCore.QCborSimpleType = ...) -> PySide2.QtCore.QCborSimpleType: ...
    def toString(self, defaultValue: str = ...) -> str: ...
    def toUrl(self, defaultValue: PySide2.QtCore.QUrl = ...) -> PySide2.QtCore.QUrl: ...
    def toUuid(self, defaultValue: PySide2.QtCore.QUuid = ...) -> PySide2.QtCore.QUuid: ...
    def toVariant(self) -> typing.Any: ...
    def type(self) -> PySide2.QtCore.QCborValue.Type: ...


class QChildEvent(PySide2.QtCore.QEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type, child: PySide2.QtCore.QObject): ...
    def added(self) -> bool: ...
    def child(self) -> PySide2.QtCore.QObject: ...
    def polished(self) -> bool: ...
    def removed(self) -> bool: ...


class QCollator(Shiboken.Object):

    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QCollator): ...
    @typing.overload
    def __init__(self, locale: PySide2.QtCore.QLocale = ...): ...
    def __call__(self, s1: str, s2: str) -> bool: ...
    def caseSensitivity(self) -> PySide2.QtCore.Qt.CaseSensitivity: ...
    @typing.overload
    def compare(self, s1: typing.Char, len1: int, s2: typing.Char, len2: int) -> int: ...
    @typing.overload
    def compare(self, s1: str, s2: str) -> int: ...
    @typing.overload
    def compare(self, s1: str, s2: str) -> int: ...
    def ignorePunctuation(self) -> bool: ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    def numericMode(self) -> bool: ...
    def setCaseSensitivity(self, cs: PySide2.QtCore.Qt.CaseSensitivity): ...
    def setIgnorePunctuation(self, on: bool): ...
    def setLocale(self, locale: PySide2.QtCore.QLocale): ...
    def setNumericMode(self, on: bool): ...
    def sortKey(self, string: str) -> PySide2.QtCore.QCollatorSortKey: ...
    def swap(self, other: PySide2.QtCore.QCollator): ...


class QCollatorSortKey(Shiboken.Object):

    def __init__(self, other: PySide2.QtCore.QCollatorSortKey): ...
    def compare(self, key: PySide2.QtCore.QCollatorSortKey) -> int: ...
    def swap(self, other: PySide2.QtCore.QCollatorSortKey): ...


class QCommandLineOption(Shiboken.Object):

    @typing.overload
    def __init__(self, name: str): ...
    @typing.overload
    def __init__(self, name: str, description: str, valueName: str = ..., defaultValue: str = ...): ...
    @typing.overload
    def __init__(self, names: typing.List[str]): ...
    @typing.overload
    def __init__(self, names: typing.List[str], description: str, valueName: str = ..., defaultValue: str = ...): ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QCommandLineOption): ...
    def defaultValues(self) -> typing.List[str]: ...
    def description(self) -> str: ...
    def flags(self) -> PySide2.QtCore.QCommandLineOption.Flags: ...
    def isHidden(self) -> bool: ...
    def names(self) -> typing.List[str]: ...
    def setDefaultValue(self, defaultValue: str): ...
    def setDefaultValues(self, defaultValues: typing.List[str]): ...
    def setDescription(self, description: str): ...
    def setFlags(self, aflags: PySide2.QtCore.QCommandLineOption.Flags): ...
    def setHidden(self, hidden: bool): ...
    def setValueName(self, name: str): ...
    def swap(self, other: PySide2.QtCore.QCommandLineOption): ...
    def valueName(self) -> str: ...


class QCommandLineParser(Shiboken.Object):

    def __init__(self): ...
    def addHelpOption(self) -> PySide2.QtCore.QCommandLineOption: ...
    def addOption(self, commandLineOption: PySide2.QtCore.QCommandLineOption) -> bool: ...
    def addOptions(self, options: typing.List[PySide2.QtCore.QCommandLineOption]) -> bool: ...
    def addPositionalArgument(self, name: str, description: str, syntax: str = ...): ...
    def addVersionOption(self) -> PySide2.QtCore.QCommandLineOption: ...
    def applicationDescription(self) -> str: ...
    def clearPositionalArguments(self): ...
    def errorText(self) -> str: ...
    def helpText(self) -> str: ...
    @typing.overload
    def isSet(self, name: str) -> bool: ...
    @typing.overload
    def isSet(self, option: PySide2.QtCore.QCommandLineOption) -> bool: ...
    def optionNames(self) -> typing.List[str]: ...
    def parse(self, arguments: typing.List[str]) -> bool: ...
    def positionalArguments(self) -> typing.List[str]: ...
    @typing.overload
    def process(self, app: PySide2.QtCore.QCoreApplication): ...
    @typing.overload
    def process(self, arguments: typing.List[str]): ...
    def setApplicationDescription(self, description: str): ...
    def setOptionsAfterPositionalArgumentsMode(self, mode: PySide2.QtCore.QCommandLineParser.OptionsAfterPositionalArgumentsMode): ...
    def setSingleDashWordOptionMode(self, parsingMode: PySide2.QtCore.QCommandLineParser.SingleDashWordOptionMode): ...
    def showHelp(self, exitCode: int = ...): ...
    def showVersion(self): ...
    def unknownOptionNames(self) -> typing.List[str]: ...
    @typing.overload
    def value(self, name: str) -> str: ...
    @typing.overload
    def value(self, option: PySide2.QtCore.QCommandLineOption) -> str: ...
    @typing.overload
    def values(self, name: str) -> typing.List[str]: ...
    @typing.overload
    def values(self, option: PySide2.QtCore.QCommandLineOption) -> typing.List[str]: ...


class QCoreApplication(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arg__1: typing.List[str]): ...
    @staticmethod
    def addLibraryPath(arg__1: str): ...
    @staticmethod
    def applicationDirPath() -> str: ...
    @staticmethod
    def applicationFilePath() -> str: ...
    @staticmethod
    def applicationName() -> str: ...
    @staticmethod
    def applicationPid() -> int: ...
    @staticmethod
    def applicationVersion() -> str: ...
    @staticmethod
    def arguments() -> typing.List[str]: ...
    @staticmethod
    def closingDown() -> bool: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    @staticmethod
    def eventDispatcher() -> PySide2.QtCore.QAbstractEventDispatcher: ...
    @staticmethod
    def exec_() -> int: ...
    @staticmethod
    def exit(retcode: int = ...): ...
    @staticmethod
    def flush(): ...
    @staticmethod
    def hasPendingEvents() -> bool: ...
    def installNativeEventFilter(self, filterObj: PySide2.QtCore.QAbstractNativeEventFilter): ...
    @staticmethod
    def installTranslator(messageFile: PySide2.QtCore.QTranslator) -> bool: ...
    @staticmethod
    def instance() -> PySide2.QtCore.QCoreApplication: ...
    @staticmethod
    def isQuitLockEnabled() -> bool: ...
    @staticmethod
    def isSetuidAllowed() -> bool: ...
    @staticmethod
    def libraryPaths() -> typing.List[str]: ...
    def notify(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    @staticmethod
    def organizationDomain() -> str: ...
    @staticmethod
    def organizationName() -> str: ...
    @staticmethod
    def postEvent(receiver: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent, priority: int = ...): ...
    @typing.overload
    @staticmethod
    def processEvents(flags: PySide2.QtCore.QEventLoop.ProcessEventsFlags, maxtime: int): ...
    @typing.overload
    @staticmethod
    def processEvents(flags: PySide2.QtCore.QEventLoop.ProcessEventsFlags = ...): ...
    @staticmethod
    def quit(): ...
    @staticmethod
    def removeLibraryPath(arg__1: str): ...
    def removeNativeEventFilter(self, filterObj: PySide2.QtCore.QAbstractNativeEventFilter): ...
    @staticmethod
    def removePostedEvents(receiver: PySide2.QtCore.QObject, eventType: int = ...): ...
    @staticmethod
    def removeTranslator(messageFile: PySide2.QtCore.QTranslator) -> bool: ...
    @staticmethod
    def sendEvent(receiver: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    @staticmethod
    def sendPostedEvents(receiver: PySide2.QtCore.QObject = ..., event_type: int = ...): ...
    @staticmethod
    def setApplicationName(application: str): ...
    @staticmethod
    def setApplicationVersion(version: str): ...
    @staticmethod
    def setAttribute(attribute: PySide2.QtCore.Qt.ApplicationAttribute, on: bool = ...): ...
    @staticmethod
    def setEventDispatcher(eventDispatcher: PySide2.QtCore.QAbstractEventDispatcher): ...
    @staticmethod
    def setLibraryPaths(arg__1: typing.List[str]): ...
    @staticmethod
    def setOrganizationDomain(orgDomain: str): ...
    @staticmethod
    def setOrganizationName(orgName: str): ...
    @staticmethod
    def setQuitLockEnabled(enabled: bool): ...
    @staticmethod
    def setSetuidAllowed(allow: bool): ...
    @staticmethod
    def startingUp() -> bool: ...
    @staticmethod
    def testAttribute(attribute: PySide2.QtCore.Qt.ApplicationAttribute) -> bool: ...
    @staticmethod
    def translate(context: str, key: str, disambiguation: str = ..., n: int = ...) -> str: ...


class QCryptographicHash(Shiboken.Object):

    def __init__(self, method: PySide2.QtCore.QCryptographicHash.Algorithm): ...
    @typing.overload
    def addData(self, data: PySide2.QtCore.QByteArray): ...
    @typing.overload
    def addData(self, data: str, length: int): ...
    @typing.overload
    def addData(self, device: PySide2.QtCore.QIODevice) -> bool: ...
    @staticmethod
    def hash(data: PySide2.QtCore.QByteArray, method: PySide2.QtCore.QCryptographicHash.Algorithm) -> PySide2.QtCore.QByteArray: ...
    @staticmethod
    def hashLength(method: PySide2.QtCore.QCryptographicHash.Algorithm) -> int: ...
    def reset(self): ...
    def result(self) -> PySide2.QtCore.QByteArray: ...


class QDataStream(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QByteArray): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QByteArray, flags: PySide2.QtCore.QIODevice.OpenMode): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QIODevice): ...
    @typing.overload
    def __lshift__(self, arg__1: str): ...
    @typing.overload
    def __lshift__(self, arg__2: PySide2.QtCore.QBitArray) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide2.QtCore.QDate) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide2.QtCore.QDateTime) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide2.QtCore.QEasingCurve) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide2.QtCore.QLine) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide2.QtCore.QLineF) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide2.QtCore.QLocale) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide2.QtCore.QMargins) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide2.QtCore.QMarginsF) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide2.QtCore.QPoint) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide2.QtCore.QPointF) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide2.QtCore.QRect) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide2.QtCore.QRectF) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide2.QtCore.QSize) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide2.QtCore.QSizeF) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide2.QtCore.QTime) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide2.QtCore.QUrl) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide2.QtCore.QUuid) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, re: PySide2.QtCore.QRegularExpression) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, regExp: PySide2.QtCore.QRegExp) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, tz: PySide2.QtCore.QTimeZone) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, version: PySide2.QtCore.QVersionNumber) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide2.QtCore.QBitArray) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide2.QtCore.QDate) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide2.QtCore.QDateTime) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide2.QtCore.QEasingCurve) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide2.QtCore.QLine) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide2.QtCore.QLineF) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide2.QtCore.QLocale) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide2.QtCore.QMargins) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide2.QtCore.QMarginsF) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide2.QtCore.QPoint) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide2.QtCore.QPointF) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide2.QtCore.QRect) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide2.QtCore.QRectF) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide2.QtCore.QSize) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide2.QtCore.QSizeF) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide2.QtCore.QTime) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide2.QtCore.QUrl) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide2.QtCore.QUuid) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, re: PySide2.QtCore.QRegularExpression) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, regExp: PySide2.QtCore.QRegExp) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, tz: PySide2.QtCore.QTimeZone) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, version: PySide2.QtCore.QVersionNumber) -> PySide2.QtCore.QDataStream: ...
    def abortTransaction(self): ...
    def atEnd(self) -> bool: ...
    def byteOrder(self) -> PySide2.QtCore.QDataStream.ByteOrder: ...
    def commitTransaction(self) -> bool: ...
    def device(self) -> PySide2.QtCore.QIODevice: ...
    def floatingPointPrecision(self) -> PySide2.QtCore.QDataStream.FloatingPointPrecision: ...
    def readBool(self) -> bool: ...
    def readDouble(self) -> float: ...
    def readFloat(self) -> float: ...
    def readInt16(self) -> int: ...
    def readInt32(self) -> int: ...
    def readInt64(self) -> int: ...
    def readInt8(self) -> int: ...
    def readQChar(self) -> typing.Char: ...
    def readQString(self) -> str: ...
    def readQStringList(self) -> typing.List[str]: ...
    def readQVariant(self) -> typing.Any: ...
    def readRawData(self, arg__1: str, len: int) -> int: ...
    def readString(self) -> str: ...
    def readUInt16(self) -> int: ...
    def readUInt32(self) -> int: ...
    def readUInt64(self) -> int: ...
    def readUInt8(self) -> int: ...
    def resetStatus(self): ...
    def rollbackTransaction(self): ...
    def setByteOrder(self, arg__1: PySide2.QtCore.QDataStream.ByteOrder): ...
    def setDevice(self, arg__1: PySide2.QtCore.QIODevice): ...
    def setFloatingPointPrecision(self, precision: PySide2.QtCore.QDataStream.FloatingPointPrecision): ...
    def setStatus(self, status: PySide2.QtCore.QDataStream.Status): ...
    def setVersion(self, arg__1: int): ...
    def skipRawData(self, len: int) -> int: ...
    def startTransaction(self): ...
    def status(self) -> PySide2.QtCore.QDataStream.Status: ...
    def unsetDevice(self): ...
    def version(self) -> int: ...
    def writeBool(self, arg__1: bool): ...
    def writeDouble(self, arg__1: float): ...
    def writeFloat(self, arg__1: float): ...
    def writeInt16(self, arg__1: int): ...
    def writeInt32(self, arg__1: int): ...
    def writeInt64(self, arg__1: int): ...
    def writeInt8(self, arg__1: typing.Char): ...
    def writeQChar(self, arg__1: typing.Char): ...
    def writeQString(self, arg__1: str): ...
    def writeQStringList(self, arg__1: typing.List[str]): ...
    def writeQVariant(self, arg__1: typing.Any): ...
    def writeRawData(self, arg__1: str, len: int) -> int: ...
    def writeString(self, arg__1: str): ...
    def writeUInt16(self, arg__1: int): ...
    def writeUInt32(self, arg__1: int): ...
    def writeUInt64(self, arg__1: int): ...
    def writeUInt8(self, arg__1: typing.Char): ...


class QDate(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QDate: PySide2.QtCore.QDate): ...
    @typing.overload
    def __init__(self, y: int, m: int, d: int): ...
    def __copy__(self): ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def addDays(self, days: int) -> PySide2.QtCore.QDate: ...
    def addMonths(self, months: int) -> PySide2.QtCore.QDate: ...
    def addYears(self, years: int) -> PySide2.QtCore.QDate: ...
    @staticmethod
    def currentDate() -> PySide2.QtCore.QDate: ...
    def day(self) -> int: ...
    def dayOfWeek(self) -> int: ...
    def dayOfYear(self) -> int: ...
    def daysInMonth(self) -> int: ...
    def daysInYear(self) -> int: ...
    def daysTo(self, arg__1: PySide2.QtCore.QDate) -> int: ...
    @staticmethod
    def fromJulianDay(jd_: int) -> PySide2.QtCore.QDate: ...
    @typing.overload
    @staticmethod
    def fromString(s: str, f: PySide2.QtCore.Qt.DateFormat = ...) -> PySide2.QtCore.QDate: ...
    @typing.overload
    @staticmethod
    def fromString(s: str, format: str) -> PySide2.QtCore.QDate: ...
    def getDate(self, year: int, month: int, day: int): ...
    @staticmethod
    def isLeapYear(year: int) -> bool: ...
    def isNull(self) -> bool: ...
    @typing.overload
    @staticmethod
    def isValid() -> bool: ...
    @typing.overload
    @staticmethod
    def isValid(y: int, m: int, d: int) -> bool: ...
    @staticmethod
    def longDayName(weekday: int, type: PySide2.QtCore.QDate.MonthNameType = ...) -> str: ...
    @staticmethod
    def longMonthName(month: int, type: PySide2.QtCore.QDate.MonthNameType = ...) -> str: ...
    def month(self) -> int: ...
    def setDate(self, year: int, month: int, day: int) -> bool: ...
    @staticmethod
    def shortDayName(weekday: int, type: PySide2.QtCore.QDate.MonthNameType = ...) -> str: ...
    @staticmethod
    def shortMonthName(month: int, type: PySide2.QtCore.QDate.MonthNameType = ...) -> str: ...
    def toJulianDay(self) -> int: ...
    def toPython(self) -> object: ...
    @typing.overload
    def toString(self, f: PySide2.QtCore.Qt.DateFormat = ...) -> str: ...
    @typing.overload
    def toString(self, format: str) -> str: ...
    def weekNumber(self, yearNum: int = ...) -> int: ...
    def year(self) -> int: ...


class QDateTime(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QDate): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QDate, arg__2: PySide2.QtCore.QTime, spec: PySide2.QtCore.Qt.TimeSpec = ...): ...
    @typing.overload
    def __init__(self, arg__1: int, arg__2: int, arg__3: int, arg__4: int, arg__5: int, arg__6: int): ...
    @typing.overload
    def __init__(self, arg__1: int, arg__2: int, arg__3: int, arg__4: int, arg__5: int, arg__6: int, arg__7: int, arg__8: int = ...): ...
    @typing.overload
    def __init__(self, date: PySide2.QtCore.QDate, time: PySide2.QtCore.QTime, spec: PySide2.QtCore.Qt.TimeSpec, offsetSeconds: int): ...
    @typing.overload
    def __init__(self, date: PySide2.QtCore.QDate, time: PySide2.QtCore.QTime, timeZone: PySide2.QtCore.QTimeZone): ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QDateTime): ...
    def __copy__(self): ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def addDays(self, days: int) -> PySide2.QtCore.QDateTime: ...
    def addMSecs(self, msecs: int) -> PySide2.QtCore.QDateTime: ...
    def addMonths(self, months: int) -> PySide2.QtCore.QDateTime: ...
    def addSecs(self, secs: int) -> PySide2.QtCore.QDateTime: ...
    def addYears(self, years: int) -> PySide2.QtCore.QDateTime: ...
    @staticmethod
    def currentDateTime() -> PySide2.QtCore.QDateTime: ...
    @staticmethod
    def currentDateTimeUtc() -> PySide2.QtCore.QDateTime: ...
    @staticmethod
    def currentMSecsSinceEpoch() -> int: ...
    @staticmethod
    def currentSecsSinceEpoch() -> int: ...
    def date(self) -> PySide2.QtCore.QDate: ...
    def daysTo(self, arg__1: PySide2.QtCore.QDateTime) -> int: ...
    @typing.overload
    @staticmethod
    def fromMSecsSinceEpoch(msecs: int) -> PySide2.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def fromMSecsSinceEpoch(msecs: int, spec: PySide2.QtCore.Qt.TimeSpec, offsetFromUtc: int = ...) -> PySide2.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def fromMSecsSinceEpoch(msecs: int, timeZone: PySide2.QtCore.QTimeZone) -> PySide2.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def fromSecsSinceEpoch(secs: int, spe: PySide2.QtCore.Qt.TimeSpec = ..., offsetFromUtc: int = ...) -> PySide2.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def fromSecsSinceEpoch(secs: int, timeZone: PySide2.QtCore.QTimeZone) -> PySide2.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def fromString(s: str, f: PySide2.QtCore.Qt.DateFormat = ...) -> PySide2.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def fromString(s: str, format: str) -> PySide2.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def fromTime_t(secsSince1Jan1970UTC: int) -> PySide2.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def fromTime_t(secsSince1Jan1970UTC: int, spec: PySide2.QtCore.Qt.TimeSpec, offsetFromUtc: int = ...) -> PySide2.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def fromTime_t(secsSince1Jan1970UTC: int, timeZone: PySide2.QtCore.QTimeZone) -> PySide2.QtCore.QDateTime: ...
    def isDaylightTime(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    def msecsTo(self, arg__1: PySide2.QtCore.QDateTime) -> int: ...
    def offsetFromUtc(self) -> int: ...
    def secsTo(self, arg__1: PySide2.QtCore.QDateTime) -> int: ...
    def setDate(self, date: PySide2.QtCore.QDate): ...
    def setMSecsSinceEpoch(self, msecs: int): ...
    def setOffsetFromUtc(self, offsetSeconds: int): ...
    def setSecsSinceEpoch(self, secs: int): ...
    def setTime(self, time: PySide2.QtCore.QTime): ...
    def setTimeSpec(self, spec: PySide2.QtCore.Qt.TimeSpec): ...
    def setTimeZone(self, toZone: PySide2.QtCore.QTimeZone): ...
    def setTime_t(self, secsSince1Jan1970UTC: int): ...
    def setUtcOffset(self, seconds: int): ...
    def swap(self, other: PySide2.QtCore.QDateTime): ...
    def time(self) -> PySide2.QtCore.QTime: ...
    def timeSpec(self) -> PySide2.QtCore.Qt.TimeSpec: ...
    def timeZone(self) -> PySide2.QtCore.QTimeZone: ...
    def timeZoneAbbreviation(self) -> str: ...
    def toLocalTime(self) -> PySide2.QtCore.QDateTime: ...
    def toMSecsSinceEpoch(self) -> int: ...
    def toOffsetFromUtc(self, offsetSeconds: int) -> PySide2.QtCore.QDateTime: ...
    def toPython(self) -> object: ...
    def toSecsSinceEpoch(self) -> int: ...
    @typing.overload
    def toString(self, f: PySide2.QtCore.Qt.DateFormat = ...) -> str: ...
    @typing.overload
    def toString(self, format: str) -> str: ...
    def toTimeSpec(self, spec: PySide2.QtCore.Qt.TimeSpec) -> PySide2.QtCore.QDateTime: ...
    def toTimeZone(self, toZone: PySide2.QtCore.QTimeZone) -> PySide2.QtCore.QDateTime: ...
    def toTime_t(self) -> int: ...
    def toUTC(self) -> PySide2.QtCore.QDateTime: ...
    def utcOffset(self) -> int: ...


class QDir(Shiboken.Object):

    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QDir): ...
    @typing.overload
    def __init__(self, path: str, nameFilter: str, sort: PySide2.QtCore.QDir.SortFlags = ..., filter: PySide2.QtCore.QDir.Filters = ...): ...
    @typing.overload
    def __init__(self, path: str = ...): ...
    def __copy__(self): ...
    def __reduce__(self) -> object: ...
    def absoluteFilePath(self, fileName: str) -> str: ...
    def absolutePath(self) -> str: ...
    @staticmethod
    def addResourceSearchPath(path: str): ...
    @staticmethod
    def addSearchPath(prefix: str, path: str): ...
    def canonicalPath(self) -> str: ...
    def cd(self, dirName: str) -> bool: ...
    def cdUp(self) -> bool: ...
    @staticmethod
    def cleanPath(path: str) -> str: ...
    def count(self) -> int: ...
    @staticmethod
    def current() -> PySide2.QtCore.QDir: ...
    @staticmethod
    def currentPath() -> str: ...
    def dirName(self) -> str: ...
    @staticmethod
    def drives() -> typing.List[PySide2.QtCore.QFileInfo]: ...
    @typing.overload
    def entryInfoList(self, filters: PySide2.QtCore.QDir.Filters = ..., sort: PySide2.QtCore.QDir.SortFlags = ...) -> typing.List[PySide2.QtCore.QFileInfo]: ...
    @typing.overload
    def entryInfoList(self, nameFilters: typing.List[str], filters: PySide2.QtCore.QDir.Filters = ..., sort: PySide2.QtCore.QDir.SortFlags = ...) -> typing.List[PySide2.QtCore.QFileInfo]: ...
    @typing.overload
    def entryList(self, filters: PySide2.QtCore.QDir.Filters = ..., sort: PySide2.QtCore.QDir.SortFlags = ...) -> typing.List[str]: ...
    @typing.overload
    def entryList(self, nameFilters: typing.List[str], filters: PySide2.QtCore.QDir.Filters = ..., sort: PySide2.QtCore.QDir.SortFlags = ...) -> typing.List[str]: ...
    @typing.overload
    def exists(self) -> bool: ...
    @typing.overload
    def exists(self, name: str) -> bool: ...
    def filePath(self, fileName: str) -> str: ...
    def filter(self) -> PySide2.QtCore.QDir.Filters: ...
    @staticmethod
    def fromNativeSeparators(pathName: str) -> str: ...
    @staticmethod
    def home() -> PySide2.QtCore.QDir: ...
    @staticmethod
    def homePath() -> str: ...
    def isAbsolute(self) -> bool: ...
    @staticmethod
    def isAbsolutePath(path: str) -> bool: ...
    def isEmpty(self, filters: PySide2.QtCore.QDir.Filters = ...) -> bool: ...
    def isReadable(self) -> bool: ...
    def isRelative(self) -> bool: ...
    @staticmethod
    def isRelativePath(path: str) -> bool: ...
    def isRoot(self) -> bool: ...
    @staticmethod
    def listSeparator() -> typing.Char: ...
    def makeAbsolute(self) -> bool: ...
    @typing.overload
    @staticmethod
    def match(filter: str, fileName: str) -> bool: ...
    @typing.overload
    @staticmethod
    def match(filters: typing.List[str], fileName: str) -> bool: ...
    def mkdir(self, dirName: str) -> bool: ...
    def mkpath(self, dirPath: str) -> bool: ...
    def nameFilters(self) -> typing.List[str]: ...
    @staticmethod
    def nameFiltersFromString(nameFilter: str) -> typing.List[str]: ...
    def path(self) -> str: ...
    def refresh(self): ...
    def relativeFilePath(self, fileName: str) -> str: ...
    def remove(self, fileName: str) -> bool: ...
    def removeRecursively(self) -> bool: ...
    def rename(self, oldName: str, newName: str) -> bool: ...
    def rmdir(self, dirName: str) -> bool: ...
    def rmpath(self, dirPath: str) -> bool: ...
    @staticmethod
    def root() -> PySide2.QtCore.QDir: ...
    @staticmethod
    def rootPath() -> str: ...
    @staticmethod
    def searchPaths(prefix: str) -> typing.List[str]: ...
    @staticmethod
    def separator() -> typing.Char: ...
    @staticmethod
    def setCurrent(path: str) -> bool: ...
    def setFilter(self, filter: PySide2.QtCore.QDir.Filters): ...
    def setNameFilters(self, nameFilters: typing.List[str]): ...
    def setPath(self, path: str): ...
    @staticmethod
    def setSearchPaths(prefix: str, searchPaths: typing.List[str]): ...
    def setSorting(self, sort: PySide2.QtCore.QDir.SortFlags): ...
    def sorting(self) -> PySide2.QtCore.QDir.SortFlags: ...
    def swap(self, other: PySide2.QtCore.QDir): ...
    @staticmethod
    def temp() -> PySide2.QtCore.QDir: ...
    @staticmethod
    def tempPath() -> str: ...
    @staticmethod
    def toNativeSeparators(pathName: str) -> str: ...


class QDirIterator(Shiboken.Object):

    @typing.overload
    def __init__(self, dir: PySide2.QtCore.QDir, flags: PySide2.QtCore.QDirIterator.IteratorFlags = ...): ...
    @typing.overload
    def __init__(self, path: str, filter: PySide2.QtCore.QDir.Filters, flags: PySide2.QtCore.QDirIterator.IteratorFlags = ...): ...
    @typing.overload
    def __init__(self, path: str, flags: PySide2.QtCore.QDirIterator.IteratorFlags = ...): ...
    @typing.overload
    def __init__(self, path: str, nameFilters: typing.List[str], filters: PySide2.QtCore.QDir.Filters = ..., flags: PySide2.QtCore.QDirIterator.IteratorFlags = ...): ...
    def fileInfo(self) -> PySide2.QtCore.QFileInfo: ...
    def fileName(self) -> str: ...
    def filePath(self) -> str: ...
    def hasNext(self) -> bool: ...
    def next(self) -> str: ...
    def path(self) -> str: ...


class QDynamicPropertyChangeEvent(PySide2.QtCore.QEvent):

    def __init__(self, name: PySide2.QtCore.QByteArray): ...
    def propertyName(self) -> PySide2.QtCore.QByteArray: ...


class QEasingCurve(Shiboken.Object):

    @typing.overload
    def __init__(self, other: PySide2.QtCore.QEasingCurve): ...
    @typing.overload
    def __init__(self, type: PySide2.QtCore.QEasingCurve.Type = ...): ...
    def __copy__(self): ...
    def addCubicBezierSegment(self, c1: PySide2.QtCore.QPointF, c2: PySide2.QtCore.QPointF, endPoint: PySide2.QtCore.QPointF): ...
    def addTCBSegment(self, nextPoint: PySide2.QtCore.QPointF, t: float, c: float, b: float): ...
    def amplitude(self) -> float: ...
    def customType(self) -> object: ...
    def overshoot(self) -> float: ...
    def period(self) -> float: ...
    def setAmplitude(self, amplitude: float): ...
    def setCustomType(self, arg__1: object): ...
    def setOvershoot(self, overshoot: float): ...
    def setPeriod(self, period: float): ...
    def setType(self, type: PySide2.QtCore.QEasingCurve.Type): ...
    def swap(self, other: PySide2.QtCore.QEasingCurve): ...
    def toCubicSpline(self) -> typing.List[PySide2.QtCore.QPointF]: ...
    def type(self) -> PySide2.QtCore.QEasingCurve.Type: ...
    def valueForProgress(self, progress: float) -> float: ...


class QElapsedTimer(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QElapsedTimer: PySide2.QtCore.QElapsedTimer): ...
    def __copy__(self): ...
    @staticmethod
    def clockType() -> PySide2.QtCore.QElapsedTimer.ClockType: ...
    def elapsed(self) -> int: ...
    def hasExpired(self, timeout: int) -> bool: ...
    def invalidate(self): ...
    @staticmethod
    def isMonotonic() -> bool: ...
    def isValid(self) -> bool: ...
    def msecsSinceReference(self) -> int: ...
    def msecsTo(self, other: PySide2.QtCore.QElapsedTimer) -> int: ...
    def nsecsElapsed(self) -> int: ...
    def restart(self) -> int: ...
    def secsTo(self, other: PySide2.QtCore.QElapsedTimer) -> int: ...
    def start(self): ...


class QEvent(Shiboken.Object):

    @typing.overload
    def __init__(self, other: PySide2.QtCore.QEvent): ...
    @typing.overload
    def __init__(self, type: PySide2.QtCore.QEvent.Type): ...
    def accept(self): ...
    def ignore(self): ...
    def isAccepted(self) -> bool: ...
    @staticmethod
    def registerEventType(hint: int = ...) -> int: ...
    def setAccepted(self, accepted: bool): ...
    def spontaneous(self) -> bool: ...
    def type(self) -> PySide2.QtCore.QEvent.Type: ...


class QEventLoop(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def exec_(self, flags: PySide2.QtCore.QEventLoop.ProcessEventsFlags = ...) -> int: ...
    def exit(self, returnCode: int = ...): ...
    def isRunning(self) -> bool: ...
    @typing.overload
    def processEvents(self, flags: PySide2.QtCore.QEventLoop.ProcessEventsFlags, maximumTime: int): ...
    @typing.overload
    def processEvents(self, flags: PySide2.QtCore.QEventLoop.ProcessEventsFlags = ...) -> bool: ...
    def quit(self): ...
    def wakeUp(self): ...


class QEventTransition(PySide2.QtCore.QAbstractTransition):

    @typing.overload
    def __init__(self, object: PySide2.QtCore.QObject, type: PySide2.QtCore.QEvent.Type, sourceState: PySide2.QtCore.QState = ...): ...
    @typing.overload
    def __init__(self, sourceState: PySide2.QtCore.QState = ...): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def eventSource(self) -> PySide2.QtCore.QObject: ...
    def eventTest(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def eventType(self) -> PySide2.QtCore.QEvent.Type: ...
    def onTransition(self, event: PySide2.QtCore.QEvent): ...
    def setEventSource(self, object: PySide2.QtCore.QObject): ...
    def setEventType(self, type: PySide2.QtCore.QEvent.Type): ...


class QFactoryInterface(Shiboken.Object):

    def __init__(self): ...
    def keys(self) -> typing.List[str]: ...


class QFile(PySide2.QtCore.QFileDevice):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, name: str): ...
    @typing.overload
    def __init__(self, name: str, parent: PySide2.QtCore.QObject): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject): ...
    @typing.overload
    @staticmethod
    def copy(fileName: str, newName: str) -> bool: ...
    @typing.overload
    @staticmethod
    def copy(newName: str) -> bool: ...
    @typing.overload
    @staticmethod
    def decodeName(localFileName: PySide2.QtCore.QByteArray) -> str: ...
    @typing.overload
    @staticmethod
    def decodeName(localFileName: str) -> str: ...
    @staticmethod
    def encodeName(fileName: str) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def exists() -> bool: ...
    @typing.overload
    @staticmethod
    def exists(fileName: str) -> bool: ...
    def fileName(self) -> str: ...
    @typing.overload
    @staticmethod
    def link(newName: str) -> bool: ...
    @typing.overload
    @staticmethod
    def link(oldname: str, newName: str) -> bool: ...
    @typing.overload
    def open(self, fd: int, ioFlags: PySide2.QtCore.QIODevice.OpenMode, handleFlags: PySide2.QtCore.QFileDevice.FileHandleFlags = ...) -> bool: ...
    @typing.overload
    def open(self, flags: PySide2.QtCore.QIODevice.OpenMode) -> bool: ...
    @typing.overload
    @staticmethod
    def permissions() -> PySide2.QtCore.QFileDevice.Permissions: ...
    @typing.overload
    @staticmethod
    def permissions(filename: str) -> PySide2.QtCore.QFileDevice.Permissions: ...
    @typing.overload
    @staticmethod
    def readLink() -> str: ...
    @typing.overload
    @staticmethod
    def readLink(fileName: str) -> str: ...
    @typing.overload
    @staticmethod
    def remove() -> bool: ...
    @typing.overload
    @staticmethod
    def remove(fileName: str) -> bool: ...
    @typing.overload
    @staticmethod
    def rename(newName: str) -> bool: ...
    @typing.overload
    @staticmethod
    def rename(oldName: str, newName: str) -> bool: ...
    @typing.overload
    @staticmethod
    def resize(filename: str, sz: int) -> bool: ...
    @typing.overload
    @staticmethod
    def resize(sz: int) -> bool: ...
    def setFileName(self, name: str): ...
    @typing.overload
    @staticmethod
    def setPermissions(filename: str, permissionSpec: PySide2.QtCore.QFileDevice.Permissions) -> bool: ...
    @typing.overload
    @staticmethod
    def setPermissions(permissionSpec: PySide2.QtCore.QFileDevice.Permissions) -> bool: ...
    def size(self) -> int: ...
    @typing.overload
    @staticmethod
    def symLinkTarget() -> str: ...
    @typing.overload
    @staticmethod
    def symLinkTarget(fileName: str) -> str: ...


class QFileDevice(PySide2.QtCore.QIODevice):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject): ...
    def atEnd(self) -> bool: ...
    def close(self): ...
    def error(self) -> PySide2.QtCore.QFileDevice.FileError: ...
    def fileName(self) -> str: ...
    def fileTime(self, time: PySide2.QtCore.QFileDevice.FileTime) -> PySide2.QtCore.QDateTime: ...
    def flush(self) -> bool: ...
    def handle(self) -> int: ...
    def isSequential(self) -> bool: ...
    def map(self, offset: int, size: int, flags: PySide2.QtCore.QFileDevice.MemoryMapFlags = ...) -> typing.Char: ...
    def permissions(self) -> PySide2.QtCore.QFileDevice.Permissions: ...
    def pos(self) -> int: ...
    def readData(self, data: str, maxlen: int) -> int: ...
    def readLineData(self, data: str, maxlen: int) -> int: ...
    def resize(self, sz: int) -> bool: ...
    def seek(self, offset: int) -> bool: ...
    def setFileTime(self, newDate: PySide2.QtCore.QDateTime, fileTime: PySide2.QtCore.QFileDevice.FileTime) -> bool: ...
    def setPermissions(self, permissionSpec: PySide2.QtCore.QFileDevice.Permissions) -> bool: ...
    def size(self) -> int: ...
    def unmap(self, address: typing.Char) -> bool: ...
    def unsetError(self): ...
    def writeData(self, data: str, len: int) -> int: ...


class QFileInfo(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, dir: PySide2.QtCore.QDir, file: str): ...
    @typing.overload
    def __init__(self, file: PySide2.QtCore.QFile): ...
    @typing.overload
    def __init__(self, file: str): ...
    @typing.overload
    def __init__(self, fileinfo: PySide2.QtCore.QFileInfo): ...
    def __copy__(self): ...
    def __reduce__(self) -> object: ...
    def absoluteDir(self) -> PySide2.QtCore.QDir: ...
    def absoluteFilePath(self) -> str: ...
    def absolutePath(self) -> str: ...
    def baseName(self) -> str: ...
    def birthTime(self) -> PySide2.QtCore.QDateTime: ...
    def bundleName(self) -> str: ...
    def caching(self) -> bool: ...
    def canonicalFilePath(self) -> str: ...
    def canonicalPath(self) -> str: ...
    def completeBaseName(self) -> str: ...
    def completeSuffix(self) -> str: ...
    def created(self) -> PySide2.QtCore.QDateTime: ...
    def dir(self) -> PySide2.QtCore.QDir: ...
    @typing.overload
    @staticmethod
    def exists() -> bool: ...
    @typing.overload
    @staticmethod
    def exists(file: str) -> bool: ...
    def fileName(self) -> str: ...
    def filePath(self) -> str: ...
    def group(self) -> str: ...
    def groupId(self) -> int: ...
    def isAbsolute(self) -> bool: ...
    def isBundle(self) -> bool: ...
    def isDir(self) -> bool: ...
    def isExecutable(self) -> bool: ...
    def isFile(self) -> bool: ...
    def isHidden(self) -> bool: ...
    def isNativePath(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isRelative(self) -> bool: ...
    def isRoot(self) -> bool: ...
    def isSymLink(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def lastModified(self) -> PySide2.QtCore.QDateTime: ...
    def lastRead(self) -> PySide2.QtCore.QDateTime: ...
    def makeAbsolute(self) -> bool: ...
    def metadataChangeTime(self) -> PySide2.QtCore.QDateTime: ...
    def owner(self) -> str: ...
    def ownerId(self) -> int: ...
    def path(self) -> str: ...
    def readLink(self) -> str: ...
    def refresh(self): ...
    def setCaching(self, on: bool): ...
    @typing.overload
    def setFile(self, dir: PySide2.QtCore.QDir, file: str): ...
    @typing.overload
    def setFile(self, file: PySide2.QtCore.QFile): ...
    @typing.overload
    def setFile(self, file: str): ...
    def size(self) -> int: ...
    def suffix(self) -> str: ...
    def swap(self, other: PySide2.QtCore.QFileInfo): ...
    def symLinkTarget(self) -> str: ...


class QFileSelector(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def allSelectors(self) -> typing.List[str]: ...
    def extraSelectors(self) -> typing.List[str]: ...
    @typing.overload
    def select(self, filePath: PySide2.QtCore.QUrl) -> PySide2.QtCore.QUrl: ...
    @typing.overload
    def select(self, filePath: str) -> str: ...
    def setExtraSelectors(self, list: typing.List[str]): ...


class QFileSystemWatcher(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, paths: typing.List[str], parent: PySide2.QtCore.QObject = ...): ...
    def addPath(self, file: str) -> bool: ...
    def addPaths(self, files: typing.List[str]) -> typing.List[str]: ...
    def directories(self) -> typing.List[str]: ...
    def files(self) -> typing.List[str]: ...
    def removePath(self, file: str) -> bool: ...
    def removePaths(self, files: typing.List[str]) -> typing.List[str]: ...


class QFinalState(PySide2.QtCore.QAbstractState):

    def __init__(self, parent: PySide2.QtCore.QState = ...): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def onEntry(self, event: PySide2.QtCore.QEvent): ...
    def onExit(self, event: PySide2.QtCore.QEvent): ...


class QGenericArgument(Shiboken.Object):

    @typing.overload
    def __init__(self, QGenericArgument: PySide2.QtCore.QGenericArgument): ...
    @typing.overload
    def __init__(self, aName: str = ..., aData: int = ...): ...
    def __copy__(self): ...
    def data(self) -> int: ...
    def name(self) -> str: ...


class QGenericReturnArgument(PySide2.QtCore.QGenericArgument):

    @typing.overload
    def __init__(self, QGenericReturnArgument: PySide2.QtCore.QGenericReturnArgument): ...
    @typing.overload
    def __init__(self, aName: str = ..., aData: int = ...): ...
    def __copy__(self): ...


class QHistoryState(PySide2.QtCore.QAbstractState):

    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QState = ...): ...
    @typing.overload
    def __init__(self, type: PySide2.QtCore.QHistoryState.HistoryType, parent: PySide2.QtCore.QState = ...): ...
    def defaultState(self) -> PySide2.QtCore.QAbstractState: ...
    def defaultTransition(self) -> PySide2.QtCore.QAbstractTransition: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def historyType(self) -> PySide2.QtCore.QHistoryState.HistoryType: ...
    def onEntry(self, event: PySide2.QtCore.QEvent): ...
    def onExit(self, event: PySide2.QtCore.QEvent): ...
    def setDefaultState(self, state: PySide2.QtCore.QAbstractState): ...
    def setDefaultTransition(self, transition: PySide2.QtCore.QAbstractTransition): ...
    def setHistoryType(self, type: PySide2.QtCore.QHistoryState.HistoryType): ...


class QIODevice(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject): ...
    def atEnd(self) -> bool: ...
    def bytesAvailable(self) -> int: ...
    def bytesToWrite(self) -> int: ...
    def canReadLine(self) -> bool: ...
    def close(self): ...
    def commitTransaction(self): ...
    def currentReadChannel(self) -> int: ...
    def currentWriteChannel(self) -> int: ...
    def errorString(self) -> str: ...
    def getChar(self, c: str) -> bool: ...
    def isOpen(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isSequential(self) -> bool: ...
    def isTextModeEnabled(self) -> bool: ...
    def isTransactionStarted(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def open(self, mode: PySide2.QtCore.QIODevice.OpenMode) -> bool: ...
    def openMode(self) -> PySide2.QtCore.QIODevice.OpenMode: ...
    def peek(self, maxlen: int) -> PySide2.QtCore.QByteArray: ...
    def pos(self) -> int: ...
    def putChar(self, c: typing.Char) -> bool: ...
    def read(self, maxlen: int) -> PySide2.QtCore.QByteArray: ...
    def readAll(self) -> PySide2.QtCore.QByteArray: ...
    def readChannelCount(self) -> int: ...
    def readData(self, data: str, maxlen: int) -> int: ...
    def readLine(self, maxlen: int = ...) -> PySide2.QtCore.QByteArray: ...
    def readLineData(self, data: str, maxlen: int) -> int: ...
    def reset(self) -> bool: ...
    def rollbackTransaction(self): ...
    def seek(self, pos: int) -> bool: ...
    def setCurrentReadChannel(self, channel: int): ...
    def setCurrentWriteChannel(self, channel: int): ...
    def setErrorString(self, errorString: str): ...
    def setOpenMode(self, openMode: PySide2.QtCore.QIODevice.OpenMode): ...
    def setTextModeEnabled(self, enabled: bool): ...
    def size(self) -> int: ...
    def skip(self, maxSize: int) -> int: ...
    def startTransaction(self): ...
    def ungetChar(self, c: typing.Char): ...
    def waitForBytesWritten(self, msecs: int) -> bool: ...
    def waitForReadyRead(self, msecs: int) -> bool: ...
    def write(self, data: PySide2.QtCore.QByteArray) -> int: ...
    def writeChannelCount(self) -> int: ...
    def writeData(self, data: str, len: int) -> int: ...


class QIdentityProxyModel(PySide2.QtCore.QAbstractProxyModel):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def columnCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def dropMimeData(self, data: PySide2.QtCore.QMimeData, action: PySide2.QtCore.Qt.DropAction, row: int, column: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def headerData(self, section: int, orientation: PySide2.QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def index(self, row: int, column: int, parent: PySide2.QtCore.QModelIndex = ...) -> PySide2.QtCore.QModelIndex: ...
    def insertColumns(self, column: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def insertRows(self, row: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def mapFromSource(self, sourceIndex: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def mapSelectionFromSource(self, selection: PySide2.QtCore.QItemSelection) -> PySide2.QtCore.QItemSelection: ...
    def mapSelectionToSource(self, selection: PySide2.QtCore.QItemSelection) -> PySide2.QtCore.QItemSelection: ...
    def mapToSource(self, proxyIndex: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def match(self, start: PySide2.QtCore.QModelIndex, role: int, value: typing.Any, hits: int = ..., flags: PySide2.QtCore.Qt.MatchFlags = ...) -> typing.List[int]: ...
    @typing.overload
    def parent(self) -> PySide2.QtCore.QObject: ...
    @typing.overload
    def parent(self, child: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def removeColumns(self, column: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def removeRows(self, row: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def rowCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def setSourceModel(self, sourceModel: PySide2.QtCore.QAbstractItemModel): ...
    def sibling(self, row: int, column: int, idx: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...


class QItemSelection(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QItemSelection: PySide2.QtCore.QItemSelection): ...
    @typing.overload
    def __init__(self, topLeft: PySide2.QtCore.QModelIndex, bottomRight: PySide2.QtCore.QModelIndex): ...
    def __add__(self, l: typing.List[PySide2.QtCore.QItemSelectionRange]) -> typing.List[PySide2.QtCore.QItemSelectionRange]: ...
    def __copy__(self): ...
    @typing.overload
    def __iadd__(self, l: typing.List[PySide2.QtCore.QItemSelectionRange]) -> typing.List[PySide2.QtCore.QItemSelectionRange]: ...
    @typing.overload
    def __iadd__(self, t: PySide2.QtCore.QItemSelectionRange) -> typing.List[PySide2.QtCore.QItemSelectionRange]: ...
    @typing.overload
    def __lshift__(self, l: typing.List[PySide2.QtCore.QItemSelectionRange]) -> typing.List[PySide2.QtCore.QItemSelectionRange]: ...
    @typing.overload
    def __lshift__(self, t: PySide2.QtCore.QItemSelectionRange) -> typing.List[PySide2.QtCore.QItemSelectionRange]: ...
    @typing.overload
    def append(self, t: PySide2.QtCore.QItemSelectionRange): ...
    @typing.overload
    def append(self, t: typing.List[PySide2.QtCore.QItemSelectionRange]): ...
    def at(self, i: int) -> PySide2.QtCore.QItemSelectionRange: ...
    def back(self) -> PySide2.QtCore.QItemSelectionRange: ...
    def clear(self): ...
    def constFirst(self) -> PySide2.QtCore.QItemSelectionRange: ...
    def constLast(self) -> PySide2.QtCore.QItemSelectionRange: ...
    def contains(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    @typing.overload
    def count(self) -> int: ...
    @typing.overload
    def count(self, t: PySide2.QtCore.QItemSelectionRange) -> int: ...
    def detachShared(self): ...
    def empty(self) -> bool: ...
    def endsWith(self, t: PySide2.QtCore.QItemSelectionRange) -> bool: ...
    def first(self) -> PySide2.QtCore.QItemSelectionRange: ...
    @staticmethod
    def fromSet(set: typing.Set[PySide2.QtCore.QItemSelectionRange]) -> typing.List[PySide2.QtCore.QItemSelectionRange]: ...
    @staticmethod
    def fromVector(vector: typing.List[PySide2.QtCore.QItemSelectionRange]) -> typing.List[PySide2.QtCore.QItemSelectionRange]: ...
    def front(self) -> PySide2.QtCore.QItemSelectionRange: ...
    def indexOf(self, t: PySide2.QtCore.QItemSelectionRange, from_: int = ...) -> int: ...
    def indexes(self) -> typing.List[int]: ...
    def insert(self, i: int, t: PySide2.QtCore.QItemSelectionRange): ...
    def isEmpty(self) -> bool: ...
    def isSharedWith(self, other: typing.List[PySide2.QtCore.QItemSelectionRange]) -> bool: ...
    def last(self) -> PySide2.QtCore.QItemSelectionRange: ...
    def lastIndexOf(self, t: PySide2.QtCore.QItemSelectionRange, from_: int = ...) -> int: ...
    def length(self) -> int: ...
    def merge(self, other: PySide2.QtCore.QItemSelection, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    def mid(self, pos: int, length: int = ...) -> typing.List[PySide2.QtCore.QItemSelectionRange]: ...
    def move(self, from_: int, to: int): ...
    def pop_back(self): ...
    def pop_front(self): ...
    def prepend(self, t: PySide2.QtCore.QItemSelectionRange): ...
    def push_back(self, t: PySide2.QtCore.QItemSelectionRange): ...
    def push_front(self, t: PySide2.QtCore.QItemSelectionRange): ...
    def removeAll(self, t: PySide2.QtCore.QItemSelectionRange) -> int: ...
    def removeAt(self, i: int): ...
    def removeFirst(self): ...
    def removeLast(self): ...
    def removeOne(self, t: PySide2.QtCore.QItemSelectionRange) -> bool: ...
    def replace(self, i: int, t: PySide2.QtCore.QItemSelectionRange): ...
    def reserve(self, size: int): ...
    def select(self, topLeft: PySide2.QtCore.QModelIndex, bottomRight: PySide2.QtCore.QModelIndex): ...
    def setSharable(self, sharable: bool): ...
    def size(self) -> int: ...
    @staticmethod
    def split(range: PySide2.QtCore.QItemSelectionRange, other: PySide2.QtCore.QItemSelectionRange, result: PySide2.QtCore.QItemSelection): ...
    def startsWith(self, t: PySide2.QtCore.QItemSelectionRange) -> bool: ...
    @typing.overload
    def swap(self, i: int, j: int): ...
    @typing.overload
    def swap(self, other: typing.List[PySide2.QtCore.QItemSelectionRange]): ...
    def takeAt(self, i: int) -> PySide2.QtCore.QItemSelectionRange: ...
    def takeFirst(self) -> PySide2.QtCore.QItemSelectionRange: ...
    def takeLast(self) -> PySide2.QtCore.QItemSelectionRange: ...
    def toSet(self) -> typing.Set[PySide2.QtCore.QItemSelectionRange]: ...
    def toVector(self) -> typing.List[PySide2.QtCore.QItemSelectionRange]: ...
    @typing.overload
    def value(self, i: int) -> PySide2.QtCore.QItemSelectionRange: ...
    @typing.overload
    def value(self, i: int, defaultValue: PySide2.QtCore.QItemSelectionRange) -> PySide2.QtCore.QItemSelectionRange: ...


class QItemSelectionModel(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, model: PySide2.QtCore.QAbstractItemModel, parent: PySide2.QtCore.QObject): ...
    @typing.overload
    def __init__(self, model: PySide2.QtCore.QAbstractItemModel = ...): ...
    def clear(self): ...
    def clearCurrentIndex(self): ...
    def clearSelection(self): ...
    def columnIntersectsSelection(self, column: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def currentIndex(self) -> PySide2.QtCore.QModelIndex: ...
    def emitSelectionChanged(self, newSelection: PySide2.QtCore.QItemSelection, oldSelection: PySide2.QtCore.QItemSelection): ...
    def hasSelection(self) -> bool: ...
    def isColumnSelected(self, column: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def isRowSelected(self, row: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def isSelected(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def reset(self): ...
    def rowIntersectsSelection(self, row: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    @typing.overload
    def select(self, index: PySide2.QtCore.QModelIndex, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    @typing.overload
    def select(self, selection: PySide2.QtCore.QItemSelection, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    def selectedColumns(self, row: int = ...) -> typing.List[int]: ...
    def selectedIndexes(self) -> typing.List[int]: ...
    def selectedRows(self, column: int = ...) -> typing.List[int]: ...
    def selection(self) -> PySide2.QtCore.QItemSelection: ...
    def setCurrentIndex(self, index: PySide2.QtCore.QModelIndex, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    def setModel(self, model: PySide2.QtCore.QAbstractItemModel): ...


class QItemSelectionRange(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, index: PySide2.QtCore.QModelIndex): ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QItemSelectionRange): ...
    @typing.overload
    def __init__(self, topL: PySide2.QtCore.QModelIndex, bottomR: PySide2.QtCore.QModelIndex): ...
    def __copy__(self): ...
    def bottom(self) -> int: ...
    def bottomRight(self) -> PySide2.QtCore.QPersistentModelIndex: ...
    @typing.overload
    def contains(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    @typing.overload
    def contains(self, row: int, column: int, parentIndex: PySide2.QtCore.QModelIndex) -> bool: ...
    def height(self) -> int: ...
    def indexes(self) -> typing.List[int]: ...
    def intersected(self, other: PySide2.QtCore.QItemSelectionRange) -> PySide2.QtCore.QItemSelectionRange: ...
    def intersects(self, other: PySide2.QtCore.QItemSelectionRange) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isValid(self) -> bool: ...
    def left(self) -> int: ...
    def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def parent(self) -> PySide2.QtCore.QModelIndex: ...
    def right(self) -> int: ...
    def swap(self, other: PySide2.QtCore.QItemSelectionRange): ...
    def top(self) -> int: ...
    def topLeft(self) -> PySide2.QtCore.QPersistentModelIndex: ...
    def width(self) -> int: ...


class QJsonArray(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QJsonArray): ...
    def __add__(self, v: PySide2.QtCore.QJsonValue) -> PySide2.QtCore.QJsonArray: ...
    def __copy__(self): ...
    def __iadd__(self, v: PySide2.QtCore.QJsonValue) -> PySide2.QtCore.QJsonArray: ...
    def __lshift__(self, v: PySide2.QtCore.QJsonValue) -> PySide2.QtCore.QJsonArray: ...
    def append(self, value: PySide2.QtCore.QJsonValue): ...
    def at(self, i: int) -> PySide2.QtCore.QJsonValue: ...
    def contains(self, element: PySide2.QtCore.QJsonValue) -> bool: ...
    def count(self) -> int: ...
    def empty(self) -> bool: ...
    def first(self) -> PySide2.QtCore.QJsonValue: ...
    @staticmethod
    def fromStringList(list: typing.List[str]) -> PySide2.QtCore.QJsonArray: ...
    @staticmethod
    def fromVariantList(list: typing.List[typing.Any]) -> PySide2.QtCore.QJsonArray: ...
    def insert(self, i: int, value: PySide2.QtCore.QJsonValue): ...
    def isEmpty(self) -> bool: ...
    def last(self) -> PySide2.QtCore.QJsonValue: ...
    def pop_back(self): ...
    def pop_front(self): ...
    def prepend(self, value: PySide2.QtCore.QJsonValue): ...
    def push_back(self, t: PySide2.QtCore.QJsonValue): ...
    def push_front(self, t: PySide2.QtCore.QJsonValue): ...
    def removeAt(self, i: int): ...
    def removeFirst(self): ...
    def removeLast(self): ...
    def replace(self, i: int, value: PySide2.QtCore.QJsonValue): ...
    def size(self) -> int: ...
    def swap(self, other: PySide2.QtCore.QJsonArray): ...
    def takeAt(self, i: int) -> PySide2.QtCore.QJsonValue: ...
    def toVariantList(self) -> typing.List[typing.Any]: ...


class QJsonDocument(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, array: PySide2.QtCore.QJsonArray): ...
    @typing.overload
    def __init__(self, object: typing.Dict[str, PySide2.QtCore.QJsonValue]): ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QJsonDocument): ...
    def __copy__(self): ...
    def array(self) -> PySide2.QtCore.QJsonArray: ...
    @staticmethod
    def fromBinaryData(data: PySide2.QtCore.QByteArray, validation: PySide2.QtCore.QJsonDocument.DataValidation = ...) -> PySide2.QtCore.QJsonDocument: ...
    @staticmethod
    def fromJson(json: PySide2.QtCore.QByteArray, error: PySide2.QtCore.QJsonParseError = ...) -> PySide2.QtCore.QJsonDocument: ...
    @staticmethod
    def fromRawData(data: str, size: int, validation: PySide2.QtCore.QJsonDocument.DataValidation = ...) -> PySide2.QtCore.QJsonDocument: ...
    @staticmethod
    def fromVariant(variant: typing.Any) -> PySide2.QtCore.QJsonDocument: ...
    def isArray(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isObject(self) -> bool: ...
    def object(self) -> typing.Dict[str, PySide2.QtCore.QJsonValue]: ...
    def rawData(self, size: int) -> str: ...
    def setArray(self, array: PySide2.QtCore.QJsonArray): ...
    def setObject(self, object: typing.Dict[str, PySide2.QtCore.QJsonValue]): ...
    def swap(self, other: PySide2.QtCore.QJsonDocument): ...
    def toBinaryData(self) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def toJson(self) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def toJson(self, format: PySide2.QtCore.QJsonDocument.JsonFormat) -> PySide2.QtCore.QByteArray: ...
    def toVariant(self) -> typing.Any: ...


class QJsonParseError(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QJsonParseError: PySide2.QtCore.QJsonParseError): ...
    def __copy__(self): ...
    def errorString(self) -> str: ...


class QJsonValue(Shiboken.Object):

    @typing.overload
    def __init__(self, a: PySide2.QtCore.QJsonArray): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QJsonValue.Type = ...): ...
    @typing.overload
    def __init__(self, b: bool): ...
    @typing.overload
    def __init__(self, n: float): ...
    @typing.overload
    def __init__(self, n: int): ...
    @typing.overload
    def __init__(self, n: int): ...
    @typing.overload
    def __init__(self, o: typing.Dict[str, PySide2.QtCore.QJsonValue]): ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QJsonValue): ...
    @typing.overload
    def __init__(self, s: str): ...
    @typing.overload
    def __init__(self, s: str): ...
    def __copy__(self): ...
    @staticmethod
    def fromVariant(variant: typing.Any) -> PySide2.QtCore.QJsonValue: ...
    def isArray(self) -> bool: ...
    def isBool(self) -> bool: ...
    def isDouble(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isObject(self) -> bool: ...
    def isString(self) -> bool: ...
    def isUndefined(self) -> bool: ...
    def swap(self, other: PySide2.QtCore.QJsonValue): ...
    @typing.overload
    def toArray(self) -> PySide2.QtCore.QJsonArray: ...
    @typing.overload
    def toArray(self, defaultValue: PySide2.QtCore.QJsonArray) -> PySide2.QtCore.QJsonArray: ...
    def toBool(self, defaultValue: bool = ...) -> bool: ...
    def toDouble(self, defaultValue: float = ...) -> float: ...
    def toInt(self, defaultValue: int = ...) -> int: ...
    @typing.overload
    def toObject(self) -> typing.Dict[str, PySide2.QtCore.QJsonValue]: ...
    @typing.overload
    def toObject(self, defaultValue: typing.Dict[str, PySide2.QtCore.QJsonValue]) -> typing.Dict[str, PySide2.QtCore.QJsonValue]: ...
    @typing.overload
    def toString(self) -> str: ...
    @typing.overload
    def toString(self, defaultValue: str) -> str: ...
    def toVariant(self) -> typing.Any: ...
    def type(self) -> PySide2.QtCore.QJsonValue.Type: ...


class QLibraryInfo(Shiboken.Object):

    @staticmethod
    def build() -> str: ...
    @staticmethod
    def buildDate() -> PySide2.QtCore.QDate: ...
    @staticmethod
    def isDebugBuild() -> bool: ...
    @staticmethod
    def licensedProducts() -> str: ...
    @staticmethod
    def licensee() -> str: ...
    @staticmethod
    def location(arg__1: PySide2.QtCore.QLibraryInfo.LibraryLocation) -> str: ...
    @staticmethod
    def platformPluginArguments(platformName: str) -> typing.List[str]: ...
    @staticmethod
    def version() -> PySide2.QtCore.QVersionNumber: ...


class QLine(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QLine: PySide2.QtCore.QLine): ...
    @typing.overload
    def __init__(self, pt1: PySide2.QtCore.QPoint, pt2: PySide2.QtCore.QPoint): ...
    @typing.overload
    def __init__(self, x1: int, y1: int, x2: int, y2: int): ...
    def __copy__(self): ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def center(self) -> PySide2.QtCore.QPoint: ...
    def dx(self) -> int: ...
    def dy(self) -> int: ...
    def isNull(self) -> bool: ...
    def p1(self) -> PySide2.QtCore.QPoint: ...
    def p2(self) -> PySide2.QtCore.QPoint: ...
    def setLine(self, x1: int, y1: int, x2: int, y2: int): ...
    def setP1(self, p1: PySide2.QtCore.QPoint): ...
    def setP2(self, p2: PySide2.QtCore.QPoint): ...
    def setPoints(self, p1: PySide2.QtCore.QPoint, p2: PySide2.QtCore.QPoint): ...
    def toTuple(self) -> object: ...
    @typing.overload
    def translate(self, dx: int, dy: int): ...
    @typing.overload
    def translate(self, p: PySide2.QtCore.QPoint): ...
    @typing.overload
    def translated(self, dx: int, dy: int) -> PySide2.QtCore.QLine: ...
    @typing.overload
    def translated(self, p: PySide2.QtCore.QPoint) -> PySide2.QtCore.QLine: ...
    def x1(self) -> int: ...
    def x2(self) -> int: ...
    def y1(self) -> int: ...
    def y2(self) -> int: ...


class QLineF(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QLineF: PySide2.QtCore.QLineF): ...
    @typing.overload
    def __init__(self, line: PySide2.QtCore.QLine): ...
    @typing.overload
    def __init__(self, pt1: PySide2.QtCore.QPointF, pt2: PySide2.QtCore.QPointF): ...
    @typing.overload
    def __init__(self, x1: float, y1: float, x2: float, y2: float): ...
    def __copy__(self): ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    @typing.overload
    def angle(self) -> float: ...
    @typing.overload
    def angle(self, l: PySide2.QtCore.QLineF) -> float: ...
    def angleTo(self, l: PySide2.QtCore.QLineF) -> float: ...
    def center(self) -> PySide2.QtCore.QPointF: ...
    def dx(self) -> float: ...
    def dy(self) -> float: ...
    @staticmethod
    def fromPolar(length: float, angle: float) -> PySide2.QtCore.QLineF: ...
    def intersect(self, l: PySide2.QtCore.QLineF, intersectionPoint: PySide2.QtCore.QPointF) -> PySide2.QtCore.QLineF.IntersectType: ...
    def isNull(self) -> bool: ...
    def length(self) -> float: ...
    def normalVector(self) -> PySide2.QtCore.QLineF: ...
    def p1(self) -> PySide2.QtCore.QPointF: ...
    def p2(self) -> PySide2.QtCore.QPointF: ...
    def pointAt(self, t: float) -> PySide2.QtCore.QPointF: ...
    def setAngle(self, angle: float): ...
    def setLength(self, len: float): ...
    def setLine(self, x1: float, y1: float, x2: float, y2: float): ...
    def setP1(self, p1: PySide2.QtCore.QPointF): ...
    def setP2(self, p2: PySide2.QtCore.QPointF): ...
    def setPoints(self, p1: PySide2.QtCore.QPointF, p2: PySide2.QtCore.QPointF): ...
    def toLine(self) -> PySide2.QtCore.QLine: ...
    def toTuple(self) -> object: ...
    @typing.overload
    def translate(self, dx: float, dy: float): ...
    @typing.overload
    def translate(self, p: PySide2.QtCore.QPointF): ...
    @typing.overload
    def translated(self, dx: float, dy: float) -> PySide2.QtCore.QLineF: ...
    @typing.overload
    def translated(self, p: PySide2.QtCore.QPointF) -> PySide2.QtCore.QLineF: ...
    def unitVector(self) -> PySide2.QtCore.QLineF: ...
    def x1(self) -> float: ...
    def x2(self) -> float: ...
    def y1(self) -> float: ...
    def y2(self) -> float: ...


class QLocale(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, language: PySide2.QtCore.QLocale.Language, country: PySide2.QtCore.QLocale.Country = ...): ...
    @typing.overload
    def __init__(self, language: PySide2.QtCore.QLocale.Language, script: PySide2.QtCore.QLocale.Script, country: PySide2.QtCore.QLocale.Country): ...
    @typing.overload
    def __init__(self, name: str): ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QLocale): ...
    def __copy__(self): ...
    def amText(self) -> str: ...
    def bcp47Name(self) -> str: ...
    @staticmethod
    def c() -> PySide2.QtCore.QLocale: ...
    @staticmethod
    def countriesForLanguage(lang: PySide2.QtCore.QLocale.Language) -> typing.List[PySide2.QtCore.QLocale.Country]: ...
    def country(self) -> PySide2.QtCore.QLocale.Country: ...
    @staticmethod
    def countryToString(country: PySide2.QtCore.QLocale.Country) -> str: ...
    def createSeparatedList(self, strl: typing.List[str]) -> str: ...
    def currencySymbol(self, arg__1: PySide2.QtCore.QLocale.CurrencySymbolFormat = ...) -> str: ...
    def dateFormat(self, format: PySide2.QtCore.QLocale.FormatType = ...) -> str: ...
    def dateTimeFormat(self, format: PySide2.QtCore.QLocale.FormatType = ...) -> str: ...
    def dayName(self, arg__1: int, format: PySide2.QtCore.QLocale.FormatType = ...) -> str: ...
    def decimalPoint(self) -> typing.Char: ...
    def exponential(self) -> typing.Char: ...
    def firstDayOfWeek(self) -> PySide2.QtCore.Qt.DayOfWeek: ...
    def formattedDataSize(self, bytes: int, precision: int = ..., format: PySide2.QtCore.QLocale.DataSizeFormats = ...) -> str: ...
    def groupSeparator(self) -> typing.Char: ...
    def language(self) -> PySide2.QtCore.QLocale.Language: ...
    @staticmethod
    def languageToString(language: PySide2.QtCore.QLocale.Language) -> str: ...
    @staticmethod
    def matchingLocales(language: PySide2.QtCore.QLocale.Language, script: PySide2.QtCore.QLocale.Script, country: PySide2.QtCore.QLocale.Country) -> typing.List[PySide2.QtCore.QLocale]: ...
    def measurementSystem(self) -> PySide2.QtCore.QLocale.MeasurementSystem: ...
    def monthName(self, arg__1: int, format: PySide2.QtCore.QLocale.FormatType = ...) -> str: ...
    def name(self) -> str: ...
    def nativeCountryName(self) -> str: ...
    def nativeLanguageName(self) -> str: ...
    def negativeSign(self) -> typing.Char: ...
    def numberOptions(self) -> PySide2.QtCore.QLocale.NumberOptions: ...
    def percent(self) -> typing.Char: ...
    def pmText(self) -> str: ...
    def positiveSign(self) -> typing.Char: ...
    @typing.overload
    def quoteString(self, str: str, style: PySide2.QtCore.QLocale.QuotationStyle = ...) -> str: ...
    @typing.overload
    def quoteString(self, str: str, style: PySide2.QtCore.QLocale.QuotationStyle = ...) -> str: ...
    def script(self) -> PySide2.QtCore.QLocale.Script: ...
    @staticmethod
    def scriptToString(script: PySide2.QtCore.QLocale.Script) -> str: ...
    @staticmethod
    def setDefault(locale: PySide2.QtCore.QLocale): ...
    def setNumberOptions(self, options: PySide2.QtCore.QLocale.NumberOptions): ...
    def standaloneDayName(self, arg__1: int, format: PySide2.QtCore.QLocale.FormatType = ...) -> str: ...
    def standaloneMonthName(self, arg__1: int, format: PySide2.QtCore.QLocale.FormatType = ...) -> str: ...
    def swap(self, other: PySide2.QtCore.QLocale): ...
    @staticmethod
    def system() -> PySide2.QtCore.QLocale: ...
    def textDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def timeFormat(self, format: PySide2.QtCore.QLocale.FormatType = ...) -> str: ...
    @typing.overload
    def toCurrencyString(self, arg__1: float, symbol: str, precision: int) -> str: ...
    @typing.overload
    def toCurrencyString(self, arg__1: float, symbol: str = ...) -> str: ...
    @typing.overload
    def toCurrencyString(self, arg__1: int, symbol: str = ...) -> str: ...
    @typing.overload
    def toCurrencyString(self, arg__1: int, symbol: str = ...) -> str: ...
    @typing.overload
    def toCurrencyString(self, arg__1: int, symbol: str = ...) -> str: ...
    @typing.overload
    def toCurrencyString(self, arg__1: int, symbol: str = ...) -> str: ...
    @typing.overload
    def toCurrencyString(self, arg__1: int, symbol: str = ...) -> str: ...
    @typing.overload
    def toCurrencyString(self, arg__1: int, symbol: str = ...) -> str: ...
    @typing.overload
    def toCurrencyString(self, i: float, symbol: str, precision: int) -> str: ...
    @typing.overload
    def toCurrencyString(self, i: float, symbol: str = ...) -> str: ...
    @typing.overload
    def toDate(self, string: str, format: PySide2.QtCore.QLocale.FormatType = ...) -> PySide2.QtCore.QDate: ...
    @typing.overload
    def toDate(self, string: str, format: str) -> PySide2.QtCore.QDate: ...
    @typing.overload
    def toDateTime(self, string: str, format: PySide2.QtCore.QLocale.FormatType = ...) -> PySide2.QtCore.QDateTime: ...
    @typing.overload
    def toDateTime(self, string: str, format: str) -> PySide2.QtCore.QDateTime: ...
    def toDouble(self, s: str, ok: bool) -> float: ...
    def toFloat(self, s: str, ok: bool) -> float: ...
    def toInt(self, s: str, ok: bool = ...) -> int: ...
    def toLongLong(self, s: str, ok: bool = ...) -> int: ...
    def toLower(self, str: str) -> str: ...
    def toShort(self, s: str, ok: bool = ...) -> int: ...
    @typing.overload
    def toString(self, date: PySide2.QtCore.QDate, format: PySide2.QtCore.QLocale.FormatType = ...) -> str: ...
    @typing.overload
    def toString(self, date: PySide2.QtCore.QDate, formatStr: str) -> str: ...
    @typing.overload
    def toString(self, dateTime: PySide2.QtCore.QDateTime, format: PySide2.QtCore.QLocale.FormatType = ...) -> str: ...
    @typing.overload
    def toString(self, dateTime: PySide2.QtCore.QDateTime, format: str) -> str: ...
    @typing.overload
    def toString(self, i: float, f: typing.Char = ..., prec: int = ...) -> str: ...
    @typing.overload
    def toString(self, i: float, f: typing.Char = ..., prec: int = ...) -> str: ...
    @typing.overload
    def toString(self, i: int) -> str: ...
    @typing.overload
    def toString(self, i: int) -> str: ...
    @typing.overload
    def toString(self, i: int) -> str: ...
    @typing.overload
    def toString(self, time: PySide2.QtCore.QTime, format: PySide2.QtCore.QLocale.FormatType = ...) -> str: ...
    @typing.overload
    def toString(self, time: PySide2.QtCore.QTime, formatStr: str) -> str: ...
    @typing.overload
    def toTime(self, string: str, format: PySide2.QtCore.QLocale.FormatType = ...) -> PySide2.QtCore.QTime: ...
    @typing.overload
    def toTime(self, string: str, format: str) -> PySide2.QtCore.QTime: ...
    def toUInt(self, s: str, ok: bool) -> int: ...
    def toULongLong(self, s: str, ok: bool) -> int: ...
    def toUShort(self, s: str, ok: bool = ...) -> int: ...
    def toUpper(self, str: str) -> str: ...
    def uiLanguages(self) -> typing.List[str]: ...
    def weekdays(self) -> typing.List[PySide2.QtCore.Qt.DayOfWeek]: ...
    def zeroDigit(self) -> typing.Char: ...


class QLockFile(Shiboken.Object):

    def __init__(self, fileName: str): ...
    def error(self) -> PySide2.QtCore.QLockFile.LockError: ...
    def getLockInfo(self, pid: int, hostname: str, appname: str) -> bool: ...
    def isLocked(self) -> bool: ...
    def lock(self) -> bool: ...
    def removeStaleLockFile(self) -> bool: ...
    def setStaleLockTime(self, arg__1: int): ...
    def staleLockTime(self) -> int: ...
    def tryLock(self, timeout: int = ...) -> bool: ...
    def unlock(self): ...


class QMargins(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QMargins: PySide2.QtCore.QMargins): ...
    @typing.overload
    def __init__(self, left: int, top: int, right: int, bottom: int): ...
    @typing.overload
    def __add__(self, lhs: int) -> PySide2.QtCore.QMargins: ...
    @typing.overload
    def __add__(self, m2: PySide2.QtCore.QMargins) -> PySide2.QtCore.QMargins: ...
    @typing.overload
    def __add__(self, rhs: int) -> PySide2.QtCore.QMargins: ...
    def __copy__(self): ...
    @typing.overload
    def __iadd__(self, arg__1: int) -> PySide2.QtCore.QMargins: ...
    @typing.overload
    def __iadd__(self, margins: PySide2.QtCore.QMargins) -> PySide2.QtCore.QMargins: ...
    @typing.overload
    def __imul__(self, arg__1: float) -> PySide2.QtCore.QMargins: ...
    @typing.overload
    def __imul__(self, arg__1: int) -> PySide2.QtCore.QMargins: ...
    @typing.overload
    def __isub__(self, arg__1: int) -> PySide2.QtCore.QMargins: ...
    @typing.overload
    def __isub__(self, margins: PySide2.QtCore.QMargins) -> PySide2.QtCore.QMargins: ...
    @typing.overload
    def __mul__(self, factor: float) -> PySide2.QtCore.QMargins: ...
    @typing.overload
    def __mul__(self, factor: int) -> PySide2.QtCore.QMargins: ...
    def __neg__(self) -> PySide2.QtCore.QMargins: ...
    def __pos__(self) -> PySide2.QtCore.QMargins: ...
    @typing.overload
    def __sub__(self, m2: PySide2.QtCore.QMargins) -> PySide2.QtCore.QMargins: ...
    @typing.overload
    def __sub__(self, rhs: int) -> PySide2.QtCore.QMargins: ...
    def bottom(self) -> int: ...
    def isNull(self) -> bool: ...
    def left(self) -> int: ...
    def right(self) -> int: ...
    def setBottom(self, bottom: int): ...
    def setLeft(self, left: int): ...
    def setRight(self, right: int): ...
    def setTop(self, top: int): ...
    def top(self) -> int: ...


class QMarginsF(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QMarginsF: PySide2.QtCore.QMarginsF): ...
    @typing.overload
    def __init__(self, left: float, top: float, right: float, bottom: float): ...
    @typing.overload
    def __init__(self, margins: PySide2.QtCore.QMargins): ...
    @typing.overload
    def __add__(self, lhs: float) -> PySide2.QtCore.QMarginsF: ...
    @typing.overload
    def __add__(self, rhs: PySide2.QtCore.QMarginsF) -> PySide2.QtCore.QMarginsF: ...
    @typing.overload
    def __add__(self, rhs: float) -> PySide2.QtCore.QMarginsF: ...
    def __copy__(self): ...
    @typing.overload
    def __iadd__(self, addend: float) -> PySide2.QtCore.QMarginsF: ...
    @typing.overload
    def __iadd__(self, margins: PySide2.QtCore.QMarginsF) -> PySide2.QtCore.QMarginsF: ...
    def __imul__(self, factor: float) -> PySide2.QtCore.QMarginsF: ...
    @typing.overload
    def __isub__(self, margins: PySide2.QtCore.QMarginsF) -> PySide2.QtCore.QMarginsF: ...
    @typing.overload
    def __isub__(self, subtrahend: float) -> PySide2.QtCore.QMarginsF: ...
    @typing.overload
    def __mul__(self, lhs: float) -> PySide2.QtCore.QMarginsF: ...
    @typing.overload
    def __mul__(self, rhs: float) -> PySide2.QtCore.QMarginsF: ...
    def __neg__(self) -> PySide2.QtCore.QMarginsF: ...
    def __pos__(self) -> PySide2.QtCore.QMarginsF: ...
    @typing.overload
    def __sub__(self, rhs: PySide2.QtCore.QMarginsF) -> PySide2.QtCore.QMarginsF: ...
    @typing.overload
    def __sub__(self, rhs: float) -> PySide2.QtCore.QMarginsF: ...
    def bottom(self) -> float: ...
    def isNull(self) -> bool: ...
    def left(self) -> float: ...
    def right(self) -> float: ...
    def setBottom(self, bottom: float): ...
    def setLeft(self, left: float): ...
    def setRight(self, right: float): ...
    def setTop(self, top: float): ...
    def toMargins(self) -> PySide2.QtCore.QMargins: ...
    def top(self) -> float: ...


class QMessageAuthenticationCode(Shiboken.Object):

    def __init__(self, method: PySide2.QtCore.QCryptographicHash.Algorithm, key: PySide2.QtCore.QByteArray = ...): ...
    @typing.overload
    def addData(self, data: PySide2.QtCore.QByteArray): ...
    @typing.overload
    def addData(self, data: str, length: int): ...
    @typing.overload
    def addData(self, device: PySide2.QtCore.QIODevice) -> bool: ...
    @staticmethod
    def hash(message: PySide2.QtCore.QByteArray, key: PySide2.QtCore.QByteArray, method: PySide2.QtCore.QCryptographicHash.Algorithm) -> PySide2.QtCore.QByteArray: ...
    def reset(self): ...
    def result(self) -> PySide2.QtCore.QByteArray: ...
    def setKey(self, key: PySide2.QtCore.QByteArray): ...


class QMessageLogContext(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, fileName: str, lineNumber: int, functionName: str, categoryName: str): ...


class QMetaClassInfo(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QMetaClassInfo: PySide2.QtCore.QMetaClassInfo): ...
    def __copy__(self): ...
    def name(self) -> str: ...
    def value(self) -> str: ...


class QMetaEnum(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QMetaEnum: PySide2.QtCore.QMetaEnum): ...
    def __copy__(self): ...
    def enumName(self) -> str: ...
    def isFlag(self) -> bool: ...
    def isScoped(self) -> bool: ...
    def isValid(self) -> bool: ...
    def key(self, index: int) -> str: ...
    def keyCount(self) -> int: ...
    def keyToValue(self, key: str, ok: bool = ...) -> int: ...
    def keysToValue(self, keys: str, ok: bool = ...) -> int: ...
    def name(self) -> str: ...
    def scope(self) -> str: ...
    def value(self, index: int) -> int: ...
    def valueToKey(self, value: int) -> str: ...
    def valueToKeys(self, value: int) -> PySide2.QtCore.QByteArray: ...


class QMetaMethod(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QMetaMethod: PySide2.QtCore.QMetaMethod): ...
    def __copy__(self): ...
    def access(self) -> PySide2.QtCore.QMetaMethod.Access: ...
    def enclosingMetaObject(self) -> PySide2.QtCore.QMetaObject: ...
    @typing.overload
    def invoke(self, object: PySide2.QtCore.QObject, connectionType: PySide2.QtCore.Qt.ConnectionType, returnValue: PySide2.QtCore.QGenericReturnArgument, val0: PySide2.QtCore.QGenericArgument = ..., val1: PySide2.QtCore.QGenericArgument = ..., val2: PySide2.QtCore.QGenericArgument = ..., val3: PySide2.QtCore.QGenericArgument = ..., val4: PySide2.QtCore.QGenericArgument = ..., val5: PySide2.QtCore.QGenericArgument = ..., val6: PySide2.QtCore.QGenericArgument = ..., val7: PySide2.QtCore.QGenericArgument = ..., val8: PySide2.QtCore.QGenericArgument = ..., val9: PySide2.QtCore.QGenericArgument = ...) -> bool: ...
    @typing.overload
    def invoke(self, object: PySide2.QtCore.QObject, connectionType: PySide2.QtCore.Qt.ConnectionType, val0: PySide2.QtCore.QGenericArgument = ..., val1: PySide2.QtCore.QGenericArgument = ..., val2: PySide2.QtCore.QGenericArgument = ..., val3: PySide2.QtCore.QGenericArgument = ..., val4: PySide2.QtCore.QGenericArgument = ..., val5: PySide2.QtCore.QGenericArgument = ..., val6: PySide2.QtCore.QGenericArgument = ..., val7: PySide2.QtCore.QGenericArgument = ..., val8: PySide2.QtCore.QGenericArgument = ..., val9: PySide2.QtCore.QGenericArgument = ...) -> bool: ...
    @typing.overload
    def invoke(self, object: PySide2.QtCore.QObject, returnValue: PySide2.QtCore.QGenericReturnArgument, val0: PySide2.QtCore.QGenericArgument = ..., val1: PySide2.QtCore.QGenericArgument = ..., val2: PySide2.QtCore.QGenericArgument = ..., val3: PySide2.QtCore.QGenericArgument = ..., val4: PySide2.QtCore.QGenericArgument = ..., val5: PySide2.QtCore.QGenericArgument = ..., val6: PySide2.QtCore.QGenericArgument = ..., val7: PySide2.QtCore.QGenericArgument = ..., val8: PySide2.QtCore.QGenericArgument = ..., val9: PySide2.QtCore.QGenericArgument = ...) -> bool: ...
    @typing.overload
    def invoke(self, object: PySide2.QtCore.QObject, val0: PySide2.QtCore.QGenericArgument = ..., val1: PySide2.QtCore.QGenericArgument = ..., val2: PySide2.QtCore.QGenericArgument = ..., val3: PySide2.QtCore.QGenericArgument = ..., val4: PySide2.QtCore.QGenericArgument = ..., val5: PySide2.QtCore.QGenericArgument = ..., val6: PySide2.QtCore.QGenericArgument = ..., val7: PySide2.QtCore.QGenericArgument = ..., val8: PySide2.QtCore.QGenericArgument = ..., val9: PySide2.QtCore.QGenericArgument = ...) -> bool: ...
    @typing.overload
    def invokeOnGadget(self, gadget: int, returnValue: PySide2.QtCore.QGenericReturnArgument, val0: PySide2.QtCore.QGenericArgument = ..., val1: PySide2.QtCore.QGenericArgument = ..., val2: PySide2.QtCore.QGenericArgument = ..., val3: PySide2.QtCore.QGenericArgument = ..., val4: PySide2.QtCore.QGenericArgument = ..., val5: PySide2.QtCore.QGenericArgument = ..., val6: PySide2.QtCore.QGenericArgument = ..., val7: PySide2.QtCore.QGenericArgument = ..., val8: PySide2.QtCore.QGenericArgument = ..., val9: PySide2.QtCore.QGenericArgument = ...) -> bool: ...
    @typing.overload
    def invokeOnGadget(self, gadget: int, val0: PySide2.QtCore.QGenericArgument = ..., val1: PySide2.QtCore.QGenericArgument = ..., val2: PySide2.QtCore.QGenericArgument = ..., val3: PySide2.QtCore.QGenericArgument = ..., val4: PySide2.QtCore.QGenericArgument = ..., val5: PySide2.QtCore.QGenericArgument = ..., val6: PySide2.QtCore.QGenericArgument = ..., val7: PySide2.QtCore.QGenericArgument = ..., val8: PySide2.QtCore.QGenericArgument = ..., val9: PySide2.QtCore.QGenericArgument = ...) -> bool: ...
    def isValid(self) -> bool: ...
    def methodIndex(self) -> int: ...
    def methodSignature(self) -> PySide2.QtCore.QByteArray: ...
    def methodType(self) -> PySide2.QtCore.QMetaMethod.MethodType: ...
    def name(self) -> PySide2.QtCore.QByteArray: ...
    def parameterCount(self) -> int: ...
    def parameterNames(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def parameterType(self, index: int) -> int: ...
    def parameterTypes(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def returnType(self) -> int: ...
    def revision(self) -> int: ...
    def tag(self) -> str: ...
    def typeName(self) -> str: ...


class QMetaObject(Shiboken.Object):

    def __init__(self): ...
    def cast(self, obj: PySide2.QtCore.QObject) -> PySide2.QtCore.QObject: ...
    @typing.overload
    @staticmethod
    def checkConnectArgs(signal: PySide2.QtCore.QMetaMethod, method: PySide2.QtCore.QMetaMethod) -> bool: ...
    @typing.overload
    @staticmethod
    def checkConnectArgs(signal: str, method: str) -> bool: ...
    def classInfo(self, index: int) -> PySide2.QtCore.QMetaClassInfo: ...
    def classInfoCount(self) -> int: ...
    def classInfoOffset(self) -> int: ...
    def className(self) -> str: ...
    @staticmethod
    def connectSlotsByName(o: PySide2.QtCore.QObject): ...
    def constructor(self, index: int) -> PySide2.QtCore.QMetaMethod: ...
    def constructorCount(self) -> int: ...
    @staticmethod
    def disconnect(sender: PySide2.QtCore.QObject, signal_index: int, receiver: PySide2.QtCore.QObject, method_index: int) -> bool: ...
    @staticmethod
    def disconnectOne(sender: PySide2.QtCore.QObject, signal_index: int, receiver: PySide2.QtCore.QObject, method_index: int) -> bool: ...
    def enumerator(self, index: int) -> PySide2.QtCore.QMetaEnum: ...
    def enumeratorCount(self) -> int: ...
    def enumeratorOffset(self) -> int: ...
    def indexOfClassInfo(self, name: str) -> int: ...
    def indexOfConstructor(self, constructor: str) -> int: ...
    def indexOfEnumerator(self, name: str) -> int: ...
    def indexOfMethod(self, method: str) -> int: ...
    def indexOfProperty(self, name: str) -> int: ...
    def indexOfSignal(self, signal: str) -> int: ...
    def indexOfSlot(self, slot: str) -> int: ...
    def inherits(self, metaObject: PySide2.QtCore.QMetaObject) -> bool: ...
    @typing.overload
    @staticmethod
    def invokeMethod(obj: PySide2.QtCore.QObject, member: str, arg__3: PySide2.QtCore.Qt.ConnectionType, ret: PySide2.QtCore.QGenericReturnArgument, val0: PySide2.QtCore.QGenericArgument = ..., val1: PySide2.QtCore.QGenericArgument = ..., val2: PySide2.QtCore.QGenericArgument = ..., val3: PySide2.QtCore.QGenericArgument = ..., val4: PySide2.QtCore.QGenericArgument = ..., val5: PySide2.QtCore.QGenericArgument = ..., val6: PySide2.QtCore.QGenericArgument = ..., val7: PySide2.QtCore.QGenericArgument = ..., val8: PySide2.QtCore.QGenericArgument = ..., val9: PySide2.QtCore.QGenericArgument = ...) -> bool: ...
    @typing.overload
    @staticmethod
    def invokeMethod(obj: PySide2.QtCore.QObject, member: str, ret: PySide2.QtCore.QGenericReturnArgument, val0: PySide2.QtCore.QGenericArgument = ..., val1: PySide2.QtCore.QGenericArgument = ..., val2: PySide2.QtCore.QGenericArgument = ..., val3: PySide2.QtCore.QGenericArgument = ..., val4: PySide2.QtCore.QGenericArgument = ..., val5: PySide2.QtCore.QGenericArgument = ..., val6: PySide2.QtCore.QGenericArgument = ..., val7: PySide2.QtCore.QGenericArgument = ..., val8: PySide2.QtCore.QGenericArgument = ..., val9: PySide2.QtCore.QGenericArgument = ...) -> bool: ...
    @typing.overload
    @staticmethod
    def invokeMethod(obj: PySide2.QtCore.QObject, member: str, type: PySide2.QtCore.Qt.ConnectionType, val0: PySide2.QtCore.QGenericArgument = ..., val1: PySide2.QtCore.QGenericArgument = ..., val2: PySide2.QtCore.QGenericArgument = ..., val3: PySide2.QtCore.QGenericArgument = ..., val4: PySide2.QtCore.QGenericArgument = ..., val5: PySide2.QtCore.QGenericArgument = ..., val6: PySide2.QtCore.QGenericArgument = ..., val7: PySide2.QtCore.QGenericArgument = ..., val8: PySide2.QtCore.QGenericArgument = ..., val9: PySide2.QtCore.QGenericArgument = ...) -> bool: ...
    @typing.overload
    @staticmethod
    def invokeMethod(obj: PySide2.QtCore.QObject, member: str, val0: PySide2.QtCore.QGenericArgument = ..., val1: PySide2.QtCore.QGenericArgument = ..., val2: PySide2.QtCore.QGenericArgument = ..., val3: PySide2.QtCore.QGenericArgument = ..., val4: PySide2.QtCore.QGenericArgument = ..., val5: PySide2.QtCore.QGenericArgument = ..., val6: PySide2.QtCore.QGenericArgument = ..., val7: PySide2.QtCore.QGenericArgument = ..., val8: PySide2.QtCore.QGenericArgument = ..., val9: PySide2.QtCore.QGenericArgument = ...) -> bool: ...
    def method(self, index: int) -> PySide2.QtCore.QMetaMethod: ...
    def methodCount(self) -> int: ...
    def methodOffset(self) -> int: ...
    def newInstance(self, val0: PySide2.QtCore.QGenericArgument = ..., val1: PySide2.QtCore.QGenericArgument = ..., val2: PySide2.QtCore.QGenericArgument = ..., val3: PySide2.QtCore.QGenericArgument = ..., val4: PySide2.QtCore.QGenericArgument = ..., val5: PySide2.QtCore.QGenericArgument = ..., val6: PySide2.QtCore.QGenericArgument = ..., val7: PySide2.QtCore.QGenericArgument = ..., val8: PySide2.QtCore.QGenericArgument = ..., val9: PySide2.QtCore.QGenericArgument = ...) -> PySide2.QtCore.QObject: ...
    @staticmethod
    def normalizedSignature(method: str) -> PySide2.QtCore.QByteArray: ...
    @staticmethod
    def normalizedType(type: str) -> PySide2.QtCore.QByteArray: ...
    def property(self, index: int) -> PySide2.QtCore.QMetaProperty: ...
    def propertyCount(self) -> int: ...
    def propertyOffset(self) -> int: ...
    def superClass(self) -> PySide2.QtCore.QMetaObject: ...
    def userProperty(self) -> PySide2.QtCore.QMetaProperty: ...

    class Connection(Shiboken.Object):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, other: PySide2.QtCore.QMetaObject.Connection): ...


class QMetaProperty(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QMetaProperty: PySide2.QtCore.QMetaProperty): ...
    def __copy__(self): ...
    def enumerator(self) -> PySide2.QtCore.QMetaEnum: ...
    def hasNotifySignal(self) -> bool: ...
    def hasStdCppSet(self) -> bool: ...
    def isConstant(self) -> bool: ...
    def isDesignable(self, obj: PySide2.QtCore.QObject = ...) -> bool: ...
    def isEditable(self, obj: PySide2.QtCore.QObject = ...) -> bool: ...
    def isEnumType(self) -> bool: ...
    def isFinal(self) -> bool: ...
    def isFlagType(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isResettable(self) -> bool: ...
    def isScriptable(self, obj: PySide2.QtCore.QObject = ...) -> bool: ...
    def isStored(self, obj: PySide2.QtCore.QObject = ...) -> bool: ...
    def isUser(self, obj: PySide2.QtCore.QObject = ...) -> bool: ...
    def isValid(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def name(self) -> str: ...
    def notifySignal(self) -> PySide2.QtCore.QMetaMethod: ...
    def notifySignalIndex(self) -> int: ...
    def propertyIndex(self) -> int: ...
    def read(self, obj: PySide2.QtCore.QObject) -> typing.Any: ...
    def readOnGadget(self, gadget: int) -> typing.Any: ...
    def reset(self, obj: PySide2.QtCore.QObject) -> bool: ...
    def resetOnGadget(self, gadget: int) -> bool: ...
    def revision(self) -> int: ...
    def type(self) -> type: ...
    def typeName(self) -> str: ...
    def userType(self) -> int: ...
    def write(self, obj: PySide2.QtCore.QObject, value: typing.Any) -> bool: ...
    def writeOnGadget(self, gadget: int, value: typing.Any) -> bool: ...


class QMimeData(PySide2.QtCore.QObject):

    def __init__(self): ...
    def clear(self): ...
    def colorData(self) -> typing.Any: ...
    def data(self, mimetype: str) -> PySide2.QtCore.QByteArray: ...
    def formats(self) -> typing.List[str]: ...
    def hasColor(self) -> bool: ...
    def hasFormat(self, mimetype: str) -> bool: ...
    def hasHtml(self) -> bool: ...
    def hasImage(self) -> bool: ...
    def hasText(self) -> bool: ...
    def hasUrls(self) -> bool: ...
    def html(self) -> str: ...
    def imageData(self) -> typing.Any: ...
    def removeFormat(self, mimetype: str): ...
    def retrieveData(self, mimetype: str, preferredType: type) -> typing.Any: ...
    def setColorData(self, color: typing.Any): ...
    def setData(self, mimetype: str, data: PySide2.QtCore.QByteArray): ...
    def setHtml(self, html: str): ...
    def setImageData(self, image: typing.Any): ...
    def setText(self, text: str): ...
    def setUrls(self, urls: typing.List[PySide2.QtCore.QUrl]): ...
    def text(self) -> str: ...
    def urls(self) -> typing.List[PySide2.QtCore.QUrl]: ...


class QMimeDatabase(Shiboken.Object):

    def __init__(self): ...
    def allMimeTypes(self) -> typing.List[PySide2.QtCore.QMimeType]: ...
    @typing.overload
    def mimeTypeForData(self, data: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QMimeType: ...
    @typing.overload
    def mimeTypeForData(self, device: PySide2.QtCore.QIODevice) -> PySide2.QtCore.QMimeType: ...
    @typing.overload
    def mimeTypeForFile(self, fileInfo: PySide2.QtCore.QFileInfo, mode: PySide2.QtCore.QMimeDatabase.MatchMode = ...) -> PySide2.QtCore.QMimeType: ...
    @typing.overload
    def mimeTypeForFile(self, fileName: str, mode: PySide2.QtCore.QMimeDatabase.MatchMode = ...) -> PySide2.QtCore.QMimeType: ...
    @typing.overload
    def mimeTypeForFileNameAndData(self, fileName: str, data: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QMimeType: ...
    @typing.overload
    def mimeTypeForFileNameAndData(self, fileName: str, device: PySide2.QtCore.QIODevice) -> PySide2.QtCore.QMimeType: ...
    def mimeTypeForName(self, nameOrAlias: str) -> PySide2.QtCore.QMimeType: ...
    def mimeTypeForUrl(self, url: PySide2.QtCore.QUrl) -> PySide2.QtCore.QMimeType: ...
    def mimeTypesForFileName(self, fileName: str) -> typing.List[PySide2.QtCore.QMimeType]: ...
    def suffixForFileName(self, fileName: str) -> str: ...


class QMimeType(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QMimeType): ...
    def __copy__(self): ...
    def aliases(self) -> typing.List[str]: ...
    def allAncestors(self) -> typing.List[str]: ...
    def comment(self) -> str: ...
    def filterString(self) -> str: ...
    def genericIconName(self) -> str: ...
    def globPatterns(self) -> typing.List[str]: ...
    def iconName(self) -> str: ...
    def inherits(self, mimeTypeName: str) -> bool: ...
    def isDefault(self) -> bool: ...
    def isValid(self) -> bool: ...
    def name(self) -> str: ...
    def parentMimeTypes(self) -> typing.List[str]: ...
    def preferredSuffix(self) -> str: ...
    def suffixes(self) -> typing.List[str]: ...
    def swap(self, other: PySide2.QtCore.QMimeType): ...


class QModelIndex(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QModelIndex: PySide2.QtCore.QModelIndex): ...
    def __copy__(self): ...
    def child(self, row: int, column: int) -> PySide2.QtCore.QModelIndex: ...
    def column(self) -> int: ...
    def data(self, role: int = ...) -> typing.Any: ...
    def flags(self) -> PySide2.QtCore.Qt.ItemFlags: ...
    def internalId(self) -> int: ...
    def internalPointer(self) -> int: ...
    def isValid(self) -> bool: ...
    def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def parent(self) -> PySide2.QtCore.QModelIndex: ...
    def row(self) -> int: ...
    def sibling(self, row: int, column: int) -> PySide2.QtCore.QModelIndex: ...
    def siblingAtColumn(self, column: int) -> PySide2.QtCore.QModelIndex: ...
    def siblingAtRow(self, row: int) -> PySide2.QtCore.QModelIndex: ...


class QMutex(PySide2.QtCore.QBasicMutex):

    def __init__(self, mode: PySide2.QtCore.QMutex.RecursionMode = ...): ...
    def isRecursive(self) -> bool: ...
    def lock(self): ...
    @typing.overload
    def tryLock(self) -> bool: ...
    @typing.overload
    def tryLock(self, timeout: int = ...) -> bool: ...
    def try_lock(self) -> bool: ...
    def unlock(self): ...


class QMutexLocker(Shiboken.Object):

    def __init__(self, m: PySide2.QtCore.QBasicMutex): ...
    def __enter__(self): ...
    def __exit__(self, arg__1: object, arg__2: object, arg__3: object): ...
    def mutex(self) -> PySide2.QtCore.QMutex: ...
    def relock(self): ...
    def unlock(self): ...


class QObject(Shiboken.Object):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def blockSignals(self, b: bool) -> bool: ...
    def childEvent(self, event: PySide2.QtCore.QChildEvent): ...
    def children(self) -> typing.List[PySide2.QtCore.QObject]: ...
    @typing.overload
    @staticmethod
    def connect(arg__1: PySide2.QtCore.QObject, arg__2: str, arg__3: typing.Callable, type: PySide2.QtCore.Qt.ConnectionType = ...) -> bool: ...
    @typing.overload
    @staticmethod
    def connect(arg__1: str, arg__2: typing.Callable, type: PySide2.QtCore.Qt.ConnectionType = ...) -> bool: ...
    @typing.overload
    @staticmethod
    def connect(arg__1: str, arg__2: PySide2.QtCore.QObject, arg__3: str, type: PySide2.QtCore.Qt.ConnectionType = ...) -> bool: ...
    @typing.overload
    @staticmethod
    def connect(sender: PySide2.QtCore.QObject, signal: PySide2.QtCore.QMetaMethod, receiver: PySide2.QtCore.QObject, method: PySide2.QtCore.QMetaMethod, type: PySide2.QtCore.Qt.ConnectionType = ...) -> PySide2.QtCore.QMetaObject.Connection: ...
    @typing.overload
    @staticmethod
    def connect(sender: PySide2.QtCore.QObject, signal: str, member: str, type: PySide2.QtCore.Qt.ConnectionType = ...) -> PySide2.QtCore.QMetaObject.Connection: ...
    @typing.overload
    @staticmethod
    def connect(sender: PySide2.QtCore.QObject, signal: str, receiver: PySide2.QtCore.QObject, member: str, type: PySide2.QtCore.Qt.ConnectionType = ...) -> PySide2.QtCore.QMetaObject.Connection: ...
    def connectNotify(self, signal: PySide2.QtCore.QMetaMethod): ...
    def customEvent(self, event: PySide2.QtCore.QEvent): ...
    def deleteLater(self): ...
    @typing.overload
    @staticmethod
    def disconnect(arg__1: PySide2.QtCore.QMetaObject.Connection) -> bool: ...
    @typing.overload
    @staticmethod
    def disconnect(arg__1: PySide2.QtCore.QObject, arg__2: str, arg__3: typing.Callable) -> bool: ...
    @typing.overload
    @staticmethod
    def disconnect(arg__1: str, arg__2: typing.Callable) -> bool: ...
    @typing.overload
    @staticmethod
    def disconnect(receiver: PySide2.QtCore.QObject, member: str = ...) -> bool: ...
    @typing.overload
    @staticmethod
    def disconnect(sender: PySide2.QtCore.QObject, signal: PySide2.QtCore.QMetaMethod, receiver: PySide2.QtCore.QObject, member: PySide2.QtCore.QMetaMethod) -> bool: ...
    @typing.overload
    @staticmethod
    def disconnect(sender: PySide2.QtCore.QObject, signal: str, receiver: PySide2.QtCore.QObject, member: str) -> bool: ...
    @typing.overload
    @staticmethod
    def disconnect(signal: str, receiver: PySide2.QtCore.QObject, member: str) -> bool: ...
    def disconnectNotify(self, signal: PySide2.QtCore.QMetaMethod): ...
    def dumpObjectInfo(self): ...
    def dumpObjectTree(self): ...
    def dynamicPropertyNames(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def emit(self, arg__1: str, *args) -> bool: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, watched: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def findChild(self, arg__1: type, arg__2: str = ...) -> object: ...
    @typing.overload
    def findChildren(self, arg__1: type, arg__2: PySide2.QtCore.QRegExp) -> typing.Iterable: ...
    @typing.overload
    def findChildren(self, arg__1: type, arg__2: str = ...) -> typing.Iterable: ...
    def inherits(self, classname: str) -> bool: ...
    def installEventFilter(self, filterObj: PySide2.QtCore.QObject): ...
    def isSignalConnected(self, signal: PySide2.QtCore.QMetaMethod) -> bool: ...
    def isWidgetType(self) -> bool: ...
    def isWindowType(self) -> bool: ...
    def killTimer(self, id: int): ...
    def metaObject(self) -> PySide2.QtCore.QMetaObject: ...
    def moveToThread(self, thread: PySide2.QtCore.QThread): ...
    def objectName(self) -> str: ...
    def parent(self) -> PySide2.QtCore.QObject: ...
    def property(self, name: str) -> typing.Any: ...
    def receivers(self, signal: str) -> int: ...
    @staticmethod
    def registerUserData() -> int: ...
    def removeEventFilter(self, obj: PySide2.QtCore.QObject): ...
    def sender(self) -> PySide2.QtCore.QObject: ...
    def senderSignalIndex(self) -> int: ...
    def setObjectName(self, name: str): ...
    def setParent(self, parent: PySide2.QtCore.QObject): ...
    def setProperty(self, name: str, value: typing.Any) -> bool: ...
    def signalsBlocked(self) -> bool: ...
    def startTimer(self, interval: int, timerType: PySide2.QtCore.Qt.TimerType = ...) -> int: ...
    def thread(self) -> PySide2.QtCore.QThread: ...
    def timerEvent(self, event: PySide2.QtCore.QTimerEvent): ...
    def tr(self, arg__1: str, arg__2: str = ..., arg__3: int = ...) -> str: ...


class QOperatingSystemVersion(Shiboken.Object):

    @typing.overload
    def __init__(self, QOperatingSystemVersion: PySide2.QtCore.QOperatingSystemVersion): ...
    @typing.overload
    def __init__(self, osType: PySide2.QtCore.QOperatingSystemVersion.OSType, vmajor: int, vminor: int = ..., vmicro: int = ...): ...
    def __copy__(self): ...
    @staticmethod
    def current() -> PySide2.QtCore.QOperatingSystemVersion: ...
    @staticmethod
    def currentType() -> PySide2.QtCore.QOperatingSystemVersion.OSType: ...
    def majorVersion(self) -> int: ...
    def microVersion(self) -> int: ...
    def minorVersion(self) -> int: ...
    def name(self) -> str: ...
    def segmentCount(self) -> int: ...
    def type(self) -> PySide2.QtCore.QOperatingSystemVersion.OSType: ...


class QParallelAnimationGroup(PySide2.QtCore.QAnimationGroup):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def duration(self) -> int: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def updateCurrentTime(self, currentTime: int): ...
    def updateDirection(self, direction: PySide2.QtCore.QAbstractAnimation.Direction): ...
    def updateState(self, newState: PySide2.QtCore.QAbstractAnimation.State, oldState: PySide2.QtCore.QAbstractAnimation.State): ...


class QPauseAnimation(PySide2.QtCore.QAbstractAnimation):

    @typing.overload
    def __init__(self, msecs: int, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def duration(self) -> int: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def setDuration(self, msecs: int): ...
    def updateCurrentTime(self, arg__1: int): ...


class QPersistentModelIndex(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, index: PySide2.QtCore.QModelIndex): ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QPersistentModelIndex): ...
    def __copy__(self): ...
    def child(self, row: int, column: int) -> PySide2.QtCore.QModelIndex: ...
    def column(self) -> int: ...
    def data(self, role: int = ...) -> typing.Any: ...
    def flags(self) -> PySide2.QtCore.Qt.ItemFlags: ...
    def internalId(self) -> int: ...
    def internalPointer(self) -> int: ...
    def isValid(self) -> bool: ...
    def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def parent(self) -> PySide2.QtCore.QModelIndex: ...
    def row(self) -> int: ...
    def sibling(self, row: int, column: int) -> PySide2.QtCore.QModelIndex: ...
    def swap(self, other: PySide2.QtCore.QPersistentModelIndex): ...


class QPluginLoader(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, fileName: str, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def errorString(self) -> str: ...
    def fileName(self) -> str: ...
    def instance(self) -> PySide2.QtCore.QObject: ...
    def isLoaded(self) -> bool: ...
    def load(self) -> bool: ...
    def metaData(self) -> typing.Dict[str, PySide2.QtCore.QJsonValue]: ...
    def setFileName(self, fileName: str): ...
    @staticmethod
    def staticInstances() -> typing.List[PySide2.QtCore.QObject]: ...
    def unload(self) -> bool: ...


class QPoint(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QPoint: PySide2.QtCore.QPoint): ...
    @typing.overload
    def __init__(self, xpos: int, ypos: int): ...
    def __add__(self, p2: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def __copy__(self): ...
    def __iadd__(self, p: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def __imul__(self, factor: float) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def __imul__(self, factor: float) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def __imul__(self, factor: int) -> PySide2.QtCore.QPoint: ...
    def __isub__(self, p: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def __mul__(self, factor: float) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def __mul__(self, factor: float) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def __mul__(self, factor: int) -> PySide2.QtCore.QPoint: ...
    def __neg__(self) -> PySide2.QtCore.QPoint: ...
    def __pos__(self) -> PySide2.QtCore.QPoint: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __sub__(self, p2: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @staticmethod
    def dotProduct(p1: PySide2.QtCore.QPoint, p2: PySide2.QtCore.QPoint) -> int: ...
    def isNull(self) -> bool: ...
    def manhattanLength(self) -> int: ...
    def setX(self, x: int): ...
    def setY(self, y: int): ...
    def toTuple(self) -> object: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QPointF(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QPointF: PySide2.QtCore.QPointF): ...
    @typing.overload
    def __init__(self, p: PySide2.QtCore.QPoint): ...
    @typing.overload
    def __init__(self, xpos: float, ypos: float): ...
    def __add__(self, p2: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def __copy__(self): ...
    def __iadd__(self, p: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def __imul__(self, c: float) -> PySide2.QtCore.QPointF: ...
    def __isub__(self, p: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def __mul__(self, c: float) -> PySide2.QtCore.QPointF: ...
    def __neg__(self) -> PySide2.QtCore.QPointF: ...
    def __pos__(self) -> PySide2.QtCore.QPointF: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __sub__(self, p2: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @staticmethod
    def dotProduct(p1: PySide2.QtCore.QPointF, p2: PySide2.QtCore.QPointF) -> float: ...
    def isNull(self) -> bool: ...
    def manhattanLength(self) -> float: ...
    def setX(self, x: float): ...
    def setY(self, y: float): ...
    def toPoint(self) -> PySide2.QtCore.QPoint: ...
    def toTuple(self) -> object: ...
    def x(self) -> float: ...
    def y(self) -> float: ...


class QProcess(PySide2.QtCore.QIODevice):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def arguments(self) -> typing.List[str]: ...
    def atEnd(self) -> bool: ...
    def bytesAvailable(self) -> int: ...
    def bytesToWrite(self) -> int: ...
    def canReadLine(self) -> bool: ...
    def close(self): ...
    def closeReadChannel(self, channel: PySide2.QtCore.QProcess.ProcessChannel): ...
    def closeWriteChannel(self): ...
    def environment(self) -> typing.List[str]: ...
    def error(self) -> PySide2.QtCore.QProcess.ProcessError: ...
    @typing.overload
    @staticmethod
    def execute(command: str) -> int: ...
    @typing.overload
    @staticmethod
    def execute(program: str, arguments: typing.List[str]) -> int: ...
    def exitCode(self) -> int: ...
    def exitStatus(self) -> PySide2.QtCore.QProcess.ExitStatus: ...
    def inputChannelMode(self) -> PySide2.QtCore.QProcess.InputChannelMode: ...
    def isSequential(self) -> bool: ...
    def kill(self): ...
    @staticmethod
    def nullDevice() -> str: ...
    def open(self, mode: PySide2.QtCore.QIODevice.OpenMode = ...) -> bool: ...
    def pid(self) -> int: ...
    def processChannelMode(self) -> PySide2.QtCore.QProcess.ProcessChannelMode: ...
    def processEnvironment(self) -> PySide2.QtCore.QProcessEnvironment: ...
    def processId(self) -> int: ...
    def program(self) -> str: ...
    def readAllStandardError(self) -> PySide2.QtCore.QByteArray: ...
    def readAllStandardOutput(self) -> PySide2.QtCore.QByteArray: ...
    def readChannel(self) -> PySide2.QtCore.QProcess.ProcessChannel: ...
    def readData(self, data: str, maxlen: int) -> int: ...
    def setArguments(self, arguments: typing.List[str]): ...
    def setEnvironment(self, environment: typing.List[str]): ...
    def setInputChannelMode(self, mode: PySide2.QtCore.QProcess.InputChannelMode): ...
    def setProcessChannelMode(self, mode: PySide2.QtCore.QProcess.ProcessChannelMode): ...
    def setProcessEnvironment(self, environment: PySide2.QtCore.QProcessEnvironment): ...
    def setProcessState(self, state: PySide2.QtCore.QProcess.ProcessState): ...
    def setProgram(self, program: str): ...
    def setReadChannel(self, channel: PySide2.QtCore.QProcess.ProcessChannel): ...
    def setStandardErrorFile(self, fileName: str, mode: PySide2.QtCore.QIODevice.OpenMode = ...): ...
    def setStandardInputFile(self, fileName: str): ...
    def setStandardOutputFile(self, fileName: str, mode: PySide2.QtCore.QIODevice.OpenMode = ...): ...
    def setStandardOutputProcess(self, destination: PySide2.QtCore.QProcess): ...
    def setWorkingDirectory(self, dir: str): ...
    def setupChildProcess(self): ...
    @typing.overload
    def start(self, command: str, mode: PySide2.QtCore.QIODevice.OpenMode = ...): ...
    @typing.overload
    def start(self, mode: PySide2.QtCore.QIODevice.OpenMode = ...): ...
    @typing.overload
    def start(self, program: str, arguments: typing.List[str], mode: PySide2.QtCore.QIODevice.OpenMode = ...): ...
    @typing.overload
    @staticmethod
    def startDetached(command: str) -> bool: ...
    @typing.overload
    @staticmethod
    def startDetached(pid: int = ...) -> bool: ...
    @typing.overload
    @staticmethod
    def startDetached(program: str, arguments: typing.List[str]) -> bool: ...
    @typing.overload
    @staticmethod
    def startDetached(program: str, arguments: typing.List[str], workingDirectory: str, pid: int = ...) -> bool: ...
    def state(self) -> PySide2.QtCore.QProcess.ProcessState: ...
    @staticmethod
    def systemEnvironment() -> typing.List[str]: ...
    def terminate(self): ...
    def waitForBytesWritten(self, msecs: int = ...) -> bool: ...
    def waitForFinished(self, msecs: int = ...) -> bool: ...
    def waitForReadyRead(self, msecs: int = ...) -> bool: ...
    def waitForStarted(self, msecs: int = ...) -> bool: ...
    def workingDirectory(self) -> str: ...
    def writeData(self, data: str, len: int) -> int: ...


class QProcessEnvironment(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QProcessEnvironment): ...
    def __copy__(self): ...
    def clear(self): ...
    def contains(self, name: str) -> bool: ...
    @typing.overload
    def insert(self, e: PySide2.QtCore.QProcessEnvironment): ...
    @typing.overload
    def insert(self, name: str, value: str): ...
    def isEmpty(self) -> bool: ...
    def keys(self) -> typing.List[str]: ...
    def remove(self, name: str): ...
    def swap(self, other: PySide2.QtCore.QProcessEnvironment): ...
    @staticmethod
    def systemEnvironment() -> PySide2.QtCore.QProcessEnvironment: ...
    def toStringList(self) -> typing.List[str]: ...
    def value(self, name: str, defaultValue: str = ...) -> str: ...


class QPropertyAnimation(PySide2.QtCore.QVariantAnimation):

    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, target: PySide2.QtCore.QObject, propertyName: PySide2.QtCore.QByteArray, parent: PySide2.QtCore.QObject = ...): ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def propertyName(self) -> PySide2.QtCore.QByteArray: ...
    def setPropertyName(self, propertyName: PySide2.QtCore.QByteArray): ...
    def setTargetObject(self, target: PySide2.QtCore.QObject): ...
    def targetObject(self) -> PySide2.QtCore.QObject: ...
    def updateCurrentValue(self, value: typing.Any): ...
    def updateState(self, newState: PySide2.QtCore.QAbstractAnimation.State, oldState: PySide2.QtCore.QAbstractAnimation.State): ...


class QRandomGenerator(Shiboken.Object):

    @typing.overload
    def __init__(self, begin: int, end: int): ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QRandomGenerator): ...
    @typing.overload
    def __init__(self, seedBuffer: int, len: int): ...
    @typing.overload
    def __init__(self, seedValue: int = ...): ...
    @typing.overload
    def bounded(self, highest: float) -> float: ...
    @typing.overload
    def bounded(self, highest: int) -> int: ...
    @typing.overload
    def bounded(self, highest: int) -> int: ...
    @typing.overload
    def bounded(self, lowest: int, highest: int) -> int: ...
    @typing.overload
    def bounded(self, lowest: int, highest: int) -> int: ...
    def discard(self, z: int): ...
    @typing.overload
    def generate(self) -> int: ...
    @typing.overload
    def generate(self, begin: int, end: int): ...
    def generate64(self) -> int: ...
    def generateDouble(self) -> float: ...
    @staticmethod
    def global_() -> PySide2.QtCore.QRandomGenerator: ...
    @staticmethod
    def max() -> int: ...
    @staticmethod
    def min() -> int: ...
    @staticmethod
    def securelySeeded() -> PySide2.QtCore.QRandomGenerator: ...
    def seed(self, s: int = ...): ...
    @staticmethod
    def system() -> PySide2.QtCore.QRandomGenerator: ...


class QRandomGenerator64(PySide2.QtCore.QRandomGenerator):

    @typing.overload
    def __init__(self, begin: int, end: int): ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QRandomGenerator): ...
    @typing.overload
    def __init__(self, seedBuffer: int, len: int): ...
    @typing.overload
    def __init__(self, seedValue: int = ...): ...
    def discard(self, z: int): ...
    def generate(self) -> int: ...
    @staticmethod
    def global_() -> PySide2.QtCore.QRandomGenerator64: ...
    @staticmethod
    def max() -> int: ...
    @staticmethod
    def min() -> int: ...
    @staticmethod
    def securelySeeded() -> PySide2.QtCore.QRandomGenerator64: ...
    @staticmethod
    def system() -> PySide2.QtCore.QRandomGenerator64: ...


class QReadLocker(Shiboken.Object):

    def __init__(self, readWriteLock: PySide2.QtCore.QReadWriteLock): ...
    def __enter__(self): ...
    def __exit__(self, arg__1: object, arg__2: object, arg__3: object): ...
    def readWriteLock(self) -> PySide2.QtCore.QReadWriteLock: ...
    def relock(self): ...
    def unlock(self): ...


class QReadWriteLock(Shiboken.Object):

    def __init__(self, recursionMode: PySide2.QtCore.QReadWriteLock.RecursionMode = ...): ...
    def lockForRead(self): ...
    def lockForWrite(self): ...
    @typing.overload
    def tryLockForRead(self) -> bool: ...
    @typing.overload
    def tryLockForRead(self, timeout: int) -> bool: ...
    @typing.overload
    def tryLockForWrite(self) -> bool: ...
    @typing.overload
    def tryLockForWrite(self, timeout: int) -> bool: ...
    def unlock(self): ...


class QRect(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QRect: PySide2.QtCore.QRect): ...
    @typing.overload
    def __init__(self, left: int, top: int, width: int, height: int): ...
    @typing.overload
    def __init__(self, topleft: PySide2.QtCore.QPoint, bottomright: PySide2.QtCore.QPoint): ...
    @typing.overload
    def __init__(self, topleft: PySide2.QtCore.QPoint, size: PySide2.QtCore.QSize): ...
    def __add__(self, margins: PySide2.QtCore.QMargins) -> PySide2.QtCore.QRect: ...
    def __and__(self, r: PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    def __copy__(self): ...
    def __iadd__(self, margins: PySide2.QtCore.QMargins) -> PySide2.QtCore.QRect: ...
    def __iand__(self, r: PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    def __ior__(self, r: PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    def __isub__(self, margins: PySide2.QtCore.QMargins) -> PySide2.QtCore.QRect: ...
    def __or__(self, r: PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __sub__(self, rhs: PySide2.QtCore.QMargins) -> PySide2.QtCore.QRect: ...
    def adjust(self, x1: int, y1: int, x2: int, y2: int): ...
    def adjusted(self, x1: int, y1: int, x2: int, y2: int) -> PySide2.QtCore.QRect: ...
    def bottom(self) -> int: ...
    def bottomLeft(self) -> PySide2.QtCore.QPoint: ...
    def bottomRight(self) -> PySide2.QtCore.QPoint: ...
    def center(self) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def contains(self, p: PySide2.QtCore.QPoint, proper: bool = ...) -> bool: ...
    @typing.overload
    def contains(self, r: PySide2.QtCore.QRect, proper: bool = ...) -> bool: ...
    @typing.overload
    def contains(self, x: int, y: int) -> bool: ...
    @typing.overload
    def contains(self, x: int, y: int, proper: bool) -> bool: ...
    def getCoords(self, x1: int, y1: int, x2: int, y2: int): ...
    def getRect(self, x: int, y: int, w: int, h: int): ...
    def height(self) -> int: ...
    def intersected(self, other: PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    def intersects(self, r: PySide2.QtCore.QRect) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    def left(self) -> int: ...
    def marginsAdded(self, margins: PySide2.QtCore.QMargins) -> PySide2.QtCore.QRect: ...
    def marginsRemoved(self, margins: PySide2.QtCore.QMargins) -> PySide2.QtCore.QRect: ...
    def moveBottom(self, pos: int): ...
    def moveBottomLeft(self, p: PySide2.QtCore.QPoint): ...
    def moveBottomRight(self, p: PySide2.QtCore.QPoint): ...
    def moveCenter(self, p: PySide2.QtCore.QPoint): ...
    def moveLeft(self, pos: int): ...
    def moveRight(self, pos: int): ...
    @typing.overload
    def moveTo(self, p: PySide2.QtCore.QPoint): ...
    @typing.overload
    def moveTo(self, x: int, t: int): ...
    def moveTop(self, pos: int): ...
    def moveTopLeft(self, p: PySide2.QtCore.QPoint): ...
    def moveTopRight(self, p: PySide2.QtCore.QPoint): ...
    def normalized(self) -> PySide2.QtCore.QRect: ...
    def right(self) -> int: ...
    def setBottom(self, pos: int): ...
    def setBottomLeft(self, p: PySide2.QtCore.QPoint): ...
    def setBottomRight(self, p: PySide2.QtCore.QPoint): ...
    def setCoords(self, x1: int, y1: int, x2: int, y2: int): ...
    def setHeight(self, h: int): ...
    def setLeft(self, pos: int): ...
    def setRect(self, x: int, y: int, w: int, h: int): ...
    def setRight(self, pos: int): ...
    def setSize(self, s: PySide2.QtCore.QSize): ...
    def setTop(self, pos: int): ...
    def setTopLeft(self, p: PySide2.QtCore.QPoint): ...
    def setTopRight(self, p: PySide2.QtCore.QPoint): ...
    def setWidth(self, w: int): ...
    def setX(self, x: int): ...
    def setY(self, y: int): ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def top(self) -> int: ...
    def topLeft(self) -> PySide2.QtCore.QPoint: ...
    def topRight(self) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def translate(self, dx: int, dy: int): ...
    @typing.overload
    def translate(self, p: PySide2.QtCore.QPoint): ...
    @typing.overload
    def translated(self, dx: int, dy: int) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def translated(self, p: PySide2.QtCore.QPoint) -> PySide2.QtCore.QRect: ...
    def transposed(self) -> PySide2.QtCore.QRect: ...
    def united(self, other: PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    def width(self) -> int: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QRectF(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QRectF: PySide2.QtCore.QRectF): ...
    @typing.overload
    def __init__(self, left: float, top: float, width: float, height: float): ...
    @typing.overload
    def __init__(self, rect: PySide2.QtCore.QRect): ...
    @typing.overload
    def __init__(self, topleft: PySide2.QtCore.QPointF, bottomRight: PySide2.QtCore.QPointF): ...
    @typing.overload
    def __init__(self, topleft: PySide2.QtCore.QPointF, size: PySide2.QtCore.QSizeF): ...
    @typing.overload
    def __add__(self, lhs: PySide2.QtCore.QMarginsF) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def __add__(self, rhs: PySide2.QtCore.QMarginsF) -> PySide2.QtCore.QRectF: ...
    def __and__(self, r: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def __copy__(self): ...
    def __iadd__(self, margins: PySide2.QtCore.QMarginsF) -> PySide2.QtCore.QRectF: ...
    def __iand__(self, r: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def __ior__(self, r: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def __isub__(self, margins: PySide2.QtCore.QMarginsF) -> PySide2.QtCore.QRectF: ...
    def __or__(self, r: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __sub__(self, rhs: PySide2.QtCore.QMarginsF) -> PySide2.QtCore.QRectF: ...
    def adjust(self, x1: float, y1: float, x2: float, y2: float): ...
    def adjusted(self, x1: float, y1: float, x2: float, y2: float) -> PySide2.QtCore.QRectF: ...
    def bottom(self) -> float: ...
    def bottomLeft(self) -> PySide2.QtCore.QPointF: ...
    def bottomRight(self) -> PySide2.QtCore.QPointF: ...
    def center(self) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def contains(self, p: PySide2.QtCore.QPointF) -> bool: ...
    @typing.overload
    def contains(self, r: PySide2.QtCore.QRectF) -> bool: ...
    @typing.overload
    def contains(self, x: float, y: float) -> bool: ...
    def getCoords(self, x1: float, y1: float, x2: float, y2: float): ...
    def getRect(self, x: float, y: float, w: float, h: float): ...
    def height(self) -> float: ...
    def intersected(self, other: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def intersects(self, r: PySide2.QtCore.QRectF) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    def left(self) -> float: ...
    def marginsAdded(self, margins: PySide2.QtCore.QMarginsF) -> PySide2.QtCore.QRectF: ...
    def marginsRemoved(self, margins: PySide2.QtCore.QMarginsF) -> PySide2.QtCore.QRectF: ...
    def moveBottom(self, pos: float): ...
    def moveBottomLeft(self, p: PySide2.QtCore.QPointF): ...
    def moveBottomRight(self, p: PySide2.QtCore.QPointF): ...
    def moveCenter(self, p: PySide2.QtCore.QPointF): ...
    def moveLeft(self, pos: float): ...
    def moveRight(self, pos: float): ...
    @typing.overload
    def moveTo(self, p: PySide2.QtCore.QPointF): ...
    @typing.overload
    def moveTo(self, x: float, y: float): ...
    def moveTop(self, pos: float): ...
    def moveTopLeft(self, p: PySide2.QtCore.QPointF): ...
    def moveTopRight(self, p: PySide2.QtCore.QPointF): ...
    def normalized(self) -> PySide2.QtCore.QRectF: ...
    def right(self) -> float: ...
    def setBottom(self, pos: float): ...
    def setBottomLeft(self, p: PySide2.QtCore.QPointF): ...
    def setBottomRight(self, p: PySide2.QtCore.QPointF): ...
    def setCoords(self, x1: float, y1: float, x2: float, y2: float): ...
    def setHeight(self, h: float): ...
    def setLeft(self, pos: float): ...
    def setRect(self, x: float, y: float, w: float, h: float): ...
    def setRight(self, pos: float): ...
    def setSize(self, s: PySide2.QtCore.QSizeF): ...
    def setTop(self, pos: float): ...
    def setTopLeft(self, p: PySide2.QtCore.QPointF): ...
    def setTopRight(self, p: PySide2.QtCore.QPointF): ...
    def setWidth(self, w: float): ...
    def setX(self, pos: float): ...
    def setY(self, pos: float): ...
    def size(self) -> PySide2.QtCore.QSizeF: ...
    def toAlignedRect(self) -> PySide2.QtCore.QRect: ...
    def toRect(self) -> PySide2.QtCore.QRect: ...
    def top(self) -> float: ...
    def topLeft(self) -> PySide2.QtCore.QPointF: ...
    def topRight(self) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def translate(self, dx: float, dy: float): ...
    @typing.overload
    def translate(self, p: PySide2.QtCore.QPointF): ...
    @typing.overload
    def translated(self, dx: float, dy: float) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def translated(self, p: PySide2.QtCore.QPointF) -> PySide2.QtCore.QRectF: ...
    def transposed(self) -> PySide2.QtCore.QRectF: ...
    def united(self, other: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def width(self) -> float: ...
    def x(self) -> float: ...
    def y(self) -> float: ...


class QRegExp(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, pattern: str, cs: PySide2.QtCore.Qt.CaseSensitivity = ..., syntax: PySide2.QtCore.QRegExp.PatternSyntax = ...): ...
    @typing.overload
    def __init__(self, rx: PySide2.QtCore.QRegExp): ...
    def __copy__(self): ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def cap(self, nth: int = ...) -> str: ...
    def captureCount(self) -> int: ...
    def capturedTexts(self) -> typing.List[str]: ...
    def caseSensitivity(self) -> PySide2.QtCore.Qt.CaseSensitivity: ...
    def errorString(self) -> str: ...
    @staticmethod
    def escape(str: str) -> str: ...
    def exactMatch(self, str: str) -> bool: ...
    def indexIn(self, str: str, offset: int = ..., caretMode: PySide2.QtCore.QRegExp.CaretMode = ...) -> int: ...
    def isEmpty(self) -> bool: ...
    def isMinimal(self) -> bool: ...
    def isValid(self) -> bool: ...
    def lastIndexIn(self, str: str, offset: int = ..., caretMode: PySide2.QtCore.QRegExp.CaretMode = ...) -> int: ...
    def matchedLength(self) -> int: ...
    def pattern(self) -> str: ...
    def patternSyntax(self) -> PySide2.QtCore.QRegExp.PatternSyntax: ...
    def pos(self, nth: int = ...) -> int: ...
    def replace(self, sourceString: str, after: str) -> str: ...
    def setCaseSensitivity(self, cs: PySide2.QtCore.Qt.CaseSensitivity): ...
    def setMinimal(self, minimal: bool): ...
    def setPattern(self, pattern: str): ...
    def setPatternSyntax(self, syntax: PySide2.QtCore.QRegExp.PatternSyntax): ...
    def swap(self, other: PySide2.QtCore.QRegExp): ...


class QRegularExpression(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, pattern: str, options: PySide2.QtCore.QRegularExpression.PatternOptions = ...): ...
    @typing.overload
    def __init__(self, re: PySide2.QtCore.QRegularExpression): ...
    def __copy__(self): ...
    @staticmethod
    def anchoredPattern(expression: str) -> str: ...
    def captureCount(self) -> int: ...
    def errorString(self) -> str: ...
    @staticmethod
    def escape(str: str) -> str: ...
    @typing.overload
    def globalMatch(self, subject: str, offset: int = ..., matchType: PySide2.QtCore.QRegularExpression.MatchType = ..., matchOptions: PySide2.QtCore.QRegularExpression.MatchOptions = ...) -> PySide2.QtCore.QRegularExpressionMatchIterator: ...
    @typing.overload
    def globalMatch(self, subjectRef: str, offset: int = ..., matchType: PySide2.QtCore.QRegularExpression.MatchType = ..., matchOptions: PySide2.QtCore.QRegularExpression.MatchOptions = ...) -> PySide2.QtCore.QRegularExpressionMatchIterator: ...
    def isValid(self) -> bool: ...
    @typing.overload
    def match(self, subject: str, offset: int = ..., matchType: PySide2.QtCore.QRegularExpression.MatchType = ..., matchOptions: PySide2.QtCore.QRegularExpression.MatchOptions = ...) -> PySide2.QtCore.QRegularExpressionMatch: ...
    @typing.overload
    def match(self, subjectRef: str, offset: int = ..., matchType: PySide2.QtCore.QRegularExpression.MatchType = ..., matchOptions: PySide2.QtCore.QRegularExpression.MatchOptions = ...) -> PySide2.QtCore.QRegularExpressionMatch: ...
    def namedCaptureGroups(self) -> typing.List[str]: ...
    def optimize(self): ...
    def pattern(self) -> str: ...
    def patternErrorOffset(self) -> int: ...
    def patternOptions(self) -> PySide2.QtCore.QRegularExpression.PatternOptions: ...
    def setPattern(self, pattern: str): ...
    def setPatternOptions(self, options: PySide2.QtCore.QRegularExpression.PatternOptions): ...
    def swap(self, other: PySide2.QtCore.QRegularExpression): ...
    @staticmethod
    def wildcardToRegularExpression(str: str) -> str: ...


class QRegularExpressionMatch(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, match: PySide2.QtCore.QRegularExpressionMatch): ...
    def __copy__(self): ...
    @typing.overload
    def captured(self, name: str) -> str: ...
    @typing.overload
    def captured(self, nth: int = ...) -> str: ...
    @typing.overload
    def capturedEnd(self, name: str) -> int: ...
    @typing.overload
    def capturedEnd(self, nth: int = ...) -> int: ...
    @typing.overload
    def capturedLength(self, name: str) -> int: ...
    @typing.overload
    def capturedLength(self, nth: int = ...) -> int: ...
    @typing.overload
    def capturedRef(self, name: str) -> str: ...
    @typing.overload
    def capturedRef(self, nth: int = ...) -> str: ...
    @typing.overload
    def capturedStart(self, name: str) -> int: ...
    @typing.overload
    def capturedStart(self, nth: int = ...) -> int: ...
    def capturedTexts(self) -> typing.List[str]: ...
    def hasMatch(self) -> bool: ...
    def hasPartialMatch(self) -> bool: ...
    def isValid(self) -> bool: ...
    def lastCapturedIndex(self) -> int: ...
    def matchOptions(self) -> PySide2.QtCore.QRegularExpression.MatchOptions: ...
    def matchType(self) -> PySide2.QtCore.QRegularExpression.MatchType: ...
    def regularExpression(self) -> PySide2.QtCore.QRegularExpression: ...
    def swap(self, other: PySide2.QtCore.QRegularExpressionMatch): ...


class QRegularExpressionMatchIterator(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, iterator: PySide2.QtCore.QRegularExpressionMatchIterator): ...
    def __copy__(self): ...
    def hasNext(self) -> bool: ...
    def isValid(self) -> bool: ...
    def matchOptions(self) -> PySide2.QtCore.QRegularExpression.MatchOptions: ...
    def matchType(self) -> PySide2.QtCore.QRegularExpression.MatchType: ...
    def next(self) -> PySide2.QtCore.QRegularExpressionMatch: ...
    def peekNext(self) -> PySide2.QtCore.QRegularExpressionMatch: ...
    def regularExpression(self) -> PySide2.QtCore.QRegularExpression: ...
    def swap(self, other: PySide2.QtCore.QRegularExpressionMatchIterator): ...


class QResource(Shiboken.Object):

    def __init__(self, file: str = ..., locale: PySide2.QtCore.QLocale = ...): ...
    def absoluteFilePath(self) -> str: ...
    @staticmethod
    def addSearchPath(path: str): ...
    def children(self) -> typing.List[str]: ...
    def data(self) -> typing.Char: ...
    def fileName(self) -> str: ...
    def isCompressed(self) -> bool: ...
    def isDir(self) -> bool: ...
    def isFile(self) -> bool: ...
    def isValid(self) -> bool: ...
    def lastModified(self) -> PySide2.QtCore.QDateTime: ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    @staticmethod
    def registerResource(rccFilename: str, resourceRoot: str = ...) -> bool: ...
    @staticmethod
    def registerResourceData(rccData: typing.Char, resourceRoot: str = ...) -> bool: ...
    @staticmethod
    def searchPaths() -> typing.List[str]: ...
    def setFileName(self, file: str): ...
    def setLocale(self, locale: PySide2.QtCore.QLocale): ...
    def size(self) -> int: ...
    @staticmethod
    def unregisterResource(rccFilename: str, resourceRoot: str = ...) -> bool: ...
    @staticmethod
    def unregisterResourceData(rccData: typing.Char, resourceRoot: str = ...) -> bool: ...


class QRunnable(Shiboken.Object):

    def __init__(self): ...
    def autoDelete(self) -> bool: ...
    def run(self): ...
    def setAutoDelete(self, _autoDelete: bool): ...


class QSaveFile(PySide2.QtCore.QFileDevice):

    @typing.overload
    def __init__(self, name: str): ...
    @typing.overload
    def __init__(self, name: str, parent: PySide2.QtCore.QObject): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def cancelWriting(self): ...
    def close(self): ...
    def commit(self) -> bool: ...
    def directWriteFallback(self) -> bool: ...
    def fileName(self) -> str: ...
    def open(self, flags: PySide2.QtCore.QIODevice.OpenMode) -> bool: ...
    def setDirectWriteFallback(self, enabled: bool): ...
    def setFileName(self, name: str): ...
    def writeData(self, data: str, len: int) -> int: ...


class QSemaphore(Shiboken.Object):

    def __init__(self, n: int = ...): ...
    def acquire(self, n: int = ...): ...
    def available(self) -> int: ...
    def release(self, n: int = ...): ...
    @typing.overload
    def tryAcquire(self, n: int, timeout: int) -> bool: ...
    @typing.overload
    def tryAcquire(self, n: int = ...) -> bool: ...


class QSemaphoreReleaser(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, sem: PySide2.QtCore.QSemaphore, n: int = ...): ...
    def cancel(self) -> PySide2.QtCore.QSemaphore: ...
    def semaphore(self) -> PySide2.QtCore.QSemaphore: ...
    def swap(self, other: PySide2.QtCore.QSemaphoreReleaser): ...


class QSequentialAnimationGroup(PySide2.QtCore.QAnimationGroup):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def addPause(self, msecs: int) -> PySide2.QtCore.QPauseAnimation: ...
    def currentAnimation(self) -> PySide2.QtCore.QAbstractAnimation: ...
    def duration(self) -> int: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def insertPause(self, index: int, msecs: int) -> PySide2.QtCore.QPauseAnimation: ...
    def updateCurrentTime(self, arg__1: int): ...
    def updateDirection(self, direction: PySide2.QtCore.QAbstractAnimation.Direction): ...
    def updateState(self, newState: PySide2.QtCore.QAbstractAnimation.State, oldState: PySide2.QtCore.QAbstractAnimation.State): ...


class QSettings(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, fileName: str, format: PySide2.QtCore.QSettings.Format, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, format: PySide2.QtCore.QSettings.Format, scope: PySide2.QtCore.QSettings.Scope, organization: str, application: str = ..., parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, organization: str, application: str = ..., parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, scope: PySide2.QtCore.QSettings.Scope, organization: str, application: str = ..., parent: PySide2.QtCore.QObject = ...): ...
    def allKeys(self) -> typing.List[str]: ...
    def applicationName(self) -> str: ...
    def beginGroup(self, prefix: str): ...
    def beginReadArray(self, prefix: str) -> int: ...
    def beginWriteArray(self, prefix: str, size: int = ...): ...
    def childGroups(self) -> typing.List[str]: ...
    def childKeys(self) -> typing.List[str]: ...
    def clear(self): ...
    def contains(self, key: str) -> bool: ...
    @staticmethod
    def defaultFormat() -> PySide2.QtCore.QSettings.Format: ...
    def endArray(self): ...
    def endGroup(self): ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def fallbacksEnabled(self) -> bool: ...
    def fileName(self) -> str: ...
    def format(self) -> PySide2.QtCore.QSettings.Format: ...
    def group(self) -> str: ...
    def iniCodec(self) -> PySide2.QtCore.QTextCodec: ...
    def isAtomicSyncRequired(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def organizationName(self) -> str: ...
    def remove(self, key: str): ...
    def scope(self) -> PySide2.QtCore.QSettings.Scope: ...
    def setArrayIndex(self, i: int): ...
    def setAtomicSyncRequired(self, enable: bool): ...
    @staticmethod
    def setDefaultFormat(format: PySide2.QtCore.QSettings.Format): ...
    def setFallbacksEnabled(self, b: bool): ...
    @typing.overload
    def setIniCodec(self, codec: PySide2.QtCore.QTextCodec): ...
    @typing.overload
    def setIniCodec(self, codecName: str): ...
    @staticmethod
    def setPath(format: PySide2.QtCore.QSettings.Format, scope: PySide2.QtCore.QSettings.Scope, path: str): ...
    def setValue(self, key: str, value: typing.Any): ...
    def status(self) -> PySide2.QtCore.QSettings.Status: ...
    def sync(self): ...
    def value(self, arg__1: str, defaultValue: typing.Any = ..., type: object = ...) -> object: ...


class QSignalBlocker(Shiboken.Object):

    def __init__(self, o: PySide2.QtCore.QObject): ...
    def reblock(self): ...
    def unblock(self): ...


class QSignalMapper(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def map(self): ...
    @typing.overload
    def map(self, sender: PySide2.QtCore.QObject): ...
    @typing.overload
    def mapping(self, id: int) -> PySide2.QtCore.QObject: ...
    @typing.overload
    def mapping(self, object: PySide2.QtCore.QObject) -> PySide2.QtCore.QObject: ...
    @typing.overload
    def mapping(self, text: str) -> PySide2.QtCore.QObject: ...
    def removeMappings(self, sender: PySide2.QtCore.QObject): ...
    @typing.overload
    def setMapping(self, sender: PySide2.QtCore.QObject, id: int): ...
    @typing.overload
    def setMapping(self, sender: PySide2.QtCore.QObject, object: PySide2.QtCore.QObject): ...
    @typing.overload
    def setMapping(self, sender: PySide2.QtCore.QObject, text: str): ...


class QSignalTransition(PySide2.QtCore.QAbstractTransition):

    @typing.overload
    def __init__(self, arg__1: object, arg__2: PySide2.QtCore.QState = ...) -> PySide2.QtCore.QSignalTransition: ...
    @typing.overload
    def __init__(self, sender: PySide2.QtCore.QObject, signal: str, sourceState: PySide2.QtCore.QState = ...): ...
    @typing.overload
    def __init__(self, sourceState: PySide2.QtCore.QState = ...): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def eventTest(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def onTransition(self, event: PySide2.QtCore.QEvent): ...
    def senderObject(self) -> PySide2.QtCore.QObject: ...
    def setSenderObject(self, sender: PySide2.QtCore.QObject): ...
    def setSignal(self, signal: PySide2.QtCore.QByteArray): ...
    def signal(self) -> PySide2.QtCore.QByteArray: ...


class QSize(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QSize: PySide2.QtCore.QSize): ...
    @typing.overload
    def __init__(self, w: int, h: int): ...
    def __add__(self, s2: PySide2.QtCore.QSize) -> PySide2.QtCore.QSize: ...
    def __copy__(self): ...
    def __iadd__(self, arg__1: PySide2.QtCore.QSize) -> PySide2.QtCore.QSize: ...
    def __imul__(self, c: float) -> PySide2.QtCore.QSize: ...
    def __isub__(self, arg__1: PySide2.QtCore.QSize) -> PySide2.QtCore.QSize: ...
    def __mul__(self, c: float) -> PySide2.QtCore.QSize: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __sub__(self, s2: PySide2.QtCore.QSize) -> PySide2.QtCore.QSize: ...
    def boundedTo(self, arg__1: PySide2.QtCore.QSize) -> PySide2.QtCore.QSize: ...
    def expandedTo(self, arg__1: PySide2.QtCore.QSize) -> PySide2.QtCore.QSize: ...
    def height(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    @typing.overload
    def scale(self, s: PySide2.QtCore.QSize, mode: PySide2.QtCore.Qt.AspectRatioMode): ...
    @typing.overload
    def scale(self, w: int, h: int, mode: PySide2.QtCore.Qt.AspectRatioMode): ...
    @typing.overload
    def scaled(self, s: PySide2.QtCore.QSize, mode: PySide2.QtCore.Qt.AspectRatioMode) -> PySide2.QtCore.QSize: ...
    @typing.overload
    def scaled(self, w: int, h: int, mode: PySide2.QtCore.Qt.AspectRatioMode) -> PySide2.QtCore.QSize: ...
    def setHeight(self, h: int): ...
    def setWidth(self, w: int): ...
    def toTuple(self) -> object: ...
    def transpose(self): ...
    def transposed(self) -> PySide2.QtCore.QSize: ...
    def width(self) -> int: ...


class QSizeF(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QSizeF: PySide2.QtCore.QSizeF): ...
    @typing.overload
    def __init__(self, sz: PySide2.QtCore.QSize): ...
    @typing.overload
    def __init__(self, w: float, h: float): ...
    def __add__(self, s2: PySide2.QtCore.QSizeF) -> PySide2.QtCore.QSizeF: ...
    def __copy__(self): ...
    def __iadd__(self, arg__1: PySide2.QtCore.QSizeF) -> PySide2.QtCore.QSizeF: ...
    def __imul__(self, c: float) -> PySide2.QtCore.QSizeF: ...
    def __isub__(self, arg__1: PySide2.QtCore.QSizeF) -> PySide2.QtCore.QSizeF: ...
    def __mul__(self, c: float) -> PySide2.QtCore.QSizeF: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __sub__(self, s2: PySide2.QtCore.QSizeF) -> PySide2.QtCore.QSizeF: ...
    def boundedTo(self, arg__1: PySide2.QtCore.QSizeF) -> PySide2.QtCore.QSizeF: ...
    def expandedTo(self, arg__1: PySide2.QtCore.QSizeF) -> PySide2.QtCore.QSizeF: ...
    def height(self) -> float: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    @typing.overload
    def scale(self, s: PySide2.QtCore.QSizeF, mode: PySide2.QtCore.Qt.AspectRatioMode): ...
    @typing.overload
    def scale(self, w: float, h: float, mode: PySide2.QtCore.Qt.AspectRatioMode): ...
    @typing.overload
    def scaled(self, s: PySide2.QtCore.QSizeF, mode: PySide2.QtCore.Qt.AspectRatioMode) -> PySide2.QtCore.QSizeF: ...
    @typing.overload
    def scaled(self, w: float, h: float, mode: PySide2.QtCore.Qt.AspectRatioMode) -> PySide2.QtCore.QSizeF: ...
    def setHeight(self, h: float): ...
    def setWidth(self, w: float): ...
    def toSize(self) -> PySide2.QtCore.QSize: ...
    def toTuple(self) -> object: ...
    def transpose(self): ...
    def transposed(self) -> PySide2.QtCore.QSizeF: ...
    def width(self) -> float: ...


class QSocketNotifier(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, arg__1: object, arg__2: PySide2.QtCore.QSocketNotifier.Type, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, socket: int, arg__2: PySide2.QtCore.QSocketNotifier.Type, parent: PySide2.QtCore.QObject = ...): ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def isEnabled(self) -> bool: ...
    def setEnabled(self, arg__1: bool): ...
    def socket(self) -> int: ...
    def type(self) -> PySide2.QtCore.QSocketNotifier.Type: ...


class QSortFilterProxyModel(PySide2.QtCore.QAbstractProxyModel):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def buddy(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def canFetchMore(self, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def columnCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def data(self, index: PySide2.QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def dropMimeData(self, data: PySide2.QtCore.QMimeData, action: PySide2.QtCore.Qt.DropAction, row: int, column: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def dynamicSortFilter(self) -> bool: ...
    def fetchMore(self, parent: PySide2.QtCore.QModelIndex): ...
    def filterAcceptsColumn(self, source_column: int, source_parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def filterAcceptsRow(self, source_row: int, source_parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def filterCaseSensitivity(self) -> PySide2.QtCore.Qt.CaseSensitivity: ...
    def filterKeyColumn(self) -> int: ...
    def filterRegExp(self) -> PySide2.QtCore.QRegExp: ...
    def filterRegularExpression(self) -> PySide2.QtCore.QRegularExpression: ...
    def filterRole(self) -> int: ...
    def flags(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.Qt.ItemFlags: ...
    def hasChildren(self, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def headerData(self, section: int, orientation: PySide2.QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def index(self, row: int, column: int, parent: PySide2.QtCore.QModelIndex = ...) -> PySide2.QtCore.QModelIndex: ...
    def insertColumns(self, column: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def insertRows(self, row: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def invalidate(self): ...
    def invalidateFilter(self): ...
    def isRecursiveFilteringEnabled(self) -> bool: ...
    def isSortLocaleAware(self) -> bool: ...
    def lessThan(self, source_left: PySide2.QtCore.QModelIndex, source_right: PySide2.QtCore.QModelIndex) -> bool: ...
    def mapFromSource(self, sourceIndex: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def mapSelectionFromSource(self, sourceSelection: PySide2.QtCore.QItemSelection) -> PySide2.QtCore.QItemSelection: ...
    def mapSelectionToSource(self, proxySelection: PySide2.QtCore.QItemSelection) -> PySide2.QtCore.QItemSelection: ...
    def mapToSource(self, proxyIndex: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def match(self, start: PySide2.QtCore.QModelIndex, role: int, value: typing.Any, hits: int = ..., flags: PySide2.QtCore.Qt.MatchFlags = ...) -> typing.List[int]: ...
    def mimeData(self, indexes: typing.List[int]) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    @typing.overload
    def parent(self) -> PySide2.QtCore.QObject: ...
    @typing.overload
    def parent(self, child: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def removeColumns(self, column: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def removeRows(self, row: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def rowCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def setData(self, index: PySide2.QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def setDynamicSortFilter(self, enable: bool): ...
    def setFilterCaseSensitivity(self, cs: PySide2.QtCore.Qt.CaseSensitivity): ...
    def setFilterFixedString(self, pattern: str): ...
    def setFilterKeyColumn(self, column: int): ...
    @typing.overload
    def setFilterRegExp(self, pattern: str): ...
    @typing.overload
    def setFilterRegExp(self, regExp: PySide2.QtCore.QRegExp): ...
    @typing.overload
    def setFilterRegularExpression(self, pattern: str): ...
    @typing.overload
    def setFilterRegularExpression(self, regularExpression: PySide2.QtCore.QRegularExpression): ...
    def setFilterRole(self, role: int): ...
    def setFilterWildcard(self, pattern: str): ...
    def setHeaderData(self, section: int, orientation: PySide2.QtCore.Qt.Orientation, value: typing.Any, role: int = ...) -> bool: ...
    def setRecursiveFilteringEnabled(self, recursive: bool): ...
    def setSortCaseSensitivity(self, cs: PySide2.QtCore.Qt.CaseSensitivity): ...
    def setSortLocaleAware(self, on: bool): ...
    def setSortRole(self, role: int): ...
    def setSourceModel(self, sourceModel: PySide2.QtCore.QAbstractItemModel): ...
    def sibling(self, row: int, column: int, idx: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def sort(self, column: int, order: PySide2.QtCore.Qt.SortOrder = ...): ...
    def sortCaseSensitivity(self) -> PySide2.QtCore.Qt.CaseSensitivity: ...
    def sortColumn(self) -> int: ...
    def sortOrder(self) -> PySide2.QtCore.Qt.SortOrder: ...
    def sortRole(self) -> int: ...
    def span(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QSize: ...
    def supportedDropActions(self) -> PySide2.QtCore.Qt.DropActions: ...


class QStandardPaths(Shiboken.Object):

    @staticmethod
    def displayName(type: PySide2.QtCore.QStandardPaths.StandardLocation) -> str: ...
    @staticmethod
    def enableTestMode(testMode: bool): ...
    @staticmethod
    def findExecutable(executableName: str, paths: typing.List[str] = ...) -> str: ...
    @staticmethod
    def isTestModeEnabled() -> bool: ...
    @staticmethod
    def locate(type: PySide2.QtCore.QStandardPaths.StandardLocation, fileName: str, options: PySide2.QtCore.QStandardPaths.LocateOptions = ...) -> str: ...
    @staticmethod
    def locateAll(type: PySide2.QtCore.QStandardPaths.StandardLocation, fileName: str, options: PySide2.QtCore.QStandardPaths.LocateOptions = ...) -> typing.List[str]: ...
    @staticmethod
    def setTestModeEnabled(testMode: bool): ...
    @staticmethod
    def standardLocations(type: PySide2.QtCore.QStandardPaths.StandardLocation) -> typing.List[str]: ...
    @staticmethod
    def writableLocation(type: PySide2.QtCore.QStandardPaths.StandardLocation) -> str: ...


class QState(PySide2.QtCore.QAbstractState):

    @typing.overload
    def __init__(self, childMode: PySide2.QtCore.QState.ChildMode, parent: PySide2.QtCore.QState = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QState = ...): ...
    @typing.overload
    def addTransition(self, arg__1: object, arg__2: PySide2.QtCore.QAbstractState) -> PySide2.QtCore.QSignalTransition: ...
    @typing.overload
    def addTransition(self, sender: PySide2.QtCore.QObject, signal: str, target: PySide2.QtCore.QAbstractState) -> PySide2.QtCore.QSignalTransition: ...
    @typing.overload
    def addTransition(self, target: PySide2.QtCore.QAbstractState) -> PySide2.QtCore.QAbstractTransition: ...
    @typing.overload
    def addTransition(self, transition: PySide2.QtCore.QAbstractTransition): ...
    def assignProperty(self, object: PySide2.QtCore.QObject, name: str, value: typing.Any): ...
    def childMode(self) -> PySide2.QtCore.QState.ChildMode: ...
    def errorState(self) -> PySide2.QtCore.QAbstractState: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def initialState(self) -> PySide2.QtCore.QAbstractState: ...
    def onEntry(self, event: PySide2.QtCore.QEvent): ...
    def onExit(self, event: PySide2.QtCore.QEvent): ...
    def removeTransition(self, transition: PySide2.QtCore.QAbstractTransition): ...
    def setChildMode(self, mode: PySide2.QtCore.QState.ChildMode): ...
    def setErrorState(self, state: PySide2.QtCore.QAbstractState): ...
    def setInitialState(self, state: PySide2.QtCore.QAbstractState): ...
    def transitions(self) -> typing.List[PySide2.QtCore.QAbstractTransition]: ...


class QStateMachine(PySide2.QtCore.QState):

    @typing.overload
    def __init__(self, childMode: PySide2.QtCore.QState.ChildMode, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def addDefaultAnimation(self, animation: PySide2.QtCore.QAbstractAnimation): ...
    def addState(self, state: PySide2.QtCore.QAbstractState): ...
    def beginMicrostep(self, event: PySide2.QtCore.QEvent): ...
    def beginSelectTransitions(self, event: PySide2.QtCore.QEvent): ...
    def cancelDelayedEvent(self, id: int) -> bool: ...
    def clearError(self): ...
    @typing.overload
    def configuration(self) -> typing.Set[PySide2.QtCore.QAbstractState]: ...
    @typing.overload
    def configuration(self) -> typing.List[PySide2.QtCore.QAbstractState]: ...
    def defaultAnimations(self) -> typing.List[PySide2.QtCore.QAbstractAnimation]: ...
    def endMicrostep(self, event: PySide2.QtCore.QEvent): ...
    def endSelectTransitions(self, event: PySide2.QtCore.QEvent): ...
    def error(self) -> PySide2.QtCore.QStateMachine.Error: ...
    def errorString(self) -> str: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, watched: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def globalRestorePolicy(self) -> PySide2.QtCore.QState.RestorePolicy: ...
    def isAnimated(self) -> bool: ...
    def isRunning(self) -> bool: ...
    def onEntry(self, event: PySide2.QtCore.QEvent): ...
    def onExit(self, event: PySide2.QtCore.QEvent): ...
    def postDelayedEvent(self, event: PySide2.QtCore.QEvent, delay: int) -> int: ...
    def postEvent(self, event: PySide2.QtCore.QEvent, priority: PySide2.QtCore.QStateMachine.EventPriority = ...): ...
    def removeDefaultAnimation(self, animation: PySide2.QtCore.QAbstractAnimation): ...
    def removeState(self, state: PySide2.QtCore.QAbstractState): ...
    def setAnimated(self, enabled: bool): ...
    def setGlobalRestorePolicy(self, restorePolicy: PySide2.QtCore.QState.RestorePolicy): ...
    def setRunning(self, running: bool): ...
    def start(self): ...
    def stop(self): ...

    class SignalEvent(PySide2.QtCore.QEvent):

        @typing.overload
        def __init__(self, SignalEvent: PySide2.QtCore.QStateMachine.SignalEvent): ...
        @typing.overload
        def __init__(self, sender: PySide2.QtCore.QObject, signalIndex: int, arguments: typing.List[typing.Any]): ...
        def __copy__(self): ...
        def arguments(self) -> typing.List[typing.Any]: ...
        def sender(self) -> PySide2.QtCore.QObject: ...
        def signalIndex(self) -> int: ...

    class WrappedEvent(PySide2.QtCore.QEvent):

        @typing.overload
        def __init__(self, WrappedEvent: PySide2.QtCore.QStateMachine.WrappedEvent): ...
        @typing.overload
        def __init__(self, object: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent): ...
        def __copy__(self): ...
        def event(self) -> PySide2.QtCore.QEvent: ...
        def object(self) -> PySide2.QtCore.QObject: ...


class QStorageInfo(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, dir: PySide2.QtCore.QDir): ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QStorageInfo): ...
    @typing.overload
    def __init__(self, path: str): ...
    def __copy__(self): ...
    def blockSize(self) -> int: ...
    def bytesAvailable(self) -> int: ...
    def bytesFree(self) -> int: ...
    def bytesTotal(self) -> int: ...
    def device(self) -> PySide2.QtCore.QByteArray: ...
    def displayName(self) -> str: ...
    def fileSystemType(self) -> PySide2.QtCore.QByteArray: ...
    def isReadOnly(self) -> bool: ...
    def isReady(self) -> bool: ...
    def isRoot(self) -> bool: ...
    def isValid(self) -> bool: ...
    @staticmethod
    def mountedVolumes() -> typing.List[PySide2.QtCore.QStorageInfo]: ...
    def name(self) -> str: ...
    def refresh(self): ...
    @staticmethod
    def root() -> PySide2.QtCore.QStorageInfo: ...
    def rootPath(self) -> str: ...
    def setPath(self, path: str): ...
    def subvolume(self) -> PySide2.QtCore.QByteArray: ...
    def swap(self, other: PySide2.QtCore.QStorageInfo): ...


class QStringListModel(PySide2.QtCore.QAbstractListModel):

    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, strings: typing.List[str], parent: PySide2.QtCore.QObject = ...): ...
    def data(self, index: PySide2.QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def flags(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.Qt.ItemFlags: ...
    def insertRows(self, row: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def removeRows(self, row: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def rowCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def setData(self, index: PySide2.QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def setStringList(self, strings: typing.List[str]): ...
    def sibling(self, row: int, column: int, idx: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def sort(self, column: int, order: PySide2.QtCore.Qt.SortOrder = ...): ...
    def stringList(self) -> typing.List[str]: ...
    def supportedDropActions(self) -> PySide2.QtCore.Qt.DropActions: ...


class QSysInfo(Shiboken.Object):

    def __init__(self): ...
    @staticmethod
    def bootUniqueId() -> PySide2.QtCore.QByteArray: ...
    @staticmethod
    def buildAbi() -> str: ...
    @staticmethod
    def buildCpuArchitecture() -> str: ...
    @staticmethod
    def currentCpuArchitecture() -> str: ...
    @staticmethod
    def kernelType() -> str: ...
    @staticmethod
    def kernelVersion() -> str: ...
    @staticmethod
    def machineHostName() -> str: ...
    @staticmethod
    def machineUniqueId() -> PySide2.QtCore.QByteArray: ...
    @staticmethod
    def prettyProductName() -> str: ...
    @staticmethod
    def productType() -> str: ...
    @staticmethod
    def productVersion() -> str: ...


class QSystemSemaphore(Shiboken.Object):

    def __init__(self, key: str, initialValue: int = ..., mode: PySide2.QtCore.QSystemSemaphore.AccessMode = ...): ...
    def acquire(self) -> bool: ...
    def error(self) -> PySide2.QtCore.QSystemSemaphore.SystemSemaphoreError: ...
    def errorString(self) -> str: ...
    def key(self) -> str: ...
    def release(self, n: int = ...) -> bool: ...
    def setKey(self, key: str, initialValue: int = ..., mode: PySide2.QtCore.QSystemSemaphore.AccessMode = ...): ...


class QTemporaryDir(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, templateName: str): ...
    def autoRemove(self) -> bool: ...
    def errorString(self) -> str: ...
    def filePath(self, fileName: str) -> str: ...
    def isValid(self) -> bool: ...
    def path(self) -> str: ...
    def remove(self) -> bool: ...
    def setAutoRemove(self, b: bool): ...


class QTemporaryFile(PySide2.QtCore.QFile):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject): ...
    @typing.overload
    def __init__(self, templateName: str): ...
    @typing.overload
    def __init__(self, templateName: str, parent: PySide2.QtCore.QObject): ...
    def autoRemove(self) -> bool: ...
    @typing.overload
    @staticmethod
    def createLocalFile(file: PySide2.QtCore.QFile) -> PySide2.QtCore.QTemporaryFile: ...
    @typing.overload
    @staticmethod
    def createLocalFile(fileName: str) -> PySide2.QtCore.QTemporaryFile: ...
    @typing.overload
    @staticmethod
    def createNativeFile(file: PySide2.QtCore.QFile) -> PySide2.QtCore.QTemporaryFile: ...
    @typing.overload
    @staticmethod
    def createNativeFile(fileName: str) -> PySide2.QtCore.QTemporaryFile: ...
    def fileName(self) -> str: ...
    def fileTemplate(self) -> str: ...
    @typing.overload
    def open(self) -> bool: ...
    @typing.overload
    def open(self, flags: PySide2.QtCore.QIODevice.OpenMode) -> bool: ...
    def rename(self, newName: str) -> bool: ...
    def setAutoRemove(self, b: bool): ...
    def setFileTemplate(self, name: str): ...


class QTextBoundaryFinder(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QTextBoundaryFinder): ...
    @typing.overload
    def __init__(self, type: PySide2.QtCore.QTextBoundaryFinder.BoundaryType, string: str): ...
    def __copy__(self): ...
    def boundaryReasons(self) -> PySide2.QtCore.QTextBoundaryFinder.BoundaryReasons: ...
    def isAtBoundary(self) -> bool: ...
    def isValid(self) -> bool: ...
    def position(self) -> int: ...
    def setPosition(self, position: int): ...
    def string(self) -> str: ...
    def toEnd(self): ...
    def toNextBoundary(self) -> int: ...
    def toPreviousBoundary(self) -> int: ...
    def toStart(self): ...
    def type(self) -> PySide2.QtCore.QTextBoundaryFinder.BoundaryType: ...


class QTextCodec(Shiboken.Object):

    def __init__(self): ...
    def aliases(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    @staticmethod
    def availableCodecs() -> typing.List[PySide2.QtCore.QByteArray]: ...
    @staticmethod
    def availableMibs() -> typing.List[int]: ...
    @typing.overload
    def canEncode(self, arg__1: typing.Char) -> bool: ...
    @typing.overload
    def canEncode(self, arg__1: str) -> bool: ...
    @typing.overload
    @staticmethod
    def codecForHtml(ba: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QTextCodec: ...
    @typing.overload
    @staticmethod
    def codecForHtml(ba: PySide2.QtCore.QByteArray, defaultCodec: PySide2.QtCore.QTextCodec) -> PySide2.QtCore.QTextCodec: ...
    @staticmethod
    def codecForLocale() -> PySide2.QtCore.QTextCodec: ...
    @staticmethod
    def codecForMib(mib: int) -> PySide2.QtCore.QTextCodec: ...
    @typing.overload
    @staticmethod
    def codecForName(name: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QTextCodec: ...
    @typing.overload
    @staticmethod
    def codecForName(name: str) -> PySide2.QtCore.QTextCodec: ...
    @typing.overload
    @staticmethod
    def codecForUtfText(ba: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QTextCodec: ...
    @typing.overload
    @staticmethod
    def codecForUtfText(ba: PySide2.QtCore.QByteArray, defaultCodec: PySide2.QtCore.QTextCodec) -> PySide2.QtCore.QTextCodec: ...
    def convertToUnicode(self, in_: str, length: int, state: PySide2.QtCore.QTextCodec.ConverterState) -> str: ...
    def fromUnicode(self, uc: str) -> PySide2.QtCore.QByteArray: ...
    def makeDecoder(self, flags: PySide2.QtCore.QTextCodec.ConversionFlags = ...) -> PySide2.QtCore.QTextDecoder: ...
    def makeEncoder(self, flags: PySide2.QtCore.QTextCodec.ConversionFlags = ...) -> PySide2.QtCore.QTextEncoder: ...
    def mibEnum(self) -> int: ...
    def name(self) -> PySide2.QtCore.QByteArray: ...
    @staticmethod
    def setCodecForLocale(c: PySide2.QtCore.QTextCodec): ...
    @typing.overload
    def toUnicode(self, arg__1: PySide2.QtCore.QByteArray) -> str: ...
    @typing.overload
    def toUnicode(self, chars: str) -> str: ...
    @typing.overload
    def toUnicode(self, in_: str, length: int, state: PySide2.QtCore.QTextCodec.ConverterState = ...) -> str: ...

    class ConverterState(Shiboken.Object):

        def __init__(self, f: PySide2.QtCore.QTextCodec.ConversionFlags = ...): ...


class QTextDecoder(Shiboken.Object):

    @typing.overload
    def __init__(self, codec: PySide2.QtCore.QTextCodec): ...
    @typing.overload
    def __init__(self, codec: PySide2.QtCore.QTextCodec, flags: PySide2.QtCore.QTextCodec.ConversionFlags): ...
    def hasFailure(self) -> bool: ...
    def needsMoreData(self) -> bool: ...
    def toUnicode(self, ba: PySide2.QtCore.QByteArray) -> str: ...


class QTextEncoder(Shiboken.Object):

    @typing.overload
    def __init__(self, codec: PySide2.QtCore.QTextCodec): ...
    @typing.overload
    def __init__(self, codec: PySide2.QtCore.QTextCodec, flags: PySide2.QtCore.QTextCodec.ConversionFlags): ...
    def fromUnicode(self, str: str) -> PySide2.QtCore.QByteArray: ...
    def hasFailure(self) -> bool: ...


class QTextStream(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, array: PySide2.QtCore.QByteArray, openMode: PySide2.QtCore.QIODevice.OpenMode = ...): ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice): ...
    @typing.overload
    def __lshift__(self, array: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QTextStream: ...
    @typing.overload
    def __lshift__(self, ch: typing.Char) -> PySide2.QtCore.QTextStream: ...
    @typing.overload
    def __lshift__(self, ch: typing.Char) -> PySide2.QtCore.QTextStream: ...
    @typing.overload
    def __lshift__(self, f: float) -> PySide2.QtCore.QTextStream: ...
    @typing.overload
    def __lshift__(self, i: int) -> PySide2.QtCore.QTextStream: ...
    @typing.overload
    def __lshift__(self, i: int) -> PySide2.QtCore.QTextStream: ...
    @typing.overload
    def __lshift__(self, m: PySide2.QtCore.QTextStreamManipulator) -> PySide2.QtCore.QTextStream: ...
    @typing.overload
    def __lshift__(self, s: str) -> PySide2.QtCore.QTextStream: ...
    @typing.overload
    def __lshift__(self, s: str) -> PySide2.QtCore.QTextStream: ...
    def __rshift__(self, array: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QTextStream: ...
    def atEnd(self) -> bool: ...
    def autoDetectUnicode(self) -> bool: ...
    def codec(self) -> PySide2.QtCore.QTextCodec: ...
    def device(self) -> PySide2.QtCore.QIODevice: ...
    def fieldAlignment(self) -> PySide2.QtCore.QTextStream.FieldAlignment: ...
    def fieldWidth(self) -> int: ...
    def flush(self): ...
    def generateByteOrderMark(self) -> bool: ...
    def integerBase(self) -> int: ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    def numberFlags(self) -> PySide2.QtCore.QTextStream.NumberFlags: ...
    def padChar(self) -> typing.Char: ...
    def pos(self) -> int: ...
    def read(self, maxlen: int) -> str: ...
    def readAll(self) -> str: ...
    def readLine(self, maxlen: int = ...) -> str: ...
    def realNumberNotation(self) -> PySide2.QtCore.QTextStream.RealNumberNotation: ...
    def realNumberPrecision(self) -> int: ...
    def reset(self): ...
    def resetStatus(self): ...
    def seek(self, pos: int) -> bool: ...
    def setAutoDetectUnicode(self, enabled: bool): ...
    @typing.overload
    def setCodec(self, codec: PySide2.QtCore.QTextCodec): ...
    @typing.overload
    def setCodec(self, codecName: str): ...
    def setDevice(self, device: PySide2.QtCore.QIODevice): ...
    def setFieldAlignment(self, alignment: PySide2.QtCore.QTextStream.FieldAlignment): ...
    def setFieldWidth(self, width: int): ...
    def setGenerateByteOrderMark(self, generate: bool): ...
    def setIntegerBase(self, base: int): ...
    def setLocale(self, locale: PySide2.QtCore.QLocale): ...
    def setNumberFlags(self, flags: PySide2.QtCore.QTextStream.NumberFlags): ...
    def setPadChar(self, ch: typing.Char): ...
    def setRealNumberNotation(self, notation: PySide2.QtCore.QTextStream.RealNumberNotation): ...
    def setRealNumberPrecision(self, precision: int): ...
    def setStatus(self, status: PySide2.QtCore.QTextStream.Status): ...
    def skipWhiteSpace(self): ...
    def status(self) -> PySide2.QtCore.QTextStream.Status: ...
    def string(self) -> str: ...


class QTextStreamManipulator(Shiboken.Object):

    def __copy__(self): ...
    def exec_(self, s: PySide2.QtCore.QTextStream): ...


class QThread(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    @staticmethod
    def currentThread() -> PySide2.QtCore.QThread: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def eventDispatcher(self) -> PySide2.QtCore.QAbstractEventDispatcher: ...
    def exec_(self) -> int: ...
    def exit(self, retcode: int = ...): ...
    @staticmethod
    def idealThreadCount() -> int: ...
    def isFinished(self) -> bool: ...
    def isInterruptionRequested(self) -> bool: ...
    def isRunning(self) -> bool: ...
    def loopLevel(self) -> int: ...
    @staticmethod
    def msleep(arg__1: int): ...
    def priority(self) -> PySide2.QtCore.QThread.Priority: ...
    def quit(self): ...
    def requestInterruption(self): ...
    def run(self): ...
    def setEventDispatcher(self, eventDispatcher: PySide2.QtCore.QAbstractEventDispatcher): ...
    def setPriority(self, priority: PySide2.QtCore.QThread.Priority): ...
    def setStackSize(self, stackSize: int): ...
    @staticmethod
    def setTerminationEnabled(enabled: bool = ...): ...
    @staticmethod
    def sleep(arg__1: int): ...
    def stackSize(self) -> int: ...
    def start(self, priority: PySide2.QtCore.QThread.Priority = ...): ...
    def terminate(self): ...
    @staticmethod
    def usleep(arg__1: int): ...
    def wait(self, time: int = ...) -> bool: ...
    @staticmethod
    def yieldCurrentThread(): ...


class QThreadPool(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def activeThreadCount(self) -> int: ...
    def cancel(self, runnable: PySide2.QtCore.QRunnable): ...
    def clear(self): ...
    def expiryTimeout(self) -> int: ...
    @staticmethod
    def globalInstance() -> PySide2.QtCore.QThreadPool: ...
    def maxThreadCount(self) -> int: ...
    def releaseThread(self): ...
    def reserveThread(self): ...
    def setExpiryTimeout(self, expiryTimeout: int): ...
    def setMaxThreadCount(self, maxThreadCount: int): ...
    def setStackSize(self, stackSize: int): ...
    def stackSize(self) -> int: ...
    def start(self, runnable: PySide2.QtCore.QRunnable, priority: int = ...): ...
    def tryStart(self, runnable: PySide2.QtCore.QRunnable) -> bool: ...
    def tryTake(self, runnable: PySide2.QtCore.QRunnable) -> bool: ...
    def waitForDone(self, msecs: int = ...) -> bool: ...


class QTime(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QTime: PySide2.QtCore.QTime): ...
    @typing.overload
    def __init__(self, h: int, m: int, s: int = ..., ms: int = ...): ...
    def __copy__(self): ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def addMSecs(self, ms: int) -> PySide2.QtCore.QTime: ...
    def addSecs(self, secs: int) -> PySide2.QtCore.QTime: ...
    @staticmethod
    def currentTime() -> PySide2.QtCore.QTime: ...
    def elapsed(self) -> int: ...
    @staticmethod
    def fromMSecsSinceStartOfDay(msecs: int) -> PySide2.QtCore.QTime: ...
    @typing.overload
    @staticmethod
    def fromString(s: str, f: PySide2.QtCore.Qt.DateFormat = ...) -> PySide2.QtCore.QTime: ...
    @typing.overload
    @staticmethod
    def fromString(s: str, format: str) -> PySide2.QtCore.QTime: ...
    def hour(self) -> int: ...
    def isNull(self) -> bool: ...
    @typing.overload
    @staticmethod
    def isValid() -> bool: ...
    @typing.overload
    @staticmethod
    def isValid(h: int, m: int, s: int, ms: int = ...) -> bool: ...
    def minute(self) -> int: ...
    def msec(self) -> int: ...
    def msecsSinceStartOfDay(self) -> int: ...
    def msecsTo(self, arg__1: PySide2.QtCore.QTime) -> int: ...
    def restart(self) -> int: ...
    def second(self) -> int: ...
    def secsTo(self, arg__1: PySide2.QtCore.QTime) -> int: ...
    def setHMS(self, h: int, m: int, s: int, ms: int = ...) -> bool: ...
    def start(self): ...
    def toPython(self) -> object: ...
    @typing.overload
    def toString(self, f: PySide2.QtCore.Qt.DateFormat = ...) -> str: ...
    @typing.overload
    def toString(self, format: str) -> str: ...


class QTimeLine(PySide2.QtCore.QObject):

    def __init__(self, duration: int = ..., parent: PySide2.QtCore.QObject = ...): ...
    def currentFrame(self) -> int: ...
    def currentTime(self) -> int: ...
    def currentValue(self) -> float: ...
    def curveShape(self) -> PySide2.QtCore.QTimeLine.CurveShape: ...
    def direction(self) -> PySide2.QtCore.QTimeLine.Direction: ...
    def duration(self) -> int: ...
    def easingCurve(self) -> PySide2.QtCore.QEasingCurve: ...
    def endFrame(self) -> int: ...
    def frameForTime(self, msec: int) -> int: ...
    def loopCount(self) -> int: ...
    def resume(self): ...
    def setCurrentTime(self, msec: int): ...
    def setCurveShape(self, shape: PySide2.QtCore.QTimeLine.CurveShape): ...
    def setDirection(self, direction: PySide2.QtCore.QTimeLine.Direction): ...
    def setDuration(self, duration: int): ...
    def setEasingCurve(self, curve: PySide2.QtCore.QEasingCurve): ...
    def setEndFrame(self, frame: int): ...
    def setFrameRange(self, startFrame: int, endFrame: int): ...
    def setLoopCount(self, count: int): ...
    def setPaused(self, paused: bool): ...
    def setStartFrame(self, frame: int): ...
    def setUpdateInterval(self, interval: int): ...
    def start(self): ...
    def startFrame(self) -> int: ...
    def state(self) -> PySide2.QtCore.QTimeLine.State: ...
    def stop(self): ...
    def timerEvent(self, event: PySide2.QtCore.QTimerEvent): ...
    def toggleDirection(self): ...
    def updateInterval(self) -> int: ...
    def valueForTime(self, msec: int) -> float: ...


class QTimeZone(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, ianaId: PySide2.QtCore.QByteArray): ...
    @typing.overload
    def __init__(self, offsetSeconds: int): ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QTimeZone): ...
    @typing.overload
    def __init__(self, zoneId: PySide2.QtCore.QByteArray, offsetSeconds: int, name: str, abbreviation: str, country: PySide2.QtCore.QLocale.Country = ..., comment: str = ...): ...
    def __copy__(self): ...
    def abbreviation(self, atDateTime: PySide2.QtCore.QDateTime) -> str: ...
    @typing.overload
    @staticmethod
    def availableTimeZoneIds() -> typing.List[PySide2.QtCore.QByteArray]: ...
    @typing.overload
    @staticmethod
    def availableTimeZoneIds(country: PySide2.QtCore.QLocale.Country) -> typing.List[PySide2.QtCore.QByteArray]: ...
    @typing.overload
    @staticmethod
    def availableTimeZoneIds(offsetSeconds: int) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def comment(self) -> str: ...
    def country(self) -> PySide2.QtCore.QLocale.Country: ...
    def daylightTimeOffset(self, atDateTime: PySide2.QtCore.QDateTime) -> int: ...
    @typing.overload
    def displayName(self, atDateTime: PySide2.QtCore.QDateTime, nameType: PySide2.QtCore.QTimeZone.NameType = ..., locale: PySide2.QtCore.QLocale = ...) -> str: ...
    @typing.overload
    def displayName(self, timeType: PySide2.QtCore.QTimeZone.TimeType, nameType: PySide2.QtCore.QTimeZone.NameType = ..., locale: PySide2.QtCore.QLocale = ...) -> str: ...
    def hasDaylightTime(self) -> bool: ...
    def hasTransitions(self) -> bool: ...
    @staticmethod
    def ianaIdToWindowsId(ianaId: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    def id(self) -> PySide2.QtCore.QByteArray: ...
    def isDaylightTime(self, atDateTime: PySide2.QtCore.QDateTime) -> bool: ...
    @staticmethod
    def isTimeZoneIdAvailable(ianaId: PySide2.QtCore.QByteArray) -> bool: ...
    def isValid(self) -> bool: ...
    def nextTransition(self, afterDateTime: PySide2.QtCore.QDateTime) -> PySide2.QtCore.QTimeZone.OffsetData: ...
    def offsetData(self, forDateTime: PySide2.QtCore.QDateTime) -> PySide2.QtCore.QTimeZone.OffsetData: ...
    def offsetFromUtc(self, atDateTime: PySide2.QtCore.QDateTime) -> int: ...
    def previousTransition(self, beforeDateTime: PySide2.QtCore.QDateTime) -> PySide2.QtCore.QTimeZone.OffsetData: ...
    def standardTimeOffset(self, atDateTime: PySide2.QtCore.QDateTime) -> int: ...
    def swap(self, other: PySide2.QtCore.QTimeZone): ...
    @staticmethod
    def systemTimeZone() -> PySide2.QtCore.QTimeZone: ...
    @staticmethod
    def systemTimeZoneId() -> PySide2.QtCore.QByteArray: ...
    def transitions(self, fromDateTime: PySide2.QtCore.QDateTime, toDateTime: PySide2.QtCore.QDateTime) -> typing.List[PySide2.QtCore.QTimeZone.OffsetData]: ...
    @staticmethod
    def utc() -> PySide2.QtCore.QTimeZone: ...
    @typing.overload
    @staticmethod
    def windowsIdToDefaultIanaId(windowsId: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def windowsIdToDefaultIanaId(windowsId: PySide2.QtCore.QByteArray, country: PySide2.QtCore.QLocale.Country) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def windowsIdToIanaIds(windowsId: PySide2.QtCore.QByteArray) -> typing.List[PySide2.QtCore.QByteArray]: ...
    @typing.overload
    @staticmethod
    def windowsIdToIanaIds(windowsId: PySide2.QtCore.QByteArray, country: PySide2.QtCore.QLocale.Country) -> typing.List[PySide2.QtCore.QByteArray]: ...

    class OffsetData(Shiboken.Object):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, OffsetData: PySide2.QtCore.QTimeZone.OffsetData): ...
        def __copy__(self): ...


class QTimer(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def interval(self) -> int: ...
    def isActive(self) -> bool: ...
    def isSingleShot(self) -> bool: ...
    def killTimer(self, arg__1: int): ...
    def remainingTime(self) -> int: ...
    def setInterval(self, msec: int): ...
    def setSingleShot(self, singleShot: bool): ...
    def setTimerType(self, atype: PySide2.QtCore.Qt.TimerType): ...
    @typing.overload
    @staticmethod
    def singleShot(arg__1: int, arg__2: typing.Callable): ...
    @typing.overload
    @staticmethod
    def singleShot(msec: int, receiver: PySide2.QtCore.QObject, member: str): ...
    @typing.overload
    @staticmethod
    def singleShot(msec: int, timerType: PySide2.QtCore.Qt.TimerType, receiver: PySide2.QtCore.QObject, member: str): ...
    @typing.overload
    def start(self): ...
    @typing.overload
    def start(self, msec: int): ...
    def stop(self): ...
    def timerEvent(self, arg__1: PySide2.QtCore.QTimerEvent): ...
    def timerId(self) -> int: ...
    def timerType(self) -> PySide2.QtCore.Qt.TimerType: ...


class QTimerEvent(PySide2.QtCore.QEvent):

    def __init__(self, timerId: int): ...
    def timerId(self) -> int: ...


class QTranslator(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def isEmpty(self) -> bool: ...
    @typing.overload
    def load(self, data: typing.Char, len: int, directory: str = ...) -> bool: ...
    @typing.overload
    def load(self, filename: str, directory: str = ..., search_delimiters: str = ..., suffix: str = ...) -> bool: ...
    @typing.overload
    def load(self, locale: PySide2.QtCore.QLocale, filename: str, prefix: str = ..., directory: str = ..., suffix: str = ...) -> bool: ...
    def translate(self, context: str, sourceText: str, disambiguation: str = ..., n: int = ...) -> str: ...


class QUrl(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, copy: PySide2.QtCore.QUrl): ...
    @typing.overload
    def __init__(self, url: str, mode: PySide2.QtCore.QUrl.ParsingMode = ...): ...
    def __copy__(self): ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def adjusted(self, options: PySide2.QtCore.QUrl.FormattingOptions) -> PySide2.QtCore.QUrl: ...
    def authority(self, options: PySide2.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    def clear(self): ...
    def errorString(self) -> str: ...
    def fileName(self, options: PySide2.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    def fragment(self, options: PySide2.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    @staticmethod
    def fromAce(arg__1: PySide2.QtCore.QByteArray) -> str: ...
    @staticmethod
    def fromEncoded(url: PySide2.QtCore.QByteArray, mode: PySide2.QtCore.QUrl.ParsingMode = ...) -> PySide2.QtCore.QUrl: ...
    @staticmethod
    def fromLocalFile(localfile: str) -> PySide2.QtCore.QUrl: ...
    @staticmethod
    def fromPercentEncoding(arg__1: PySide2.QtCore.QByteArray) -> str: ...
    @staticmethod
    def fromStringList(uris: typing.List[str], mode: PySide2.QtCore.QUrl.ParsingMode = ...) -> typing.List[PySide2.QtCore.QUrl]: ...
    @typing.overload
    @staticmethod
    def fromUserInput(userInput: str) -> PySide2.QtCore.QUrl: ...
    @typing.overload
    @staticmethod
    def fromUserInput(userInput: str, workingDirectory: str, options: PySide2.QtCore.QUrl.UserInputResolutionOptions = ...) -> PySide2.QtCore.QUrl: ...
    def hasFragment(self) -> bool: ...
    def hasQuery(self) -> bool: ...
    def host(self, arg__1: PySide2.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    @staticmethod
    def idnWhitelist() -> typing.List[str]: ...
    def isEmpty(self) -> bool: ...
    def isLocalFile(self) -> bool: ...
    def isParentOf(self, url: PySide2.QtCore.QUrl) -> bool: ...
    def isRelative(self) -> bool: ...
    def isValid(self) -> bool: ...
    def matches(self, url: PySide2.QtCore.QUrl, options: PySide2.QtCore.QUrl.FormattingOptions) -> bool: ...
    def password(self, arg__1: PySide2.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    def path(self, options: PySide2.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    def port(self, defaultPort: int = ...) -> int: ...
    def query(self, arg__1: PySide2.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    def resolved(self, relative: PySide2.QtCore.QUrl) -> PySide2.QtCore.QUrl: ...
    def scheme(self) -> str: ...
    def setAuthority(self, authority: str, mode: PySide2.QtCore.QUrl.ParsingMode = ...): ...
    def setFragment(self, fragment: str, mode: PySide2.QtCore.QUrl.ParsingMode = ...): ...
    def setHost(self, host: str, mode: PySide2.QtCore.QUrl.ParsingMode = ...): ...
    @staticmethod
    def setIdnWhitelist(arg__1: typing.List[str]): ...
    def setPassword(self, password: str, mode: PySide2.QtCore.QUrl.ParsingMode = ...): ...
    def setPath(self, path: str, mode: PySide2.QtCore.QUrl.ParsingMode = ...): ...
    def setPort(self, port: int): ...
    @typing.overload
    def setQuery(self, query: PySide2.QtCore.QUrlQuery): ...
    @typing.overload
    def setQuery(self, query: str, mode: PySide2.QtCore.QUrl.ParsingMode = ...): ...
    def setScheme(self, scheme: str): ...
    def setUrl(self, url: str, mode: PySide2.QtCore.QUrl.ParsingMode = ...): ...
    def setUserInfo(self, userInfo: str, mode: PySide2.QtCore.QUrl.ParsingMode = ...): ...
    def setUserName(self, userName: str, mode: PySide2.QtCore.QUrl.ParsingMode = ...): ...
    def swap(self, other: PySide2.QtCore.QUrl): ...
    @staticmethod
    def toAce(arg__1: str) -> PySide2.QtCore.QByteArray: ...
    def toDisplayString(self, options: PySide2.QtCore.QUrl.FormattingOptions = ...) -> str: ...
    def toEncoded(self, options: PySide2.QtCore.QUrl.FormattingOptions = ...) -> PySide2.QtCore.QByteArray: ...
    def toLocalFile(self) -> str: ...
    @staticmethod
    def toPercentEncoding(arg__1: str, exclude: PySide2.QtCore.QByteArray = ..., include: PySide2.QtCore.QByteArray = ...) -> PySide2.QtCore.QByteArray: ...
    def toString(self, options: PySide2.QtCore.QUrl.FormattingOptions = ...) -> str: ...
    @staticmethod
    def toStringList(uris: typing.List[PySide2.QtCore.QUrl], options: PySide2.QtCore.QUrl.FormattingOptions = ...) -> typing.List[str]: ...
    def topLevelDomain(self, options: PySide2.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    def url(self, options: PySide2.QtCore.QUrl.FormattingOptions = ...) -> str: ...
    def userInfo(self, options: PySide2.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    def userName(self, options: PySide2.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...


class QUrlQuery(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QUrlQuery): ...
    @typing.overload
    def __init__(self, queryString: str): ...
    @typing.overload
    def __init__(self, url: PySide2.QtCore.QUrl): ...
    def __copy__(self): ...
    def addQueryItem(self, key: str, value: str): ...
    def allQueryItemValues(self, key: str, encoding: PySide2.QtCore.QUrl.ComponentFormattingOption = ...) -> typing.List[str]: ...
    def clear(self): ...
    @staticmethod
    def defaultQueryPairDelimiter() -> typing.Char: ...
    @staticmethod
    def defaultQueryValueDelimiter() -> typing.Char: ...
    def hasQueryItem(self, key: str) -> bool: ...
    def isEmpty(self) -> bool: ...
    def query(self, encoding: PySide2.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    def queryItemValue(self, key: str, encoding: PySide2.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    def queryItems(self, encoding: PySide2.QtCore.QUrl.ComponentFormattingOption = ...) -> typing.List[typing.Tuple]: ...
    def queryPairDelimiter(self) -> typing.Char: ...
    def queryValueDelimiter(self) -> typing.Char: ...
    def removeAllQueryItems(self, key: str): ...
    def removeQueryItem(self, key: str): ...
    def setQuery(self, queryString: str): ...
    def setQueryDelimiters(self, valueDelimiter: typing.Char, pairDelimiter: typing.Char): ...
    def setQueryItems(self, query: typing.List[typing.Tuple]): ...
    def swap(self, other: PySide2.QtCore.QUrlQuery): ...
    def toString(self, encoding: PySide2.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...


class QUuid(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QByteArray): ...
    @typing.overload
    def __init__(self, arg__1: str): ...
    @typing.overload
    def __init__(self, arg__1: str): ...
    @typing.overload
    def __init__(self, l: int, w1: int, w2: int, b1: typing.Char, b2: typing.Char, b3: typing.Char, b4: typing.Char, b5: typing.Char, b6: typing.Char, b7: typing.Char, b8: typing.Char): ...
    def __copy__(self): ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    @staticmethod
    def createUuid() -> PySide2.QtCore.QUuid: ...
    @typing.overload
    @staticmethod
    def createUuidV3(ns: PySide2.QtCore.QUuid, baseData: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QUuid: ...
    @typing.overload
    @staticmethod
    def createUuidV3(ns: PySide2.QtCore.QUuid, baseData: str) -> PySide2.QtCore.QUuid: ...
    @typing.overload
    @staticmethod
    def createUuidV5(ns: PySide2.QtCore.QUuid, baseData: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QUuid: ...
    @typing.overload
    @staticmethod
    def createUuidV5(ns: PySide2.QtCore.QUuid, baseData: str) -> PySide2.QtCore.QUuid: ...
    @staticmethod
    def fromRfc4122(arg__1: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QUuid: ...
    def isNull(self) -> bool: ...
    @typing.overload
    def toByteArray(self) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def toByteArray(self, mode: PySide2.QtCore.QUuid.StringFormat) -> PySide2.QtCore.QByteArray: ...
    def toRfc4122(self) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def toString(self) -> str: ...
    @typing.overload
    def toString(self, mode: PySide2.QtCore.QUuid.StringFormat) -> str: ...
    def variant(self) -> PySide2.QtCore.QUuid.Variant: ...
    def version(self) -> PySide2.QtCore.QUuid.Version: ...


class QVariantAnimation(PySide2.QtCore.QAbstractAnimation):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def currentValue(self) -> typing.Any: ...
    def duration(self) -> int: ...
    def easingCurve(self) -> PySide2.QtCore.QEasingCurve: ...
    def endValue(self) -> typing.Any: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def interpolated(self, from_: typing.Any, to: typing.Any, progress: float) -> typing.Any: ...
    def keyValueAt(self, step: float) -> typing.Any: ...
    def keyValues(self) -> typing.List[typing.Tuple]: ...
    def setDuration(self, msecs: int): ...
    def setEasingCurve(self, easing: PySide2.QtCore.QEasingCurve): ...
    def setEndValue(self, value: typing.Any): ...
    def setKeyValueAt(self, step: float, value: typing.Any): ...
    def setKeyValues(self, values: typing.List[typing.Tuple]): ...
    def setStartValue(self, value: typing.Any): ...
    def startValue(self) -> typing.Any: ...
    def updateCurrentTime(self, arg__1: int): ...
    def updateCurrentValue(self, value: typing.Any): ...
    def updateState(self, newState: PySide2.QtCore.QAbstractAnimation.State, oldState: PySide2.QtCore.QAbstractAnimation.State): ...


class QVersionNumber(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, maj: int): ...
    @typing.overload
    def __init__(self, maj: int, min: int): ...
    @typing.overload
    def __init__(self, maj: int, min: int, mic: int): ...
    @typing.overload
    def __init__(self, seg: typing.List[int]): ...
    def __copy__(self): ...
    @staticmethod
    def commonPrefix(v1: PySide2.QtCore.QVersionNumber, v2: PySide2.QtCore.QVersionNumber) -> PySide2.QtCore.QVersionNumber: ...
    @staticmethod
    def compare(v1: PySide2.QtCore.QVersionNumber, v2: PySide2.QtCore.QVersionNumber) -> int: ...
    @staticmethod
    def fromString(string: str, suffixIndex: int = ...) -> PySide2.QtCore.QVersionNumber: ...
    def isNormalized(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isPrefixOf(self, other: PySide2.QtCore.QVersionNumber) -> bool: ...
    def majorVersion(self) -> int: ...
    def microVersion(self) -> int: ...
    def minorVersion(self) -> int: ...
    def normalized(self) -> PySide2.QtCore.QVersionNumber: ...
    def segmentAt(self, index: int) -> int: ...
    def segmentCount(self) -> int: ...
    def segments(self) -> typing.List[int]: ...
    def toString(self) -> str: ...


class QWaitCondition(Shiboken.Object):

    def __init__(self): ...
    def notify_all(self): ...
    def notify_one(self): ...
    @typing.overload
    def wait(self, lockedMutex: PySide2.QtCore.QMutex, time: int = ...) -> bool: ...
    @typing.overload
    def wait(self, lockedReadWriteLock: PySide2.QtCore.QReadWriteLock, time: int = ...) -> bool: ...
    def wakeAll(self): ...
    def wakeOne(self): ...


class QWriteLocker(Shiboken.Object):

    def __init__(self, readWriteLock: PySide2.QtCore.QReadWriteLock): ...
    def __enter__(self): ...
    def __exit__(self, arg__1: object, arg__2: object, arg__3: object): ...
    def readWriteLock(self) -> PySide2.QtCore.QReadWriteLock: ...
    def relock(self): ...
    def unlock(self): ...


class QXmlStreamAttribute(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QXmlStreamAttribute): ...
    @typing.overload
    def __init__(self, namespaceUri: str, name: str, value: str): ...
    @typing.overload
    def __init__(self, qualifiedName: str, value: str): ...
    def __copy__(self): ...
    def isDefault(self) -> bool: ...
    def name(self) -> str: ...
    def namespaceUri(self) -> str: ...
    def prefix(self) -> str: ...
    def qualifiedName(self) -> str: ...
    def value(self) -> str: ...


class QXmlStreamAttributes(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QXmlStreamAttributes: PySide2.QtCore.QXmlStreamAttributes): ...
    def __add__(self, l: typing.List[PySide2.QtCore.QXmlStreamAttribute]) -> typing.List[PySide2.QtCore.QXmlStreamAttribute]: ...
    def __copy__(self): ...
    def __iadd__(self, t: PySide2.QtCore.QXmlStreamAttribute) -> typing.List[PySide2.QtCore.QXmlStreamAttribute]: ...
    @typing.overload
    def __lshift__(self, l: typing.List[PySide2.QtCore.QXmlStreamAttribute]) -> typing.List[PySide2.QtCore.QXmlStreamAttribute]: ...
    @typing.overload
    def __lshift__(self, t: PySide2.QtCore.QXmlStreamAttribute) -> typing.List[PySide2.QtCore.QXmlStreamAttribute]: ...
    @typing.overload
    def append(self, namespaceUri: str, name: str, value: str): ...
    @typing.overload
    def append(self, qualifiedName: str, value: str): ...
    def at(self, i: int) -> PySide2.QtCore.QXmlStreamAttribute: ...
    def back(self) -> PySide2.QtCore.QXmlStreamAttribute: ...
    def capacity(self) -> int: ...
    def clear(self): ...
    def constData(self) -> PySide2.QtCore.QXmlStreamAttribute: ...
    def constFirst(self) -> PySide2.QtCore.QXmlStreamAttribute: ...
    def constLast(self) -> PySide2.QtCore.QXmlStreamAttribute: ...
    def contains(self, t: PySide2.QtCore.QXmlStreamAttribute) -> bool: ...
    @typing.overload
    def count(self) -> int: ...
    @typing.overload
    def count(self, t: PySide2.QtCore.QXmlStreamAttribute) -> int: ...
    def data(self) -> PySide2.QtCore.QXmlStreamAttribute: ...
    def empty(self) -> bool: ...
    def endsWith(self, t: PySide2.QtCore.QXmlStreamAttribute) -> bool: ...
    def fill(self, t: PySide2.QtCore.QXmlStreamAttribute, size: int = ...) -> typing.List[PySide2.QtCore.QXmlStreamAttribute]: ...
    def first(self) -> PySide2.QtCore.QXmlStreamAttribute: ...
    def front(self) -> PySide2.QtCore.QXmlStreamAttribute: ...
    @typing.overload
    def hasAttribute(self, namespaceUri: str, name: str) -> bool: ...
    @typing.overload
    def hasAttribute(self, qualifiedName: str) -> bool: ...
    def indexOf(self, t: PySide2.QtCore.QXmlStreamAttribute, from_: int = ...) -> int: ...
    @typing.overload
    def insert(self, i: int, n: int, t: PySide2.QtCore.QXmlStreamAttribute): ...
    @typing.overload
    def insert(self, i: int, t: PySide2.QtCore.QXmlStreamAttribute): ...
    def isEmpty(self) -> bool: ...
    def isSharedWith(self, other: typing.List[PySide2.QtCore.QXmlStreamAttribute]) -> bool: ...
    def last(self) -> PySide2.QtCore.QXmlStreamAttribute: ...
    def lastIndexOf(self, t: PySide2.QtCore.QXmlStreamAttribute, from_: int = ...) -> int: ...
    def length(self) -> int: ...
    def mid(self, pos: int, len: int = ...) -> typing.List[PySide2.QtCore.QXmlStreamAttribute]: ...
    def move(self, from_: int, to: int): ...
    def prepend(self, t: PySide2.QtCore.QXmlStreamAttribute): ...
    @typing.overload
    def remove(self, i: int): ...
    @typing.overload
    def remove(self, i: int, n: int): ...
    def removeAll(self, t: PySide2.QtCore.QXmlStreamAttribute) -> int: ...
    def removeAt(self, i: int): ...
    def removeFirst(self): ...
    def removeLast(self): ...
    def removeOne(self, t: PySide2.QtCore.QXmlStreamAttribute) -> bool: ...
    def replace(self, i: int, t: PySide2.QtCore.QXmlStreamAttribute): ...
    def reserve(self, size: int): ...
    def resize(self, size: int): ...
    def setSharable(self, sharable: bool): ...
    def shrink_to_fit(self): ...
    def size(self) -> int: ...
    def squeeze(self): ...
    def startsWith(self, t: PySide2.QtCore.QXmlStreamAttribute) -> bool: ...
    def swap(self, other: typing.List[PySide2.QtCore.QXmlStreamAttribute]): ...
    def takeAt(self, i: int) -> PySide2.QtCore.QXmlStreamAttribute: ...
    def takeFirst(self) -> PySide2.QtCore.QXmlStreamAttribute: ...
    def takeLast(self) -> PySide2.QtCore.QXmlStreamAttribute: ...
    @typing.overload
    def value(self, namespaceUri: str, name: str) -> str: ...
    @typing.overload
    def value(self, qualifiedName: str) -> str: ...


class QXmlStreamEntityDeclaration(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QXmlStreamEntityDeclaration): ...
    def __copy__(self): ...
    def name(self) -> str: ...
    def notationName(self) -> str: ...
    def publicId(self) -> str: ...
    def systemId(self) -> str: ...
    def value(self) -> str: ...


class QXmlStreamEntityResolver(Shiboken.Object):

    def __init__(self): ...
    def resolveEntity(self, publicId: str, systemId: str) -> str: ...
    def resolveUndeclaredEntity(self, name: str) -> str: ...


class QXmlStreamNamespaceDeclaration(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QXmlStreamNamespaceDeclaration): ...
    @typing.overload
    def __init__(self, prefix: str, namespaceUri: str): ...
    def __copy__(self): ...
    def namespaceUri(self) -> str: ...
    def prefix(self) -> str: ...


class QXmlStreamNotationDeclaration(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QXmlStreamNotationDeclaration): ...
    def __copy__(self): ...
    def name(self) -> str: ...
    def publicId(self) -> str: ...
    def systemId(self) -> str: ...


class QXmlStreamReader(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, data: PySide2.QtCore.QByteArray): ...
    @typing.overload
    def __init__(self, data: str): ...
    @typing.overload
    def __init__(self, data: str): ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice): ...
    @typing.overload
    def addData(self, data: PySide2.QtCore.QByteArray): ...
    @typing.overload
    def addData(self, data: str): ...
    @typing.overload
    def addData(self, data: str): ...
    def addExtraNamespaceDeclaration(self, extraNamespaceDeclaraction: PySide2.QtCore.QXmlStreamNamespaceDeclaration): ...
    def addExtraNamespaceDeclarations(self, extraNamespaceDeclaractions: typing.List[PySide2.QtCore.QXmlStreamNamespaceDeclaration]): ...
    def atEnd(self) -> bool: ...
    def attributes(self) -> PySide2.QtCore.QXmlStreamAttributes: ...
    def characterOffset(self) -> int: ...
    def clear(self): ...
    def columnNumber(self) -> int: ...
    def device(self) -> PySide2.QtCore.QIODevice: ...
    def documentEncoding(self) -> str: ...
    def documentVersion(self) -> str: ...
    def dtdName(self) -> str: ...
    def dtdPublicId(self) -> str: ...
    def dtdSystemId(self) -> str: ...
    def entityDeclarations(self) -> typing.List[PySide2.QtCore.QXmlStreamEntityDeclaration]: ...
    def entityResolver(self) -> PySide2.QtCore.QXmlStreamEntityResolver: ...
    def error(self) -> PySide2.QtCore.QXmlStreamReader.Error: ...
    def errorString(self) -> str: ...
    def hasError(self) -> bool: ...
    def isCDATA(self) -> bool: ...
    def isCharacters(self) -> bool: ...
    def isComment(self) -> bool: ...
    def isDTD(self) -> bool: ...
    def isEndDocument(self) -> bool: ...
    def isEndElement(self) -> bool: ...
    def isEntityReference(self) -> bool: ...
    def isProcessingInstruction(self) -> bool: ...
    def isStandaloneDocument(self) -> bool: ...
    def isStartDocument(self) -> bool: ...
    def isStartElement(self) -> bool: ...
    def isWhitespace(self) -> bool: ...
    def lineNumber(self) -> int: ...
    def name(self) -> str: ...
    def namespaceDeclarations(self) -> typing.List[PySide2.QtCore.QXmlStreamNamespaceDeclaration]: ...
    def namespaceProcessing(self) -> bool: ...
    def namespaceUri(self) -> str: ...
    def notationDeclarations(self) -> typing.List[PySide2.QtCore.QXmlStreamNotationDeclaration]: ...
    def prefix(self) -> str: ...
    def processingInstructionData(self) -> str: ...
    def processingInstructionTarget(self) -> str: ...
    def qualifiedName(self) -> str: ...
    def raiseError(self, message: str = ...): ...
    def readElementText(self, behaviour: PySide2.QtCore.QXmlStreamReader.ReadElementTextBehaviour = ...) -> str: ...
    def readNext(self) -> PySide2.QtCore.QXmlStreamReader.TokenType: ...
    def readNextStartElement(self) -> bool: ...
    def setDevice(self, device: PySide2.QtCore.QIODevice): ...
    def setEntityResolver(self, resolver: PySide2.QtCore.QXmlStreamEntityResolver): ...
    def setNamespaceProcessing(self, arg__1: bool): ...
    def skipCurrentElement(self): ...
    def text(self) -> str: ...
    def tokenString(self) -> str: ...
    def tokenType(self) -> PySide2.QtCore.QXmlStreamReader.TokenType: ...


class QXmlStreamWriter(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, array: PySide2.QtCore.QByteArray): ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice): ...
    def autoFormatting(self) -> bool: ...
    def autoFormattingIndent(self) -> int: ...
    def codec(self) -> PySide2.QtCore.QTextCodec: ...
    def device(self) -> PySide2.QtCore.QIODevice: ...
    def hasError(self) -> bool: ...
    def setAutoFormatting(self, arg__1: bool): ...
    def setAutoFormattingIndent(self, spacesOrTabs: int): ...
    @typing.overload
    def setCodec(self, codec: PySide2.QtCore.QTextCodec): ...
    @typing.overload
    def setCodec(self, codecName: str): ...
    def setDevice(self, device: PySide2.QtCore.QIODevice): ...
    @typing.overload
    def writeAttribute(self, attribute: PySide2.QtCore.QXmlStreamAttribute): ...
    @typing.overload
    def writeAttribute(self, namespaceUri: str, name: str, value: str): ...
    @typing.overload
    def writeAttribute(self, qualifiedName: str, value: str): ...
    def writeAttributes(self, attributes: PySide2.QtCore.QXmlStreamAttributes): ...
    def writeCDATA(self, text: str): ...
    def writeCharacters(self, text: str): ...
    def writeComment(self, text: str): ...
    def writeCurrentToken(self, reader: PySide2.QtCore.QXmlStreamReader): ...
    def writeDTD(self, dtd: str): ...
    def writeDefaultNamespace(self, namespaceUri: str): ...
    @typing.overload
    def writeEmptyElement(self, namespaceUri: str, name: str): ...
    @typing.overload
    def writeEmptyElement(self, qualifiedName: str): ...
    def writeEndDocument(self): ...
    def writeEndElement(self): ...
    def writeEntityReference(self, name: str): ...
    def writeNamespace(self, namespaceUri: str, prefix: str = ...): ...
    def writeProcessingInstruction(self, target: str, data: str = ...): ...
    @typing.overload
    def writeStartDocument(self): ...
    @typing.overload
    def writeStartDocument(self, version: str): ...
    @typing.overload
    def writeStartDocument(self, version: str, standalone: bool): ...
    @typing.overload
    def writeStartElement(self, namespaceUri: str, name: str): ...
    @typing.overload
    def writeStartElement(self, qualifiedName: str): ...
    @typing.overload
    def writeTextElement(self, namespaceUri: str, name: str, text: str): ...
    @typing.overload
    def writeTextElement(self, qualifiedName: str, text: str): ...


class Qt: ...

# eof
