# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2019 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtWidgets, except for defaults which are replaced by "...".
"""

# Module PySide2.QtWidgets
import PySide2
from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken2 as Shiboken
Shiboken.Object = Object

import PySide2.QtWidgets


class QAbstractButton(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def animateClick(self, msec: int = ...): ...
    def autoExclusive(self) -> bool: ...
    def autoRepeat(self) -> bool: ...
    def autoRepeatDelay(self) -> int: ...
    def autoRepeatInterval(self) -> int: ...
    def changeEvent(self, e: PySide2.QtCore.QEvent): ...
    def checkStateSet(self): ...
    def click(self): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, e: PySide2.QtGui.QFocusEvent): ...
    def focusOutEvent(self, e: PySide2.QtGui.QFocusEvent): ...
    def group(self) -> PySide2.QtWidgets.QButtonGroup: ...
    def hitButton(self, pos: PySide2.QtCore.QPoint) -> bool: ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def isCheckable(self) -> bool: ...
    def isChecked(self) -> bool: ...
    def isDown(self) -> bool: ...
    def keyPressEvent(self, e: PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, e: PySide2.QtGui.QKeyEvent): ...
    def mouseMoveEvent(self, e: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, e: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, e: PySide2.QtGui.QMouseEvent): ...
    def nextCheckState(self): ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent): ...
    def setAutoExclusive(self, arg__1: bool): ...
    def setAutoRepeat(self, arg__1: bool): ...
    def setAutoRepeatDelay(self, arg__1: int): ...
    def setAutoRepeatInterval(self, arg__1: int): ...
    def setCheckable(self, arg__1: bool): ...
    def setChecked(self, arg__1: bool): ...
    def setDown(self, arg__1: bool): ...
    def setIcon(self, icon: PySide2.QtGui.QIcon): ...
    def setIconSize(self, size: PySide2.QtCore.QSize): ...
    def setShortcut(self, key: PySide2.QtGui.QKeySequence): ...
    def setText(self, text: str): ...
    def shortcut(self) -> PySide2.QtGui.QKeySequence: ...
    def text(self) -> str: ...
    def timerEvent(self, e: PySide2.QtCore.QTimerEvent): ...
    def toggle(self): ...


class QAbstractGraphicsShapeItem(PySide2.QtWidgets.QGraphicsItem):

    def __init__(self, parent: PySide2.QtWidgets.QGraphicsItem = ...): ...
    def brush(self) -> PySide2.QtGui.QBrush: ...
    def isObscuredBy(self, item: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def pen(self) -> PySide2.QtGui.QPen: ...
    def setBrush(self, brush: PySide2.QtGui.QBrush): ...
    def setPen(self, pen: PySide2.QtGui.QPen): ...


class QAbstractItemDelegate(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def createEditor(self, parent: PySide2.QtWidgets.QWidget, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QWidget: ...
    def destroyEditor(self, editor: PySide2.QtWidgets.QWidget, index: PySide2.QtCore.QModelIndex): ...
    def editorEvent(self, event: PySide2.QtCore.QEvent, model: PySide2.QtCore.QAbstractItemModel, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> bool: ...
    @staticmethod
    def elidedText(fontMetrics: PySide2.QtGui.QFontMetrics, width: int, mode: PySide2.QtCore.Qt.TextElideMode, text: str) -> str: ...
    def helpEvent(self, event: PySide2.QtGui.QHelpEvent, view: PySide2.QtWidgets.QAbstractItemView, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex): ...
    def paintingRoles(self) -> typing.List[int]: ...
    def setEditorData(self, editor: PySide2.QtWidgets.QWidget, index: PySide2.QtCore.QModelIndex): ...
    def setModelData(self, editor: PySide2.QtWidgets.QWidget, model: PySide2.QtCore.QAbstractItemModel, index: PySide2.QtCore.QModelIndex): ...
    def sizeHint(self, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QSize: ...
    def updateEditorGeometry(self, editor: PySide2.QtWidgets.QWidget, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex): ...


class QAbstractItemView(PySide2.QtWidgets.QAbstractScrollArea):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def alternatingRowColors(self) -> bool: ...
    def autoScrollMargin(self) -> int: ...
    def clearSelection(self): ...
    def closeEditor(self, editor: PySide2.QtWidgets.QWidget, hint: PySide2.QtWidgets.QAbstractItemDelegate.EndEditHint): ...
    def closePersistentEditor(self, index: PySide2.QtCore.QModelIndex): ...
    def commitData(self, editor: PySide2.QtWidgets.QWidget): ...
    def currentChanged(self, current: PySide2.QtCore.QModelIndex, previous: PySide2.QtCore.QModelIndex): ...
    def currentIndex(self) -> PySide2.QtCore.QModelIndex: ...
    def dataChanged(self, topLeft: PySide2.QtCore.QModelIndex, bottomRight: PySide2.QtCore.QModelIndex, roles: typing.List[int] = ...): ...
    def defaultDropAction(self) -> PySide2.QtCore.Qt.DropAction: ...
    def dirtyRegionOffset(self) -> PySide2.QtCore.QPoint: ...
    def doAutoScroll(self): ...
    def doItemsLayout(self): ...
    def dragDropMode(self) -> PySide2.QtWidgets.QAbstractItemView.DragDropMode: ...
    def dragDropOverwriteMode(self) -> bool: ...
    def dragEnabled(self) -> bool: ...
    def dragEnterEvent(self, event: PySide2.QtGui.QDragEnterEvent): ...
    def dragLeaveEvent(self, event: PySide2.QtGui.QDragLeaveEvent): ...
    def dragMoveEvent(self, event: PySide2.QtGui.QDragMoveEvent): ...
    def dropEvent(self, event: PySide2.QtGui.QDropEvent): ...
    def dropIndicatorPosition(self) -> PySide2.QtWidgets.QAbstractItemView.DropIndicatorPosition: ...
    @typing.overload
    def edit(self, index: PySide2.QtCore.QModelIndex): ...
    @typing.overload
    def edit(self, index: PySide2.QtCore.QModelIndex, trigger: PySide2.QtWidgets.QAbstractItemView.EditTrigger, event: PySide2.QtCore.QEvent) -> bool: ...
    def editTriggers(self) -> PySide2.QtWidgets.QAbstractItemView.EditTriggers: ...
    def editorDestroyed(self, editor: PySide2.QtCore.QObject): ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, object: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def executeDelayedItemsLayout(self): ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent): ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent): ...
    def hasAutoScroll(self) -> bool: ...
    def horizontalOffset(self) -> int: ...
    def horizontalScrollMode(self) -> PySide2.QtWidgets.QAbstractItemView.ScrollMode: ...
    def horizontalScrollbarAction(self, action: int): ...
    def horizontalScrollbarValueChanged(self, value: int): ...
    def horizontalStepsPerItem(self) -> int: ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def indexAt(self, point: PySide2.QtCore.QPoint) -> PySide2.QtCore.QModelIndex: ...
    def indexWidget(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QWidget: ...
    def inputMethodEvent(self, event: PySide2.QtGui.QInputMethodEvent): ...
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def isIndexHidden(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def isPersistentEditorOpen(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    @typing.overload
    def itemDelegate(self) -> PySide2.QtWidgets.QAbstractItemDelegate: ...
    @typing.overload
    def itemDelegate(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QAbstractItemDelegate: ...
    def itemDelegateForColumn(self, column: int) -> PySide2.QtWidgets.QAbstractItemDelegate: ...
    def itemDelegateForRow(self, row: int) -> PySide2.QtWidgets.QAbstractItemDelegate: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent): ...
    def keyboardSearch(self, search: str): ...
    def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def mouseDoubleClickEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    def moveCursor(self, cursorAction: PySide2.QtWidgets.QAbstractItemView.CursorAction, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> PySide2.QtCore.QModelIndex: ...
    def openPersistentEditor(self, index: PySide2.QtCore.QModelIndex): ...
    def reset(self): ...
    def resetHorizontalScrollMode(self): ...
    def resetVerticalScrollMode(self): ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent): ...
    def rootIndex(self) -> PySide2.QtCore.QModelIndex: ...
    def rowsAboutToBeRemoved(self, parent: PySide2.QtCore.QModelIndex, start: int, end: int): ...
    def rowsInserted(self, parent: PySide2.QtCore.QModelIndex, start: int, end: int): ...
    def scheduleDelayedItemsLayout(self): ...
    def scrollDirtyRegion(self, dx: int, dy: int): ...
    def scrollTo(self, index: PySide2.QtCore.QModelIndex, hint: PySide2.QtWidgets.QAbstractItemView.ScrollHint = ...): ...
    def scrollToBottom(self): ...
    def scrollToTop(self): ...
    def selectAll(self): ...
    def selectedIndexes(self) -> typing.List[int]: ...
    def selectionBehavior(self) -> PySide2.QtWidgets.QAbstractItemView.SelectionBehavior: ...
    def selectionChanged(self, selected: PySide2.QtCore.QItemSelection, deselected: PySide2.QtCore.QItemSelection): ...
    def selectionCommand(self, index: PySide2.QtCore.QModelIndex, event: PySide2.QtCore.QEvent = ...) -> PySide2.QtCore.QItemSelectionModel.SelectionFlags: ...
    def selectionMode(self) -> PySide2.QtWidgets.QAbstractItemView.SelectionMode: ...
    def selectionModel(self) -> PySide2.QtCore.QItemSelectionModel: ...
    def setAlternatingRowColors(self, enable: bool): ...
    def setAutoScroll(self, enable: bool): ...
    def setAutoScrollMargin(self, margin: int): ...
    def setCurrentIndex(self, index: PySide2.QtCore.QModelIndex): ...
    def setDefaultDropAction(self, dropAction: PySide2.QtCore.Qt.DropAction): ...
    def setDirtyRegion(self, region: PySide2.QtGui.QRegion): ...
    def setDragDropMode(self, behavior: PySide2.QtWidgets.QAbstractItemView.DragDropMode): ...
    def setDragDropOverwriteMode(self, overwrite: bool): ...
    def setDragEnabled(self, enable: bool): ...
    def setDropIndicatorShown(self, enable: bool): ...
    def setEditTriggers(self, triggers: PySide2.QtWidgets.QAbstractItemView.EditTriggers): ...
    def setHorizontalScrollMode(self, mode: PySide2.QtWidgets.QAbstractItemView.ScrollMode): ...
    def setHorizontalStepsPerItem(self, steps: int): ...
    def setIconSize(self, size: PySide2.QtCore.QSize): ...
    def setIndexWidget(self, index: PySide2.QtCore.QModelIndex, widget: PySide2.QtWidgets.QWidget): ...
    def setItemDelegate(self, delegate: PySide2.QtWidgets.QAbstractItemDelegate): ...
    def setItemDelegateForColumn(self, column: int, delegate: PySide2.QtWidgets.QAbstractItemDelegate): ...
    def setItemDelegateForRow(self, row: int, delegate: PySide2.QtWidgets.QAbstractItemDelegate): ...
    def setModel(self, model: PySide2.QtCore.QAbstractItemModel): ...
    def setRootIndex(self, index: PySide2.QtCore.QModelIndex): ...
    def setSelection(self, rect: PySide2.QtCore.QRect, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    def setSelectionBehavior(self, behavior: PySide2.QtWidgets.QAbstractItemView.SelectionBehavior): ...
    def setSelectionMode(self, mode: PySide2.QtWidgets.QAbstractItemView.SelectionMode): ...
    def setSelectionModel(self, selectionModel: PySide2.QtCore.QItemSelectionModel): ...
    def setState(self, state: PySide2.QtWidgets.QAbstractItemView.State): ...
    def setTabKeyNavigation(self, enable: bool): ...
    def setTextElideMode(self, mode: PySide2.QtCore.Qt.TextElideMode): ...
    def setVerticalScrollMode(self, mode: PySide2.QtWidgets.QAbstractItemView.ScrollMode): ...
    def setVerticalStepsPerItem(self, steps: int): ...
    def showDropIndicator(self) -> bool: ...
    def sizeHintForColumn(self, column: int) -> int: ...
    def sizeHintForIndex(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QSize: ...
    def sizeHintForRow(self, row: int) -> int: ...
    def startAutoScroll(self): ...
    def startDrag(self, supportedActions: PySide2.QtCore.Qt.DropActions): ...
    def state(self) -> PySide2.QtWidgets.QAbstractItemView.State: ...
    def stopAutoScroll(self): ...
    def tabKeyNavigation(self) -> bool: ...
    def textElideMode(self) -> PySide2.QtCore.Qt.TextElideMode: ...
    def timerEvent(self, event: PySide2.QtCore.QTimerEvent): ...
    @typing.overload
    def update(self): ...
    @typing.overload
    def update(self, index: PySide2.QtCore.QModelIndex): ...
    def updateEditorData(self): ...
    def updateEditorGeometries(self): ...
    def updateGeometries(self): ...
    def verticalOffset(self) -> int: ...
    def verticalScrollMode(self) -> PySide2.QtWidgets.QAbstractItemView.ScrollMode: ...
    def verticalScrollbarAction(self, action: int): ...
    def verticalScrollbarValueChanged(self, value: int): ...
    def verticalStepsPerItem(self) -> int: ...
    def viewOptions(self) -> PySide2.QtWidgets.QStyleOptionViewItem: ...
    def viewportEvent(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def viewportSizeHint(self) -> PySide2.QtCore.QSize: ...
    def visualRect(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide2.QtCore.QItemSelection) -> PySide2.QtGui.QRegion: ...


class QAbstractScrollArea(PySide2.QtWidgets.QFrame):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def addScrollBarWidget(self, widget: PySide2.QtWidgets.QWidget, alignment: PySide2.QtCore.Qt.Alignment): ...
    def contextMenuEvent(self, arg__1: PySide2.QtGui.QContextMenuEvent): ...
    def cornerWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def dragEnterEvent(self, arg__1: PySide2.QtGui.QDragEnterEvent): ...
    def dragLeaveEvent(self, arg__1: PySide2.QtGui.QDragLeaveEvent): ...
    def dragMoveEvent(self, arg__1: PySide2.QtGui.QDragMoveEvent): ...
    def dropEvent(self, arg__1: PySide2.QtGui.QDropEvent): ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    def horizontalScrollBar(self) -> PySide2.QtWidgets.QScrollBar: ...
    def horizontalScrollBarPolicy(self) -> PySide2.QtCore.Qt.ScrollBarPolicy: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent): ...
    def maximumViewportSize(self) -> PySide2.QtCore.QSize: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseDoubleClickEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent): ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent): ...
    def scrollBarWidgets(self, alignment: PySide2.QtCore.Qt.Alignment) -> typing.List[PySide2.QtWidgets.QWidget]: ...
    def scrollContentsBy(self, dx: int, dy: int): ...
    def setCornerWidget(self, widget: PySide2.QtWidgets.QWidget): ...
    def setHorizontalScrollBar(self, scrollbar: PySide2.QtWidgets.QScrollBar): ...
    def setHorizontalScrollBarPolicy(self, arg__1: PySide2.QtCore.Qt.ScrollBarPolicy): ...
    def setSizeAdjustPolicy(self, policy: PySide2.QtWidgets.QAbstractScrollArea.SizeAdjustPolicy): ...
    def setVerticalScrollBar(self, scrollbar: PySide2.QtWidgets.QScrollBar): ...
    def setVerticalScrollBarPolicy(self, arg__1: PySide2.QtCore.Qt.ScrollBarPolicy): ...
    def setViewport(self, widget: PySide2.QtWidgets.QWidget): ...
    @typing.overload
    def setViewportMargins(self, left: int, top: int, right: int, bottom: int): ...
    @typing.overload
    def setViewportMargins(self, margins: PySide2.QtCore.QMargins): ...
    def setupViewport(self, viewport: PySide2.QtWidgets.QWidget): ...
    def sizeAdjustPolicy(self) -> PySide2.QtWidgets.QAbstractScrollArea.SizeAdjustPolicy: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def verticalScrollBar(self) -> PySide2.QtWidgets.QScrollBar: ...
    def verticalScrollBarPolicy(self) -> PySide2.QtCore.Qt.ScrollBarPolicy: ...
    def viewport(self) -> PySide2.QtWidgets.QWidget: ...
    def viewportEvent(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def viewportMargins(self) -> PySide2.QtCore.QMargins: ...
    def viewportSizeHint(self) -> PySide2.QtCore.QSize: ...
    def wheelEvent(self, arg__1: PySide2.QtGui.QWheelEvent): ...


class QAbstractSlider(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def changeEvent(self, e: PySide2.QtCore.QEvent): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def hasTracking(self) -> bool: ...
    def invertedAppearance(self) -> bool: ...
    def invertedControls(self) -> bool: ...
    def isSliderDown(self) -> bool: ...
    def keyPressEvent(self, ev: PySide2.QtGui.QKeyEvent): ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def pageStep(self) -> int: ...
    def repeatAction(self) -> PySide2.QtWidgets.QAbstractSlider.SliderAction: ...
    def setInvertedAppearance(self, arg__1: bool): ...
    def setInvertedControls(self, arg__1: bool): ...
    def setMaximum(self, arg__1: int): ...
    def setMinimum(self, arg__1: int): ...
    def setOrientation(self, arg__1: PySide2.QtCore.Qt.Orientation): ...
    def setPageStep(self, arg__1: int): ...
    def setRange(self, min: int, max: int): ...
    def setRepeatAction(self, action: PySide2.QtWidgets.QAbstractSlider.SliderAction, thresholdTime: int = ..., repeatTime: int = ...): ...
    def setSingleStep(self, arg__1: int): ...
    def setSliderDown(self, arg__1: bool): ...
    def setSliderPosition(self, arg__1: int): ...
    def setTracking(self, enable: bool): ...
    def setValue(self, arg__1: int): ...
    def singleStep(self) -> int: ...
    def sliderChange(self, change: PySide2.QtWidgets.QAbstractSlider.SliderChange): ...
    def sliderPosition(self) -> int: ...
    def timerEvent(self, arg__1: PySide2.QtCore.QTimerEvent): ...
    def triggerAction(self, action: PySide2.QtWidgets.QAbstractSlider.SliderAction): ...
    def value(self) -> int: ...
    def wheelEvent(self, e: PySide2.QtGui.QWheelEvent): ...


class QAbstractSpinBox(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def buttonSymbols(self) -> PySide2.QtWidgets.QAbstractSpinBox.ButtonSymbols: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent): ...
    def clear(self): ...
    def closeEvent(self, event: PySide2.QtGui.QCloseEvent): ...
    def contextMenuEvent(self, event: PySide2.QtGui.QContextMenuEvent): ...
    def correctionMode(self) -> PySide2.QtWidgets.QAbstractSpinBox.CorrectionMode: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def fixup(self, input: str): ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent): ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent): ...
    def hasAcceptableInput(self) -> bool: ...
    def hasFrame(self) -> bool: ...
    def hideEvent(self, event: PySide2.QtGui.QHideEvent): ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionSpinBox): ...
    def inputMethodQuery(self, arg__1: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def interpretText(self): ...
    def isAccelerated(self) -> bool: ...
    def isGroupSeparatorShown(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, event: PySide2.QtGui.QKeyEvent): ...
    def keyboardTracking(self) -> bool: ...
    def lineEdit(self) -> PySide2.QtWidgets.QLineEdit: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent): ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent): ...
    def selectAll(self): ...
    def setAccelerated(self, on: bool): ...
    def setAlignment(self, flag: PySide2.QtCore.Qt.Alignment): ...
    def setButtonSymbols(self, bs: PySide2.QtWidgets.QAbstractSpinBox.ButtonSymbols): ...
    def setCorrectionMode(self, cm: PySide2.QtWidgets.QAbstractSpinBox.CorrectionMode): ...
    def setFrame(self, arg__1: bool): ...
    def setGroupSeparatorShown(self, shown: bool): ...
    def setKeyboardTracking(self, kt: bool): ...
    def setLineEdit(self, edit: PySide2.QtWidgets.QLineEdit): ...
    def setReadOnly(self, r: bool): ...
    def setSpecialValueText(self, txt: str): ...
    def setWrapping(self, w: bool): ...
    def showEvent(self, event: PySide2.QtGui.QShowEvent): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def specialValueText(self) -> str: ...
    def stepBy(self, steps: int): ...
    def stepDown(self): ...
    def stepEnabled(self) -> PySide2.QtWidgets.QAbstractSpinBox.StepEnabled: ...
    def stepUp(self): ...
    def text(self) -> str: ...
    def timerEvent(self, event: PySide2.QtCore.QTimerEvent): ...
    def validate(self, input: str, pos: int) -> PySide2.QtGui.QValidator.State: ...
    def wheelEvent(self, event: PySide2.QtGui.QWheelEvent): ...
    def wrapping(self) -> bool: ...


class QAccessibleWidget(PySide2.QtGui.QAccessibleObject):

    def __init__(self, o: PySide2.QtWidgets.QWidget, r: PySide2.QtGui.QAccessible.Role = ..., name: str = ...): ...
    def actionNames(self) -> typing.List[str]: ...
    def addControllingSignal(self, signal: str): ...
    def backgroundColor(self) -> PySide2.QtGui.QColor: ...
    def child(self, index: int) -> PySide2.QtGui.QAccessibleInterface: ...
    def childCount(self) -> int: ...
    def doAction(self, actionName: str): ...
    def focusChild(self) -> PySide2.QtGui.QAccessibleInterface: ...
    def foregroundColor(self) -> PySide2.QtGui.QColor: ...
    def indexOfChild(self, child: PySide2.QtGui.QAccessibleInterface) -> int: ...
    def interface_cast(self, t: PySide2.QtGui.QAccessible.InterfaceType) -> int: ...
    def isValid(self) -> bool: ...
    def keyBindingsForAction(self, actionName: str) -> typing.List[str]: ...
    def parent(self) -> PySide2.QtGui.QAccessibleInterface: ...
    def parentObject(self) -> PySide2.QtCore.QObject: ...
    def rect(self) -> PySide2.QtCore.QRect: ...
    def relations(self, match: PySide2.QtGui.QAccessible.Relation = ...) -> typing.List[typing.Tuple]: ...
    def role(self) -> PySide2.QtGui.QAccessible.Role: ...
    def state(self) -> PySide2.QtGui.QAccessible.State: ...
    def text(self, t: PySide2.QtGui.QAccessible.Text) -> str: ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...
    def window(self) -> PySide2.QtGui.QWindow: ...


class QAction(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, icon: PySide2.QtGui.QIcon, text: str, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, text: str, parent: PySide2.QtCore.QObject = ...): ...
    def actionGroup(self) -> PySide2.QtWidgets.QActionGroup: ...
    def activate(self, event: PySide2.QtWidgets.QAction.ActionEvent): ...
    def associatedGraphicsWidgets(self) -> typing.List[PySide2.QtWidgets.QGraphicsWidget]: ...
    def associatedWidgets(self) -> typing.List[PySide2.QtWidgets.QWidget]: ...
    def autoRepeat(self) -> bool: ...
    def data(self) -> typing.Any: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def hover(self): ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def iconText(self) -> str: ...
    def isCheckable(self) -> bool: ...
    def isChecked(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isIconVisibleInMenu(self) -> bool: ...
    def isSeparator(self) -> bool: ...
    def isShortcutVisibleInContextMenu(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def menu(self) -> PySide2.QtWidgets.QMenu: ...
    def menuRole(self) -> PySide2.QtWidgets.QAction.MenuRole: ...
    def parentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def priority(self) -> PySide2.QtWidgets.QAction.Priority: ...
    def setActionGroup(self, group: PySide2.QtWidgets.QActionGroup): ...
    def setAutoRepeat(self, arg__1: bool): ...
    def setCheckable(self, arg__1: bool): ...
    def setChecked(self, arg__1: bool): ...
    def setData(self, var: typing.Any): ...
    def setDisabled(self, b: bool): ...
    def setEnabled(self, arg__1: bool): ...
    def setFont(self, font: PySide2.QtGui.QFont): ...
    def setIcon(self, icon: PySide2.QtGui.QIcon): ...
    def setIconText(self, text: str): ...
    def setIconVisibleInMenu(self, visible: bool): ...
    def setMenu(self, menu: PySide2.QtWidgets.QMenu): ...
    def setMenuRole(self, menuRole: PySide2.QtWidgets.QAction.MenuRole): ...
    def setPriority(self, priority: PySide2.QtWidgets.QAction.Priority): ...
    def setSeparator(self, b: bool): ...
    def setShortcut(self, shortcut: PySide2.QtGui.QKeySequence): ...
    def setShortcutContext(self, context: PySide2.QtCore.Qt.ShortcutContext): ...
    def setShortcutVisibleInContextMenu(self, show: bool): ...
    @typing.overload
    def setShortcuts(self, arg__1: PySide2.QtGui.QKeySequence.StandardKey): ...
    @typing.overload
    def setShortcuts(self, shortcuts: typing.List[PySide2.QtGui.QKeySequence]): ...
    def setStatusTip(self, statusTip: str): ...
    def setText(self, text: str): ...
    def setToolTip(self, tip: str): ...
    def setVisible(self, arg__1: bool): ...
    def setWhatsThis(self, what: str): ...
    def shortcut(self) -> PySide2.QtGui.QKeySequence: ...
    def shortcutContext(self) -> PySide2.QtCore.Qt.ShortcutContext: ...
    def shortcuts(self) -> typing.List[PySide2.QtGui.QKeySequence]: ...
    def showStatusText(self, widget: PySide2.QtWidgets.QWidget = ...) -> bool: ...
    def statusTip(self) -> str: ...
    def text(self) -> str: ...
    def toggle(self): ...
    def toolTip(self) -> str: ...
    def trigger(self): ...
    def whatsThis(self) -> str: ...


class QActionGroup(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject): ...
    def actions(self) -> typing.List[PySide2.QtWidgets.QAction]: ...
    @typing.overload
    def addAction(self, a: PySide2.QtWidgets.QAction) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide2.QtGui.QIcon, text: str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, text: str) -> PySide2.QtWidgets.QAction: ...
    def checkedAction(self) -> PySide2.QtWidgets.QAction: ...
    def isEnabled(self) -> bool: ...
    def isExclusive(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def removeAction(self, a: PySide2.QtWidgets.QAction): ...
    def setDisabled(self, b: bool): ...
    def setEnabled(self, arg__1: bool): ...
    def setExclusive(self, arg__1: bool): ...
    def setVisible(self, arg__1: bool): ...


class QApplication(PySide2.QtGui.QGuiApplication):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arg__1: typing.List[str]): ...
    @staticmethod
    def aboutQt(): ...
    @staticmethod
    def activeModalWidget() -> PySide2.QtWidgets.QWidget: ...
    @staticmethod
    def activePopupWidget() -> PySide2.QtWidgets.QWidget: ...
    @staticmethod
    def activeWindow() -> PySide2.QtWidgets.QWidget: ...
    @staticmethod
    def alert(widget: PySide2.QtWidgets.QWidget, duration: int = ...): ...
    @staticmethod
    def allWidgets() -> typing.List[PySide2.QtWidgets.QWidget]: ...
    def autoSipEnabled(self) -> bool: ...
    @staticmethod
    def beep(): ...
    @staticmethod
    def closeAllWindows(): ...
    @staticmethod
    def colorSpec() -> int: ...
    @staticmethod
    def cursorFlashTime() -> int: ...
    @staticmethod
    def desktop() -> PySide2.QtWidgets.QDesktopWidget: ...
    @staticmethod
    def doubleClickInterval() -> int: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    @staticmethod
    def exec_() -> int: ...
    @staticmethod
    def focusWidget() -> PySide2.QtWidgets.QWidget: ...
    @typing.overload
    @staticmethod
    def font() -> PySide2.QtGui.QFont: ...
    @typing.overload
    @staticmethod
    def font(arg__1: PySide2.QtWidgets.QWidget) -> PySide2.QtGui.QFont: ...
    @typing.overload
    @staticmethod
    def font(className: str) -> PySide2.QtGui.QFont: ...
    @staticmethod
    def fontMetrics() -> PySide2.QtGui.QFontMetrics: ...
    @staticmethod
    def globalStrut() -> PySide2.QtCore.QSize: ...
    @staticmethod
    def isEffectEnabled(arg__1: PySide2.QtCore.Qt.UIEffect) -> bool: ...
    @staticmethod
    def keyboardInputInterval() -> int: ...
    def notify(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    @typing.overload
    @staticmethod
    def palette() -> PySide2.QtGui.QPalette: ...
    @typing.overload
    @staticmethod
    def palette(arg__1: PySide2.QtWidgets.QWidget) -> PySide2.QtGui.QPalette: ...
    @typing.overload
    @staticmethod
    def palette(className: str) -> PySide2.QtGui.QPalette: ...
    @staticmethod
    def setActiveWindow(act: PySide2.QtWidgets.QWidget): ...
    def setAutoSipEnabled(self, enabled: bool): ...
    @staticmethod
    def setColorSpec(arg__1: int): ...
    @staticmethod
    def setCursorFlashTime(arg__1: int): ...
    @staticmethod
    def setDoubleClickInterval(arg__1: int): ...
    @staticmethod
    def setEffectEnabled(arg__1: PySide2.QtCore.Qt.UIEffect, enable: bool = ...): ...
    @typing.overload
    @staticmethod
    def setFont(arg__1: PySide2.QtGui.QFont): ...
    @typing.overload
    @staticmethod
    def setFont(arg__1: PySide2.QtGui.QFont, className: str = ...): ...
    @staticmethod
    def setGlobalStrut(arg__1: PySide2.QtCore.QSize): ...
    @staticmethod
    def setKeyboardInputInterval(arg__1: int): ...
    @typing.overload
    @staticmethod
    def setPalette(arg__1: PySide2.QtGui.QPalette, className: str = ...): ...
    @typing.overload
    @staticmethod
    def setPalette(pal: PySide2.QtGui.QPalette): ...
    @staticmethod
    def setStartDragDistance(l: int): ...
    @staticmethod
    def setStartDragTime(ms: int): ...
    @typing.overload
    @staticmethod
    def setStyle(arg__1: PySide2.QtWidgets.QStyle): ...
    @typing.overload
    @staticmethod
    def setStyle(arg__1: str) -> PySide2.QtWidgets.QStyle: ...
    def setStyleSheet(self, sheet: str): ...
    @staticmethod
    def setWheelScrollLines(arg__1: int): ...
    @staticmethod
    def setWindowIcon(icon: PySide2.QtGui.QIcon): ...
    @staticmethod
    def startDragDistance() -> int: ...
    @staticmethod
    def startDragTime() -> int: ...
    @staticmethod
    def style() -> PySide2.QtWidgets.QStyle: ...
    def styleSheet(self) -> str: ...
    @typing.overload
    @staticmethod
    def topLevelAt(p: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QWidget: ...
    @typing.overload
    @staticmethod
    def topLevelAt(x: int, y: int) -> PySide2.QtWidgets.QWidget: ...
    @staticmethod
    def topLevelWidgets() -> typing.List[PySide2.QtWidgets.QWidget]: ...
    @staticmethod
    def wheelScrollLines() -> int: ...
    @typing.overload
    @staticmethod
    def widgetAt(p: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QWidget: ...
    @typing.overload
    @staticmethod
    def widgetAt(x: int, y: int) -> PySide2.QtWidgets.QWidget: ...
    @staticmethod
    def windowIcon() -> PySide2.QtGui.QIcon: ...


class QBoxLayout(PySide2.QtWidgets.QLayout):

    def __init__(self, arg__1: PySide2.QtWidgets.QBoxLayout.Direction, parent: PySide2.QtWidgets.QWidget = ...): ...
    def addItem(self, arg__1: PySide2.QtWidgets.QLayoutItem): ...
    def addLayout(self, layout: PySide2.QtWidgets.QLayout, stretch: int = ...): ...
    def addSpacerItem(self, spacerItem: PySide2.QtWidgets.QSpacerItem): ...
    def addSpacing(self, size: int): ...
    def addStretch(self, stretch: int = ...): ...
    def addStrut(self, arg__1: int): ...
    @typing.overload
    def addWidget(self, arg__1: PySide2.QtWidgets.QWidget, stretch: int = ..., alignment: PySide2.QtCore.Qt.Alignment = ...): ...
    @typing.overload
    def addWidget(self, w: PySide2.QtWidgets.QWidget): ...
    def count(self) -> int: ...
    def direction(self) -> PySide2.QtWidgets.QBoxLayout.Direction: ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def insertItem(self, index: int, arg__2: PySide2.QtWidgets.QLayoutItem): ...
    def insertLayout(self, index: int, layout: PySide2.QtWidgets.QLayout, stretch: int = ...): ...
    def insertSpacerItem(self, index: int, spacerItem: PySide2.QtWidgets.QSpacerItem): ...
    def insertSpacing(self, index: int, size: int): ...
    def insertStretch(self, index: int, stretch: int = ...): ...
    def insertWidget(self, index: int, widget: PySide2.QtWidgets.QWidget, stretch: int = ..., alignment: PySide2.QtCore.Qt.Alignment = ...): ...
    def invalidate(self): ...
    def itemAt(self, arg__1: int) -> PySide2.QtWidgets.QLayoutItem: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumHeightForWidth(self, arg__1: int) -> int: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def setDirection(self, arg__1: PySide2.QtWidgets.QBoxLayout.Direction): ...
    def setGeometry(self, arg__1: PySide2.QtCore.QRect): ...
    def setSpacing(self, spacing: int): ...
    def setStretch(self, index: int, stretch: int): ...
    @typing.overload
    def setStretchFactor(self, l: PySide2.QtWidgets.QLayout, stretch: int) -> bool: ...
    @typing.overload
    def setStretchFactor(self, w: PySide2.QtWidgets.QWidget, stretch: int) -> bool: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def spacing(self) -> int: ...
    def stretch(self, index: int) -> int: ...
    def takeAt(self, arg__1: int) -> PySide2.QtWidgets.QLayoutItem: ...


class QButtonGroup(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def addButton(self, arg__1: PySide2.QtWidgets.QAbstractButton, id: int = ...): ...
    def button(self, id: int) -> PySide2.QtWidgets.QAbstractButton: ...
    def buttons(self) -> typing.List[PySide2.QtWidgets.QAbstractButton]: ...
    def checkedButton(self) -> PySide2.QtWidgets.QAbstractButton: ...
    def checkedId(self) -> int: ...
    def exclusive(self) -> bool: ...
    def id(self, button: PySide2.QtWidgets.QAbstractButton) -> int: ...
    def removeButton(self, arg__1: PySide2.QtWidgets.QAbstractButton): ...
    def setExclusive(self, arg__1: bool): ...
    def setId(self, button: PySide2.QtWidgets.QAbstractButton, id: int): ...


class QCalendarWidget(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def dateEditAcceptDelay(self) -> int: ...
    @typing.overload
    def dateTextFormat(self) -> typing.Dict: ...
    @typing.overload
    def dateTextFormat(self, date: PySide2.QtCore.QDate) -> PySide2.QtGui.QTextCharFormat: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, watched: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def firstDayOfWeek(self) -> PySide2.QtCore.Qt.DayOfWeek: ...
    def headerTextFormat(self) -> PySide2.QtGui.QTextCharFormat: ...
    def horizontalHeaderFormat(self) -> PySide2.QtWidgets.QCalendarWidget.HorizontalHeaderFormat: ...
    def isDateEditEnabled(self) -> bool: ...
    def isGridVisible(self) -> bool: ...
    def isNavigationBarVisible(self) -> bool: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent): ...
    def maximumDate(self) -> PySide2.QtCore.QDate: ...
    def minimumDate(self) -> PySide2.QtCore.QDate: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def monthShown(self) -> int: ...
    def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    def paintCell(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRect, date: PySide2.QtCore.QDate): ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent): ...
    def selectedDate(self) -> PySide2.QtCore.QDate: ...
    def selectionMode(self) -> PySide2.QtWidgets.QCalendarWidget.SelectionMode: ...
    def setCurrentPage(self, year: int, month: int): ...
    def setDateEditAcceptDelay(self, delay: int): ...
    def setDateEditEnabled(self, enable: bool): ...
    def setDateRange(self, min: PySide2.QtCore.QDate, max: PySide2.QtCore.QDate): ...
    def setDateTextFormat(self, date: PySide2.QtCore.QDate, format: PySide2.QtGui.QTextCharFormat): ...
    def setFirstDayOfWeek(self, dayOfWeek: PySide2.QtCore.Qt.DayOfWeek): ...
    def setGridVisible(self, show: bool): ...
    def setHeaderTextFormat(self, format: PySide2.QtGui.QTextCharFormat): ...
    def setHorizontalHeaderFormat(self, format: PySide2.QtWidgets.QCalendarWidget.HorizontalHeaderFormat): ...
    def setMaximumDate(self, date: PySide2.QtCore.QDate): ...
    def setMinimumDate(self, date: PySide2.QtCore.QDate): ...
    def setNavigationBarVisible(self, visible: bool): ...
    def setSelectedDate(self, date: PySide2.QtCore.QDate): ...
    def setSelectionMode(self, mode: PySide2.QtWidgets.QCalendarWidget.SelectionMode): ...
    def setVerticalHeaderFormat(self, format: PySide2.QtWidgets.QCalendarWidget.VerticalHeaderFormat): ...
    def setWeekdayTextFormat(self, dayOfWeek: PySide2.QtCore.Qt.DayOfWeek, format: PySide2.QtGui.QTextCharFormat): ...
    def showNextMonth(self): ...
    def showNextYear(self): ...
    def showPreviousMonth(self): ...
    def showPreviousYear(self): ...
    def showSelectedDate(self): ...
    def showToday(self): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def updateCell(self, date: PySide2.QtCore.QDate): ...
    def updateCells(self): ...
    def verticalHeaderFormat(self) -> PySide2.QtWidgets.QCalendarWidget.VerticalHeaderFormat: ...
    def weekdayTextFormat(self, dayOfWeek: PySide2.QtCore.Qt.DayOfWeek) -> PySide2.QtGui.QTextCharFormat: ...
    def yearShown(self) -> int: ...


class QCheckBox(PySide2.QtWidgets.QAbstractButton):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, text: str, parent: PySide2.QtWidgets.QWidget = ...): ...
    def checkState(self) -> PySide2.QtCore.Qt.CheckState: ...
    def checkStateSet(self): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def hitButton(self, pos: PySide2.QtCore.QPoint) -> bool: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionButton): ...
    def isTristate(self) -> bool: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def nextCheckState(self): ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent): ...
    def setCheckState(self, state: PySide2.QtCore.Qt.CheckState): ...
    def setTristate(self, y: bool = ...): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...


class QColorDialog(PySide2.QtWidgets.QDialog):

    @typing.overload
    def __init__(self, initial: PySide2.QtGui.QColor, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def changeEvent(self, event: PySide2.QtCore.QEvent): ...
    def currentColor(self) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def customColor(index: int) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def customCount() -> int: ...
    def done(self, result: int): ...
    @staticmethod
    def getColor(initial: PySide2.QtGui.QColor = ..., parent: PySide2.QtWidgets.QWidget = ..., title: str = ..., options: PySide2.QtWidgets.QColorDialog.ColorDialogOptions = ...) -> PySide2.QtGui.QColor: ...
    @typing.overload
    def open(self): ...
    @typing.overload
    def open(self, receiver: PySide2.QtCore.QObject, member: str): ...
    def options(self) -> PySide2.QtWidgets.QColorDialog.ColorDialogOptions: ...
    def selectedColor(self) -> PySide2.QtGui.QColor: ...
    def setCurrentColor(self, color: PySide2.QtGui.QColor): ...
    @staticmethod
    def setCustomColor(index: int, color: PySide2.QtGui.QColor): ...
    def setOption(self, option: PySide2.QtWidgets.QColorDialog.ColorDialogOption, on: bool = ...): ...
    def setOptions(self, options: PySide2.QtWidgets.QColorDialog.ColorDialogOptions): ...
    @staticmethod
    def setStandardColor(index: int, color: PySide2.QtGui.QColor): ...
    def setVisible(self, visible: bool): ...
    @staticmethod
    def standardColor(index: int) -> PySide2.QtGui.QColor: ...
    def testOption(self, option: PySide2.QtWidgets.QColorDialog.ColorDialogOption) -> bool: ...


class QColormap(Shiboken.Object):

    def __init__(self, colormap: PySide2.QtWidgets.QColormap): ...
    def __copy__(self): ...
    @staticmethod
    def cleanup(): ...
    def colorAt(self, pixel: int) -> PySide2.QtGui.QColor: ...
    def colormap(self) -> typing.List[PySide2.QtGui.QColor]: ...
    def depth(self) -> int: ...
    @staticmethod
    def initialize(): ...
    @staticmethod
    def instance(screen: int = ...) -> PySide2.QtWidgets.QColormap: ...
    def mode(self) -> PySide2.QtWidgets.QColormap.Mode: ...
    def pixel(self, color: PySide2.QtGui.QColor) -> int: ...
    def size(self) -> int: ...


class QColumnView(PySide2.QtWidgets.QAbstractItemView):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def columnWidths(self) -> typing.List[int]: ...
    def createColumn(self, rootIndex: PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QAbstractItemView: ...
    def currentChanged(self, current: PySide2.QtCore.QModelIndex, previous: PySide2.QtCore.QModelIndex): ...
    def horizontalOffset(self) -> int: ...
    def indexAt(self, point: PySide2.QtCore.QPoint) -> PySide2.QtCore.QModelIndex: ...
    def initializeColumn(self, column: PySide2.QtWidgets.QAbstractItemView): ...
    def isIndexHidden(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def moveCursor(self, cursorAction: PySide2.QtWidgets.QAbstractItemView.CursorAction, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> PySide2.QtCore.QModelIndex: ...
    def previewWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent): ...
    def resizeGripsVisible(self) -> bool: ...
    def rowsInserted(self, parent: PySide2.QtCore.QModelIndex, start: int, end: int): ...
    def scrollContentsBy(self, dx: int, dy: int): ...
    def scrollTo(self, index: PySide2.QtCore.QModelIndex, hint: PySide2.QtWidgets.QAbstractItemView.ScrollHint = ...): ...
    def selectAll(self): ...
    def setColumnWidths(self, list: typing.List[int]): ...
    def setModel(self, model: PySide2.QtCore.QAbstractItemModel): ...
    def setPreviewWidget(self, widget: PySide2.QtWidgets.QWidget): ...
    def setResizeGripsVisible(self, visible: bool): ...
    def setRootIndex(self, index: PySide2.QtCore.QModelIndex): ...
    def setSelection(self, rect: PySide2.QtCore.QRect, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    def setSelectionModel(self, selectionModel: PySide2.QtCore.QItemSelectionModel): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def verticalOffset(self) -> int: ...
    def visualRect(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide2.QtCore.QItemSelection) -> PySide2.QtGui.QRegion: ...


class QComboBox(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def addItem(self, icon: PySide2.QtGui.QIcon, text: str, userData: typing.Any = ...): ...
    @typing.overload
    def addItem(self, text: str, userData: typing.Any = ...): ...
    def addItems(self, texts: typing.List[str]): ...
    def autoCompletion(self) -> bool: ...
    def autoCompletionCaseSensitivity(self) -> PySide2.QtCore.Qt.CaseSensitivity: ...
    def changeEvent(self, e: PySide2.QtCore.QEvent): ...
    def clear(self): ...
    def clearEditText(self): ...
    def completer(self) -> PySide2.QtWidgets.QCompleter: ...
    def contextMenuEvent(self, e: PySide2.QtGui.QContextMenuEvent): ...
    def count(self) -> int: ...
    def currentData(self, role: int = ...) -> typing.Any: ...
    def currentIndex(self) -> int: ...
    def currentText(self) -> str: ...
    def duplicatesEnabled(self) -> bool: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def findData(self, data: typing.Any, role: int = ..., flags: PySide2.QtCore.Qt.MatchFlags = ...) -> int: ...
    def findText(self, text: str, flags: PySide2.QtCore.Qt.MatchFlags = ...) -> int: ...
    def focusInEvent(self, e: PySide2.QtGui.QFocusEvent): ...
    def focusOutEvent(self, e: PySide2.QtGui.QFocusEvent): ...
    def hasFrame(self) -> bool: ...
    def hideEvent(self, e: PySide2.QtGui.QHideEvent): ...
    def hidePopup(self): ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionComboBox): ...
    def inputMethodEvent(self, arg__1: PySide2.QtGui.QInputMethodEvent): ...
    @typing.overload
    def inputMethodQuery(self, arg__1: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    @typing.overload
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery, argument: typing.Any) -> typing.Any: ...
    @typing.overload
    def insertItem(self, index: int, icon: PySide2.QtGui.QIcon, text: str, userData: typing.Any = ...): ...
    @typing.overload
    def insertItem(self, index: int, text: str, userData: typing.Any = ...): ...
    def insertItems(self, index: int, texts: typing.List[str]): ...
    def insertPolicy(self) -> PySide2.QtWidgets.QComboBox.InsertPolicy: ...
    def insertSeparator(self, index: int): ...
    def isEditable(self) -> bool: ...
    def itemData(self, index: int, role: int = ...) -> typing.Any: ...
    def itemDelegate(self) -> PySide2.QtWidgets.QAbstractItemDelegate: ...
    def itemIcon(self, index: int) -> PySide2.QtGui.QIcon: ...
    def itemText(self, index: int) -> str: ...
    def keyPressEvent(self, e: PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, e: PySide2.QtGui.QKeyEvent): ...
    def lineEdit(self) -> PySide2.QtWidgets.QLineEdit: ...
    def maxCount(self) -> int: ...
    def maxVisibleItems(self) -> int: ...
    def minimumContentsLength(self) -> int: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def modelColumn(self) -> int: ...
    def mousePressEvent(self, e: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, e: PySide2.QtGui.QMouseEvent): ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent): ...
    def removeItem(self, index: int): ...
    def resizeEvent(self, e: PySide2.QtGui.QResizeEvent): ...
    def rootModelIndex(self) -> PySide2.QtCore.QModelIndex: ...
    def setAutoCompletion(self, enable: bool): ...
    def setAutoCompletionCaseSensitivity(self, sensitivity: PySide2.QtCore.Qt.CaseSensitivity): ...
    def setCompleter(self, c: PySide2.QtWidgets.QCompleter): ...
    def setCurrentIndex(self, index: int): ...
    def setCurrentText(self, text: str): ...
    def setDuplicatesEnabled(self, enable: bool): ...
    def setEditText(self, text: str): ...
    def setEditable(self, editable: bool): ...
    def setFrame(self, arg__1: bool): ...
    def setIconSize(self, size: PySide2.QtCore.QSize): ...
    def setInsertPolicy(self, policy: PySide2.QtWidgets.QComboBox.InsertPolicy): ...
    def setItemData(self, index: int, value: typing.Any, role: int = ...): ...
    def setItemDelegate(self, delegate: PySide2.QtWidgets.QAbstractItemDelegate): ...
    def setItemIcon(self, index: int, icon: PySide2.QtGui.QIcon): ...
    def setItemText(self, index: int, text: str): ...
    def setLineEdit(self, edit: PySide2.QtWidgets.QLineEdit): ...
    def setMaxCount(self, max: int): ...
    def setMaxVisibleItems(self, maxItems: int): ...
    def setMinimumContentsLength(self, characters: int): ...
    def setModel(self, model: PySide2.QtCore.QAbstractItemModel): ...
    def setModelColumn(self, visibleColumn: int): ...
    def setRootModelIndex(self, index: PySide2.QtCore.QModelIndex): ...
    def setSizeAdjustPolicy(self, policy: PySide2.QtWidgets.QComboBox.SizeAdjustPolicy): ...
    def setValidator(self, v: PySide2.QtGui.QValidator): ...
    def setView(self, itemView: PySide2.QtWidgets.QAbstractItemView): ...
    def showEvent(self, e: PySide2.QtGui.QShowEvent): ...
    def showPopup(self): ...
    def sizeAdjustPolicy(self) -> PySide2.QtWidgets.QComboBox.SizeAdjustPolicy: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def validator(self) -> PySide2.QtGui.QValidator: ...
    def view(self) -> PySide2.QtWidgets.QAbstractItemView: ...
    def wheelEvent(self, e: PySide2.QtGui.QWheelEvent): ...


class QCommandLinkButton(PySide2.QtWidgets.QPushButton):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, text: str, description: str, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, text: str, parent: PySide2.QtWidgets.QWidget = ...): ...
    def description(self) -> str: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent): ...
    def setDescription(self, description: str): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...


class QCommonStyle(PySide2.QtWidgets.QStyle):

    def __init__(self): ...
    def drawComplexControl(self, cc: PySide2.QtWidgets.QStyle.ComplexControl, opt: PySide2.QtWidgets.QStyleOptionComplex, p: PySide2.QtGui.QPainter, w: PySide2.QtWidgets.QWidget = ...): ...
    def drawControl(self, element: PySide2.QtWidgets.QStyle.ControlElement, opt: PySide2.QtWidgets.QStyleOption, p: PySide2.QtGui.QPainter, w: PySide2.QtWidgets.QWidget = ...): ...
    def drawPrimitive(self, pe: PySide2.QtWidgets.QStyle.PrimitiveElement, opt: PySide2.QtWidgets.QStyleOption, p: PySide2.QtGui.QPainter, w: PySide2.QtWidgets.QWidget = ...): ...
    def generatedIconPixmap(self, iconMode: PySide2.QtGui.QIcon.Mode, pixmap: PySide2.QtGui.QPixmap, opt: PySide2.QtWidgets.QStyleOption) -> PySide2.QtGui.QPixmap: ...
    def hitTestComplexControl(self, cc: PySide2.QtWidgets.QStyle.ComplexControl, opt: PySide2.QtWidgets.QStyleOptionComplex, pt: PySide2.QtCore.QPoint, w: PySide2.QtWidgets.QWidget = ...) -> PySide2.QtWidgets.QStyle.SubControl: ...
    def layoutSpacing(self, control1: PySide2.QtWidgets.QSizePolicy.ControlType, control2: PySide2.QtWidgets.QSizePolicy.ControlType, orientation: PySide2.QtCore.Qt.Orientation, option: PySide2.QtWidgets.QStyleOption = ..., widget: PySide2.QtWidgets.QWidget = ...) -> int: ...
    def pixelMetric(self, m: PySide2.QtWidgets.QStyle.PixelMetric, opt: PySide2.QtWidgets.QStyleOption = ..., widget: PySide2.QtWidgets.QWidget = ...) -> int: ...
    @typing.overload
    def polish(self, app: PySide2.QtWidgets.QApplication): ...
    @typing.overload
    def polish(self, application: PySide2.QtWidgets.QApplication): ...
    @typing.overload
    def polish(self, arg__1: PySide2.QtGui.QPalette): ...
    @typing.overload
    def polish(self, widget: PySide2.QtWidgets.QWidget): ...
    def sizeFromContents(self, ct: PySide2.QtWidgets.QStyle.ContentsType, opt: PySide2.QtWidgets.QStyleOption, contentsSize: PySide2.QtCore.QSize, widget: PySide2.QtWidgets.QWidget = ...) -> PySide2.QtCore.QSize: ...
    def standardIcon(self, standardIcon: PySide2.QtWidgets.QStyle.StandardPixmap, opt: PySide2.QtWidgets.QStyleOption = ..., widget: PySide2.QtWidgets.QWidget = ...) -> PySide2.QtGui.QIcon: ...
    def standardPixmap(self, sp: PySide2.QtWidgets.QStyle.StandardPixmap, opt: PySide2.QtWidgets.QStyleOption = ..., widget: PySide2.QtWidgets.QWidget = ...) -> PySide2.QtGui.QPixmap: ...
    def styleHint(self, sh: PySide2.QtWidgets.QStyle.StyleHint, opt: PySide2.QtWidgets.QStyleOption = ..., w: PySide2.QtWidgets.QWidget = ..., shret: PySide2.QtWidgets.QStyleHintReturn = ...) -> int: ...
    def subControlRect(self, cc: PySide2.QtWidgets.QStyle.ComplexControl, opt: PySide2.QtWidgets.QStyleOptionComplex, sc: PySide2.QtWidgets.QStyle.SubControl, w: PySide2.QtWidgets.QWidget = ...) -> PySide2.QtCore.QRect: ...
    def subElementRect(self, r: PySide2.QtWidgets.QStyle.SubElement, opt: PySide2.QtWidgets.QStyleOption, widget: PySide2.QtWidgets.QWidget = ...) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def unpolish(self, application: PySide2.QtWidgets.QApplication): ...
    @typing.overload
    def unpolish(self, widget: PySide2.QtWidgets.QWidget): ...


class QCompleter(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, completions: typing.List[str], parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, model: PySide2.QtCore.QAbstractItemModel, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def caseSensitivity(self) -> PySide2.QtCore.Qt.CaseSensitivity: ...
    def complete(self, rect: PySide2.QtCore.QRect = ...): ...
    def completionColumn(self) -> int: ...
    def completionCount(self) -> int: ...
    def completionMode(self) -> PySide2.QtWidgets.QCompleter.CompletionMode: ...
    def completionModel(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def completionPrefix(self) -> str: ...
    def completionRole(self) -> int: ...
    def currentCompletion(self) -> str: ...
    def currentIndex(self) -> PySide2.QtCore.QModelIndex: ...
    def currentRow(self) -> int: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, o: PySide2.QtCore.QObject, e: PySide2.QtCore.QEvent) -> bool: ...
    def filterMode(self) -> PySide2.QtCore.Qt.MatchFlags: ...
    def maxVisibleItems(self) -> int: ...
    def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def modelSorting(self) -> PySide2.QtWidgets.QCompleter.ModelSorting: ...
    def pathFromIndex(self, index: PySide2.QtCore.QModelIndex) -> str: ...
    def popup(self) -> PySide2.QtWidgets.QAbstractItemView: ...
    def setCaseSensitivity(self, caseSensitivity: PySide2.QtCore.Qt.CaseSensitivity): ...
    def setCompletionColumn(self, column: int): ...
    def setCompletionMode(self, mode: PySide2.QtWidgets.QCompleter.CompletionMode): ...
    def setCompletionPrefix(self, prefix: str): ...
    def setCompletionRole(self, role: int): ...
    def setCurrentRow(self, row: int) -> bool: ...
    def setFilterMode(self, filterMode: PySide2.QtCore.Qt.MatchFlags): ...
    def setMaxVisibleItems(self, maxItems: int): ...
    def setModel(self, c: PySide2.QtCore.QAbstractItemModel): ...
    def setModelSorting(self, sorting: PySide2.QtWidgets.QCompleter.ModelSorting): ...
    def setPopup(self, popup: PySide2.QtWidgets.QAbstractItemView): ...
    def setWidget(self, widget: PySide2.QtWidgets.QWidget): ...
    def setWrapAround(self, wrap: bool): ...
    def splitPath(self, path: str) -> typing.List[str]: ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...
    def wrapAround(self) -> bool: ...


class QDataWidgetMapper(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def addMapping(self, widget: PySide2.QtWidgets.QWidget, section: int): ...
    @typing.overload
    def addMapping(self, widget: PySide2.QtWidgets.QWidget, section: int, propertyName: PySide2.QtCore.QByteArray): ...
    def clearMapping(self): ...
    def currentIndex(self) -> int: ...
    def itemDelegate(self) -> PySide2.QtWidgets.QAbstractItemDelegate: ...
    def mappedPropertyName(self, widget: PySide2.QtWidgets.QWidget) -> PySide2.QtCore.QByteArray: ...
    def mappedSection(self, widget: PySide2.QtWidgets.QWidget) -> int: ...
    def mappedWidgetAt(self, section: int) -> PySide2.QtWidgets.QWidget: ...
    def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def removeMapping(self, widget: PySide2.QtWidgets.QWidget): ...
    def revert(self): ...
    def rootIndex(self) -> PySide2.QtCore.QModelIndex: ...
    def setCurrentIndex(self, index: int): ...
    def setCurrentModelIndex(self, index: PySide2.QtCore.QModelIndex): ...
    def setItemDelegate(self, delegate: PySide2.QtWidgets.QAbstractItemDelegate): ...
    def setModel(self, model: PySide2.QtCore.QAbstractItemModel): ...
    def setOrientation(self, aOrientation: PySide2.QtCore.Qt.Orientation): ...
    def setRootIndex(self, index: PySide2.QtCore.QModelIndex): ...
    def setSubmitPolicy(self, policy: PySide2.QtWidgets.QDataWidgetMapper.SubmitPolicy): ...
    def submit(self) -> bool: ...
    def submitPolicy(self) -> PySide2.QtWidgets.QDataWidgetMapper.SubmitPolicy: ...
    def toFirst(self): ...
    def toLast(self): ...
    def toNext(self): ...
    def toPrevious(self): ...


class QDateEdit(PySide2.QtWidgets.QDateTimeEdit):

    @typing.overload
    def __init__(self, date: PySide2.QtCore.QDate, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...


class QDateTimeEdit(PySide2.QtWidgets.QAbstractSpinBox):

    @typing.overload
    def __init__(self, d: PySide2.QtCore.QDate, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, dt: PySide2.QtCore.QDateTime, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, t: PySide2.QtCore.QTime, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, val: typing.Any, parserType: type, parent: PySide2.QtWidgets.QWidget = ...): ...
    def calendarPopup(self) -> bool: ...
    def calendarWidget(self) -> PySide2.QtWidgets.QCalendarWidget: ...
    def clear(self): ...
    def clearMaximumDate(self): ...
    def clearMaximumDateTime(self): ...
    def clearMaximumTime(self): ...
    def clearMinimumDate(self): ...
    def clearMinimumDateTime(self): ...
    def clearMinimumTime(self): ...
    def currentSection(self) -> PySide2.QtWidgets.QDateTimeEdit.Section: ...
    def currentSectionIndex(self) -> int: ...
    def date(self) -> PySide2.QtCore.QDate: ...
    def dateTime(self) -> PySide2.QtCore.QDateTime: ...
    def dateTimeFromText(self, text: str) -> PySide2.QtCore.QDateTime: ...
    def displayFormat(self) -> str: ...
    def displayedSections(self) -> PySide2.QtWidgets.QDateTimeEdit.Sections: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def fixup(self, input: str): ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent): ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionSpinBox): ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent): ...
    def maximumDate(self) -> PySide2.QtCore.QDate: ...
    def maximumDateTime(self) -> PySide2.QtCore.QDateTime: ...
    def maximumTime(self) -> PySide2.QtCore.QTime: ...
    def minimumDate(self) -> PySide2.QtCore.QDate: ...
    def minimumDateTime(self) -> PySide2.QtCore.QDateTime: ...
    def minimumTime(self) -> PySide2.QtCore.QTime: ...
    def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent): ...
    def sectionAt(self, index: int) -> PySide2.QtWidgets.QDateTimeEdit.Section: ...
    def sectionCount(self) -> int: ...
    def sectionText(self, section: PySide2.QtWidgets.QDateTimeEdit.Section) -> str: ...
    def setCalendarPopup(self, enable: bool): ...
    def setCalendarWidget(self, calendarWidget: PySide2.QtWidgets.QCalendarWidget): ...
    def setCurrentSection(self, section: PySide2.QtWidgets.QDateTimeEdit.Section): ...
    def setCurrentSectionIndex(self, index: int): ...
    def setDate(self, date: PySide2.QtCore.QDate): ...
    def setDateRange(self, min: PySide2.QtCore.QDate, max: PySide2.QtCore.QDate): ...
    def setDateTime(self, dateTime: PySide2.QtCore.QDateTime): ...
    def setDateTimeRange(self, min: PySide2.QtCore.QDateTime, max: PySide2.QtCore.QDateTime): ...
    def setDisplayFormat(self, format: str): ...
    def setMaximumDate(self, max: PySide2.QtCore.QDate): ...
    def setMaximumDateTime(self, dt: PySide2.QtCore.QDateTime): ...
    def setMaximumTime(self, max: PySide2.QtCore.QTime): ...
    def setMinimumDate(self, min: PySide2.QtCore.QDate): ...
    def setMinimumDateTime(self, dt: PySide2.QtCore.QDateTime): ...
    def setMinimumTime(self, min: PySide2.QtCore.QTime): ...
    def setSelectedSection(self, section: PySide2.QtWidgets.QDateTimeEdit.Section): ...
    def setTime(self, time: PySide2.QtCore.QTime): ...
    def setTimeRange(self, min: PySide2.QtCore.QTime, max: PySide2.QtCore.QTime): ...
    def setTimeSpec(self, spec: PySide2.QtCore.Qt.TimeSpec): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def stepBy(self, steps: int): ...
    def stepEnabled(self) -> PySide2.QtWidgets.QAbstractSpinBox.StepEnabled: ...
    def textFromDateTime(self, dt: PySide2.QtCore.QDateTime) -> str: ...
    def time(self) -> PySide2.QtCore.QTime: ...
    def timeSpec(self) -> PySide2.QtCore.Qt.TimeSpec: ...
    def validate(self, input: str, pos: int) -> PySide2.QtGui.QValidator.State: ...
    def wheelEvent(self, event: PySide2.QtGui.QWheelEvent): ...


class QDesktopWidget(PySide2.QtWidgets.QWidget):

    def __init__(self): ...
    @typing.overload
    def availableGeometry(self, point: PySide2.QtCore.QPoint) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def availableGeometry(self, screen: int = ...) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def availableGeometry(self, widget: PySide2.QtWidgets.QWidget) -> PySide2.QtCore.QRect: ...
    def isVirtualDesktop(self) -> bool: ...
    def numScreens(self) -> int: ...
    def primaryScreen(self) -> int: ...
    def resizeEvent(self, e: PySide2.QtGui.QResizeEvent): ...
    def screen(self, screen: int = ...) -> PySide2.QtWidgets.QWidget: ...
    def screenCount(self) -> int: ...
    @typing.overload
    def screenGeometry(self, point: PySide2.QtCore.QPoint) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def screenGeometry(self, screen: int = ...) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def screenGeometry(self, widget: PySide2.QtWidgets.QWidget) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def screenNumber(self, arg__1: PySide2.QtCore.QPoint) -> int: ...
    @typing.overload
    def screenNumber(self, widget: PySide2.QtWidgets.QWidget = ...) -> int: ...


class QDial(PySide2.QtWidgets.QAbstractSlider):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionSlider): ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, me: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, me: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, me: PySide2.QtGui.QMouseEvent): ...
    def notchSize(self) -> int: ...
    def notchTarget(self) -> float: ...
    def notchesVisible(self) -> bool: ...
    def paintEvent(self, pe: PySide2.QtGui.QPaintEvent): ...
    def resizeEvent(self, re: PySide2.QtGui.QResizeEvent): ...
    def setNotchTarget(self, target: float): ...
    def setNotchesVisible(self, visible: bool): ...
    def setWrapping(self, on: bool): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sliderChange(self, change: PySide2.QtWidgets.QAbstractSlider.SliderChange): ...
    def wrapping(self) -> bool: ...


class QDialog(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ..., f: PySide2.QtCore.Qt.WindowFlags = ...): ...
    def accept(self): ...
    def adjustPosition(self, arg__1: PySide2.QtWidgets.QWidget): ...
    def closeEvent(self, arg__1: PySide2.QtGui.QCloseEvent): ...
    def contextMenuEvent(self, arg__1: PySide2.QtGui.QContextMenuEvent): ...
    def done(self, arg__1: int): ...
    def eventFilter(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    def exec_(self) -> int: ...
    def extension(self) -> PySide2.QtWidgets.QWidget: ...
    def isSizeGripEnabled(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent): ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def open(self): ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def reject(self): ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent): ...
    def result(self) -> int: ...
    def setExtension(self, extension: PySide2.QtWidgets.QWidget): ...
    def setModal(self, modal: bool): ...
    def setOrientation(self, orientation: PySide2.QtCore.Qt.Orientation): ...
    def setResult(self, r: int): ...
    def setSizeGripEnabled(self, arg__1: bool): ...
    def setVisible(self, visible: bool): ...
    def showEvent(self, arg__1: PySide2.QtGui.QShowEvent): ...
    def showExtension(self, arg__1: bool): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...


class QDialogButtonBox(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, buttons: PySide2.QtWidgets.QDialogButtonBox.StandardButtons, orientation: PySide2.QtCore.Qt.Orientation, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, buttons: PySide2.QtWidgets.QDialogButtonBox.StandardButtons, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, orientation: PySide2.QtCore.Qt.Orientation, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def addButton(self, button: PySide2.QtWidgets.QAbstractButton, role: PySide2.QtWidgets.QDialogButtonBox.ButtonRole): ...
    @typing.overload
    def addButton(self, button: PySide2.QtWidgets.QDialogButtonBox.StandardButton) -> PySide2.QtWidgets.QPushButton: ...
    @typing.overload
    def addButton(self, text: str, role: PySide2.QtWidgets.QDialogButtonBox.ButtonRole) -> PySide2.QtWidgets.QPushButton: ...
    def button(self, which: PySide2.QtWidgets.QDialogButtonBox.StandardButton) -> PySide2.QtWidgets.QPushButton: ...
    def buttonRole(self, button: PySide2.QtWidgets.QAbstractButton) -> PySide2.QtWidgets.QDialogButtonBox.ButtonRole: ...
    def buttons(self) -> typing.List[PySide2.QtWidgets.QAbstractButton]: ...
    def centerButtons(self) -> bool: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent): ...
    def clear(self): ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def removeButton(self, button: PySide2.QtWidgets.QAbstractButton): ...
    def setCenterButtons(self, center: bool): ...
    def setOrientation(self, orientation: PySide2.QtCore.Qt.Orientation): ...
    def setStandardButtons(self, buttons: PySide2.QtWidgets.QDialogButtonBox.StandardButtons): ...
    def standardButton(self, button: PySide2.QtWidgets.QAbstractButton) -> PySide2.QtWidgets.QDialogButtonBox.StandardButton: ...
    def standardButtons(self) -> PySide2.QtWidgets.QDialogButtonBox.StandardButtons: ...


class QDirModel(PySide2.QtCore.QAbstractItemModel):

    @typing.overload
    def __init__(self, nameFilters: typing.List[str], filters: PySide2.QtCore.QDir.Filters, sort: PySide2.QtCore.QDir.SortFlags, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def columnCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def data(self, index: PySide2.QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def dropMimeData(self, data: PySide2.QtCore.QMimeData, action: PySide2.QtCore.Qt.DropAction, row: int, column: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def fileIcon(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtGui.QIcon: ...
    def fileInfo(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QFileInfo: ...
    def fileName(self, index: PySide2.QtCore.QModelIndex) -> str: ...
    def filePath(self, index: PySide2.QtCore.QModelIndex) -> str: ...
    def filter(self) -> PySide2.QtCore.QDir.Filters: ...
    def flags(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.Qt.ItemFlags: ...
    def hasChildren(self, index: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def headerData(self, section: int, orientation: PySide2.QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def iconProvider(self) -> PySide2.QtWidgets.QFileIconProvider: ...
    @typing.overload
    def index(self, path: str, column: int = ...) -> PySide2.QtCore.QModelIndex: ...
    @typing.overload
    def index(self, row: int, column: int, parent: PySide2.QtCore.QModelIndex = ...) -> PySide2.QtCore.QModelIndex: ...
    def isDir(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def lazyChildCount(self) -> bool: ...
    def mimeData(self, indexes: typing.List[int]) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    def mkdir(self, parent: PySide2.QtCore.QModelIndex, name: str) -> PySide2.QtCore.QModelIndex: ...
    def nameFilters(self) -> typing.List[str]: ...
    @typing.overload
    def parent(self) -> PySide2.QtCore.QObject: ...
    @typing.overload
    def parent(self, child: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def refresh(self, parent: PySide2.QtCore.QModelIndex = ...): ...
    def remove(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def resolveSymlinks(self) -> bool: ...
    def rmdir(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def rowCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def setData(self, index: PySide2.QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def setFilter(self, filters: PySide2.QtCore.QDir.Filters): ...
    def setIconProvider(self, provider: PySide2.QtWidgets.QFileIconProvider): ...
    def setLazyChildCount(self, enable: bool): ...
    def setNameFilters(self, filters: typing.List[str]): ...
    def setReadOnly(self, enable: bool): ...
    def setResolveSymlinks(self, enable: bool): ...
    def setSorting(self, sort: PySide2.QtCore.QDir.SortFlags): ...
    def sort(self, column: int, order: PySide2.QtCore.Qt.SortOrder = ...): ...
    def sorting(self) -> PySide2.QtCore.QDir.SortFlags: ...
    def supportedDropActions(self) -> PySide2.QtCore.Qt.DropActions: ...


class QDockWidget(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...): ...
    @typing.overload
    def __init__(self, title: str, parent: PySide2.QtWidgets.QWidget = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...): ...
    def allowedAreas(self) -> PySide2.QtCore.Qt.DockWidgetAreas: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent): ...
    def closeEvent(self, event: PySide2.QtGui.QCloseEvent): ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def features(self) -> PySide2.QtWidgets.QDockWidget.DockWidgetFeatures: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionDockWidget): ...
    def isAreaAllowed(self, area: PySide2.QtCore.Qt.DockWidgetArea) -> bool: ...
    def isFloating(self) -> bool: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent): ...
    def setAllowedAreas(self, areas: PySide2.QtCore.Qt.DockWidgetAreas): ...
    def setFeatures(self, features: PySide2.QtWidgets.QDockWidget.DockWidgetFeatures): ...
    def setFloating(self, floating: bool): ...
    def setTitleBarWidget(self, widget: PySide2.QtWidgets.QWidget): ...
    def setWidget(self, widget: PySide2.QtWidgets.QWidget): ...
    def titleBarWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def toggleViewAction(self) -> PySide2.QtWidgets.QAction: ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QDoubleSpinBox(PySide2.QtWidgets.QAbstractSpinBox):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def cleanText(self) -> str: ...
    def decimals(self) -> int: ...
    def fixup(self, str: str): ...
    def maximum(self) -> float: ...
    def minimum(self) -> float: ...
    def prefix(self) -> str: ...
    def setDecimals(self, prec: int): ...
    def setMaximum(self, max: float): ...
    def setMinimum(self, min: float): ...
    def setPrefix(self, prefix: str): ...
    def setRange(self, min: float, max: float): ...
    def setSingleStep(self, val: float): ...
    def setStepType(self, stepType: PySide2.QtWidgets.QAbstractSpinBox.StepType): ...
    def setSuffix(self, suffix: str): ...
    def setValue(self, val: float): ...
    def singleStep(self) -> float: ...
    def stepType(self) -> PySide2.QtWidgets.QAbstractSpinBox.StepType: ...
    def suffix(self) -> str: ...
    def textFromValue(self, val: float) -> str: ...
    def validate(self, input: str, pos: int) -> PySide2.QtGui.QValidator.State: ...
    def value(self) -> float: ...
    def valueFromText(self, text: str) -> float: ...


class QErrorMessage(PySide2.QtWidgets.QDialog):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def changeEvent(self, e: PySide2.QtCore.QEvent): ...
    def done(self, arg__1: int): ...
    @staticmethod
    def qtHandler() -> PySide2.QtWidgets.QErrorMessage: ...
    @typing.overload
    def showMessage(self, message: str): ...
    @typing.overload
    def showMessage(self, message: str, type: str): ...


class QFileDialog(PySide2.QtWidgets.QDialog):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget, f: PySide2.QtCore.Qt.WindowFlags): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ..., caption: str = ..., directory: str = ..., filter: str = ...): ...
    def accept(self): ...
    def acceptMode(self) -> PySide2.QtWidgets.QFileDialog.AcceptMode: ...
    def changeEvent(self, e: PySide2.QtCore.QEvent): ...
    def confirmOverwrite(self) -> bool: ...
    def defaultSuffix(self) -> str: ...
    def directory(self) -> PySide2.QtCore.QDir: ...
    def directoryUrl(self) -> PySide2.QtCore.QUrl: ...
    def done(self, result: int): ...
    def fileMode(self) -> PySide2.QtWidgets.QFileDialog.FileMode: ...
    def filter(self) -> PySide2.QtCore.QDir.Filters: ...
    @staticmethod
    def getExistingDirectory(parent: PySide2.QtWidgets.QWidget = ..., caption: str = ..., dir: str = ..., options: PySide2.QtWidgets.QFileDialog.Options = ...) -> str: ...
    @staticmethod
    def getExistingDirectoryUrl(parent: PySide2.QtWidgets.QWidget = ..., caption: str = ..., dir: PySide2.QtCore.QUrl = ..., options: PySide2.QtWidgets.QFileDialog.Options = ..., supportedSchemes: typing.List[str] = ...) -> PySide2.QtCore.QUrl: ...
    @staticmethod
    def getOpenFileName(parent: PySide2.QtWidgets.QWidget = ..., caption: str = ..., dir: str = ..., filter: str = ..., selectedFilter: str = ..., options: PySide2.QtWidgets.QFileDialog.Options = ...) -> str: ...
    @staticmethod
    def getOpenFileNames(parent: PySide2.QtWidgets.QWidget = ..., caption: str = ..., dir: str = ..., filter: str = ..., selectedFilter: str = ..., options: PySide2.QtWidgets.QFileDialog.Options = ...) -> typing.List[str]: ...
    @staticmethod
    def getOpenFileUrl(parent: PySide2.QtWidgets.QWidget = ..., caption: str = ..., dir: PySide2.QtCore.QUrl = ..., filter: str = ..., selectedFilter: str = ..., options: PySide2.QtWidgets.QFileDialog.Options = ..., supportedSchemes: typing.List[str] = ...) -> PySide2.QtCore.QUrl: ...
    @staticmethod
    def getOpenFileUrls(parent: PySide2.QtWidgets.QWidget = ..., caption: str = ..., dir: PySide2.QtCore.QUrl = ..., filter: str = ..., selectedFilter: str = ..., options: PySide2.QtWidgets.QFileDialog.Options = ..., supportedSchemes: typing.List[str] = ...) -> typing.List[PySide2.QtCore.QUrl]: ...
    @staticmethod
    def getSaveFileName(parent: PySide2.QtWidgets.QWidget = ..., caption: str = ..., dir: str = ..., filter: str = ..., selectedFilter: str = ..., options: PySide2.QtWidgets.QFileDialog.Options = ...) -> str: ...
    @staticmethod
    def getSaveFileUrl(parent: PySide2.QtWidgets.QWidget = ..., caption: str = ..., dir: PySide2.QtCore.QUrl = ..., filter: str = ..., selectedFilter: str = ..., options: PySide2.QtWidgets.QFileDialog.Options = ..., supportedSchemes: typing.List[str] = ...) -> PySide2.QtCore.QUrl: ...
    def history(self) -> typing.List[str]: ...
    def iconProvider(self) -> PySide2.QtWidgets.QFileIconProvider: ...
    def isNameFilterDetailsVisible(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def itemDelegate(self) -> PySide2.QtWidgets.QAbstractItemDelegate: ...
    def labelText(self, label: PySide2.QtWidgets.QFileDialog.DialogLabel) -> str: ...
    def mimeTypeFilters(self) -> typing.List[str]: ...
    def nameFilters(self) -> typing.List[str]: ...
    @typing.overload
    def open(self): ...
    @typing.overload
    def open(self, receiver: PySide2.QtCore.QObject, member: str): ...
    def options(self) -> PySide2.QtWidgets.QFileDialog.Options: ...
    def proxyModel(self) -> PySide2.QtCore.QAbstractProxyModel: ...
    def resolveSymlinks(self) -> bool: ...
    def restoreState(self, state: PySide2.QtCore.QByteArray) -> bool: ...
    def saveState(self) -> PySide2.QtCore.QByteArray: ...
    def selectFile(self, filename: str): ...
    def selectMimeTypeFilter(self, filter: str): ...
    def selectNameFilter(self, filter: str): ...
    def selectUrl(self, url: PySide2.QtCore.QUrl): ...
    def selectedFiles(self) -> typing.List[str]: ...
    def selectedMimeTypeFilter(self) -> str: ...
    def selectedNameFilter(self) -> str: ...
    def selectedUrls(self) -> typing.List[PySide2.QtCore.QUrl]: ...
    def setAcceptMode(self, mode: PySide2.QtWidgets.QFileDialog.AcceptMode): ...
    def setConfirmOverwrite(self, enabled: bool): ...
    def setDefaultSuffix(self, suffix: str): ...
    @typing.overload
    def setDirectory(self, directory: PySide2.QtCore.QDir): ...
    @typing.overload
    def setDirectory(self, directory: str): ...
    def setDirectoryUrl(self, directory: PySide2.QtCore.QUrl): ...
    def setFileMode(self, mode: PySide2.QtWidgets.QFileDialog.FileMode): ...
    def setFilter(self, filters: PySide2.QtCore.QDir.Filters): ...
    def setHistory(self, paths: typing.List[str]): ...
    def setIconProvider(self, provider: PySide2.QtWidgets.QFileIconProvider): ...
    def setItemDelegate(self, delegate: PySide2.QtWidgets.QAbstractItemDelegate): ...
    def setLabelText(self, label: PySide2.QtWidgets.QFileDialog.DialogLabel, text: str): ...
    def setMimeTypeFilters(self, filters: typing.List[str]): ...
    def setNameFilter(self, filter: str): ...
    def setNameFilterDetailsVisible(self, enabled: bool): ...
    def setNameFilters(self, filters: typing.List[str]): ...
    def setOption(self, option: PySide2.QtWidgets.QFileDialog.Option, on: bool = ...): ...
    def setOptions(self, options: PySide2.QtWidgets.QFileDialog.Options): ...
    def setProxyModel(self, model: PySide2.QtCore.QAbstractProxyModel): ...
    def setReadOnly(self, enabled: bool): ...
    def setResolveSymlinks(self, enabled: bool): ...
    def setSidebarUrls(self, urls: typing.List[PySide2.QtCore.QUrl]): ...
    def setSupportedSchemes(self, schemes: typing.List[str]): ...
    def setViewMode(self, mode: PySide2.QtWidgets.QFileDialog.ViewMode): ...
    def setVisible(self, visible: bool): ...
    def sidebarUrls(self) -> typing.List[PySide2.QtCore.QUrl]: ...
    def supportedSchemes(self) -> typing.List[str]: ...
    def testOption(self, option: PySide2.QtWidgets.QFileDialog.Option) -> bool: ...
    def viewMode(self) -> PySide2.QtWidgets.QFileDialog.ViewMode: ...


class QFileIconProvider(Shiboken.Object):

    def __init__(self): ...
    @typing.overload
    def icon(self, info: PySide2.QtCore.QFileInfo) -> PySide2.QtGui.QIcon: ...
    @typing.overload
    def icon(self, type: PySide2.QtWidgets.QFileIconProvider.IconType) -> PySide2.QtGui.QIcon: ...
    def options(self) -> PySide2.QtWidgets.QFileIconProvider.Options: ...
    def setOptions(self, options: PySide2.QtWidgets.QFileIconProvider.Options): ...
    def type(self, info: PySide2.QtCore.QFileInfo) -> str: ...


class QFileSystemModel(PySide2.QtCore.QAbstractItemModel):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def canFetchMore(self, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def columnCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def data(self, index: PySide2.QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def dropMimeData(self, data: PySide2.QtCore.QMimeData, action: PySide2.QtCore.Qt.DropAction, row: int, column: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def fetchMore(self, parent: PySide2.QtCore.QModelIndex): ...
    def fileIcon(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtGui.QIcon: ...
    def fileInfo(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QFileInfo: ...
    def fileName(self, index: PySide2.QtCore.QModelIndex) -> str: ...
    def filePath(self, index: PySide2.QtCore.QModelIndex) -> str: ...
    def filter(self) -> PySide2.QtCore.QDir.Filters: ...
    def flags(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.Qt.ItemFlags: ...
    def hasChildren(self, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def headerData(self, section: int, orientation: PySide2.QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def iconProvider(self) -> PySide2.QtWidgets.QFileIconProvider: ...
    @typing.overload
    def index(self, path: str, column: int = ...) -> PySide2.QtCore.QModelIndex: ...
    @typing.overload
    def index(self, row: int, column: int, parent: PySide2.QtCore.QModelIndex = ...) -> PySide2.QtCore.QModelIndex: ...
    def isDir(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def lastModified(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QDateTime: ...
    def mimeData(self, indexes: typing.List[int]) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    def mkdir(self, parent: PySide2.QtCore.QModelIndex, name: str) -> PySide2.QtCore.QModelIndex: ...
    def myComputer(self, role: int = ...) -> typing.Any: ...
    def nameFilterDisables(self) -> bool: ...
    def nameFilters(self) -> typing.List[str]: ...
    @typing.overload
    def parent(self) -> PySide2.QtCore.QObject: ...
    @typing.overload
    def parent(self, child: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def remove(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def resolveSymlinks(self) -> bool: ...
    def rmdir(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def rootDirectory(self) -> PySide2.QtCore.QDir: ...
    def rootPath(self) -> str: ...
    def rowCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def setData(self, index: PySide2.QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def setFilter(self, filters: PySide2.QtCore.QDir.Filters): ...
    def setIconProvider(self, provider: PySide2.QtWidgets.QFileIconProvider): ...
    def setNameFilterDisables(self, enable: bool): ...
    def setNameFilters(self, filters: typing.List[str]): ...
    def setReadOnly(self, enable: bool): ...
    def setResolveSymlinks(self, enable: bool): ...
    def setRootPath(self, path: str) -> PySide2.QtCore.QModelIndex: ...
    def sibling(self, row: int, column: int, idx: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def size(self, index: PySide2.QtCore.QModelIndex) -> int: ...
    def sort(self, column: int, order: PySide2.QtCore.Qt.SortOrder = ...): ...
    def supportedDropActions(self) -> PySide2.QtCore.Qt.DropActions: ...
    def timerEvent(self, event: PySide2.QtCore.QTimerEvent): ...
    def type(self, index: PySide2.QtCore.QModelIndex) -> str: ...


class QFocusFrame(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOption): ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent): ...
    def setWidget(self, widget: PySide2.QtWidgets.QWidget): ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QFontComboBox(PySide2.QtWidgets.QComboBox):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def currentFont(self) -> PySide2.QtGui.QFont: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def fontFilters(self) -> PySide2.QtWidgets.QFontComboBox.FontFilters: ...
    def setCurrentFont(self, f: PySide2.QtGui.QFont): ...
    def setFontFilters(self, filters: PySide2.QtWidgets.QFontComboBox.FontFilters): ...
    def setWritingSystem(self, arg__1: PySide2.QtGui.QFontDatabase.WritingSystem): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def writingSystem(self) -> PySide2.QtGui.QFontDatabase.WritingSystem: ...


class QFontDialog(PySide2.QtWidgets.QDialog):

    @typing.overload
    def __init__(self, initial: PySide2.QtGui.QFont, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def changeEvent(self, event: PySide2.QtCore.QEvent): ...
    def currentFont(self) -> PySide2.QtGui.QFont: ...
    def done(self, result: int): ...
    def eventFilter(self, object: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    @typing.overload
    @staticmethod
    def getFont(ok: bool, initial: PySide2.QtGui.QFont, parent: PySide2.QtWidgets.QWidget = ..., title: str = ..., options: PySide2.QtWidgets.QFontDialog.FontDialogOptions = ...) -> PySide2.QtGui.QFont: ...
    @typing.overload
    @staticmethod
    def getFont(ok: bool, parent: PySide2.QtWidgets.QWidget = ...) -> PySide2.QtGui.QFont: ...
    @typing.overload
    def open(self): ...
    @typing.overload
    def open(self, receiver: PySide2.QtCore.QObject, member: str): ...
    def options(self) -> PySide2.QtWidgets.QFontDialog.FontDialogOptions: ...
    def selectedFont(self) -> PySide2.QtGui.QFont: ...
    def setCurrentFont(self, font: PySide2.QtGui.QFont): ...
    def setOption(self, option: PySide2.QtWidgets.QFontDialog.FontDialogOption, on: bool = ...): ...
    def setOptions(self, options: PySide2.QtWidgets.QFontDialog.FontDialogOptions): ...
    def setVisible(self, visible: bool): ...
    def testOption(self, option: PySide2.QtWidgets.QFontDialog.FontDialogOption) -> bool: ...


class QFormLayout(PySide2.QtWidgets.QLayout):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def addItem(self, item: PySide2.QtWidgets.QLayoutItem): ...
    @typing.overload
    def addRow(self, label: PySide2.QtWidgets.QWidget, field: PySide2.QtWidgets.QLayout): ...
    @typing.overload
    def addRow(self, label: PySide2.QtWidgets.QWidget, field: PySide2.QtWidgets.QWidget): ...
    @typing.overload
    def addRow(self, labelText: str, field: PySide2.QtWidgets.QLayout): ...
    @typing.overload
    def addRow(self, labelText: str, field: PySide2.QtWidgets.QWidget): ...
    @typing.overload
    def addRow(self, layout: PySide2.QtWidgets.QLayout): ...
    @typing.overload
    def addRow(self, widget: PySide2.QtWidgets.QWidget): ...
    def count(self) -> int: ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def fieldGrowthPolicy(self) -> PySide2.QtWidgets.QFormLayout.FieldGrowthPolicy: ...
    def formAlignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def getItemPosition(self, index: int, rowPtr: int, rolePtr: PySide2.QtWidgets.QFormLayout.ItemRole): ...
    def getLayoutPosition(self, layout: PySide2.QtWidgets.QLayout, rowPtr: int, rolePtr: PySide2.QtWidgets.QFormLayout.ItemRole): ...
    def getWidgetPosition(self, widget: PySide2.QtWidgets.QWidget, rowPtr: int, rolePtr: PySide2.QtWidgets.QFormLayout.ItemRole): ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, width: int) -> int: ...
    def horizontalSpacing(self) -> int: ...
    @typing.overload
    def insertRow(self, row: int, label: PySide2.QtWidgets.QWidget, field: PySide2.QtWidgets.QLayout): ...
    @typing.overload
    def insertRow(self, row: int, label: PySide2.QtWidgets.QWidget, field: PySide2.QtWidgets.QWidget): ...
    @typing.overload
    def insertRow(self, row: int, labelText: str, field: PySide2.QtWidgets.QLayout): ...
    @typing.overload
    def insertRow(self, row: int, labelText: str, field: PySide2.QtWidgets.QWidget): ...
    @typing.overload
    def insertRow(self, row: int, layout: PySide2.QtWidgets.QLayout): ...
    @typing.overload
    def insertRow(self, row: int, widget: PySide2.QtWidgets.QWidget): ...
    def invalidate(self): ...
    @typing.overload
    def itemAt(self, index: int) -> PySide2.QtWidgets.QLayoutItem: ...
    @typing.overload
    def itemAt(self, row: int, role: PySide2.QtWidgets.QFormLayout.ItemRole) -> PySide2.QtWidgets.QLayoutItem: ...
    def labelAlignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    @typing.overload
    def labelForField(self, field: PySide2.QtWidgets.QLayout) -> PySide2.QtWidgets.QWidget: ...
    @typing.overload
    def labelForField(self, field: PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QWidget: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    @typing.overload
    def removeRow(self, layout: PySide2.QtWidgets.QLayout): ...
    @typing.overload
    def removeRow(self, row: int): ...
    @typing.overload
    def removeRow(self, widget: PySide2.QtWidgets.QWidget): ...
    def rowCount(self) -> int: ...
    def rowWrapPolicy(self) -> PySide2.QtWidgets.QFormLayout.RowWrapPolicy: ...
    def setFieldGrowthPolicy(self, policy: PySide2.QtWidgets.QFormLayout.FieldGrowthPolicy): ...
    def setFormAlignment(self, alignment: PySide2.QtCore.Qt.Alignment): ...
    def setGeometry(self, rect: PySide2.QtCore.QRect): ...
    def setHorizontalSpacing(self, spacing: int): ...
    def setItem(self, row: int, role: PySide2.QtWidgets.QFormLayout.ItemRole, item: PySide2.QtWidgets.QLayoutItem): ...
    def setLabelAlignment(self, alignment: PySide2.QtCore.Qt.Alignment): ...
    def setLayout(self, row: int, role: PySide2.QtWidgets.QFormLayout.ItemRole, layout: PySide2.QtWidgets.QLayout): ...
    def setRowWrapPolicy(self, policy: PySide2.QtWidgets.QFormLayout.RowWrapPolicy): ...
    def setSpacing(self, arg__1: int): ...
    def setVerticalSpacing(self, spacing: int): ...
    def setWidget(self, row: int, role: PySide2.QtWidgets.QFormLayout.ItemRole, widget: PySide2.QtWidgets.QWidget): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def spacing(self) -> int: ...
    def takeAt(self, index: int) -> PySide2.QtWidgets.QLayoutItem: ...
    def verticalSpacing(self) -> int: ...


class QFrame(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ..., f: PySide2.QtCore.Qt.WindowFlags = ...): ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent): ...
    def drawFrame(self, arg__1: PySide2.QtGui.QPainter): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def frameRect(self) -> PySide2.QtCore.QRect: ...
    def frameShadow(self) -> PySide2.QtWidgets.QFrame.Shadow: ...
    def frameShape(self) -> PySide2.QtWidgets.QFrame.Shape: ...
    def frameStyle(self) -> int: ...
    def frameWidth(self) -> int: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionFrame): ...
    def lineWidth(self) -> int: ...
    def midLineWidth(self) -> int: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent): ...
    def setFrameRect(self, arg__1: PySide2.QtCore.QRect): ...
    def setFrameShadow(self, arg__1: PySide2.QtWidgets.QFrame.Shadow): ...
    def setFrameShape(self, arg__1: PySide2.QtWidgets.QFrame.Shape): ...
    def setFrameStyle(self, arg__1: int): ...
    def setLineWidth(self, arg__1: int): ...
    def setMidLineWidth(self, arg__1: int): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...


class QGesture(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def gestureCancelPolicy(self) -> PySide2.QtWidgets.QGesture.GestureCancelPolicy: ...
    def gestureType(self) -> PySide2.QtCore.Qt.GestureType: ...
    def hasHotSpot(self) -> bool: ...
    def hotSpot(self) -> PySide2.QtCore.QPointF: ...
    def setGestureCancelPolicy(self, policy: PySide2.QtWidgets.QGesture.GestureCancelPolicy): ...
    def setHotSpot(self, value: PySide2.QtCore.QPointF): ...
    def state(self) -> PySide2.QtCore.Qt.GestureState: ...
    def unsetHotSpot(self): ...


class QGestureEvent(PySide2.QtCore.QEvent):

    def __init__(self, gestures: typing.List[PySide2.QtWidgets.QGesture]): ...
    @typing.overload
    def accept(self): ...
    @typing.overload
    def accept(self, arg__1: PySide2.QtCore.Qt.GestureType): ...
    @typing.overload
    def accept(self, arg__1: PySide2.QtWidgets.QGesture): ...
    def activeGestures(self) -> typing.List[PySide2.QtWidgets.QGesture]: ...
    def canceledGestures(self) -> typing.List[PySide2.QtWidgets.QGesture]: ...
    def gesture(self, type: PySide2.QtCore.Qt.GestureType) -> PySide2.QtWidgets.QGesture: ...
    def gestures(self) -> typing.List[PySide2.QtWidgets.QGesture]: ...
    @typing.overload
    def ignore(self): ...
    @typing.overload
    def ignore(self, arg__1: PySide2.QtCore.Qt.GestureType): ...
    @typing.overload
    def ignore(self, arg__1: PySide2.QtWidgets.QGesture): ...
    @typing.overload
    def isAccepted(self) -> bool: ...
    @typing.overload
    def isAccepted(self, arg__1: PySide2.QtCore.Qt.GestureType) -> bool: ...
    @typing.overload
    def isAccepted(self, arg__1: PySide2.QtWidgets.QGesture) -> bool: ...
    def mapToGraphicsScene(self, gesturePoint: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def setAccepted(self, accepted: bool): ...
    @typing.overload
    def setAccepted(self, arg__1: PySide2.QtCore.Qt.GestureType, arg__2: bool): ...
    @typing.overload
    def setAccepted(self, arg__1: PySide2.QtWidgets.QGesture, arg__2: bool): ...
    def setWidget(self, widget: PySide2.QtWidgets.QWidget): ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QGestureRecognizer(Shiboken.Object):

    def __init__(self): ...
    def create(self, target: PySide2.QtCore.QObject) -> PySide2.QtWidgets.QGesture: ...
    def recognize(self, state: PySide2.QtWidgets.QGesture, watched: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> PySide2.QtWidgets.QGestureRecognizer.Result: ...
    @staticmethod
    def registerRecognizer(recognizer: PySide2.QtWidgets.QGestureRecognizer) -> PySide2.QtCore.Qt.GestureType: ...
    def reset(self, state: PySide2.QtWidgets.QGesture): ...
    @staticmethod
    def unregisterRecognizer(type: PySide2.QtCore.Qt.GestureType): ...


class QGraphicsAnchor(PySide2.QtCore.QObject):

    def setSizePolicy(self, policy: PySide2.QtWidgets.QSizePolicy.Policy): ...
    def setSpacing(self, spacing: float): ...
    def sizePolicy(self) -> PySide2.QtWidgets.QSizePolicy.Policy: ...
    def spacing(self) -> float: ...
    def unsetSpacing(self): ...


class QGraphicsAnchorLayout(PySide2.QtWidgets.QGraphicsLayout):

    def __init__(self, parent: PySide2.QtWidgets.QGraphicsLayoutItem = ...): ...
    def addAnchor(self, firstItem: PySide2.QtWidgets.QGraphicsLayoutItem, firstEdge: PySide2.QtCore.Qt.AnchorPoint, secondItem: PySide2.QtWidgets.QGraphicsLayoutItem, secondEdge: PySide2.QtCore.Qt.AnchorPoint) -> PySide2.QtWidgets.QGraphicsAnchor: ...
    def addAnchors(self, firstItem: PySide2.QtWidgets.QGraphicsLayoutItem, secondItem: PySide2.QtWidgets.QGraphicsLayoutItem, orientations: PySide2.QtCore.Qt.Orientations = ...): ...
    def addCornerAnchors(self, firstItem: PySide2.QtWidgets.QGraphicsLayoutItem, firstCorner: PySide2.QtCore.Qt.Corner, secondItem: PySide2.QtWidgets.QGraphicsLayoutItem, secondCorner: PySide2.QtCore.Qt.Corner): ...
    def anchor(self, firstItem: PySide2.QtWidgets.QGraphicsLayoutItem, firstEdge: PySide2.QtCore.Qt.AnchorPoint, secondItem: PySide2.QtWidgets.QGraphicsLayoutItem, secondEdge: PySide2.QtCore.Qt.AnchorPoint) -> PySide2.QtWidgets.QGraphicsAnchor: ...
    def count(self) -> int: ...
    def horizontalSpacing(self) -> float: ...
    def invalidate(self): ...
    def itemAt(self, index: int) -> PySide2.QtWidgets.QGraphicsLayoutItem: ...
    def removeAt(self, index: int): ...
    def setGeometry(self, rect: PySide2.QtCore.QRectF): ...
    def setHorizontalSpacing(self, spacing: float): ...
    def setSpacing(self, spacing: float): ...
    def setVerticalSpacing(self, spacing: float): ...
    def sizeHint(self, which: PySide2.QtCore.Qt.SizeHint, constraint: PySide2.QtCore.QSizeF = ...) -> PySide2.QtCore.QSizeF: ...
    def verticalSpacing(self) -> float: ...


class QGraphicsBlurEffect(PySide2.QtWidgets.QGraphicsEffect):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def blurHints(self) -> PySide2.QtWidgets.QGraphicsBlurEffect.BlurHints: ...
    def blurRadius(self) -> float: ...
    def boundingRectFor(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def draw(self, painter: PySide2.QtGui.QPainter): ...
    def setBlurHints(self, hints: PySide2.QtWidgets.QGraphicsBlurEffect.BlurHints): ...
    def setBlurRadius(self, blurRadius: float): ...


class QGraphicsColorizeEffect(PySide2.QtWidgets.QGraphicsEffect):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def color(self) -> PySide2.QtGui.QColor: ...
    def draw(self, painter: PySide2.QtGui.QPainter): ...
    def setColor(self, c: PySide2.QtGui.QColor): ...
    def setStrength(self, strength: float): ...
    def strength(self) -> float: ...


class QGraphicsDropShadowEffect(PySide2.QtWidgets.QGraphicsEffect):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def blurRadius(self) -> float: ...
    def boundingRectFor(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def color(self) -> PySide2.QtGui.QColor: ...
    def draw(self, painter: PySide2.QtGui.QPainter): ...
    def offset(self) -> PySide2.QtCore.QPointF: ...
    def setBlurRadius(self, blurRadius: float): ...
    def setColor(self, color: PySide2.QtGui.QColor): ...
    @typing.overload
    def setOffset(self, d: float): ...
    @typing.overload
    def setOffset(self, dx: float, dy: float): ...
    @typing.overload
    def setOffset(self, ofs: PySide2.QtCore.QPointF): ...
    def setXOffset(self, dx: float): ...
    def setYOffset(self, dy: float): ...
    def xOffset(self) -> float: ...
    def yOffset(self) -> float: ...


class QGraphicsEffect(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def boundingRectFor(self, sourceRect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def draw(self, painter: PySide2.QtGui.QPainter): ...
    def drawSource(self, painter: PySide2.QtGui.QPainter): ...
    def isEnabled(self) -> bool: ...
    def setEnabled(self, enable: bool): ...
    def sourceBoundingRect(self, system: PySide2.QtCore.Qt.CoordinateSystem = ...) -> PySide2.QtCore.QRectF: ...
    def sourceChanged(self, flags: PySide2.QtWidgets.QGraphicsEffect.ChangeFlags): ...
    def sourceIsPixmap(self) -> bool: ...
    def sourcePixmap(self, system: PySide2.QtCore.Qt.CoordinateSystem = ..., offset: PySide2.QtCore.QPoint = ..., mode: PySide2.QtWidgets.QGraphicsEffect.PixmapPadMode = ...) -> PySide2.QtGui.QPixmap: ...
    def update(self): ...
    def updateBoundingRect(self): ...


class QGraphicsEllipseItem(PySide2.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QGraphicsItem = ...): ...
    @typing.overload
    def __init__(self, rect: PySide2.QtCore.QRectF, parent: PySide2.QtWidgets.QGraphicsItem = ...): ...
    @typing.overload
    def __init__(self, x: float, y: float, w: float, h: float, parent: PySide2.QtWidgets.QGraphicsItem = ...): ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def isObscuredBy(self, item: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: PySide2.QtWidgets.QWidget = ...): ...
    def rect(self) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def setRect(self, rect: PySide2.QtCore.QRectF): ...
    @typing.overload
    def setRect(self, x: float, y: float, w: float, h: float): ...
    def setSpanAngle(self, angle: int): ...
    def setStartAngle(self, angle: int): ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def spanAngle(self) -> int: ...
    def startAngle(self) -> int: ...
    def type(self) -> int: ...


class QGraphicsGridLayout(PySide2.QtWidgets.QGraphicsLayout):

    def __init__(self, parent: PySide2.QtWidgets.QGraphicsLayoutItem = ...): ...
    @typing.overload
    def addItem(self, item: PySide2.QtWidgets.QGraphicsLayoutItem, row: int, column: int, alignment: PySide2.QtCore.Qt.Alignment = ...): ...
    @typing.overload
    def addItem(self, item: PySide2.QtWidgets.QGraphicsLayoutItem, row: int, column: int, rowSpan: int, columnSpan: int, alignment: PySide2.QtCore.Qt.Alignment = ...): ...
    def alignment(self, item: PySide2.QtWidgets.QGraphicsLayoutItem) -> PySide2.QtCore.Qt.Alignment: ...
    def columnAlignment(self, column: int) -> PySide2.QtCore.Qt.Alignment: ...
    def columnCount(self) -> int: ...
    def columnMaximumWidth(self, column: int) -> float: ...
    def columnMinimumWidth(self, column: int) -> float: ...
    def columnPreferredWidth(self, column: int) -> float: ...
    def columnSpacing(self, column: int) -> float: ...
    def columnStretchFactor(self, column: int) -> int: ...
    def count(self) -> int: ...
    def horizontalSpacing(self) -> float: ...
    def invalidate(self): ...
    @typing.overload
    def itemAt(self, index: int) -> PySide2.QtWidgets.QGraphicsLayoutItem: ...
    @typing.overload
    def itemAt(self, row: int, column: int) -> PySide2.QtWidgets.QGraphicsLayoutItem: ...
    def removeAt(self, index: int): ...
    def removeItem(self, item: PySide2.QtWidgets.QGraphicsLayoutItem): ...
    def rowAlignment(self, row: int) -> PySide2.QtCore.Qt.Alignment: ...
    def rowCount(self) -> int: ...
    def rowMaximumHeight(self, row: int) -> float: ...
    def rowMinimumHeight(self, row: int) -> float: ...
    def rowPreferredHeight(self, row: int) -> float: ...
    def rowSpacing(self, row: int) -> float: ...
    def rowStretchFactor(self, row: int) -> int: ...
    def setAlignment(self, item: PySide2.QtWidgets.QGraphicsLayoutItem, alignment: PySide2.QtCore.Qt.Alignment): ...
    def setColumnAlignment(self, column: int, alignment: PySide2.QtCore.Qt.Alignment): ...
    def setColumnFixedWidth(self, column: int, width: float): ...
    def setColumnMaximumWidth(self, column: int, width: float): ...
    def setColumnMinimumWidth(self, column: int, width: float): ...
    def setColumnPreferredWidth(self, column: int, width: float): ...
    def setColumnSpacing(self, column: int, spacing: float): ...
    def setColumnStretchFactor(self, column: int, stretch: int): ...
    def setGeometry(self, rect: PySide2.QtCore.QRectF): ...
    def setHorizontalSpacing(self, spacing: float): ...
    def setRowAlignment(self, row: int, alignment: PySide2.QtCore.Qt.Alignment): ...
    def setRowFixedHeight(self, row: int, height: float): ...
    def setRowMaximumHeight(self, row: int, height: float): ...
    def setRowMinimumHeight(self, row: int, height: float): ...
    def setRowPreferredHeight(self, row: int, height: float): ...
    def setRowSpacing(self, row: int, spacing: float): ...
    def setRowStretchFactor(self, row: int, stretch: int): ...
    def setSpacing(self, spacing: float): ...
    def setVerticalSpacing(self, spacing: float): ...
    def sizeHint(self, which: PySide2.QtCore.Qt.SizeHint, constraint: PySide2.QtCore.QSizeF = ...) -> PySide2.QtCore.QSizeF: ...
    def verticalSpacing(self) -> float: ...


class QGraphicsItem(Shiboken.Object):

    def __init__(self, parent: PySide2.QtWidgets.QGraphicsItem = ...): ...
    def acceptDrops(self) -> bool: ...
    def acceptHoverEvents(self) -> bool: ...
    def acceptTouchEvents(self) -> bool: ...
    def acceptedMouseButtons(self) -> PySide2.QtCore.Qt.MouseButtons: ...
    def addToIndex(self): ...
    def advance(self, phase: int): ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def boundingRegion(self, itemToDeviceTransform: PySide2.QtGui.QTransform) -> PySide2.QtGui.QRegion: ...
    def boundingRegionGranularity(self) -> float: ...
    def cacheMode(self) -> PySide2.QtWidgets.QGraphicsItem.CacheMode: ...
    def childItems(self) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    def childrenBoundingRect(self) -> PySide2.QtCore.QRectF: ...
    def clearFocus(self): ...
    def clipPath(self) -> PySide2.QtGui.QPainterPath: ...
    def collidesWithItem(self, other: PySide2.QtWidgets.QGraphicsItem, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> bool: ...
    def collidesWithPath(self, path: PySide2.QtGui.QPainterPath, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> bool: ...
    def collidingItems(self, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    def commonAncestorItem(self, other: PySide2.QtWidgets.QGraphicsItem) -> PySide2.QtWidgets.QGraphicsItem: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def contextMenuEvent(self, event: PySide2.QtWidgets.QGraphicsSceneContextMenuEvent): ...
    def cursor(self) -> PySide2.QtGui.QCursor: ...
    def data(self, key: int) -> typing.Any: ...
    def deviceTransform(self, viewportTransform: PySide2.QtGui.QTransform) -> PySide2.QtGui.QTransform: ...
    def dragEnterEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def dragLeaveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def dragMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def dropEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def effectiveOpacity(self) -> float: ...
    @typing.overload
    def ensureVisible(self, rect: PySide2.QtCore.QRectF = ..., xmargin: int = ..., ymargin: int = ...): ...
    @typing.overload
    def ensureVisible(self, x: float, y: float, w: float, h: float, xmargin: int = ..., ymargin: int = ...): ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def filtersChildEvents(self) -> bool: ...
    def flags(self) -> PySide2.QtWidgets.QGraphicsItem.GraphicsItemFlags: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent): ...
    def focusItem(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent): ...
    def focusProxy(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def focusScopeItem(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def grabKeyboard(self): ...
    def grabMouse(self): ...
    def graphicsEffect(self) -> PySide2.QtWidgets.QGraphicsEffect: ...
    def group(self) -> PySide2.QtWidgets.QGraphicsItemGroup: ...
    def handlesChildEvents(self) -> bool: ...
    def hasCursor(self) -> bool: ...
    def hasFocus(self) -> bool: ...
    def hide(self): ...
    def hoverEnterEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHoverEvent): ...
    def hoverLeaveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHoverEvent): ...
    def hoverMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHoverEvent): ...
    def inputMethodEvent(self, event: PySide2.QtGui.QInputMethodEvent): ...
    def inputMethodHints(self) -> PySide2.QtCore.Qt.InputMethodHints: ...
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def installSceneEventFilter(self, filterItem: PySide2.QtWidgets.QGraphicsItem): ...
    def isActive(self) -> bool: ...
    def isAncestorOf(self, child: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def isBlockedByModalPanel(self, blockingPanel: PySide2.QtWidgets.QGraphicsItem = ...) -> bool: ...
    def isClipped(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    @typing.overload
    def isObscured(self, rect: PySide2.QtCore.QRectF = ...) -> bool: ...
    @typing.overload
    def isObscured(self, x: float, y: float, w: float, h: float) -> bool: ...
    def isObscuredBy(self, item: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def isPanel(self) -> bool: ...
    def isSelected(self) -> bool: ...
    def isUnderMouse(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def isVisibleTo(self, parent: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def isWidget(self) -> bool: ...
    def isWindow(self) -> bool: ...
    def itemChange(self, change: PySide2.QtWidgets.QGraphicsItem.GraphicsItemChange, value: typing.Any) -> typing.Any: ...
    def itemTransform(self, other: PySide2.QtWidgets.QGraphicsItem, ok: bool) -> PySide2.QtGui.QTransform: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, event: PySide2.QtGui.QKeyEvent): ...
    @typing.overload
    def mapFromItem(self, item: PySide2.QtWidgets.QGraphicsItem, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapFromItem(self, item: PySide2.QtWidgets.QGraphicsItem, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapFromItem(self, item: PySide2.QtWidgets.QGraphicsItem, polygon: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromItem(self, item: PySide2.QtWidgets.QGraphicsItem, rect: PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromItem(self, item: PySide2.QtWidgets.QGraphicsItem, x: float, y: float) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapFromItem(self, item: PySide2.QtWidgets.QGraphicsItem, x: float, y: float, w: float, h: float) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromParent(self, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapFromParent(self, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapFromParent(self, polygon: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromParent(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromParent(self, x: float, y: float) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapFromParent(self, x: float, y: float, w: float, h: float) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromScene(self, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapFromScene(self, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapFromScene(self, polygon: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromScene(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromScene(self, x: float, y: float) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapFromScene(self, x: float, y: float, w: float, h: float) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapRectFromItem(self, item: PySide2.QtWidgets.QGraphicsItem, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectFromItem(self, item: PySide2.QtWidgets.QGraphicsItem, x: float, y: float, w: float, h: float) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectFromParent(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectFromParent(self, x: float, y: float, w: float, h: float) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectFromScene(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectFromScene(self, x: float, y: float, w: float, h: float) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectToItem(self, item: PySide2.QtWidgets.QGraphicsItem, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectToItem(self, item: PySide2.QtWidgets.QGraphicsItem, x: float, y: float, w: float, h: float) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectToParent(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectToParent(self, x: float, y: float, w: float, h: float) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectToScene(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectToScene(self, x: float, y: float, w: float, h: float) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapToItem(self, item: PySide2.QtWidgets.QGraphicsItem, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapToItem(self, item: PySide2.QtWidgets.QGraphicsItem, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToItem(self, item: PySide2.QtWidgets.QGraphicsItem, polygon: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToItem(self, item: PySide2.QtWidgets.QGraphicsItem, rect: PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToItem(self, item: PySide2.QtWidgets.QGraphicsItem, x: float, y: float) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToItem(self, item: PySide2.QtWidgets.QGraphicsItem, x: float, y: float, w: float, h: float) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToParent(self, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapToParent(self, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToParent(self, polygon: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToParent(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToParent(self, x: float, y: float) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToParent(self, x: float, y: float, w: float, h: float) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToScene(self, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapToScene(self, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToScene(self, polygon: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToScene(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToScene(self, x: float, y: float) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToScene(self, x: float, y: float, w: float, h: float) -> PySide2.QtGui.QPolygonF: ...
    def matrix(self) -> PySide2.QtGui.QMatrix: ...
    def mouseDoubleClickEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mouseMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mousePressEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mouseReleaseEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def moveBy(self, dx: float, dy: float): ...
    def opacity(self) -> float: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: PySide2.QtWidgets.QWidget = ...): ...
    def panel(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def panelModality(self) -> PySide2.QtWidgets.QGraphicsItem.PanelModality: ...
    def parentItem(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def parentObject(self) -> PySide2.QtWidgets.QGraphicsObject: ...
    def parentWidget(self) -> PySide2.QtWidgets.QGraphicsWidget: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def prepareGeometryChange(self): ...
    def removeFromIndex(self): ...
    def removeSceneEventFilter(self, filterItem: PySide2.QtWidgets.QGraphicsItem): ...
    def resetMatrix(self): ...
    def resetTransform(self): ...
    def rotation(self) -> float: ...
    def scale(self) -> float: ...
    def scene(self) -> PySide2.QtWidgets.QGraphicsScene: ...
    def sceneBoundingRect(self) -> PySide2.QtCore.QRectF: ...
    def sceneEvent(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def sceneEventFilter(self, watched: PySide2.QtWidgets.QGraphicsItem, event: PySide2.QtCore.QEvent) -> bool: ...
    def sceneMatrix(self) -> PySide2.QtGui.QMatrix: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def sceneTransform(self) -> PySide2.QtGui.QTransform: ...
    def scroll(self, dx: float, dy: float, rect: PySide2.QtCore.QRectF = ...): ...
    def setAcceptDrops(self, on: bool): ...
    def setAcceptHoverEvents(self, enabled: bool): ...
    def setAcceptTouchEvents(self, enabled: bool): ...
    def setAcceptedMouseButtons(self, buttons: PySide2.QtCore.Qt.MouseButtons): ...
    def setActive(self, active: bool): ...
    def setBoundingRegionGranularity(self, granularity: float): ...
    def setCacheMode(self, mode: PySide2.QtWidgets.QGraphicsItem.CacheMode, cacheSize: PySide2.QtCore.QSize = ...): ...
    def setCursor(self, cursor: PySide2.QtGui.QCursor): ...
    def setData(self, key: int, value: typing.Any): ...
    def setEnabled(self, enabled: bool): ...
    def setFiltersChildEvents(self, enabled: bool): ...
    def setFlag(self, flag: PySide2.QtWidgets.QGraphicsItem.GraphicsItemFlag, enabled: bool = ...): ...
    def setFlags(self, flags: PySide2.QtWidgets.QGraphicsItem.GraphicsItemFlags): ...
    def setFocus(self, focusReason: PySide2.QtCore.Qt.FocusReason = ...): ...
    def setFocusProxy(self, item: PySide2.QtWidgets.QGraphicsItem): ...
    def setGraphicsEffect(self, effect: PySide2.QtWidgets.QGraphicsEffect): ...
    def setGroup(self, group: PySide2.QtWidgets.QGraphicsItemGroup): ...
    def setHandlesChildEvents(self, enabled: bool): ...
    def setInputMethodHints(self, hints: PySide2.QtCore.Qt.InputMethodHints): ...
    def setMatrix(self, matrix: PySide2.QtGui.QMatrix, combine: bool = ...): ...
    def setOpacity(self, opacity: float): ...
    def setPanelModality(self, panelModality: PySide2.QtWidgets.QGraphicsItem.PanelModality): ...
    def setParentItem(self, parent: PySide2.QtWidgets.QGraphicsItem): ...
    @typing.overload
    def setPos(self, pos: PySide2.QtCore.QPointF): ...
    @typing.overload
    def setPos(self, x: float, y: float): ...
    def setRotation(self, angle: float): ...
    def setScale(self, scale: float): ...
    def setSelected(self, selected: bool): ...
    def setToolTip(self, toolTip: str): ...
    def setTransform(self, matrix: PySide2.QtGui.QTransform, combine: bool = ...): ...
    @typing.overload
    def setTransformOriginPoint(self, ax: float, ay: float): ...
    @typing.overload
    def setTransformOriginPoint(self, origin: PySide2.QtCore.QPointF): ...
    def setTransformations(self, transformations: typing.List[PySide2.QtWidgets.QGraphicsTransform]): ...
    def setVisible(self, visible: bool): ...
    def setX(self, x: float): ...
    def setY(self, y: float): ...
    def setZValue(self, z: float): ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def show(self): ...
    def stackBefore(self, sibling: PySide2.QtWidgets.QGraphicsItem): ...
    def toGraphicsObject(self) -> PySide2.QtWidgets.QGraphicsObject: ...
    def toolTip(self) -> str: ...
    def topLevelItem(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def topLevelWidget(self) -> PySide2.QtWidgets.QGraphicsWidget: ...
    def transform(self) -> PySide2.QtGui.QTransform: ...
    def transformOriginPoint(self) -> PySide2.QtCore.QPointF: ...
    def transformations(self) -> typing.List[PySide2.QtWidgets.QGraphicsTransform]: ...
    def type(self) -> int: ...
    def ungrabKeyboard(self): ...
    def ungrabMouse(self): ...
    def unsetCursor(self): ...
    @typing.overload
    def update(self, rect: PySide2.QtCore.QRectF = ...): ...
    @typing.overload
    def update(self, x: float, y: float, width: float, height: float): ...
    def updateMicroFocus(self): ...
    def wheelEvent(self, event: PySide2.QtWidgets.QGraphicsSceneWheelEvent): ...
    def window(self) -> PySide2.QtWidgets.QGraphicsWidget: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def zValue(self) -> float: ...


class QGraphicsItemAnimation(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def afterAnimationStep(self, step: float): ...
    def beforeAnimationStep(self, step: float): ...
    def clear(self): ...
    def horizontalScaleAt(self, step: float) -> float: ...
    def horizontalShearAt(self, step: float) -> float: ...
    def item(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def matrixAt(self, step: float) -> PySide2.QtGui.QMatrix: ...
    def posAt(self, step: float) -> PySide2.QtCore.QPointF: ...
    def posList(self) -> typing.List[typing.Tuple]: ...
    def reset(self): ...
    def rotationAt(self, step: float) -> float: ...
    def rotationList(self) -> typing.List[typing.Tuple]: ...
    def scaleList(self) -> typing.List[typing.Tuple]: ...
    def setItem(self, item: PySide2.QtWidgets.QGraphicsItem): ...
    def setPosAt(self, step: float, pos: PySide2.QtCore.QPointF): ...
    def setRotationAt(self, step: float, angle: float): ...
    def setScaleAt(self, step: float, sx: float, sy: float): ...
    def setShearAt(self, step: float, sh: float, sv: float): ...
    def setStep(self, x: float): ...
    def setTimeLine(self, timeLine: PySide2.QtCore.QTimeLine): ...
    def setTranslationAt(self, step: float, dx: float, dy: float): ...
    def shearList(self) -> typing.List[typing.Tuple]: ...
    def timeLine(self) -> PySide2.QtCore.QTimeLine: ...
    def translationList(self) -> typing.List[typing.Tuple]: ...
    def verticalScaleAt(self, step: float) -> float: ...
    def verticalShearAt(self, step: float) -> float: ...
    def xTranslationAt(self, step: float) -> float: ...
    def yTranslationAt(self, step: float) -> float: ...


class QGraphicsItemGroup(PySide2.QtWidgets.QGraphicsItem):

    def __init__(self, parent: PySide2.QtWidgets.QGraphicsItem = ...): ...
    def addToGroup(self, item: PySide2.QtWidgets.QGraphicsItem): ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def isObscuredBy(self, item: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: PySide2.QtWidgets.QWidget = ...): ...
    def removeFromGroup(self, item: PySide2.QtWidgets.QGraphicsItem): ...
    def type(self) -> int: ...


class QGraphicsLayout(PySide2.QtWidgets.QGraphicsLayoutItem):

    def __init__(self, parent: PySide2.QtWidgets.QGraphicsLayoutItem = ...): ...
    def activate(self): ...
    def addChildLayoutItem(self, layoutItem: PySide2.QtWidgets.QGraphicsLayoutItem): ...
    def count(self) -> int: ...
    def getContentsMargins(self, left: float, top: float, right: float, bottom: float): ...
    @staticmethod
    def instantInvalidatePropagation() -> bool: ...
    def invalidate(self): ...
    def isActivated(self) -> bool: ...
    def itemAt(self, i: int) -> PySide2.QtWidgets.QGraphicsLayoutItem: ...
    def removeAt(self, index: int): ...
    def setContentsMargins(self, left: float, top: float, right: float, bottom: float): ...
    @staticmethod
    def setInstantInvalidatePropagation(enable: bool): ...
    def updateGeometry(self): ...
    def widgetEvent(self, e: PySide2.QtCore.QEvent): ...


class QGraphicsLayoutItem(Shiboken.Object):

    def __init__(self, parent: PySide2.QtWidgets.QGraphicsLayoutItem = ..., isLayout: bool = ...): ...
    def contentsRect(self) -> PySide2.QtCore.QRectF: ...
    def effectiveSizeHint(self, which: PySide2.QtCore.Qt.SizeHint, constraint: PySide2.QtCore.QSizeF = ...) -> PySide2.QtCore.QSizeF: ...
    def geometry(self) -> PySide2.QtCore.QRectF: ...
    def getContentsMargins(self, left: float, top: float, right: float, bottom: float): ...
    def graphicsItem(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def isLayout(self) -> bool: ...
    def maximumHeight(self) -> float: ...
    def maximumSize(self) -> PySide2.QtCore.QSizeF: ...
    def maximumWidth(self) -> float: ...
    def minimumHeight(self) -> float: ...
    def minimumSize(self) -> PySide2.QtCore.QSizeF: ...
    def minimumWidth(self) -> float: ...
    def ownedByLayout(self) -> bool: ...
    def parentLayoutItem(self) -> PySide2.QtWidgets.QGraphicsLayoutItem: ...
    def preferredHeight(self) -> float: ...
    def preferredSize(self) -> PySide2.QtCore.QSizeF: ...
    def preferredWidth(self) -> float: ...
    def setGeometry(self, rect: PySide2.QtCore.QRectF): ...
    def setGraphicsItem(self, item: PySide2.QtWidgets.QGraphicsItem): ...
    def setMaximumHeight(self, height: float): ...
    @typing.overload
    def setMaximumSize(self, size: PySide2.QtCore.QSizeF): ...
    @typing.overload
    def setMaximumSize(self, w: float, h: float): ...
    def setMaximumWidth(self, width: float): ...
    def setMinimumHeight(self, height: float): ...
    @typing.overload
    def setMinimumSize(self, size: PySide2.QtCore.QSizeF): ...
    @typing.overload
    def setMinimumSize(self, w: float, h: float): ...
    def setMinimumWidth(self, width: float): ...
    def setOwnedByLayout(self, ownedByLayout: bool): ...
    def setParentLayoutItem(self, parent: PySide2.QtWidgets.QGraphicsLayoutItem): ...
    def setPreferredHeight(self, height: float): ...
    @typing.overload
    def setPreferredSize(self, size: PySide2.QtCore.QSizeF): ...
    @typing.overload
    def setPreferredSize(self, w: float, h: float): ...
    def setPreferredWidth(self, width: float): ...
    @typing.overload
    def setSizePolicy(self, hPolicy: PySide2.QtWidgets.QSizePolicy.Policy, vPolicy: PySide2.QtWidgets.QSizePolicy.Policy, controlType: PySide2.QtWidgets.QSizePolicy.ControlType = ...): ...
    @typing.overload
    def setSizePolicy(self, policy: PySide2.QtWidgets.QSizePolicy): ...
    def sizeHint(self, which: PySide2.QtCore.Qt.SizeHint, constraint: PySide2.QtCore.QSizeF = ...) -> PySide2.QtCore.QSizeF: ...
    def sizePolicy(self) -> PySide2.QtWidgets.QSizePolicy: ...
    def updateGeometry(self): ...


class QGraphicsLineItem(PySide2.QtWidgets.QGraphicsItem):

    @typing.overload
    def __init__(self, line: PySide2.QtCore.QLineF, parent: PySide2.QtWidgets.QGraphicsItem = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QGraphicsItem = ...): ...
    @typing.overload
    def __init__(self, x1: float, y1: float, x2: float, y2: float, parent: PySide2.QtWidgets.QGraphicsItem = ...): ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def isObscuredBy(self, item: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def line(self) -> PySide2.QtCore.QLineF: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: PySide2.QtWidgets.QWidget = ...): ...
    def pen(self) -> PySide2.QtGui.QPen: ...
    @typing.overload
    def setLine(self, line: PySide2.QtCore.QLineF): ...
    @typing.overload
    def setLine(self, x1: float, y1: float, x2: float, y2: float): ...
    def setPen(self, pen: PySide2.QtGui.QPen): ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def type(self) -> int: ...


class QGraphicsLinearLayout(PySide2.QtWidgets.QGraphicsLayout):

    @typing.overload
    def __init__(self, orientation: PySide2.QtCore.Qt.Orientation, parent: PySide2.QtWidgets.QGraphicsLayoutItem = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QGraphicsLayoutItem = ...): ...
    def addItem(self, item: PySide2.QtWidgets.QGraphicsLayoutItem): ...
    def addStretch(self, stretch: int = ...): ...
    def alignment(self, item: PySide2.QtWidgets.QGraphicsLayoutItem) -> PySide2.QtCore.Qt.Alignment: ...
    def count(self) -> int: ...
    def dump(self, indent: int = ...): ...
    def insertItem(self, index: int, item: PySide2.QtWidgets.QGraphicsLayoutItem): ...
    def insertStretch(self, index: int, stretch: int = ...): ...
    def invalidate(self): ...
    def itemAt(self, index: int) -> PySide2.QtWidgets.QGraphicsLayoutItem: ...
    def itemSpacing(self, index: int) -> float: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def removeAt(self, index: int): ...
    def removeItem(self, item: PySide2.QtWidgets.QGraphicsLayoutItem): ...
    def setAlignment(self, item: PySide2.QtWidgets.QGraphicsLayoutItem, alignment: PySide2.QtCore.Qt.Alignment): ...
    def setGeometry(self, rect: PySide2.QtCore.QRectF): ...
    def setItemSpacing(self, index: int, spacing: float): ...
    def setOrientation(self, orientation: PySide2.QtCore.Qt.Orientation): ...
    def setSpacing(self, spacing: float): ...
    def setStretchFactor(self, item: PySide2.QtWidgets.QGraphicsLayoutItem, stretch: int): ...
    def sizeHint(self, which: PySide2.QtCore.Qt.SizeHint, constraint: PySide2.QtCore.QSizeF = ...) -> PySide2.QtCore.QSizeF: ...
    def spacing(self) -> float: ...
    def stretchFactor(self, item: PySide2.QtWidgets.QGraphicsLayoutItem) -> int: ...


class QGraphicsObject(PySide2.QtWidgets.QGraphicsItem, PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtWidgets.QGraphicsItem = ...): ...
    def event(self, ev: PySide2.QtCore.QEvent) -> bool: ...
    def grabGesture(self, type: PySide2.QtCore.Qt.GestureType, flags: PySide2.QtCore.Qt.GestureFlags = ...): ...
    def ungrabGesture(self, type: PySide2.QtCore.Qt.GestureType): ...
    def updateMicroFocus(self): ...


class QGraphicsOpacityEffect(PySide2.QtWidgets.QGraphicsEffect):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def draw(self, painter: PySide2.QtGui.QPainter): ...
    def opacity(self) -> float: ...
    def opacityMask(self) -> PySide2.QtGui.QBrush: ...
    def setOpacity(self, opacity: float): ...
    def setOpacityMask(self, mask: PySide2.QtGui.QBrush): ...


class QGraphicsPathItem(PySide2.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QGraphicsItem = ...): ...
    @typing.overload
    def __init__(self, path: PySide2.QtGui.QPainterPath, parent: PySide2.QtWidgets.QGraphicsItem = ...): ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def isObscuredBy(self, item: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: PySide2.QtWidgets.QWidget = ...): ...
    def path(self) -> PySide2.QtGui.QPainterPath: ...
    def setPath(self, path: PySide2.QtGui.QPainterPath): ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def type(self) -> int: ...


class QGraphicsPixmapItem(PySide2.QtWidgets.QGraphicsItem):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QGraphicsItem = ...): ...
    @typing.overload
    def __init__(self, pixmap: PySide2.QtGui.QPixmap, parent: PySide2.QtWidgets.QGraphicsItem = ...): ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def isObscuredBy(self, item: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def offset(self) -> PySide2.QtCore.QPointF: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: PySide2.QtWidgets.QWidget): ...
    def pixmap(self) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def setOffset(self, offset: PySide2.QtCore.QPointF): ...
    @typing.overload
    def setOffset(self, x: float, y: float): ...
    def setPixmap(self, pixmap: PySide2.QtGui.QPixmap): ...
    def setShapeMode(self, mode: PySide2.QtWidgets.QGraphicsPixmapItem.ShapeMode): ...
    def setTransformationMode(self, mode: PySide2.QtCore.Qt.TransformationMode): ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def shapeMode(self) -> PySide2.QtWidgets.QGraphicsPixmapItem.ShapeMode: ...
    def transformationMode(self) -> PySide2.QtCore.Qt.TransformationMode: ...
    def type(self) -> int: ...


class QGraphicsPolygonItem(PySide2.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QGraphicsItem = ...): ...
    @typing.overload
    def __init__(self, polygon: PySide2.QtGui.QPolygonF, parent: PySide2.QtWidgets.QGraphicsItem = ...): ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def fillRule(self) -> PySide2.QtCore.Qt.FillRule: ...
    def isObscuredBy(self, item: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: PySide2.QtWidgets.QWidget = ...): ...
    def polygon(self) -> PySide2.QtGui.QPolygonF: ...
    def setFillRule(self, rule: PySide2.QtCore.Qt.FillRule): ...
    def setPolygon(self, polygon: PySide2.QtGui.QPolygonF): ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def type(self) -> int: ...


class QGraphicsProxyWidget(PySide2.QtWidgets.QGraphicsWidget):

    def __init__(self, parent: PySide2.QtWidgets.QGraphicsItem = ..., wFlags: PySide2.QtCore.Qt.WindowFlags = ...): ...
    def contextMenuEvent(self, event: PySide2.QtWidgets.QGraphicsSceneContextMenuEvent): ...
    def createProxyForChildWidget(self, child: PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QGraphicsProxyWidget: ...
    def dragEnterEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def dragLeaveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def dragMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def dropEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, object: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent): ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent): ...
    def grabMouseEvent(self, event: PySide2.QtCore.QEvent): ...
    def hideEvent(self, event: PySide2.QtGui.QHideEvent): ...
    def hoverEnterEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHoverEvent): ...
    def hoverLeaveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHoverEvent): ...
    def hoverMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHoverEvent): ...
    def inputMethodEvent(self, event: PySide2.QtGui.QInputMethodEvent): ...
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def itemChange(self, change: PySide2.QtWidgets.QGraphicsItem.GraphicsItemChange, value: typing.Any) -> typing.Any: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, event: PySide2.QtGui.QKeyEvent): ...
    def mouseDoubleClickEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mouseMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mousePressEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mouseReleaseEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def newProxyWidget(self, arg__1: PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QGraphicsProxyWidget: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: PySide2.QtWidgets.QWidget): ...
    def resizeEvent(self, event: PySide2.QtWidgets.QGraphicsSceneResizeEvent): ...
    def setGeometry(self, rect: PySide2.QtCore.QRectF): ...
    def setWidget(self, widget: PySide2.QtWidgets.QWidget): ...
    def showEvent(self, event: PySide2.QtGui.QShowEvent): ...
    def sizeHint(self, which: PySide2.QtCore.Qt.SizeHint, constraint: PySide2.QtCore.QSizeF = ...) -> PySide2.QtCore.QSizeF: ...
    def subWidgetRect(self, widget: PySide2.QtWidgets.QWidget) -> PySide2.QtCore.QRectF: ...
    def type(self) -> int: ...
    def ungrabMouseEvent(self, event: PySide2.QtCore.QEvent): ...
    def wheelEvent(self, event: PySide2.QtWidgets.QGraphicsSceneWheelEvent): ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QGraphicsRectItem(PySide2.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QGraphicsItem = ...): ...
    @typing.overload
    def __init__(self, rect: PySide2.QtCore.QRectF, parent: PySide2.QtWidgets.QGraphicsItem = ...): ...
    @typing.overload
    def __init__(self, x: float, y: float, w: float, h: float, parent: PySide2.QtWidgets.QGraphicsItem = ...): ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def isObscuredBy(self, item: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: PySide2.QtWidgets.QWidget = ...): ...
    def rect(self) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def setRect(self, rect: PySide2.QtCore.QRectF): ...
    @typing.overload
    def setRect(self, x: float, y: float, w: float, h: float): ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def type(self) -> int: ...


class QGraphicsRotation(PySide2.QtWidgets.QGraphicsTransform):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def angle(self) -> float: ...
    def applyTo(self, matrix: PySide2.QtGui.QMatrix4x4): ...
    def axis(self) -> PySide2.QtGui.QVector3D: ...
    def origin(self) -> PySide2.QtGui.QVector3D: ...
    def setAngle(self, arg__1: float): ...
    @typing.overload
    def setAxis(self, axis: PySide2.QtCore.Qt.Axis): ...
    @typing.overload
    def setAxis(self, axis: PySide2.QtGui.QVector3D): ...
    def setOrigin(self, point: PySide2.QtGui.QVector3D): ...


class QGraphicsScale(PySide2.QtWidgets.QGraphicsTransform):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def applyTo(self, matrix: PySide2.QtGui.QMatrix4x4): ...
    def origin(self) -> PySide2.QtGui.QVector3D: ...
    def setOrigin(self, point: PySide2.QtGui.QVector3D): ...
    def setXScale(self, arg__1: float): ...
    def setYScale(self, arg__1: float): ...
    def setZScale(self, arg__1: float): ...
    def xScale(self) -> float: ...
    def yScale(self) -> float: ...
    def zScale(self) -> float: ...


class QGraphicsScene(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, sceneRect: PySide2.QtCore.QRectF, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, x: float, y: float, width: float, height: float, parent: PySide2.QtCore.QObject = ...): ...
    def activePanel(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def activeWindow(self) -> PySide2.QtWidgets.QGraphicsWidget: ...
    @typing.overload
    def addEllipse(self, rect: PySide2.QtCore.QRectF, pen: PySide2.QtGui.QPen = ..., brush: PySide2.QtGui.QBrush = ...) -> PySide2.QtWidgets.QGraphicsEllipseItem: ...
    @typing.overload
    def addEllipse(self, x: float, y: float, w: float, h: float, pen: PySide2.QtGui.QPen = ..., brush: PySide2.QtGui.QBrush = ...) -> PySide2.QtWidgets.QGraphicsEllipseItem: ...
    def addItem(self, item: PySide2.QtWidgets.QGraphicsItem): ...
    @typing.overload
    def addLine(self, line: PySide2.QtCore.QLineF, pen: PySide2.QtGui.QPen = ...) -> PySide2.QtWidgets.QGraphicsLineItem: ...
    @typing.overload
    def addLine(self, x1: float, y1: float, x2: float, y2: float, pen: PySide2.QtGui.QPen = ...) -> PySide2.QtWidgets.QGraphicsLineItem: ...
    def addPath(self, path: PySide2.QtGui.QPainterPath, pen: PySide2.QtGui.QPen = ..., brush: PySide2.QtGui.QBrush = ...) -> PySide2.QtWidgets.QGraphicsPathItem: ...
    def addPixmap(self, pixmap: PySide2.QtGui.QPixmap) -> PySide2.QtWidgets.QGraphicsPixmapItem: ...
    def addPolygon(self, polygon: PySide2.QtGui.QPolygonF, pen: PySide2.QtGui.QPen = ..., brush: PySide2.QtGui.QBrush = ...) -> PySide2.QtWidgets.QGraphicsPolygonItem: ...
    @typing.overload
    def addRect(self, rect: PySide2.QtCore.QRectF, pen: PySide2.QtGui.QPen = ..., brush: PySide2.QtGui.QBrush = ...) -> PySide2.QtWidgets.QGraphicsRectItem: ...
    @typing.overload
    def addRect(self, x: float, y: float, w: float, h: float, pen: PySide2.QtGui.QPen = ..., brush: PySide2.QtGui.QBrush = ...) -> PySide2.QtWidgets.QGraphicsRectItem: ...
    def addSimpleText(self, text: str, font: PySide2.QtGui.QFont = ...) -> PySide2.QtWidgets.QGraphicsSimpleTextItem: ...
    def addText(self, text: str, font: PySide2.QtGui.QFont = ...) -> PySide2.QtWidgets.QGraphicsTextItem: ...
    def addWidget(self, widget: PySide2.QtWidgets.QWidget, wFlags: PySide2.QtCore.Qt.WindowFlags = ...) -> PySide2.QtWidgets.QGraphicsProxyWidget: ...
    def advance(self): ...
    def backgroundBrush(self) -> PySide2.QtGui.QBrush: ...
    def bspTreeDepth(self) -> int: ...
    def clear(self): ...
    def clearFocus(self): ...
    def clearSelection(self): ...
    def collidingItems(self, item: PySide2.QtWidgets.QGraphicsItem, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    def contextMenuEvent(self, event: PySide2.QtWidgets.QGraphicsSceneContextMenuEvent): ...
    def createItemGroup(self, items: typing.List[PySide2.QtWidgets.QGraphicsItem]) -> PySide2.QtWidgets.QGraphicsItemGroup: ...
    def destroyItemGroup(self, group: PySide2.QtWidgets.QGraphicsItemGroup): ...
    def dragEnterEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def dragLeaveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def dragMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def drawBackground(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRectF): ...
    def drawForeground(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRectF): ...
    def dropEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, watched: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent): ...
    def focusItem(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOnTouch(self) -> bool: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent): ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def foregroundBrush(self) -> PySide2.QtGui.QBrush: ...
    def hasFocus(self) -> bool: ...
    def height(self) -> float: ...
    def helpEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHelpEvent): ...
    def inputMethodEvent(self, event: PySide2.QtGui.QInputMethodEvent): ...
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    @typing.overload
    def invalidate(self, rect: PySide2.QtCore.QRectF = ..., layers: PySide2.QtWidgets.QGraphicsScene.SceneLayers = ...): ...
    @typing.overload
    def invalidate(self, x: float, y: float, w: float, h: float, layers: PySide2.QtWidgets.QGraphicsScene.SceneLayers = ...): ...
    def isActive(self) -> bool: ...
    def isSortCacheEnabled(self) -> bool: ...
    @typing.overload
    def itemAt(self, pos: PySide2.QtCore.QPointF, deviceTransform: PySide2.QtGui.QTransform) -> PySide2.QtWidgets.QGraphicsItem: ...
    @typing.overload
    def itemAt(self, x: float, y: float, deviceTransform: PySide2.QtGui.QTransform) -> PySide2.QtWidgets.QGraphicsItem: ...
    def itemIndexMethod(self) -> PySide2.QtWidgets.QGraphicsScene.ItemIndexMethod: ...
    @typing.overload
    def items(self, order: PySide2.QtCore.Qt.SortOrder = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, path: PySide2.QtGui.QPainterPath, mode: PySide2.QtCore.Qt.ItemSelectionMode = ..., order: PySide2.QtCore.Qt.SortOrder = ..., deviceTransform: PySide2.QtGui.QTransform = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, polygon: PySide2.QtGui.QPolygonF, mode: PySide2.QtCore.Qt.ItemSelectionMode = ..., order: PySide2.QtCore.Qt.SortOrder = ..., deviceTransform: PySide2.QtGui.QTransform = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, pos: PySide2.QtCore.QPointF, mode: PySide2.QtCore.Qt.ItemSelectionMode = ..., order: PySide2.QtCore.Qt.SortOrder = ..., deviceTransform: PySide2.QtGui.QTransform = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, rect: PySide2.QtCore.QRectF, mode: PySide2.QtCore.Qt.ItemSelectionMode = ..., order: PySide2.QtCore.Qt.SortOrder = ..., deviceTransform: PySide2.QtGui.QTransform = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, x: float, y: float, w: float, h: float, mode: PySide2.QtCore.Qt.ItemSelectionMode, order: PySide2.QtCore.Qt.SortOrder, deviceTransform: PySide2.QtGui.QTransform = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    def itemsBoundingRect(self) -> PySide2.QtCore.QRectF: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, event: PySide2.QtGui.QKeyEvent): ...
    def minimumRenderSize(self) -> float: ...
    def mouseDoubleClickEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mouseGrabberItem(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def mouseMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mousePressEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mouseReleaseEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def palette(self) -> PySide2.QtGui.QPalette: ...
    def removeItem(self, item: PySide2.QtWidgets.QGraphicsItem): ...
    def render(self, painter: PySide2.QtGui.QPainter, target: PySide2.QtCore.QRectF = ..., source: PySide2.QtCore.QRectF = ..., aspectRatioMode: PySide2.QtCore.Qt.AspectRatioMode = ...): ...
    def sceneRect(self) -> PySide2.QtCore.QRectF: ...
    def selectedItems(self) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    def selectionArea(self) -> PySide2.QtGui.QPainterPath: ...
    def sendEvent(self, item: PySide2.QtWidgets.QGraphicsItem, event: PySide2.QtCore.QEvent) -> bool: ...
    def setActivePanel(self, item: PySide2.QtWidgets.QGraphicsItem): ...
    def setActiveWindow(self, widget: PySide2.QtWidgets.QGraphicsWidget): ...
    def setBackgroundBrush(self, brush: PySide2.QtGui.QBrush): ...
    def setBspTreeDepth(self, depth: int): ...
    def setFocus(self, focusReason: PySide2.QtCore.Qt.FocusReason = ...): ...
    def setFocusItem(self, item: PySide2.QtWidgets.QGraphicsItem, focusReason: PySide2.QtCore.Qt.FocusReason = ...): ...
    def setFocusOnTouch(self, enabled: bool): ...
    def setFont(self, font: PySide2.QtGui.QFont): ...
    def setForegroundBrush(self, brush: PySide2.QtGui.QBrush): ...
    def setItemIndexMethod(self, method: PySide2.QtWidgets.QGraphicsScene.ItemIndexMethod): ...
    def setMinimumRenderSize(self, minSize: float): ...
    def setPalette(self, palette: PySide2.QtGui.QPalette): ...
    @typing.overload
    def setSceneRect(self, rect: PySide2.QtCore.QRectF): ...
    @typing.overload
    def setSceneRect(self, x: float, y: float, w: float, h: float): ...
    @typing.overload
    def setSelectionArea(self, path: PySide2.QtGui.QPainterPath, deviceTransform: PySide2.QtGui.QTransform): ...
    @typing.overload
    def setSelectionArea(self, path: PySide2.QtGui.QPainterPath, mode: PySide2.QtCore.Qt.ItemSelectionMode = ..., deviceTransform: PySide2.QtGui.QTransform = ...): ...
    @typing.overload
    def setSelectionArea(self, path: PySide2.QtGui.QPainterPath, selectionOperation: PySide2.QtCore.Qt.ItemSelectionOperation, mode: PySide2.QtCore.Qt.ItemSelectionMode = ..., deviceTransform: PySide2.QtGui.QTransform = ...): ...
    def setSortCacheEnabled(self, enabled: bool): ...
    def setStickyFocus(self, enabled: bool): ...
    def setStyle(self, style: PySide2.QtWidgets.QStyle): ...
    def stickyFocus(self) -> bool: ...
    def style(self) -> PySide2.QtWidgets.QStyle: ...
    @typing.overload
    def update(self, rect: PySide2.QtCore.QRectF = ...): ...
    @typing.overload
    def update(self, x: float, y: float, w: float, h: float): ...
    def views(self) -> typing.List[PySide2.QtWidgets.QGraphicsView]: ...
    def wheelEvent(self, event: PySide2.QtWidgets.QGraphicsSceneWheelEvent): ...
    def width(self) -> float: ...


class QGraphicsSceneContextMenuEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type = ...): ...
    def modifiers(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def reason(self) -> PySide2.QtWidgets.QGraphicsSceneContextMenuEvent.Reason: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setModifiers(self, modifiers: PySide2.QtCore.Qt.KeyboardModifiers): ...
    def setPos(self, pos: PySide2.QtCore.QPointF): ...
    def setReason(self, reason: PySide2.QtWidgets.QGraphicsSceneContextMenuEvent.Reason): ...
    def setScenePos(self, pos: PySide2.QtCore.QPointF): ...
    def setScreenPos(self, pos: PySide2.QtCore.QPoint): ...


class QGraphicsSceneDragDropEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type = ...): ...
    def acceptProposedAction(self): ...
    def buttons(self) -> PySide2.QtCore.Qt.MouseButtons: ...
    def dropAction(self) -> PySide2.QtCore.Qt.DropAction: ...
    def mimeData(self) -> PySide2.QtCore.QMimeData: ...
    def modifiers(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def possibleActions(self) -> PySide2.QtCore.Qt.DropActions: ...
    def proposedAction(self) -> PySide2.QtCore.Qt.DropAction: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setButtons(self, buttons: PySide2.QtCore.Qt.MouseButtons): ...
    def setDropAction(self, action: PySide2.QtCore.Qt.DropAction): ...
    def setModifiers(self, modifiers: PySide2.QtCore.Qt.KeyboardModifiers): ...
    def setPos(self, pos: PySide2.QtCore.QPointF): ...
    def setPossibleActions(self, actions: PySide2.QtCore.Qt.DropActions): ...
    def setProposedAction(self, action: PySide2.QtCore.Qt.DropAction): ...
    def setScenePos(self, pos: PySide2.QtCore.QPointF): ...
    def setScreenPos(self, pos: PySide2.QtCore.QPoint): ...
    def source(self) -> PySide2.QtWidgets.QWidget: ...


class QGraphicsSceneEvent(PySide2.QtCore.QEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type): ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QGraphicsSceneHelpEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type = ...): ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setScenePos(self, pos: PySide2.QtCore.QPointF): ...
    def setScreenPos(self, pos: PySide2.QtCore.QPoint): ...


class QGraphicsSceneHoverEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type = ...): ...
    def lastPos(self) -> PySide2.QtCore.QPointF: ...
    def lastScenePos(self) -> PySide2.QtCore.QPointF: ...
    def lastScreenPos(self) -> PySide2.QtCore.QPoint: ...
    def modifiers(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setLastPos(self, pos: PySide2.QtCore.QPointF): ...
    def setLastScenePos(self, pos: PySide2.QtCore.QPointF): ...
    def setLastScreenPos(self, pos: PySide2.QtCore.QPoint): ...
    def setModifiers(self, modifiers: PySide2.QtCore.Qt.KeyboardModifiers): ...
    def setPos(self, pos: PySide2.QtCore.QPointF): ...
    def setScenePos(self, pos: PySide2.QtCore.QPointF): ...
    def setScreenPos(self, pos: PySide2.QtCore.QPoint): ...


class QGraphicsSceneMouseEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type = ...): ...
    def button(self) -> PySide2.QtCore.Qt.MouseButton: ...
    def buttonDownPos(self, button: PySide2.QtCore.Qt.MouseButton) -> PySide2.QtCore.QPointF: ...
    def buttonDownScenePos(self, button: PySide2.QtCore.Qt.MouseButton) -> PySide2.QtCore.QPointF: ...
    def buttonDownScreenPos(self, button: PySide2.QtCore.Qt.MouseButton) -> PySide2.QtCore.QPoint: ...
    def buttons(self) -> PySide2.QtCore.Qt.MouseButtons: ...
    def flags(self) -> PySide2.QtCore.Qt.MouseEventFlags: ...
    def lastPos(self) -> PySide2.QtCore.QPointF: ...
    def lastScenePos(self) -> PySide2.QtCore.QPointF: ...
    def lastScreenPos(self) -> PySide2.QtCore.QPoint: ...
    def modifiers(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setButton(self, button: PySide2.QtCore.Qt.MouseButton): ...
    def setButtonDownPos(self, button: PySide2.QtCore.Qt.MouseButton, pos: PySide2.QtCore.QPointF): ...
    def setButtonDownScenePos(self, button: PySide2.QtCore.Qt.MouseButton, pos: PySide2.QtCore.QPointF): ...
    def setButtonDownScreenPos(self, button: PySide2.QtCore.Qt.MouseButton, pos: PySide2.QtCore.QPoint): ...
    def setButtons(self, buttons: PySide2.QtCore.Qt.MouseButtons): ...
    def setFlags(self, arg__1: PySide2.QtCore.Qt.MouseEventFlags): ...
    def setLastPos(self, pos: PySide2.QtCore.QPointF): ...
    def setLastScenePos(self, pos: PySide2.QtCore.QPointF): ...
    def setLastScreenPos(self, pos: PySide2.QtCore.QPoint): ...
    def setModifiers(self, modifiers: PySide2.QtCore.Qt.KeyboardModifiers): ...
    def setPos(self, pos: PySide2.QtCore.QPointF): ...
    def setScenePos(self, pos: PySide2.QtCore.QPointF): ...
    def setScreenPos(self, pos: PySide2.QtCore.QPoint): ...
    def setSource(self, source: PySide2.QtCore.Qt.MouseEventSource): ...
    def source(self) -> PySide2.QtCore.Qt.MouseEventSource: ...


class QGraphicsSceneMoveEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self): ...
    def newPos(self) -> PySide2.QtCore.QPointF: ...
    def oldPos(self) -> PySide2.QtCore.QPointF: ...
    def setNewPos(self, pos: PySide2.QtCore.QPointF): ...
    def setOldPos(self, pos: PySide2.QtCore.QPointF): ...


class QGraphicsSceneResizeEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self): ...
    def newSize(self) -> PySide2.QtCore.QSizeF: ...
    def oldSize(self) -> PySide2.QtCore.QSizeF: ...
    def setNewSize(self, size: PySide2.QtCore.QSizeF): ...
    def setOldSize(self, size: PySide2.QtCore.QSizeF): ...


class QGraphicsSceneWheelEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type = ...): ...
    def buttons(self) -> PySide2.QtCore.Qt.MouseButtons: ...
    def delta(self) -> int: ...
    def modifiers(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setButtons(self, buttons: PySide2.QtCore.Qt.MouseButtons): ...
    def setDelta(self, delta: int): ...
    def setModifiers(self, modifiers: PySide2.QtCore.Qt.KeyboardModifiers): ...
    def setOrientation(self, orientation: PySide2.QtCore.Qt.Orientation): ...
    def setPos(self, pos: PySide2.QtCore.QPointF): ...
    def setScenePos(self, pos: PySide2.QtCore.QPointF): ...
    def setScreenPos(self, pos: PySide2.QtCore.QPoint): ...


class QGraphicsSimpleTextItem(PySide2.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QGraphicsItem = ...): ...
    @typing.overload
    def __init__(self, text: str, parent: PySide2.QtWidgets.QGraphicsItem = ...): ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def isObscuredBy(self, item: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: PySide2.QtWidgets.QWidget): ...
    def setFont(self, font: PySide2.QtGui.QFont): ...
    def setText(self, text: str): ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def text(self) -> str: ...
    def type(self) -> int: ...


class QGraphicsTextItem(PySide2.QtWidgets.QGraphicsObject):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QGraphicsItem = ...): ...
    @typing.overload
    def __init__(self, text: str, parent: PySide2.QtWidgets.QGraphicsItem = ...): ...
    def adjustSize(self): ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def contextMenuEvent(self, event: PySide2.QtWidgets.QGraphicsSceneContextMenuEvent): ...
    def defaultTextColor(self) -> PySide2.QtGui.QColor: ...
    def document(self) -> PySide2.QtGui.QTextDocument: ...
    def dragEnterEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def dragLeaveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def dragMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def dropEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent): ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent): ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def hoverEnterEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHoverEvent): ...
    def hoverLeaveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHoverEvent): ...
    def hoverMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHoverEvent): ...
    def inputMethodEvent(self, event: PySide2.QtGui.QInputMethodEvent): ...
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def isObscuredBy(self, item: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, event: PySide2.QtGui.QKeyEvent): ...
    def mouseDoubleClickEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mouseMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mousePressEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mouseReleaseEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def openExternalLinks(self) -> bool: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: PySide2.QtWidgets.QWidget): ...
    def sceneEvent(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def setDefaultTextColor(self, c: PySide2.QtGui.QColor): ...
    def setDocument(self, document: PySide2.QtGui.QTextDocument): ...
    def setFont(self, font: PySide2.QtGui.QFont): ...
    def setHtml(self, html: str): ...
    def setOpenExternalLinks(self, open: bool): ...
    def setPlainText(self, text: str): ...
    def setTabChangesFocus(self, b: bool): ...
    def setTextCursor(self, cursor: PySide2.QtGui.QTextCursor): ...
    def setTextInteractionFlags(self, flags: PySide2.QtCore.Qt.TextInteractionFlags): ...
    def setTextWidth(self, width: float): ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def tabChangesFocus(self) -> bool: ...
    def textCursor(self) -> PySide2.QtGui.QTextCursor: ...
    def textInteractionFlags(self) -> PySide2.QtCore.Qt.TextInteractionFlags: ...
    def textWidth(self) -> float: ...
    def toHtml(self) -> str: ...
    def toPlainText(self) -> str: ...
    def type(self) -> int: ...


class QGraphicsTransform(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def applyTo(self, matrix: PySide2.QtGui.QMatrix4x4): ...
    def update(self): ...


class QGraphicsView(PySide2.QtWidgets.QAbstractScrollArea):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, scene: PySide2.QtWidgets.QGraphicsScene, parent: PySide2.QtWidgets.QWidget = ...): ...
    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def backgroundBrush(self) -> PySide2.QtGui.QBrush: ...
    def cacheMode(self) -> PySide2.QtWidgets.QGraphicsView.CacheMode: ...
    @typing.overload
    def centerOn(self, item: PySide2.QtWidgets.QGraphicsItem): ...
    @typing.overload
    def centerOn(self, pos: PySide2.QtCore.QPointF): ...
    @typing.overload
    def centerOn(self, x: float, y: float): ...
    def contextMenuEvent(self, event: PySide2.QtGui.QContextMenuEvent): ...
    def dragEnterEvent(self, event: PySide2.QtGui.QDragEnterEvent): ...
    def dragLeaveEvent(self, event: PySide2.QtGui.QDragLeaveEvent): ...
    def dragMode(self) -> PySide2.QtWidgets.QGraphicsView.DragMode: ...
    def dragMoveEvent(self, event: PySide2.QtGui.QDragMoveEvent): ...
    def drawBackground(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRectF): ...
    def drawForeground(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRectF): ...
    def drawItems(self, painter: PySide2.QtGui.QPainter, numItems: int, items: typing.List[PySide2.QtWidgets.QGraphicsItem], options: typing.List[PySide2.QtWidgets.QStyleOptionGraphicsItem]): ...
    def dropEvent(self, event: PySide2.QtGui.QDropEvent): ...
    @typing.overload
    def ensureVisible(self, item: PySide2.QtWidgets.QGraphicsItem, xmargin: int = ..., ymargin: int = ...): ...
    @typing.overload
    def ensureVisible(self, rect: PySide2.QtCore.QRectF, xmargin: int = ..., ymargin: int = ...): ...
    @typing.overload
    def ensureVisible(self, x: float, y: float, w: float, h: float, xmargin: int = ..., ymargin: int = ...): ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    @typing.overload
    def fitInView(self, item: PySide2.QtWidgets.QGraphicsItem, aspectRadioMode: PySide2.QtCore.Qt.AspectRatioMode = ...): ...
    @typing.overload
    def fitInView(self, rect: PySide2.QtCore.QRectF, aspectRadioMode: PySide2.QtCore.Qt.AspectRatioMode = ...): ...
    @typing.overload
    def fitInView(self, x: float, y: float, w: float, h: float, aspectRadioMode: PySide2.QtCore.Qt.AspectRatioMode = ...): ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent): ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent): ...
    def foregroundBrush(self) -> PySide2.QtGui.QBrush: ...
    def inputMethodEvent(self, event: PySide2.QtGui.QInputMethodEvent): ...
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def invalidateScene(self, rect: PySide2.QtCore.QRectF = ..., layers: PySide2.QtWidgets.QGraphicsScene.SceneLayers = ...): ...
    def isInteractive(self) -> bool: ...
    def isTransformed(self) -> bool: ...
    @typing.overload
    def itemAt(self, pos: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QGraphicsItem: ...
    @typing.overload
    def itemAt(self, x: int, y: int) -> PySide2.QtWidgets.QGraphicsItem: ...
    @typing.overload
    def items(self) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, path: PySide2.QtGui.QPainterPath, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, polygon: PySide2.QtGui.QPolygon, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, pos: PySide2.QtCore.QPoint) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, rect: PySide2.QtCore.QRect, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, x: int, y: int) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, x: int, y: int, w: int, h: int, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, event: PySide2.QtGui.QKeyEvent): ...
    @typing.overload
    def mapFromScene(self, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapFromScene(self, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def mapFromScene(self, polygon: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygon: ...
    @typing.overload
    def mapFromScene(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygon: ...
    @typing.overload
    def mapFromScene(self, x: float, y: float) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def mapFromScene(self, x: float, y: float, w: float, h: float) -> PySide2.QtGui.QPolygon: ...
    @typing.overload
    def mapToScene(self, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapToScene(self, point: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToScene(self, polygon: PySide2.QtGui.QPolygon) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToScene(self, rect: PySide2.QtCore.QRect) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToScene(self, x: int, y: int) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToScene(self, x: int, y: int, w: int, h: int) -> PySide2.QtGui.QPolygonF: ...
    def matrix(self) -> PySide2.QtGui.QMatrix: ...
    def mouseDoubleClickEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    def optimizationFlags(self) -> PySide2.QtWidgets.QGraphicsView.OptimizationFlags: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent): ...
    @typing.overload
    def render(self, painter: PySide2.QtGui.QPainter, target: PySide2.QtCore.QRectF = ..., source: PySide2.QtCore.QRect = ..., aspectRatioMode: PySide2.QtCore.Qt.AspectRatioMode = ...): ...
    @typing.overload
    def render(self, target: PySide2.QtGui.QPaintDevice, targetOffset: PySide2.QtCore.QPoint = ..., sourceRegion: PySide2.QtGui.QRegion = ..., renderFlags: PySide2.QtWidgets.QWidget.RenderFlags = ...): ...
    def renderHints(self) -> PySide2.QtGui.QPainter.RenderHints: ...
    def resetCachedContent(self): ...
    def resetMatrix(self): ...
    def resetTransform(self): ...
    def resizeAnchor(self) -> PySide2.QtWidgets.QGraphicsView.ViewportAnchor: ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent): ...
    def rotate(self, angle: float): ...
    def rubberBandRect(self) -> PySide2.QtCore.QRect: ...
    def rubberBandSelectionMode(self) -> PySide2.QtCore.Qt.ItemSelectionMode: ...
    def scale(self, sx: float, sy: float): ...
    def scene(self) -> PySide2.QtWidgets.QGraphicsScene: ...
    def sceneRect(self) -> PySide2.QtCore.QRectF: ...
    def scrollContentsBy(self, dx: int, dy: int): ...
    def setAlignment(self, alignment: PySide2.QtCore.Qt.Alignment): ...
    def setBackgroundBrush(self, brush: PySide2.QtGui.QBrush): ...
    def setCacheMode(self, mode: PySide2.QtWidgets.QGraphicsView.CacheMode): ...
    def setDragMode(self, mode: PySide2.QtWidgets.QGraphicsView.DragMode): ...
    def setForegroundBrush(self, brush: PySide2.QtGui.QBrush): ...
    def setInteractive(self, allowed: bool): ...
    def setMatrix(self, matrix: PySide2.QtGui.QMatrix, combine: bool = ...): ...
    def setOptimizationFlag(self, flag: PySide2.QtWidgets.QGraphicsView.OptimizationFlag, enabled: bool = ...): ...
    def setOptimizationFlags(self, flags: PySide2.QtWidgets.QGraphicsView.OptimizationFlags): ...
    def setRenderHint(self, hint: PySide2.QtGui.QPainter.RenderHint, enabled: bool = ...): ...
    def setRenderHints(self, hints: PySide2.QtGui.QPainter.RenderHints): ...
    def setResizeAnchor(self, anchor: PySide2.QtWidgets.QGraphicsView.ViewportAnchor): ...
    def setRubberBandSelectionMode(self, mode: PySide2.QtCore.Qt.ItemSelectionMode): ...
    def setScene(self, scene: PySide2.QtWidgets.QGraphicsScene): ...
    @typing.overload
    def setSceneRect(self, rect: PySide2.QtCore.QRectF): ...
    @typing.overload
    def setSceneRect(self, x: float, y: float, w: float, h: float): ...
    def setTransform(self, matrix: PySide2.QtGui.QTransform, combine: bool = ...): ...
    def setTransformationAnchor(self, anchor: PySide2.QtWidgets.QGraphicsView.ViewportAnchor): ...
    def setViewportUpdateMode(self, mode: PySide2.QtWidgets.QGraphicsView.ViewportUpdateMode): ...
    def setupViewport(self, widget: PySide2.QtWidgets.QWidget): ...
    def shear(self, sh: float, sv: float): ...
    def showEvent(self, event: PySide2.QtGui.QShowEvent): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def transform(self) -> PySide2.QtGui.QTransform: ...
    def transformationAnchor(self) -> PySide2.QtWidgets.QGraphicsView.ViewportAnchor: ...
    def translate(self, dx: float, dy: float): ...
    def updateScene(self, rects: typing.List[PySide2.QtCore.QRectF]): ...
    def updateSceneRect(self, rect: PySide2.QtCore.QRectF): ...
    def viewportEvent(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def viewportTransform(self) -> PySide2.QtGui.QTransform: ...
    def viewportUpdateMode(self) -> PySide2.QtWidgets.QGraphicsView.ViewportUpdateMode: ...
    def wheelEvent(self, event: PySide2.QtGui.QWheelEvent): ...


class QGraphicsWidget(PySide2.QtWidgets.QGraphicsObject, PySide2.QtWidgets.QGraphicsLayoutItem):

    def __init__(self, parent: PySide2.QtWidgets.QGraphicsItem = ..., wFlags: PySide2.QtCore.Qt.WindowFlags = ...): ...
    def actions(self) -> typing.List[PySide2.QtWidgets.QAction]: ...
    def addAction(self, action: PySide2.QtWidgets.QAction): ...
    def addActions(self, actions: typing.List[PySide2.QtWidgets.QAction]): ...
    def adjustSize(self): ...
    def autoFillBackground(self) -> bool: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent): ...
    def close(self) -> bool: ...
    def closeEvent(self, event: PySide2.QtGui.QCloseEvent): ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent): ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent): ...
    def focusPolicy(self) -> PySide2.QtCore.Qt.FocusPolicy: ...
    def focusWidget(self) -> PySide2.QtWidgets.QGraphicsWidget: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def getContentsMargins(self, left: float, top: float, right: float, bottom: float): ...
    def getWindowFrameMargins(self, left: float, top: float, right: float, bottom: float): ...
    def grabKeyboardEvent(self, event: PySide2.QtCore.QEvent): ...
    def grabMouseEvent(self, event: PySide2.QtCore.QEvent): ...
    def grabShortcut(self, sequence: PySide2.QtGui.QKeySequence, context: PySide2.QtCore.Qt.ShortcutContext = ...) -> int: ...
    def hideEvent(self, event: PySide2.QtGui.QHideEvent): ...
    def hoverLeaveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHoverEvent): ...
    def hoverMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHoverEvent): ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOption): ...
    def insertAction(self, before: PySide2.QtWidgets.QAction, action: PySide2.QtWidgets.QAction): ...
    def insertActions(self, before: PySide2.QtWidgets.QAction, actions: typing.List[PySide2.QtWidgets.QAction]): ...
    def isActiveWindow(self) -> bool: ...
    def itemChange(self, change: PySide2.QtWidgets.QGraphicsItem.GraphicsItemChange, value: typing.Any) -> typing.Any: ...
    def layout(self) -> PySide2.QtWidgets.QGraphicsLayout: ...
    def layoutDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def moveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMoveEvent): ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: PySide2.QtWidgets.QWidget = ...): ...
    def paintWindowFrame(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: PySide2.QtWidgets.QWidget = ...): ...
    def palette(self) -> PySide2.QtGui.QPalette: ...
    def polishEvent(self): ...
    def propertyChange(self, propertyName: str, value: typing.Any) -> typing.Any: ...
    def rect(self) -> PySide2.QtCore.QRectF: ...
    def releaseShortcut(self, id: int): ...
    def removeAction(self, action: PySide2.QtWidgets.QAction): ...
    @typing.overload
    def resize(self, size: PySide2.QtCore.QSizeF): ...
    @typing.overload
    def resize(self, w: float, h: float): ...
    def resizeEvent(self, event: PySide2.QtWidgets.QGraphicsSceneResizeEvent): ...
    def sceneEvent(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def setAttribute(self, attribute: PySide2.QtCore.Qt.WidgetAttribute, on: bool = ...): ...
    def setAutoFillBackground(self, enabled: bool): ...
    def setContentsMargins(self, left: float, top: float, right: float, bottom: float): ...
    def setFocusPolicy(self, policy: PySide2.QtCore.Qt.FocusPolicy): ...
    def setFont(self, font: PySide2.QtGui.QFont): ...
    @typing.overload
    def setGeometry(self, rect: PySide2.QtCore.QRectF): ...
    @typing.overload
    def setGeometry(self, x: float, y: float, w: float, h: float): ...
    def setLayout(self, layout: PySide2.QtWidgets.QGraphicsLayout): ...
    def setLayoutDirection(self, direction: PySide2.QtCore.Qt.LayoutDirection): ...
    def setPalette(self, palette: PySide2.QtGui.QPalette): ...
    def setShortcutAutoRepeat(self, id: int, enabled: bool = ...): ...
    def setShortcutEnabled(self, id: int, enabled: bool = ...): ...
    def setStyle(self, style: PySide2.QtWidgets.QStyle): ...
    @staticmethod
    def setTabOrder(first: PySide2.QtWidgets.QGraphicsWidget, second: PySide2.QtWidgets.QGraphicsWidget): ...
    def setWindowFlags(self, wFlags: PySide2.QtCore.Qt.WindowFlags): ...
    def setWindowFrameMargins(self, left: float, top: float, right: float, bottom: float): ...
    def setWindowTitle(self, title: str): ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def showEvent(self, event: PySide2.QtGui.QShowEvent): ...
    def size(self) -> PySide2.QtCore.QSizeF: ...
    def sizeHint(self, which: PySide2.QtCore.Qt.SizeHint, constraint: PySide2.QtCore.QSizeF = ...) -> PySide2.QtCore.QSizeF: ...
    def style(self) -> PySide2.QtWidgets.QStyle: ...
    def testAttribute(self, attribute: PySide2.QtCore.Qt.WidgetAttribute) -> bool: ...
    def type(self) -> int: ...
    def ungrabKeyboardEvent(self, event: PySide2.QtCore.QEvent): ...
    def ungrabMouseEvent(self, event: PySide2.QtCore.QEvent): ...
    def unsetLayoutDirection(self): ...
    def unsetWindowFrameMargins(self): ...
    def updateGeometry(self): ...
    def windowFlags(self) -> PySide2.QtCore.Qt.WindowFlags: ...
    def windowFrameEvent(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def windowFrameGeometry(self) -> PySide2.QtCore.QRectF: ...
    def windowFrameRect(self) -> PySide2.QtCore.QRectF: ...
    def windowFrameSectionAt(self, pos: PySide2.QtCore.QPointF) -> PySide2.QtCore.Qt.WindowFrameSection: ...
    def windowTitle(self) -> str: ...
    def windowType(self) -> PySide2.QtCore.Qt.WindowType: ...


class QGridLayout(PySide2.QtWidgets.QLayout):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget): ...
    @typing.overload
    def addItem(self, arg__1: PySide2.QtWidgets.QLayoutItem): ...
    @typing.overload
    def addItem(self, item: PySide2.QtWidgets.QLayoutItem, row: int, column: int, rowSpan: int = ..., columnSpan: int = ..., alignment: PySide2.QtCore.Qt.Alignment = ...): ...
    @typing.overload
    def addLayout(self, arg__1: PySide2.QtWidgets.QLayout, row: int, column: int, alignment: PySide2.QtCore.Qt.Alignment = ...): ...
    @typing.overload
    def addLayout(self, arg__1: PySide2.QtWidgets.QLayout, row: int, column: int, rowSpan: int, columnSpan: int, alignment: PySide2.QtCore.Qt.Alignment = ...): ...
    @typing.overload
    def addWidget(self, arg__1: PySide2.QtWidgets.QWidget, row: int, column: int, alignment: PySide2.QtCore.Qt.Alignment = ...): ...
    @typing.overload
    def addWidget(self, arg__1: PySide2.QtWidgets.QWidget, row: int, column: int, rowSpan: int, columnSpan: int, alignment: PySide2.QtCore.Qt.Alignment = ...): ...
    @typing.overload
    def addWidget(self, w: PySide2.QtWidgets.QWidget): ...
    def cellRect(self, row: int, column: int) -> PySide2.QtCore.QRect: ...
    def columnCount(self) -> int: ...
    def columnMinimumWidth(self, column: int) -> int: ...
    def columnStretch(self, column: int) -> int: ...
    def count(self) -> int: ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def getItemPosition(self, idx: int, row: int, column: int, rowSpan: int, columnSpan: int): ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def horizontalSpacing(self) -> int: ...
    def invalidate(self): ...
    def itemAt(self, index: int) -> PySide2.QtWidgets.QLayoutItem: ...
    def itemAtPosition(self, row: int, column: int) -> PySide2.QtWidgets.QLayoutItem: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumHeightForWidth(self, arg__1: int) -> int: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def originCorner(self) -> PySide2.QtCore.Qt.Corner: ...
    def rowCount(self) -> int: ...
    def rowMinimumHeight(self, row: int) -> int: ...
    def rowStretch(self, row: int) -> int: ...
    def setColumnMinimumWidth(self, column: int, minSize: int): ...
    def setColumnStretch(self, column: int, stretch: int): ...
    def setDefaultPositioning(self, n: int, orient: PySide2.QtCore.Qt.Orientation): ...
    def setGeometry(self, arg__1: PySide2.QtCore.QRect): ...
    def setHorizontalSpacing(self, spacing: int): ...
    def setOriginCorner(self, arg__1: PySide2.QtCore.Qt.Corner): ...
    def setRowMinimumHeight(self, row: int, minSize: int): ...
    def setRowStretch(self, row: int, stretch: int): ...
    def setSpacing(self, spacing: int): ...
    def setVerticalSpacing(self, spacing: int): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def spacing(self) -> int: ...
    def takeAt(self, index: int) -> PySide2.QtWidgets.QLayoutItem: ...
    def verticalSpacing(self) -> int: ...


class QGroupBox(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, title: str, parent: PySide2.QtWidgets.QWidget = ...): ...
    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent): ...
    def childEvent(self, event: PySide2.QtCore.QChildEvent): ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent): ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionGroupBox): ...
    def isCheckable(self) -> bool: ...
    def isChecked(self) -> bool: ...
    def isFlat(self) -> bool: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent): ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent): ...
    def setAlignment(self, alignment: int): ...
    def setCheckable(self, checkable: bool): ...
    def setChecked(self, checked: bool): ...
    def setFlat(self, flat: bool): ...
    def setTitle(self, title: str): ...
    def title(self) -> str: ...


class QHBoxLayout(PySide2.QtWidgets.QBoxLayout):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget): ...


class QHeaderView(PySide2.QtWidgets.QAbstractItemView):

    def __init__(self, orientation: PySide2.QtCore.Qt.Orientation, parent: PySide2.QtWidgets.QWidget = ...): ...
    def cascadingSectionResizes(self) -> bool: ...
    def count(self) -> int: ...
    def currentChanged(self, current: PySide2.QtCore.QModelIndex, old: PySide2.QtCore.QModelIndex): ...
    def dataChanged(self, topLeft: PySide2.QtCore.QModelIndex, bottomRight: PySide2.QtCore.QModelIndex, roles: typing.List[int] = ...): ...
    def defaultAlignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def defaultSectionSize(self) -> int: ...
    def doItemsLayout(self): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def headerDataChanged(self, orientation: PySide2.QtCore.Qt.Orientation, logicalFirst: int, logicalLast: int): ...
    def hiddenSectionCount(self) -> int: ...
    def hideSection(self, logicalIndex: int): ...
    def highlightSections(self) -> bool: ...
    def horizontalOffset(self) -> int: ...
    def indexAt(self, p: PySide2.QtCore.QPoint) -> PySide2.QtCore.QModelIndex: ...
    @typing.overload
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionFrame): ...
    @typing.overload
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionHeader): ...
    def initialize(self): ...
    @typing.overload
    def initializeSections(self): ...
    @typing.overload
    def initializeSections(self, start: int, end: int): ...
    def isFirstSectionMovable(self) -> bool: ...
    def isIndexHidden(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def isSectionHidden(self, logicalIndex: int) -> bool: ...
    def isSortIndicatorShown(self) -> bool: ...
    def length(self) -> int: ...
    def logicalIndex(self, visualIndex: int) -> int: ...
    @typing.overload
    def logicalIndexAt(self, pos: PySide2.QtCore.QPoint) -> int: ...
    @typing.overload
    def logicalIndexAt(self, position: int) -> int: ...
    @typing.overload
    def logicalIndexAt(self, x: int, y: int) -> int: ...
    def maximumSectionSize(self) -> int: ...
    def minimumSectionSize(self) -> int: ...
    def mouseDoubleClickEvent(self, e: PySide2.QtGui.QMouseEvent): ...
    def mouseMoveEvent(self, e: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, e: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, e: PySide2.QtGui.QMouseEvent): ...
    def moveCursor(self, arg__1: PySide2.QtWidgets.QAbstractItemView.CursorAction, arg__2: PySide2.QtCore.Qt.KeyboardModifiers) -> PySide2.QtCore.QModelIndex: ...
    def moveSection(self, from_: int, to: int): ...
    def offset(self) -> int: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent): ...
    def paintSection(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRect, logicalIndex: int): ...
    def reset(self): ...
    def resetDefaultSectionSize(self): ...
    def resizeContentsPrecision(self) -> int: ...
    def resizeSection(self, logicalIndex: int, size: int): ...
    @typing.overload
    def resizeSections(self): ...
    @typing.overload
    def resizeSections(self, mode: PySide2.QtWidgets.QHeaderView.ResizeMode): ...
    def restoreState(self, state: PySide2.QtCore.QByteArray) -> bool: ...
    def rowsInserted(self, parent: PySide2.QtCore.QModelIndex, start: int, end: int): ...
    def saveState(self) -> PySide2.QtCore.QByteArray: ...
    def scrollContentsBy(self, dx: int, dy: int): ...
    def scrollTo(self, index: PySide2.QtCore.QModelIndex, hint: PySide2.QtWidgets.QAbstractItemView.ScrollHint): ...
    def sectionPosition(self, logicalIndex: int) -> int: ...
    def sectionResizeMode(self, logicalIndex: int) -> PySide2.QtWidgets.QHeaderView.ResizeMode: ...
    def sectionSize(self, logicalIndex: int) -> int: ...
    def sectionSizeFromContents(self, logicalIndex: int) -> PySide2.QtCore.QSize: ...
    def sectionSizeHint(self, logicalIndex: int) -> int: ...
    def sectionViewportPosition(self, logicalIndex: int) -> int: ...
    def sectionsAboutToBeRemoved(self, parent: PySide2.QtCore.QModelIndex, logicalFirst: int, logicalLast: int): ...
    def sectionsClickable(self) -> bool: ...
    def sectionsHidden(self) -> bool: ...
    def sectionsInserted(self, parent: PySide2.QtCore.QModelIndex, logicalFirst: int, logicalLast: int): ...
    def sectionsMovable(self) -> bool: ...
    def sectionsMoved(self) -> bool: ...
    def setCascadingSectionResizes(self, enable: bool): ...
    def setDefaultAlignment(self, alignment: PySide2.QtCore.Qt.Alignment): ...
    def setDefaultSectionSize(self, size: int): ...
    def setFirstSectionMovable(self, movable: bool): ...
    def setHighlightSections(self, highlight: bool): ...
    def setMaximumSectionSize(self, size: int): ...
    def setMinimumSectionSize(self, size: int): ...
    def setModel(self, model: PySide2.QtCore.QAbstractItemModel): ...
    def setOffset(self, offset: int): ...
    def setOffsetToLastSection(self): ...
    def setOffsetToSectionPosition(self, visualIndex: int): ...
    def setResizeContentsPrecision(self, precision: int): ...
    def setSectionHidden(self, logicalIndex: int, hide: bool): ...
    @typing.overload
    def setSectionResizeMode(self, logicalIndex: int, mode: PySide2.QtWidgets.QHeaderView.ResizeMode): ...
    @typing.overload
    def setSectionResizeMode(self, mode: PySide2.QtWidgets.QHeaderView.ResizeMode): ...
    def setSectionsClickable(self, clickable: bool): ...
    def setSectionsMovable(self, movable: bool): ...
    def setSelection(self, rect: PySide2.QtCore.QRect, flags: PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    def setSortIndicator(self, logicalIndex: int, order: PySide2.QtCore.Qt.SortOrder): ...
    def setSortIndicatorShown(self, show: bool): ...
    def setStretchLastSection(self, stretch: bool): ...
    def setVisible(self, v: bool): ...
    def showSection(self, logicalIndex: int): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sortIndicatorOrder(self) -> PySide2.QtCore.Qt.SortOrder: ...
    def sortIndicatorSection(self) -> int: ...
    def stretchLastSection(self) -> bool: ...
    def stretchSectionCount(self) -> int: ...
    def swapSections(self, first: int, second: int): ...
    def updateGeometries(self): ...
    def updateSection(self, logicalIndex: int): ...
    def verticalOffset(self) -> int: ...
    def viewportEvent(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def visualIndex(self, logicalIndex: int) -> int: ...
    def visualIndexAt(self, position: int) -> int: ...
    def visualRect(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide2.QtCore.QItemSelection) -> PySide2.QtGui.QRegion: ...


class QInputDialog(PySide2.QtWidgets.QDialog):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...): ...
    def cancelButtonText(self) -> str: ...
    def comboBoxItems(self) -> typing.List[str]: ...
    def done(self, result: int): ...
    def doubleDecimals(self) -> int: ...
    def doubleMaximum(self) -> float: ...
    def doubleMinimum(self) -> float: ...
    def doubleStep(self) -> float: ...
    def doubleValue(self) -> float: ...
    @typing.overload
    @staticmethod
    def getDouble(parent: PySide2.QtWidgets.QWidget, title: str, label: str, value: float, minValue: float, maxValue: float, decimals: int, ok: bool, flags: PySide2.QtCore.Qt.WindowFlags, step: float) -> float: ...
    @typing.overload
    @staticmethod
    def getDouble(parent: PySide2.QtWidgets.QWidget, title: str, label: str, value: float, minValue: float = ..., maxValue: float = ..., decimals: int = ..., ok: bool = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> float: ...
    @staticmethod
    def getInt(parent: PySide2.QtWidgets.QWidget, title: str, label: str, value: int, minValue: int = ..., maxValue: int = ..., step: int = ..., ok: bool = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> int: ...
    @staticmethod
    def getItem(parent: PySide2.QtWidgets.QWidget, title: str, label: str, items: typing.List[str], current: int, editable: bool = ..., ok: bool = ..., flags: PySide2.QtCore.Qt.WindowFlags = ..., inputMethodHints: PySide2.QtCore.Qt.InputMethodHints = ...) -> str: ...
    @staticmethod
    def getMultiLineText(parent: PySide2.QtWidgets.QWidget, title: str, label: str, text: str, ok: bool = ..., flags: PySide2.QtCore.Qt.WindowFlags = ..., inputMethodHints: PySide2.QtCore.Qt.InputMethodHints = ...) -> str: ...
    @staticmethod
    def getText(parent: PySide2.QtWidgets.QWidget, title: str, label: str, echo: PySide2.QtWidgets.QLineEdit.EchoMode, text: str = ..., ok: bool = ..., flags: PySide2.QtCore.Qt.WindowFlags = ..., inputMethodHints: PySide2.QtCore.Qt.InputMethodHints = ...) -> str: ...
    def inputMode(self) -> PySide2.QtWidgets.QInputDialog.InputMode: ...
    def intMaximum(self) -> int: ...
    def intMinimum(self) -> int: ...
    def intStep(self) -> int: ...
    def intValue(self) -> int: ...
    def isComboBoxEditable(self) -> bool: ...
    def labelText(self) -> str: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def okButtonText(self) -> str: ...
    @typing.overload
    def open(self): ...
    @typing.overload
    def open(self, receiver: PySide2.QtCore.QObject, member: str): ...
    def setCancelButtonText(self, text: str): ...
    def setComboBoxEditable(self, editable: bool): ...
    def setComboBoxItems(self, items: typing.List[str]): ...
    def setDoubleDecimals(self, decimals: int): ...
    def setDoubleMaximum(self, max: float): ...
    def setDoubleMinimum(self, min: float): ...
    def setDoubleRange(self, min: float, max: float): ...
    def setDoubleStep(self, step: float): ...
    def setDoubleValue(self, value: float): ...
    def setInputMode(self, mode: PySide2.QtWidgets.QInputDialog.InputMode): ...
    def setIntMaximum(self, max: int): ...
    def setIntMinimum(self, min: int): ...
    def setIntRange(self, min: int, max: int): ...
    def setIntStep(self, step: int): ...
    def setIntValue(self, value: int): ...
    def setLabelText(self, text: str): ...
    def setOkButtonText(self, text: str): ...
    def setOption(self, option: PySide2.QtWidgets.QInputDialog.InputDialogOption, on: bool = ...): ...
    def setTextEchoMode(self, mode: PySide2.QtWidgets.QLineEdit.EchoMode): ...
    def setTextValue(self, text: str): ...
    def setVisible(self, visible: bool): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def testOption(self, option: PySide2.QtWidgets.QInputDialog.InputDialogOption) -> bool: ...
    def textEchoMode(self) -> PySide2.QtWidgets.QLineEdit.EchoMode: ...
    def textValue(self) -> str: ...


class QItemDelegate(PySide2.QtWidgets.QAbstractItemDelegate):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def createEditor(self, parent: PySide2.QtWidgets.QWidget, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QWidget: ...
    def decoration(self, option: PySide2.QtWidgets.QStyleOptionViewItem, variant: typing.Any) -> PySide2.QtGui.QPixmap: ...
    def doCheck(self, option: PySide2.QtWidgets.QStyleOptionViewItem, bounding: PySide2.QtCore.QRect, variant: typing.Any) -> PySide2.QtCore.QRect: ...
    def drawBackground(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex): ...
    def drawCheck(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionViewItem, rect: PySide2.QtCore.QRect, state: PySide2.QtCore.Qt.CheckState): ...
    def drawDecoration(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionViewItem, rect: PySide2.QtCore.QRect, pixmap: PySide2.QtGui.QPixmap): ...
    def drawDisplay(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionViewItem, rect: PySide2.QtCore.QRect, text: str): ...
    def drawFocus(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionViewItem, rect: PySide2.QtCore.QRect): ...
    def editorEvent(self, event: PySide2.QtCore.QEvent, model: PySide2.QtCore.QAbstractItemModel, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def eventFilter(self, object: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def hasClipping(self) -> bool: ...
    def itemEditorFactory(self) -> PySide2.QtWidgets.QItemEditorFactory: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex): ...
    def rect(self, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex, role: int) -> PySide2.QtCore.QRect: ...
    def setClipping(self, clip: bool): ...
    def setEditorData(self, editor: PySide2.QtWidgets.QWidget, index: PySide2.QtCore.QModelIndex): ...
    def setItemEditorFactory(self, factory: PySide2.QtWidgets.QItemEditorFactory): ...
    def setModelData(self, editor: PySide2.QtWidgets.QWidget, model: PySide2.QtCore.QAbstractItemModel, index: PySide2.QtCore.QModelIndex): ...
    def setOptions(self, index: PySide2.QtCore.QModelIndex, option: PySide2.QtWidgets.QStyleOptionViewItem) -> PySide2.QtWidgets.QStyleOptionViewItem: ...
    def sizeHint(self, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QSize: ...
    def textRectangle(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRect, font: PySide2.QtGui.QFont, text: str) -> PySide2.QtCore.QRect: ...
    def updateEditorGeometry(self, editor: PySide2.QtWidgets.QWidget, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex): ...


class QItemEditorCreatorBase(Shiboken.Object):

    def __init__(self): ...
    def createWidget(self, parent: PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QWidget: ...
    def valuePropertyName(self) -> PySide2.QtCore.QByteArray: ...


class QItemEditorFactory(Shiboken.Object):

    def __init__(self): ...
    def createEditor(self, userType: int, parent: PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QWidget: ...
    @staticmethod
    def defaultFactory() -> PySide2.QtWidgets.QItemEditorFactory: ...
    def registerEditor(self, userType: int, creator: PySide2.QtWidgets.QItemEditorCreatorBase): ...
    @staticmethod
    def setDefaultFactory(factory: PySide2.QtWidgets.QItemEditorFactory): ...
    def valuePropertyName(self, userType: int) -> PySide2.QtCore.QByteArray: ...


class QKeyEventTransition(PySide2.QtCore.QEventTransition):

    @typing.overload
    def __init__(self, object: PySide2.QtCore.QObject, type: PySide2.QtCore.QEvent.Type, key: int, sourceState: PySide2.QtCore.QState = ...): ...
    @typing.overload
    def __init__(self, sourceState: PySide2.QtCore.QState = ...): ...
    def eventTest(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def key(self) -> int: ...
    def modifierMask(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def onTransition(self, event: PySide2.QtCore.QEvent): ...
    def setKey(self, key: int): ...
    def setModifierMask(self, modifiers: PySide2.QtCore.Qt.KeyboardModifiers): ...


class QKeySequenceEdit(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, keySequence: PySide2.QtGui.QKeySequence, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def clear(self): ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, arg__1: PySide2.QtGui.QKeyEvent): ...
    def keySequence(self) -> PySide2.QtGui.QKeySequence: ...
    def setKeySequence(self, keySequence: PySide2.QtGui.QKeySequence): ...
    def timerEvent(self, arg__1: PySide2.QtCore.QTimerEvent): ...


class QLCDNumber(PySide2.QtWidgets.QFrame):

    @typing.overload
    def __init__(self, numDigits: int, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def checkOverflow(self, num: float) -> bool: ...
    @typing.overload
    def checkOverflow(self, num: int) -> bool: ...
    def digitCount(self) -> int: ...
    @typing.overload
    def display(self, num: float): ...
    @typing.overload
    def display(self, num: int): ...
    @typing.overload
    def display(self, str: str): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def intValue(self) -> int: ...
    def mode(self) -> PySide2.QtWidgets.QLCDNumber.Mode: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent): ...
    def segmentStyle(self) -> PySide2.QtWidgets.QLCDNumber.SegmentStyle: ...
    def setBinMode(self): ...
    def setDecMode(self): ...
    def setDigitCount(self, nDigits: int): ...
    def setHexMode(self): ...
    def setMode(self, arg__1: PySide2.QtWidgets.QLCDNumber.Mode): ...
    def setOctMode(self): ...
    def setSegmentStyle(self, arg__1: PySide2.QtWidgets.QLCDNumber.SegmentStyle): ...
    def setSmallDecimalPoint(self, arg__1: bool): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def smallDecimalPoint(self) -> bool: ...
    def value(self) -> float: ...


class QLabel(PySide2.QtWidgets.QFrame):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ..., f: PySide2.QtCore.Qt.WindowFlags = ...): ...
    @typing.overload
    def __init__(self, text: str, parent: PySide2.QtWidgets.QWidget = ..., f: PySide2.QtCore.Qt.WindowFlags = ...): ...
    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def buddy(self) -> PySide2.QtWidgets.QWidget: ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent): ...
    def clear(self): ...
    def contextMenuEvent(self, ev: PySide2.QtGui.QContextMenuEvent): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, ev: PySide2.QtGui.QFocusEvent): ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, ev: PySide2.QtGui.QFocusEvent): ...
    def hasScaledContents(self) -> bool: ...
    def hasSelectedText(self) -> bool: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def indent(self) -> int: ...
    def keyPressEvent(self, ev: PySide2.QtGui.QKeyEvent): ...
    def margin(self) -> int: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, ev: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, ev: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, ev: PySide2.QtGui.QMouseEvent): ...
    def movie(self) -> PySide2.QtGui.QMovie: ...
    def openExternalLinks(self) -> bool: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent): ...
    def picture(self) -> PySide2.QtGui.QPicture: ...
    def pixmap(self) -> PySide2.QtGui.QPixmap: ...
    def selectedText(self) -> str: ...
    def selectionStart(self) -> int: ...
    def setAlignment(self, arg__1: PySide2.QtCore.Qt.Alignment): ...
    def setBuddy(self, arg__1: PySide2.QtWidgets.QWidget): ...
    def setIndent(self, arg__1: int): ...
    def setMargin(self, arg__1: int): ...
    def setMovie(self, movie: PySide2.QtGui.QMovie): ...
    @typing.overload
    def setNum(self, arg__1: float): ...
    @typing.overload
    def setNum(self, arg__1: int): ...
    def setOpenExternalLinks(self, open: bool): ...
    def setPicture(self, arg__1: PySide2.QtGui.QPicture): ...
    def setPixmap(self, arg__1: PySide2.QtGui.QPixmap): ...
    def setScaledContents(self, arg__1: bool): ...
    def setSelection(self, arg__1: int, arg__2: int): ...
    def setText(self, arg__1: str): ...
    def setTextFormat(self, arg__1: PySide2.QtCore.Qt.TextFormat): ...
    def setTextInteractionFlags(self, flags: PySide2.QtCore.Qt.TextInteractionFlags): ...
    def setWordWrap(self, on: bool): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def text(self) -> str: ...
    def textFormat(self) -> PySide2.QtCore.Qt.TextFormat: ...
    def textInteractionFlags(self) -> PySide2.QtCore.Qt.TextInteractionFlags: ...
    def wordWrap(self) -> bool: ...


class QLayout(PySide2.QtCore.QObject, PySide2.QtWidgets.QLayoutItem):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget): ...
    def activate(self) -> bool: ...
    def addChildLayout(self, l: PySide2.QtWidgets.QLayout): ...
    def addChildWidget(self, w: PySide2.QtWidgets.QWidget): ...
    def addItem(self, arg__1: PySide2.QtWidgets.QLayoutItem): ...
    def addWidget(self, w: PySide2.QtWidgets.QWidget): ...
    def adoptLayout(self, layout: PySide2.QtWidgets.QLayout) -> bool: ...
    def alignmentRect(self, arg__1: PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    def childEvent(self, e: PySide2.QtCore.QChildEvent): ...
    @staticmethod
    def closestAcceptableSize(w: PySide2.QtWidgets.QWidget, s: PySide2.QtCore.QSize) -> PySide2.QtCore.QSize: ...
    def contentsMargins(self) -> PySide2.QtCore.QMargins: ...
    def contentsRect(self) -> PySide2.QtCore.QRect: ...
    def controlTypes(self) -> PySide2.QtWidgets.QSizePolicy.ControlTypes: ...
    def count(self) -> int: ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def getContentsMargins(self, left: int, top: int, right: int, bottom: int): ...
    @typing.overload
    def indexOf(self, arg__1: PySide2.QtWidgets.QLayoutItem) -> int: ...
    @typing.overload
    def indexOf(self, arg__1: PySide2.QtWidgets.QWidget) -> int: ...
    def invalidate(self): ...
    def isEmpty(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def itemAt(self, index: int) -> PySide2.QtWidgets.QLayoutItem: ...
    def layout(self) -> PySide2.QtWidgets.QLayout: ...
    def margin(self) -> int: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def menuBar(self) -> PySide2.QtWidgets.QWidget: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def parentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def removeItem(self, arg__1: PySide2.QtWidgets.QLayoutItem): ...
    def removeWidget(self, w: PySide2.QtWidgets.QWidget): ...
    def replaceWidget(self, from_: PySide2.QtWidgets.QWidget, to: PySide2.QtWidgets.QWidget, options: PySide2.QtCore.Qt.FindChildOptions = ...) -> PySide2.QtWidgets.QLayoutItem: ...
    @typing.overload
    def setAlignment(self, arg__1: PySide2.QtCore.Qt.Alignment): ...
    @typing.overload
    def setAlignment(self, l: PySide2.QtWidgets.QLayout, alignment: PySide2.QtCore.Qt.Alignment) -> bool: ...
    @typing.overload
    def setAlignment(self, w: PySide2.QtWidgets.QWidget, alignment: PySide2.QtCore.Qt.Alignment) -> bool: ...
    @typing.overload
    def setContentsMargins(self, left: int, top: int, right: int, bottom: int): ...
    @typing.overload
    def setContentsMargins(self, margins: PySide2.QtCore.QMargins): ...
    def setEnabled(self, arg__1: bool): ...
    def setGeometry(self, arg__1: PySide2.QtCore.QRect): ...
    def setMargin(self, arg__1: int): ...
    def setMenuBar(self, w: PySide2.QtWidgets.QWidget): ...
    def setSizeConstraint(self, arg__1: PySide2.QtWidgets.QLayout.SizeConstraint): ...
    def setSpacing(self, arg__1: int): ...
    def sizeConstraint(self) -> PySide2.QtWidgets.QLayout.SizeConstraint: ...
    def spacing(self) -> int: ...
    def takeAt(self, index: int) -> PySide2.QtWidgets.QLayoutItem: ...
    def totalHeightForWidth(self, w: int) -> int: ...
    def totalMaximumSize(self) -> PySide2.QtCore.QSize: ...
    def totalMinimumSize(self) -> PySide2.QtCore.QSize: ...
    def totalSizeHint(self) -> PySide2.QtCore.QSize: ...
    def update(self): ...
    def widgetEvent(self, arg__1: PySide2.QtCore.QEvent): ...


class QLayoutItem(Shiboken.Object):

    def __init__(self, alignment: PySide2.QtCore.Qt.Alignment = ...): ...
    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def controlTypes(self) -> PySide2.QtWidgets.QSizePolicy.ControlTypes: ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def invalidate(self): ...
    def isEmpty(self) -> bool: ...
    def layout(self) -> PySide2.QtWidgets.QLayout: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumHeightForWidth(self, arg__1: int) -> int: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def setAlignment(self, a: PySide2.QtCore.Qt.Alignment): ...
    def setGeometry(self, arg__1: PySide2.QtCore.QRect): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def spacerItem(self) -> PySide2.QtWidgets.QSpacerItem: ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QLineEdit(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, arg__1: str, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def addAction(self, action: PySide2.QtWidgets.QAction): ...
    @typing.overload
    def addAction(self, action: PySide2.QtWidgets.QAction, position: PySide2.QtWidgets.QLineEdit.ActionPosition): ...
    @typing.overload
    def addAction(self, arg__1: PySide2.QtWidgets.QAction): ...
    @typing.overload
    def addAction(self, icon: PySide2.QtGui.QIcon, position: PySide2.QtWidgets.QLineEdit.ActionPosition) -> PySide2.QtWidgets.QAction: ...
    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def backspace(self): ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent): ...
    def clear(self): ...
    def completer(self) -> PySide2.QtWidgets.QCompleter: ...
    def contextMenuEvent(self, arg__1: PySide2.QtGui.QContextMenuEvent): ...
    def copy(self): ...
    def createStandardContextMenu(self) -> PySide2.QtWidgets.QMenu: ...
    def cursorBackward(self, mark: bool, steps: int = ...): ...
    def cursorForward(self, mark: bool, steps: int = ...): ...
    def cursorMoveStyle(self) -> PySide2.QtCore.Qt.CursorMoveStyle: ...
    def cursorPosition(self) -> int: ...
    def cursorPositionAt(self, pos: PySide2.QtCore.QPoint) -> int: ...
    def cursorRect(self) -> PySide2.QtCore.QRect: ...
    def cursorWordBackward(self, mark: bool): ...
    def cursorWordForward(self, mark: bool): ...
    def cut(self): ...
    def del_(self): ...
    def deselect(self): ...
    def displayText(self) -> str: ...
    def dragEnabled(self) -> bool: ...
    def dragEnterEvent(self, arg__1: PySide2.QtGui.QDragEnterEvent): ...
    def dragLeaveEvent(self, e: PySide2.QtGui.QDragLeaveEvent): ...
    def dragMoveEvent(self, e: PySide2.QtGui.QDragMoveEvent): ...
    def dropEvent(self, arg__1: PySide2.QtGui.QDropEvent): ...
    def echoMode(self) -> PySide2.QtWidgets.QLineEdit.EchoMode: ...
    def end(self, mark: bool): ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, arg__1: PySide2.QtGui.QFocusEvent): ...
    def focusOutEvent(self, arg__1: PySide2.QtGui.QFocusEvent): ...
    def getTextMargins(self, left: int, top: int, right: int, bottom: int): ...
    def hasAcceptableInput(self) -> bool: ...
    def hasFrame(self) -> bool: ...
    def hasSelectedText(self) -> bool: ...
    def home(self, mark: bool): ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionFrame): ...
    def inputMask(self) -> str: ...
    def inputMethodEvent(self, arg__1: PySide2.QtGui.QInputMethodEvent): ...
    @typing.overload
    def inputMethodQuery(self, arg__1: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    @typing.overload
    def inputMethodQuery(self, property: PySide2.QtCore.Qt.InputMethodQuery, argument: typing.Any) -> typing.Any: ...
    def insert(self, arg__1: str): ...
    def isClearButtonEnabled(self) -> bool: ...
    def isModified(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def isRedoAvailable(self) -> bool: ...
    def isUndoAvailable(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent): ...
    def maxLength(self) -> int: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseDoubleClickEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent): ...
    def paste(self): ...
    def placeholderText(self) -> str: ...
    def redo(self): ...
    def selectAll(self): ...
    def selectedText(self) -> str: ...
    def selectionEnd(self) -> int: ...
    def selectionLength(self) -> int: ...
    def selectionStart(self) -> int: ...
    def setAlignment(self, flag: PySide2.QtCore.Qt.Alignment): ...
    def setClearButtonEnabled(self, enable: bool): ...
    def setCompleter(self, completer: PySide2.QtWidgets.QCompleter): ...
    def setCursorMoveStyle(self, style: PySide2.QtCore.Qt.CursorMoveStyle): ...
    def setCursorPosition(self, arg__1: int): ...
    def setDragEnabled(self, b: bool): ...
    def setEchoMode(self, arg__1: PySide2.QtWidgets.QLineEdit.EchoMode): ...
    def setFrame(self, arg__1: bool): ...
    def setInputMask(self, inputMask: str): ...
    def setMaxLength(self, arg__1: int): ...
    def setModified(self, arg__1: bool): ...
    def setPlaceholderText(self, arg__1: str): ...
    def setReadOnly(self, arg__1: bool): ...
    def setSelection(self, arg__1: int, arg__2: int): ...
    def setText(self, arg__1: str): ...
    @typing.overload
    def setTextMargins(self, left: int, top: int, right: int, bottom: int): ...
    @typing.overload
    def setTextMargins(self, margins: PySide2.QtCore.QMargins): ...
    def setValidator(self, arg__1: PySide2.QtGui.QValidator): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def text(self) -> str: ...
    def textMargins(self) -> PySide2.QtCore.QMargins: ...
    def undo(self): ...
    def validator(self) -> PySide2.QtGui.QValidator: ...


class QListView(PySide2.QtWidgets.QAbstractItemView):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def batchSize(self) -> int: ...
    def clearPropertyFlags(self): ...
    def contentsSize(self) -> PySide2.QtCore.QSize: ...
    def currentChanged(self, current: PySide2.QtCore.QModelIndex, previous: PySide2.QtCore.QModelIndex): ...
    def dataChanged(self, topLeft: PySide2.QtCore.QModelIndex, bottomRight: PySide2.QtCore.QModelIndex, roles: typing.List[int] = ...): ...
    def doItemsLayout(self): ...
    def dragLeaveEvent(self, e: PySide2.QtGui.QDragLeaveEvent): ...
    def dragMoveEvent(self, e: PySide2.QtGui.QDragMoveEvent): ...
    def dropEvent(self, e: PySide2.QtGui.QDropEvent): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def flow(self) -> PySide2.QtWidgets.QListView.Flow: ...
    def gridSize(self) -> PySide2.QtCore.QSize: ...
    def horizontalOffset(self) -> int: ...
    def indexAt(self, p: PySide2.QtCore.QPoint) -> PySide2.QtCore.QModelIndex: ...
    def isIndexHidden(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def isRowHidden(self, row: int) -> bool: ...
    def isSelectionRectVisible(self) -> bool: ...
    def isWrapping(self) -> bool: ...
    def itemAlignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def layoutMode(self) -> PySide2.QtWidgets.QListView.LayoutMode: ...
    def modelColumn(self) -> int: ...
    def mouseMoveEvent(self, e: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, e: PySide2.QtGui.QMouseEvent): ...
    def moveCursor(self, cursorAction: PySide2.QtWidgets.QAbstractItemView.CursorAction, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> PySide2.QtCore.QModelIndex: ...
    def movement(self) -> PySide2.QtWidgets.QListView.Movement: ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent): ...
    def rectForIndex(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def reset(self): ...
    def resizeContents(self, width: int, height: int): ...
    def resizeEvent(self, e: PySide2.QtGui.QResizeEvent): ...
    def resizeMode(self) -> PySide2.QtWidgets.QListView.ResizeMode: ...
    def rowsAboutToBeRemoved(self, parent: PySide2.QtCore.QModelIndex, start: int, end: int): ...
    def rowsInserted(self, parent: PySide2.QtCore.QModelIndex, start: int, end: int): ...
    def scrollContentsBy(self, dx: int, dy: int): ...
    def scrollTo(self, index: PySide2.QtCore.QModelIndex, hint: PySide2.QtWidgets.QAbstractItemView.ScrollHint = ...): ...
    def selectedIndexes(self) -> typing.List[int]: ...
    def selectionChanged(self, selected: PySide2.QtCore.QItemSelection, deselected: PySide2.QtCore.QItemSelection): ...
    def setBatchSize(self, batchSize: int): ...
    def setFlow(self, flow: PySide2.QtWidgets.QListView.Flow): ...
    def setGridSize(self, size: PySide2.QtCore.QSize): ...
    def setItemAlignment(self, alignment: PySide2.QtCore.Qt.Alignment): ...
    def setLayoutMode(self, mode: PySide2.QtWidgets.QListView.LayoutMode): ...
    def setModelColumn(self, column: int): ...
    def setMovement(self, movement: PySide2.QtWidgets.QListView.Movement): ...
    def setPositionForIndex(self, position: PySide2.QtCore.QPoint, index: PySide2.QtCore.QModelIndex): ...
    def setResizeMode(self, mode: PySide2.QtWidgets.QListView.ResizeMode): ...
    def setRootIndex(self, index: PySide2.QtCore.QModelIndex): ...
    def setRowHidden(self, row: int, hide: bool): ...
    def setSelection(self, rect: PySide2.QtCore.QRect, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    def setSelectionRectVisible(self, show: bool): ...
    def setSpacing(self, space: int): ...
    def setUniformItemSizes(self, enable: bool): ...
    def setViewMode(self, mode: PySide2.QtWidgets.QListView.ViewMode): ...
    def setWordWrap(self, on: bool): ...
    def setWrapping(self, enable: bool): ...
    def spacing(self) -> int: ...
    def startDrag(self, supportedActions: PySide2.QtCore.Qt.DropActions): ...
    def timerEvent(self, e: PySide2.QtCore.QTimerEvent): ...
    def uniformItemSizes(self) -> bool: ...
    def updateGeometries(self): ...
    def verticalOffset(self) -> int: ...
    def viewMode(self) -> PySide2.QtWidgets.QListView.ViewMode: ...
    def viewOptions(self) -> PySide2.QtWidgets.QStyleOptionViewItem: ...
    def viewportSizeHint(self) -> PySide2.QtCore.QSize: ...
    def visualRect(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide2.QtCore.QItemSelection) -> PySide2.QtGui.QRegion: ...
    def wheelEvent(self, e: PySide2.QtGui.QWheelEvent): ...
    def wordWrap(self) -> bool: ...


class QListWidget(PySide2.QtWidgets.QListView):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def addItem(self, item: PySide2.QtWidgets.QListWidgetItem): ...
    @typing.overload
    def addItem(self, label: str): ...
    def addItems(self, labels: typing.List[str]): ...
    def clear(self): ...
    @typing.overload
    def closePersistentEditor(self, index: PySide2.QtCore.QModelIndex): ...
    @typing.overload
    def closePersistentEditor(self, item: PySide2.QtWidgets.QListWidgetItem): ...
    def count(self) -> int: ...
    def currentItem(self) -> PySide2.QtWidgets.QListWidgetItem: ...
    def currentRow(self) -> int: ...
    def dropEvent(self, event: PySide2.QtGui.QDropEvent): ...
    def dropMimeData(self, index: int, data: PySide2.QtCore.QMimeData, action: PySide2.QtCore.Qt.DropAction) -> bool: ...
    def editItem(self, item: PySide2.QtWidgets.QListWidgetItem): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def findItems(self, text: str, flags: PySide2.QtCore.Qt.MatchFlags) -> typing.List[PySide2.QtWidgets.QListWidgetItem]: ...
    def indexFromItem(self, item: PySide2.QtWidgets.QListWidgetItem) -> PySide2.QtCore.QModelIndex: ...
    @typing.overload
    def insertItem(self, row: int, item: PySide2.QtWidgets.QListWidgetItem): ...
    @typing.overload
    def insertItem(self, row: int, label: str): ...
    def insertItems(self, row: int, labels: typing.List[str]): ...
    def isItemHidden(self, item: PySide2.QtWidgets.QListWidgetItem) -> bool: ...
    def isItemSelected(self, item: PySide2.QtWidgets.QListWidgetItem) -> bool: ...
    @typing.overload
    def isPersistentEditorOpen(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    @typing.overload
    def isPersistentEditorOpen(self, item: PySide2.QtWidgets.QListWidgetItem) -> bool: ...
    def isSortingEnabled(self) -> bool: ...
    def item(self, row: int) -> PySide2.QtWidgets.QListWidgetItem: ...
    @typing.overload
    def itemAt(self, p: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QListWidgetItem: ...
    @typing.overload
    def itemAt(self, x: int, y: int) -> PySide2.QtWidgets.QListWidgetItem: ...
    def itemFromIndex(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QListWidgetItem: ...
    def itemWidget(self, item: PySide2.QtWidgets.QListWidgetItem) -> PySide2.QtWidgets.QWidget: ...
    def items(self, data: PySide2.QtCore.QMimeData) -> typing.List[PySide2.QtWidgets.QListWidgetItem]: ...
    def mimeData(self, items: typing.List[PySide2.QtWidgets.QListWidgetItem]) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    @typing.overload
    def openPersistentEditor(self, index: PySide2.QtCore.QModelIndex): ...
    @typing.overload
    def openPersistentEditor(self, item: PySide2.QtWidgets.QListWidgetItem): ...
    def removeItemWidget(self, item: PySide2.QtWidgets.QListWidgetItem): ...
    def row(self, item: PySide2.QtWidgets.QListWidgetItem) -> int: ...
    def scrollToItem(self, item: PySide2.QtWidgets.QListWidgetItem, hint: PySide2.QtWidgets.QAbstractItemView.ScrollHint = ...): ...
    def selectedItems(self) -> typing.List[PySide2.QtWidgets.QListWidgetItem]: ...
    @typing.overload
    def setCurrentItem(self, item: PySide2.QtWidgets.QListWidgetItem): ...
    @typing.overload
    def setCurrentItem(self, item: PySide2.QtWidgets.QListWidgetItem, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    @typing.overload
    def setCurrentRow(self, row: int): ...
    @typing.overload
    def setCurrentRow(self, row: int, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    def setItemHidden(self, item: PySide2.QtWidgets.QListWidgetItem, hide: bool): ...
    def setItemSelected(self, item: PySide2.QtWidgets.QListWidgetItem, select: bool): ...
    def setItemWidget(self, item: PySide2.QtWidgets.QListWidgetItem, widget: PySide2.QtWidgets.QWidget): ...
    def setModel(self, model: PySide2.QtCore.QAbstractItemModel): ...
    def setSelectionModel(self, selectionModel: PySide2.QtCore.QItemSelectionModel): ...
    def setSortingEnabled(self, enable: bool): ...
    def sortItems(self, order: PySide2.QtCore.Qt.SortOrder = ...): ...
    def supportedDropActions(self) -> PySide2.QtCore.Qt.DropActions: ...
    def takeItem(self, row: int) -> PySide2.QtWidgets.QListWidgetItem: ...
    def visualItemRect(self, item: PySide2.QtWidgets.QListWidgetItem) -> PySide2.QtCore.QRect: ...


class QListWidgetItem(Shiboken.Object):

    @typing.overload
    def __init__(self, icon: PySide2.QtGui.QIcon, text: str, view: PySide2.QtWidgets.QListWidget = ..., type: int = ...): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QListWidgetItem): ...
    @typing.overload
    def __init__(self, text: str, view: PySide2.QtWidgets.QListWidget = ..., type: int = ...): ...
    @typing.overload
    def __init__(self, view: PySide2.QtWidgets.QListWidget = ..., type: int = ...): ...
    def __lshift__(self, out: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, in_: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def background(self) -> PySide2.QtGui.QBrush: ...
    def backgroundColor(self) -> PySide2.QtGui.QColor: ...
    def checkState(self) -> PySide2.QtCore.Qt.CheckState: ...
    def clone(self) -> PySide2.QtWidgets.QListWidgetItem: ...
    def data(self, role: int) -> typing.Any: ...
    def flags(self) -> PySide2.QtCore.Qt.ItemFlags: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def foreground(self) -> PySide2.QtGui.QBrush: ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def isHidden(self) -> bool: ...
    def isSelected(self) -> bool: ...
    def listWidget(self) -> PySide2.QtWidgets.QListWidget: ...
    def read(self, in_: PySide2.QtCore.QDataStream): ...
    def setBackground(self, brush: PySide2.QtGui.QBrush): ...
    def setBackgroundColor(self, color: PySide2.QtGui.QColor): ...
    def setCheckState(self, state: PySide2.QtCore.Qt.CheckState): ...
    def setData(self, role: int, value: typing.Any): ...
    def setFlags(self, flags: PySide2.QtCore.Qt.ItemFlags): ...
    def setFont(self, font: PySide2.QtGui.QFont): ...
    def setForeground(self, brush: PySide2.QtGui.QBrush): ...
    def setHidden(self, hide: bool): ...
    def setIcon(self, icon: PySide2.QtGui.QIcon): ...
    def setSelected(self, select: bool): ...
    def setSizeHint(self, size: PySide2.QtCore.QSize): ...
    def setStatusTip(self, statusTip: str): ...
    def setText(self, text: str): ...
    def setTextAlignment(self, alignment: int): ...
    def setTextColor(self, color: PySide2.QtGui.QColor): ...
    def setToolTip(self, toolTip: str): ...
    def setWhatsThis(self, whatsThis: str): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def statusTip(self) -> str: ...
    def text(self) -> str: ...
    def textAlignment(self) -> int: ...
    def textColor(self) -> PySide2.QtGui.QColor: ...
    def toolTip(self) -> str: ...
    def type(self) -> int: ...
    def whatsThis(self) -> str: ...
    def write(self, out: PySide2.QtCore.QDataStream): ...


class QMainWindow(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...): ...
    @typing.overload
    def addDockWidget(self, area: PySide2.QtCore.Qt.DockWidgetArea, dockwidget: PySide2.QtWidgets.QDockWidget): ...
    @typing.overload
    def addDockWidget(self, area: PySide2.QtCore.Qt.DockWidgetArea, dockwidget: PySide2.QtWidgets.QDockWidget, orientation: PySide2.QtCore.Qt.Orientation): ...
    @typing.overload
    def addToolBar(self, area: PySide2.QtCore.Qt.ToolBarArea, toolbar: PySide2.QtWidgets.QToolBar): ...
    @typing.overload
    def addToolBar(self, title: str) -> PySide2.QtWidgets.QToolBar: ...
    @typing.overload
    def addToolBar(self, toolbar: PySide2.QtWidgets.QToolBar): ...
    def addToolBarBreak(self, area: PySide2.QtCore.Qt.ToolBarArea = ...): ...
    def centralWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def contextMenuEvent(self, event: PySide2.QtGui.QContextMenuEvent): ...
    def corner(self, corner: PySide2.QtCore.Qt.Corner) -> PySide2.QtCore.Qt.DockWidgetArea: ...
    def createPopupMenu(self) -> PySide2.QtWidgets.QMenu: ...
    def dockOptions(self) -> PySide2.QtWidgets.QMainWindow.DockOptions: ...
    def dockWidgetArea(self, dockwidget: PySide2.QtWidgets.QDockWidget) -> PySide2.QtCore.Qt.DockWidgetArea: ...
    def documentMode(self) -> bool: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def insertToolBar(self, before: PySide2.QtWidgets.QToolBar, toolbar: PySide2.QtWidgets.QToolBar): ...
    def insertToolBarBreak(self, before: PySide2.QtWidgets.QToolBar): ...
    def isAnimated(self) -> bool: ...
    def isDockNestingEnabled(self) -> bool: ...
    def isSeparator(self, pos: PySide2.QtCore.QPoint) -> bool: ...
    def menuBar(self) -> PySide2.QtWidgets.QMenuBar: ...
    def menuWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def removeDockWidget(self, dockwidget: PySide2.QtWidgets.QDockWidget): ...
    def removeToolBar(self, toolbar: PySide2.QtWidgets.QToolBar): ...
    def removeToolBarBreak(self, before: PySide2.QtWidgets.QToolBar): ...
    def resizeDocks(self, docks: typing.List[PySide2.QtWidgets.QDockWidget], sizes: typing.List[int], orientation: PySide2.QtCore.Qt.Orientation): ...
    def restoreDockWidget(self, dockwidget: PySide2.QtWidgets.QDockWidget) -> bool: ...
    def restoreState(self, state: PySide2.QtCore.QByteArray, version: int = ...) -> bool: ...
    def saveState(self, version: int = ...) -> PySide2.QtCore.QByteArray: ...
    def setAnimated(self, enabled: bool): ...
    def setCentralWidget(self, widget: PySide2.QtWidgets.QWidget): ...
    def setCorner(self, corner: PySide2.QtCore.Qt.Corner, area: PySide2.QtCore.Qt.DockWidgetArea): ...
    def setDockNestingEnabled(self, enabled: bool): ...
    def setDockOptions(self, options: PySide2.QtWidgets.QMainWindow.DockOptions): ...
    def setDocumentMode(self, enabled: bool): ...
    def setIconSize(self, iconSize: PySide2.QtCore.QSize): ...
    def setMenuBar(self, menubar: PySide2.QtWidgets.QMenuBar): ...
    def setMenuWidget(self, menubar: PySide2.QtWidgets.QWidget): ...
    def setStatusBar(self, statusbar: PySide2.QtWidgets.QStatusBar): ...
    def setTabPosition(self, areas: PySide2.QtCore.Qt.DockWidgetAreas, tabPosition: PySide2.QtWidgets.QTabWidget.TabPosition): ...
    def setTabShape(self, tabShape: PySide2.QtWidgets.QTabWidget.TabShape): ...
    def setToolButtonStyle(self, toolButtonStyle: PySide2.QtCore.Qt.ToolButtonStyle): ...
    def setUnifiedTitleAndToolBarOnMac(self, set: bool): ...
    def splitDockWidget(self, after: PySide2.QtWidgets.QDockWidget, dockwidget: PySide2.QtWidgets.QDockWidget, orientation: PySide2.QtCore.Qt.Orientation): ...
    def statusBar(self) -> PySide2.QtWidgets.QStatusBar: ...
    def tabPosition(self, area: PySide2.QtCore.Qt.DockWidgetArea) -> PySide2.QtWidgets.QTabWidget.TabPosition: ...
    def tabShape(self) -> PySide2.QtWidgets.QTabWidget.TabShape: ...
    def tabifiedDockWidgets(self, dockwidget: PySide2.QtWidgets.QDockWidget) -> typing.List[PySide2.QtWidgets.QDockWidget]: ...
    def tabifyDockWidget(self, first: PySide2.QtWidgets.QDockWidget, second: PySide2.QtWidgets.QDockWidget): ...
    def takeCentralWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def toolBarArea(self, toolbar: PySide2.QtWidgets.QToolBar) -> PySide2.QtCore.Qt.ToolBarArea: ...
    def toolBarBreak(self, toolbar: PySide2.QtWidgets.QToolBar) -> bool: ...
    def toolButtonStyle(self) -> PySide2.QtCore.Qt.ToolButtonStyle: ...
    def unifiedTitleAndToolBarOnMac(self) -> bool: ...


class QMdiArea(PySide2.QtWidgets.QAbstractScrollArea):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def activateNextSubWindow(self): ...
    def activatePreviousSubWindow(self): ...
    def activationOrder(self) -> PySide2.QtWidgets.QMdiArea.WindowOrder: ...
    def activeSubWindow(self) -> PySide2.QtWidgets.QMdiSubWindow: ...
    def addSubWindow(self, widget: PySide2.QtWidgets.QWidget, flags: PySide2.QtCore.Qt.WindowFlags = ...) -> PySide2.QtWidgets.QMdiSubWindow: ...
    def background(self) -> PySide2.QtGui.QBrush: ...
    def cascadeSubWindows(self): ...
    def childEvent(self, childEvent: PySide2.QtCore.QChildEvent): ...
    def closeActiveSubWindow(self): ...
    def closeAllSubWindows(self): ...
    def currentSubWindow(self) -> PySide2.QtWidgets.QMdiSubWindow: ...
    def documentMode(self) -> bool: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, object: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def paintEvent(self, paintEvent: PySide2.QtGui.QPaintEvent): ...
    def removeSubWindow(self, widget: PySide2.QtWidgets.QWidget): ...
    def resizeEvent(self, resizeEvent: PySide2.QtGui.QResizeEvent): ...
    def scrollContentsBy(self, dx: int, dy: int): ...
    def setActivationOrder(self, order: PySide2.QtWidgets.QMdiArea.WindowOrder): ...
    def setActiveSubWindow(self, window: PySide2.QtWidgets.QMdiSubWindow): ...
    def setBackground(self, background: PySide2.QtGui.QBrush): ...
    def setDocumentMode(self, enabled: bool): ...
    def setOption(self, option: PySide2.QtWidgets.QMdiArea.AreaOption, on: bool = ...): ...
    def setTabPosition(self, position: PySide2.QtWidgets.QTabWidget.TabPosition): ...
    def setTabShape(self, shape: PySide2.QtWidgets.QTabWidget.TabShape): ...
    def setTabsClosable(self, closable: bool): ...
    def setTabsMovable(self, movable: bool): ...
    def setViewMode(self, mode: PySide2.QtWidgets.QMdiArea.ViewMode): ...
    def setupViewport(self, viewport: PySide2.QtWidgets.QWidget): ...
    def showEvent(self, showEvent: PySide2.QtGui.QShowEvent): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def subWindowList(self, order: PySide2.QtWidgets.QMdiArea.WindowOrder = ...) -> typing.List[PySide2.QtWidgets.QMdiSubWindow]: ...
    def tabPosition(self) -> PySide2.QtWidgets.QTabWidget.TabPosition: ...
    def tabShape(self) -> PySide2.QtWidgets.QTabWidget.TabShape: ...
    def tabsClosable(self) -> bool: ...
    def tabsMovable(self) -> bool: ...
    def testOption(self, opton: PySide2.QtWidgets.QMdiArea.AreaOption) -> bool: ...
    def tileSubWindows(self): ...
    def timerEvent(self, timerEvent: PySide2.QtCore.QTimerEvent): ...
    def viewMode(self) -> PySide2.QtWidgets.QMdiArea.ViewMode: ...
    def viewportEvent(self, event: PySide2.QtCore.QEvent) -> bool: ...


class QMdiSubWindow(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...): ...
    def changeEvent(self, changeEvent: PySide2.QtCore.QEvent): ...
    def childEvent(self, childEvent: PySide2.QtCore.QChildEvent): ...
    def closeEvent(self, closeEvent: PySide2.QtGui.QCloseEvent): ...
    def contextMenuEvent(self, contextMenuEvent: PySide2.QtGui.QContextMenuEvent): ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, object: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, focusInEvent: PySide2.QtGui.QFocusEvent): ...
    def focusOutEvent(self, focusOutEvent: PySide2.QtGui.QFocusEvent): ...
    def hideEvent(self, hideEvent: PySide2.QtGui.QHideEvent): ...
    def isShaded(self) -> bool: ...
    def keyPressEvent(self, keyEvent: PySide2.QtGui.QKeyEvent): ...
    def keyboardPageStep(self) -> int: ...
    def keyboardSingleStep(self) -> int: ...
    def leaveEvent(self, leaveEvent: PySide2.QtCore.QEvent): ...
    def maximizedButtonsWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def maximizedSystemMenuIconWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def mdiArea(self) -> PySide2.QtWidgets.QMdiArea: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseDoubleClickEvent(self, mouseEvent: PySide2.QtGui.QMouseEvent): ...
    def mouseMoveEvent(self, mouseEvent: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, mouseEvent: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, mouseEvent: PySide2.QtGui.QMouseEvent): ...
    def moveEvent(self, moveEvent: PySide2.QtGui.QMoveEvent): ...
    def paintEvent(self, paintEvent: PySide2.QtGui.QPaintEvent): ...
    def resizeEvent(self, resizeEvent: PySide2.QtGui.QResizeEvent): ...
    def setKeyboardPageStep(self, step: int): ...
    def setKeyboardSingleStep(self, step: int): ...
    def setOption(self, option: PySide2.QtWidgets.QMdiSubWindow.SubWindowOption, on: bool = ...): ...
    def setSystemMenu(self, systemMenu: PySide2.QtWidgets.QMenu): ...
    def setWidget(self, widget: PySide2.QtWidgets.QWidget): ...
    def showEvent(self, showEvent: PySide2.QtGui.QShowEvent): ...
    def showShaded(self): ...
    def showSystemMenu(self): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def systemMenu(self) -> PySide2.QtWidgets.QMenu: ...
    def testOption(self, arg__1: PySide2.QtWidgets.QMdiSubWindow.SubWindowOption) -> bool: ...
    def timerEvent(self, timerEvent: PySide2.QtCore.QTimerEvent): ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QMenu(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, title: str, parent: PySide2.QtWidgets.QWidget = ...): ...
    def actionAt(self, arg__1: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QAction: ...
    def actionEvent(self, arg__1: PySide2.QtGui.QActionEvent): ...
    def actionGeometry(self, arg__1: PySide2.QtWidgets.QAction) -> PySide2.QtCore.QRect: ...
    def activeAction(self) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, arg__1: str, arg__2: object, arg__3: PySide2.QtGui.QKeySequence = ...): ...
    @typing.overload
    def addAction(self, arg__1: PySide2.QtGui.QIcon, arg__2: str, arg__3: object, arg__4: PySide2.QtGui.QKeySequence = ...): ...
    @typing.overload
    def addAction(self, arg__1: PySide2.QtWidgets.QAction): ...
    @typing.overload
    def addAction(self, icon: PySide2.QtGui.QIcon, text: str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide2.QtGui.QIcon, text: str, receiver: PySide2.QtCore.QObject, member: str, shortcut: PySide2.QtGui.QKeySequence = ...) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, text: str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, text: str, receiver: PySide2.QtCore.QObject, member: str, shortcut: PySide2.QtGui.QKeySequence = ...) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addMenu(self, icon: PySide2.QtGui.QIcon, title: str) -> PySide2.QtWidgets.QMenu: ...
    @typing.overload
    def addMenu(self, menu: PySide2.QtWidgets.QMenu) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addMenu(self, title: str) -> PySide2.QtWidgets.QMenu: ...
    @typing.overload
    def addSection(self, icon: PySide2.QtGui.QIcon, text: str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addSection(self, text: str) -> PySide2.QtWidgets.QAction: ...
    def addSeparator(self) -> PySide2.QtWidgets.QAction: ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent): ...
    def clear(self): ...
    def columnCount(self) -> int: ...
    def defaultAction(self) -> PySide2.QtWidgets.QAction: ...
    def enterEvent(self, arg__1: PySide2.QtCore.QEvent): ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    @typing.overload
    @staticmethod
    def exec_() -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    @staticmethod
    def exec_(actions: typing.List[PySide2.QtWidgets.QAction], pos: PySide2.QtCore.QPoint, at: PySide2.QtWidgets.QAction = ..., parent: PySide2.QtWidgets.QWidget = ...) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    @staticmethod
    def exec_(pos: PySide2.QtCore.QPoint, at: PySide2.QtWidgets.QAction = ...) -> PySide2.QtWidgets.QAction: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def hideEvent(self, arg__1: PySide2.QtGui.QHideEvent): ...
    def hideTearOffMenu(self): ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionMenuItem, action: PySide2.QtWidgets.QAction): ...
    def insertMenu(self, before: PySide2.QtWidgets.QAction, menu: PySide2.QtWidgets.QMenu) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def insertSection(self, before: PySide2.QtWidgets.QAction, icon: PySide2.QtGui.QIcon, text: str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def insertSection(self, before: PySide2.QtWidgets.QAction, text: str) -> PySide2.QtWidgets.QAction: ...
    def insertSeparator(self, before: PySide2.QtWidgets.QAction) -> PySide2.QtWidgets.QAction: ...
    def isEmpty(self) -> bool: ...
    def isTearOffEnabled(self) -> bool: ...
    def isTearOffMenuVisible(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent): ...
    def leaveEvent(self, arg__1: PySide2.QtCore.QEvent): ...
    def menuAction(self) -> PySide2.QtWidgets.QAction: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent): ...
    def popup(self, pos: PySide2.QtCore.QPoint, at: PySide2.QtWidgets.QAction = ...): ...
    def separatorsCollapsible(self) -> bool: ...
    def setActiveAction(self, act: PySide2.QtWidgets.QAction): ...
    def setDefaultAction(self, arg__1: PySide2.QtWidgets.QAction): ...
    def setIcon(self, icon: PySide2.QtGui.QIcon): ...
    def setSeparatorsCollapsible(self, collapse: bool): ...
    def setTearOffEnabled(self, arg__1: bool): ...
    def setTitle(self, title: str): ...
    def setToolTipsVisible(self, visible: bool): ...
    @typing.overload
    def showTearOffMenu(self): ...
    @typing.overload
    def showTearOffMenu(self, pos: PySide2.QtCore.QPoint): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def timerEvent(self, arg__1: PySide2.QtCore.QTimerEvent): ...
    def title(self) -> str: ...
    def toolTipsVisible(self) -> bool: ...
    def wheelEvent(self, arg__1: PySide2.QtGui.QWheelEvent): ...


class QMenuBar(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def actionAt(self, arg__1: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QAction: ...
    def actionEvent(self, arg__1: PySide2.QtGui.QActionEvent): ...
    def actionGeometry(self, arg__1: PySide2.QtWidgets.QAction) -> PySide2.QtCore.QRect: ...
    def activeAction(self) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, arg__1: PySide2.QtWidgets.QAction): ...
    @typing.overload
    def addAction(self, arg__1: str, arg__2: object): ...
    @typing.overload
    def addAction(self, text: str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, text: str, receiver: PySide2.QtCore.QObject, member: str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addMenu(self, icon: PySide2.QtGui.QIcon, title: str) -> PySide2.QtWidgets.QMenu: ...
    @typing.overload
    def addMenu(self, menu: PySide2.QtWidgets.QMenu) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addMenu(self, title: str) -> PySide2.QtWidgets.QMenu: ...
    def addSeparator(self) -> PySide2.QtWidgets.QAction: ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent): ...
    def clear(self): ...
    def cornerWidget(self, corner: PySide2.QtCore.Qt.Corner = ...) -> PySide2.QtWidgets.QWidget: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, arg__1: PySide2.QtGui.QFocusEvent): ...
    def focusOutEvent(self, arg__1: PySide2.QtGui.QFocusEvent): ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionMenuItem, action: PySide2.QtWidgets.QAction): ...
    def insertMenu(self, before: PySide2.QtWidgets.QAction, menu: PySide2.QtWidgets.QMenu) -> PySide2.QtWidgets.QAction: ...
    def insertSeparator(self, before: PySide2.QtWidgets.QAction) -> PySide2.QtWidgets.QAction: ...
    def isDefaultUp(self) -> bool: ...
    def isNativeMenuBar(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent): ...
    def leaveEvent(self, arg__1: PySide2.QtCore.QEvent): ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent): ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent): ...
    def setActiveAction(self, action: PySide2.QtWidgets.QAction): ...
    def setCornerWidget(self, w: PySide2.QtWidgets.QWidget, corner: PySide2.QtCore.Qt.Corner = ...): ...
    def setDefaultUp(self, arg__1: bool): ...
    def setNativeMenuBar(self, nativeMenuBar: bool): ...
    def setVisible(self, visible: bool): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def timerEvent(self, arg__1: PySide2.QtCore.QTimerEvent): ...


class QMessageBox(PySide2.QtWidgets.QDialog):

    @typing.overload
    def __init__(self, icon: PySide2.QtWidgets.QMessageBox.Icon, title: str, text: str, buttons: PySide2.QtWidgets.QMessageBox.StandardButtons = ..., parent: PySide2.QtWidgets.QWidget = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @staticmethod
    def about(parent: PySide2.QtWidgets.QWidget, title: str, text: str): ...
    @staticmethod
    def aboutQt(parent: PySide2.QtWidgets.QWidget, title: str = ...): ...
    @typing.overload
    def addButton(self, button: PySide2.QtWidgets.QAbstractButton, role: PySide2.QtWidgets.QMessageBox.ButtonRole): ...
    @typing.overload
    def addButton(self, button: PySide2.QtWidgets.QMessageBox.StandardButton) -> PySide2.QtWidgets.QPushButton: ...
    @typing.overload
    def addButton(self, text: str, role: PySide2.QtWidgets.QMessageBox.ButtonRole) -> PySide2.QtWidgets.QPushButton: ...
    def button(self, which: PySide2.QtWidgets.QMessageBox.StandardButton) -> PySide2.QtWidgets.QAbstractButton: ...
    def buttonRole(self, button: PySide2.QtWidgets.QAbstractButton) -> PySide2.QtWidgets.QMessageBox.ButtonRole: ...
    def buttonText(self, button: int) -> str: ...
    def buttons(self) -> typing.List[PySide2.QtWidgets.QAbstractButton]: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent): ...
    def checkBox(self) -> PySide2.QtWidgets.QCheckBox: ...
    def clickedButton(self) -> PySide2.QtWidgets.QAbstractButton: ...
    def closeEvent(self, event: PySide2.QtGui.QCloseEvent): ...
    @typing.overload
    @staticmethod
    def critical(parent: PySide2.QtWidgets.QWidget, title: str, text: str, button0: PySide2.QtWidgets.QMessageBox.StandardButton, button1: PySide2.QtWidgets.QMessageBox.StandardButton) -> int: ...
    @typing.overload
    @staticmethod
    def critical(parent: PySide2.QtWidgets.QWidget, title: str, text: str, buttons: PySide2.QtWidgets.QMessageBox.StandardButtons = ..., defaultButton: PySide2.QtWidgets.QMessageBox.StandardButton = ...) -> PySide2.QtWidgets.QMessageBox.StandardButton: ...
    def defaultButton(self) -> PySide2.QtWidgets.QPushButton: ...
    def detailedText(self) -> str: ...
    def escapeButton(self) -> PySide2.QtWidgets.QAbstractButton: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def icon(self) -> PySide2.QtWidgets.QMessageBox.Icon: ...
    def iconPixmap(self) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    @staticmethod
    def information(parent: PySide2.QtWidgets.QWidget, title: str, text: str, button0: PySide2.QtWidgets.QMessageBox.StandardButton, button1: PySide2.QtWidgets.QMessageBox.StandardButton = ...) -> PySide2.QtWidgets.QMessageBox.StandardButton: ...
    @typing.overload
    @staticmethod
    def information(parent: PySide2.QtWidgets.QWidget, title: str, text: str, buttons: PySide2.QtWidgets.QMessageBox.StandardButtons = ..., defaultButton: PySide2.QtWidgets.QMessageBox.StandardButton = ...) -> PySide2.QtWidgets.QMessageBox.StandardButton: ...
    def informativeText(self) -> str: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent): ...
    @typing.overload
    def open(self): ...
    @typing.overload
    def open(self, receiver: PySide2.QtCore.QObject, member: str): ...
    @typing.overload
    @staticmethod
    def question(parent: PySide2.QtWidgets.QWidget, title: str, text: str, button0: PySide2.QtWidgets.QMessageBox.StandardButton, button1: PySide2.QtWidgets.QMessageBox.StandardButton) -> int: ...
    @typing.overload
    @staticmethod
    def question(parent: PySide2.QtWidgets.QWidget, title: str, text: str, buttons: PySide2.QtWidgets.QMessageBox.StandardButtons = ..., defaultButton: PySide2.QtWidgets.QMessageBox.StandardButton = ...) -> PySide2.QtWidgets.QMessageBox.StandardButton: ...
    def removeButton(self, button: PySide2.QtWidgets.QAbstractButton): ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent): ...
    def setButtonText(self, button: int, text: str): ...
    def setCheckBox(self, cb: PySide2.QtWidgets.QCheckBox): ...
    @typing.overload
    def setDefaultButton(self, button: PySide2.QtWidgets.QMessageBox.StandardButton): ...
    @typing.overload
    def setDefaultButton(self, button: PySide2.QtWidgets.QPushButton): ...
    def setDetailedText(self, text: str): ...
    @typing.overload
    def setEscapeButton(self, button: PySide2.QtWidgets.QAbstractButton): ...
    @typing.overload
    def setEscapeButton(self, button: PySide2.QtWidgets.QMessageBox.StandardButton): ...
    def setIcon(self, arg__1: PySide2.QtWidgets.QMessageBox.Icon): ...
    def setIconPixmap(self, pixmap: PySide2.QtGui.QPixmap): ...
    def setInformativeText(self, text: str): ...
    def setStandardButtons(self, buttons: PySide2.QtWidgets.QMessageBox.StandardButtons): ...
    def setText(self, text: str): ...
    def setTextFormat(self, format: PySide2.QtCore.Qt.TextFormat): ...
    def setTextInteractionFlags(self, flags: PySide2.QtCore.Qt.TextInteractionFlags): ...
    def setWindowModality(self, windowModality: PySide2.QtCore.Qt.WindowModality): ...
    def setWindowTitle(self, title: str): ...
    def showEvent(self, event: PySide2.QtGui.QShowEvent): ...
    def standardButton(self, button: PySide2.QtWidgets.QAbstractButton) -> PySide2.QtWidgets.QMessageBox.StandardButton: ...
    def standardButtons(self) -> PySide2.QtWidgets.QMessageBox.StandardButtons: ...
    @staticmethod
    def standardIcon(icon: PySide2.QtWidgets.QMessageBox.Icon) -> PySide2.QtGui.QPixmap: ...
    def text(self) -> str: ...
    def textFormat(self) -> PySide2.QtCore.Qt.TextFormat: ...
    def textInteractionFlags(self) -> PySide2.QtCore.Qt.TextInteractionFlags: ...
    @typing.overload
    @staticmethod
    def warning(parent: PySide2.QtWidgets.QWidget, title: str, text: str, button0: PySide2.QtWidgets.QMessageBox.StandardButton, button1: PySide2.QtWidgets.QMessageBox.StandardButton) -> int: ...
    @typing.overload
    @staticmethod
    def warning(parent: PySide2.QtWidgets.QWidget, title: str, text: str, buttons: PySide2.QtWidgets.QMessageBox.StandardButtons = ..., defaultButton: PySide2.QtWidgets.QMessageBox.StandardButton = ...) -> PySide2.QtWidgets.QMessageBox.StandardButton: ...


class QMouseEventTransition(PySide2.QtCore.QEventTransition):

    @typing.overload
    def __init__(self, object: PySide2.QtCore.QObject, type: PySide2.QtCore.QEvent.Type, button: PySide2.QtCore.Qt.MouseButton, sourceState: PySide2.QtCore.QState = ...): ...
    @typing.overload
    def __init__(self, sourceState: PySide2.QtCore.QState = ...): ...
    def button(self) -> PySide2.QtCore.Qt.MouseButton: ...
    def eventTest(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def hitTestPath(self) -> PySide2.QtGui.QPainterPath: ...
    def modifierMask(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def onTransition(self, event: PySide2.QtCore.QEvent): ...
    def setButton(self, button: PySide2.QtCore.Qt.MouseButton): ...
    def setHitTestPath(self, path: PySide2.QtGui.QPainterPath): ...
    def setModifierMask(self, modifiers: PySide2.QtCore.Qt.KeyboardModifiers): ...


class QOpenGLWidget(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ..., f: PySide2.QtCore.Qt.WindowFlags = ...): ...
    def context(self) -> PySide2.QtGui.QOpenGLContext: ...
    def defaultFramebufferObject(self) -> int: ...
    def doneCurrent(self): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def format(self) -> PySide2.QtGui.QSurfaceFormat: ...
    def grabFramebuffer(self) -> PySide2.QtGui.QImage: ...
    def initializeGL(self): ...
    def isValid(self) -> bool: ...
    def makeCurrent(self): ...
    def metric(self, metric: PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent): ...
    def paintGL(self): ...
    def redirected(self, p: PySide2.QtCore.QPoint) -> PySide2.QtGui.QPaintDevice: ...
    def resizeEvent(self, e: PySide2.QtGui.QResizeEvent): ...
    def resizeGL(self, w: int, h: int): ...
    def setFormat(self, format: PySide2.QtGui.QSurfaceFormat): ...
    def setTextureFormat(self, texFormat: int): ...
    def setUpdateBehavior(self, updateBehavior: PySide2.QtWidgets.QOpenGLWidget.UpdateBehavior): ...
    def textureFormat(self) -> int: ...
    def updateBehavior(self) -> PySide2.QtWidgets.QOpenGLWidget.UpdateBehavior: ...


class QPanGesture(PySide2.QtWidgets.QGesture):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def acceleration(self) -> float: ...
    def delta(self) -> PySide2.QtCore.QPointF: ...
    def lastOffset(self) -> PySide2.QtCore.QPointF: ...
    def offset(self) -> PySide2.QtCore.QPointF: ...
    def setAcceleration(self, value: float): ...
    def setLastOffset(self, value: PySide2.QtCore.QPointF): ...
    def setOffset(self, value: PySide2.QtCore.QPointF): ...


class QPinchGesture(PySide2.QtWidgets.QGesture):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def centerPoint(self) -> PySide2.QtCore.QPointF: ...
    def changeFlags(self) -> PySide2.QtWidgets.QPinchGesture.ChangeFlags: ...
    def lastCenterPoint(self) -> PySide2.QtCore.QPointF: ...
    def lastRotationAngle(self) -> float: ...
    def lastScaleFactor(self) -> float: ...
    def rotationAngle(self) -> float: ...
    def scaleFactor(self) -> float: ...
    def setCenterPoint(self, value: PySide2.QtCore.QPointF): ...
    def setChangeFlags(self, value: PySide2.QtWidgets.QPinchGesture.ChangeFlags): ...
    def setLastCenterPoint(self, value: PySide2.QtCore.QPointF): ...
    def setLastRotationAngle(self, value: float): ...
    def setLastScaleFactor(self, value: float): ...
    def setRotationAngle(self, value: float): ...
    def setScaleFactor(self, value: float): ...
    def setStartCenterPoint(self, value: PySide2.QtCore.QPointF): ...
    def setTotalChangeFlags(self, value: PySide2.QtWidgets.QPinchGesture.ChangeFlags): ...
    def setTotalRotationAngle(self, value: float): ...
    def setTotalScaleFactor(self, value: float): ...
    def startCenterPoint(self) -> PySide2.QtCore.QPointF: ...
    def totalChangeFlags(self) -> PySide2.QtWidgets.QPinchGesture.ChangeFlags: ...
    def totalRotationAngle(self) -> float: ...
    def totalScaleFactor(self) -> float: ...


class QPlainTextDocumentLayout(PySide2.QtGui.QAbstractTextDocumentLayout):

    def __init__(self, document: PySide2.QtGui.QTextDocument): ...
    def blockBoundingRect(self, block: PySide2.QtGui.QTextBlock) -> PySide2.QtCore.QRectF: ...
    def cursorWidth(self) -> int: ...
    def documentChanged(self, from_: int, arg__2: int, charsAdded: int): ...
    def documentSize(self) -> PySide2.QtCore.QSizeF: ...
    def draw(self, arg__1: PySide2.QtGui.QPainter, arg__2: PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext): ...
    def ensureBlockLayout(self, block: PySide2.QtGui.QTextBlock): ...
    def frameBoundingRect(self, arg__1: PySide2.QtGui.QTextFrame) -> PySide2.QtCore.QRectF: ...
    def hitTest(self, arg__1: PySide2.QtCore.QPointF, arg__2: PySide2.QtCore.Qt.HitTestAccuracy) -> int: ...
    def pageCount(self) -> int: ...
    def requestUpdate(self): ...
    def setCursorWidth(self, width: int): ...


class QPlainTextEdit(PySide2.QtWidgets.QAbstractScrollArea):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, text: str, parent: PySide2.QtWidgets.QWidget = ...): ...
    def anchorAt(self, pos: PySide2.QtCore.QPoint) -> str: ...
    def appendHtml(self, html: str): ...
    def appendPlainText(self, text: str): ...
    def backgroundVisible(self) -> bool: ...
    def blockBoundingGeometry(self, block: PySide2.QtGui.QTextBlock) -> PySide2.QtCore.QRectF: ...
    def blockBoundingRect(self, block: PySide2.QtGui.QTextBlock) -> PySide2.QtCore.QRectF: ...
    def blockCount(self) -> int: ...
    def canInsertFromMimeData(self, source: PySide2.QtCore.QMimeData) -> bool: ...
    def canPaste(self) -> bool: ...
    def centerCursor(self): ...
    def centerOnScroll(self) -> bool: ...
    def changeEvent(self, e: PySide2.QtCore.QEvent): ...
    def clear(self): ...
    def contentOffset(self) -> PySide2.QtCore.QPointF: ...
    def contextMenuEvent(self, e: PySide2.QtGui.QContextMenuEvent): ...
    def copy(self): ...
    def createMimeDataFromSelection(self) -> PySide2.QtCore.QMimeData: ...
    @typing.overload
    def createStandardContextMenu(self) -> PySide2.QtWidgets.QMenu: ...
    @typing.overload
    def createStandardContextMenu(self, position: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QMenu: ...
    def currentCharFormat(self) -> PySide2.QtGui.QTextCharFormat: ...
    def cursorForPosition(self, pos: PySide2.QtCore.QPoint) -> PySide2.QtGui.QTextCursor: ...
    @typing.overload
    def cursorRect(self) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def cursorRect(self, cursor: PySide2.QtGui.QTextCursor) -> PySide2.QtCore.QRect: ...
    def cursorWidth(self) -> int: ...
    def cut(self): ...
    def doSetTextCursor(self, cursor: PySide2.QtGui.QTextCursor): ...
    def document(self) -> PySide2.QtGui.QTextDocument: ...
    def documentTitle(self) -> str: ...
    def dragEnterEvent(self, e: PySide2.QtGui.QDragEnterEvent): ...
    def dragLeaveEvent(self, e: PySide2.QtGui.QDragLeaveEvent): ...
    def dragMoveEvent(self, e: PySide2.QtGui.QDragMoveEvent): ...
    def dropEvent(self, e: PySide2.QtGui.QDropEvent): ...
    def ensureCursorVisible(self): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def extraSelections(self) -> typing.List[PySide2.QtWidgets.QTextEdit.ExtraSelection]: ...
    @typing.overload
    def find(self, exp: PySide2.QtCore.QRegExp, options: PySide2.QtGui.QTextDocument.FindFlags = ...) -> bool: ...
    @typing.overload
    def find(self, exp: str, options: PySide2.QtGui.QTextDocument.FindFlags = ...) -> bool: ...
    def firstVisibleBlock(self) -> PySide2.QtGui.QTextBlock: ...
    def focusInEvent(self, e: PySide2.QtGui.QFocusEvent): ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, e: PySide2.QtGui.QFocusEvent): ...
    def getPaintContext(self) -> PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext: ...
    def inputMethodEvent(self, arg__1: PySide2.QtGui.QInputMethodEvent): ...
    @typing.overload
    def inputMethodQuery(self, property: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    @typing.overload
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery, argument: typing.Any) -> typing.Any: ...
    def insertFromMimeData(self, source: PySide2.QtCore.QMimeData): ...
    def insertPlainText(self, text: str): ...
    def isReadOnly(self) -> bool: ...
    def isUndoRedoEnabled(self) -> bool: ...
    def keyPressEvent(self, e: PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, e: PySide2.QtGui.QKeyEvent): ...
    def lineWrapMode(self) -> PySide2.QtWidgets.QPlainTextEdit.LineWrapMode: ...
    def loadResource(self, type: int, name: PySide2.QtCore.QUrl) -> typing.Any: ...
    def maximumBlockCount(self) -> int: ...
    def mergeCurrentCharFormat(self, modifier: PySide2.QtGui.QTextCharFormat): ...
    def mouseDoubleClickEvent(self, e: PySide2.QtGui.QMouseEvent): ...
    def mouseMoveEvent(self, e: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, e: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, e: PySide2.QtGui.QMouseEvent): ...
    def moveCursor(self, operation: PySide2.QtGui.QTextCursor.MoveOperation, mode: PySide2.QtGui.QTextCursor.MoveMode = ...): ...
    def overwriteMode(self) -> bool: ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent): ...
    def paste(self): ...
    def placeholderText(self) -> str: ...
    def print_(self, printer: PySide2.QtGui.QPagedPaintDevice): ...
    def redo(self): ...
    def resizeEvent(self, e: PySide2.QtGui.QResizeEvent): ...
    def scrollContentsBy(self, dx: int, dy: int): ...
    def selectAll(self): ...
    def setBackgroundVisible(self, visible: bool): ...
    def setCenterOnScroll(self, enabled: bool): ...
    def setCurrentCharFormat(self, format: PySide2.QtGui.QTextCharFormat): ...
    def setCursorWidth(self, width: int): ...
    def setDocument(self, document: PySide2.QtGui.QTextDocument): ...
    def setDocumentTitle(self, title: str): ...
    def setExtraSelections(self, selections: typing.List[PySide2.QtWidgets.QTextEdit.ExtraSelection]): ...
    def setLineWrapMode(self, mode: PySide2.QtWidgets.QPlainTextEdit.LineWrapMode): ...
    def setMaximumBlockCount(self, maximum: int): ...
    def setOverwriteMode(self, overwrite: bool): ...
    def setPlaceholderText(self, placeholderText: str): ...
    def setPlainText(self, text: str): ...
    def setReadOnly(self, ro: bool): ...
    def setTabChangesFocus(self, b: bool): ...
    def setTabStopDistance(self, distance: float): ...
    def setTabStopWidth(self, width: int): ...
    def setTextCursor(self, cursor: PySide2.QtGui.QTextCursor): ...
    def setTextInteractionFlags(self, flags: PySide2.QtCore.Qt.TextInteractionFlags): ...
    def setUndoRedoEnabled(self, enable: bool): ...
    def setWordWrapMode(self, policy: PySide2.QtGui.QTextOption.WrapMode): ...
    def showEvent(self, arg__1: PySide2.QtGui.QShowEvent): ...
    def tabChangesFocus(self) -> bool: ...
    def tabStopDistance(self) -> float: ...
    def tabStopWidth(self) -> int: ...
    def textCursor(self) -> PySide2.QtGui.QTextCursor: ...
    def textInteractionFlags(self) -> PySide2.QtCore.Qt.TextInteractionFlags: ...
    def timerEvent(self, e: PySide2.QtCore.QTimerEvent): ...
    def toPlainText(self) -> str: ...
    def undo(self): ...
    def wheelEvent(self, e: PySide2.QtGui.QWheelEvent): ...
    def wordWrapMode(self) -> PySide2.QtGui.QTextOption.WrapMode: ...
    def zoomIn(self, range: int = ...): ...
    def zoomInF(self, range: float): ...
    def zoomOut(self, range: int = ...): ...


class QProgressBar(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def format(self) -> str: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionProgressBar): ...
    def invertedAppearance(self) -> bool: ...
    def isTextVisible(self) -> bool: ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent): ...
    def reset(self): ...
    def resetFormat(self): ...
    def setAlignment(self, alignment: PySide2.QtCore.Qt.Alignment): ...
    def setFormat(self, format: str): ...
    def setInvertedAppearance(self, invert: bool): ...
    def setMaximum(self, maximum: int): ...
    def setMinimum(self, minimum: int): ...
    def setOrientation(self, arg__1: PySide2.QtCore.Qt.Orientation): ...
    def setRange(self, minimum: int, maximum: int): ...
    def setTextDirection(self, textDirection: PySide2.QtWidgets.QProgressBar.Direction): ...
    def setTextVisible(self, visible: bool): ...
    def setValue(self, value: int): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def text(self) -> str: ...
    def textDirection(self) -> PySide2.QtWidgets.QProgressBar.Direction: ...
    def value(self) -> int: ...


class QProgressDialog(PySide2.QtWidgets.QDialog):

    @typing.overload
    def __init__(self, labelText: str, cancelButtonText: str, minimum: int, maximum: int, parent: PySide2.QtWidgets.QWidget = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...): ...
    def autoClose(self) -> bool: ...
    def autoReset(self) -> bool: ...
    def cancel(self): ...
    def changeEvent(self, event: PySide2.QtCore.QEvent): ...
    def closeEvent(self, event: PySide2.QtGui.QCloseEvent): ...
    def forceShow(self): ...
    def labelText(self) -> str: ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...
    def minimumDuration(self) -> int: ...
    @typing.overload
    def open(self): ...
    @typing.overload
    def open(self, receiver: PySide2.QtCore.QObject, member: str): ...
    def reset(self): ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent): ...
    def setAutoClose(self, close: bool): ...
    def setAutoReset(self, reset: bool): ...
    def setBar(self, bar: PySide2.QtWidgets.QProgressBar): ...
    def setCancelButton(self, button: PySide2.QtWidgets.QPushButton): ...
    def setCancelButtonText(self, text: str): ...
    def setLabel(self, label: PySide2.QtWidgets.QLabel): ...
    def setLabelText(self, text: str): ...
    def setMaximum(self, maximum: int): ...
    def setMinimum(self, minimum: int): ...
    def setMinimumDuration(self, ms: int): ...
    def setRange(self, minimum: int, maximum: int): ...
    def setValue(self, progress: int): ...
    def showEvent(self, event: PySide2.QtGui.QShowEvent): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def value(self) -> int: ...
    def wasCanceled(self) -> bool: ...


class QProxyStyle(PySide2.QtWidgets.QCommonStyle):

    @typing.overload
    def __init__(self, key: str): ...
    @typing.overload
    def __init__(self, style: PySide2.QtWidgets.QStyle = ...): ...
    def baseStyle(self) -> PySide2.QtWidgets.QStyle: ...
    def drawComplexControl(self, control: PySide2.QtWidgets.QStyle.ComplexControl, option: PySide2.QtWidgets.QStyleOptionComplex, painter: PySide2.QtGui.QPainter, widget: PySide2.QtWidgets.QWidget = ...): ...
    def drawControl(self, element: PySide2.QtWidgets.QStyle.ControlElement, option: PySide2.QtWidgets.QStyleOption, painter: PySide2.QtGui.QPainter, widget: PySide2.QtWidgets.QWidget = ...): ...
    def drawItemPixmap(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRect, alignment: int, pixmap: PySide2.QtGui.QPixmap): ...
    def drawItemText(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRect, flags: int, pal: PySide2.QtGui.QPalette, enabled: bool, text: str, textRole: PySide2.QtGui.QPalette.ColorRole = ...): ...
    def drawPrimitive(self, element: PySide2.QtWidgets.QStyle.PrimitiveElement, option: PySide2.QtWidgets.QStyleOption, painter: PySide2.QtGui.QPainter, widget: PySide2.QtWidgets.QWidget = ...): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def generatedIconPixmap(self, iconMode: PySide2.QtGui.QIcon.Mode, pixmap: PySide2.QtGui.QPixmap, opt: PySide2.QtWidgets.QStyleOption) -> PySide2.QtGui.QPixmap: ...
    def hitTestComplexControl(self, control: PySide2.QtWidgets.QStyle.ComplexControl, option: PySide2.QtWidgets.QStyleOptionComplex, pos: PySide2.QtCore.QPoint, widget: PySide2.QtWidgets.QWidget = ...) -> PySide2.QtWidgets.QStyle.SubControl: ...
    def itemPixmapRect(self, r: PySide2.QtCore.QRect, flags: int, pixmap: PySide2.QtGui.QPixmap) -> PySide2.QtCore.QRect: ...
    def itemTextRect(self, fm: PySide2.QtGui.QFontMetrics, r: PySide2.QtCore.QRect, flags: int, enabled: bool, text: str) -> PySide2.QtCore.QRect: ...
    def layoutSpacing(self, control1: PySide2.QtWidgets.QSizePolicy.ControlType, control2: PySide2.QtWidgets.QSizePolicy.ControlType, orientation: PySide2.QtCore.Qt.Orientation, option: PySide2.QtWidgets.QStyleOption = ..., widget: PySide2.QtWidgets.QWidget = ...) -> int: ...
    def pixelMetric(self, metric: PySide2.QtWidgets.QStyle.PixelMetric, option: PySide2.QtWidgets.QStyleOption = ..., widget: PySide2.QtWidgets.QWidget = ...) -> int: ...
    @typing.overload
    def polish(self, app: PySide2.QtWidgets.QApplication): ...
    @typing.overload
    def polish(self, pal: PySide2.QtGui.QPalette): ...
    @typing.overload
    def polish(self, widget: PySide2.QtWidgets.QWidget): ...
    def setBaseStyle(self, style: PySide2.QtWidgets.QStyle): ...
    def sizeFromContents(self, type: PySide2.QtWidgets.QStyle.ContentsType, option: PySide2.QtWidgets.QStyleOption, size: PySide2.QtCore.QSize, widget: PySide2.QtWidgets.QWidget) -> PySide2.QtCore.QSize: ...
    def standardIcon(self, standardIcon: PySide2.QtWidgets.QStyle.StandardPixmap, option: PySide2.QtWidgets.QStyleOption = ..., widget: PySide2.QtWidgets.QWidget = ...) -> PySide2.QtGui.QIcon: ...
    def standardPalette(self) -> PySide2.QtGui.QPalette: ...
    def standardPixmap(self, standardPixmap: PySide2.QtWidgets.QStyle.StandardPixmap, opt: PySide2.QtWidgets.QStyleOption, widget: PySide2.QtWidgets.QWidget = ...) -> PySide2.QtGui.QPixmap: ...
    def styleHint(self, hint: PySide2.QtWidgets.QStyle.StyleHint, option: PySide2.QtWidgets.QStyleOption = ..., widget: PySide2.QtWidgets.QWidget = ..., returnData: PySide2.QtWidgets.QStyleHintReturn = ...) -> int: ...
    def subControlRect(self, cc: PySide2.QtWidgets.QStyle.ComplexControl, opt: PySide2.QtWidgets.QStyleOptionComplex, sc: PySide2.QtWidgets.QStyle.SubControl, widget: PySide2.QtWidgets.QWidget) -> PySide2.QtCore.QRect: ...
    def subElementRect(self, element: PySide2.QtWidgets.QStyle.SubElement, option: PySide2.QtWidgets.QStyleOption, widget: PySide2.QtWidgets.QWidget) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def unpolish(self, app: PySide2.QtWidgets.QApplication): ...
    @typing.overload
    def unpolish(self, application: PySide2.QtWidgets.QApplication): ...
    @typing.overload
    def unpolish(self, widget: PySide2.QtWidgets.QWidget): ...


class QPushButton(PySide2.QtWidgets.QAbstractButton):

    @typing.overload
    def __init__(self, icon: PySide2.QtGui.QIcon, text: str, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, text: str, parent: PySide2.QtWidgets.QWidget = ...): ...
    def autoDefault(self) -> bool: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, arg__1: PySide2.QtGui.QFocusEvent): ...
    def focusOutEvent(self, arg__1: PySide2.QtGui.QFocusEvent): ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionButton): ...
    def isDefault(self) -> bool: ...
    def isFlat(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent): ...
    def menu(self) -> PySide2.QtWidgets.QMenu: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent): ...
    def setAutoDefault(self, arg__1: bool): ...
    def setDefault(self, arg__1: bool): ...
    def setFlat(self, arg__1: bool): ...
    def setMenu(self, menu: PySide2.QtWidgets.QMenu): ...
    def showMenu(self): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...


class QRadioButton(PySide2.QtWidgets.QAbstractButton):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, text: str, parent: PySide2.QtWidgets.QWidget = ...): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def hitButton(self, arg__1: PySide2.QtCore.QPoint) -> bool: ...
    def initStyleOption(self, button: PySide2.QtWidgets.QStyleOptionButton): ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...


class QRubberBand(PySide2.QtWidgets.QWidget):

    def __init__(self, arg__1: PySide2.QtWidgets.QRubberBand.Shape, parent: PySide2.QtWidgets.QWidget = ...): ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionRubberBand): ...
    @typing.overload
    def move(self, p: PySide2.QtCore.QPoint): ...
    @typing.overload
    def move(self, x: int, y: int): ...
    def moveEvent(self, arg__1: PySide2.QtGui.QMoveEvent): ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent): ...
    @typing.overload
    def resize(self, s: PySide2.QtCore.QSize): ...
    @typing.overload
    def resize(self, w: int, h: int): ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent): ...
    @typing.overload
    def setGeometry(self, r: PySide2.QtCore.QRect): ...
    @typing.overload
    def setGeometry(self, x: int, y: int, w: int, h: int): ...
    def shape(self) -> PySide2.QtWidgets.QRubberBand.Shape: ...
    def showEvent(self, arg__1: PySide2.QtGui.QShowEvent): ...


class QScrollArea(PySide2.QtWidgets.QAbstractScrollArea):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def ensureVisible(self, x: int, y: int, xmargin: int = ..., ymargin: int = ...): ...
    def ensureWidgetVisible(self, childWidget: PySide2.QtWidgets.QWidget, xmargin: int = ..., ymargin: int = ...): ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent): ...
    def scrollContentsBy(self, dx: int, dy: int): ...
    def setAlignment(self, arg__1: PySide2.QtCore.Qt.Alignment): ...
    def setWidget(self, widget: PySide2.QtWidgets.QWidget): ...
    def setWidgetResizable(self, resizable: bool): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def takeWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def viewportSizeHint(self) -> PySide2.QtCore.QSize: ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...
    def widgetResizable(self) -> bool: ...


class QScrollBar(PySide2.QtWidgets.QAbstractSlider):

    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.Qt.Orientation, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def contextMenuEvent(self, arg__1: PySide2.QtGui.QContextMenuEvent): ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def hideEvent(self, arg__1: PySide2.QtGui.QHideEvent): ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionSlider): ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sliderChange(self, change: PySide2.QtWidgets.QAbstractSlider.SliderChange): ...
    def wheelEvent(self, arg__1: PySide2.QtGui.QWheelEvent): ...


class QScroller(PySide2.QtCore.QObject):

    @staticmethod
    def activeScrollers() -> typing.List[PySide2.QtWidgets.QScroller]: ...
    @typing.overload
    def ensureVisible(self, rect: PySide2.QtCore.QRectF, xmargin: float, ymargin: float): ...
    @typing.overload
    def ensureVisible(self, rect: PySide2.QtCore.QRectF, xmargin: float, ymargin: float, scrollTime: int): ...
    def finalPosition(self) -> PySide2.QtCore.QPointF: ...
    @staticmethod
    def grabGesture(target: PySide2.QtCore.QObject, gestureType: PySide2.QtWidgets.QScroller.ScrollerGestureType = ...) -> PySide2.QtCore.Qt.GestureType: ...
    @staticmethod
    def grabbedGesture(target: PySide2.QtCore.QObject) -> PySide2.QtCore.Qt.GestureType: ...
    def handleInput(self, input: PySide2.QtWidgets.QScroller.Input, position: PySide2.QtCore.QPointF, timestamp: int = ...) -> bool: ...
    @staticmethod
    def hasScroller(target: PySide2.QtCore.QObject) -> bool: ...
    def pixelPerMeter(self) -> PySide2.QtCore.QPointF: ...
    def resendPrepareEvent(self): ...
    @typing.overload
    def scrollTo(self, pos: PySide2.QtCore.QPointF): ...
    @typing.overload
    def scrollTo(self, pos: PySide2.QtCore.QPointF, scrollTime: int): ...
    @staticmethod
    def scroller(target: PySide2.QtCore.QObject) -> PySide2.QtWidgets.QScroller: ...
    def scrollerProperties(self) -> PySide2.QtWidgets.QScrollerProperties: ...
    def setScrollerProperties(self, prop: PySide2.QtWidgets.QScrollerProperties): ...
    @typing.overload
    def setSnapPositionsX(self, first: float, interval: float): ...
    @typing.overload
    def setSnapPositionsX(self, positions: typing.List[float]): ...
    @typing.overload
    def setSnapPositionsY(self, first: float, interval: float): ...
    @typing.overload
    def setSnapPositionsY(self, positions: typing.List[float]): ...
    def state(self) -> PySide2.QtWidgets.QScroller.State: ...
    def stop(self): ...
    def target(self) -> PySide2.QtCore.QObject: ...
    @staticmethod
    def ungrabGesture(target: PySide2.QtCore.QObject): ...
    def velocity(self) -> PySide2.QtCore.QPointF: ...


class QScrollerProperties(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, sp: PySide2.QtWidgets.QScrollerProperties): ...
    def __copy__(self): ...
    def scrollMetric(self, metric: PySide2.QtWidgets.QScrollerProperties.ScrollMetric) -> typing.Any: ...
    @staticmethod
    def setDefaultScrollerProperties(sp: PySide2.QtWidgets.QScrollerProperties): ...
    def setScrollMetric(self, metric: PySide2.QtWidgets.QScrollerProperties.ScrollMetric, value: typing.Any): ...
    @staticmethod
    def unsetDefaultScrollerProperties(): ...


class QShortcut(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QKeySequence, arg__2: PySide2.QtWidgets.QWidget, arg__3: typing.Callable, arg__4: PySide2.QtCore.Qt.ShortcutContext = ...): ...
    @typing.overload
    def __init__(self, key: PySide2.QtGui.QKeySequence, parent: PySide2.QtWidgets.QWidget, member: str = ..., ambiguousMember: str = ..., context: PySide2.QtCore.Qt.ShortcutContext = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget): ...
    def autoRepeat(self) -> bool: ...
    def context(self) -> PySide2.QtCore.Qt.ShortcutContext: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def id(self) -> int: ...
    def isEnabled(self) -> bool: ...
    def key(self) -> PySide2.QtGui.QKeySequence: ...
    def parentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def setAutoRepeat(self, on: bool): ...
    def setContext(self, context: PySide2.QtCore.Qt.ShortcutContext): ...
    def setEnabled(self, enable: bool): ...
    def setKey(self, key: PySide2.QtGui.QKeySequence): ...
    def setWhatsThis(self, text: str): ...
    def whatsThis(self) -> str: ...


class QSizeGrip(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: PySide2.QtWidgets.QWidget): ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    def hideEvent(self, hideEvent: PySide2.QtGui.QHideEvent): ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, mouseEvent: PySide2.QtGui.QMouseEvent): ...
    def moveEvent(self, moveEvent: PySide2.QtGui.QMoveEvent): ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent): ...
    def setVisible(self, arg__1: bool): ...
    def showEvent(self, showEvent: PySide2.QtGui.QShowEvent): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...


class QSizePolicy(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, horizontal: PySide2.QtWidgets.QSizePolicy.Policy, vertical: PySide2.QtWidgets.QSizePolicy.Policy, type: PySide2.QtWidgets.QSizePolicy.ControlType = ...): ...
    def __copy__(self): ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def controlType(self) -> PySide2.QtWidgets.QSizePolicy.ControlType: ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def hasHeightForWidth(self) -> bool: ...
    def hasWidthForHeight(self) -> bool: ...
    def horizontalPolicy(self) -> PySide2.QtWidgets.QSizePolicy.Policy: ...
    def horizontalStretch(self) -> int: ...
    def retainSizeWhenHidden(self) -> bool: ...
    def setControlType(self, type: PySide2.QtWidgets.QSizePolicy.ControlType): ...
    def setHeightForWidth(self, b: bool): ...
    def setHorizontalPolicy(self, d: PySide2.QtWidgets.QSizePolicy.Policy): ...
    def setHorizontalStretch(self, stretchFactor: int): ...
    def setRetainSizeWhenHidden(self, retainSize: bool): ...
    def setVerticalPolicy(self, d: PySide2.QtWidgets.QSizePolicy.Policy): ...
    def setVerticalStretch(self, stretchFactor: int): ...
    def setWidthForHeight(self, b: bool): ...
    def transpose(self): ...
    def transposed(self) -> PySide2.QtWidgets.QSizePolicy: ...
    def verticalPolicy(self) -> PySide2.QtWidgets.QSizePolicy.Policy: ...
    def verticalStretch(self) -> int: ...


class QSlider(PySide2.QtWidgets.QAbstractSlider):

    @typing.overload
    def __init__(self, orientation: PySide2.QtCore.Qt.Orientation, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionSlider): ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, ev: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, ev: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, ev: PySide2.QtGui.QMouseEvent): ...
    def paintEvent(self, ev: PySide2.QtGui.QPaintEvent): ...
    def setTickInterval(self, ti: int): ...
    def setTickPosition(self, position: PySide2.QtWidgets.QSlider.TickPosition): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def tickInterval(self) -> int: ...
    def tickPosition(self) -> PySide2.QtWidgets.QSlider.TickPosition: ...


class QSpacerItem(PySide2.QtWidgets.QLayoutItem):

    def __init__(self, w: int, h: int, hData: PySide2.QtWidgets.QSizePolicy.Policy = ..., vData: PySide2.QtWidgets.QSizePolicy.Policy = ...): ...
    def changeSize(self, w: int, h: int, hData: PySide2.QtWidgets.QSizePolicy.Policy = ..., vData: PySide2.QtWidgets.QSizePolicy.Policy = ...): ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def isEmpty(self) -> bool: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def setGeometry(self, arg__1: PySide2.QtCore.QRect): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sizePolicy(self) -> PySide2.QtWidgets.QSizePolicy: ...
    def spacerItem(self) -> PySide2.QtWidgets.QSpacerItem: ...


class QSpinBox(PySide2.QtWidgets.QAbstractSpinBox):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def cleanText(self) -> str: ...
    def displayIntegerBase(self) -> int: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def fixup(self, str: str): ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...
    def prefix(self) -> str: ...
    def setDisplayIntegerBase(self, base: int): ...
    def setMaximum(self, max: int): ...
    def setMinimum(self, min: int): ...
    def setPrefix(self, prefix: str): ...
    def setRange(self, min: int, max: int): ...
    def setSingleStep(self, val: int): ...
    def setStepType(self, stepType: PySide2.QtWidgets.QAbstractSpinBox.StepType): ...
    def setSuffix(self, suffix: str): ...
    def setValue(self, val: int): ...
    def singleStep(self) -> int: ...
    def stepType(self) -> PySide2.QtWidgets.QAbstractSpinBox.StepType: ...
    def suffix(self) -> str: ...
    def textFromValue(self, val: int) -> str: ...
    def validate(self, input: str, pos: int) -> PySide2.QtGui.QValidator.State: ...
    def value(self) -> int: ...
    def valueFromText(self, text: str) -> int: ...


class QSplashScreen(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget, pixmap: PySide2.QtGui.QPixmap = ..., f: PySide2.QtCore.Qt.WindowFlags = ...): ...
    @typing.overload
    def __init__(self, pixmap: PySide2.QtGui.QPixmap = ..., f: PySide2.QtCore.Qt.WindowFlags = ...): ...
    def clearMessage(self): ...
    def drawContents(self, painter: PySide2.QtGui.QPainter): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def finish(self, w: PySide2.QtWidgets.QWidget): ...
    def message(self) -> str: ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def pixmap(self) -> PySide2.QtGui.QPixmap: ...
    def setPixmap(self, pixmap: PySide2.QtGui.QPixmap): ...
    def showMessage(self, message: str, alignment: int = ..., color: PySide2.QtGui.QColor = ...): ...


class QSplitter(PySide2.QtWidgets.QFrame):

    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.Qt.Orientation, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def __lshift__(self, arg__1: PySide2.QtCore.QTextStream) -> PySide2.QtCore.QTextStream: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QTextStream) -> PySide2.QtCore.QTextStream: ...
    def addWidget(self, widget: PySide2.QtWidgets.QWidget): ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent): ...
    def childEvent(self, arg__1: PySide2.QtCore.QChildEvent): ...
    def childrenCollapsible(self) -> bool: ...
    def closestLegalPosition(self, arg__1: int, arg__2: int) -> int: ...
    def count(self) -> int: ...
    def createHandle(self) -> PySide2.QtWidgets.QSplitterHandle: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def getRange(self, index: int, arg__2: int, arg__3: int): ...
    def handle(self, index: int) -> PySide2.QtWidgets.QSplitterHandle: ...
    def handleWidth(self) -> int: ...
    def indexOf(self, w: PySide2.QtWidgets.QWidget) -> int: ...
    def insertWidget(self, index: int, widget: PySide2.QtWidgets.QWidget): ...
    def isCollapsible(self, index: int) -> bool: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def moveSplitter(self, pos: int, index: int): ...
    def opaqueResize(self) -> bool: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def refresh(self): ...
    def replaceWidget(self, index: int, widget: PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QWidget: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent): ...
    def restoreState(self, state: PySide2.QtCore.QByteArray) -> bool: ...
    def saveState(self) -> PySide2.QtCore.QByteArray: ...
    def setChildrenCollapsible(self, arg__1: bool): ...
    def setCollapsible(self, index: int, arg__2: bool): ...
    def setHandleWidth(self, arg__1: int): ...
    def setOpaqueResize(self, opaque: bool = ...): ...
    def setOrientation(self, arg__1: PySide2.QtCore.Qt.Orientation): ...
    def setRubberBand(self, position: int): ...
    def setSizes(self, list: typing.List[int]): ...
    def setStretchFactor(self, index: int, stretch: int): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sizes(self) -> typing.List[int]: ...
    def widget(self, index: int) -> PySide2.QtWidgets.QWidget: ...


class QSplitterHandle(PySide2.QtWidgets.QWidget):

    def __init__(self, o: PySide2.QtCore.Qt.Orientation, parent: PySide2.QtWidgets.QSplitter): ...
    def closestLegalPosition(self, p: int) -> int: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def moveSplitter(self, p: int): ...
    def opaqueResize(self) -> bool: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent): ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent): ...
    def setOrientation(self, o: PySide2.QtCore.Qt.Orientation): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def splitter(self) -> PySide2.QtWidgets.QSplitter: ...


class QStackedLayout(PySide2.QtWidgets.QLayout):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget): ...
    @typing.overload
    def __init__(self, parentLayout: PySide2.QtWidgets.QLayout): ...
    def addItem(self, item: PySide2.QtWidgets.QLayoutItem): ...
    def addWidget(self, w: PySide2.QtWidgets.QWidget) -> int: ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def currentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, width: int) -> int: ...
    def insertWidget(self, index: int, w: PySide2.QtWidgets.QWidget) -> int: ...
    def itemAt(self, arg__1: int) -> PySide2.QtWidgets.QLayoutItem: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def setCurrentIndex(self, index: int): ...
    def setCurrentWidget(self, w: PySide2.QtWidgets.QWidget): ...
    def setGeometry(self, rect: PySide2.QtCore.QRect): ...
    def setStackingMode(self, stackingMode: PySide2.QtWidgets.QStackedLayout.StackingMode): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def stackingMode(self) -> PySide2.QtWidgets.QStackedLayout.StackingMode: ...
    def takeAt(self, arg__1: int) -> PySide2.QtWidgets.QLayoutItem: ...
    @typing.overload
    def widget(self) -> PySide2.QtWidgets.QWidget: ...
    @typing.overload
    def widget(self, arg__1: int) -> PySide2.QtWidgets.QWidget: ...


class QStackedWidget(PySide2.QtWidgets.QFrame):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def addWidget(self, w: PySide2.QtWidgets.QWidget) -> int: ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def currentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def indexOf(self, arg__1: PySide2.QtWidgets.QWidget) -> int: ...
    def insertWidget(self, index: int, w: PySide2.QtWidgets.QWidget) -> int: ...
    def removeWidget(self, w: PySide2.QtWidgets.QWidget): ...
    def setCurrentIndex(self, index: int): ...
    def setCurrentWidget(self, w: PySide2.QtWidgets.QWidget): ...
    def widget(self, arg__1: int) -> PySide2.QtWidgets.QWidget: ...


class QStatusBar(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def addPermanentWidget(self, widget: PySide2.QtWidgets.QWidget, stretch: int = ...): ...
    def addWidget(self, widget: PySide2.QtWidgets.QWidget, stretch: int = ...): ...
    def clearMessage(self): ...
    def currentMessage(self) -> str: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def hideOrShow(self): ...
    def insertPermanentWidget(self, index: int, widget: PySide2.QtWidgets.QWidget, stretch: int = ...) -> int: ...
    def insertWidget(self, index: int, widget: PySide2.QtWidgets.QWidget, stretch: int = ...) -> int: ...
    def isSizeGripEnabled(self) -> bool: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent): ...
    def reformat(self): ...
    def removeWidget(self, widget: PySide2.QtWidgets.QWidget): ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent): ...
    def setSizeGripEnabled(self, arg__1: bool): ...
    def showEvent(self, arg__1: PySide2.QtGui.QShowEvent): ...
    def showMessage(self, text: str, timeout: int = ...): ...


class QStyle(PySide2.QtCore.QObject):

    def __init__(self): ...
    @staticmethod
    def alignedRect(direction: PySide2.QtCore.Qt.LayoutDirection, alignment: PySide2.QtCore.Qt.Alignment, size: PySide2.QtCore.QSize, rectangle: PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    def combinedLayoutSpacing(self, controls1: PySide2.QtWidgets.QSizePolicy.ControlTypes, controls2: PySide2.QtWidgets.QSizePolicy.ControlTypes, orientation: PySide2.QtCore.Qt.Orientation, option: PySide2.QtWidgets.QStyleOption = ..., widget: PySide2.QtWidgets.QWidget = ...) -> int: ...
    def drawComplexControl(self, cc: PySide2.QtWidgets.QStyle.ComplexControl, opt: PySide2.QtWidgets.QStyleOptionComplex, p: PySide2.QtGui.QPainter, widget: PySide2.QtWidgets.QWidget = ...): ...
    def drawControl(self, element: PySide2.QtWidgets.QStyle.ControlElement, opt: PySide2.QtWidgets.QStyleOption, p: PySide2.QtGui.QPainter, widget: PySide2.QtWidgets.QWidget = ...): ...
    def drawItemPixmap(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRect, alignment: int, pixmap: PySide2.QtGui.QPixmap): ...
    def drawItemText(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRect, flags: int, pal: PySide2.QtGui.QPalette, enabled: bool, text: str, textRole: PySide2.QtGui.QPalette.ColorRole = ...): ...
    def drawPrimitive(self, pe: PySide2.QtWidgets.QStyle.PrimitiveElement, opt: PySide2.QtWidgets.QStyleOption, p: PySide2.QtGui.QPainter, widget: PySide2.QtWidgets.QWidget = ...): ...
    def generatedIconPixmap(self, iconMode: PySide2.QtGui.QIcon.Mode, pixmap: PySide2.QtGui.QPixmap, opt: PySide2.QtWidgets.QStyleOption) -> PySide2.QtGui.QPixmap: ...
    def hitTestComplexControl(self, cc: PySide2.QtWidgets.QStyle.ComplexControl, opt: PySide2.QtWidgets.QStyleOptionComplex, pt: PySide2.QtCore.QPoint, widget: PySide2.QtWidgets.QWidget = ...) -> PySide2.QtWidgets.QStyle.SubControl: ...
    def itemPixmapRect(self, r: PySide2.QtCore.QRect, flags: int, pixmap: PySide2.QtGui.QPixmap) -> PySide2.QtCore.QRect: ...
    def itemTextRect(self, fm: PySide2.QtGui.QFontMetrics, r: PySide2.QtCore.QRect, flags: int, enabled: bool, text: str) -> PySide2.QtCore.QRect: ...
    def layoutSpacing(self, control1: PySide2.QtWidgets.QSizePolicy.ControlType, control2: PySide2.QtWidgets.QSizePolicy.ControlType, orientation: PySide2.QtCore.Qt.Orientation, option: PySide2.QtWidgets.QStyleOption = ..., widget: PySide2.QtWidgets.QWidget = ...) -> int: ...
    def pixelMetric(self, metric: PySide2.QtWidgets.QStyle.PixelMetric, option: PySide2.QtWidgets.QStyleOption = ..., widget: PySide2.QtWidgets.QWidget = ...) -> int: ...
    @typing.overload
    def polish(self, application: PySide2.QtWidgets.QApplication): ...
    @typing.overload
    def polish(self, palette: PySide2.QtGui.QPalette): ...
    @typing.overload
    def polish(self, widget: PySide2.QtWidgets.QWidget): ...
    def proxy(self) -> PySide2.QtWidgets.QStyle: ...
    def sizeFromContents(self, ct: PySide2.QtWidgets.QStyle.ContentsType, opt: PySide2.QtWidgets.QStyleOption, contentsSize: PySide2.QtCore.QSize, w: PySide2.QtWidgets.QWidget = ...) -> PySide2.QtCore.QSize: ...
    @staticmethod
    def sliderPositionFromValue(min: int, max: int, val: int, space: int, upsideDown: bool = ...) -> int: ...
    @staticmethod
    def sliderValueFromPosition(min: int, max: int, pos: int, space: int, upsideDown: bool = ...) -> int: ...
    def standardIcon(self, standardIcon: PySide2.QtWidgets.QStyle.StandardPixmap, option: PySide2.QtWidgets.QStyleOption = ..., widget: PySide2.QtWidgets.QWidget = ...) -> PySide2.QtGui.QIcon: ...
    def standardPalette(self) -> PySide2.QtGui.QPalette: ...
    def standardPixmap(self, standardPixmap: PySide2.QtWidgets.QStyle.StandardPixmap, opt: PySide2.QtWidgets.QStyleOption = ..., widget: PySide2.QtWidgets.QWidget = ...) -> PySide2.QtGui.QPixmap: ...
    def styleHint(self, stylehint: PySide2.QtWidgets.QStyle.StyleHint, opt: PySide2.QtWidgets.QStyleOption = ..., widget: PySide2.QtWidgets.QWidget = ..., returnData: PySide2.QtWidgets.QStyleHintReturn = ...) -> int: ...
    def subControlRect(self, cc: PySide2.QtWidgets.QStyle.ComplexControl, opt: PySide2.QtWidgets.QStyleOptionComplex, sc: PySide2.QtWidgets.QStyle.SubControl, widget: PySide2.QtWidgets.QWidget = ...) -> PySide2.QtCore.QRect: ...
    def subElementRect(self, subElement: PySide2.QtWidgets.QStyle.SubElement, option: PySide2.QtWidgets.QStyleOption, widget: PySide2.QtWidgets.QWidget = ...) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def unpolish(self, application: PySide2.QtWidgets.QApplication): ...
    @typing.overload
    def unpolish(self, widget: PySide2.QtWidgets.QWidget): ...
    @staticmethod
    def visualAlignment(direction: PySide2.QtCore.Qt.LayoutDirection, alignment: PySide2.QtCore.Qt.Alignment) -> PySide2.QtCore.Qt.Alignment: ...
    @staticmethod
    def visualPos(direction: PySide2.QtCore.Qt.LayoutDirection, boundingRect: PySide2.QtCore.QRect, logicalPos: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @staticmethod
    def visualRect(direction: PySide2.QtCore.Qt.LayoutDirection, boundingRect: PySide2.QtCore.QRect, logicalRect: PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...


class QStyleFactory(Shiboken.Object):

    def __init__(self): ...
    @staticmethod
    def create(arg__1: str) -> PySide2.QtWidgets.QStyle: ...
    @staticmethod
    def keys() -> typing.List[str]: ...


class QStyleHintReturn(Shiboken.Object):

    def __init__(self, version: int = ..., type: int = ...): ...


class QStyleHintReturnMask(PySide2.QtWidgets.QStyleHintReturn):

    def __init__(self): ...


class QStyleHintReturnVariant(PySide2.QtWidgets.QStyleHintReturn):

    def __init__(self): ...


class QStyleOption(Shiboken.Object):

    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOption): ...
    @typing.overload
    def __init__(self, version: int = ..., type: int = ...): ...
    def init(self, w: PySide2.QtWidgets.QWidget): ...
    def initFrom(self, w: PySide2.QtWidgets.QWidget): ...


class QStyleOptionButton(PySide2.QtWidgets.QStyleOption):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionButton): ...
    @typing.overload
    def __init__(self, version: int): ...


class QStyleOptionComboBox(PySide2.QtWidgets.QStyleOptionComplex):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionComboBox): ...
    @typing.overload
    def __init__(self, version: int): ...


class QStyleOptionComplex(PySide2.QtWidgets.QStyleOption):

    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionComplex): ...
    @typing.overload
    def __init__(self, version: int = ..., type: int = ...): ...


class QStyleOptionDockWidget(PySide2.QtWidgets.QStyleOption):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionDockWidget): ...
    @typing.overload
    def __init__(self, version: int): ...


class QStyleOptionFocusRect(PySide2.QtWidgets.QStyleOption):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionFocusRect): ...
    @typing.overload
    def __init__(self, version: int): ...


class QStyleOptionFrame(PySide2.QtWidgets.QStyleOption):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionFrame): ...
    @typing.overload
    def __init__(self, version: int): ...


class QStyleOptionGraphicsItem(PySide2.QtWidgets.QStyleOption):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionGraphicsItem): ...
    @typing.overload
    def __init__(self, version: int): ...
    @staticmethod
    def levelOfDetailFromTransform(worldTransform: PySide2.QtGui.QTransform) -> float: ...


class QStyleOptionGroupBox(PySide2.QtWidgets.QStyleOptionComplex):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionGroupBox): ...
    @typing.overload
    def __init__(self, version: int): ...


class QStyleOptionHeader(PySide2.QtWidgets.QStyleOption):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionHeader): ...
    @typing.overload
    def __init__(self, version: int): ...


class QStyleOptionMenuItem(PySide2.QtWidgets.QStyleOption):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionMenuItem): ...
    @typing.overload
    def __init__(self, version: int): ...


class QStyleOptionProgressBar(PySide2.QtWidgets.QStyleOption):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionProgressBar): ...
    @typing.overload
    def __init__(self, version: int): ...


class QStyleOptionRubberBand(PySide2.QtWidgets.QStyleOption):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionRubberBand): ...
    @typing.overload
    def __init__(self, version: int): ...


class QStyleOptionSizeGrip(PySide2.QtWidgets.QStyleOptionComplex):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionSizeGrip): ...
    @typing.overload
    def __init__(self, version: int): ...


class QStyleOptionSlider(PySide2.QtWidgets.QStyleOptionComplex):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionSlider): ...
    @typing.overload
    def __init__(self, version: int): ...


class QStyleOptionSpinBox(PySide2.QtWidgets.QStyleOptionComplex):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionSpinBox): ...
    @typing.overload
    def __init__(self, version: int): ...


class QStyleOptionTab(PySide2.QtWidgets.QStyleOption):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionTab): ...
    @typing.overload
    def __init__(self, version: int): ...


class QStyleOptionTabBarBase(PySide2.QtWidgets.QStyleOption):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionTabBarBase): ...
    @typing.overload
    def __init__(self, version: int): ...


class QStyleOptionTabWidgetFrame(PySide2.QtWidgets.QStyleOption):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionTabWidgetFrame): ...
    @typing.overload
    def __init__(self, version: int): ...


class QStyleOptionTitleBar(PySide2.QtWidgets.QStyleOptionComplex):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionTitleBar): ...
    @typing.overload
    def __init__(self, version: int): ...


class QStyleOptionToolBar(PySide2.QtWidgets.QStyleOption):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionToolBar): ...
    @typing.overload
    def __init__(self, version: int): ...


class QStyleOptionToolBox(PySide2.QtWidgets.QStyleOption):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionToolBox): ...
    @typing.overload
    def __init__(self, version: int): ...


class QStyleOptionToolButton(PySide2.QtWidgets.QStyleOptionComplex):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionToolButton): ...
    @typing.overload
    def __init__(self, version: int): ...


class QStyleOptionViewItem(PySide2.QtWidgets.QStyleOption):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionViewItem): ...
    @typing.overload
    def __init__(self, version: int): ...
    def __copy__(self): ...


class QStylePainter(PySide2.QtGui.QPainter):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, pd: PySide2.QtGui.QPaintDevice, w: PySide2.QtWidgets.QWidget): ...
    @typing.overload
    def __init__(self, w: PySide2.QtWidgets.QWidget): ...
    @typing.overload
    def begin(self, arg__1: PySide2.QtGui.QPaintDevice) -> bool: ...
    @typing.overload
    def begin(self, pd: PySide2.QtGui.QPaintDevice, w: PySide2.QtWidgets.QWidget) -> bool: ...
    @typing.overload
    def begin(self, w: PySide2.QtWidgets.QWidget) -> bool: ...
    def drawComplexControl(self, cc: PySide2.QtWidgets.QStyle.ComplexControl, opt: PySide2.QtWidgets.QStyleOptionComplex): ...
    def drawControl(self, ce: PySide2.QtWidgets.QStyle.ControlElement, opt: PySide2.QtWidgets.QStyleOption): ...
    def drawItemPixmap(self, r: PySide2.QtCore.QRect, flags: int, pixmap: PySide2.QtGui.QPixmap): ...
    def drawItemText(self, r: PySide2.QtCore.QRect, flags: int, pal: PySide2.QtGui.QPalette, enabled: bool, text: str, textRole: PySide2.QtGui.QPalette.ColorRole = ...): ...
    def drawPrimitive(self, pe: PySide2.QtWidgets.QStyle.PrimitiveElement, opt: PySide2.QtWidgets.QStyleOption): ...
    def style(self) -> PySide2.QtWidgets.QStyle: ...


class QStyledItemDelegate(PySide2.QtWidgets.QAbstractItemDelegate):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def createEditor(self, parent: PySide2.QtWidgets.QWidget, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QWidget: ...
    def displayText(self, value: typing.Any, locale: PySide2.QtCore.QLocale) -> str: ...
    def editorEvent(self, event: PySide2.QtCore.QEvent, model: PySide2.QtCore.QAbstractItemModel, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def eventFilter(self, object: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex): ...
    def itemEditorFactory(self) -> PySide2.QtWidgets.QItemEditorFactory: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex): ...
    def setEditorData(self, editor: PySide2.QtWidgets.QWidget, index: PySide2.QtCore.QModelIndex): ...
    def setItemEditorFactory(self, factory: PySide2.QtWidgets.QItemEditorFactory): ...
    def setModelData(self, editor: PySide2.QtWidgets.QWidget, model: PySide2.QtCore.QAbstractItemModel, index: PySide2.QtCore.QModelIndex): ...
    def sizeHint(self, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QSize: ...
    def updateEditorGeometry(self, editor: PySide2.QtWidgets.QWidget, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex): ...


class QSwipeGesture(PySide2.QtWidgets.QGesture):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def horizontalDirection(self) -> PySide2.QtWidgets.QSwipeGesture.SwipeDirection: ...
    def setSwipeAngle(self, value: float): ...
    def swipeAngle(self) -> float: ...
    def verticalDirection(self) -> PySide2.QtWidgets.QSwipeGesture.SwipeDirection: ...


class QSystemTrayIcon(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, icon: PySide2.QtGui.QIcon, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def contextMenu(self) -> PySide2.QtWidgets.QMenu: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def hide(self): ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    @staticmethod
    def isSystemTrayAvailable() -> bool: ...
    def isVisible(self) -> bool: ...
    def setContextMenu(self, menu: PySide2.QtWidgets.QMenu): ...
    def setIcon(self, icon: PySide2.QtGui.QIcon): ...
    def setToolTip(self, tip: str): ...
    def setVisible(self, visible: bool): ...
    def show(self): ...
    @typing.overload
    def showMessage(self, title: str, msg: str, icon: PySide2.QtGui.QIcon, msecs: int = ...): ...
    @typing.overload
    def showMessage(self, title: str, msg: str, icon: PySide2.QtWidgets.QSystemTrayIcon.MessageIcon = ..., msecs: int = ...): ...
    @staticmethod
    def supportsMessages() -> bool: ...
    def toolTip(self) -> str: ...


class QTabBar(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def accessibleTabName(self, index: int) -> str: ...
    @typing.overload
    def addTab(self, icon: PySide2.QtGui.QIcon, text: str) -> int: ...
    @typing.overload
    def addTab(self, text: str) -> int: ...
    def autoHide(self) -> bool: ...
    def changeCurrentOnDrag(self) -> bool: ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent): ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def documentMode(self) -> bool: ...
    def drawBase(self) -> bool: ...
    def elideMode(self) -> PySide2.QtCore.Qt.TextElideMode: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def expanding(self) -> bool: ...
    def hideEvent(self, arg__1: PySide2.QtGui.QHideEvent): ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionTab, tabIndex: int): ...
    @typing.overload
    def insertTab(self, index: int, icon: PySide2.QtGui.QIcon, text: str) -> int: ...
    @typing.overload
    def insertTab(self, index: int, text: str) -> int: ...
    def isMovable(self) -> bool: ...
    def isTabEnabled(self, index: int) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent): ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def minimumTabSizeHint(self, index: int) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def moveTab(self, from_: int, to: int): ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent): ...
    def removeTab(self, index: int): ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent): ...
    def selectionBehaviorOnRemove(self) -> PySide2.QtWidgets.QTabBar.SelectionBehavior: ...
    def setAccessibleTabName(self, index: int, name: str): ...
    def setAutoHide(self, hide: bool): ...
    def setChangeCurrentOnDrag(self, change: bool): ...
    def setCurrentIndex(self, index: int): ...
    def setDocumentMode(self, set: bool): ...
    def setDrawBase(self, drawTheBase: bool): ...
    def setElideMode(self, arg__1: PySide2.QtCore.Qt.TextElideMode): ...
    def setExpanding(self, enabled: bool): ...
    def setIconSize(self, size: PySide2.QtCore.QSize): ...
    def setMovable(self, movable: bool): ...
    def setSelectionBehaviorOnRemove(self, behavior: PySide2.QtWidgets.QTabBar.SelectionBehavior): ...
    def setShape(self, shape: PySide2.QtWidgets.QTabBar.Shape): ...
    def setTabButton(self, index: int, position: PySide2.QtWidgets.QTabBar.ButtonPosition, widget: PySide2.QtWidgets.QWidget): ...
    def setTabData(self, index: int, data: typing.Any): ...
    def setTabEnabled(self, index: int, arg__2: bool): ...
    def setTabIcon(self, index: int, icon: PySide2.QtGui.QIcon): ...
    def setTabText(self, index: int, text: str): ...
    def setTabTextColor(self, index: int, color: PySide2.QtGui.QColor): ...
    def setTabToolTip(self, index: int, tip: str): ...
    def setTabWhatsThis(self, index: int, text: str): ...
    def setTabsClosable(self, closable: bool): ...
    def setUsesScrollButtons(self, useButtons: bool): ...
    def shape(self) -> PySide2.QtWidgets.QTabBar.Shape: ...
    def showEvent(self, arg__1: PySide2.QtGui.QShowEvent): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def tabAt(self, pos: PySide2.QtCore.QPoint) -> int: ...
    def tabButton(self, index: int, position: PySide2.QtWidgets.QTabBar.ButtonPosition) -> PySide2.QtWidgets.QWidget: ...
    def tabData(self, index: int) -> typing.Any: ...
    def tabIcon(self, index: int) -> PySide2.QtGui.QIcon: ...
    def tabInserted(self, index: int): ...
    def tabLayoutChange(self): ...
    def tabRect(self, index: int) -> PySide2.QtCore.QRect: ...
    def tabRemoved(self, index: int): ...
    def tabSizeHint(self, index: int) -> PySide2.QtCore.QSize: ...
    def tabText(self, index: int) -> str: ...
    def tabTextColor(self, index: int) -> PySide2.QtGui.QColor: ...
    def tabToolTip(self, index: int) -> str: ...
    def tabWhatsThis(self, index: int) -> str: ...
    def tabsClosable(self) -> bool: ...
    def timerEvent(self, event: PySide2.QtCore.QTimerEvent): ...
    def usesScrollButtons(self) -> bool: ...
    def wheelEvent(self, event: PySide2.QtGui.QWheelEvent): ...


class QTabWidget(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def addTab(self, widget: PySide2.QtWidgets.QWidget, arg__2: str) -> int: ...
    @typing.overload
    def addTab(self, widget: PySide2.QtWidgets.QWidget, icon: PySide2.QtGui.QIcon, label: str) -> int: ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent): ...
    def clear(self): ...
    def cornerWidget(self, corner: PySide2.QtCore.Qt.Corner = ...) -> PySide2.QtWidgets.QWidget: ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def currentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def documentMode(self) -> bool: ...
    def elideMode(self) -> PySide2.QtCore.Qt.TextElideMode: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, width: int) -> int: ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def indexOf(self, widget: PySide2.QtWidgets.QWidget) -> int: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionTabWidgetFrame): ...
    @typing.overload
    def insertTab(self, index: int, widget: PySide2.QtWidgets.QWidget, arg__3: str) -> int: ...
    @typing.overload
    def insertTab(self, index: int, widget: PySide2.QtWidgets.QWidget, icon: PySide2.QtGui.QIcon, label: str) -> int: ...
    def isMovable(self) -> bool: ...
    def isTabEnabled(self, index: int) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent): ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent): ...
    def removeTab(self, index: int): ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent): ...
    def setCornerWidget(self, w: PySide2.QtWidgets.QWidget, corner: PySide2.QtCore.Qt.Corner = ...): ...
    def setCurrentIndex(self, index: int): ...
    def setCurrentWidget(self, widget: PySide2.QtWidgets.QWidget): ...
    def setDocumentMode(self, set: bool): ...
    def setElideMode(self, arg__1: PySide2.QtCore.Qt.TextElideMode): ...
    def setIconSize(self, size: PySide2.QtCore.QSize): ...
    def setMovable(self, movable: bool): ...
    def setTabBar(self, arg__1: PySide2.QtWidgets.QTabBar): ...
    def setTabBarAutoHide(self, enabled: bool): ...
    def setTabEnabled(self, index: int, arg__2: bool): ...
    def setTabIcon(self, index: int, icon: PySide2.QtGui.QIcon): ...
    def setTabPosition(self, arg__1: PySide2.QtWidgets.QTabWidget.TabPosition): ...
    def setTabShape(self, s: PySide2.QtWidgets.QTabWidget.TabShape): ...
    def setTabText(self, index: int, arg__2: str): ...
    def setTabToolTip(self, index: int, tip: str): ...
    def setTabWhatsThis(self, index: int, text: str): ...
    def setTabsClosable(self, closeable: bool): ...
    def setUsesScrollButtons(self, useButtons: bool): ...
    def showEvent(self, arg__1: PySide2.QtGui.QShowEvent): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def tabBar(self) -> PySide2.QtWidgets.QTabBar: ...
    def tabBarAutoHide(self) -> bool: ...
    def tabIcon(self, index: int) -> PySide2.QtGui.QIcon: ...
    def tabInserted(self, index: int): ...
    def tabPosition(self) -> PySide2.QtWidgets.QTabWidget.TabPosition: ...
    def tabRemoved(self, index: int): ...
    def tabShape(self) -> PySide2.QtWidgets.QTabWidget.TabShape: ...
    def tabText(self, index: int) -> str: ...
    def tabToolTip(self, index: int) -> str: ...
    def tabWhatsThis(self, index: int) -> str: ...
    def tabsClosable(self) -> bool: ...
    def usesScrollButtons(self) -> bool: ...
    def widget(self, index: int) -> PySide2.QtWidgets.QWidget: ...


class QTableView(PySide2.QtWidgets.QAbstractItemView):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def clearSpans(self): ...
    def columnAt(self, x: int) -> int: ...
    def columnCountChanged(self, oldCount: int, newCount: int): ...
    def columnMoved(self, column: int, oldIndex: int, newIndex: int): ...
    def columnResized(self, column: int, oldWidth: int, newWidth: int): ...
    def columnSpan(self, row: int, column: int) -> int: ...
    def columnViewportPosition(self, column: int) -> int: ...
    def columnWidth(self, column: int) -> int: ...
    def currentChanged(self, current: PySide2.QtCore.QModelIndex, previous: PySide2.QtCore.QModelIndex): ...
    def doItemsLayout(self): ...
    def gridStyle(self) -> PySide2.QtCore.Qt.PenStyle: ...
    def hideColumn(self, column: int): ...
    def hideRow(self, row: int): ...
    def horizontalHeader(self) -> PySide2.QtWidgets.QHeaderView: ...
    def horizontalOffset(self) -> int: ...
    def horizontalScrollbarAction(self, action: int): ...
    def indexAt(self, p: PySide2.QtCore.QPoint) -> PySide2.QtCore.QModelIndex: ...
    def isColumnHidden(self, column: int) -> bool: ...
    def isCornerButtonEnabled(self) -> bool: ...
    def isIndexHidden(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def isRowHidden(self, row: int) -> bool: ...
    def isSortingEnabled(self) -> bool: ...
    def moveCursor(self, cursorAction: PySide2.QtWidgets.QAbstractItemView.CursorAction, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> PySide2.QtCore.QModelIndex: ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent): ...
    def resizeColumnToContents(self, column: int): ...
    def resizeColumnsToContents(self): ...
    def resizeRowToContents(self, row: int): ...
    def resizeRowsToContents(self): ...
    def rowAt(self, y: int) -> int: ...
    def rowCountChanged(self, oldCount: int, newCount: int): ...
    def rowHeight(self, row: int) -> int: ...
    def rowMoved(self, row: int, oldIndex: int, newIndex: int): ...
    def rowResized(self, row: int, oldHeight: int, newHeight: int): ...
    def rowSpan(self, row: int, column: int) -> int: ...
    def rowViewportPosition(self, row: int) -> int: ...
    def scrollContentsBy(self, dx: int, dy: int): ...
    def scrollTo(self, index: PySide2.QtCore.QModelIndex, hint: PySide2.QtWidgets.QAbstractItemView.ScrollHint = ...): ...
    def selectColumn(self, column: int): ...
    def selectRow(self, row: int): ...
    def selectedIndexes(self) -> typing.List[int]: ...
    def selectionChanged(self, selected: PySide2.QtCore.QItemSelection, deselected: PySide2.QtCore.QItemSelection): ...
    def setColumnHidden(self, column: int, hide: bool): ...
    def setColumnWidth(self, column: int, width: int): ...
    def setCornerButtonEnabled(self, enable: bool): ...
    def setGridStyle(self, style: PySide2.QtCore.Qt.PenStyle): ...
    def setHorizontalHeader(self, header: PySide2.QtWidgets.QHeaderView): ...
    def setModel(self, model: PySide2.QtCore.QAbstractItemModel): ...
    def setRootIndex(self, index: PySide2.QtCore.QModelIndex): ...
    def setRowHeight(self, row: int, height: int): ...
    def setRowHidden(self, row: int, hide: bool): ...
    def setSelection(self, rect: PySide2.QtCore.QRect, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    def setSelectionModel(self, selectionModel: PySide2.QtCore.QItemSelectionModel): ...
    def setShowGrid(self, show: bool): ...
    def setSortingEnabled(self, enable: bool): ...
    def setSpan(self, row: int, column: int, rowSpan: int, columnSpan: int): ...
    def setVerticalHeader(self, header: PySide2.QtWidgets.QHeaderView): ...
    def setWordWrap(self, on: bool): ...
    def showColumn(self, column: int): ...
    def showGrid(self) -> bool: ...
    def showRow(self, row: int): ...
    def sizeHintForColumn(self, column: int) -> int: ...
    def sizeHintForRow(self, row: int) -> int: ...
    @typing.overload
    def sortByColumn(self, column: int): ...
    @typing.overload
    def sortByColumn(self, column: int, order: PySide2.QtCore.Qt.SortOrder): ...
    def timerEvent(self, event: PySide2.QtCore.QTimerEvent): ...
    def updateGeometries(self): ...
    def verticalHeader(self) -> PySide2.QtWidgets.QHeaderView: ...
    def verticalOffset(self) -> int: ...
    def verticalScrollbarAction(self, action: int): ...
    def viewOptions(self) -> PySide2.QtWidgets.QStyleOptionViewItem: ...
    def viewportSizeHint(self) -> PySide2.QtCore.QSize: ...
    def visualRect(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide2.QtCore.QItemSelection) -> PySide2.QtGui.QRegion: ...
    def wordWrap(self) -> bool: ...


class QTableWidget(PySide2.QtWidgets.QTableView):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, rows: int, columns: int, parent: PySide2.QtWidgets.QWidget = ...): ...
    def cellWidget(self, row: int, column: int) -> PySide2.QtWidgets.QWidget: ...
    def clear(self): ...
    def clearContents(self): ...
    @typing.overload
    def closePersistentEditor(self, index: PySide2.QtCore.QModelIndex): ...
    @typing.overload
    def closePersistentEditor(self, item: PySide2.QtWidgets.QTableWidgetItem): ...
    def column(self, item: PySide2.QtWidgets.QTableWidgetItem) -> int: ...
    def columnCount(self) -> int: ...
    def currentColumn(self) -> int: ...
    def currentItem(self) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def currentRow(self) -> int: ...
    def dropEvent(self, event: PySide2.QtGui.QDropEvent): ...
    def dropMimeData(self, row: int, column: int, data: PySide2.QtCore.QMimeData, action: PySide2.QtCore.Qt.DropAction) -> bool: ...
    def editItem(self, item: PySide2.QtWidgets.QTableWidgetItem): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def findItems(self, text: str, flags: PySide2.QtCore.Qt.MatchFlags) -> typing.List[PySide2.QtWidgets.QTableWidgetItem]: ...
    def horizontalHeaderItem(self, column: int) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def indexFromItem(self, item: PySide2.QtWidgets.QTableWidgetItem) -> PySide2.QtCore.QModelIndex: ...
    def insertColumn(self, column: int): ...
    def insertRow(self, row: int): ...
    def isItemSelected(self, item: PySide2.QtWidgets.QTableWidgetItem) -> bool: ...
    @typing.overload
    def isPersistentEditorOpen(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    @typing.overload
    def isPersistentEditorOpen(self, item: PySide2.QtWidgets.QTableWidgetItem) -> bool: ...
    def isSortingEnabled(self) -> bool: ...
    def item(self, row: int, column: int) -> PySide2.QtWidgets.QTableWidgetItem: ...
    @typing.overload
    def itemAt(self, p: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QTableWidgetItem: ...
    @typing.overload
    def itemAt(self, x: int, y: int) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def itemFromIndex(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def itemPrototype(self) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def items(self, data: PySide2.QtCore.QMimeData) -> typing.List[PySide2.QtWidgets.QTableWidgetItem]: ...
    def mimeData(self, items: typing.List[PySide2.QtWidgets.QTableWidgetItem]) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    @typing.overload
    def openPersistentEditor(self, index: PySide2.QtCore.QModelIndex): ...
    @typing.overload
    def openPersistentEditor(self, item: PySide2.QtWidgets.QTableWidgetItem): ...
    def removeCellWidget(self, row: int, column: int): ...
    def removeColumn(self, column: int): ...
    def removeRow(self, row: int): ...
    def row(self, item: PySide2.QtWidgets.QTableWidgetItem) -> int: ...
    def rowCount(self) -> int: ...
    def scrollToItem(self, item: PySide2.QtWidgets.QTableWidgetItem, hint: PySide2.QtWidgets.QAbstractItemView.ScrollHint = ...): ...
    def selectedItems(self) -> typing.List[PySide2.QtWidgets.QTableWidgetItem]: ...
    def selectedRanges(self) -> typing.List[PySide2.QtWidgets.QTableWidgetSelectionRange]: ...
    def setCellWidget(self, row: int, column: int, widget: PySide2.QtWidgets.QWidget): ...
    def setColumnCount(self, columns: int): ...
    @typing.overload
    def setCurrentCell(self, row: int, column: int): ...
    @typing.overload
    def setCurrentCell(self, row: int, column: int, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    @typing.overload
    def setCurrentItem(self, item: PySide2.QtWidgets.QTableWidgetItem): ...
    @typing.overload
    def setCurrentItem(self, item: PySide2.QtWidgets.QTableWidgetItem, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    def setHorizontalHeaderItem(self, column: int, item: PySide2.QtWidgets.QTableWidgetItem): ...
    def setHorizontalHeaderLabels(self, labels: typing.List[str]): ...
    def setItem(self, row: int, column: int, item: PySide2.QtWidgets.QTableWidgetItem): ...
    def setItemPrototype(self, item: PySide2.QtWidgets.QTableWidgetItem): ...
    def setItemSelected(self, item: PySide2.QtWidgets.QTableWidgetItem, select: bool): ...
    def setModel(self, model: PySide2.QtCore.QAbstractItemModel): ...
    def setRangeSelected(self, range: PySide2.QtWidgets.QTableWidgetSelectionRange, select: bool): ...
    def setRowCount(self, rows: int): ...
    def setSortingEnabled(self, enable: bool): ...
    def setVerticalHeaderItem(self, row: int, item: PySide2.QtWidgets.QTableWidgetItem): ...
    def setVerticalHeaderLabels(self, labels: typing.List[str]): ...
    def sortItems(self, column: int, order: PySide2.QtCore.Qt.SortOrder = ...): ...
    def supportedDropActions(self) -> PySide2.QtCore.Qt.DropActions: ...
    def takeHorizontalHeaderItem(self, column: int) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def takeItem(self, row: int, column: int) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def takeVerticalHeaderItem(self, row: int) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def verticalHeaderItem(self, row: int) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def visualColumn(self, logicalColumn: int) -> int: ...
    def visualItemRect(self, item: PySide2.QtWidgets.QTableWidgetItem) -> PySide2.QtCore.QRect: ...
    def visualRow(self, logicalRow: int) -> int: ...


class QTableWidgetItem(Shiboken.Object):

    @typing.overload
    def __init__(self, icon: PySide2.QtGui.QIcon, text: str, type: int = ...): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QTableWidgetItem): ...
    @typing.overload
    def __init__(self, text: str, type: int = ...): ...
    @typing.overload
    def __init__(self, type: int = ...): ...
    def __lshift__(self, out: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, in_: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def background(self) -> PySide2.QtGui.QBrush: ...
    def backgroundColor(self) -> PySide2.QtGui.QColor: ...
    def checkState(self) -> PySide2.QtCore.Qt.CheckState: ...
    def clone(self) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def column(self) -> int: ...
    def data(self, role: int) -> typing.Any: ...
    def flags(self) -> PySide2.QtCore.Qt.ItemFlags: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def foreground(self) -> PySide2.QtGui.QBrush: ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def isSelected(self) -> bool: ...
    def read(self, in_: PySide2.QtCore.QDataStream): ...
    def row(self) -> int: ...
    def setBackground(self, brush: PySide2.QtGui.QBrush): ...
    def setBackgroundColor(self, color: PySide2.QtGui.QColor): ...
    def setCheckState(self, state: PySide2.QtCore.Qt.CheckState): ...
    def setData(self, role: int, value: typing.Any): ...
    def setFlags(self, flags: PySide2.QtCore.Qt.ItemFlags): ...
    def setFont(self, font: PySide2.QtGui.QFont): ...
    def setForeground(self, brush: PySide2.QtGui.QBrush): ...
    def setIcon(self, icon: PySide2.QtGui.QIcon): ...
    def setSelected(self, select: bool): ...
    def setSizeHint(self, size: PySide2.QtCore.QSize): ...
    def setStatusTip(self, statusTip: str): ...
    def setText(self, text: str): ...
    def setTextAlignment(self, alignment: int): ...
    def setTextColor(self, color: PySide2.QtGui.QColor): ...
    def setToolTip(self, toolTip: str): ...
    def setWhatsThis(self, whatsThis: str): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def statusTip(self) -> str: ...
    def tableWidget(self) -> PySide2.QtWidgets.QTableWidget: ...
    def text(self) -> str: ...
    def textAlignment(self) -> int: ...
    def textColor(self) -> PySide2.QtGui.QColor: ...
    def toolTip(self) -> str: ...
    def type(self) -> int: ...
    def whatsThis(self) -> str: ...
    def write(self, out: PySide2.QtCore.QDataStream): ...


class QTableWidgetSelectionRange(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QTableWidgetSelectionRange): ...
    @typing.overload
    def __init__(self, top: int, left: int, bottom: int, right: int): ...
    def __copy__(self): ...
    def bottomRow(self) -> int: ...
    def columnCount(self) -> int: ...
    def leftColumn(self) -> int: ...
    def rightColumn(self) -> int: ...
    def rowCount(self) -> int: ...
    def topRow(self) -> int: ...


class QTapAndHoldGesture(PySide2.QtWidgets.QGesture):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def position(self) -> PySide2.QtCore.QPointF: ...
    def setPosition(self, pos: PySide2.QtCore.QPointF): ...
    @staticmethod
    def setTimeout(msecs: int): ...
    @staticmethod
    def timeout() -> int: ...


class QTapGesture(PySide2.QtWidgets.QGesture):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def position(self) -> PySide2.QtCore.QPointF: ...
    def setPosition(self, pos: PySide2.QtCore.QPointF): ...


class QTextBrowser(PySide2.QtWidgets.QTextEdit):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def backward(self): ...
    def backwardHistoryCount(self) -> int: ...
    def clearHistory(self): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, ev: PySide2.QtGui.QFocusEvent): ...
    def forward(self): ...
    def forwardHistoryCount(self) -> int: ...
    def historyTitle(self, arg__1: int) -> str: ...
    def historyUrl(self, arg__1: int) -> PySide2.QtCore.QUrl: ...
    def home(self): ...
    def isBackwardAvailable(self) -> bool: ...
    def isForwardAvailable(self) -> bool: ...
    def keyPressEvent(self, ev: PySide2.QtGui.QKeyEvent): ...
    def loadResource(self, type: int, name: PySide2.QtCore.QUrl) -> typing.Any: ...
    def mouseMoveEvent(self, ev: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, ev: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, ev: PySide2.QtGui.QMouseEvent): ...
    def openExternalLinks(self) -> bool: ...
    def openLinks(self) -> bool: ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent): ...
    def reload(self): ...
    def searchPaths(self) -> typing.List[str]: ...
    def setOpenExternalLinks(self, open: bool): ...
    def setOpenLinks(self, open: bool): ...
    def setSearchPaths(self, paths: typing.List[str]): ...
    def setSource(self, name: PySide2.QtCore.QUrl): ...
    def source(self) -> PySide2.QtCore.QUrl: ...


class QTextEdit(PySide2.QtWidgets.QAbstractScrollArea):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, text: str, parent: PySide2.QtWidgets.QWidget = ...): ...
    def acceptRichText(self) -> bool: ...
    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def anchorAt(self, pos: PySide2.QtCore.QPoint) -> str: ...
    def append(self, text: str): ...
    def autoFormatting(self) -> PySide2.QtWidgets.QTextEdit.AutoFormatting: ...
    def canInsertFromMimeData(self, source: PySide2.QtCore.QMimeData) -> bool: ...
    def canPaste(self) -> bool: ...
    def changeEvent(self, e: PySide2.QtCore.QEvent): ...
    def clear(self): ...
    def contextMenuEvent(self, e: PySide2.QtGui.QContextMenuEvent): ...
    def copy(self): ...
    def createMimeDataFromSelection(self) -> PySide2.QtCore.QMimeData: ...
    @typing.overload
    def createStandardContextMenu(self) -> PySide2.QtWidgets.QMenu: ...
    @typing.overload
    def createStandardContextMenu(self, position: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QMenu: ...
    def currentCharFormat(self) -> PySide2.QtGui.QTextCharFormat: ...
    def currentFont(self) -> PySide2.QtGui.QFont: ...
    def cursorForPosition(self, pos: PySide2.QtCore.QPoint) -> PySide2.QtGui.QTextCursor: ...
    @typing.overload
    def cursorRect(self) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def cursorRect(self, cursor: PySide2.QtGui.QTextCursor) -> PySide2.QtCore.QRect: ...
    def cursorWidth(self) -> int: ...
    def cut(self): ...
    def doSetTextCursor(self, cursor: PySide2.QtGui.QTextCursor): ...
    def document(self) -> PySide2.QtGui.QTextDocument: ...
    def documentTitle(self) -> str: ...
    def dragEnterEvent(self, e: PySide2.QtGui.QDragEnterEvent): ...
    def dragLeaveEvent(self, e: PySide2.QtGui.QDragLeaveEvent): ...
    def dragMoveEvent(self, e: PySide2.QtGui.QDragMoveEvent): ...
    def dropEvent(self, e: PySide2.QtGui.QDropEvent): ...
    def ensureCursorVisible(self): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def extraSelections(self) -> typing.List[PySide2.QtWidgets.QTextEdit.ExtraSelection]: ...
    @typing.overload
    def find(self, exp: PySide2.QtCore.QRegExp, options: PySide2.QtGui.QTextDocument.FindFlags = ...) -> bool: ...
    @typing.overload
    def find(self, exp: str, options: PySide2.QtGui.QTextDocument.FindFlags = ...) -> bool: ...
    def focusInEvent(self, e: PySide2.QtGui.QFocusEvent): ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, e: PySide2.QtGui.QFocusEvent): ...
    def fontFamily(self) -> str: ...
    def fontItalic(self) -> bool: ...
    def fontPointSize(self) -> float: ...
    def fontUnderline(self) -> bool: ...
    def fontWeight(self) -> int: ...
    def inputMethodEvent(self, arg__1: PySide2.QtGui.QInputMethodEvent): ...
    @typing.overload
    def inputMethodQuery(self, property: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    @typing.overload
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery, argument: typing.Any) -> typing.Any: ...
    def insertFromMimeData(self, source: PySide2.QtCore.QMimeData): ...
    def insertHtml(self, text: str): ...
    def insertPlainText(self, text: str): ...
    def isReadOnly(self) -> bool: ...
    def isUndoRedoEnabled(self) -> bool: ...
    def keyPressEvent(self, e: PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, e: PySide2.QtGui.QKeyEvent): ...
    def lineWrapColumnOrWidth(self) -> int: ...
    def lineWrapMode(self) -> PySide2.QtWidgets.QTextEdit.LineWrapMode: ...
    def loadResource(self, type: int, name: PySide2.QtCore.QUrl) -> typing.Any: ...
    def mergeCurrentCharFormat(self, modifier: PySide2.QtGui.QTextCharFormat): ...
    def mouseDoubleClickEvent(self, e: PySide2.QtGui.QMouseEvent): ...
    def mouseMoveEvent(self, e: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, e: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, e: PySide2.QtGui.QMouseEvent): ...
    def moveCursor(self, operation: PySide2.QtGui.QTextCursor.MoveOperation, mode: PySide2.QtGui.QTextCursor.MoveMode = ...): ...
    def overwriteMode(self) -> bool: ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent): ...
    def paste(self): ...
    def placeholderText(self) -> str: ...
    def print_(self, printer: PySide2.QtGui.QPagedPaintDevice): ...
    def redo(self): ...
    def resizeEvent(self, e: PySide2.QtGui.QResizeEvent): ...
    def scrollContentsBy(self, dx: int, dy: int): ...
    def scrollToAnchor(self, name: str): ...
    def selectAll(self): ...
    def setAcceptRichText(self, accept: bool): ...
    def setAlignment(self, a: PySide2.QtCore.Qt.Alignment): ...
    def setAutoFormatting(self, features: PySide2.QtWidgets.QTextEdit.AutoFormatting): ...
    def setCurrentCharFormat(self, format: PySide2.QtGui.QTextCharFormat): ...
    def setCurrentFont(self, f: PySide2.QtGui.QFont): ...
    def setCursorWidth(self, width: int): ...
    def setDocument(self, document: PySide2.QtGui.QTextDocument): ...
    def setDocumentTitle(self, title: str): ...
    def setExtraSelections(self, selections: typing.List[PySide2.QtWidgets.QTextEdit.ExtraSelection]): ...
    def setFontFamily(self, fontFamily: str): ...
    def setFontItalic(self, b: bool): ...
    def setFontPointSize(self, s: float): ...
    def setFontUnderline(self, b: bool): ...
    def setFontWeight(self, w: int): ...
    def setHtml(self, text: str): ...
    def setLineWrapColumnOrWidth(self, w: int): ...
    def setLineWrapMode(self, mode: PySide2.QtWidgets.QTextEdit.LineWrapMode): ...
    def setOverwriteMode(self, overwrite: bool): ...
    def setPlaceholderText(self, placeholderText: str): ...
    def setPlainText(self, text: str): ...
    def setReadOnly(self, ro: bool): ...
    def setTabChangesFocus(self, b: bool): ...
    def setTabStopDistance(self, distance: float): ...
    def setTabStopWidth(self, width: int): ...
    def setText(self, text: str): ...
    def setTextBackgroundColor(self, c: PySide2.QtGui.QColor): ...
    def setTextColor(self, c: PySide2.QtGui.QColor): ...
    def setTextCursor(self, cursor: PySide2.QtGui.QTextCursor): ...
    def setTextInteractionFlags(self, flags: PySide2.QtCore.Qt.TextInteractionFlags): ...
    def setUndoRedoEnabled(self, enable: bool): ...
    def setWordWrapMode(self, policy: PySide2.QtGui.QTextOption.WrapMode): ...
    def showEvent(self, arg__1: PySide2.QtGui.QShowEvent): ...
    def tabChangesFocus(self) -> bool: ...
    def tabStopDistance(self) -> float: ...
    def tabStopWidth(self) -> int: ...
    def textBackgroundColor(self) -> PySide2.QtGui.QColor: ...
    def textColor(self) -> PySide2.QtGui.QColor: ...
    def textCursor(self) -> PySide2.QtGui.QTextCursor: ...
    def textInteractionFlags(self) -> PySide2.QtCore.Qt.TextInteractionFlags: ...
    def timerEvent(self, e: PySide2.QtCore.QTimerEvent): ...
    def toHtml(self) -> str: ...
    def toPlainText(self) -> str: ...
    def undo(self): ...
    def wheelEvent(self, e: PySide2.QtGui.QWheelEvent): ...
    def wordWrapMode(self) -> PySide2.QtGui.QTextOption.WrapMode: ...
    def zoomIn(self, range: int = ...): ...
    def zoomInF(self, range: float): ...
    def zoomOut(self, range: int = ...): ...

    class ExtraSelection(Shiboken.Object):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, ExtraSelection: PySide2.QtWidgets.QTextEdit.ExtraSelection): ...
        def __copy__(self): ...


class QTileRules(Shiboken.Object):

    @typing.overload
    def __init__(self, QTileRules: PySide2.QtWidgets.QTileRules): ...
    @typing.overload
    def __init__(self, horizontalRule: PySide2.QtCore.Qt.TileRule, verticalRule: PySide2.QtCore.Qt.TileRule): ...
    @typing.overload
    def __init__(self, rule: PySide2.QtCore.Qt.TileRule = ...): ...
    def __copy__(self): ...


class QTimeEdit(PySide2.QtWidgets.QDateTimeEdit):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, time: PySide2.QtCore.QTime, parent: PySide2.QtWidgets.QWidget = ...): ...


class QToolBar(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, title: str, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def actionAt(self, p: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def actionAt(self, x: int, y: int) -> PySide2.QtWidgets.QAction: ...
    def actionEvent(self, event: PySide2.QtGui.QActionEvent): ...
    def actionGeometry(self, action: PySide2.QtWidgets.QAction) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def addAction(self, arg__1: PySide2.QtWidgets.QAction): ...
    @typing.overload
    def addAction(self, icon: PySide2.QtGui.QIcon, text: str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide2.QtGui.QIcon, text: str, receiver: PySide2.QtCore.QObject, member: str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, text: str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, text: str, receiver: PySide2.QtCore.QObject, member: str) -> PySide2.QtWidgets.QAction: ...
    def addSeparator(self) -> PySide2.QtWidgets.QAction: ...
    def addWidget(self, widget: PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QAction: ...
    def allowedAreas(self) -> PySide2.QtCore.Qt.ToolBarAreas: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent): ...
    def clear(self): ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionToolBar): ...
    def insertSeparator(self, before: PySide2.QtWidgets.QAction) -> PySide2.QtWidgets.QAction: ...
    def insertWidget(self, before: PySide2.QtWidgets.QAction, widget: PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QAction: ...
    def isAreaAllowed(self, area: PySide2.QtCore.Qt.ToolBarArea) -> bool: ...
    def isFloatable(self) -> bool: ...
    def isFloating(self) -> bool: ...
    def isMovable(self) -> bool: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent): ...
    def setAllowedAreas(self, areas: PySide2.QtCore.Qt.ToolBarAreas): ...
    def setFloatable(self, floatable: bool): ...
    def setIconSize(self, iconSize: PySide2.QtCore.QSize): ...
    def setMovable(self, movable: bool): ...
    def setOrientation(self, orientation: PySide2.QtCore.Qt.Orientation): ...
    def setToolButtonStyle(self, toolButtonStyle: PySide2.QtCore.Qt.ToolButtonStyle): ...
    def toggleViewAction(self) -> PySide2.QtWidgets.QAction: ...
    def toolButtonStyle(self) -> PySide2.QtCore.Qt.ToolButtonStyle: ...
    def widgetForAction(self, action: PySide2.QtWidgets.QAction) -> PySide2.QtWidgets.QWidget: ...


class QToolBox(PySide2.QtWidgets.QFrame):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ..., f: PySide2.QtCore.Qt.WindowFlags = ...): ...
    @typing.overload
    def addItem(self, widget: PySide2.QtWidgets.QWidget, icon: PySide2.QtGui.QIcon, text: str) -> int: ...
    @typing.overload
    def addItem(self, widget: PySide2.QtWidgets.QWidget, text: str) -> int: ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent): ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def currentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def indexOf(self, widget: PySide2.QtWidgets.QWidget) -> int: ...
    @typing.overload
    def insertItem(self, index: int, widget: PySide2.QtWidgets.QWidget, icon: PySide2.QtGui.QIcon, text: str) -> int: ...
    @typing.overload
    def insertItem(self, index: int, widget: PySide2.QtWidgets.QWidget, text: str) -> int: ...
    def isItemEnabled(self, index: int) -> bool: ...
    def itemIcon(self, index: int) -> PySide2.QtGui.QIcon: ...
    def itemInserted(self, index: int): ...
    def itemRemoved(self, index: int): ...
    def itemText(self, index: int) -> str: ...
    def itemToolTip(self, index: int) -> str: ...
    def removeItem(self, index: int): ...
    def setCurrentIndex(self, index: int): ...
    def setCurrentWidget(self, widget: PySide2.QtWidgets.QWidget): ...
    def setItemEnabled(self, index: int, enabled: bool): ...
    def setItemIcon(self, index: int, icon: PySide2.QtGui.QIcon): ...
    def setItemText(self, index: int, text: str): ...
    def setItemToolTip(self, index: int, toolTip: str): ...
    def showEvent(self, e: PySide2.QtGui.QShowEvent): ...
    def widget(self, index: int) -> PySide2.QtWidgets.QWidget: ...


class QToolButton(PySide2.QtWidgets.QAbstractButton):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def actionEvent(self, arg__1: PySide2.QtGui.QActionEvent): ...
    def arrowType(self) -> PySide2.QtCore.Qt.ArrowType: ...
    def autoRaise(self) -> bool: ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent): ...
    def defaultAction(self) -> PySide2.QtWidgets.QAction: ...
    def enterEvent(self, arg__1: PySide2.QtCore.QEvent): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def hitButton(self, pos: PySide2.QtCore.QPoint) -> bool: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionToolButton): ...
    def leaveEvent(self, arg__1: PySide2.QtCore.QEvent): ...
    def menu(self) -> PySide2.QtWidgets.QMenu: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def nextCheckState(self): ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent): ...
    def popupMode(self) -> PySide2.QtWidgets.QToolButton.ToolButtonPopupMode: ...
    def setArrowType(self, type: PySide2.QtCore.Qt.ArrowType): ...
    def setAutoRaise(self, enable: bool): ...
    def setDefaultAction(self, arg__1: PySide2.QtWidgets.QAction): ...
    def setMenu(self, menu: PySide2.QtWidgets.QMenu): ...
    def setPopupMode(self, mode: PySide2.QtWidgets.QToolButton.ToolButtonPopupMode): ...
    def setToolButtonStyle(self, style: PySide2.QtCore.Qt.ToolButtonStyle): ...
    def showMenu(self): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def timerEvent(self, arg__1: PySide2.QtCore.QTimerEvent): ...
    def toolButtonStyle(self) -> PySide2.QtCore.Qt.ToolButtonStyle: ...


class QToolTip(Shiboken.Object):

    @staticmethod
    def font() -> PySide2.QtGui.QFont: ...
    @staticmethod
    def hideText(): ...
    @staticmethod
    def isVisible() -> bool: ...
    @staticmethod
    def palette() -> PySide2.QtGui.QPalette: ...
    @staticmethod
    def setFont(arg__1: PySide2.QtGui.QFont): ...
    @staticmethod
    def setPalette(arg__1: PySide2.QtGui.QPalette): ...
    @typing.overload
    @staticmethod
    def showText(pos: PySide2.QtCore.QPoint, text: str, w: PySide2.QtWidgets.QWidget, rect: PySide2.QtCore.QRect): ...
    @typing.overload
    @staticmethod
    def showText(pos: PySide2.QtCore.QPoint, text: str, w: PySide2.QtWidgets.QWidget, rect: PySide2.QtCore.QRect, msecShowTime: int): ...
    @typing.overload
    @staticmethod
    def showText(pos: PySide2.QtCore.QPoint, text: str, w: PySide2.QtWidgets.QWidget = ...): ...
    @staticmethod
    def text() -> str: ...


class QTreeView(PySide2.QtWidgets.QAbstractItemView):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def allColumnsShowFocus(self) -> bool: ...
    def autoExpandDelay(self) -> int: ...
    def collapse(self, index: PySide2.QtCore.QModelIndex): ...
    def collapseAll(self): ...
    def columnAt(self, x: int) -> int: ...
    def columnCountChanged(self, oldCount: int, newCount: int): ...
    def columnMoved(self): ...
    def columnResized(self, column: int, oldSize: int, newSize: int): ...
    def columnViewportPosition(self, column: int) -> int: ...
    def columnWidth(self, column: int) -> int: ...
    def currentChanged(self, current: PySide2.QtCore.QModelIndex, previous: PySide2.QtCore.QModelIndex): ...
    def dataChanged(self, topLeft: PySide2.QtCore.QModelIndex, bottomRight: PySide2.QtCore.QModelIndex, roles: typing.List[int] = ...): ...
    def doItemsLayout(self): ...
    def dragMoveEvent(self, event: PySide2.QtGui.QDragMoveEvent): ...
    def drawBranches(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRect, index: PySide2.QtCore.QModelIndex): ...
    def drawRow(self, painter: PySide2.QtGui.QPainter, options: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex): ...
    def drawTree(self, painter: PySide2.QtGui.QPainter, region: PySide2.QtGui.QRegion): ...
    def expand(self, index: PySide2.QtCore.QModelIndex): ...
    def expandAll(self): ...
    def expandToDepth(self, depth: int): ...
    def expandsOnDoubleClick(self) -> bool: ...
    def header(self) -> PySide2.QtWidgets.QHeaderView: ...
    def hideColumn(self, column: int): ...
    def horizontalOffset(self) -> int: ...
    def horizontalScrollbarAction(self, action: int): ...
    def indentation(self) -> int: ...
    def indexAbove(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def indexAt(self, p: PySide2.QtCore.QPoint) -> PySide2.QtCore.QModelIndex: ...
    def indexBelow(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def indexRowSizeHint(self, index: PySide2.QtCore.QModelIndex) -> int: ...
    def isAnimated(self) -> bool: ...
    def isColumnHidden(self, column: int) -> bool: ...
    def isExpanded(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def isFirstColumnSpanned(self, row: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def isHeaderHidden(self) -> bool: ...
    def isIndexHidden(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def isRowHidden(self, row: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def isSortingEnabled(self) -> bool: ...
    def itemsExpandable(self) -> bool: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent): ...
    def keyboardSearch(self, search: str): ...
    def mouseDoubleClickEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    def moveCursor(self, cursorAction: PySide2.QtWidgets.QAbstractItemView.CursorAction, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> PySide2.QtCore.QModelIndex: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent): ...
    def reexpand(self): ...
    def reset(self): ...
    def resetIndentation(self): ...
    def resizeColumnToContents(self, column: int): ...
    def rootIsDecorated(self) -> bool: ...
    def rowHeight(self, index: PySide2.QtCore.QModelIndex) -> int: ...
    def rowsAboutToBeRemoved(self, parent: PySide2.QtCore.QModelIndex, start: int, end: int): ...
    def rowsInserted(self, parent: PySide2.QtCore.QModelIndex, start: int, end: int): ...
    def rowsRemoved(self, parent: PySide2.QtCore.QModelIndex, first: int, last: int): ...
    def scrollContentsBy(self, dx: int, dy: int): ...
    def scrollTo(self, index: PySide2.QtCore.QModelIndex, hint: PySide2.QtWidgets.QAbstractItemView.ScrollHint = ...): ...
    def selectAll(self): ...
    def selectedIndexes(self) -> typing.List[int]: ...
    def selectionChanged(self, selected: PySide2.QtCore.QItemSelection, deselected: PySide2.QtCore.QItemSelection): ...
    def setAllColumnsShowFocus(self, enable: bool): ...
    def setAnimated(self, enable: bool): ...
    def setAutoExpandDelay(self, delay: int): ...
    def setColumnHidden(self, column: int, hide: bool): ...
    def setColumnWidth(self, column: int, width: int): ...
    def setExpanded(self, index: PySide2.QtCore.QModelIndex, expand: bool): ...
    def setExpandsOnDoubleClick(self, enable: bool): ...
    def setFirstColumnSpanned(self, row: int, parent: PySide2.QtCore.QModelIndex, span: bool): ...
    def setHeader(self, header: PySide2.QtWidgets.QHeaderView): ...
    def setHeaderHidden(self, hide: bool): ...
    def setIndentation(self, i: int): ...
    def setItemsExpandable(self, enable: bool): ...
    def setModel(self, model: PySide2.QtCore.QAbstractItemModel): ...
    def setRootIndex(self, index: PySide2.QtCore.QModelIndex): ...
    def setRootIsDecorated(self, show: bool): ...
    def setRowHidden(self, row: int, parent: PySide2.QtCore.QModelIndex, hide: bool): ...
    def setSelection(self, rect: PySide2.QtCore.QRect, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    def setSelectionModel(self, selectionModel: PySide2.QtCore.QItemSelectionModel): ...
    def setSortingEnabled(self, enable: bool): ...
    def setTreePosition(self, logicalIndex: int): ...
    def setUniformRowHeights(self, uniform: bool): ...
    def setWordWrap(self, on: bool): ...
    def showColumn(self, column: int): ...
    def sizeHintForColumn(self, column: int) -> int: ...
    @typing.overload
    def sortByColumn(self, column: int): ...
    @typing.overload
    def sortByColumn(self, column: int, order: PySide2.QtCore.Qt.SortOrder): ...
    def timerEvent(self, event: PySide2.QtCore.QTimerEvent): ...
    def treePosition(self) -> int: ...
    def uniformRowHeights(self) -> bool: ...
    def updateGeometries(self): ...
    def verticalOffset(self) -> int: ...
    def verticalScrollbarValueChanged(self, value: int): ...
    def viewportEvent(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def viewportSizeHint(self) -> PySide2.QtCore.QSize: ...
    def visualRect(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide2.QtCore.QItemSelection) -> PySide2.QtGui.QRegion: ...
    def wordWrap(self) -> bool: ...


class QTreeWidget(PySide2.QtWidgets.QTreeView):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def addTopLevelItem(self, item: PySide2.QtWidgets.QTreeWidgetItem): ...
    def addTopLevelItems(self, items: typing.List[PySide2.QtWidgets.QTreeWidgetItem]): ...
    def clear(self): ...
    @typing.overload
    def closePersistentEditor(self, index: PySide2.QtCore.QModelIndex): ...
    @typing.overload
    def closePersistentEditor(self, item: PySide2.QtWidgets.QTreeWidgetItem, column: int = ...): ...
    def collapseItem(self, item: PySide2.QtWidgets.QTreeWidgetItem): ...
    def columnCount(self) -> int: ...
    def currentColumn(self) -> int: ...
    def currentItem(self) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def dropEvent(self, event: PySide2.QtGui.QDropEvent): ...
    def dropMimeData(self, parent: PySide2.QtWidgets.QTreeWidgetItem, index: int, data: PySide2.QtCore.QMimeData, action: PySide2.QtCore.Qt.DropAction) -> bool: ...
    def editItem(self, item: PySide2.QtWidgets.QTreeWidgetItem, column: int = ...): ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def expandItem(self, item: PySide2.QtWidgets.QTreeWidgetItem): ...
    def findItems(self, text: str, flags: PySide2.QtCore.Qt.MatchFlags, column: int = ...) -> typing.List[PySide2.QtWidgets.QTreeWidgetItem]: ...
    def headerItem(self) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def indexFromItem(self, item: PySide2.QtWidgets.QTreeWidgetItem, column: int = ...) -> PySide2.QtCore.QModelIndex: ...
    def indexOfTopLevelItem(self, item: PySide2.QtWidgets.QTreeWidgetItem) -> int: ...
    def insertTopLevelItem(self, index: int, item: PySide2.QtWidgets.QTreeWidgetItem): ...
    def insertTopLevelItems(self, index: int, items: typing.List[PySide2.QtWidgets.QTreeWidgetItem]): ...
    def invisibleRootItem(self) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def isFirstItemColumnSpanned(self, item: PySide2.QtWidgets.QTreeWidgetItem) -> bool: ...
    def isItemExpanded(self, item: PySide2.QtWidgets.QTreeWidgetItem) -> bool: ...
    def isItemHidden(self, item: PySide2.QtWidgets.QTreeWidgetItem) -> bool: ...
    def isItemSelected(self, item: PySide2.QtWidgets.QTreeWidgetItem) -> bool: ...
    @typing.overload
    def isPersistentEditorOpen(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    @typing.overload
    def isPersistentEditorOpen(self, item: PySide2.QtWidgets.QTreeWidgetItem, column: int = ...) -> bool: ...
    def itemAbove(self, item: PySide2.QtWidgets.QTreeWidgetItem) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    @typing.overload
    def itemAt(self, p: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    @typing.overload
    def itemAt(self, x: int, y: int) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def itemBelow(self, item: PySide2.QtWidgets.QTreeWidgetItem) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def itemFromIndex(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def itemWidget(self, item: PySide2.QtWidgets.QTreeWidgetItem, column: int) -> PySide2.QtWidgets.QWidget: ...
    def items(self, data: PySide2.QtCore.QMimeData) -> typing.List[PySide2.QtWidgets.QTreeWidgetItem]: ...
    def mimeData(self, items: typing.List[PySide2.QtWidgets.QTreeWidgetItem]) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    @typing.overload
    def openPersistentEditor(self, index: PySide2.QtCore.QModelIndex): ...
    @typing.overload
    def openPersistentEditor(self, item: PySide2.QtWidgets.QTreeWidgetItem, column: int = ...): ...
    def removeItemWidget(self, item: PySide2.QtWidgets.QTreeWidgetItem, column: int): ...
    def scrollToItem(self, item: PySide2.QtWidgets.QTreeWidgetItem, hint: PySide2.QtWidgets.QAbstractItemView.ScrollHint = ...): ...
    def selectedItems(self) -> typing.List[PySide2.QtWidgets.QTreeWidgetItem]: ...
    def setColumnCount(self, columns: int): ...
    @typing.overload
    def setCurrentItem(self, item: PySide2.QtWidgets.QTreeWidgetItem): ...
    @typing.overload
    def setCurrentItem(self, item: PySide2.QtWidgets.QTreeWidgetItem, column: int): ...
    @typing.overload
    def setCurrentItem(self, item: PySide2.QtWidgets.QTreeWidgetItem, column: int, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    def setFirstItemColumnSpanned(self, item: PySide2.QtWidgets.QTreeWidgetItem, span: bool): ...
    def setHeaderItem(self, item: PySide2.QtWidgets.QTreeWidgetItem): ...
    def setHeaderLabel(self, label: str): ...
    def setHeaderLabels(self, labels: typing.List[str]): ...
    def setItemExpanded(self, item: PySide2.QtWidgets.QTreeWidgetItem, expand: bool): ...
    def setItemHidden(self, item: PySide2.QtWidgets.QTreeWidgetItem, hide: bool): ...
    def setItemSelected(self, item: PySide2.QtWidgets.QTreeWidgetItem, select: bool): ...
    def setItemWidget(self, item: PySide2.QtWidgets.QTreeWidgetItem, column: int, widget: PySide2.QtWidgets.QWidget): ...
    def setModel(self, model: PySide2.QtCore.QAbstractItemModel): ...
    def setSelectionModel(self, selectionModel: PySide2.QtCore.QItemSelectionModel): ...
    def sortColumn(self) -> int: ...
    def sortItems(self, column: int, order: PySide2.QtCore.Qt.SortOrder): ...
    def supportedDropActions(self) -> PySide2.QtCore.Qt.DropActions: ...
    def takeTopLevelItem(self, index: int) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def topLevelItem(self, index: int) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def topLevelItemCount(self) -> int: ...
    def visualItemRect(self, item: PySide2.QtWidgets.QTreeWidgetItem) -> PySide2.QtCore.QRect: ...


class QTreeWidgetItem(Shiboken.Object):

    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QTreeWidgetItem): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QTreeWidgetItem, after: PySide2.QtWidgets.QTreeWidgetItem, type: int = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QTreeWidgetItem, strings: typing.List[str], type: int = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QTreeWidgetItem, type: int = ...): ...
    @typing.overload
    def __init__(self, strings: typing.List[str], type: int = ...): ...
    @typing.overload
    def __init__(self, type: int = ...): ...
    @typing.overload
    def __init__(self, view: PySide2.QtWidgets.QTreeWidget, after: PySide2.QtWidgets.QTreeWidgetItem, type: int = ...): ...
    @typing.overload
    def __init__(self, view: PySide2.QtWidgets.QTreeWidget, strings: typing.List[str], type: int = ...): ...
    @typing.overload
    def __init__(self, view: PySide2.QtWidgets.QTreeWidget, type: int = ...): ...
    def __lshift__(self, out: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, in_: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def addChild(self, child: PySide2.QtWidgets.QTreeWidgetItem): ...
    def addChildren(self, children: typing.List[PySide2.QtWidgets.QTreeWidgetItem]): ...
    def background(self, column: int) -> PySide2.QtGui.QBrush: ...
    def backgroundColor(self, column: int) -> PySide2.QtGui.QColor: ...
    def checkState(self, column: int) -> PySide2.QtCore.Qt.CheckState: ...
    def child(self, index: int) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def childCount(self) -> int: ...
    def childIndicatorPolicy(self) -> PySide2.QtWidgets.QTreeWidgetItem.ChildIndicatorPolicy: ...
    def clone(self) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def columnCount(self) -> int: ...
    def data(self, column: int, role: int) -> typing.Any: ...
    def emitDataChanged(self): ...
    def flags(self) -> PySide2.QtCore.Qt.ItemFlags: ...
    def font(self, column: int) -> PySide2.QtGui.QFont: ...
    def foreground(self, column: int) -> PySide2.QtGui.QBrush: ...
    def icon(self, column: int) -> PySide2.QtGui.QIcon: ...
    def indexOfChild(self, child: PySide2.QtWidgets.QTreeWidgetItem) -> int: ...
    def insertChild(self, index: int, child: PySide2.QtWidgets.QTreeWidgetItem): ...
    def insertChildren(self, index: int, children: typing.List[PySide2.QtWidgets.QTreeWidgetItem]): ...
    def isDisabled(self) -> bool: ...
    def isExpanded(self) -> bool: ...
    def isFirstColumnSpanned(self) -> bool: ...
    def isHidden(self) -> bool: ...
    def isSelected(self) -> bool: ...
    def parent(self) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def read(self, in_: PySide2.QtCore.QDataStream): ...
    def removeChild(self, child: PySide2.QtWidgets.QTreeWidgetItem): ...
    def setBackground(self, column: int, brush: PySide2.QtGui.QBrush): ...
    def setBackgroundColor(self, column: int, color: PySide2.QtGui.QColor): ...
    def setCheckState(self, column: int, state: PySide2.QtCore.Qt.CheckState): ...
    def setChildIndicatorPolicy(self, policy: PySide2.QtWidgets.QTreeWidgetItem.ChildIndicatorPolicy): ...
    def setData(self, column: int, role: int, value: typing.Any): ...
    def setDisabled(self, disabled: bool): ...
    def setExpanded(self, expand: bool): ...
    def setFirstColumnSpanned(self, span: bool): ...
    def setFlags(self, flags: PySide2.QtCore.Qt.ItemFlags): ...
    def setFont(self, column: int, font: PySide2.QtGui.QFont): ...
    def setForeground(self, column: int, brush: PySide2.QtGui.QBrush): ...
    def setHidden(self, hide: bool): ...
    def setIcon(self, column: int, icon: PySide2.QtGui.QIcon): ...
    def setSelected(self, select: bool): ...
    def setSizeHint(self, column: int, size: PySide2.QtCore.QSize): ...
    def setStatusTip(self, column: int, statusTip: str): ...
    def setText(self, column: int, text: str): ...
    def setTextAlignment(self, column: int, alignment: int): ...
    def setTextColor(self, column: int, color: PySide2.QtGui.QColor): ...
    def setToolTip(self, column: int, toolTip: str): ...
    def setWhatsThis(self, column: int, whatsThis: str): ...
    def sizeHint(self, column: int) -> PySide2.QtCore.QSize: ...
    def sortChildren(self, column: int, order: PySide2.QtCore.Qt.SortOrder): ...
    def statusTip(self, column: int) -> str: ...
    def takeChild(self, index: int) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def takeChildren(self) -> typing.List[PySide2.QtWidgets.QTreeWidgetItem]: ...
    def text(self, column: int) -> str: ...
    def textAlignment(self, column: int) -> int: ...
    def textColor(self, column: int) -> PySide2.QtGui.QColor: ...
    def toolTip(self, column: int) -> str: ...
    def treeWidget(self) -> PySide2.QtWidgets.QTreeWidget: ...
    def type(self) -> int: ...
    def whatsThis(self, column: int) -> str: ...
    def write(self, out: PySide2.QtCore.QDataStream): ...


class QTreeWidgetItemIterator(Shiboken.Object):

    @typing.overload
    def __init__(self, it: PySide2.QtWidgets.QTreeWidgetItemIterator): ...
    @typing.overload
    def __init__(self, item: PySide2.QtWidgets.QTreeWidgetItem, flags: PySide2.QtWidgets.QTreeWidgetItemIterator.IteratorFlags = ...): ...
    @typing.overload
    def __init__(self, widget: PySide2.QtWidgets.QTreeWidget, flags: PySide2.QtWidgets.QTreeWidgetItemIterator.IteratorFlags = ...): ...
    def __copy__(self): ...
    def __iadd__(self, n: int) -> PySide2.QtWidgets.QTreeWidgetItemIterator: ...
    def __isub__(self, n: int) -> PySide2.QtWidgets.QTreeWidgetItemIterator: ...
    def __iter__(self) -> object: ...
    def __next__(self) -> object: ...
    def value(self) -> PySide2.QtWidgets.QTreeWidgetItem: ...


class QUndoCommand(Shiboken.Object):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QUndoCommand = ...): ...
    @typing.overload
    def __init__(self, text: str, parent: PySide2.QtWidgets.QUndoCommand = ...): ...
    def actionText(self) -> str: ...
    def child(self, index: int) -> PySide2.QtWidgets.QUndoCommand: ...
    def childCount(self) -> int: ...
    def id(self) -> int: ...
    def isObsolete(self) -> bool: ...
    def mergeWith(self, other: PySide2.QtWidgets.QUndoCommand) -> bool: ...
    def redo(self): ...
    def setObsolete(self, obsolete: bool): ...
    def setText(self, text: str): ...
    def text(self) -> str: ...
    def undo(self): ...


class QUndoGroup(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def activeStack(self) -> PySide2.QtWidgets.QUndoStack: ...
    def addStack(self, stack: PySide2.QtWidgets.QUndoStack): ...
    def canRedo(self) -> bool: ...
    def canUndo(self) -> bool: ...
    def createRedoAction(self, parent: PySide2.QtCore.QObject, prefix: str = ...) -> PySide2.QtWidgets.QAction: ...
    def createUndoAction(self, parent: PySide2.QtCore.QObject, prefix: str = ...) -> PySide2.QtWidgets.QAction: ...
    def isClean(self) -> bool: ...
    def redo(self): ...
    def redoText(self) -> str: ...
    def removeStack(self, stack: PySide2.QtWidgets.QUndoStack): ...
    def setActiveStack(self, stack: PySide2.QtWidgets.QUndoStack): ...
    def stacks(self) -> typing.List[PySide2.QtWidgets.QUndoStack]: ...
    def undo(self): ...
    def undoText(self) -> str: ...


class QUndoStack(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def beginMacro(self, text: str): ...
    def canRedo(self) -> bool: ...
    def canUndo(self) -> bool: ...
    def cleanIndex(self) -> int: ...
    def clear(self): ...
    def command(self, index: int) -> PySide2.QtWidgets.QUndoCommand: ...
    def count(self) -> int: ...
    def createRedoAction(self, parent: PySide2.QtCore.QObject, prefix: str = ...) -> PySide2.QtWidgets.QAction: ...
    def createUndoAction(self, parent: PySide2.QtCore.QObject, prefix: str = ...) -> PySide2.QtWidgets.QAction: ...
    def endMacro(self): ...
    def index(self) -> int: ...
    def isActive(self) -> bool: ...
    def isClean(self) -> bool: ...
    def push(self, cmd: PySide2.QtWidgets.QUndoCommand): ...
    def redo(self): ...
    def redoText(self) -> str: ...
    def resetClean(self): ...
    def setActive(self, active: bool = ...): ...
    def setClean(self): ...
    def setIndex(self, idx: int): ...
    def setUndoLimit(self, limit: int): ...
    def text(self, idx: int) -> str: ...
    def undo(self): ...
    def undoLimit(self) -> int: ...
    def undoText(self) -> str: ...


class QUndoView(PySide2.QtWidgets.QListView):

    @typing.overload
    def __init__(self, group: PySide2.QtWidgets.QUndoGroup, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, stack: PySide2.QtWidgets.QUndoStack, parent: PySide2.QtWidgets.QWidget = ...): ...
    def cleanIcon(self) -> PySide2.QtGui.QIcon: ...
    def emptyLabel(self) -> str: ...
    def group(self) -> PySide2.QtWidgets.QUndoGroup: ...
    def setCleanIcon(self, icon: PySide2.QtGui.QIcon): ...
    def setEmptyLabel(self, label: str): ...
    def setGroup(self, group: PySide2.QtWidgets.QUndoGroup): ...
    def setStack(self, stack: PySide2.QtWidgets.QUndoStack): ...
    def stack(self) -> PySide2.QtWidgets.QUndoStack: ...


class QVBoxLayout(PySide2.QtWidgets.QBoxLayout):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget): ...


class QWhatsThis(Shiboken.Object):

    @staticmethod
    def createAction(parent: PySide2.QtCore.QObject = ...) -> PySide2.QtWidgets.QAction: ...
    @staticmethod
    def enterWhatsThisMode(): ...
    @staticmethod
    def hideText(): ...
    @staticmethod
    def inWhatsThisMode() -> bool: ...
    @staticmethod
    def leaveWhatsThisMode(): ...
    @staticmethod
    def showText(pos: PySide2.QtCore.QPoint, text: str, w: PySide2.QtWidgets.QWidget = ...): ...


class QWidget(PySide2.QtCore.QObject, PySide2.QtGui.QPaintDevice):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ..., f: PySide2.QtCore.Qt.WindowFlags = ...): ...
    def acceptDrops(self) -> bool: ...
    def accessibleDescription(self) -> str: ...
    def accessibleName(self) -> str: ...
    def actionEvent(self, event: PySide2.QtGui.QActionEvent): ...
    def actions(self) -> typing.List[PySide2.QtWidgets.QAction]: ...
    def activateWindow(self): ...
    def addAction(self, action: PySide2.QtWidgets.QAction): ...
    def addActions(self, actions: typing.List[PySide2.QtWidgets.QAction]): ...
    def adjustSize(self): ...
    def autoFillBackground(self) -> bool: ...
    def backgroundRole(self) -> PySide2.QtGui.QPalette.ColorRole: ...
    def backingStore(self) -> PySide2.QtGui.QBackingStore: ...
    def baseSize(self) -> PySide2.QtCore.QSize: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent): ...
    @typing.overload
    def childAt(self, p: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QWidget: ...
    @typing.overload
    def childAt(self, x: int, y: int) -> PySide2.QtWidgets.QWidget: ...
    def childrenRect(self) -> PySide2.QtCore.QRect: ...
    def childrenRegion(self) -> PySide2.QtGui.QRegion: ...
    def clearFocus(self): ...
    def clearMask(self): ...
    def close(self) -> bool: ...
    def closeEvent(self, event: PySide2.QtGui.QCloseEvent): ...
    def contentsMargins(self) -> PySide2.QtCore.QMargins: ...
    def contentsRect(self) -> PySide2.QtCore.QRect: ...
    def contextMenuEvent(self, event: PySide2.QtGui.QContextMenuEvent): ...
    def contextMenuPolicy(self) -> PySide2.QtCore.Qt.ContextMenuPolicy: ...
    def create(self, arg__1: int = ..., initializeWindow: bool = ..., destroyOldWindow: bool = ...): ...
    def createWinId(self): ...
    @staticmethod
    def createWindowContainer(window: PySide2.QtGui.QWindow, parent: PySide2.QtWidgets.QWidget = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> PySide2.QtWidgets.QWidget: ...
    def cursor(self) -> PySide2.QtGui.QCursor: ...
    def destroy(self, destroyWindow: bool = ..., destroySubWindows: bool = ...): ...
    def devType(self) -> int: ...
    def dragEnterEvent(self, event: PySide2.QtGui.QDragEnterEvent): ...
    def dragLeaveEvent(self, event: PySide2.QtGui.QDragLeaveEvent): ...
    def dragMoveEvent(self, event: PySide2.QtGui.QDragMoveEvent): ...
    def dropEvent(self, event: PySide2.QtGui.QDropEvent): ...
    def effectiveWinId(self) -> int: ...
    def ensurePolished(self): ...
    def enterEvent(self, event: PySide2.QtCore.QEvent): ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    @staticmethod
    def find(arg__1: int) -> PySide2.QtWidgets.QWidget: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent): ...
    def focusNextChild(self) -> bool: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent): ...
    def focusPolicy(self) -> PySide2.QtCore.Qt.FocusPolicy: ...
    def focusPreviousChild(self) -> bool: ...
    def focusProxy(self) -> PySide2.QtWidgets.QWidget: ...
    def focusWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def fontInfo(self) -> PySide2.QtGui.QFontInfo: ...
    def fontMetrics(self) -> PySide2.QtGui.QFontMetrics: ...
    def foregroundRole(self) -> PySide2.QtGui.QPalette.ColorRole: ...
    def frameGeometry(self) -> PySide2.QtCore.QRect: ...
    def frameSize(self) -> PySide2.QtCore.QSize: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def getContentsMargins(self, left: int, top: int, right: int, bottom: int): ...
    def grab(self, rectangle: PySide2.QtCore.QRect = ...) -> PySide2.QtGui.QPixmap: ...
    def grabGesture(self, type: PySide2.QtCore.Qt.GestureType, flags: PySide2.QtCore.Qt.GestureFlags = ...): ...
    def grabKeyboard(self): ...
    @typing.overload
    def grabMouse(self): ...
    @typing.overload
    def grabMouse(self, arg__1: PySide2.QtGui.QCursor): ...
    def grabShortcut(self, key: PySide2.QtGui.QKeySequence, context: PySide2.QtCore.Qt.ShortcutContext = ...) -> int: ...
    def graphicsEffect(self) -> PySide2.QtWidgets.QGraphicsEffect: ...
    def graphicsProxyWidget(self) -> PySide2.QtWidgets.QGraphicsProxyWidget: ...
    def hasFocus(self) -> bool: ...
    def hasHeightForWidth(self) -> bool: ...
    def hasMouseTracking(self) -> bool: ...
    def hasTabletTracking(self) -> bool: ...
    def height(self) -> int: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def hide(self): ...
    def hideEvent(self, event: PySide2.QtGui.QHideEvent): ...
    def initPainter(self, painter: PySide2.QtGui.QPainter): ...
    def inputMethodEvent(self, event: PySide2.QtGui.QInputMethodEvent): ...
    def inputMethodHints(self) -> PySide2.QtCore.Qt.InputMethodHints: ...
    def inputMethodQuery(self, arg__1: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def insertAction(self, before: PySide2.QtWidgets.QAction, action: PySide2.QtWidgets.QAction): ...
    def insertActions(self, before: PySide2.QtWidgets.QAction, actions: typing.List[PySide2.QtWidgets.QAction]): ...
    def internalWinId(self) -> int: ...
    def isActiveWindow(self) -> bool: ...
    def isAncestorOf(self, child: PySide2.QtWidgets.QWidget) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isEnabledTo(self, arg__1: PySide2.QtWidgets.QWidget) -> bool: ...
    def isEnabledToTLW(self) -> bool: ...
    def isFullScreen(self) -> bool: ...
    def isHidden(self) -> bool: ...
    def isLeftToRight(self) -> bool: ...
    def isMaximized(self) -> bool: ...
    def isMinimized(self) -> bool: ...
    def isModal(self) -> bool: ...
    def isRightToLeft(self) -> bool: ...
    def isTopLevel(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def isVisibleTo(self, arg__1: PySide2.QtWidgets.QWidget) -> bool: ...
    def isWindow(self) -> bool: ...
    def isWindowModified(self) -> bool: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, event: PySide2.QtGui.QKeyEvent): ...
    @staticmethod
    def keyboardGrabber() -> PySide2.QtWidgets.QWidget: ...
    def layout(self) -> PySide2.QtWidgets.QLayout: ...
    def layoutDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def leaveEvent(self, event: PySide2.QtCore.QEvent): ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    def lower(self): ...
    def mapFrom(self, arg__1: PySide2.QtWidgets.QWidget, arg__2: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mapFromGlobal(self, arg__1: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mapFromParent(self, arg__1: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mapTo(self, arg__1: PySide2.QtWidgets.QWidget, arg__2: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mapToGlobal(self, arg__1: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mapToParent(self, arg__1: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mask(self) -> PySide2.QtGui.QRegion: ...
    def maximumHeight(self) -> int: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def maximumWidth(self) -> int: ...
    def metric(self, arg__1: PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def minimumHeight(self) -> int: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def minimumWidth(self) -> int: ...
    def mouseDoubleClickEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    @staticmethod
    def mouseGrabber() -> PySide2.QtWidgets.QWidget: ...
    def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent): ...
    @typing.overload
    def move(self, arg__1: PySide2.QtCore.QPoint): ...
    @typing.overload
    def move(self, x: int, y: int): ...
    def moveEvent(self, event: PySide2.QtGui.QMoveEvent): ...
    def nativeEvent(self, eventType: PySide2.QtCore.QByteArray, message: int, result: int) -> bool: ...
    def nativeParentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def nextInFocusChain(self) -> PySide2.QtWidgets.QWidget: ...
    def normalGeometry(self) -> PySide2.QtCore.QRect: ...
    def overrideWindowFlags(self, type: PySide2.QtCore.Qt.WindowFlags): ...
    def overrideWindowState(self, state: PySide2.QtCore.Qt.WindowStates): ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent): ...
    def palette(self) -> PySide2.QtGui.QPalette: ...
    def parentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def previousInFocusChain(self) -> PySide2.QtWidgets.QWidget: ...
    def raise_(self): ...
    def rect(self) -> PySide2.QtCore.QRect: ...
    def redirected(self, offset: PySide2.QtCore.QPoint) -> PySide2.QtGui.QPaintDevice: ...
    def releaseKeyboard(self): ...
    def releaseMouse(self): ...
    def releaseShortcut(self, id: int): ...
    def removeAction(self, action: PySide2.QtWidgets.QAction): ...
    @typing.overload
    def render(self, painter: PySide2.QtGui.QPainter, targetOffset: PySide2.QtCore.QPoint, sourceRegion: PySide2.QtGui.QRegion = ..., renderFlags: PySide2.QtWidgets.QWidget.RenderFlags = ...): ...
    @typing.overload
    def render(self, target: PySide2.QtGui.QPaintDevice, targetOffset: PySide2.QtCore.QPoint = ..., sourceRegion: PySide2.QtGui.QRegion = ..., renderFlags: PySide2.QtWidgets.QWidget.RenderFlags = ...): ...
    @typing.overload
    def repaint(self): ...
    @typing.overload
    def repaint(self, arg__1: PySide2.QtCore.QRect): ...
    @typing.overload
    def repaint(self, arg__1: PySide2.QtGui.QRegion): ...
    @typing.overload
    def repaint(self, x: int, y: int, w: int, h: int): ...
    @typing.overload
    def resize(self, arg__1: PySide2.QtCore.QSize): ...
    @typing.overload
    def resize(self, w: int, h: int): ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent): ...
    def restoreGeometry(self, geometry: PySide2.QtCore.QByteArray) -> bool: ...
    def saveGeometry(self) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def scroll(self, dx: int, dy: int): ...
    @typing.overload
    def scroll(self, dx: int, dy: int, arg__3: PySide2.QtCore.QRect): ...
    def setAcceptDrops(self, on: bool): ...
    def setAccessibleDescription(self, description: str): ...
    def setAccessibleName(self, name: str): ...
    def setAttribute(self, arg__1: PySide2.QtCore.Qt.WidgetAttribute, on: bool = ...): ...
    def setAutoFillBackground(self, enabled: bool): ...
    def setBackgroundRole(self, arg__1: PySide2.QtGui.QPalette.ColorRole): ...
    @typing.overload
    def setBaseSize(self, arg__1: PySide2.QtCore.QSize): ...
    @typing.overload
    def setBaseSize(self, basew: int, baseh: int): ...
    @typing.overload
    def setContentsMargins(self, left: int, top: int, right: int, bottom: int): ...
    @typing.overload
    def setContentsMargins(self, margins: PySide2.QtCore.QMargins): ...
    def setContextMenuPolicy(self, policy: PySide2.QtCore.Qt.ContextMenuPolicy): ...
    def setCursor(self, arg__1: PySide2.QtGui.QCursor): ...
    def setDisabled(self, arg__1: bool): ...
    def setEnabled(self, arg__1: bool): ...
    def setFixedHeight(self, h: int): ...
    @typing.overload
    def setFixedSize(self, arg__1: PySide2.QtCore.QSize): ...
    @typing.overload
    def setFixedSize(self, w: int, h: int): ...
    def setFixedWidth(self, w: int): ...
    @typing.overload
    def setFocus(self): ...
    @typing.overload
    def setFocus(self, reason: PySide2.QtCore.Qt.FocusReason): ...
    def setFocusPolicy(self, policy: PySide2.QtCore.Qt.FocusPolicy): ...
    def setFocusProxy(self, arg__1: PySide2.QtWidgets.QWidget): ...
    def setFont(self, arg__1: PySide2.QtGui.QFont): ...
    def setForegroundRole(self, arg__1: PySide2.QtGui.QPalette.ColorRole): ...
    @typing.overload
    def setGeometry(self, arg__1: PySide2.QtCore.QRect): ...
    @typing.overload
    def setGeometry(self, x: int, y: int, w: int, h: int): ...
    def setGraphicsEffect(self, effect: PySide2.QtWidgets.QGraphicsEffect): ...
    def setHidden(self, hidden: bool): ...
    def setInputMethodHints(self, hints: PySide2.QtCore.Qt.InputMethodHints): ...
    def setLayout(self, arg__1: PySide2.QtWidgets.QLayout): ...
    def setLayoutDirection(self, direction: PySide2.QtCore.Qt.LayoutDirection): ...
    def setLocale(self, locale: PySide2.QtCore.QLocale): ...
    @typing.overload
    def setMask(self, arg__1: PySide2.QtGui.QBitmap): ...
    @typing.overload
    def setMask(self, arg__1: PySide2.QtGui.QRegion): ...
    def setMaximumHeight(self, maxh: int): ...
    @typing.overload
    def setMaximumSize(self, arg__1: PySide2.QtCore.QSize): ...
    @typing.overload
    def setMaximumSize(self, maxw: int, maxh: int): ...
    def setMaximumWidth(self, maxw: int): ...
    def setMinimumHeight(self, minh: int): ...
    @typing.overload
    def setMinimumSize(self, arg__1: PySide2.QtCore.QSize): ...
    @typing.overload
    def setMinimumSize(self, minw: int, minh: int): ...
    def setMinimumWidth(self, minw: int): ...
    def setMouseTracking(self, enable: bool): ...
    def setPalette(self, arg__1: PySide2.QtGui.QPalette): ...
    @typing.overload
    def setParent(self, parent: PySide2.QtWidgets.QWidget): ...
    @typing.overload
    def setParent(self, parent: PySide2.QtWidgets.QWidget, f: PySide2.QtCore.Qt.WindowFlags): ...
    def setShortcutAutoRepeat(self, id: int, enable: bool = ...): ...
    def setShortcutEnabled(self, id: int, enable: bool = ...): ...
    @typing.overload
    def setSizeIncrement(self, arg__1: PySide2.QtCore.QSize): ...
    @typing.overload
    def setSizeIncrement(self, w: int, h: int): ...
    @typing.overload
    def setSizePolicy(self, arg__1: PySide2.QtWidgets.QSizePolicy): ...
    @typing.overload
    def setSizePolicy(self, horizontal: PySide2.QtWidgets.QSizePolicy.Policy, vertical: PySide2.QtWidgets.QSizePolicy.Policy): ...
    def setStatusTip(self, arg__1: str): ...
    def setStyle(self, arg__1: PySide2.QtWidgets.QStyle): ...
    def setStyleSheet(self, styleSheet: str): ...
    @staticmethod
    def setTabOrder(arg__1: PySide2.QtWidgets.QWidget, arg__2: PySide2.QtWidgets.QWidget): ...
    def setTabletTracking(self, enable: bool): ...
    def setToolTip(self, arg__1: str): ...
    def setToolTipDuration(self, msec: int): ...
    def setUpdatesEnabled(self, enable: bool): ...
    def setVisible(self, visible: bool): ...
    def setWhatsThis(self, arg__1: str): ...
    def setWindowFilePath(self, filePath: str): ...
    def setWindowFlag(self, arg__1: PySide2.QtCore.Qt.WindowType, on: bool = ...): ...
    def setWindowFlags(self, type: PySide2.QtCore.Qt.WindowFlags): ...
    def setWindowIcon(self, icon: PySide2.QtGui.QIcon): ...
    def setWindowIconText(self, arg__1: str): ...
    def setWindowModality(self, windowModality: PySide2.QtCore.Qt.WindowModality): ...
    def setWindowModified(self, arg__1: bool): ...
    def setWindowOpacity(self, level: float): ...
    def setWindowRole(self, arg__1: str): ...
    def setWindowState(self, state: PySide2.QtCore.Qt.WindowStates): ...
    def setWindowTitle(self, arg__1: str): ...
    def sharedPainter(self) -> PySide2.QtGui.QPainter: ...
    def show(self): ...
    def showEvent(self, event: PySide2.QtGui.QShowEvent): ...
    def showFullScreen(self): ...
    def showMaximized(self): ...
    def showMinimized(self): ...
    def showNormal(self): ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sizeIncrement(self) -> PySide2.QtCore.QSize: ...
    def sizePolicy(self) -> PySide2.QtWidgets.QSizePolicy: ...
    def stackUnder(self, arg__1: PySide2.QtWidgets.QWidget): ...
    def statusTip(self) -> str: ...
    def style(self) -> PySide2.QtWidgets.QStyle: ...
    def styleSheet(self) -> str: ...
    def tabletEvent(self, event: PySide2.QtGui.QTabletEvent): ...
    def testAttribute(self, arg__1: PySide2.QtCore.Qt.WidgetAttribute) -> bool: ...
    def toolTip(self) -> str: ...
    def toolTipDuration(self) -> int: ...
    def topLevelWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def underMouse(self) -> bool: ...
    def ungrabGesture(self, type: PySide2.QtCore.Qt.GestureType): ...
    def unsetCursor(self): ...
    def unsetLayoutDirection(self): ...
    def unsetLocale(self): ...
    @typing.overload
    def update(self): ...
    @typing.overload
    def update(self, arg__1: PySide2.QtCore.QRect): ...
    @typing.overload
    def update(self, arg__1: PySide2.QtGui.QRegion): ...
    @typing.overload
    def update(self, x: int, y: int, w: int, h: int): ...
    def updateGeometry(self): ...
    def updateMicroFocus(self): ...
    def updatesEnabled(self) -> bool: ...
    def visibleRegion(self) -> PySide2.QtGui.QRegion: ...
    def whatsThis(self) -> str: ...
    def wheelEvent(self, event: PySide2.QtGui.QWheelEvent): ...
    def width(self) -> int: ...
    def winId(self) -> int: ...
    def window(self) -> PySide2.QtWidgets.QWidget: ...
    def windowFilePath(self) -> str: ...
    def windowFlags(self) -> PySide2.QtCore.Qt.WindowFlags: ...
    def windowHandle(self) -> PySide2.QtGui.QWindow: ...
    def windowIcon(self) -> PySide2.QtGui.QIcon: ...
    def windowIconText(self) -> str: ...
    def windowModality(self) -> PySide2.QtCore.Qt.WindowModality: ...
    def windowOpacity(self) -> float: ...
    def windowRole(self) -> str: ...
    def windowState(self) -> PySide2.QtCore.Qt.WindowStates: ...
    def windowTitle(self) -> str: ...
    def windowType(self) -> PySide2.QtCore.Qt.WindowType: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QWidgetAction(PySide2.QtWidgets.QAction):

    def __init__(self, parent: PySide2.QtCore.QObject): ...
    def createWidget(self, parent: PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QWidget: ...
    def createdWidgets(self) -> typing.List[PySide2.QtWidgets.QWidget]: ...
    def defaultWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def deleteWidget(self, widget: PySide2.QtWidgets.QWidget): ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    def releaseWidget(self, widget: PySide2.QtWidgets.QWidget): ...
    def requestWidget(self, parent: PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QWidget: ...
    def setDefaultWidget(self, w: PySide2.QtWidgets.QWidget): ...


class QWidgetItem(PySide2.QtWidgets.QLayoutItem):

    def __init__(self, w: PySide2.QtWidgets.QWidget): ...
    def controlTypes(self) -> PySide2.QtWidgets.QSizePolicy.ControlTypes: ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def isEmpty(self) -> bool: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def setGeometry(self, arg__1: PySide2.QtCore.QRect): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QWizard(PySide2.QtWidgets.QDialog):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...): ...
    def addPage(self, page: PySide2.QtWidgets.QWizardPage) -> int: ...
    def back(self): ...
    def button(self, which: PySide2.QtWidgets.QWizard.WizardButton) -> PySide2.QtWidgets.QAbstractButton: ...
    def buttonText(self, which: PySide2.QtWidgets.QWizard.WizardButton) -> str: ...
    def cleanupPage(self, id: int): ...
    def currentId(self) -> int: ...
    def currentPage(self) -> PySide2.QtWidgets.QWizardPage: ...
    def done(self, result: int): ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def field(self, name: str) -> typing.Any: ...
    def hasVisitedPage(self, id: int) -> bool: ...
    def initializePage(self, id: int): ...
    def next(self): ...
    def nextId(self) -> int: ...
    def options(self) -> PySide2.QtWidgets.QWizard.WizardOptions: ...
    def page(self, id: int) -> PySide2.QtWidgets.QWizardPage: ...
    def pageIds(self) -> typing.List[int]: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent): ...
    def pixmap(self, which: PySide2.QtWidgets.QWizard.WizardPixmap) -> PySide2.QtGui.QPixmap: ...
    def removePage(self, id: int): ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent): ...
    def restart(self): ...
    def setButton(self, which: PySide2.QtWidgets.QWizard.WizardButton, button: PySide2.QtWidgets.QAbstractButton): ...
    def setButtonLayout(self, layout: typing.List[PySide2.QtWidgets.QWizard.WizardButton]): ...
    def setButtonText(self, which: PySide2.QtWidgets.QWizard.WizardButton, text: str): ...
    def setDefaultProperty(self, className: str, property: str, changedSignal: str): ...
    def setField(self, name: str, value: typing.Any): ...
    def setOption(self, option: PySide2.QtWidgets.QWizard.WizardOption, on: bool = ...): ...
    def setOptions(self, options: PySide2.QtWidgets.QWizard.WizardOptions): ...
    def setPage(self, id: int, page: PySide2.QtWidgets.QWizardPage): ...
    def setPixmap(self, which: PySide2.QtWidgets.QWizard.WizardPixmap, pixmap: PySide2.QtGui.QPixmap): ...
    def setSideWidget(self, widget: PySide2.QtWidgets.QWidget): ...
    def setStartId(self, id: int): ...
    def setSubTitleFormat(self, format: PySide2.QtCore.Qt.TextFormat): ...
    def setTitleFormat(self, format: PySide2.QtCore.Qt.TextFormat): ...
    def setVisible(self, visible: bool): ...
    def setWizardStyle(self, style: PySide2.QtWidgets.QWizard.WizardStyle): ...
    def sideWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def startId(self) -> int: ...
    def subTitleFormat(self) -> PySide2.QtCore.Qt.TextFormat: ...
    def testOption(self, option: PySide2.QtWidgets.QWizard.WizardOption) -> bool: ...
    def titleFormat(self) -> PySide2.QtCore.Qt.TextFormat: ...
    def validateCurrentPage(self) -> bool: ...
    def visitedPages(self) -> typing.List[int]: ...
    def wizardStyle(self) -> PySide2.QtWidgets.QWizard.WizardStyle: ...


class QWizardPage(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def buttonText(self, which: PySide2.QtWidgets.QWizard.WizardButton) -> str: ...
    def cleanupPage(self): ...
    def field(self, name: str) -> typing.Any: ...
    def initializePage(self): ...
    def isCommitPage(self) -> bool: ...
    def isComplete(self) -> bool: ...
    def isFinalPage(self) -> bool: ...
    def nextId(self) -> int: ...
    def pixmap(self, which: PySide2.QtWidgets.QWizard.WizardPixmap) -> PySide2.QtGui.QPixmap: ...
    def registerField(self, name: str, widget: PySide2.QtWidgets.QWidget, property: str = ..., changedSignal: str = ...): ...
    def setButtonText(self, which: PySide2.QtWidgets.QWizard.WizardButton, text: str): ...
    def setCommitPage(self, commitPage: bool): ...
    def setField(self, name: str, value: typing.Any): ...
    def setFinalPage(self, finalPage: bool): ...
    def setPixmap(self, which: PySide2.QtWidgets.QWizard.WizardPixmap, pixmap: PySide2.QtGui.QPixmap): ...
    def setSubTitle(self, subTitle: str): ...
    def setTitle(self, title: str): ...
    def subTitle(self) -> str: ...
    def title(self) -> str: ...
    def validatePage(self) -> bool: ...
    def wizard(self) -> PySide2.QtWidgets.QWizard: ...

# eof
