# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2019 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtGui, except for defaults which are replaced by "...".
"""

# Module PySide2.QtGui
import PySide2
from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken2 as Shiboken
Shiboken.Object = Object

import PySide2.QtGui


def qAlpha(rgb: int) -> int: ...
def qBlue(rgb: int) -> int: ...
@typing.overload
def qGray(r: int, g: int, b: int) -> int: ...
@typing.overload
def qGray(rgb: int) -> int: ...
def qGreen(rgb: int) -> int: ...
def qIsGray(rgb: int) -> bool: ...
def qRed(rgb: int) -> int: ...
def qRgb(r: int, g: int, b: int) -> int: ...
def qRgba(r: int, g: int, b: int, a: int) -> int: ...


class QAbstractOpenGLFunctions(Shiboken.Object):

    def __init__(self): ...
    def initializeOpenGLFunctions(self) -> bool: ...
    def isInitialized(self) -> bool: ...
    def owningContext(self) -> PySide2.QtGui.QOpenGLContext: ...
    def setOwningContext(self, context: PySide2.QtGui.QOpenGLContext): ...


class QAbstractTextDocumentLayout(PySide2.QtCore.QObject):

    def __init__(self, doc: PySide2.QtGui.QTextDocument): ...
    def anchorAt(self, pos: PySide2.QtCore.QPointF) -> str: ...
    def blockBoundingRect(self, block: PySide2.QtGui.QTextBlock) -> PySide2.QtCore.QRectF: ...
    def document(self) -> PySide2.QtGui.QTextDocument: ...
    def documentChanged(self, from_: int, charsRemoved: int, charsAdded: int): ...
    def documentSize(self) -> PySide2.QtCore.QSizeF: ...
    def draw(self, painter: PySide2.QtGui.QPainter, context: PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext): ...
    def drawInlineObject(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRectF, object: PySide2.QtGui.QTextInlineObject, posInDocument: int, format: PySide2.QtGui.QTextFormat): ...
    def format(self, pos: int) -> PySide2.QtGui.QTextCharFormat: ...
    def formatAt(self, pos: PySide2.QtCore.QPointF) -> PySide2.QtGui.QTextFormat: ...
    def formatIndex(self, pos: int) -> int: ...
    def frameBoundingRect(self, frame: PySide2.QtGui.QTextFrame) -> PySide2.QtCore.QRectF: ...
    def handlerForObject(self, objectType: int) -> PySide2.QtGui.QTextObjectInterface: ...
    def hitTest(self, point: PySide2.QtCore.QPointF, accuracy: PySide2.QtCore.Qt.HitTestAccuracy) -> int: ...
    def imageAt(self, pos: PySide2.QtCore.QPointF) -> str: ...
    def pageCount(self) -> int: ...
    def paintDevice(self) -> PySide2.QtGui.QPaintDevice: ...
    def positionInlineObject(self, item: PySide2.QtGui.QTextInlineObject, posInDocument: int, format: PySide2.QtGui.QTextFormat): ...
    def registerHandler(self, objectType: int, component: PySide2.QtCore.QObject): ...
    def resizeInlineObject(self, item: PySide2.QtGui.QTextInlineObject, posInDocument: int, format: PySide2.QtGui.QTextFormat): ...
    def setPaintDevice(self, device: PySide2.QtGui.QPaintDevice): ...
    def unregisterHandler(self, objectType: int, component: PySide2.QtCore.QObject = ...): ...

    class PaintContext(Shiboken.Object):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, PaintContext: PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext): ...
        def __copy__(self): ...

    class Selection(Shiboken.Object):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, Selection: PySide2.QtGui.QAbstractTextDocumentLayout.Selection): ...
        def __copy__(self): ...


class QAccessible(Shiboken.Object):

    def __copy__(self): ...
    @staticmethod
    def accessibleInterface(uniqueId: int) -> PySide2.QtGui.QAccessibleInterface: ...
    @staticmethod
    def cleanup(): ...
    @staticmethod
    def deleteAccessibleInterface(uniqueId: int): ...
    @staticmethod
    def isActive() -> bool: ...
    @staticmethod
    def qAccessibleTextBoundaryHelper(cursor: PySide2.QtGui.QTextCursor, boundaryType: PySide2.QtGui.QAccessible.TextBoundaryType) -> typing.Tuple: ...
    @staticmethod
    def queryAccessibleInterface(arg__1: PySide2.QtCore.QObject) -> PySide2.QtGui.QAccessibleInterface: ...
    @staticmethod
    def registerAccessibleInterface(iface: PySide2.QtGui.QAccessibleInterface) -> int: ...
    @staticmethod
    def setActive(active: bool): ...
    @staticmethod
    def setRootObject(object: PySide2.QtCore.QObject): ...
    @staticmethod
    def uniqueId(iface: PySide2.QtGui.QAccessibleInterface) -> int: ...
    @staticmethod
    def updateAccessibility(event: PySide2.QtGui.QAccessibleEvent): ...

    class State(Shiboken.Object):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, State: PySide2.QtGui.QAccessible.State): ...
        def __copy__(self): ...


class QAccessibleEditableTextInterface(Shiboken.Object):

    def __init__(self): ...
    def deleteText(self, startOffset: int, endOffset: int): ...
    def insertText(self, offset: int, text: str): ...
    def replaceText(self, startOffset: int, endOffset: int, text: str): ...


class QAccessibleEvent(Shiboken.Object):

    @typing.overload
    def __init__(self, iface: PySide2.QtGui.QAccessibleInterface, typ: PySide2.QtGui.QAccessible.Event): ...
    @typing.overload
    def __init__(self, obj: PySide2.QtCore.QObject, typ: PySide2.QtGui.QAccessible.Event): ...
    def accessibleInterface(self) -> PySide2.QtGui.QAccessibleInterface: ...
    def child(self) -> int: ...
    def object(self) -> PySide2.QtCore.QObject: ...
    def setChild(self, chld: int): ...
    def type(self) -> PySide2.QtGui.QAccessible.Event: ...
    def uniqueId(self) -> int: ...


class QAccessibleInterface(Shiboken.Object):

    def __init__(self): ...
    def backgroundColor(self) -> PySide2.QtGui.QColor: ...
    def child(self, index: int) -> PySide2.QtGui.QAccessibleInterface: ...
    def childAt(self, x: int, y: int) -> PySide2.QtGui.QAccessibleInterface: ...
    def childCount(self) -> int: ...
    def editableTextInterface(self) -> PySide2.QtGui.QAccessibleEditableTextInterface: ...
    def focusChild(self) -> PySide2.QtGui.QAccessibleInterface: ...
    def foregroundColor(self) -> PySide2.QtGui.QColor: ...
    def indexOfChild(self, arg__1: PySide2.QtGui.QAccessibleInterface) -> int: ...
    def interface_cast(self, arg__1: PySide2.QtGui.QAccessible.InterfaceType) -> int: ...
    def isValid(self) -> bool: ...
    def object(self) -> PySide2.QtCore.QObject: ...
    def parent(self) -> PySide2.QtGui.QAccessibleInterface: ...
    def rect(self) -> PySide2.QtCore.QRect: ...
    def relations(self, match: PySide2.QtGui.QAccessible.Relation = ...) -> typing.List[typing.Tuple]: ...
    def role(self) -> PySide2.QtGui.QAccessible.Role: ...
    def setText(self, t: PySide2.QtGui.QAccessible.Text, text: str): ...
    def state(self) -> PySide2.QtGui.QAccessible.State: ...
    def tableCellInterface(self) -> PySide2.QtGui.QAccessibleTableCellInterface: ...
    def text(self, t: PySide2.QtGui.QAccessible.Text) -> str: ...
    def textInterface(self) -> PySide2.QtGui.QAccessibleTextInterface: ...
    def valueInterface(self) -> PySide2.QtGui.QAccessibleValueInterface: ...
    def virtual_hook(self, id: int, data: int): ...
    def window(self) -> PySide2.QtGui.QWindow: ...


class QAccessibleObject(PySide2.QtGui.QAccessibleInterface):

    def __init__(self, object: PySide2.QtCore.QObject): ...
    def childAt(self, x: int, y: int) -> PySide2.QtGui.QAccessibleInterface: ...
    def isValid(self) -> bool: ...
    def object(self) -> PySide2.QtCore.QObject: ...
    def rect(self) -> PySide2.QtCore.QRect: ...
    def setText(self, t: PySide2.QtGui.QAccessible.Text, text: str): ...


class QAccessibleStateChangeEvent(PySide2.QtGui.QAccessibleEvent):

    @typing.overload
    def __init__(self, iface: PySide2.QtGui.QAccessibleInterface, state: PySide2.QtGui.QAccessible.State): ...
    @typing.overload
    def __init__(self, obj: PySide2.QtCore.QObject, state: PySide2.QtGui.QAccessible.State): ...
    def changedStates(self) -> PySide2.QtGui.QAccessible.State: ...


class QAccessibleTableCellInterface(Shiboken.Object):

    def __init__(self): ...
    def columnExtent(self) -> int: ...
    def columnHeaderCells(self) -> typing.List[PySide2.QtGui.QAccessibleInterface]: ...
    def columnIndex(self) -> int: ...
    def isSelected(self) -> bool: ...
    def rowExtent(self) -> int: ...
    def rowHeaderCells(self) -> typing.List[PySide2.QtGui.QAccessibleInterface]: ...
    def rowIndex(self) -> int: ...
    def table(self) -> PySide2.QtGui.QAccessibleInterface: ...


class QAccessibleTableModelChangeEvent(PySide2.QtGui.QAccessibleEvent):

    @typing.overload
    def __init__(self, iface: PySide2.QtGui.QAccessibleInterface, changeType: PySide2.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType): ...
    @typing.overload
    def __init__(self, obj: PySide2.QtCore.QObject, changeType: PySide2.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType): ...
    def firstColumn(self) -> int: ...
    def firstRow(self) -> int: ...
    def lastColumn(self) -> int: ...
    def lastRow(self) -> int: ...
    def modelChangeType(self) -> PySide2.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType: ...
    def setFirstColumn(self, col: int): ...
    def setFirstRow(self, row: int): ...
    def setLastColumn(self, col: int): ...
    def setLastRow(self, row: int): ...
    def setModelChangeType(self, changeType: PySide2.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType): ...


class QAccessibleTextCursorEvent(PySide2.QtGui.QAccessibleEvent):

    @typing.overload
    def __init__(self, iface: PySide2.QtGui.QAccessibleInterface, cursorPos: int): ...
    @typing.overload
    def __init__(self, obj: PySide2.QtCore.QObject, cursorPos: int): ...
    def cursorPosition(self) -> int: ...
    def setCursorPosition(self, position: int): ...


class QAccessibleTextInsertEvent(PySide2.QtGui.QAccessibleTextCursorEvent):

    @typing.overload
    def __init__(self, iface: PySide2.QtGui.QAccessibleInterface, position: int, text: str): ...
    @typing.overload
    def __init__(self, obj: PySide2.QtCore.QObject, position: int, text: str): ...
    def changePosition(self) -> int: ...
    def textInserted(self) -> str: ...


class QAccessibleTextInterface(Shiboken.Object):

    def __init__(self): ...
    def addSelection(self, startOffset: int, endOffset: int): ...
    def attributes(self, offset: int, startOffset: int, endOffset: int) -> str: ...
    def characterCount(self) -> int: ...
    def characterRect(self, offset: int) -> PySide2.QtCore.QRect: ...
    def cursorPosition(self) -> int: ...
    def offsetAtPoint(self, point: PySide2.QtCore.QPoint) -> int: ...
    def removeSelection(self, selectionIndex: int): ...
    def scrollToSubstring(self, startIndex: int, endIndex: int): ...
    def selection(self, selectionIndex: int, startOffset: int, endOffset: int): ...
    def selectionCount(self) -> int: ...
    def setCursorPosition(self, position: int): ...
    def setSelection(self, selectionIndex: int, startOffset: int, endOffset: int): ...
    def text(self, startOffset: int, endOffset: int) -> str: ...
    def textAfterOffset(self, offset: int, boundaryType: PySide2.QtGui.QAccessible.TextBoundaryType, startOffset: int, endOffset: int) -> str: ...
    def textAtOffset(self, offset: int, boundaryType: PySide2.QtGui.QAccessible.TextBoundaryType, startOffset: int, endOffset: int) -> str: ...
    def textBeforeOffset(self, offset: int, boundaryType: PySide2.QtGui.QAccessible.TextBoundaryType, startOffset: int, endOffset: int) -> str: ...


class QAccessibleTextRemoveEvent(PySide2.QtGui.QAccessibleTextCursorEvent):

    @typing.overload
    def __init__(self, iface: PySide2.QtGui.QAccessibleInterface, position: int, text: str): ...
    @typing.overload
    def __init__(self, obj: PySide2.QtCore.QObject, position: int, text: str): ...
    def changePosition(self) -> int: ...
    def textRemoved(self) -> str: ...


class QAccessibleTextSelectionEvent(PySide2.QtGui.QAccessibleTextCursorEvent):

    @typing.overload
    def __init__(self, iface: PySide2.QtGui.QAccessibleInterface, start: int, end: int): ...
    @typing.overload
    def __init__(self, obj: PySide2.QtCore.QObject, start: int, end: int): ...
    def selectionEnd(self) -> int: ...
    def selectionStart(self) -> int: ...
    def setSelection(self, start: int, end: int): ...


class QAccessibleTextUpdateEvent(PySide2.QtGui.QAccessibleTextCursorEvent):

    @typing.overload
    def __init__(self, iface: PySide2.QtGui.QAccessibleInterface, position: int, oldText: str, text: str): ...
    @typing.overload
    def __init__(self, obj: PySide2.QtCore.QObject, position: int, oldText: str, text: str): ...
    def changePosition(self) -> int: ...
    def textInserted(self) -> str: ...
    def textRemoved(self) -> str: ...


class QAccessibleValueChangeEvent(PySide2.QtGui.QAccessibleEvent):

    @typing.overload
    def __init__(self, iface: PySide2.QtGui.QAccessibleInterface, val: typing.Any): ...
    @typing.overload
    def __init__(self, obj: PySide2.QtCore.QObject, val: typing.Any): ...
    def setValue(self, val: typing.Any): ...
    def value(self) -> typing.Any: ...


class QAccessibleValueInterface(Shiboken.Object):

    def __init__(self): ...
    def currentValue(self) -> typing.Any: ...
    def maximumValue(self) -> typing.Any: ...
    def minimumStepSize(self) -> typing.Any: ...
    def minimumValue(self) -> typing.Any: ...
    def setCurrentValue(self, value: typing.Any): ...


class QActionEvent: ...


class QBackingStore(Shiboken.Object):

    def __init__(self, window: PySide2.QtGui.QWindow): ...
    def beginPaint(self, arg__1: PySide2.QtGui.QRegion): ...
    def endPaint(self): ...
    def flush(self, region: PySide2.QtGui.QRegion, window: PySide2.QtGui.QWindow = ..., offset: PySide2.QtCore.QPoint = ...): ...
    def hasStaticContents(self) -> bool: ...
    def paintDevice(self) -> PySide2.QtGui.QPaintDevice: ...
    def resize(self, size: PySide2.QtCore.QSize): ...
    def scroll(self, area: PySide2.QtGui.QRegion, dx: int, dy: int) -> bool: ...
    def setStaticContents(self, region: PySide2.QtGui.QRegion): ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def staticContents(self) -> PySide2.QtGui.QRegion: ...
    def window(self) -> PySide2.QtGui.QWindow: ...


class QBitmap(PySide2.QtGui.QPixmap):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QSize): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QPixmap): ...
    @typing.overload
    def __init__(self, fileName: str, format: str = ...): ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QBitmap): ...
    @typing.overload
    def __init__(self, w: int, h: int): ...
    def __copy__(self): ...
    def clear(self): ...
    @staticmethod
    def fromData(size: PySide2.QtCore.QSize, bits: typing.Char, monoFormat: PySide2.QtGui.QImage.Format = ...) -> PySide2.QtGui.QBitmap: ...
    @typing.overload
    @staticmethod
    def fromImage(image: PySide2.QtGui.QImage, flags: PySide2.QtCore.Qt.ImageConversionFlags = ...) -> PySide2.QtGui.QBitmap: ...
    @typing.overload
    @staticmethod
    def fromImage(image: PySide2.QtGui.QImage, flags: PySide2.QtCore.Qt.ImageConversionFlags = ...) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def swap(self, other: PySide2.QtGui.QBitmap): ...
    @typing.overload
    def swap(self, other: PySide2.QtGui.QPixmap): ...
    @typing.overload
    def transformed(self, arg__1: PySide2.QtGui.QMatrix) -> PySide2.QtGui.QBitmap: ...
    @typing.overload
    def transformed(self, arg__1: PySide2.QtGui.QMatrix, mode: PySide2.QtCore.Qt.TransformationMode = ...) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def transformed(self, matrix: PySide2.QtGui.QTransform) -> PySide2.QtGui.QBitmap: ...


class QBrush(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, brush: PySide2.QtGui.QBrush): ...
    @typing.overload
    def __init__(self, bs: PySide2.QtCore.Qt.BrushStyle): ...
    @typing.overload
    def __init__(self, color: PySide2.QtCore.Qt.GlobalColor, bs: PySide2.QtCore.Qt.BrushStyle = ...): ...
    @typing.overload
    def __init__(self, color: PySide2.QtCore.Qt.GlobalColor, pixmap: PySide2.QtGui.QPixmap): ...
    @typing.overload
    def __init__(self, color: PySide2.QtGui.QColor, bs: PySide2.QtCore.Qt.BrushStyle = ...): ...
    @typing.overload
    def __init__(self, color: PySide2.QtGui.QColor, pixmap: PySide2.QtGui.QPixmap): ...
    @typing.overload
    def __init__(self, gradient: PySide2.QtGui.QGradient): ...
    @typing.overload
    def __init__(self, image: PySide2.QtGui.QImage): ...
    @typing.overload
    def __init__(self, pixmap: PySide2.QtGui.QPixmap): ...
    def __copy__(self): ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def color(self) -> PySide2.QtGui.QColor: ...
    def gradient(self) -> PySide2.QtGui.QGradient: ...
    def isOpaque(self) -> bool: ...
    def matrix(self) -> PySide2.QtGui.QMatrix: ...
    @typing.overload
    def setColor(self, color: PySide2.QtCore.Qt.GlobalColor): ...
    @typing.overload
    def setColor(self, color: PySide2.QtGui.QColor): ...
    def setMatrix(self, mat: PySide2.QtGui.QMatrix): ...
    def setStyle(self, arg__1: PySide2.QtCore.Qt.BrushStyle): ...
    def setTexture(self, pixmap: PySide2.QtGui.QPixmap): ...
    def setTextureImage(self, image: PySide2.QtGui.QImage): ...
    def setTransform(self, arg__1: PySide2.QtGui.QTransform): ...
    def style(self) -> PySide2.QtCore.Qt.BrushStyle: ...
    def swap(self, other: PySide2.QtGui.QBrush): ...
    def texture(self) -> PySide2.QtGui.QPixmap: ...
    def textureImage(self) -> PySide2.QtGui.QImage: ...
    def transform(self) -> PySide2.QtGui.QTransform: ...


class QClipboard(PySide2.QtCore.QObject):

    def clear(self, mode: PySide2.QtGui.QClipboard.Mode = ...): ...
    def image(self, mode: PySide2.QtGui.QClipboard.Mode = ...) -> PySide2.QtGui.QImage: ...
    def mimeData(self, mode: PySide2.QtGui.QClipboard.Mode = ...) -> PySide2.QtCore.QMimeData: ...
    def ownsClipboard(self) -> bool: ...
    def ownsFindBuffer(self) -> bool: ...
    def ownsSelection(self) -> bool: ...
    def pixmap(self, mode: PySide2.QtGui.QClipboard.Mode = ...) -> PySide2.QtGui.QPixmap: ...
    def setImage(self, arg__1: PySide2.QtGui.QImage, mode: PySide2.QtGui.QClipboard.Mode = ...): ...
    def setMimeData(self, data: PySide2.QtCore.QMimeData, mode: PySide2.QtGui.QClipboard.Mode = ...): ...
    def setPixmap(self, arg__1: PySide2.QtGui.QPixmap, mode: PySide2.QtGui.QClipboard.Mode = ...): ...
    def setText(self, arg__1: str, mode: PySide2.QtGui.QClipboard.Mode = ...): ...
    def supportsFindBuffer(self) -> bool: ...
    def supportsSelection(self) -> bool: ...
    @typing.overload
    def text(self, mode: PySide2.QtGui.QClipboard.Mode = ...) -> str: ...
    @typing.overload
    def text(self, subtype: str, mode: PySide2.QtGui.QClipboard.Mode = ...) -> str: ...


class QCloseEvent(PySide2.QtCore.QEvent):

    def __init__(self): ...


class QColor(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arg__1: typing.Any): ...
    @typing.overload
    def __init__(self, color: PySide2.QtCore.Qt.GlobalColor): ...
    @typing.overload
    def __init__(self, color: PySide2.QtGui.QColor): ...
    @typing.overload
    def __init__(self, name: str): ...
    @typing.overload
    def __init__(self, r: int, g: int, b: int, a: int = ...): ...
    @typing.overload
    def __init__(self, rgb: int): ...
    def __copy__(self): ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __setstate__(self, arg__1: object) -> object: ...
    def __str__(self) -> object: ...
    def alpha(self) -> int: ...
    def alphaF(self) -> float: ...
    def black(self) -> int: ...
    def blackF(self) -> float: ...
    def blue(self) -> int: ...
    def blueF(self) -> float: ...
    @staticmethod
    def colorNames() -> typing.List[str]: ...
    def convertTo(self, colorSpec: PySide2.QtGui.QColor.Spec) -> PySide2.QtGui.QColor: ...
    def cyan(self) -> int: ...
    def cyanF(self) -> float: ...
    def dark(self, f: int = ...) -> PySide2.QtGui.QColor: ...
    def darker(self, f: int = ...) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def fromCmyk(c: int, m: int, y: int, k: int, a: int = ...) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def fromCmykF(c: float, m: float, y: float, k: float, a: float = ...) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def fromHsl(h: int, s: int, l: int, a: int = ...) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def fromHslF(h: float, s: float, l: float, a: float = ...) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def fromHsv(h: int, s: int, v: int, a: int = ...) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def fromHsvF(h: float, s: float, v: float, a: float = ...) -> PySide2.QtGui.QColor: ...
    @typing.overload
    @staticmethod
    def fromRgb(r: int, g: int, b: int, a: int = ...) -> PySide2.QtGui.QColor: ...
    @typing.overload
    @staticmethod
    def fromRgb(rgb: int) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def fromRgbF(r: float, g: float, b: float, a: float = ...) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def fromRgba(rgba: int) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def fromRgba64(r: int, g: int, b: int, a: int = ...) -> PySide2.QtGui.QColor: ...
    def getCmyk(self, c: int, m: int, y: int, k: int, a: int): ...
    def getCmykF(self, c: float, m: float, y: float, k: float, a: float): ...
    def getHsl(self, h: int, s: int, l: int, a: int): ...
    def getHslF(self, h: float, s: float, l: float, a: float): ...
    def getHsv(self, h: int, s: int, v: int, a: int): ...
    def getHsvF(self, h: float, s: float, v: float, a: float): ...
    def getRgb(self, r: int, g: int, b: int, a: int): ...
    def getRgbF(self, r: float, g: float, b: float, a: float): ...
    def green(self) -> int: ...
    def greenF(self) -> float: ...
    def hslHue(self) -> int: ...
    def hslHueF(self) -> float: ...
    def hslSaturation(self) -> int: ...
    def hslSaturationF(self) -> float: ...
    def hsvHue(self) -> int: ...
    def hsvHueF(self) -> float: ...
    def hsvSaturation(self) -> int: ...
    def hsvSaturationF(self) -> float: ...
    def hue(self) -> int: ...
    def hueF(self) -> float: ...
    def isValid(self) -> bool: ...
    @staticmethod
    def isValidColor(name: str) -> bool: ...
    def light(self, f: int = ...) -> PySide2.QtGui.QColor: ...
    def lighter(self, f: int = ...) -> PySide2.QtGui.QColor: ...
    def lightness(self) -> int: ...
    def lightnessF(self) -> float: ...
    def magenta(self) -> int: ...
    def magentaF(self) -> float: ...
    @typing.overload
    def name(self) -> str: ...
    @typing.overload
    def name(self, format: PySide2.QtGui.QColor.NameFormat) -> str: ...
    def red(self) -> int: ...
    def redF(self) -> float: ...
    def rgb(self) -> int: ...
    def rgba(self) -> int: ...
    def saturation(self) -> int: ...
    def saturationF(self) -> float: ...
    def setAlpha(self, alpha: int): ...
    def setAlphaF(self, alpha: float): ...
    def setBlue(self, blue: int): ...
    def setBlueF(self, blue: float): ...
    def setCmyk(self, c: int, m: int, y: int, k: int, a: int = ...): ...
    def setCmykF(self, c: float, m: float, y: float, k: float, a: float = ...): ...
    def setGreen(self, green: int): ...
    def setGreenF(self, green: float): ...
    def setHsl(self, h: int, s: int, l: int, a: int = ...): ...
    def setHslF(self, h: float, s: float, l: float, a: float = ...): ...
    def setHsv(self, h: int, s: int, v: int, a: int = ...): ...
    def setHsvF(self, h: float, s: float, v: float, a: float = ...): ...
    def setNamedColor(self, name: str): ...
    def setRed(self, red: int): ...
    def setRedF(self, red: float): ...
    @typing.overload
    def setRgb(self, r: int, g: int, b: int, a: int = ...): ...
    @typing.overload
    def setRgb(self, rgb: int): ...
    def setRgbF(self, r: float, g: float, b: float, a: float = ...): ...
    def setRgba(self, rgba: int): ...
    def spec(self) -> PySide2.QtGui.QColor.Spec: ...
    def toCmyk(self) -> PySide2.QtGui.QColor: ...
    def toHsl(self) -> PySide2.QtGui.QColor: ...
    def toHsv(self) -> PySide2.QtGui.QColor: ...
    def toRgb(self) -> PySide2.QtGui.QColor: ...
    def toTuple(self) -> object: ...
    def value(self) -> int: ...
    def valueF(self) -> float: ...
    def yellow(self) -> int: ...
    def yellowF(self) -> float: ...


class QConicalGradient(PySide2.QtGui.QGradient):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QConicalGradient: PySide2.QtGui.QConicalGradient): ...
    @typing.overload
    def __init__(self, center: PySide2.QtCore.QPointF, startAngle: float): ...
    @typing.overload
    def __init__(self, cx: float, cy: float, startAngle: float): ...
    def __copy__(self): ...
    def angle(self) -> float: ...
    def center(self) -> PySide2.QtCore.QPointF: ...
    def setAngle(self, angle: float): ...
    @typing.overload
    def setCenter(self, center: PySide2.QtCore.QPointF): ...
    @typing.overload
    def setCenter(self, x: float, y: float): ...


class QContextMenuEvent(PySide2.QtGui.QInputEvent):

    @typing.overload
    def __init__(self, reason: PySide2.QtGui.QContextMenuEvent.Reason, pos: PySide2.QtCore.QPoint): ...
    @typing.overload
    def __init__(self, reason: PySide2.QtGui.QContextMenuEvent.Reason, pos: PySide2.QtCore.QPoint, globalPos: PySide2.QtCore.QPoint): ...
    @typing.overload
    def __init__(self, reason: PySide2.QtGui.QContextMenuEvent.Reason, pos: PySide2.QtCore.QPoint, globalPos: PySide2.QtCore.QPoint, modifiers: PySide2.QtCore.Qt.KeyboardModifiers): ...
    def globalPos(self) -> PySide2.QtCore.QPoint: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def reason(self) -> PySide2.QtGui.QContextMenuEvent.Reason: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QCursor(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, bitmap: PySide2.QtGui.QBitmap, mask: PySide2.QtGui.QBitmap, hotX: int = ..., hotY: int = ...): ...
    @typing.overload
    def __init__(self, cursor: PySide2.QtGui.QCursor): ...
    @typing.overload
    def __init__(self, pixmap: PySide2.QtGui.QPixmap, hotX: int = ..., hotY: int = ...): ...
    @typing.overload
    def __init__(self, shape: PySide2.QtCore.Qt.CursorShape): ...
    def __copy__(self): ...
    def __lshift__(self, outS: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, inS: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def bitmap(self) -> PySide2.QtGui.QBitmap: ...
    def hotSpot(self) -> PySide2.QtCore.QPoint: ...
    def mask(self) -> PySide2.QtGui.QBitmap: ...
    def pixmap(self) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    @staticmethod
    def pos() -> PySide2.QtCore.QPoint: ...
    @typing.overload
    @staticmethod
    def pos(screen: PySide2.QtGui.QScreen) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    @staticmethod
    def setPos(p: PySide2.QtCore.QPoint): ...
    @typing.overload
    @staticmethod
    def setPos(screen: PySide2.QtGui.QScreen, p: PySide2.QtCore.QPoint): ...
    @typing.overload
    @staticmethod
    def setPos(screen: PySide2.QtGui.QScreen, x: int, y: int): ...
    @typing.overload
    @staticmethod
    def setPos(x: int, y: int): ...
    def setShape(self, newShape: PySide2.QtCore.Qt.CursorShape): ...
    def shape(self) -> PySide2.QtCore.Qt.CursorShape: ...
    def swap(self, other: PySide2.QtGui.QCursor): ...


class QDesktopServices(Shiboken.Object):

    def __init__(self): ...
    @staticmethod
    def openUrl(url: PySide2.QtCore.QUrl) -> bool: ...
    @staticmethod
    def setUrlHandler(scheme: str, receiver: PySide2.QtCore.QObject, method: str): ...
    @staticmethod
    def unsetUrlHandler(scheme: str): ...


class QDoubleValidator(PySide2.QtGui.QValidator):

    @typing.overload
    def __init__(self, bottom: float, top: float, decimals: int, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def bottom(self) -> float: ...
    def decimals(self) -> int: ...
    def notation(self) -> PySide2.QtGui.QDoubleValidator.Notation: ...
    def setBottom(self, arg__1: float): ...
    def setDecimals(self, arg__1: int): ...
    def setNotation(self, arg__1: PySide2.QtGui.QDoubleValidator.Notation): ...
    def setRange(self, bottom: float, top: float, decimals: int = ...): ...
    def setTop(self, arg__1: float): ...
    def top(self) -> float: ...
    def validate(self, arg__1: str, arg__2: int) -> PySide2.QtGui.QValidator.State: ...


class QDrag(PySide2.QtCore.QObject):

    def __init__(self, dragSource: PySide2.QtCore.QObject): ...
    @staticmethod
    def cancel(): ...
    def defaultAction(self) -> PySide2.QtCore.Qt.DropAction: ...
    def dragCursor(self, action: PySide2.QtCore.Qt.DropAction) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def exec_(self, supportedActions: PySide2.QtCore.Qt.DropActions, defaultAction: PySide2.QtCore.Qt.DropAction) -> PySide2.QtCore.Qt.DropAction: ...
    @typing.overload
    def exec_(self, supportedActions: PySide2.QtCore.Qt.DropActions = ...) -> PySide2.QtCore.Qt.DropAction: ...
    def hotSpot(self) -> PySide2.QtCore.QPoint: ...
    def mimeData(self) -> PySide2.QtCore.QMimeData: ...
    def pixmap(self) -> PySide2.QtGui.QPixmap: ...
    def setDragCursor(self, cursor: PySide2.QtGui.QPixmap, action: PySide2.QtCore.Qt.DropAction): ...
    def setHotSpot(self, hotspot: PySide2.QtCore.QPoint): ...
    def setMimeData(self, data: PySide2.QtCore.QMimeData): ...
    def setPixmap(self, arg__1: PySide2.QtGui.QPixmap): ...
    def source(self) -> PySide2.QtCore.QObject: ...
    def start(self, supportedActions: PySide2.QtCore.Qt.DropActions = ...) -> PySide2.QtCore.Qt.DropAction: ...
    def supportedActions(self) -> PySide2.QtCore.Qt.DropActions: ...
    def target(self) -> PySide2.QtCore.QObject: ...


class QDragEnterEvent(PySide2.QtGui.QDragMoveEvent):

    def __init__(self, pos: PySide2.QtCore.QPoint, actions: PySide2.QtCore.Qt.DropActions, data: PySide2.QtCore.QMimeData, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers): ...


class QDragLeaveEvent(PySide2.QtCore.QEvent):

    def __init__(self): ...


class QDragMoveEvent(PySide2.QtGui.QDropEvent):

    def __init__(self, pos: PySide2.QtCore.QPoint, actions: PySide2.QtCore.Qt.DropActions, data: PySide2.QtCore.QMimeData, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers, type: PySide2.QtCore.QEvent.Type = ...): ...
    @typing.overload
    def accept(self): ...
    @typing.overload
    def accept(self, r: PySide2.QtCore.QRect): ...
    def answerRect(self) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def ignore(self): ...
    @typing.overload
    def ignore(self, r: PySide2.QtCore.QRect): ...


class QDropEvent(PySide2.QtCore.QEvent):

    def __init__(self, pos: PySide2.QtCore.QPointF, actions: PySide2.QtCore.Qt.DropActions, data: PySide2.QtCore.QMimeData, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers, type: PySide2.QtCore.QEvent.Type = ...): ...
    def acceptProposedAction(self): ...
    def dropAction(self) -> PySide2.QtCore.Qt.DropAction: ...
    def keyboardModifiers(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def mimeData(self) -> PySide2.QtCore.QMimeData: ...
    def mouseButtons(self) -> PySide2.QtCore.Qt.MouseButtons: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def posF(self) -> PySide2.QtCore.QPointF: ...
    def possibleActions(self) -> PySide2.QtCore.Qt.DropActions: ...
    def proposedAction(self) -> PySide2.QtCore.Qt.DropAction: ...
    def setDropAction(self, action: PySide2.QtCore.Qt.DropAction): ...
    def source(self) -> PySide2.QtCore.QObject: ...


class QEnterEvent(PySide2.QtCore.QEvent):

    def __init__(self, localPos: PySide2.QtCore.QPointF, windowPos: PySide2.QtCore.QPointF, screenPos: PySide2.QtCore.QPointF): ...
    def globalPos(self) -> PySide2.QtCore.QPoint: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def localPos(self) -> PySide2.QtCore.QPointF: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def screenPos(self) -> PySide2.QtCore.QPointF: ...
    def windowPos(self) -> PySide2.QtCore.QPointF: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QExposeEvent(PySide2.QtCore.QEvent):

    def __init__(self, rgn: PySide2.QtGui.QRegion): ...
    def region(self) -> PySide2.QtGui.QRegion: ...


class QFileOpenEvent(PySide2.QtCore.QEvent):

    @typing.overload
    def __init__(self, file: str): ...
    @typing.overload
    def __init__(self, url: PySide2.QtCore.QUrl): ...
    def file(self) -> str: ...
    def openFile(self, file: PySide2.QtCore.QFile, flags: PySide2.QtCore.QIODevice.OpenMode) -> bool: ...
    def url(self) -> PySide2.QtCore.QUrl: ...


class QFocusEvent(PySide2.QtCore.QEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type, reason: PySide2.QtCore.Qt.FocusReason = ...): ...
    def gotFocus(self) -> bool: ...
    def lostFocus(self) -> bool: ...
    def reason(self) -> PySide2.QtCore.Qt.FocusReason: ...


class QFont(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QFont): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QFont, pd: PySide2.QtGui.QPaintDevice): ...
    @typing.overload
    def __init__(self, family: str, pointSize: int = ..., weight: int = ..., italic: bool = ...): ...
    def __copy__(self): ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def bold(self) -> bool: ...
    @staticmethod
    def cacheStatistics(): ...
    def capitalization(self) -> PySide2.QtGui.QFont.Capitalization: ...
    @staticmethod
    def cleanup(): ...
    def defaultFamily(self) -> str: ...
    def exactMatch(self) -> bool: ...
    def family(self) -> str: ...
    def fixedPitch(self) -> bool: ...
    def fromString(self, arg__1: str) -> bool: ...
    def hintingPreference(self) -> PySide2.QtGui.QFont.HintingPreference: ...
    @staticmethod
    def initialize(): ...
    @staticmethod
    def insertSubstitution(arg__1: str, arg__2: str): ...
    @staticmethod
    def insertSubstitutions(arg__1: str, arg__2: typing.List[str]): ...
    def isCopyOf(self, arg__1: PySide2.QtGui.QFont) -> bool: ...
    def italic(self) -> bool: ...
    def kerning(self) -> bool: ...
    def key(self) -> str: ...
    def lastResortFamily(self) -> str: ...
    def lastResortFont(self) -> str: ...
    def letterSpacing(self) -> float: ...
    def letterSpacingType(self) -> PySide2.QtGui.QFont.SpacingType: ...
    def overline(self) -> bool: ...
    def pixelSize(self) -> int: ...
    def pointSize(self) -> int: ...
    def pointSizeF(self) -> float: ...
    def rawMode(self) -> bool: ...
    def rawName(self) -> str: ...
    @staticmethod
    def removeSubstitutions(arg__1: str): ...
    @typing.overload
    def resolve(self) -> int: ...
    @typing.overload
    def resolve(self, arg__1: PySide2.QtGui.QFont) -> PySide2.QtGui.QFont: ...
    @typing.overload
    def resolve(self, mask: int): ...
    def setBold(self, arg__1: bool): ...
    def setCapitalization(self, arg__1: PySide2.QtGui.QFont.Capitalization): ...
    def setFamily(self, arg__1: str): ...
    def setFixedPitch(self, arg__1: bool): ...
    def setHintingPreference(self, hintingPreference: PySide2.QtGui.QFont.HintingPreference): ...
    def setItalic(self, b: bool): ...
    def setKerning(self, arg__1: bool): ...
    def setLetterSpacing(self, type: PySide2.QtGui.QFont.SpacingType, spacing: float): ...
    def setOverline(self, arg__1: bool): ...
    def setPixelSize(self, arg__1: int): ...
    def setPointSize(self, arg__1: int): ...
    def setPointSizeF(self, arg__1: float): ...
    def setRawMode(self, arg__1: bool): ...
    def setRawName(self, arg__1: str): ...
    def setStretch(self, arg__1: int): ...
    def setStrikeOut(self, arg__1: bool): ...
    def setStyle(self, style: PySide2.QtGui.QFont.Style): ...
    def setStyleHint(self, arg__1: PySide2.QtGui.QFont.StyleHint, strategy: PySide2.QtGui.QFont.StyleStrategy = ...): ...
    def setStyleName(self, arg__1: str): ...
    def setStyleStrategy(self, s: PySide2.QtGui.QFont.StyleStrategy): ...
    def setUnderline(self, arg__1: bool): ...
    def setWeight(self, arg__1: int): ...
    def setWordSpacing(self, spacing: float): ...
    def stretch(self) -> int: ...
    def strikeOut(self) -> bool: ...
    def style(self) -> PySide2.QtGui.QFont.Style: ...
    def styleHint(self) -> PySide2.QtGui.QFont.StyleHint: ...
    def styleName(self) -> str: ...
    def styleStrategy(self) -> PySide2.QtGui.QFont.StyleStrategy: ...
    @staticmethod
    def substitute(arg__1: str) -> str: ...
    @staticmethod
    def substitutes(arg__1: str) -> typing.List[str]: ...
    @staticmethod
    def substitutions() -> typing.List[str]: ...
    def swap(self, other: PySide2.QtGui.QFont): ...
    def toString(self) -> str: ...
    def underline(self) -> bool: ...
    def weight(self) -> int: ...
    def wordSpacing(self) -> float: ...


class QFontDatabase(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QFontDatabase: PySide2.QtGui.QFontDatabase): ...
    def __copy__(self): ...
    @staticmethod
    def addApplicationFont(fileName: str) -> int: ...
    @staticmethod
    def addApplicationFontFromData(fontData: PySide2.QtCore.QByteArray) -> int: ...
    @staticmethod
    def applicationFontFamilies(id: int) -> typing.List[str]: ...
    def bold(self, family: str, style: str) -> bool: ...
    def families(self, writingSystem: PySide2.QtGui.QFontDatabase.WritingSystem = ...) -> typing.List[str]: ...
    def font(self, family: str, style: str, pointSize: int) -> PySide2.QtGui.QFont: ...
    def hasFamily(self, family: str) -> bool: ...
    def isBitmapScalable(self, family: str, style: str = ...) -> bool: ...
    def isFixedPitch(self, family: str, style: str = ...) -> bool: ...
    def isPrivateFamily(self, family: str) -> bool: ...
    def isScalable(self, family: str, style: str = ...) -> bool: ...
    def isSmoothlyScalable(self, family: str, style: str = ...) -> bool: ...
    def italic(self, family: str, style: str) -> bool: ...
    def pointSizes(self, family: str, style: str = ...) -> typing.List[int]: ...
    @staticmethod
    def removeAllApplicationFonts() -> bool: ...
    @staticmethod
    def removeApplicationFont(id: int) -> bool: ...
    def smoothSizes(self, family: str, style: str) -> typing.List[int]: ...
    @staticmethod
    def standardSizes() -> typing.List[int]: ...
    @typing.overload
    def styleString(self, font: PySide2.QtGui.QFont) -> str: ...
    @typing.overload
    def styleString(self, fontInfo: PySide2.QtGui.QFontInfo) -> str: ...
    def styles(self, family: str) -> typing.List[str]: ...
    @staticmethod
    def supportsThreadedFontRendering() -> bool: ...
    @staticmethod
    def systemFont(type: PySide2.QtGui.QFontDatabase.SystemFont) -> PySide2.QtGui.QFont: ...
    def weight(self, family: str, style: str) -> int: ...
    @staticmethod
    def writingSystemName(writingSystem: PySide2.QtGui.QFontDatabase.WritingSystem) -> str: ...
    @staticmethod
    def writingSystemSample(writingSystem: PySide2.QtGui.QFontDatabase.WritingSystem) -> str: ...
    @typing.overload
    def writingSystems(self) -> typing.List[PySide2.QtGui.QFontDatabase.WritingSystem]: ...
    @typing.overload
    def writingSystems(self, family: str) -> typing.List[PySide2.QtGui.QFontDatabase.WritingSystem]: ...


class QFontInfo(Shiboken.Object):

    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QFont): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QFontInfo): ...
    def __copy__(self): ...
    def bold(self) -> bool: ...
    def exactMatch(self) -> bool: ...
    def family(self) -> str: ...
    def fixedPitch(self) -> bool: ...
    def italic(self) -> bool: ...
    def overline(self) -> bool: ...
    def pixelSize(self) -> int: ...
    def pointSize(self) -> int: ...
    def pointSizeF(self) -> float: ...
    def rawMode(self) -> bool: ...
    def strikeOut(self) -> bool: ...
    def style(self) -> PySide2.QtGui.QFont.Style: ...
    def styleHint(self) -> PySide2.QtGui.QFont.StyleHint: ...
    def styleName(self) -> str: ...
    def swap(self, other: PySide2.QtGui.QFontInfo): ...
    def underline(self) -> bool: ...
    def weight(self) -> int: ...


class QFontMetrics(Shiboken.Object):

    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QFont): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QFont, pd: PySide2.QtGui.QPaintDevice): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QFontMetrics): ...
    def __copy__(self): ...
    def ascent(self) -> int: ...
    def averageCharWidth(self) -> int: ...
    @typing.overload
    def boundingRect(self, r: PySide2.QtCore.QRect, flags: int, text: str, tabstops: int = ..., tabarray: int = ...) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def boundingRect(self, text: str) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def boundingRect(self, x: int, y: int, w: int, h: int, flags: int, text: str, tabstops: int = ..., tabarray: int = ...) -> PySide2.QtCore.QRect: ...
    def boundingRectChar(self, arg__1: typing.Char) -> PySide2.QtCore.QRect: ...
    def capHeight(self) -> int: ...
    def charWidth(self, str: str, pos: int) -> int: ...
    def descent(self) -> int: ...
    def elidedText(self, text: str, mode: PySide2.QtCore.Qt.TextElideMode, width: int, flags: int = ...) -> str: ...
    def height(self) -> int: ...
    @typing.overload
    def horizontalAdvance(self, arg__1: typing.Char) -> int: ...
    @typing.overload
    def horizontalAdvance(self, arg__1: str, len: int = ...) -> int: ...
    def inFont(self, arg__1: typing.Char) -> bool: ...
    def inFontUcs4(self, ucs4: int) -> bool: ...
    def leading(self) -> int: ...
    def leftBearing(self, arg__1: typing.Char) -> int: ...
    def lineSpacing(self) -> int: ...
    def lineWidth(self) -> int: ...
    def maxWidth(self) -> int: ...
    def minLeftBearing(self) -> int: ...
    def minRightBearing(self) -> int: ...
    def overlinePos(self) -> int: ...
    def rightBearing(self, arg__1: typing.Char) -> int: ...
    def size(self, flags: int, str: str, tabstops: int = ..., tabarray: int = ...) -> PySide2.QtCore.QSize: ...
    def strikeOutPos(self) -> int: ...
    def swap(self, other: PySide2.QtGui.QFontMetrics): ...
    def tightBoundingRect(self, text: str) -> PySide2.QtCore.QRect: ...
    def underlinePos(self) -> int: ...
    @typing.overload
    def width(self, arg__1: str, len: int, flags: int) -> int: ...
    @typing.overload
    def width(self, arg__1: str, len: int = ...) -> int: ...
    def widthChar(self, arg__1: typing.Char) -> int: ...
    def xHeight(self) -> int: ...


class QFontMetricsF(Shiboken.Object):

    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QFont): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QFont, pd: PySide2.QtGui.QPaintDevice): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QFontMetrics): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QFontMetricsF): ...
    def __copy__(self): ...
    def ascent(self) -> float: ...
    def averageCharWidth(self) -> float: ...
    @typing.overload
    def boundingRect(self, r: PySide2.QtCore.QRectF, flags: int, string: str, tabstops: int = ..., tabarray: int = ...) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def boundingRect(self, string: str) -> PySide2.QtCore.QRectF: ...
    def boundingRectChar(self, arg__1: typing.Char) -> PySide2.QtCore.QRectF: ...
    def capHeight(self) -> float: ...
    def descent(self) -> float: ...
    def elidedText(self, text: str, mode: PySide2.QtCore.Qt.TextElideMode, width: float, flags: int = ...) -> str: ...
    def height(self) -> float: ...
    @typing.overload
    def horizontalAdvance(self, arg__1: typing.Char) -> float: ...
    @typing.overload
    def horizontalAdvance(self, string: str, length: int = ...) -> float: ...
    def inFont(self, arg__1: typing.Char) -> bool: ...
    def inFontUcs4(self, ucs4: int) -> bool: ...
    def leading(self) -> float: ...
    def leftBearing(self, arg__1: typing.Char) -> float: ...
    def lineSpacing(self) -> float: ...
    def lineWidth(self) -> float: ...
    def maxWidth(self) -> float: ...
    def minLeftBearing(self) -> float: ...
    def minRightBearing(self) -> float: ...
    def overlinePos(self) -> float: ...
    def rightBearing(self, arg__1: typing.Char) -> float: ...
    def size(self, flags: int, str: str, tabstops: int = ..., tabarray: int = ...) -> PySide2.QtCore.QSizeF: ...
    def strikeOutPos(self) -> float: ...
    def swap(self, other: PySide2.QtGui.QFontMetricsF): ...
    def tightBoundingRect(self, text: str) -> PySide2.QtCore.QRectF: ...
    def underlinePos(self) -> float: ...
    def width(self, string: str) -> float: ...
    def widthChar(self, arg__1: typing.Char) -> float: ...
    def xHeight(self) -> float: ...


class QGradient(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QGradient: PySide2.QtGui.QGradient): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QGradient.Preset): ...
    def __copy__(self): ...
    def coordinateMode(self) -> PySide2.QtGui.QGradient.CoordinateMode: ...
    def interpolationMode(self) -> PySide2.QtGui.QGradient.InterpolationMode: ...
    def setColorAt(self, pos: float, color: PySide2.QtGui.QColor): ...
    def setCoordinateMode(self, mode: PySide2.QtGui.QGradient.CoordinateMode): ...
    def setInterpolationMode(self, mode: PySide2.QtGui.QGradient.InterpolationMode): ...
    def setSpread(self, spread: PySide2.QtGui.QGradient.Spread): ...
    def setStops(self, stops: typing.List[typing.Tuple]): ...
    def spread(self) -> PySide2.QtGui.QGradient.Spread: ...
    def stops(self) -> typing.List[typing.Tuple]: ...
    def type(self) -> PySide2.QtGui.QGradient.Type: ...


class QGuiApplication(PySide2.QtCore.QCoreApplication):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arg__1: typing.List[str]): ...
    @staticmethod
    def allWindows() -> typing.List[PySide2.QtGui.QWindow]: ...
    @staticmethod
    def applicationDisplayName() -> str: ...
    @staticmethod
    def applicationState() -> PySide2.QtCore.Qt.ApplicationState: ...
    @staticmethod
    def changeOverrideCursor(arg__1: PySide2.QtGui.QCursor): ...
    @staticmethod
    def clipboard() -> PySide2.QtGui.QClipboard: ...
    @staticmethod
    def desktopFileName() -> str: ...
    @staticmethod
    def desktopSettingsAware() -> bool: ...
    def devicePixelRatio(self) -> float: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    @staticmethod
    def exec_() -> int: ...
    @staticmethod
    def focusObject() -> PySide2.QtCore.QObject: ...
    @staticmethod
    def focusWindow() -> PySide2.QtGui.QWindow: ...
    @staticmethod
    def font() -> PySide2.QtGui.QFont: ...
    @staticmethod
    def inputMethod() -> PySide2.QtGui.QInputMethod: ...
    @staticmethod
    def isFallbackSessionManagementEnabled() -> bool: ...
    @staticmethod
    def isLeftToRight() -> bool: ...
    @staticmethod
    def isRightToLeft() -> bool: ...
    def isSavingSession(self) -> bool: ...
    def isSessionRestored(self) -> bool: ...
    @staticmethod
    def keyboardModifiers() -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    @staticmethod
    def layoutDirection() -> PySide2.QtCore.Qt.LayoutDirection: ...
    @staticmethod
    def modalWindow() -> PySide2.QtGui.QWindow: ...
    @staticmethod
    def mouseButtons() -> PySide2.QtCore.Qt.MouseButtons: ...
    def notify(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    @staticmethod
    def overrideCursor() -> PySide2.QtGui.QCursor: ...
    @staticmethod
    def palette() -> PySide2.QtGui.QPalette: ...
    @staticmethod
    def platformName() -> str: ...
    @staticmethod
    def primaryScreen() -> PySide2.QtGui.QScreen: ...
    @staticmethod
    def queryKeyboardModifiers() -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    @staticmethod
    def quitOnLastWindowClosed() -> bool: ...
    @staticmethod
    def restoreOverrideCursor(): ...
    @staticmethod
    def screenAt(point: PySide2.QtCore.QPoint) -> PySide2.QtGui.QScreen: ...
    @staticmethod
    def screens() -> typing.List[PySide2.QtGui.QScreen]: ...
    def sessionId(self) -> str: ...
    def sessionKey(self) -> str: ...
    @staticmethod
    def setApplicationDisplayName(name: str): ...
    @staticmethod
    def setDesktopFileName(name: str): ...
    @staticmethod
    def setDesktopSettingsAware(on: bool): ...
    @staticmethod
    def setFallbackSessionManagementEnabled(arg__1: bool): ...
    @staticmethod
    def setFont(arg__1: PySide2.QtGui.QFont): ...
    @staticmethod
    def setLayoutDirection(direction: PySide2.QtCore.Qt.LayoutDirection): ...
    @staticmethod
    def setOverrideCursor(arg__1: PySide2.QtGui.QCursor): ...
    @staticmethod
    def setPalette(pal: PySide2.QtGui.QPalette): ...
    @staticmethod
    def setQuitOnLastWindowClosed(quit: bool): ...
    @staticmethod
    def setWindowIcon(icon: PySide2.QtGui.QIcon): ...
    @staticmethod
    def styleHints() -> PySide2.QtGui.QStyleHints: ...
    @staticmethod
    def sync(): ...
    @staticmethod
    def topLevelAt(pos: PySide2.QtCore.QPoint) -> PySide2.QtGui.QWindow: ...
    @staticmethod
    def topLevelWindows() -> typing.List[PySide2.QtGui.QWindow]: ...
    @staticmethod
    def windowIcon() -> PySide2.QtGui.QIcon: ...


class QHelpEvent(PySide2.QtCore.QEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type, pos: PySide2.QtCore.QPoint, globalPos: PySide2.QtCore.QPoint): ...
    def globalPos(self) -> PySide2.QtCore.QPoint: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QHideEvent(PySide2.QtCore.QEvent):

    def __init__(self): ...


class QHoverEvent(PySide2.QtGui.QInputEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type, pos: PySide2.QtCore.QPointF, oldPos: PySide2.QtCore.QPointF, modifiers: PySide2.QtCore.Qt.KeyboardModifiers = ...): ...
    def oldPos(self) -> PySide2.QtCore.QPoint: ...
    def oldPosF(self) -> PySide2.QtCore.QPointF: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def posF(self) -> PySide2.QtCore.QPointF: ...


class QIcon(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, engine: PySide2.QtGui.QIconEngine): ...
    @typing.overload
    def __init__(self, fileName: str): ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QIcon): ...
    @typing.overload
    def __init__(self, pixmap: PySide2.QtGui.QPixmap): ...
    def __copy__(self): ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def actualSize(self, size: PySide2.QtCore.QSize, mode: PySide2.QtGui.QIcon.Mode = ..., state: PySide2.QtGui.QIcon.State = ...) -> PySide2.QtCore.QSize: ...
    @typing.overload
    def actualSize(self, window: PySide2.QtGui.QWindow, size: PySide2.QtCore.QSize, mode: PySide2.QtGui.QIcon.Mode = ..., state: PySide2.QtGui.QIcon.State = ...) -> PySide2.QtCore.QSize: ...
    def addFile(self, fileName: str, size: PySide2.QtCore.QSize = ..., mode: PySide2.QtGui.QIcon.Mode = ..., state: PySide2.QtGui.QIcon.State = ...): ...
    def addPixmap(self, pixmap: PySide2.QtGui.QPixmap, mode: PySide2.QtGui.QIcon.Mode = ..., state: PySide2.QtGui.QIcon.State = ...): ...
    def availableSizes(self, mode: PySide2.QtGui.QIcon.Mode = ..., state: PySide2.QtGui.QIcon.State = ...) -> typing.List[PySide2.QtCore.QSize]: ...
    def cacheKey(self) -> int: ...
    @staticmethod
    def fallbackSearchPaths() -> typing.List[str]: ...
    @staticmethod
    def fallbackThemeName() -> str: ...
    @typing.overload
    @staticmethod
    def fromTheme(name: str) -> PySide2.QtGui.QIcon: ...
    @typing.overload
    @staticmethod
    def fromTheme(name: str, fallback: PySide2.QtGui.QIcon) -> PySide2.QtGui.QIcon: ...
    @staticmethod
    def hasThemeIcon(name: str) -> bool: ...
    def isMask(self) -> bool: ...
    def isNull(self) -> bool: ...
    def name(self) -> str: ...
    @typing.overload
    def paint(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRect, alignment: PySide2.QtCore.Qt.Alignment = ..., mode: PySide2.QtGui.QIcon.Mode = ..., state: PySide2.QtGui.QIcon.State = ...): ...
    @typing.overload
    def paint(self, painter: PySide2.QtGui.QPainter, x: int, y: int, w: int, h: int, alignment: PySide2.QtCore.Qt.Alignment = ..., mode: PySide2.QtGui.QIcon.Mode = ..., state: PySide2.QtGui.QIcon.State = ...): ...
    @typing.overload
    def pixmap(self, extent: int, mode: PySide2.QtGui.QIcon.Mode = ..., state: PySide2.QtGui.QIcon.State = ...) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def pixmap(self, size: PySide2.QtCore.QSize, mode: PySide2.QtGui.QIcon.Mode = ..., state: PySide2.QtGui.QIcon.State = ...) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def pixmap(self, w: int, h: int, mode: PySide2.QtGui.QIcon.Mode = ..., state: PySide2.QtGui.QIcon.State = ...) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def pixmap(self, window: PySide2.QtGui.QWindow, size: PySide2.QtCore.QSize, mode: PySide2.QtGui.QIcon.Mode = ..., state: PySide2.QtGui.QIcon.State = ...) -> PySide2.QtGui.QPixmap: ...
    @staticmethod
    def setFallbackSearchPaths(paths: typing.List[str]): ...
    @staticmethod
    def setFallbackThemeName(name: str): ...
    def setIsMask(self, isMask: bool): ...
    @staticmethod
    def setThemeName(path: str): ...
    @staticmethod
    def setThemeSearchPaths(searchpath: typing.List[str]): ...
    def swap(self, other: PySide2.QtGui.QIcon): ...
    @staticmethod
    def themeName() -> str: ...
    @staticmethod
    def themeSearchPaths() -> typing.List[str]: ...


class QIconDragEvent(PySide2.QtCore.QEvent):

    def __init__(self): ...


class QIconEngine(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QIconEngine): ...
    def actualSize(self, size: PySide2.QtCore.QSize, mode: PySide2.QtGui.QIcon.Mode, state: PySide2.QtGui.QIcon.State) -> PySide2.QtCore.QSize: ...
    def addFile(self, fileName: str, size: PySide2.QtCore.QSize, mode: PySide2.QtGui.QIcon.Mode, state: PySide2.QtGui.QIcon.State): ...
    def addPixmap(self, pixmap: PySide2.QtGui.QPixmap, mode: PySide2.QtGui.QIcon.Mode, state: PySide2.QtGui.QIcon.State): ...
    def availableSizes(self, mode: PySide2.QtGui.QIcon.Mode = ..., state: PySide2.QtGui.QIcon.State = ...) -> typing.List[PySide2.QtCore.QSize]: ...
    def clone(self) -> PySide2.QtGui.QIconEngine: ...
    def iconName(self) -> str: ...
    def isNull(self) -> bool: ...
    def key(self) -> str: ...
    def paint(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRect, mode: PySide2.QtGui.QIcon.Mode, state: PySide2.QtGui.QIcon.State): ...
    def pixmap(self, size: PySide2.QtCore.QSize, mode: PySide2.QtGui.QIcon.Mode, state: PySide2.QtGui.QIcon.State) -> PySide2.QtGui.QPixmap: ...
    def read(self, in_: PySide2.QtCore.QDataStream) -> bool: ...
    def scaledPixmap(self, size: PySide2.QtCore.QSize, mode: PySide2.QtGui.QIcon.Mode, state: PySide2.QtGui.QIcon.State, scale: float) -> PySide2.QtGui.QPixmap: ...
    def write(self, out: PySide2.QtCore.QDataStream) -> bool: ...

    class AvailableSizesArgument(Shiboken.Object):

        def __init__(self): ...


class QImage(PySide2.QtGui.QPaintDevice):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arg__1: str, arg__2: int, arg__3: int, arg__4: PySide2.QtGui.QImage.Format): ...
    @typing.overload
    def __init__(self, arg__1: str, arg__2: int, arg__3: int, arg__4: int, arg__5: PySide2.QtGui.QImage.Format): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QImage): ...
    @typing.overload
    def __init__(self, data: typing.Char, width: int, height: int, bytesPerLine: int, format: PySide2.QtGui.QImage.Format, cleanupFunction: typing.Callable = ..., cleanupInfo: int = ...): ...
    @typing.overload
    def __init__(self, data: typing.Char, width: int, height: int, format: PySide2.QtGui.QImage.Format, cleanupFunction: typing.Callable = ..., cleanupInfo: int = ...): ...
    @typing.overload
    def __init__(self, fileName: str, format: str = ...): ...
    @typing.overload
    def __init__(self, size: PySide2.QtCore.QSize, format: PySide2.QtGui.QImage.Format): ...
    @typing.overload
    def __init__(self, width: int, height: int, format: PySide2.QtGui.QImage.Format): ...
    @typing.overload
    def __init__(self, xpm: typing.List[typing.Char]): ...
    def __copy__(self): ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def allGray(self) -> bool: ...
    def alphaChannel(self) -> PySide2.QtGui.QImage: ...
    def bitPlaneCount(self) -> int: ...
    def bits(self) -> typing.Char: ...
    def byteCount(self) -> int: ...
    def bytesPerLine(self) -> int: ...
    def cacheKey(self) -> int: ...
    def color(self, i: int) -> int: ...
    def colorCount(self) -> int: ...
    def colorTable(self) -> typing.List[int]: ...
    def constBits(self) -> typing.Char: ...
    def constScanLine(self, arg__1: int) -> typing.Char: ...
    @typing.overload
    def convertToFormat(self, f: PySide2.QtGui.QImage.Format, colorTable: typing.List[int], flags: PySide2.QtCore.Qt.ImageConversionFlags = ...) -> PySide2.QtGui.QImage: ...
    @typing.overload
    def convertToFormat(self, f: PySide2.QtGui.QImage.Format, flags: PySide2.QtCore.Qt.ImageConversionFlags = ...) -> PySide2.QtGui.QImage: ...
    def convertToFormat_helper(self, format: PySide2.QtGui.QImage.Format, flags: PySide2.QtCore.Qt.ImageConversionFlags) -> PySide2.QtGui.QImage: ...
    def convertToFormat_inplace(self, format: PySide2.QtGui.QImage.Format, flags: PySide2.QtCore.Qt.ImageConversionFlags) -> bool: ...
    @typing.overload
    def copy(self, rect: PySide2.QtCore.QRect = ...) -> PySide2.QtGui.QImage: ...
    @typing.overload
    def copy(self, x: int, y: int, w: int, h: int) -> PySide2.QtGui.QImage: ...
    def createAlphaMask(self, flags: PySide2.QtCore.Qt.ImageConversionFlags = ...) -> PySide2.QtGui.QImage: ...
    def createHeuristicMask(self, clipTight: bool = ...) -> PySide2.QtGui.QImage: ...
    def createMaskFromColor(self, color: int, mode: PySide2.QtCore.Qt.MaskMode = ...) -> PySide2.QtGui.QImage: ...
    def depth(self) -> int: ...
    def devType(self) -> int: ...
    def devicePixelRatio(self) -> float: ...
    def dotsPerMeterX(self) -> int: ...
    def dotsPerMeterY(self) -> int: ...
    @typing.overload
    def fill(self, color: PySide2.QtCore.Qt.GlobalColor): ...
    @typing.overload
    def fill(self, color: PySide2.QtGui.QColor): ...
    @typing.overload
    def fill(self, pixel: int): ...
    def format(self) -> PySide2.QtGui.QImage.Format: ...
    @staticmethod
    def fromData(data: PySide2.QtCore.QByteArray, format: str = ...) -> PySide2.QtGui.QImage: ...
    def hasAlphaChannel(self) -> bool: ...
    def height(self) -> int: ...
    def invertPixels(self, mode: PySide2.QtGui.QImage.InvertMode = ...): ...
    def isGrayscale(self) -> bool: ...
    def isNull(self) -> bool: ...
    @typing.overload
    def load(self, device: PySide2.QtCore.QIODevice, format: str) -> bool: ...
    @typing.overload
    def load(self, fileName: str, format: str = ...) -> bool: ...
    def loadFromData(self, data: PySide2.QtCore.QByteArray, aformat: str = ...) -> bool: ...
    def metric(self, metric: PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def mirrored(self, horizontally: bool = ..., vertically: bool = ...) -> PySide2.QtGui.QImage: ...
    def mirrored_helper(self, horizontal: bool, vertical: bool) -> PySide2.QtGui.QImage: ...
    def mirrored_inplace(self, horizontal: bool, vertical: bool): ...
    def offset(self) -> PySide2.QtCore.QPoint: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    @typing.overload
    def pixel(self, pt: PySide2.QtCore.QPoint) -> int: ...
    @typing.overload
    def pixel(self, x: int, y: int) -> int: ...
    @typing.overload
    def pixelColor(self, pt: PySide2.QtCore.QPoint) -> PySide2.QtGui.QColor: ...
    @typing.overload
    def pixelColor(self, x: int, y: int) -> PySide2.QtGui.QColor: ...
    def pixelFormat(self) -> PySide2.QtGui.QPixelFormat: ...
    @typing.overload
    def pixelIndex(self, pt: PySide2.QtCore.QPoint) -> int: ...
    @typing.overload
    def pixelIndex(self, x: int, y: int) -> int: ...
    def rect(self) -> PySide2.QtCore.QRect: ...
    def reinterpretAsFormat(self, f: PySide2.QtGui.QImage.Format) -> bool: ...
    def rgbSwapped(self) -> PySide2.QtGui.QImage: ...
    def rgbSwapped_helper(self) -> PySide2.QtGui.QImage: ...
    def rgbSwapped_inplace(self): ...
    @typing.overload
    def save(self, device: PySide2.QtCore.QIODevice, format: str = ..., quality: int = ...) -> bool: ...
    @typing.overload
    def save(self, fileName: str, format: str = ..., quality: int = ...) -> bool: ...
    @typing.overload
    def scaled(self, s: PySide2.QtCore.QSize, aspectMode: PySide2.QtCore.Qt.AspectRatioMode = ..., mode: PySide2.QtCore.Qt.TransformationMode = ...) -> PySide2.QtGui.QImage: ...
    @typing.overload
    def scaled(self, w: int, h: int, aspectMode: PySide2.QtCore.Qt.AspectRatioMode = ..., mode: PySide2.QtCore.Qt.TransformationMode = ...) -> PySide2.QtGui.QImage: ...
    def scaledToHeight(self, h: int, mode: PySide2.QtCore.Qt.TransformationMode = ...) -> PySide2.QtGui.QImage: ...
    def scaledToWidth(self, w: int, mode: PySide2.QtCore.Qt.TransformationMode = ...) -> PySide2.QtGui.QImage: ...
    def scanLine(self, arg__1: int) -> typing.Char: ...
    def setAlphaChannel(self, alphaChannel: PySide2.QtGui.QImage): ...
    def setColor(self, i: int, c: int): ...
    def setColorCount(self, arg__1: int): ...
    def setColorTable(self, colors: typing.List[int]): ...
    def setDevicePixelRatio(self, scaleFactor: float): ...
    def setDotsPerMeterX(self, arg__1: int): ...
    def setDotsPerMeterY(self, arg__1: int): ...
    def setOffset(self, arg__1: PySide2.QtCore.QPoint): ...
    @typing.overload
    def setPixel(self, pt: PySide2.QtCore.QPoint, index_or_rgb: int): ...
    @typing.overload
    def setPixel(self, x: int, y: int, index_or_rgb: int): ...
    @typing.overload
    def setPixelColor(self, pt: PySide2.QtCore.QPoint, c: PySide2.QtGui.QColor): ...
    @typing.overload
    def setPixelColor(self, x: int, y: int, c: PySide2.QtGui.QColor): ...
    def setText(self, key: str, value: str): ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def sizeInBytes(self) -> int: ...
    def smoothScaled(self, w: int, h: int) -> PySide2.QtGui.QImage: ...
    def swap(self, other: PySide2.QtGui.QImage): ...
    def text(self, key: str = ...) -> str: ...
    def textKeys(self) -> typing.List[str]: ...
    @staticmethod
    def toImageFormat(format: PySide2.QtGui.QPixelFormat) -> PySide2.QtGui.QImage.Format: ...
    @staticmethod
    def toPixelFormat(format: PySide2.QtGui.QImage.Format) -> PySide2.QtGui.QPixelFormat: ...
    @typing.overload
    def transformed(self, matrix: PySide2.QtGui.QMatrix, mode: PySide2.QtCore.Qt.TransformationMode = ...) -> PySide2.QtGui.QImage: ...
    @typing.overload
    def transformed(self, matrix: PySide2.QtGui.QTransform, mode: PySide2.QtCore.Qt.TransformationMode = ...) -> PySide2.QtGui.QImage: ...
    @typing.overload
    @staticmethod
    def trueMatrix(arg__1: PySide2.QtGui.QMatrix, w: int, h: int) -> PySide2.QtGui.QMatrix: ...
    @typing.overload
    @staticmethod
    def trueMatrix(arg__1: PySide2.QtGui.QTransform, w: int, h: int) -> PySide2.QtGui.QTransform: ...
    @typing.overload
    def valid(self, pt: PySide2.QtCore.QPoint) -> bool: ...
    @typing.overload
    def valid(self, x: int, y: int) -> bool: ...
    def width(self) -> int: ...


class QImageIOHandler(Shiboken.Object):

    def __init__(self): ...
    def canRead(self) -> bool: ...
    def currentImageNumber(self) -> int: ...
    def currentImageRect(self) -> PySide2.QtCore.QRect: ...
    def device(self) -> PySide2.QtCore.QIODevice: ...
    def format(self) -> PySide2.QtCore.QByteArray: ...
    def imageCount(self) -> int: ...
    def jumpToImage(self, imageNumber: int) -> bool: ...
    def jumpToNextImage(self) -> bool: ...
    def loopCount(self) -> int: ...
    def name(self) -> PySide2.QtCore.QByteArray: ...
    def nextImageDelay(self) -> int: ...
    def option(self, option: PySide2.QtGui.QImageIOHandler.ImageOption) -> typing.Any: ...
    def read(self, image: PySide2.QtGui.QImage) -> bool: ...
    def setDevice(self, device: PySide2.QtCore.QIODevice): ...
    def setFormat(self, format: PySide2.QtCore.QByteArray): ...
    def setOption(self, option: PySide2.QtGui.QImageIOHandler.ImageOption, value: typing.Any): ...
    def supportsOption(self, option: PySide2.QtGui.QImageIOHandler.ImageOption) -> bool: ...
    def write(self, image: PySide2.QtGui.QImage) -> bool: ...


class QImageReader(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice, format: PySide2.QtCore.QByteArray = ...): ...
    @typing.overload
    def __init__(self, fileName: str, format: PySide2.QtCore.QByteArray = ...): ...
    def autoDetectImageFormat(self) -> bool: ...
    def autoTransform(self) -> bool: ...
    def backgroundColor(self) -> PySide2.QtGui.QColor: ...
    def canRead(self) -> bool: ...
    def clipRect(self) -> PySide2.QtCore.QRect: ...
    def currentImageNumber(self) -> int: ...
    def currentImageRect(self) -> PySide2.QtCore.QRect: ...
    def decideFormatFromContent(self) -> bool: ...
    def device(self) -> PySide2.QtCore.QIODevice: ...
    def error(self) -> PySide2.QtGui.QImageReader.ImageReaderError: ...
    def errorString(self) -> str: ...
    def fileName(self) -> str: ...
    def format(self) -> PySide2.QtCore.QByteArray: ...
    def gamma(self) -> float: ...
    def imageCount(self) -> int: ...
    @typing.overload
    @staticmethod
    def imageFormat() -> PySide2.QtGui.QImage.Format: ...
    @typing.overload
    @staticmethod
    def imageFormat(device: PySide2.QtCore.QIODevice) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def imageFormat(fileName: str) -> PySide2.QtCore.QByteArray: ...
    @staticmethod
    def imageFormatsForMimeType(mimeType: PySide2.QtCore.QByteArray) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def jumpToImage(self, imageNumber: int) -> bool: ...
    def jumpToNextImage(self) -> bool: ...
    def loopCount(self) -> int: ...
    def nextImageDelay(self) -> int: ...
    def quality(self) -> int: ...
    def read(self) -> PySide2.QtGui.QImage: ...
    def scaledClipRect(self) -> PySide2.QtCore.QRect: ...
    def scaledSize(self) -> PySide2.QtCore.QSize: ...
    def setAutoDetectImageFormat(self, enabled: bool): ...
    def setAutoTransform(self, enabled: bool): ...
    def setBackgroundColor(self, color: PySide2.QtGui.QColor): ...
    def setClipRect(self, rect: PySide2.QtCore.QRect): ...
    def setDecideFormatFromContent(self, ignored: bool): ...
    def setDevice(self, device: PySide2.QtCore.QIODevice): ...
    def setFileName(self, fileName: str): ...
    def setFormat(self, format: PySide2.QtCore.QByteArray): ...
    def setGamma(self, gamma: float): ...
    def setQuality(self, quality: int): ...
    def setScaledClipRect(self, rect: PySide2.QtCore.QRect): ...
    def setScaledSize(self, size: PySide2.QtCore.QSize): ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def subType(self) -> PySide2.QtCore.QByteArray: ...
    @staticmethod
    def supportedImageFormats() -> typing.List[PySide2.QtCore.QByteArray]: ...
    @staticmethod
    def supportedMimeTypes() -> typing.List[PySide2.QtCore.QByteArray]: ...
    def supportedSubTypes(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def supportsAnimation(self) -> bool: ...
    def supportsOption(self, option: PySide2.QtGui.QImageIOHandler.ImageOption) -> bool: ...
    def text(self, key: str) -> str: ...
    def textKeys(self) -> typing.List[str]: ...
    def transformation(self) -> PySide2.QtGui.QImageIOHandler.Transformations: ...


class QImageWriter(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice, format: PySide2.QtCore.QByteArray): ...
    @typing.overload
    def __init__(self, fileName: str, format: PySide2.QtCore.QByteArray = ...): ...
    def canWrite(self) -> bool: ...
    def compression(self) -> int: ...
    def description(self) -> str: ...
    def device(self) -> PySide2.QtCore.QIODevice: ...
    def error(self) -> PySide2.QtGui.QImageWriter.ImageWriterError: ...
    def errorString(self) -> str: ...
    def fileName(self) -> str: ...
    def format(self) -> PySide2.QtCore.QByteArray: ...
    def gamma(self) -> float: ...
    @staticmethod
    def imageFormatsForMimeType(mimeType: PySide2.QtCore.QByteArray) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def optimizedWrite(self) -> bool: ...
    def progressiveScanWrite(self) -> bool: ...
    def quality(self) -> int: ...
    def setCompression(self, compression: int): ...
    def setDescription(self, description: str): ...
    def setDevice(self, device: PySide2.QtCore.QIODevice): ...
    def setFileName(self, fileName: str): ...
    def setFormat(self, format: PySide2.QtCore.QByteArray): ...
    def setGamma(self, gamma: float): ...
    def setOptimizedWrite(self, optimize: bool): ...
    def setProgressiveScanWrite(self, progressive: bool): ...
    def setQuality(self, quality: int): ...
    def setSubType(self, type: PySide2.QtCore.QByteArray): ...
    def setText(self, key: str, text: str): ...
    def setTransformation(self, orientation: PySide2.QtGui.QImageIOHandler.Transformations): ...
    def subType(self) -> PySide2.QtCore.QByteArray: ...
    @staticmethod
    def supportedImageFormats() -> typing.List[PySide2.QtCore.QByteArray]: ...
    @staticmethod
    def supportedMimeTypes() -> typing.List[PySide2.QtCore.QByteArray]: ...
    def supportedSubTypes(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def supportsOption(self, option: PySide2.QtGui.QImageIOHandler.ImageOption) -> bool: ...
    def transformation(self) -> PySide2.QtGui.QImageIOHandler.Transformations: ...
    def write(self, image: PySide2.QtGui.QImage) -> bool: ...


class QInputEvent(PySide2.QtCore.QEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type, modifiers: PySide2.QtCore.Qt.KeyboardModifiers = ...): ...
    def modifiers(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def setModifiers(self, amodifiers: PySide2.QtCore.Qt.KeyboardModifiers): ...
    def setTimestamp(self, atimestamp: int): ...
    def timestamp(self) -> int: ...


class QInputMethod(PySide2.QtCore.QObject):

    def anchorRectangle(self) -> PySide2.QtCore.QRectF: ...
    def commit(self): ...
    def cursorRectangle(self) -> PySide2.QtCore.QRectF: ...
    def hide(self): ...
    def inputDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def inputItemClipRectangle(self) -> PySide2.QtCore.QRectF: ...
    def inputItemRectangle(self) -> PySide2.QtCore.QRectF: ...
    def inputItemTransform(self) -> PySide2.QtGui.QTransform: ...
    def invokeAction(self, a: PySide2.QtGui.QInputMethod.Action, cursorPosition: int): ...
    def isAnimating(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def keyboardRectangle(self) -> PySide2.QtCore.QRectF: ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    @staticmethod
    def queryFocusObject(query: PySide2.QtCore.Qt.InputMethodQuery, argument: typing.Any) -> typing.Any: ...
    def reset(self): ...
    def setInputItemRectangle(self, rect: PySide2.QtCore.QRectF): ...
    def setInputItemTransform(self, transform: PySide2.QtGui.QTransform): ...
    def setVisible(self, visible: bool): ...
    def show(self): ...
    def update(self, queries: PySide2.QtCore.Qt.InputMethodQueries): ...


class QInputMethodEvent(PySide2.QtCore.QEvent):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QInputMethodEvent): ...
    @typing.overload
    def __init__(self, preeditText: str, attributes: typing.List[PySide2.QtGui.QInputMethodEvent.Attribute]): ...
    def attributes(self) -> typing.List[PySide2.QtGui.QInputMethodEvent.Attribute]: ...
    def commitString(self) -> str: ...
    def preeditString(self) -> str: ...
    def replacementLength(self) -> int: ...
    def replacementStart(self) -> int: ...
    def setCommitString(self, commitString: str, replaceFrom: int = ..., replaceLength: int = ...): ...

    class Attribute(Shiboken.Object):

        @typing.overload
        def __init__(self, Attribute: PySide2.QtGui.QInputMethodEvent.Attribute): ...
        @typing.overload
        def __init__(self, typ: PySide2.QtGui.QInputMethodEvent.AttributeType, s: int, l: int): ...
        @typing.overload
        def __init__(self, typ: PySide2.QtGui.QInputMethodEvent.AttributeType, s: int, l: int, val: typing.Any): ...
        def __copy__(self): ...


class QInputMethodQueryEvent(PySide2.QtCore.QEvent):

    def __init__(self, queries: PySide2.QtCore.Qt.InputMethodQueries): ...
    def queries(self) -> PySide2.QtCore.Qt.InputMethodQueries: ...
    def setValue(self, query: PySide2.QtCore.Qt.InputMethodQuery, value: typing.Any): ...
    def value(self, query: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...


class QIntValidator(PySide2.QtGui.QValidator):

    @typing.overload
    def __init__(self, bottom: int, top: int, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def bottom(self) -> int: ...
    def fixup(self, input: str): ...
    def setBottom(self, arg__1: int): ...
    def setRange(self, bottom: int, top: int): ...
    def setTop(self, arg__1: int): ...
    def top(self) -> int: ...
    def validate(self, arg__1: str, arg__2: int) -> PySide2.QtGui.QValidator.State: ...


class QKeyEvent(PySide2.QtGui.QInputEvent):

    @typing.overload
    def __init__(self, type: PySide2.QtCore.QEvent.Type, key: int, modifiers: PySide2.QtCore.Qt.KeyboardModifiers, nativeScanCode: int, nativeVirtualKey: int, nativeModifiers: int, text: str = ..., autorep: bool = ..., count: int = ...): ...
    @typing.overload
    def __init__(self, type: PySide2.QtCore.QEvent.Type, key: int, modifiers: PySide2.QtCore.Qt.KeyboardModifiers, text: str = ..., autorep: bool = ..., count: int = ...): ...
    def count(self) -> int: ...
    def isAutoRepeat(self) -> bool: ...
    def key(self) -> int: ...
    def matches(self, key: PySide2.QtGui.QKeySequence.StandardKey) -> bool: ...
    def modifiers(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def nativeModifiers(self) -> int: ...
    def nativeScanCode(self) -> int: ...
    def nativeVirtualKey(self) -> int: ...
    def text(self) -> str: ...


class QKeySequence(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, k1: int, k2: int = ..., k3: int = ..., k4: int = ...): ...
    @typing.overload
    def __init__(self, key: PySide2.QtGui.QKeySequence.StandardKey): ...
    @typing.overload
    def __init__(self, key: str, format: PySide2.QtGui.QKeySequence.SequenceFormat = ...): ...
    @typing.overload
    def __init__(self, ks: PySide2.QtGui.QKeySequence): ...
    def __copy__(self): ...
    def __lshift__(self, in_: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, out: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def count(self) -> int: ...
    @staticmethod
    def fromString(str: str, format: PySide2.QtGui.QKeySequence.SequenceFormat = ...) -> PySide2.QtGui.QKeySequence: ...
    def isEmpty(self) -> bool: ...
    @staticmethod
    def keyBindings(key: PySide2.QtGui.QKeySequence.StandardKey) -> typing.List[PySide2.QtGui.QKeySequence]: ...
    @staticmethod
    def listFromString(str: str, format: PySide2.QtGui.QKeySequence.SequenceFormat = ...) -> typing.List[PySide2.QtGui.QKeySequence]: ...
    @staticmethod
    def listToString(list: typing.List[PySide2.QtGui.QKeySequence], format: PySide2.QtGui.QKeySequence.SequenceFormat = ...) -> str: ...
    def matches(self, seq: PySide2.QtGui.QKeySequence) -> PySide2.QtGui.QKeySequence.SequenceMatch: ...
    @staticmethod
    def mnemonic(text: str) -> PySide2.QtGui.QKeySequence: ...
    def swap(self, other: PySide2.QtGui.QKeySequence): ...
    def toString(self, format: PySide2.QtGui.QKeySequence.SequenceFormat = ...) -> str: ...


class QLinearGradient(PySide2.QtGui.QGradient):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QLinearGradient: PySide2.QtGui.QLinearGradient): ...
    @typing.overload
    def __init__(self, start: PySide2.QtCore.QPointF, finalStop: PySide2.QtCore.QPointF): ...
    @typing.overload
    def __init__(self, xStart: float, yStart: float, xFinalStop: float, yFinalStop: float): ...
    def __copy__(self): ...
    def finalStop(self) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def setFinalStop(self, stop: PySide2.QtCore.QPointF): ...
    @typing.overload
    def setFinalStop(self, x: float, y: float): ...
    @typing.overload
    def setStart(self, start: PySide2.QtCore.QPointF): ...
    @typing.overload
    def setStart(self, x: float, y: float): ...
    def start(self) -> PySide2.QtCore.QPointF: ...


class QMatrix(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, m11: float, m12: float, m21: float, m22: float, dx: float, dy: float): ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QMatrix): ...
    def __copy__(self): ...
    def __imul__(self, arg__1: PySide2.QtGui.QMatrix) -> PySide2.QtGui.QMatrix: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, l: PySide2.QtCore.QLine) -> PySide2.QtCore.QLine: ...
    @typing.overload
    def __mul__(self, l: PySide2.QtCore.QLineF) -> PySide2.QtCore.QLineF: ...
    @typing.overload
    def __mul__(self, o: PySide2.QtGui.QMatrix) -> PySide2.QtGui.QMatrix: ...
    @typing.overload
    def __mul__(self, p: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def __mul__(self, p: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def determinant(self) -> float: ...
    def dx(self) -> float: ...
    def dy(self) -> float: ...
    def inverted(self, invertible: bool = ...) -> PySide2.QtGui.QMatrix: ...
    def isIdentity(self) -> bool: ...
    def isInvertible(self) -> bool: ...
    def m11(self) -> float: ...
    def m12(self) -> float: ...
    def m21(self) -> float: ...
    def m22(self) -> float: ...
    @typing.overload
    def map(self, a: PySide2.QtGui.QPolygon) -> PySide2.QtGui.QPolygon: ...
    @typing.overload
    def map(self, a: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def map(self, l: PySide2.QtCore.QLine) -> PySide2.QtCore.QLine: ...
    @typing.overload
    def map(self, l: PySide2.QtCore.QLineF) -> PySide2.QtCore.QLineF: ...
    @typing.overload
    def map(self, p: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def map(self, p: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def map(self, p: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def map(self, r: PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def map(self, x: float, y: float, tx: float, ty: float): ...
    @typing.overload
    def map(self, x: int, y: int, tx: int, ty: int): ...
    @typing.overload
    def mapRect(self, arg__1: PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def mapRect(self, arg__1: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def mapToPolygon(self, r: PySide2.QtCore.QRect) -> PySide2.QtGui.QPolygon: ...
    def reset(self): ...
    def rotate(self, a: float) -> PySide2.QtGui.QMatrix: ...
    def scale(self, sx: float, sy: float) -> PySide2.QtGui.QMatrix: ...
    def setMatrix(self, m11: float, m12: float, m21: float, m22: float, dx: float, dy: float): ...
    def shear(self, sh: float, sv: float) -> PySide2.QtGui.QMatrix: ...
    def translate(self, dx: float, dy: float) -> PySide2.QtGui.QMatrix: ...


class QMatrix2x2(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QMatrix2x2: PySide2.QtGui.QMatrix2x2): ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable): ...
    @typing.overload
    def __call__(self, row: int, column: int) -> float: ...
    @typing.overload
    def __call__(self, row: int, column: int) -> float: ...
    def __copy__(self): ...
    def __iadd__(self, other: Missing(PySide2.QtGui.QGenericMatrix)) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __imul__(self, factor: float) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __isub__(self, other: Missing(PySide2.QtGui.QGenericMatrix)) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def constData(self) -> float: ...
    def data(self) -> float: ...
    def fill(self, value: float): ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self): ...
    def transposed(self) -> Missing(PySide2.QtGui.QGenericMatrix): ...


class QMatrix2x3(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QMatrix2x3: PySide2.QtGui.QMatrix2x3): ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable): ...
    @typing.overload
    def __call__(self, row: int, column: int) -> float: ...
    @typing.overload
    def __call__(self, row: int, column: int) -> float: ...
    def __copy__(self): ...
    def __iadd__(self, other: Missing(PySide2.QtGui.QGenericMatrix)) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __imul__(self, factor: float) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __isub__(self, other: Missing(PySide2.QtGui.QGenericMatrix)) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def constData(self) -> float: ...
    def data(self) -> float: ...
    def fill(self, value: float): ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self): ...
    def transposed(self) -> Missing(PySide2.QtGui.QGenericMatrix): ...


class QMatrix2x4(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QMatrix2x4: PySide2.QtGui.QMatrix2x4): ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable): ...
    @typing.overload
    def __call__(self, row: int, column: int) -> float: ...
    @typing.overload
    def __call__(self, row: int, column: int) -> float: ...
    def __copy__(self): ...
    def __iadd__(self, other: Missing(PySide2.QtGui.QGenericMatrix)) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __imul__(self, factor: float) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __isub__(self, other: Missing(PySide2.QtGui.QGenericMatrix)) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def constData(self) -> float: ...
    def data(self) -> float: ...
    def fill(self, value: float): ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self): ...
    def transposed(self) -> Missing(PySide2.QtGui.QGenericMatrix): ...


class QMatrix3x2(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QMatrix3x2: PySide2.QtGui.QMatrix3x2): ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable): ...
    @typing.overload
    def __call__(self, row: int, column: int) -> float: ...
    @typing.overload
    def __call__(self, row: int, column: int) -> float: ...
    def __copy__(self): ...
    def __iadd__(self, other: Missing(PySide2.QtGui.QGenericMatrix)) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __imul__(self, factor: float) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __isub__(self, other: Missing(PySide2.QtGui.QGenericMatrix)) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def constData(self) -> float: ...
    def data(self) -> float: ...
    def fill(self, value: float): ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self): ...
    def transposed(self) -> Missing(PySide2.QtGui.QGenericMatrix): ...


class QMatrix3x3(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QMatrix3x3: PySide2.QtGui.QMatrix3x3): ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable): ...
    @typing.overload
    def __call__(self, row: int, column: int) -> float: ...
    @typing.overload
    def __call__(self, row: int, column: int) -> float: ...
    def __copy__(self): ...
    def __iadd__(self, other: Missing(PySide2.QtGui.QGenericMatrix)) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __imul__(self, factor: float) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __isub__(self, other: Missing(PySide2.QtGui.QGenericMatrix)) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def constData(self) -> float: ...
    def data(self) -> float: ...
    def fill(self, value: float): ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self): ...
    def transposed(self) -> Missing(PySide2.QtGui.QGenericMatrix): ...


class QMatrix3x4(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QMatrix3x4: PySide2.QtGui.QMatrix3x4): ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable): ...
    @typing.overload
    def __call__(self, row: int, column: int) -> float: ...
    @typing.overload
    def __call__(self, row: int, column: int) -> float: ...
    def __copy__(self): ...
    def __iadd__(self, other: Missing(PySide2.QtGui.QGenericMatrix)) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __imul__(self, factor: float) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __isub__(self, other: Missing(PySide2.QtGui.QGenericMatrix)) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def constData(self) -> float: ...
    def data(self) -> float: ...
    def fill(self, value: float): ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self): ...
    def transposed(self) -> Missing(PySide2.QtGui.QGenericMatrix): ...


class QMatrix4x2(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QMatrix4x2: PySide2.QtGui.QMatrix4x2): ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable): ...
    @typing.overload
    def __call__(self, row: int, column: int) -> float: ...
    @typing.overload
    def __call__(self, row: int, column: int) -> float: ...
    def __copy__(self): ...
    def __iadd__(self, other: Missing(PySide2.QtGui.QGenericMatrix)) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __imul__(self, factor: float) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __isub__(self, other: Missing(PySide2.QtGui.QGenericMatrix)) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def constData(self) -> float: ...
    def data(self) -> float: ...
    def fill(self, value: float): ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self): ...
    def transposed(self) -> Missing(PySide2.QtGui.QGenericMatrix): ...


class QMatrix4x3(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QMatrix4x3: PySide2.QtGui.QMatrix4x3): ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable): ...
    @typing.overload
    def __call__(self, row: int, column: int) -> float: ...
    @typing.overload
    def __call__(self, row: int, column: int) -> float: ...
    def __copy__(self): ...
    def __iadd__(self, other: Missing(PySide2.QtGui.QGenericMatrix)) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __imul__(self, factor: float) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __isub__(self, other: Missing(PySide2.QtGui.QGenericMatrix)) -> Missing(PySide2.QtGui.QGenericMatrix): ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def constData(self) -> float: ...
    def data(self) -> float: ...
    def fill(self, value: float): ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self): ...
    def transposed(self) -> Missing(PySide2.QtGui.QGenericMatrix): ...


class QMatrix4x4(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, m11: float, m12: float, m13: float, m14: float, m21: float, m22: float, m23: float, m24: float, m31: float, m32: float, m33: float, m34: float, m41: float, m42: float, m43: float, m44: float): ...
    @typing.overload
    def __init__(self, matrix: PySide2.QtGui.QMatrix): ...
    @typing.overload
    def __init__(self, transform: PySide2.QtGui.QTransform): ...
    @typing.overload
    def __init__(self, values: float): ...
    def __add__(self, m2: PySide2.QtGui.QMatrix4x4) -> PySide2.QtGui.QMatrix4x4: ...
    def __copy__(self): ...
    def __dummy(self, arg__1: typing.List[float]): ...
    def __iadd__(self, other: PySide2.QtGui.QMatrix4x4) -> PySide2.QtGui.QMatrix4x4: ...
    @typing.overload
    def __imul__(self, factor: float) -> PySide2.QtGui.QMatrix4x4: ...
    @typing.overload
    def __imul__(self, other: PySide2.QtGui.QMatrix4x4) -> PySide2.QtGui.QMatrix4x4: ...
    def __isub__(self, other: PySide2.QtGui.QMatrix4x4) -> PySide2.QtGui.QMatrix4x4: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, factor: float) -> PySide2.QtGui.QMatrix4x4: ...
    @typing.overload
    def __mul__(self, m2: PySide2.QtGui.QMatrix4x4) -> PySide2.QtGui.QMatrix4x4: ...
    @typing.overload
    def __mul__(self, point: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def __mul__(self, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def __neg__(self) -> PySide2.QtGui.QMatrix4x4: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __sub__(self, m2: PySide2.QtGui.QMatrix4x4) -> PySide2.QtGui.QMatrix4x4: ...
    def column(self, index: int) -> PySide2.QtGui.QVector4D: ...
    def copyDataTo(self, values: float): ...
    def data(self) -> float: ...
    def determinant(self) -> float: ...
    def fill(self, value: float): ...
    def flipCoordinates(self): ...
    def frustum(self, left: float, right: float, bottom: float, top: float, nearPlane: float, farPlane: float): ...
    def inverted(self, invertible: bool = ...) -> PySide2.QtGui.QMatrix4x4: ...
    def isAffine(self) -> bool: ...
    def isIdentity(self) -> bool: ...
    def lookAt(self, eye: PySide2.QtGui.QVector3D, center: PySide2.QtGui.QVector3D, up: PySide2.QtGui.QVector3D): ...
    @typing.overload
    def map(self, point: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def map(self, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def map(self, point: PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    @typing.overload
    def map(self, point: PySide2.QtGui.QVector4D) -> PySide2.QtGui.QVector4D: ...
    @typing.overload
    def mapRect(self, rect: PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def mapRect(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def mapVector(self, vector: PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    def normalMatrix(self) -> PySide2.QtGui.QMatrix3x3: ...
    def optimize(self): ...
    @typing.overload
    def ortho(self, left: float, right: float, bottom: float, top: float, nearPlane: float, farPlane: float): ...
    @typing.overload
    def ortho(self, rect: PySide2.QtCore.QRect): ...
    @typing.overload
    def ortho(self, rect: PySide2.QtCore.QRectF): ...
    def perspective(self, verticalAngle: float, aspectRatio: float, nearPlane: float, farPlane: float): ...
    @typing.overload
    def rotate(self, angle: float, vector: PySide2.QtGui.QVector3D): ...
    @typing.overload
    def rotate(self, angle: float, x: float, y: float, z: float = ...): ...
    @typing.overload
    def rotate(self, quaternion: PySide2.QtGui.QQuaternion): ...
    def row(self, index: int) -> PySide2.QtGui.QVector4D: ...
    @typing.overload
    def scale(self, factor: float): ...
    @typing.overload
    def scale(self, vector: PySide2.QtGui.QVector3D): ...
    @typing.overload
    def scale(self, x: float, y: float): ...
    @typing.overload
    def scale(self, x: float, y: float, z: float): ...
    def setColumn(self, index: int, value: PySide2.QtGui.QVector4D): ...
    def setRow(self, index: int, value: PySide2.QtGui.QVector4D): ...
    def setToIdentity(self): ...
    def toAffine(self) -> PySide2.QtGui.QMatrix: ...
    @typing.overload
    def toTransform(self) -> PySide2.QtGui.QTransform: ...
    @typing.overload
    def toTransform(self, distanceToPlane: float) -> PySide2.QtGui.QTransform: ...
    @typing.overload
    def translate(self, vector: PySide2.QtGui.QVector3D): ...
    @typing.overload
    def translate(self, x: float, y: float): ...
    @typing.overload
    def translate(self, x: float, y: float, z: float): ...
    def transposed(self) -> PySide2.QtGui.QMatrix4x4: ...
    @typing.overload
    def viewport(self, left: float, bottom: float, width: float, height: float, nearPlane: float = ..., farPlane: float = ...): ...
    @typing.overload
    def viewport(self, rect: PySide2.QtCore.QRectF): ...


class QMouseEvent(PySide2.QtGui.QInputEvent):

    @typing.overload
    def __init__(self, type: PySide2.QtCore.QEvent.Type, localPos: PySide2.QtCore.QPointF, button: PySide2.QtCore.Qt.MouseButton, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers): ...
    @typing.overload
    def __init__(self, type: PySide2.QtCore.QEvent.Type, localPos: PySide2.QtCore.QPointF, screenPos: PySide2.QtCore.QPointF, button: PySide2.QtCore.Qt.MouseButton, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers): ...
    @typing.overload
    def __init__(self, type: PySide2.QtCore.QEvent.Type, localPos: PySide2.QtCore.QPointF, windowPos: PySide2.QtCore.QPointF, screenPos: PySide2.QtCore.QPointF, button: PySide2.QtCore.Qt.MouseButton, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers): ...
    @typing.overload
    def __init__(self, type: PySide2.QtCore.QEvent.Type, localPos: PySide2.QtCore.QPointF, windowPos: PySide2.QtCore.QPointF, screenPos: PySide2.QtCore.QPointF, button: PySide2.QtCore.Qt.MouseButton, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers, source: PySide2.QtCore.Qt.MouseEventSource): ...
    def button(self) -> PySide2.QtCore.Qt.MouseButton: ...
    def buttons(self) -> PySide2.QtCore.Qt.MouseButtons: ...
    def flags(self) -> PySide2.QtCore.Qt.MouseEventFlags: ...
    def globalPos(self) -> PySide2.QtCore.QPoint: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def localPos(self) -> PySide2.QtCore.QPointF: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def screenPos(self) -> PySide2.QtCore.QPointF: ...
    def setLocalPos(self, localPosition: PySide2.QtCore.QPointF): ...
    def source(self) -> PySide2.QtCore.Qt.MouseEventSource: ...
    def windowPos(self) -> PySide2.QtCore.QPointF: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QMoveEvent(PySide2.QtCore.QEvent):

    def __init__(self, pos: PySide2.QtCore.QPoint, oldPos: PySide2.QtCore.QPoint): ...
    def oldPos(self) -> PySide2.QtCore.QPoint: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...


class QMovie(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice, format: PySide2.QtCore.QByteArray = ..., parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, fileName: str, format: PySide2.QtCore.QByteArray = ..., parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def backgroundColor(self) -> PySide2.QtGui.QColor: ...
    def cacheMode(self) -> PySide2.QtGui.QMovie.CacheMode: ...
    def currentFrameNumber(self) -> int: ...
    def currentImage(self) -> PySide2.QtGui.QImage: ...
    def currentPixmap(self) -> PySide2.QtGui.QPixmap: ...
    def device(self) -> PySide2.QtCore.QIODevice: ...
    def fileName(self) -> str: ...
    def format(self) -> PySide2.QtCore.QByteArray: ...
    def frameCount(self) -> int: ...
    def frameRect(self) -> PySide2.QtCore.QRect: ...
    def isValid(self) -> bool: ...
    def jumpToFrame(self, frameNumber: int) -> bool: ...
    def jumpToNextFrame(self) -> bool: ...
    def lastError(self) -> PySide2.QtGui.QImageReader.ImageReaderError: ...
    def lastErrorString(self) -> str: ...
    def loopCount(self) -> int: ...
    def nextFrameDelay(self) -> int: ...
    def scaledSize(self) -> PySide2.QtCore.QSize: ...
    def setBackgroundColor(self, color: PySide2.QtGui.QColor): ...
    def setCacheMode(self, mode: PySide2.QtGui.QMovie.CacheMode): ...
    def setDevice(self, device: PySide2.QtCore.QIODevice): ...
    def setFileName(self, fileName: str): ...
    def setFormat(self, format: PySide2.QtCore.QByteArray): ...
    def setPaused(self, paused: bool): ...
    def setScaledSize(self, size: PySide2.QtCore.QSize): ...
    def setSpeed(self, percentSpeed: int): ...
    def speed(self) -> int: ...
    def start(self): ...
    def state(self) -> PySide2.QtGui.QMovie.MovieState: ...
    def stop(self): ...
    @staticmethod
    def supportedFormats() -> typing.List[PySide2.QtCore.QByteArray]: ...


class QNativeGestureEvent(PySide2.QtGui.QInputEvent):

    @typing.overload
    def __init__(self, type: PySide2.QtCore.Qt.NativeGestureType, dev: PySide2.QtGui.QTouchDevice, localPos: PySide2.QtCore.QPointF, windowPos: PySide2.QtCore.QPointF, screenPos: PySide2.QtCore.QPointF, value: float, sequenceId: int, intArgument: int): ...
    @typing.overload
    def __init__(self, type: PySide2.QtCore.Qt.NativeGestureType, localPos: PySide2.QtCore.QPointF, windowPos: PySide2.QtCore.QPointF, screenPos: PySide2.QtCore.QPointF, value: float, sequenceId: int, intArgument: int): ...
    def device(self) -> PySide2.QtGui.QTouchDevice: ...
    def gestureType(self) -> PySide2.QtCore.Qt.NativeGestureType: ...
    def globalPos(self) -> PySide2.QtCore.QPoint: ...
    def localPos(self) -> PySide2.QtCore.QPointF: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def screenPos(self) -> PySide2.QtCore.QPointF: ...
    def value(self) -> float: ...
    def windowPos(self) -> PySide2.QtCore.QPointF: ...


class QOffscreenSurface(PySide2.QtCore.QObject, PySide2.QtGui.QSurface):

    @typing.overload
    def __init__(self, screen: PySide2.QtGui.QScreen, parent: PySide2.QtCore.QObject): ...
    @typing.overload
    def __init__(self, screen: PySide2.QtGui.QScreen = ...): ...
    def create(self): ...
    def destroy(self): ...
    def format(self) -> PySide2.QtGui.QSurfaceFormat: ...
    def isValid(self) -> bool: ...
    def nativeHandle(self) -> int: ...
    def requestedFormat(self) -> PySide2.QtGui.QSurfaceFormat: ...
    def screen(self) -> PySide2.QtGui.QScreen: ...
    def setFormat(self, format: PySide2.QtGui.QSurfaceFormat): ...
    def setNativeHandle(self, handle: int): ...
    def setScreen(self, screen: PySide2.QtGui.QScreen): ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def surfaceHandle(self) -> int: ...
    def surfaceType(self) -> PySide2.QtGui.QSurface.SurfaceType: ...


class QOpenGLBuffer(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QOpenGLBuffer): ...
    @typing.overload
    def __init__(self, type: PySide2.QtGui.QOpenGLBuffer.Type): ...
    @typing.overload
    def allocate(self, count: int): ...
    @typing.overload
    def allocate(self, data: int, count: int): ...
    def bind(self) -> bool: ...
    def bufferId(self) -> int: ...
    def create(self) -> bool: ...
    def destroy(self): ...
    def isCreated(self) -> bool: ...
    def map(self, access: PySide2.QtGui.QOpenGLBuffer.Access) -> int: ...
    def mapRange(self, offset: int, count: int, access: PySide2.QtGui.QOpenGLBuffer.RangeAccessFlags) -> int: ...
    def read(self, offset: int, data: int, count: int) -> bool: ...
    @typing.overload
    @staticmethod
    def release(): ...
    @typing.overload
    @staticmethod
    def release(type: PySide2.QtGui.QOpenGLBuffer.Type): ...
    def setUsagePattern(self, value: PySide2.QtGui.QOpenGLBuffer.UsagePattern): ...
    def size(self) -> int: ...
    def type(self) -> PySide2.QtGui.QOpenGLBuffer.Type: ...
    def unmap(self) -> bool: ...
    def usagePattern(self) -> PySide2.QtGui.QOpenGLBuffer.UsagePattern: ...
    def write(self, offset: int, data: int, count: int): ...


class QOpenGLContext(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    @staticmethod
    def areSharing(first: PySide2.QtGui.QOpenGLContext, second: PySide2.QtGui.QOpenGLContext) -> bool: ...
    def create(self) -> bool: ...
    @staticmethod
    def currentContext() -> PySide2.QtGui.QOpenGLContext: ...
    def defaultFramebufferObject(self) -> int: ...
    def doneCurrent(self): ...
    def extensions(self) -> typing.Set[PySide2.QtCore.QByteArray]: ...
    def extraFunctions(self) -> PySide2.QtGui.QOpenGLExtraFunctions: ...
    def format(self) -> PySide2.QtGui.QSurfaceFormat: ...
    def functions(self) -> PySide2.QtGui.QOpenGLFunctions: ...
    @staticmethod
    def globalShareContext() -> PySide2.QtGui.QOpenGLContext: ...
    def hasExtension(self, extension: PySide2.QtCore.QByteArray) -> bool: ...
    def isOpenGLES(self) -> bool: ...
    def isValid(self) -> bool: ...
    def makeCurrent(self, surface: PySide2.QtGui.QSurface) -> bool: ...
    def nativeHandle(self) -> typing.Any: ...
    @staticmethod
    def openGLModuleHandle() -> int: ...
    @staticmethod
    def openGLModuleType() -> PySide2.QtGui.QOpenGLContext.OpenGLModuleType: ...
    def screen(self) -> PySide2.QtGui.QScreen: ...
    def setFormat(self, format: PySide2.QtGui.QSurfaceFormat): ...
    def setNativeHandle(self, handle: typing.Any): ...
    def setScreen(self, screen: PySide2.QtGui.QScreen): ...
    def setShareContext(self, shareContext: PySide2.QtGui.QOpenGLContext): ...
    def shareContext(self) -> PySide2.QtGui.QOpenGLContext: ...
    def shareGroup(self) -> PySide2.QtGui.QOpenGLContextGroup: ...
    @staticmethod
    def supportsThreadedOpenGL() -> bool: ...
    def surface(self) -> PySide2.QtGui.QSurface: ...
    def swapBuffers(self, surface: PySide2.QtGui.QSurface): ...
    def versionFunctions(self, versionProfile: PySide2.QtGui.QOpenGLVersionProfile = ...) -> PySide2.QtGui.QAbstractOpenGLFunctions: ...


class QOpenGLContextGroup(PySide2.QtCore.QObject):

    @staticmethod
    def currentContextGroup() -> PySide2.QtGui.QOpenGLContextGroup: ...
    def shares(self) -> typing.List[PySide2.QtGui.QOpenGLContext]: ...


class QOpenGLDebugLogger(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def disableMessages(self, ids: typing.List[int], sources: PySide2.QtGui.QOpenGLDebugMessage.Sources = ..., types: PySide2.QtGui.QOpenGLDebugMessage.Types = ...): ...
    @typing.overload
    def disableMessages(self, sources: PySide2.QtGui.QOpenGLDebugMessage.Sources = ..., types: PySide2.QtGui.QOpenGLDebugMessage.Types = ..., severities: PySide2.QtGui.QOpenGLDebugMessage.Severities = ...): ...
    @typing.overload
    def enableMessages(self, ids: typing.List[int], sources: PySide2.QtGui.QOpenGLDebugMessage.Sources = ..., types: PySide2.QtGui.QOpenGLDebugMessage.Types = ...): ...
    @typing.overload
    def enableMessages(self, sources: PySide2.QtGui.QOpenGLDebugMessage.Sources = ..., types: PySide2.QtGui.QOpenGLDebugMessage.Types = ..., severities: PySide2.QtGui.QOpenGLDebugMessage.Severities = ...): ...
    def initialize(self) -> bool: ...
    def isLogging(self) -> bool: ...
    def logMessage(self, debugMessage: PySide2.QtGui.QOpenGLDebugMessage): ...
    def loggedMessages(self) -> typing.List[PySide2.QtGui.QOpenGLDebugMessage]: ...
    def loggingMode(self) -> PySide2.QtGui.QOpenGLDebugLogger.LoggingMode: ...
    def maximumMessageLength(self) -> int: ...
    def popGroup(self): ...
    def pushGroup(self, name: str, id: int = ..., source: PySide2.QtGui.QOpenGLDebugMessage.Source = ...): ...
    def startLogging(self, loggingMode: PySide2.QtGui.QOpenGLDebugLogger.LoggingMode = ...): ...
    def stopLogging(self): ...


class QOpenGLDebugMessage(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, debugMessage: PySide2.QtGui.QOpenGLDebugMessage): ...
    def __copy__(self): ...
    @staticmethod
    def createApplicationMessage(text: str, id: int = ..., severity: PySide2.QtGui.QOpenGLDebugMessage.Severity = ..., type: PySide2.QtGui.QOpenGLDebugMessage.Type = ...) -> PySide2.QtGui.QOpenGLDebugMessage: ...
    @staticmethod
    def createThirdPartyMessage(text: str, id: int = ..., severity: PySide2.QtGui.QOpenGLDebugMessage.Severity = ..., type: PySide2.QtGui.QOpenGLDebugMessage.Type = ...) -> PySide2.QtGui.QOpenGLDebugMessage: ...
    def id(self) -> int: ...
    def message(self) -> str: ...
    def severity(self) -> PySide2.QtGui.QOpenGLDebugMessage.Severity: ...
    def source(self) -> PySide2.QtGui.QOpenGLDebugMessage.Source: ...
    def swap(self, other: PySide2.QtGui.QOpenGLDebugMessage): ...
    def type(self) -> PySide2.QtGui.QOpenGLDebugMessage.Type: ...


class QOpenGLExtraFunctions(PySide2.QtGui.QOpenGLFunctions):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, context: PySide2.QtGui.QOpenGLContext): ...
    def glActiveShaderProgram(self, pipeline: int, program: int): ...
    def glBeginQuery(self, target: int, id: int): ...
    def glBeginTransformFeedback(self, primitiveMode: int): ...
    def glBindBufferBase(self, target: int, index: int, buffer: int): ...
    def glBindImageTexture(self, unit: int, texture: int, level: int, layered: typing.Char, layer: int, access: int, format: int): ...
    def glBindProgramPipeline(self, pipeline: int): ...
    def glBindSampler(self, unit: int, sampler: int): ...
    def glBindTransformFeedback(self, target: int, id: int): ...
    def glBindVertexArray(self, array: int): ...
    def glBlendBarrier(self): ...
    def glBlendEquationSeparatei(self, buf: int, modeRGB: int, modeAlpha: int): ...
    def glBlendEquationi(self, buf: int, mode: int): ...
    def glBlendFuncSeparatei(self, buf: int, srcRGB: int, dstRGB: int, srcAlpha: int, dstAlpha: int): ...
    def glBlendFunci(self, buf: int, src: int, dst: int): ...
    def glBlitFramebuffer(self, srcX0: int, srcY0: int, srcX1: int, srcY1: int, dstX0: int, dstY0: int, dstX1: int, dstY1: int, mask: int, filter: int): ...
    def glClearBufferfi(self, buffer: int, drawbuffer: int, depth: float, stencil: int): ...
    def glClearBufferfv(self, buffer: int, drawbuffer: int, value: float): ...
    def glClearBufferiv(self, buffer: int, drawbuffer: int, value: int): ...
    def glClearBufferuiv(self, buffer: int, drawbuffer: int, value: int): ...
    def glColorMaski(self, index: int, r: typing.Char, g: typing.Char, b: typing.Char, a: typing.Char): ...
    def glCompressedTexImage3D(self, target: int, level: int, internalformat: int, width: int, height: int, depth: int, border: int, imageSize: int, data: int): ...
    def glCompressedTexSubImage3D(self, target: int, level: int, xoffset: int, yoffset: int, zoffset: int, width: int, height: int, depth: int, format: int, imageSize: int, data: int): ...
    def glCopyImageSubData(self, srcName: int, srcTarget: int, srcLevel: int, srcX: int, srcY: int, srcZ: int, dstName: int, dstTarget: int, dstLevel: int, dstX: int, dstY: int, dstZ: int, srcWidth: int, srcHeight: int, srcDepth: int): ...
    def glCopyTexSubImage3D(self, target: int, level: int, xoffset: int, yoffset: int, zoffset: int, x: int, y: int, width: int, height: int): ...
    def glDebugMessageControl(self, source: int, type: int, severity: int, count: int, ids: int, enabled: typing.Char): ...
    def glDebugMessageInsert(self, source: int, type: int, id: int, severity: int, length: int, buf: str): ...
    def glDeleteProgramPipelines(self, n: int, pipelines: int): ...
    def glDeleteQueries(self, n: int, ids: int): ...
    def glDeleteSamplers(self, count: int, samplers: int): ...
    def glDeleteTransformFeedbacks(self, n: int, ids: int): ...
    def glDeleteVertexArrays(self, n: int, arrays: int): ...
    def glDisablei(self, target: int, index: int): ...
    def glDispatchCompute(self, num_groups_x: int, num_groups_y: int, num_groups_z: int): ...
    def glDrawArraysIndirect(self, mode: int, indirect: int): ...
    def glDrawArraysInstanced(self, mode: int, first: int, count: int, instancecount: int): ...
    def glDrawBuffers(self, n: int, bufs: int): ...
    def glDrawElementsBaseVertex(self, mode: int, count: int, type: int, indices: int, basevertex: int): ...
    def glDrawElementsIndirect(self, mode: int, type: int, indirect: int): ...
    def glDrawElementsInstanced(self, mode: int, count: int, type: int, indices: int, instancecount: int): ...
    def glDrawElementsInstancedBaseVertex(self, mode: int, count: int, type: int, indices: int, instancecount: int, basevertex: int): ...
    def glDrawRangeElements(self, mode: int, start: int, end: int, count: int, type: int, indices: int): ...
    def glDrawRangeElementsBaseVertex(self, mode: int, start: int, end: int, count: int, type: int, indices: int, basevertex: int): ...
    def glEnablei(self, target: int, index: int): ...
    def glEndQuery(self, target: int): ...
    def glFramebufferParameteri(self, target: int, pname: int, param: int): ...
    def glFramebufferTexture(self, target: int, attachment: int, texture: int, level: int): ...
    def glFramebufferTextureLayer(self, target: int, attachment: int, texture: int, level: int, layer: int): ...
    def glGenProgramPipelines(self, n: int, pipelines: int): ...
    def glGenQueries(self, n: int, ids: int): ...
    def glGenSamplers(self, count: int, samplers: int): ...
    def glGenTransformFeedbacks(self, n: int, ids: int): ...
    def glGenVertexArrays(self, n: int, arrays: int): ...
    def glGetActiveUniformBlockiv(self, program: int, uniformBlockIndex: int, pname: int, params: int): ...
    def glGetActiveUniformsiv(self, program: int, uniformCount: int, uniformIndices: int, pname: int, params: int): ...
    def glGetBufferParameteri64v(self, target: int, pname: int, params: int): ...
    def glGetFragDataLocation(self, program: int, name: str) -> int: ...
    def glGetFramebufferParameteriv(self, target: int, pname: int, params: int): ...
    def glGetGraphicsResetStatus(self) -> int: ...
    def glGetInteger64i_v(self, target: int, index: int, data: int): ...
    def glGetInteger64v(self, pname: int, data: int): ...
    def glGetIntegeri_v(self, target: int, index: int, data: int): ...
    def glGetInternalformativ(self, target: int, internalformat: int, pname: int, bufSize: int, params: int): ...
    def glGetMultisamplefv(self, pname: int, index: int, val: float): ...
    def glGetProgramBinary(self, program: int, bufSize: int, length: int, binaryFormat: int, binary: int): ...
    def glGetProgramInterfaceiv(self, program: int, programInterface: int, pname: int, params: int): ...
    def glGetProgramPipelineiv(self, pipeline: int, pname: int, params: int): ...
    def glGetProgramResourceIndex(self, program: int, programInterface: int, name: str) -> int: ...
    def glGetProgramResourceLocation(self, program: int, programInterface: int, name: str) -> int: ...
    def glGetProgramResourceiv(self, program: int, programInterface: int, index: int, propCount: int, props: int, bufSize: int, length: int, params: int): ...
    def glGetQueryObjectuiv(self, id: int, pname: int, params: int): ...
    def glGetQueryiv(self, target: int, pname: int, params: int): ...
    def glGetSamplerParameterIiv(self, sampler: int, pname: int, params: int): ...
    def glGetSamplerParameterIuiv(self, sampler: int, pname: int, params: int): ...
    def glGetSamplerParameterfv(self, sampler: int, pname: int, params: float): ...
    def glGetSamplerParameteriv(self, sampler: int, pname: int, params: int): ...
    def glGetStringi(self, name: int, index: int) -> typing.Char: ...
    def glGetTexLevelParameterfv(self, target: int, level: int, pname: int, params: float): ...
    def glGetTexLevelParameteriv(self, target: int, level: int, pname: int, params: int): ...
    def glGetTexParameterIiv(self, target: int, pname: int, params: int): ...
    def glGetTexParameterIuiv(self, target: int, pname: int, params: int): ...
    def glGetUniformBlockIndex(self, program: int, uniformBlockName: str) -> int: ...
    def glGetUniformuiv(self, program: int, location: int, params: int): ...
    def glGetVertexAttribIiv(self, index: int, pname: int, params: int): ...
    def glGetVertexAttribIuiv(self, index: int, pname: int, params: int): ...
    def glGetnUniformfv(self, program: int, location: int, bufSize: int, params: float): ...
    def glGetnUniformiv(self, program: int, location: int, bufSize: int, params: int): ...
    def glGetnUniformuiv(self, program: int, location: int, bufSize: int, params: int): ...
    def glInvalidateFramebuffer(self, target: int, numAttachments: int, attachments: int): ...
    def glInvalidateSubFramebuffer(self, target: int, numAttachments: int, attachments: int, x: int, y: int, width: int, height: int): ...
    def glIsEnabledi(self, target: int, index: int) -> typing.Char: ...
    def glIsProgramPipeline(self, pipeline: int) -> typing.Char: ...
    def glIsQuery(self, id: int) -> typing.Char: ...
    def glIsSampler(self, sampler: int) -> typing.Char: ...
    def glIsTransformFeedback(self, id: int) -> typing.Char: ...
    def glIsVertexArray(self, array: int) -> typing.Char: ...
    def glMemoryBarrier(self, barriers: int): ...
    def glMemoryBarrierByRegion(self, barriers: int): ...
    def glMinSampleShading(self, value: float): ...
    def glObjectLabel(self, identifier: int, name: int, length: int, label: str): ...
    def glObjectPtrLabel(self, ptr: int, length: int, label: str): ...
    def glPatchParameteri(self, pname: int, value: int): ...
    def glPopDebugGroup(self): ...
    def glPrimitiveBoundingBox(self, minX: float, minY: float, minZ: float, minW: float, maxX: float, maxY: float, maxZ: float, maxW: float): ...
    def glProgramBinary(self, program: int, binaryFormat: int, binary: int, length: int): ...
    def glProgramParameteri(self, program: int, pname: int, value: int): ...
    def glProgramUniform1f(self, program: int, location: int, v0: float): ...
    def glProgramUniform1fv(self, program: int, location: int, count: int, value: float): ...
    def glProgramUniform1i(self, program: int, location: int, v0: int): ...
    def glProgramUniform1iv(self, program: int, location: int, count: int, value: int): ...
    def glProgramUniform1ui(self, program: int, location: int, v0: int): ...
    def glProgramUniform1uiv(self, program: int, location: int, count: int, value: int): ...
    def glProgramUniform2f(self, program: int, location: int, v0: float, v1: float): ...
    def glProgramUniform2fv(self, program: int, location: int, count: int, value: float): ...
    def glProgramUniform2i(self, program: int, location: int, v0: int, v1: int): ...
    def glProgramUniform2iv(self, program: int, location: int, count: int, value: int): ...
    def glProgramUniform2ui(self, program: int, location: int, v0: int, v1: int): ...
    def glProgramUniform2uiv(self, program: int, location: int, count: int, value: int): ...
    def glProgramUniform3f(self, program: int, location: int, v0: float, v1: float, v2: float): ...
    def glProgramUniform3fv(self, program: int, location: int, count: int, value: float): ...
    def glProgramUniform3i(self, program: int, location: int, v0: int, v1: int, v2: int): ...
    def glProgramUniform3iv(self, program: int, location: int, count: int, value: int): ...
    def glProgramUniform3ui(self, program: int, location: int, v0: int, v1: int, v2: int): ...
    def glProgramUniform3uiv(self, program: int, location: int, count: int, value: int): ...
    def glProgramUniform4f(self, program: int, location: int, v0: float, v1: float, v2: float, v3: float): ...
    def glProgramUniform4fv(self, program: int, location: int, count: int, value: float): ...
    def glProgramUniform4i(self, program: int, location: int, v0: int, v1: int, v2: int, v3: int): ...
    def glProgramUniform4iv(self, program: int, location: int, count: int, value: int): ...
    def glProgramUniform4ui(self, program: int, location: int, v0: int, v1: int, v2: int, v3: int): ...
    def glProgramUniform4uiv(self, program: int, location: int, count: int, value: int): ...
    def glProgramUniformMatrix2fv(self, program: int, location: int, count: int, transpose: typing.Char, value: float): ...
    def glProgramUniformMatrix2x3fv(self, program: int, location: int, count: int, transpose: typing.Char, value: float): ...
    def glProgramUniformMatrix2x4fv(self, program: int, location: int, count: int, transpose: typing.Char, value: float): ...
    def glProgramUniformMatrix3fv(self, program: int, location: int, count: int, transpose: typing.Char, value: float): ...
    def glProgramUniformMatrix3x2fv(self, program: int, location: int, count: int, transpose: typing.Char, value: float): ...
    def glProgramUniformMatrix3x4fv(self, program: int, location: int, count: int, transpose: typing.Char, value: float): ...
    def glProgramUniformMatrix4fv(self, program: int, location: int, count: int, transpose: typing.Char, value: float): ...
    def glProgramUniformMatrix4x2fv(self, program: int, location: int, count: int, transpose: typing.Char, value: float): ...
    def glProgramUniformMatrix4x3fv(self, program: int, location: int, count: int, transpose: typing.Char, value: float): ...
    def glPushDebugGroup(self, source: int, id: int, length: int, message: str): ...
    def glReadBuffer(self, mode: int): ...
    def glReadnPixels(self, x: int, y: int, width: int, height: int, format: int, type: int, bufSize: int, data: int): ...
    def glRenderbufferStorageMultisample(self, target: int, samples: int, internalformat: int, width: int, height: int): ...
    def glSampleMaski(self, maskNumber: int, mask: int): ...
    def glSamplerParameterIiv(self, sampler: int, pname: int, param: int): ...
    def glSamplerParameterIuiv(self, sampler: int, pname: int, param: int): ...
    def glSamplerParameterf(self, sampler: int, pname: int, param: float): ...
    def glSamplerParameterfv(self, sampler: int, pname: int, param: float): ...
    def glSamplerParameteri(self, sampler: int, pname: int, param: int): ...
    def glSamplerParameteriv(self, sampler: int, pname: int, param: int): ...
    def glTexBuffer(self, target: int, internalformat: int, buffer: int): ...
    def glTexImage3D(self, target: int, level: int, internalformat: int, width: int, height: int, depth: int, border: int, format: int, type: int, pixels: int): ...
    def glTexParameterIiv(self, target: int, pname: int, params: int): ...
    def glTexParameterIuiv(self, target: int, pname: int, params: int): ...
    def glTexStorage2D(self, target: int, levels: int, internalformat: int, width: int, height: int): ...
    def glTexStorage2DMultisample(self, target: int, samples: int, internalformat: int, width: int, height: int, fixedsamplelocations: typing.Char): ...
    def glTexStorage3D(self, target: int, levels: int, internalformat: int, width: int, height: int, depth: int): ...
    def glTexStorage3DMultisample(self, target: int, samples: int, internalformat: int, width: int, height: int, depth: int, fixedsamplelocations: typing.Char): ...
    def glTexSubImage3D(self, target: int, level: int, xoffset: int, yoffset: int, zoffset: int, width: int, height: int, depth: int, format: int, type: int, pixels: int): ...
    def glUniform1ui(self, location: int, v0: int): ...
    def glUniform1uiv(self, location: int, count: int, value: int): ...
    def glUniform2ui(self, location: int, v0: int, v1: int): ...
    def glUniform2uiv(self, location: int, count: int, value: int): ...
    def glUniform3ui(self, location: int, v0: int, v1: int, v2: int): ...
    def glUniform3uiv(self, location: int, count: int, value: int): ...
    def glUniform4ui(self, location: int, v0: int, v1: int, v2: int, v3: int): ...
    def glUniform4uiv(self, location: int, count: int, value: int): ...
    def glUniformBlockBinding(self, program: int, uniformBlockIndex: int, uniformBlockBinding: int): ...
    def glUniformMatrix2x3fv(self, location: int, count: int, transpose: typing.Char, value: float): ...
    def glUniformMatrix2x4fv(self, location: int, count: int, transpose: typing.Char, value: float): ...
    def glUniformMatrix3x2fv(self, location: int, count: int, transpose: typing.Char, value: float): ...
    def glUniformMatrix3x4fv(self, location: int, count: int, transpose: typing.Char, value: float): ...
    def glUniformMatrix4x2fv(self, location: int, count: int, transpose: typing.Char, value: float): ...
    def glUniformMatrix4x3fv(self, location: int, count: int, transpose: typing.Char, value: float): ...
    def glUnmapBuffer(self, target: int) -> typing.Char: ...
    def glUseProgramStages(self, pipeline: int, stages: int, program: int): ...
    def glValidateProgramPipeline(self, pipeline: int): ...
    def glVertexAttribBinding(self, attribindex: int, bindingindex: int): ...
    def glVertexAttribDivisor(self, index: int, divisor: int): ...
    def glVertexAttribFormat(self, attribindex: int, size: int, type: int, normalized: typing.Char, relativeoffset: int): ...
    def glVertexAttribI4i(self, index: int, x: int, y: int, z: int, w: int): ...
    def glVertexAttribI4iv(self, index: int, v: int): ...
    def glVertexAttribI4ui(self, index: int, x: int, y: int, z: int, w: int): ...
    def glVertexAttribI4uiv(self, index: int, v: int): ...
    def glVertexAttribIFormat(self, attribindex: int, size: int, type: int, relativeoffset: int): ...
    def glVertexAttribIPointer(self, index: int, size: int, type: int, stride: int, pointer: int): ...
    def glVertexBindingDivisor(self, bindingindex: int, divisor: int): ...


class QOpenGLFramebufferObject(Shiboken.Object):

    @typing.overload
    def __init__(self, size: PySide2.QtCore.QSize, attachment: PySide2.QtGui.QOpenGLFramebufferObject.Attachment, target: int = ..., internalFormat: int = ...): ...
    @typing.overload
    def __init__(self, size: PySide2.QtCore.QSize, format: PySide2.QtGui.QOpenGLFramebufferObjectFormat): ...
    @typing.overload
    def __init__(self, size: PySide2.QtCore.QSize, target: int = ...): ...
    @typing.overload
    def __init__(self, width: int, height: int, attachment: PySide2.QtGui.QOpenGLFramebufferObject.Attachment, target: int = ..., internalFormat: int = ...): ...
    @typing.overload
    def __init__(self, width: int, height: int, format: PySide2.QtGui.QOpenGLFramebufferObjectFormat): ...
    @typing.overload
    def __init__(self, width: int, height: int, target: int = ...): ...
    @typing.overload
    def addColorAttachment(self, size: PySide2.QtCore.QSize, internalFormat: int = ...): ...
    @typing.overload
    def addColorAttachment(self, width: int, height: int, internalFormat: int = ...): ...
    def attachment(self) -> PySide2.QtGui.QOpenGLFramebufferObject.Attachment: ...
    def bind(self) -> bool: ...
    @staticmethod
    def bindDefault() -> bool: ...
    @typing.overload
    @staticmethod
    def blitFramebuffer(target: PySide2.QtGui.QOpenGLFramebufferObject, source: PySide2.QtGui.QOpenGLFramebufferObject, buffers: int = ..., filter: int = ...): ...
    @typing.overload
    @staticmethod
    def blitFramebuffer(target: PySide2.QtGui.QOpenGLFramebufferObject, targetRect: PySide2.QtCore.QRect, source: PySide2.QtGui.QOpenGLFramebufferObject, sourceRect: PySide2.QtCore.QRect, buffers: int, filter: int, readColorAttachmentIndex: int, drawColorAttachmentIndex: int): ...
    @typing.overload
    @staticmethod
    def blitFramebuffer(target: PySide2.QtGui.QOpenGLFramebufferObject, targetRect: PySide2.QtCore.QRect, source: PySide2.QtGui.QOpenGLFramebufferObject, sourceRect: PySide2.QtCore.QRect, buffers: int, filter: int, readColorAttachmentIndex: int, drawColorAttachmentIndex: int, restorePolicy: PySide2.QtGui.QOpenGLFramebufferObject.FramebufferRestorePolicy): ...
    @typing.overload
    @staticmethod
    def blitFramebuffer(target: PySide2.QtGui.QOpenGLFramebufferObject, targetRect: PySide2.QtCore.QRect, source: PySide2.QtGui.QOpenGLFramebufferObject, sourceRect: PySide2.QtCore.QRect, buffers: int = ..., filter: int = ...): ...
    def format(self) -> PySide2.QtGui.QOpenGLFramebufferObjectFormat: ...
    def handle(self) -> int: ...
    @staticmethod
    def hasOpenGLFramebufferBlit() -> bool: ...
    @staticmethod
    def hasOpenGLFramebufferObjects() -> bool: ...
    def height(self) -> int: ...
    def isBound(self) -> bool: ...
    def isValid(self) -> bool: ...
    def release(self) -> bool: ...
    def setAttachment(self, attachment: PySide2.QtGui.QOpenGLFramebufferObject.Attachment): ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def sizes(self) -> typing.List[PySide2.QtCore.QSize]: ...
    @typing.overload
    def takeTexture(self) -> int: ...
    @typing.overload
    def takeTexture(self, colorAttachmentIndex: int) -> int: ...
    def texture(self) -> int: ...
    def textures(self) -> typing.List[int]: ...
    @typing.overload
    def toImage(self) -> PySide2.QtGui.QImage: ...
    @typing.overload
    def toImage(self, flipped: bool) -> PySide2.QtGui.QImage: ...
    @typing.overload
    def toImage(self, flipped: bool, colorAttachmentIndex: int) -> PySide2.QtGui.QImage: ...
    def width(self) -> int: ...


class QOpenGLFramebufferObjectFormat(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QOpenGLFramebufferObjectFormat): ...
    def __copy__(self): ...
    def attachment(self) -> PySide2.QtGui.QOpenGLFramebufferObject.Attachment: ...
    def internalTextureFormat(self) -> int: ...
    def mipmap(self) -> bool: ...
    def samples(self) -> int: ...
    def setAttachment(self, attachment: PySide2.QtGui.QOpenGLFramebufferObject.Attachment): ...
    def setInternalTextureFormat(self, internalTextureFormat: int): ...
    def setMipmap(self, enabled: bool): ...
    def setSamples(self, samples: int): ...
    def setTextureTarget(self, target: int): ...
    def textureTarget(self) -> int: ...


class QOpenGLFunctions(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, context: PySide2.QtGui.QOpenGLContext): ...
    def glActiveTexture(self, texture: int): ...
    def glAttachShader(self, program: int, shader: int): ...
    def glBindAttribLocation(self, program: int, index: int, name: str): ...
    def glBindBuffer(self, target: int, buffer: int): ...
    def glBindFramebuffer(self, target: int, framebuffer: int): ...
    def glBindRenderbuffer(self, target: int, renderbuffer: int): ...
    def glBindTexture(self, target: int, texture: int): ...
    def glBlendColor(self, red: float, green: float, blue: float, alpha: float): ...
    def glBlendEquation(self, mode: int): ...
    def glBlendEquationSeparate(self, modeRGB: int, modeAlpha: int): ...
    def glBlendFunc(self, sfactor: int, dfactor: int): ...
    def glBlendFuncSeparate(self, srcRGB: int, dstRGB: int, srcAlpha: int, dstAlpha: int): ...
    def glCheckFramebufferStatus(self, target: int) -> int: ...
    def glClear(self, mask: int): ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float): ...
    def glClearDepthf(self, depth: float): ...
    def glClearStencil(self, s: int): ...
    def glColorMask(self, red: typing.Char, green: typing.Char, blue: typing.Char, alpha: typing.Char): ...
    def glCompileShader(self, shader: int): ...
    def glCompressedTexImage2D(self, target: int, level: int, internalformat: int, width: int, height: int, border: int, imageSize: int, data: int): ...
    def glCompressedTexSubImage2D(self, target: int, level: int, xoffset: int, yoffset: int, width: int, height: int, format: int, imageSize: int, data: int): ...
    def glCopyTexImage2D(self, target: int, level: int, internalformat: int, x: int, y: int, width: int, height: int, border: int): ...
    def glCopyTexSubImage2D(self, target: int, level: int, xoffset: int, yoffset: int, x: int, y: int, width: int, height: int): ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type: int) -> int: ...
    def glCullFace(self, mode: int): ...
    def glDeleteBuffers(self, n: int, buffers: int): ...
    def glDeleteFramebuffers(self, n: int, framebuffers: int): ...
    def glDeleteProgram(self, program: int): ...
    def glDeleteRenderbuffers(self, n: int, renderbuffers: int): ...
    def glDeleteShader(self, shader: int): ...
    def glDeleteTextures(self, n: int, textures: int): ...
    def glDepthFunc(self, func: int): ...
    def glDepthMask(self, flag: typing.Char): ...
    def glDepthRangef(self, zNear: float, zFar: float): ...
    def glDetachShader(self, program: int, shader: int): ...
    def glDisable(self, cap: int): ...
    def glDisableVertexAttribArray(self, index: int): ...
    def glDrawArrays(self, mode: int, first: int, count: int): ...
    def glDrawElements(self, mode: int, count: int, type: int, indices: int): ...
    def glEnable(self, cap: int): ...
    def glEnableVertexAttribArray(self, index: int): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFramebufferRenderbuffer(self, target: int, attachment: int, renderbuffertarget: int, renderbuffer: int): ...
    def glFramebufferTexture2D(self, target: int, attachment: int, textarget: int, texture: int, level: int): ...
    def glFrontFace(self, mode: int): ...
    def glGenBuffers(self, n: int, buffers: int): ...
    def glGenFramebuffers(self, n: int, framebuffers: int): ...
    def glGenRenderbuffers(self, n: int, renderbuffers: int): ...
    def glGenTextures(self, n: int, textures: int): ...
    def glGenerateMipmap(self, target: int): ...
    def glGetAttachedShaders(self, program: int, maxcount: int, count: int, shaders: int): ...
    def glGetAttribLocation(self, program: int, name: str) -> int: ...
    def glGetBufferParameteriv(self, target: int, pname: int, params: int): ...
    def glGetError(self) -> int: ...
    def glGetFloatv(self, pname: int, params: float): ...
    def glGetFramebufferAttachmentParameteriv(self, target: int, attachment: int, pname: int, params: int): ...
    def glGetIntegerv(self, pname: int, params: int): ...
    def glGetProgramiv(self, program: int, pname: int, params: int): ...
    def glGetRenderbufferParameteriv(self, target: int, pname: int, params: int): ...
    def glGetShaderPrecisionFormat(self, shadertype: int, precisiontype: int, range: int, precision: int): ...
    def glGetShaderiv(self, shader: int, pname: int, params: int): ...
    def glGetString(self, name: int) -> typing.Char: ...
    def glGetTexParameterfv(self, target: int, pname: int, params: float): ...
    def glGetTexParameteriv(self, target: int, pname: int, params: int): ...
    def glGetUniformLocation(self, program: int, name: str) -> int: ...
    def glGetUniformfv(self, program: int, location: int, params: float): ...
    def glGetUniformiv(self, program: int, location: int, params: int): ...
    def glGetVertexAttribfv(self, index: int, pname: int, params: float): ...
    def glGetVertexAttribiv(self, index: int, pname: int, params: int): ...
    def glHint(self, target: int, mode: int): ...
    def glIsBuffer(self, buffer: int) -> typing.Char: ...
    def glIsEnabled(self, cap: int) -> typing.Char: ...
    def glIsFramebuffer(self, framebuffer: int) -> typing.Char: ...
    def glIsProgram(self, program: int) -> typing.Char: ...
    def glIsRenderbuffer(self, renderbuffer: int) -> typing.Char: ...
    def glIsShader(self, shader: int) -> typing.Char: ...
    def glIsTexture(self, texture: int) -> typing.Char: ...
    def glLineWidth(self, width: float): ...
    def glLinkProgram(self, program: int): ...
    def glPixelStorei(self, pname: int, param: int): ...
    def glPolygonOffset(self, factor: float, units: float): ...
    def glReadPixels(self, x: int, y: int, width: int, height: int, format: int, type: int, pixels: int): ...
    def glReleaseShaderCompiler(self): ...
    def glRenderbufferStorage(self, target: int, internalformat: int, width: int, height: int): ...
    def glSampleCoverage(self, value: float, invert: typing.Char): ...
    def glScissor(self, x: int, y: int, width: int, height: int): ...
    def glShaderBinary(self, n: int, shaders: int, binaryformat: int, binary: int, length: int): ...
    def glStencilFunc(self, func: int, ref: int, mask: int): ...
    def glStencilFuncSeparate(self, face: int, func: int, ref: int, mask: int): ...
    def glStencilMask(self, mask: int): ...
    def glStencilMaskSeparate(self, face: int, mask: int): ...
    def glStencilOp(self, fail: int, zfail: int, zpass: int): ...
    def glStencilOpSeparate(self, face: int, fail: int, zfail: int, zpass: int): ...
    def glTexImage2D(self, target: int, level: int, internalformat: int, width: int, height: int, border: int, format: int, type: int, pixels: int): ...
    def glTexParameterf(self, target: int, pname: int, param: float): ...
    def glTexParameterfv(self, target: int, pname: int, params: float): ...
    def glTexParameteri(self, target: int, pname: int, param: int): ...
    def glTexParameteriv(self, target: int, pname: int, params: int): ...
    def glTexSubImage2D(self, target: int, level: int, xoffset: int, yoffset: int, width: int, height: int, format: int, type: int, pixels: int): ...
    def glUniform1f(self, location: int, x: float): ...
    def glUniform1fv(self, location: int, count: int, v: float): ...
    def glUniform1i(self, location: int, x: int): ...
    def glUniform1iv(self, location: int, count: int, v: int): ...
    def glUniform2f(self, location: int, x: float, y: float): ...
    def glUniform2fv(self, location: int, count: int, v: float): ...
    def glUniform2i(self, location: int, x: int, y: int): ...
    def glUniform2iv(self, location: int, count: int, v: int): ...
    def glUniform3f(self, location: int, x: float, y: float, z: float): ...
    def glUniform3fv(self, location: int, count: int, v: float): ...
    def glUniform3i(self, location: int, x: int, y: int, z: int): ...
    def glUniform3iv(self, location: int, count: int, v: int): ...
    def glUniform4f(self, location: int, x: float, y: float, z: float, w: float): ...
    def glUniform4fv(self, location: int, count: int, v: float): ...
    def glUniform4i(self, location: int, x: int, y: int, z: int, w: int): ...
    def glUniform4iv(self, location: int, count: int, v: int): ...
    def glUniformMatrix2fv(self, location: int, count: int, transpose: typing.Char, value: float): ...
    def glUniformMatrix3fv(self, location: int, count: int, transpose: typing.Char, value: float): ...
    def glUniformMatrix4fv(self, location: int, count: int, transpose: typing.Char, value: float): ...
    def glUseProgram(self, program: int): ...
    def glValidateProgram(self, program: int): ...
    def glVertexAttrib1f(self, indx: int, x: float): ...
    def glVertexAttrib1fv(self, indx: int, values: float): ...
    def glVertexAttrib2f(self, indx: int, x: float, y: float): ...
    def glVertexAttrib2fv(self, indx: int, values: float): ...
    def glVertexAttrib3f(self, indx: int, x: float, y: float, z: float): ...
    def glVertexAttrib3fv(self, indx: int, values: float): ...
    def glVertexAttrib4f(self, indx: int, x: float, y: float, z: float, w: float): ...
    def glVertexAttrib4fv(self, indx: int, values: float): ...
    def glVertexAttribPointer(self, indx: int, size: int, type: int, normalized: typing.Char, stride: int, ptr: int): ...
    def glViewport(self, x: int, y: int, width: int, height: int): ...
    def hasOpenGLFeature(self, feature: PySide2.QtGui.QOpenGLFunctions.OpenGLFeature) -> bool: ...
    def initializeOpenGLFunctions(self): ...
    def openGLFeatures(self) -> PySide2.QtGui.QOpenGLFunctions.OpenGLFeatures: ...


class QOpenGLPixelTransferOptions(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QOpenGLPixelTransferOptions): ...
    def __copy__(self): ...
    def alignment(self) -> int: ...
    def imageHeight(self) -> int: ...
    def isLeastSignificantBitFirst(self) -> bool: ...
    def isSwapBytesEnabled(self) -> bool: ...
    def rowLength(self) -> int: ...
    def setAlignment(self, alignment: int): ...
    def setImageHeight(self, imageHeight: int): ...
    def setLeastSignificantByteFirst(self, lsbFirst: bool): ...
    def setRowLength(self, rowLength: int): ...
    def setSkipImages(self, skipImages: int): ...
    def setSkipPixels(self, skipPixels: int): ...
    def setSkipRows(self, skipRows: int): ...
    def setSwapBytesEnabled(self, swapBytes: bool): ...
    def skipImages(self) -> int: ...
    def skipPixels(self) -> int: ...
    def skipRows(self) -> int: ...
    def swap(self, other: PySide2.QtGui.QOpenGLPixelTransferOptions): ...


class QOpenGLShader(PySide2.QtCore.QObject):

    def __init__(self, type: PySide2.QtGui.QOpenGLShader.ShaderType, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def compileSourceCode(self, source: PySide2.QtCore.QByteArray) -> bool: ...
    @typing.overload
    def compileSourceCode(self, source: str) -> bool: ...
    @typing.overload
    def compileSourceCode(self, source: str) -> bool: ...
    def compileSourceFile(self, fileName: str) -> bool: ...
    @staticmethod
    def hasOpenGLShaders(type: PySide2.QtGui.QOpenGLShader.ShaderType, context: PySide2.QtGui.QOpenGLContext = ...) -> bool: ...
    def isCompiled(self) -> bool: ...
    def log(self) -> str: ...
    def shaderId(self) -> int: ...
    def shaderType(self) -> PySide2.QtGui.QOpenGLShader.ShaderType: ...
    def sourceCode(self) -> PySide2.QtCore.QByteArray: ...


class QOpenGLShaderProgram(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def addCacheableShaderFromSourceCode(self, type: PySide2.QtGui.QOpenGLShader.ShaderType, source: PySide2.QtCore.QByteArray) -> bool: ...
    @typing.overload
    def addCacheableShaderFromSourceCode(self, type: PySide2.QtGui.QOpenGLShader.ShaderType, source: str) -> bool: ...
    @typing.overload
    def addCacheableShaderFromSourceCode(self, type: PySide2.QtGui.QOpenGLShader.ShaderType, source: str) -> bool: ...
    def addCacheableShaderFromSourceFile(self, type: PySide2.QtGui.QOpenGLShader.ShaderType, fileName: str) -> bool: ...
    def addShader(self, shader: PySide2.QtGui.QOpenGLShader) -> bool: ...
    @typing.overload
    def addShaderFromSourceCode(self, type: PySide2.QtGui.QOpenGLShader.ShaderType, source: PySide2.QtCore.QByteArray) -> bool: ...
    @typing.overload
    def addShaderFromSourceCode(self, type: PySide2.QtGui.QOpenGLShader.ShaderType, source: str) -> bool: ...
    @typing.overload
    def addShaderFromSourceCode(self, type: PySide2.QtGui.QOpenGLShader.ShaderType, source: str) -> bool: ...
    def addShaderFromSourceFile(self, type: PySide2.QtGui.QOpenGLShader.ShaderType, fileName: str) -> bool: ...
    @typing.overload
    def attributeLocation(self, name: PySide2.QtCore.QByteArray) -> int: ...
    @typing.overload
    def attributeLocation(self, name: str) -> int: ...
    @typing.overload
    def attributeLocation(self, name: str) -> int: ...
    def bind(self) -> bool: ...
    @typing.overload
    def bindAttributeLocation(self, name: PySide2.QtCore.QByteArray, location: int): ...
    @typing.overload
    def bindAttributeLocation(self, name: str, location: int): ...
    @typing.overload
    def bindAttributeLocation(self, name: str, location: int): ...
    def create(self) -> bool: ...
    def defaultInnerTessellationLevels(self) -> typing.List[float]: ...
    def defaultOuterTessellationLevels(self) -> typing.List[float]: ...
    @typing.overload
    def disableAttributeArray(self, location: int): ...
    @typing.overload
    def disableAttributeArray(self, name: str): ...
    @typing.overload
    def enableAttributeArray(self, location: int): ...
    @typing.overload
    def enableAttributeArray(self, name: str): ...
    @staticmethod
    def hasOpenGLShaderPrograms(context: PySide2.QtGui.QOpenGLContext = ...) -> bool: ...
    def isLinked(self) -> bool: ...
    def link(self) -> bool: ...
    def log(self) -> str: ...
    def maxGeometryOutputVertices(self) -> int: ...
    def patchVertexCount(self) -> int: ...
    def programId(self) -> int: ...
    def release(self): ...
    def removeAllShaders(self): ...
    def removeShader(self, shader: PySide2.QtGui.QOpenGLShader): ...
    @typing.overload
    def setAttributeArray(self, location: int, type: int, values: int, tupleSize: int, stride: int = ...): ...
    @typing.overload
    def setAttributeArray(self, location: int, values: float, tupleSize: int, stride: int = ...): ...
    @typing.overload
    def setAttributeArray(self, name: str, type: int, values: int, tupleSize: int, stride: int = ...): ...
    @typing.overload
    def setAttributeArray(self, name: str, values: float, tupleSize: int, stride: int = ...): ...
    @typing.overload
    def setAttributeBuffer(self, location: int, type: int, offset: int, tupleSize: int, stride: int = ...): ...
    @typing.overload
    def setAttributeBuffer(self, name: str, type: int, offset: int, tupleSize: int, stride: int = ...): ...
    @typing.overload
    def setAttributeValue(self, location: int, value: PySide2.QtGui.QColor): ...
    @typing.overload
    def setAttributeValue(self, location: int, value: PySide2.QtGui.QVector2D): ...
    @typing.overload
    def setAttributeValue(self, location: int, value: PySide2.QtGui.QVector3D): ...
    @typing.overload
    def setAttributeValue(self, location: int, value: PySide2.QtGui.QVector4D): ...
    @typing.overload
    def setAttributeValue(self, location: int, value: float): ...
    @typing.overload
    def setAttributeValue(self, location: int, values: float, columns: int, rows: int): ...
    @typing.overload
    def setAttributeValue(self, location: int, x: float, y: float): ...
    @typing.overload
    def setAttributeValue(self, location: int, x: float, y: float, z: float): ...
    @typing.overload
    def setAttributeValue(self, location: int, x: float, y: float, z: float, w: float): ...
    @typing.overload
    def setAttributeValue(self, name: str, value: PySide2.QtGui.QColor): ...
    @typing.overload
    def setAttributeValue(self, name: str, value: PySide2.QtGui.QVector2D): ...
    @typing.overload
    def setAttributeValue(self, name: str, value: PySide2.QtGui.QVector3D): ...
    @typing.overload
    def setAttributeValue(self, name: str, value: PySide2.QtGui.QVector4D): ...
    @typing.overload
    def setAttributeValue(self, name: str, value: float): ...
    @typing.overload
    def setAttributeValue(self, name: str, values: float, columns: int, rows: int): ...
    @typing.overload
    def setAttributeValue(self, name: str, x: float, y: float): ...
    @typing.overload
    def setAttributeValue(self, name: str, x: float, y: float, z: float): ...
    @typing.overload
    def setAttributeValue(self, name: str, x: float, y: float, z: float, w: float): ...
    def setDefaultInnerTessellationLevels(self, levels: typing.List[float]): ...
    def setDefaultOuterTessellationLevels(self, levels: typing.List[float]): ...
    def setPatchVertexCount(self, count: int): ...
    @typing.overload
    def setUniformValue(self, location: int, color: PySide2.QtGui.QColor): ...
    @typing.overload
    def setUniformValue(self, location: int, point: PySide2.QtCore.QPoint): ...
    @typing.overload
    def setUniformValue(self, location: int, point: PySide2.QtCore.QPointF): ...
    @typing.overload
    def setUniformValue(self, location: int, size: PySide2.QtCore.QSize): ...
    @typing.overload
    def setUniformValue(self, location: int, size: PySide2.QtCore.QSizeF): ...
    @typing.overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QMatrix2x2): ...
    @typing.overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QMatrix2x3): ...
    @typing.overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QMatrix2x4): ...
    @typing.overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QMatrix3x2): ...
    @typing.overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QMatrix3x3): ...
    @typing.overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QMatrix3x4): ...
    @typing.overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QMatrix4x2): ...
    @typing.overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QMatrix4x3): ...
    @typing.overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QMatrix4x4): ...
    @typing.overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QTransform): ...
    @typing.overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QVector2D): ...
    @typing.overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QVector3D): ...
    @typing.overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QVector4D): ...
    @typing.overload
    def setUniformValue(self, location: int, value: float): ...
    @typing.overload
    def setUniformValue(self, location: int, value: typing.List[typing.List[float]]): ...
    @typing.overload
    def setUniformValue(self, location: int, value: int): ...
    @typing.overload
    def setUniformValue(self, location: int, value: int): ...
    @typing.overload
    def setUniformValue(self, location: int, x: float, y: float): ...
    @typing.overload
    def setUniformValue(self, location: int, x: float, y: float, z: float): ...
    @typing.overload
    def setUniformValue(self, location: int, x: float, y: float, z: float, w: float): ...
    @typing.overload
    def setUniformValue(self, name: str, color: PySide2.QtGui.QColor): ...
    @typing.overload
    def setUniformValue(self, name: str, point: PySide2.QtCore.QPoint): ...
    @typing.overload
    def setUniformValue(self, name: str, point: PySide2.QtCore.QPointF): ...
    @typing.overload
    def setUniformValue(self, name: str, size: PySide2.QtCore.QSize): ...
    @typing.overload
    def setUniformValue(self, name: str, size: PySide2.QtCore.QSizeF): ...
    @typing.overload
    def setUniformValue(self, name: str, value: PySide2.QtGui.QMatrix2x2): ...
    @typing.overload
    def setUniformValue(self, name: str, value: PySide2.QtGui.QMatrix2x3): ...
    @typing.overload
    def setUniformValue(self, name: str, value: PySide2.QtGui.QMatrix2x4): ...
    @typing.overload
    def setUniformValue(self, name: str, value: PySide2.QtGui.QMatrix3x2): ...
    @typing.overload
    def setUniformValue(self, name: str, value: PySide2.QtGui.QMatrix3x3): ...
    @typing.overload
    def setUniformValue(self, name: str, value: PySide2.QtGui.QMatrix3x4): ...
    @typing.overload
    def setUniformValue(self, name: str, value: PySide2.QtGui.QMatrix4x2): ...
    @typing.overload
    def setUniformValue(self, name: str, value: PySide2.QtGui.QMatrix4x3): ...
    @typing.overload
    def setUniformValue(self, name: str, value: PySide2.QtGui.QMatrix4x4): ...
    @typing.overload
    def setUniformValue(self, name: str, value: PySide2.QtGui.QTransform): ...
    @typing.overload
    def setUniformValue(self, name: str, value: PySide2.QtGui.QVector2D): ...
    @typing.overload
    def setUniformValue(self, name: str, value: PySide2.QtGui.QVector3D): ...
    @typing.overload
    def setUniformValue(self, name: str, value: PySide2.QtGui.QVector4D): ...
    @typing.overload
    def setUniformValue(self, name: str, value: typing.List[typing.List[float]]): ...
    @typing.overload
    def setUniformValue(self, name: str, x: float, y: float): ...
    @typing.overload
    def setUniformValue(self, name: str, x: float, y: float, z: float): ...
    @typing.overload
    def setUniformValue(self, name: str, x: float, y: float, z: float, w: float): ...
    @typing.overload
    def setUniformValue1f(self, arg__1: int, arg__2: float): ...
    @typing.overload
    def setUniformValue1f(self, arg__1: str, arg__2: float): ...
    @typing.overload
    def setUniformValue1i(self, arg__1: int, arg__2: int): ...
    @typing.overload
    def setUniformValue1i(self, arg__1: str, arg__2: int): ...
    @typing.overload
    def setUniformValueArray(self, location: int, values: float, count: int, tupleSize: int): ...
    @typing.overload
    def setUniformValueArray(self, location: int, values: int, count: int): ...
    @typing.overload
    def setUniformValueArray(self, location: int, values: int, count: int): ...
    @typing.overload
    def setUniformValueArray(self, name: str, values: float, count: int, tupleSize: int): ...
    @typing.overload
    def setUniformValueArray(self, name: str, values: int, count: int): ...
    @typing.overload
    def setUniformValueArray(self, name: str, values: int, count: int): ...
    def shaders(self) -> typing.List[PySide2.QtGui.QOpenGLShader]: ...
    @typing.overload
    def uniformLocation(self, name: PySide2.QtCore.QByteArray) -> int: ...
    @typing.overload
    def uniformLocation(self, name: str) -> int: ...
    @typing.overload
    def uniformLocation(self, name: str) -> int: ...


class QOpenGLTexture(Shiboken.Object):

    @typing.overload
    def __init__(self, image: PySide2.QtGui.QImage, genMipMaps: PySide2.QtGui.QOpenGLTexture.MipMapGeneration = ...): ...
    @typing.overload
    def __init__(self, target: PySide2.QtGui.QOpenGLTexture.Target): ...
    @typing.overload
    def allocateStorage(self): ...
    @typing.overload
    def allocateStorage(self, pixelFormat: PySide2.QtGui.QOpenGLTexture.PixelFormat, pixelType: PySide2.QtGui.QOpenGLTexture.PixelType): ...
    @typing.overload
    def bind(self): ...
    @typing.overload
    def bind(self, unit: int, reset: PySide2.QtGui.QOpenGLTexture.TextureUnitReset = ...): ...
    def borderColor(self) -> PySide2.QtGui.QColor: ...
    @typing.overload
    @staticmethod
    def boundTextureId(target: PySide2.QtGui.QOpenGLTexture.BindingTarget) -> int: ...
    @typing.overload
    @staticmethod
    def boundTextureId(unit: int, target: PySide2.QtGui.QOpenGLTexture.BindingTarget) -> int: ...
    def comparisonFunction(self) -> PySide2.QtGui.QOpenGLTexture.ComparisonFunction: ...
    def comparisonMode(self) -> PySide2.QtGui.QOpenGLTexture.ComparisonMode: ...
    def create(self) -> bool: ...
    def createTextureView(self, target: PySide2.QtGui.QOpenGLTexture.Target, viewFormat: PySide2.QtGui.QOpenGLTexture.TextureFormat, minimumMipmapLevel: int, maximumMipmapLevel: int, minimumLayer: int, maximumLayer: int) -> PySide2.QtGui.QOpenGLTexture: ...
    def depth(self) -> int: ...
    def depthStencilMode(self) -> PySide2.QtGui.QOpenGLTexture.DepthStencilMode: ...
    def destroy(self): ...
    def faces(self) -> int: ...
    def format(self) -> PySide2.QtGui.QOpenGLTexture.TextureFormat: ...
    @typing.overload
    def generateMipMaps(self): ...
    @typing.overload
    def generateMipMaps(self, baseLevel: int, resetBaseLevel: bool = ...): ...
    @staticmethod
    def hasFeature(feature: PySide2.QtGui.QOpenGLTexture.Feature) -> bool: ...
    def height(self) -> int: ...
    def isAutoMipMapGenerationEnabled(self) -> bool: ...
    @typing.overload
    def isBound(self) -> bool: ...
    @typing.overload
    def isBound(self, unit: int) -> bool: ...
    def isCreated(self) -> bool: ...
    def isFixedSamplePositions(self) -> bool: ...
    def isStorageAllocated(self) -> bool: ...
    def isTextureView(self) -> bool: ...
    def layers(self) -> int: ...
    def levelOfDetailRange(self) -> typing.Tuple: ...
    def levelofDetailBias(self) -> float: ...
    def magnificationFilter(self) -> PySide2.QtGui.QOpenGLTexture.Filter: ...
    def maximumAnisotropy(self) -> float: ...
    def maximumLevelOfDetail(self) -> float: ...
    def maximumMipLevels(self) -> int: ...
    def minMagFilters(self) -> typing.Tuple: ...
    def minificationFilter(self) -> PySide2.QtGui.QOpenGLTexture.Filter: ...
    def minimumLevelOfDetail(self) -> float: ...
    def mipBaseLevel(self) -> int: ...
    def mipLevelRange(self) -> typing.Tuple: ...
    def mipLevels(self) -> int: ...
    def mipMaxLevel(self) -> int: ...
    @typing.overload
    def release(self): ...
    @typing.overload
    def release(self, unit: int, reset: PySide2.QtGui.QOpenGLTexture.TextureUnitReset = ...): ...
    def samples(self) -> int: ...
    def setAutoMipMapGenerationEnabled(self, enabled: bool): ...
    @typing.overload
    def setBorderColor(self, color: PySide2.QtGui.QColor): ...
    @typing.overload
    def setBorderColor(self, r: float, g: float, b: float, a: float): ...
    @typing.overload
    def setBorderColor(self, r: int, g: int, b: int, a: int): ...
    @typing.overload
    def setBorderColor(self, r: int, g: int, b: int, a: int): ...
    def setComparisonFunction(self, function: PySide2.QtGui.QOpenGLTexture.ComparisonFunction): ...
    def setComparisonMode(self, mode: PySide2.QtGui.QOpenGLTexture.ComparisonMode): ...
    @typing.overload
    def setCompressedData(self, dataSize: int, data: int, options: PySide2.QtGui.QOpenGLPixelTransferOptions = ...): ...
    @typing.overload
    def setCompressedData(self, mipLevel: int, dataSize: int, data: int, options: PySide2.QtGui.QOpenGLPixelTransferOptions = ...): ...
    @typing.overload
    def setCompressedData(self, mipLevel: int, layer: int, cubeFace: PySide2.QtGui.QOpenGLTexture.CubeMapFace, dataSize: int, data: int, options: PySide2.QtGui.QOpenGLPixelTransferOptions = ...): ...
    @typing.overload
    def setCompressedData(self, mipLevel: int, layer: int, dataSize: int, data: int, options: PySide2.QtGui.QOpenGLPixelTransferOptions = ...): ...
    @typing.overload
    def setCompressedData(self, mipLevel: int, layer: int, layerCount: int, cubeFace: PySide2.QtGui.QOpenGLTexture.CubeMapFace, dataSize: int, data: int, options: PySide2.QtGui.QOpenGLPixelTransferOptions = ...): ...
    @typing.overload
    def setData(self, image: PySide2.QtGui.QImage, genMipMaps: PySide2.QtGui.QOpenGLTexture.MipMapGeneration = ...): ...
    @typing.overload
    def setData(self, mipLevel: int, layer: int, cubeFace: PySide2.QtGui.QOpenGLTexture.CubeMapFace, sourceFormat: PySide2.QtGui.QOpenGLTexture.PixelFormat, sourceType: PySide2.QtGui.QOpenGLTexture.PixelType, data: int, options: PySide2.QtGui.QOpenGLPixelTransferOptions = ...): ...
    @typing.overload
    def setData(self, mipLevel: int, layer: int, layerCount: int, cubeFace: PySide2.QtGui.QOpenGLTexture.CubeMapFace, sourceFormat: PySide2.QtGui.QOpenGLTexture.PixelFormat, sourceType: PySide2.QtGui.QOpenGLTexture.PixelType, data: int, options: PySide2.QtGui.QOpenGLPixelTransferOptions = ...): ...
    @typing.overload
    def setData(self, mipLevel: int, layer: int, sourceFormat: PySide2.QtGui.QOpenGLTexture.PixelFormat, sourceType: PySide2.QtGui.QOpenGLTexture.PixelType, data: int, options: PySide2.QtGui.QOpenGLPixelTransferOptions = ...): ...
    @typing.overload
    def setData(self, mipLevel: int, sourceFormat: PySide2.QtGui.QOpenGLTexture.PixelFormat, sourceType: PySide2.QtGui.QOpenGLTexture.PixelType, data: int, options: PySide2.QtGui.QOpenGLPixelTransferOptions = ...): ...
    @typing.overload
    def setData(self, sourceFormat: PySide2.QtGui.QOpenGLTexture.PixelFormat, sourceType: PySide2.QtGui.QOpenGLTexture.PixelType, data: int, options: PySide2.QtGui.QOpenGLPixelTransferOptions = ...): ...
    def setDepthStencilMode(self, mode: PySide2.QtGui.QOpenGLTexture.DepthStencilMode): ...
    def setFixedSamplePositions(self, fixed: bool): ...
    def setFormat(self, format: PySide2.QtGui.QOpenGLTexture.TextureFormat): ...
    def setLayers(self, layers: int): ...
    def setLevelOfDetailRange(self, min: float, max: float): ...
    def setLevelofDetailBias(self, bias: float): ...
    def setMagnificationFilter(self, filter: PySide2.QtGui.QOpenGLTexture.Filter): ...
    def setMaximumAnisotropy(self, anisotropy: float): ...
    def setMaximumLevelOfDetail(self, value: float): ...
    def setMinMagFilters(self, minificationFilter: PySide2.QtGui.QOpenGLTexture.Filter, magnificationFilter: PySide2.QtGui.QOpenGLTexture.Filter): ...
    def setMinificationFilter(self, filter: PySide2.QtGui.QOpenGLTexture.Filter): ...
    def setMinimumLevelOfDetail(self, value: float): ...
    def setMipBaseLevel(self, baseLevel: int): ...
    def setMipLevelRange(self, baseLevel: int, maxLevel: int): ...
    def setMipLevels(self, levels: int): ...
    def setMipMaxLevel(self, maxLevel: int): ...
    def setSamples(self, samples: int): ...
    def setSize(self, width: int, height: int = ..., depth: int = ...): ...
    @typing.overload
    def setSwizzleMask(self, component: PySide2.QtGui.QOpenGLTexture.SwizzleComponent, value: PySide2.QtGui.QOpenGLTexture.SwizzleValue): ...
    @typing.overload
    def setSwizzleMask(self, r: PySide2.QtGui.QOpenGLTexture.SwizzleValue, g: PySide2.QtGui.QOpenGLTexture.SwizzleValue, b: PySide2.QtGui.QOpenGLTexture.SwizzleValue, a: PySide2.QtGui.QOpenGLTexture.SwizzleValue): ...
    @typing.overload
    def setWrapMode(self, direction: PySide2.QtGui.QOpenGLTexture.CoordinateDirection, mode: PySide2.QtGui.QOpenGLTexture.WrapMode): ...
    @typing.overload
    def setWrapMode(self, mode: PySide2.QtGui.QOpenGLTexture.WrapMode): ...
    def swizzleMask(self, component: PySide2.QtGui.QOpenGLTexture.SwizzleComponent) -> PySide2.QtGui.QOpenGLTexture.SwizzleValue: ...
    def target(self) -> PySide2.QtGui.QOpenGLTexture.Target: ...
    def textureId(self) -> int: ...
    def width(self) -> int: ...
    def wrapMode(self, direction: PySide2.QtGui.QOpenGLTexture.CoordinateDirection) -> PySide2.QtGui.QOpenGLTexture.WrapMode: ...


class QOpenGLTextureBlitter(Shiboken.Object):

    def __init__(self): ...
    def bind(self, target: int = ...): ...
    @typing.overload
    def blit(self, texture: int, targetTransform: PySide2.QtGui.QMatrix4x4, sourceOrigin: PySide2.QtGui.QOpenGLTextureBlitter.Origin): ...
    @typing.overload
    def blit(self, texture: int, targetTransform: PySide2.QtGui.QMatrix4x4, sourceTransform: PySide2.QtGui.QMatrix3x3): ...
    def create(self) -> bool: ...
    def destroy(self): ...
    def isCreated(self) -> bool: ...
    def release(self): ...
    def setOpacity(self, opacity: float): ...
    def setRedBlueSwizzle(self, swizzle: bool): ...
    @staticmethod
    def sourceTransform(subTexture: PySide2.QtCore.QRectF, textureSize: PySide2.QtCore.QSize, origin: PySide2.QtGui.QOpenGLTextureBlitter.Origin) -> PySide2.QtGui.QMatrix3x3: ...
    def supportsExternalOESTarget(self) -> bool: ...
    @staticmethod
    def targetTransform(target: PySide2.QtCore.QRectF, viewport: PySide2.QtCore.QRect) -> PySide2.QtGui.QMatrix4x4: ...


class QOpenGLTimeMonitor(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def create(self) -> bool: ...
    def destroy(self): ...
    def isCreated(self) -> bool: ...
    def isResultAvailable(self) -> bool: ...
    def objectIds(self) -> typing.List[int]: ...
    def recordSample(self) -> int: ...
    def reset(self): ...
    def sampleCount(self) -> int: ...
    def setSampleCount(self, sampleCount: int): ...
    def waitForIntervals(self) -> typing.List[int]: ...
    def waitForSamples(self) -> typing.List[int]: ...


class QOpenGLTimerQuery(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def begin(self): ...
    def create(self) -> bool: ...
    def destroy(self): ...
    def end(self): ...
    def isCreated(self) -> bool: ...
    def isResultAvailable(self) -> bool: ...
    def objectId(self) -> int: ...
    def recordTimestamp(self): ...
    def waitForResult(self) -> int: ...
    def waitForTimestamp(self) -> int: ...


class QOpenGLVersionProfile(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, format: PySide2.QtGui.QSurfaceFormat): ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QOpenGLVersionProfile): ...
    def __copy__(self): ...
    def hasProfiles(self) -> bool: ...
    def isLegacyVersion(self) -> bool: ...
    def isValid(self) -> bool: ...
    def profile(self) -> PySide2.QtGui.QSurfaceFormat.OpenGLContextProfile: ...
    def setProfile(self, profile: PySide2.QtGui.QSurfaceFormat.OpenGLContextProfile): ...
    def setVersion(self, majorVersion: int, minorVersion: int): ...
    def version(self) -> typing.Tuple: ...


class QOpenGLVertexArrayObject(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def bind(self): ...
    def create(self) -> bool: ...
    def destroy(self): ...
    def isCreated(self) -> bool: ...
    def objectId(self) -> int: ...
    def release(self): ...

    class Binder(Shiboken.Object):

        def __init__(self, v: PySide2.QtGui.QOpenGLVertexArrayObject): ...
        def rebind(self): ...
        def release(self): ...


class QOpenGLWindow(PySide2.QtGui.QPaintDeviceWindow):

    @typing.overload
    def __init__(self, shareContext: PySide2.QtGui.QOpenGLContext, updateBehavior: PySide2.QtGui.QOpenGLWindow.UpdateBehavior = ..., parent: PySide2.QtGui.QWindow = ...): ...
    @typing.overload
    def __init__(self, updateBehavior: PySide2.QtGui.QOpenGLWindow.UpdateBehavior = ..., parent: PySide2.QtGui.QWindow = ...): ...
    def context(self) -> PySide2.QtGui.QOpenGLContext: ...
    def defaultFramebufferObject(self) -> int: ...
    def doneCurrent(self): ...
    def grabFramebuffer(self) -> PySide2.QtGui.QImage: ...
    def initializeGL(self): ...
    def isValid(self) -> bool: ...
    def makeCurrent(self): ...
    def metric(self, metric: PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent): ...
    def paintGL(self): ...
    def paintOverGL(self): ...
    def paintUnderGL(self): ...
    def redirected(self, arg__1: PySide2.QtCore.QPoint) -> PySide2.QtGui.QPaintDevice: ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent): ...
    def resizeGL(self, w: int, h: int): ...
    def shareContext(self) -> PySide2.QtGui.QOpenGLContext: ...
    def updateBehavior(self) -> PySide2.QtGui.QOpenGLWindow.UpdateBehavior: ...


class QPageLayout(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QPageLayout): ...
    @typing.overload
    def __init__(self, pageSize: PySide2.QtGui.QPageSize, orientation: PySide2.QtGui.QPageLayout.Orientation, margins: PySide2.QtCore.QMarginsF, units: PySide2.QtGui.QPageLayout.Unit = ..., minMargins: PySide2.QtCore.QMarginsF = ...): ...
    def __copy__(self): ...
    @typing.overload
    def fullRect(self) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def fullRect(self, units: PySide2.QtGui.QPageLayout.Unit) -> PySide2.QtCore.QRectF: ...
    def fullRectPixels(self, resolution: int) -> PySide2.QtCore.QRect: ...
    def fullRectPoints(self) -> PySide2.QtCore.QRect: ...
    def isEquivalentTo(self, other: PySide2.QtGui.QPageLayout) -> bool: ...
    def isValid(self) -> bool: ...
    @typing.overload
    def margins(self) -> PySide2.QtCore.QMarginsF: ...
    @typing.overload
    def margins(self, units: PySide2.QtGui.QPageLayout.Unit) -> PySide2.QtCore.QMarginsF: ...
    def marginsPixels(self, resolution: int) -> PySide2.QtCore.QMargins: ...
    def marginsPoints(self) -> PySide2.QtCore.QMargins: ...
    def maximumMargins(self) -> PySide2.QtCore.QMarginsF: ...
    def minimumMargins(self) -> PySide2.QtCore.QMarginsF: ...
    def mode(self) -> PySide2.QtGui.QPageLayout.Mode: ...
    def orientation(self) -> PySide2.QtGui.QPageLayout.Orientation: ...
    def pageSize(self) -> PySide2.QtGui.QPageSize: ...
    @typing.overload
    def paintRect(self) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def paintRect(self, units: PySide2.QtGui.QPageLayout.Unit) -> PySide2.QtCore.QRectF: ...
    def paintRectPixels(self, resolution: int) -> PySide2.QtCore.QRect: ...
    def paintRectPoints(self) -> PySide2.QtCore.QRect: ...
    def setBottomMargin(self, bottomMargin: float) -> bool: ...
    def setLeftMargin(self, leftMargin: float) -> bool: ...
    def setMargins(self, margins: PySide2.QtCore.QMarginsF) -> bool: ...
    def setMinimumMargins(self, minMargins: PySide2.QtCore.QMarginsF): ...
    def setMode(self, mode: PySide2.QtGui.QPageLayout.Mode): ...
    def setOrientation(self, orientation: PySide2.QtGui.QPageLayout.Orientation): ...
    def setPageSize(self, pageSize: PySide2.QtGui.QPageSize, minMargins: PySide2.QtCore.QMarginsF = ...): ...
    def setRightMargin(self, rightMargin: float) -> bool: ...
    def setTopMargin(self, topMargin: float) -> bool: ...
    def setUnits(self, units: PySide2.QtGui.QPageLayout.Unit): ...
    def swap(self, other: PySide2.QtGui.QPageLayout): ...
    def units(self) -> PySide2.QtGui.QPageLayout.Unit: ...


class QPageSize(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QPageSize): ...
    @typing.overload
    def __init__(self, pageSizeId: PySide2.QtGui.QPageSize.PageSizeId): ...
    @typing.overload
    def __init__(self, pointSize: PySide2.QtCore.QSize, name: str = ..., matchPolicy: PySide2.QtGui.QPageSize.SizeMatchPolicy = ...): ...
    @typing.overload
    def __init__(self, size: PySide2.QtCore.QSizeF, units: PySide2.QtGui.QPageSize.Unit, name: str = ..., matchPolicy: PySide2.QtGui.QPageSize.SizeMatchPolicy = ...): ...
    def __copy__(self): ...
    @typing.overload
    @staticmethod
    def definitionSize() -> PySide2.QtCore.QSizeF: ...
    @typing.overload
    @staticmethod
    def definitionSize(pageSizeId: PySide2.QtGui.QPageSize.PageSizeId) -> PySide2.QtCore.QSizeF: ...
    @typing.overload
    @staticmethod
    def definitionUnits() -> PySide2.QtGui.QPageSize.Unit: ...
    @typing.overload
    @staticmethod
    def definitionUnits(pageSizeId: PySide2.QtGui.QPageSize.PageSizeId) -> PySide2.QtGui.QPageSize.Unit: ...
    @typing.overload
    @staticmethod
    def id() -> PySide2.QtGui.QPageSize.PageSizeId: ...
    @typing.overload
    @staticmethod
    def id(pointSize: PySide2.QtCore.QSize, matchPolicy: PySide2.QtGui.QPageSize.SizeMatchPolicy = ...) -> PySide2.QtGui.QPageSize.PageSizeId: ...
    @typing.overload
    @staticmethod
    def id(size: PySide2.QtCore.QSizeF, units: PySide2.QtGui.QPageSize.Unit, matchPolicy: PySide2.QtGui.QPageSize.SizeMatchPolicy = ...) -> PySide2.QtGui.QPageSize.PageSizeId: ...
    @typing.overload
    @staticmethod
    def id(windowsId: int) -> PySide2.QtGui.QPageSize.PageSizeId: ...
    def isEquivalentTo(self, other: PySide2.QtGui.QPageSize) -> bool: ...
    def isValid(self) -> bool: ...
    @typing.overload
    @staticmethod
    def key() -> str: ...
    @typing.overload
    @staticmethod
    def key(pageSizeId: PySide2.QtGui.QPageSize.PageSizeId) -> str: ...
    @typing.overload
    @staticmethod
    def name() -> str: ...
    @typing.overload
    @staticmethod
    def name(pageSizeId: PySide2.QtGui.QPageSize.PageSizeId) -> str: ...
    def rect(self, units: PySide2.QtGui.QPageSize.Unit) -> PySide2.QtCore.QRectF: ...
    def rectPixels(self, resolution: int) -> PySide2.QtCore.QRect: ...
    def rectPoints(self) -> PySide2.QtCore.QRect: ...
    @typing.overload
    @staticmethod
    def size(pageSizeId: PySide2.QtGui.QPageSize.PageSizeId, units: PySide2.QtGui.QPageSize.Unit) -> PySide2.QtCore.QSizeF: ...
    @typing.overload
    @staticmethod
    def size(units: PySide2.QtGui.QPageSize.Unit) -> PySide2.QtCore.QSizeF: ...
    @typing.overload
    @staticmethod
    def sizePixels(pageSizeId: PySide2.QtGui.QPageSize.PageSizeId, resolution: int) -> PySide2.QtCore.QSize: ...
    @typing.overload
    @staticmethod
    def sizePixels(resolution: int) -> PySide2.QtCore.QSize: ...
    @typing.overload
    @staticmethod
    def sizePoints() -> PySide2.QtCore.QSize: ...
    @typing.overload
    @staticmethod
    def sizePoints(pageSizeId: PySide2.QtGui.QPageSize.PageSizeId) -> PySide2.QtCore.QSize: ...
    def swap(self, other: PySide2.QtGui.QPageSize): ...
    @typing.overload
    @staticmethod
    def windowsId() -> int: ...
    @typing.overload
    @staticmethod
    def windowsId(pageSizeId: PySide2.QtGui.QPageSize.PageSizeId) -> int: ...


class QPagedPaintDevice(PySide2.QtGui.QPaintDevice):

    def __init__(self): ...
    def devicePageLayout(self) -> PySide2.QtGui.QPageLayout: ...
    def margins(self) -> PySide2.QtGui.QPagedPaintDevice.Margins: ...
    def newPage(self) -> bool: ...
    def pageLayout(self) -> PySide2.QtGui.QPageLayout: ...
    def pageSize(self) -> PySide2.QtGui.QPagedPaintDevice.PageSize: ...
    def pageSizeMM(self) -> PySide2.QtCore.QSizeF: ...
    def setMargins(self, margins: PySide2.QtGui.QPagedPaintDevice.Margins): ...
    def setPageLayout(self, pageLayout: PySide2.QtGui.QPageLayout) -> bool: ...
    @typing.overload
    def setPageMargins(self, margins: PySide2.QtCore.QMarginsF) -> bool: ...
    @typing.overload
    def setPageMargins(self, margins: PySide2.QtCore.QMarginsF, units: PySide2.QtGui.QPageLayout.Unit) -> bool: ...
    def setPageOrientation(self, orientation: PySide2.QtGui.QPageLayout.Orientation) -> bool: ...
    @typing.overload
    def setPageSize(self, pageSize: PySide2.QtGui.QPageSize) -> bool: ...
    @typing.overload
    def setPageSize(self, size: PySide2.QtGui.QPagedPaintDevice.PageSize): ...
    def setPageSizeMM(self, size: PySide2.QtCore.QSizeF): ...

    class Margins(Shiboken.Object):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, Margins: PySide2.QtGui.QPagedPaintDevice.Margins): ...
        def __copy__(self): ...


class QPaintDevice(Shiboken.Object):

    def __init__(self): ...
    def colorCount(self) -> int: ...
    def depth(self) -> int: ...
    def devType(self) -> int: ...
    def devicePixelRatio(self) -> int: ...
    def devicePixelRatioF(self) -> float: ...
    @staticmethod
    def devicePixelRatioFScale() -> float: ...
    def height(self) -> int: ...
    def heightMM(self) -> int: ...
    def initPainter(self, painter: PySide2.QtGui.QPainter): ...
    def logicalDpiX(self) -> int: ...
    def logicalDpiY(self) -> int: ...
    def metric(self, metric: PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def paintingActive(self) -> bool: ...
    def physicalDpiX(self) -> int: ...
    def physicalDpiY(self) -> int: ...
    def redirected(self, offset: PySide2.QtCore.QPoint) -> PySide2.QtGui.QPaintDevice: ...
    def sharedPainter(self) -> PySide2.QtGui.QPainter: ...
    def width(self) -> int: ...
    def widthMM(self) -> int: ...


class QPaintDeviceWindow(PySide2.QtGui.QWindow, PySide2.QtGui.QPaintDevice):

    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def exposeEvent(self, arg__1: PySide2.QtGui.QExposeEvent): ...
    def metric(self, metric: PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent): ...
    @typing.overload
    def update(self): ...
    @typing.overload
    def update(self, rect: PySide2.QtCore.QRect): ...
    @typing.overload
    def update(self, region: PySide2.QtGui.QRegion): ...


class QPaintEngine(Shiboken.Object):

    def __init__(self, features: PySide2.QtGui.QPaintEngine.PaintEngineFeatures = ...): ...
    def begin(self, pdev: PySide2.QtGui.QPaintDevice) -> bool: ...
    def clearDirty(self, df: PySide2.QtGui.QPaintEngine.DirtyFlags): ...
    def coordinateOffset(self) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def drawEllipse(self, r: PySide2.QtCore.QRect): ...
    @typing.overload
    def drawEllipse(self, r: PySide2.QtCore.QRectF): ...
    def drawImage(self, r: PySide2.QtCore.QRectF, pm: PySide2.QtGui.QImage, sr: PySide2.QtCore.QRectF, flags: PySide2.QtCore.Qt.ImageConversionFlags = ...): ...
    @typing.overload
    def drawLines(self, lines: PySide2.QtCore.QLine, lineCount: int): ...
    @typing.overload
    def drawLines(self, lines: PySide2.QtCore.QLineF, lineCount: int): ...
    def drawPath(self, path: PySide2.QtGui.QPainterPath): ...
    def drawPixmap(self, r: PySide2.QtCore.QRectF, pm: PySide2.QtGui.QPixmap, sr: PySide2.QtCore.QRectF): ...
    @typing.overload
    def drawPoints(self, points: PySide2.QtCore.QPoint, pointCount: int): ...
    @typing.overload
    def drawPoints(self, points: PySide2.QtCore.QPointF, pointCount: int): ...
    @typing.overload
    def drawPolygon(self, points: PySide2.QtCore.QPoint, pointCount: int, mode: PySide2.QtGui.QPaintEngine.PolygonDrawMode): ...
    @typing.overload
    def drawPolygon(self, points: PySide2.QtCore.QPointF, pointCount: int, mode: PySide2.QtGui.QPaintEngine.PolygonDrawMode): ...
    @typing.overload
    def drawRects(self, rects: PySide2.QtCore.QRect, rectCount: int): ...
    @typing.overload
    def drawRects(self, rects: PySide2.QtCore.QRectF, rectCount: int): ...
    def drawTextItem(self, p: PySide2.QtCore.QPointF, textItem: PySide2.QtGui.QTextItem): ...
    def drawTiledPixmap(self, r: PySide2.QtCore.QRectF, pixmap: PySide2.QtGui.QPixmap, s: PySide2.QtCore.QPointF): ...
    def end(self) -> bool: ...
    def hasFeature(self, feature: PySide2.QtGui.QPaintEngine.PaintEngineFeatures) -> bool: ...
    def isActive(self) -> bool: ...
    def isExtended(self) -> bool: ...
    def paintDevice(self) -> PySide2.QtGui.QPaintDevice: ...
    def painter(self) -> PySide2.QtGui.QPainter: ...
    def setActive(self, newState: bool): ...
    def setDirty(self, df: PySide2.QtGui.QPaintEngine.DirtyFlags): ...
    def setSystemClip(self, baseClip: PySide2.QtGui.QRegion): ...
    def setSystemRect(self, rect: PySide2.QtCore.QRect): ...
    def syncState(self): ...
    def systemClip(self) -> PySide2.QtGui.QRegion: ...
    def systemRect(self) -> PySide2.QtCore.QRect: ...
    def testDirty(self, df: PySide2.QtGui.QPaintEngine.DirtyFlags) -> bool: ...
    def type(self) -> PySide2.QtGui.QPaintEngine.Type: ...
    def updateState(self, state: PySide2.QtGui.QPaintEngineState): ...


class QPaintEngineState(Shiboken.Object):

    def __init__(self): ...
    def backgroundBrush(self) -> PySide2.QtGui.QBrush: ...
    def backgroundMode(self) -> PySide2.QtCore.Qt.BGMode: ...
    def brush(self) -> PySide2.QtGui.QBrush: ...
    def brushNeedsResolving(self) -> bool: ...
    def brushOrigin(self) -> PySide2.QtCore.QPointF: ...
    def clipOperation(self) -> PySide2.QtCore.Qt.ClipOperation: ...
    def clipPath(self) -> PySide2.QtGui.QPainterPath: ...
    def clipRegion(self) -> PySide2.QtGui.QRegion: ...
    def compositionMode(self) -> PySide2.QtGui.QPainter.CompositionMode: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def isClipEnabled(self) -> bool: ...
    def matrix(self) -> PySide2.QtGui.QMatrix: ...
    def opacity(self) -> float: ...
    def painter(self) -> PySide2.QtGui.QPainter: ...
    def pen(self) -> PySide2.QtGui.QPen: ...
    def penNeedsResolving(self) -> bool: ...
    def renderHints(self) -> PySide2.QtGui.QPainter.RenderHints: ...
    def state(self) -> PySide2.QtGui.QPaintEngine.DirtyFlags: ...
    def transform(self) -> PySide2.QtGui.QTransform: ...


class QPaintEvent(PySide2.QtCore.QEvent):

    @typing.overload
    def __init__(self, paintRect: PySide2.QtCore.QRect): ...
    @typing.overload
    def __init__(self, paintRegion: PySide2.QtGui.QRegion): ...
    def rect(self) -> PySide2.QtCore.QRect: ...
    def region(self) -> PySide2.QtGui.QRegion: ...


class QPainter(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QPaintDevice): ...
    def background(self) -> PySide2.QtGui.QBrush: ...
    def backgroundMode(self) -> PySide2.QtCore.Qt.BGMode: ...
    def begin(self, arg__1: PySide2.QtGui.QPaintDevice) -> bool: ...
    def beginNativePainting(self): ...
    @typing.overload
    def boundingRect(self, rect: PySide2.QtCore.QRect, flags: int, text: str) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def boundingRect(self, rect: PySide2.QtCore.QRectF, flags: int, text: str) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def boundingRect(self, rect: PySide2.QtCore.QRectF, text: str, o: PySide2.QtGui.QTextOption = ...) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def boundingRect(self, x: int, y: int, w: int, h: int, flags: int, text: str) -> PySide2.QtCore.QRect: ...
    def brush(self) -> PySide2.QtGui.QBrush: ...
    def brushOrigin(self) -> PySide2.QtCore.QPoint: ...
    def clipBoundingRect(self) -> PySide2.QtCore.QRectF: ...
    def clipPath(self) -> PySide2.QtGui.QPainterPath: ...
    def clipRegion(self) -> PySide2.QtGui.QRegion: ...
    def combinedMatrix(self) -> PySide2.QtGui.QMatrix: ...
    def combinedTransform(self) -> PySide2.QtGui.QTransform: ...
    def compositionMode(self) -> PySide2.QtGui.QPainter.CompositionMode: ...
    def device(self) -> PySide2.QtGui.QPaintDevice: ...
    def deviceMatrix(self) -> PySide2.QtGui.QMatrix: ...
    def deviceTransform(self) -> PySide2.QtGui.QTransform: ...
    @typing.overload
    def drawArc(self, arg__1: PySide2.QtCore.QRect, a: int, alen: int): ...
    @typing.overload
    def drawArc(self, rect: PySide2.QtCore.QRectF, a: int, alen: int): ...
    @typing.overload
    def drawArc(self, x: int, y: int, w: int, h: int, a: int, alen: int): ...
    @typing.overload
    def drawChord(self, arg__1: PySide2.QtCore.QRect, a: int, alen: int): ...
    @typing.overload
    def drawChord(self, rect: PySide2.QtCore.QRectF, a: int, alen: int): ...
    @typing.overload
    def drawChord(self, x: int, y: int, w: int, h: int, a: int, alen: int): ...
    @typing.overload
    def drawConvexPolygon(self, arg__1: typing.List[PySide2.QtCore.QPointF]): ...
    @typing.overload
    def drawConvexPolygon(self, arg__1: typing.List[PySide2.QtCore.QPoint]): ...
    @typing.overload
    def drawConvexPolygon(self, polygon: PySide2.QtGui.QPolygon): ...
    @typing.overload
    def drawConvexPolygon(self, polygon: PySide2.QtGui.QPolygonF): ...
    @typing.overload
    def drawEllipse(self, center: PySide2.QtCore.QPoint, rx: int, ry: int): ...
    @typing.overload
    def drawEllipse(self, center: PySide2.QtCore.QPointF, rx: float, ry: float): ...
    @typing.overload
    def drawEllipse(self, r: PySide2.QtCore.QRect): ...
    @typing.overload
    def drawEllipse(self, r: PySide2.QtCore.QRectF): ...
    @typing.overload
    def drawEllipse(self, x: int, y: int, w: int, h: int): ...
    @typing.overload
    def drawImage(self, p: PySide2.QtCore.QPoint, image: PySide2.QtGui.QImage): ...
    @typing.overload
    def drawImage(self, p: PySide2.QtCore.QPoint, image: PySide2.QtGui.QImage, sr: PySide2.QtCore.QRect, flags: PySide2.QtCore.Qt.ImageConversionFlags = ...): ...
    @typing.overload
    def drawImage(self, p: PySide2.QtCore.QPointF, image: PySide2.QtGui.QImage): ...
    @typing.overload
    def drawImage(self, p: PySide2.QtCore.QPointF, image: PySide2.QtGui.QImage, sr: PySide2.QtCore.QRectF, flags: PySide2.QtCore.Qt.ImageConversionFlags = ...): ...
    @typing.overload
    def drawImage(self, r: PySide2.QtCore.QRect, image: PySide2.QtGui.QImage): ...
    @typing.overload
    def drawImage(self, r: PySide2.QtCore.QRectF, image: PySide2.QtGui.QImage): ...
    @typing.overload
    def drawImage(self, targetRect: PySide2.QtCore.QRect, image: PySide2.QtGui.QImage, sourceRect: PySide2.QtCore.QRect, flags: PySide2.QtCore.Qt.ImageConversionFlags = ...): ...
    @typing.overload
    def drawImage(self, targetRect: PySide2.QtCore.QRectF, image: PySide2.QtGui.QImage, sourceRect: PySide2.QtCore.QRectF, flags: PySide2.QtCore.Qt.ImageConversionFlags = ...): ...
    @typing.overload
    def drawImage(self, x: int, y: int, image: PySide2.QtGui.QImage, sx: int = ..., sy: int = ..., sw: int = ..., sh: int = ..., flags: PySide2.QtCore.Qt.ImageConversionFlags = ...): ...
    @typing.overload
    def drawLine(self, line: PySide2.QtCore.QLine): ...
    @typing.overload
    def drawLine(self, line: PySide2.QtCore.QLineF): ...
    @typing.overload
    def drawLine(self, p1: PySide2.QtCore.QPoint, p2: PySide2.QtCore.QPoint): ...
    @typing.overload
    def drawLine(self, p1: PySide2.QtCore.QPointF, p2: PySide2.QtCore.QPointF): ...
    @typing.overload
    def drawLine(self, x1: int, y1: int, x2: int, y2: int): ...
    @typing.overload
    def drawLines(self, lines: typing.List[PySide2.QtCore.QLineF]): ...
    @typing.overload
    def drawLines(self, lines: typing.List[PySide2.QtCore.QLine]): ...
    @typing.overload
    def drawLines(self, pointPairs: typing.List[PySide2.QtCore.QPointF]): ...
    @typing.overload
    def drawLines(self, pointPairs: typing.List[PySide2.QtCore.QPoint]): ...
    def drawPath(self, path: PySide2.QtGui.QPainterPath): ...
    @typing.overload
    def drawPicture(self, p: PySide2.QtCore.QPoint, picture: PySide2.QtGui.QPicture): ...
    @typing.overload
    def drawPicture(self, p: PySide2.QtCore.QPointF, picture: PySide2.QtGui.QPicture): ...
    @typing.overload
    def drawPicture(self, x: int, y: int, picture: PySide2.QtGui.QPicture): ...
    @typing.overload
    def drawPie(self, arg__1: PySide2.QtCore.QRect, a: int, alen: int): ...
    @typing.overload
    def drawPie(self, rect: PySide2.QtCore.QRectF, a: int, alen: int): ...
    @typing.overload
    def drawPie(self, x: int, y: int, w: int, h: int, a: int, alen: int): ...
    @typing.overload
    def drawPixmap(self, p: PySide2.QtCore.QPoint, pm: PySide2.QtGui.QPixmap): ...
    @typing.overload
    def drawPixmap(self, p: PySide2.QtCore.QPoint, pm: PySide2.QtGui.QPixmap, sr: PySide2.QtCore.QRect): ...
    @typing.overload
    def drawPixmap(self, p: PySide2.QtCore.QPointF, pm: PySide2.QtGui.QPixmap): ...
    @typing.overload
    def drawPixmap(self, p: PySide2.QtCore.QPointF, pm: PySide2.QtGui.QPixmap, sr: PySide2.QtCore.QRectF): ...
    @typing.overload
    def drawPixmap(self, r: PySide2.QtCore.QRect, pm: PySide2.QtGui.QPixmap): ...
    @typing.overload
    def drawPixmap(self, targetRect: PySide2.QtCore.QRect, pixmap: PySide2.QtGui.QPixmap, sourceRect: PySide2.QtCore.QRect): ...
    @typing.overload
    def drawPixmap(self, targetRect: PySide2.QtCore.QRectF, pixmap: PySide2.QtGui.QPixmap, sourceRect: PySide2.QtCore.QRectF): ...
    @typing.overload
    def drawPixmap(self, x: int, y: int, pm: PySide2.QtGui.QPixmap): ...
    @typing.overload
    def drawPixmap(self, x: int, y: int, pm: PySide2.QtGui.QPixmap, sx: int, sy: int, sw: int, sh: int): ...
    @typing.overload
    def drawPixmap(self, x: int, y: int, w: int, h: int, pm: PySide2.QtGui.QPixmap): ...
    @typing.overload
    def drawPixmap(self, x: int, y: int, w: int, h: int, pm: PySide2.QtGui.QPixmap, sx: int, sy: int, sw: int, sh: int): ...
    def drawPixmapFragments(self, fragments: PySide2.QtGui.QPainter.PixmapFragment, fragmentCount: int, pixmap: PySide2.QtGui.QPixmap, hints: PySide2.QtGui.QPainter.PixmapFragmentHints = ...): ...
    @typing.overload
    def drawPoint(self, p: PySide2.QtCore.QPoint): ...
    @typing.overload
    def drawPoint(self, pt: PySide2.QtCore.QPointF): ...
    @typing.overload
    def drawPoint(self, x: int, y: int): ...
    @typing.overload
    def drawPoints(self, arg__1: typing.List[PySide2.QtCore.QPointF]): ...
    @typing.overload
    def drawPoints(self, arg__1: typing.List[PySide2.QtCore.QPoint]): ...
    @typing.overload
    def drawPoints(self, points: PySide2.QtGui.QPolygon): ...
    @typing.overload
    def drawPoints(self, points: PySide2.QtGui.QPolygonF): ...
    @typing.overload
    def drawPolygon(self, arg__1: typing.List[PySide2.QtCore.QPointF], arg__2: PySide2.QtCore.Qt.FillRule): ...
    @typing.overload
    def drawPolygon(self, arg__1: typing.List[PySide2.QtCore.QPoint], arg__2: PySide2.QtCore.Qt.FillRule): ...
    @typing.overload
    def drawPolygon(self, polygon: PySide2.QtGui.QPolygon, fillRule: PySide2.QtCore.Qt.FillRule = ...): ...
    @typing.overload
    def drawPolygon(self, polygon: PySide2.QtGui.QPolygonF, fillRule: PySide2.QtCore.Qt.FillRule = ...): ...
    @typing.overload
    def drawPolyline(self, arg__1: typing.List[PySide2.QtCore.QPointF]): ...
    @typing.overload
    def drawPolyline(self, arg__1: typing.List[PySide2.QtCore.QPoint]): ...
    @typing.overload
    def drawPolyline(self, polygon: PySide2.QtGui.QPolygon): ...
    @typing.overload
    def drawPolyline(self, polyline: PySide2.QtGui.QPolygonF): ...
    @typing.overload
    def drawRect(self, rect: PySide2.QtCore.QRect): ...
    @typing.overload
    def drawRect(self, rect: PySide2.QtCore.QRectF): ...
    @typing.overload
    def drawRect(self, x1: int, y1: int, w: int, h: int): ...
    @typing.overload
    def drawRects(self, rectangles: typing.List[PySide2.QtCore.QRectF]): ...
    @typing.overload
    def drawRects(self, rectangles: typing.List[PySide2.QtCore.QRect]): ...
    @typing.overload
    def drawRoundRect(self, r: PySide2.QtCore.QRect, xround: int = ..., yround: int = ...): ...
    @typing.overload
    def drawRoundRect(self, r: PySide2.QtCore.QRectF, xround: int = ..., yround: int = ...): ...
    @typing.overload
    def drawRoundRect(self, x: int, y: int, w: int, h: int, xRound: int = ..., yRound: int = ...): ...
    @typing.overload
    def drawRoundedRect(self, rect: PySide2.QtCore.QRect, xRadius: float, yRadius: float, mode: PySide2.QtCore.Qt.SizeMode = ...): ...
    @typing.overload
    def drawRoundedRect(self, rect: PySide2.QtCore.QRectF, xRadius: float, yRadius: float, mode: PySide2.QtCore.Qt.SizeMode = ...): ...
    @typing.overload
    def drawRoundedRect(self, x: int, y: int, w: int, h: int, xRadius: float, yRadius: float, mode: PySide2.QtCore.Qt.SizeMode = ...): ...
    @typing.overload
    def drawStaticText(self, left: int, top: int, staticText: PySide2.QtGui.QStaticText): ...
    @typing.overload
    def drawStaticText(self, topLeftPosition: PySide2.QtCore.QPoint, staticText: PySide2.QtGui.QStaticText): ...
    @typing.overload
    def drawStaticText(self, topLeftPosition: PySide2.QtCore.QPointF, staticText: PySide2.QtGui.QStaticText): ...
    @typing.overload
    def drawText(self, p: PySide2.QtCore.QPoint, s: str): ...
    @typing.overload
    def drawText(self, p: PySide2.QtCore.QPointF, s: str): ...
    @typing.overload
    def drawText(self, r: PySide2.QtCore.QRect, flags: int, text: str, br: PySide2.QtCore.QRect): ...
    @typing.overload
    def drawText(self, r: PySide2.QtCore.QRectF, flags: int, text: str, br: PySide2.QtCore.QRectF): ...
    @typing.overload
    def drawText(self, r: PySide2.QtCore.QRectF, text: str, o: PySide2.QtGui.QTextOption = ...): ...
    @typing.overload
    def drawText(self, x: int, y: int, s: str): ...
    @typing.overload
    def drawText(self, x: int, y: int, w: int, h: int, flags: int, text: str, br: PySide2.QtCore.QRect): ...
    @typing.overload
    def drawTextItem(self, p: PySide2.QtCore.QPoint, ti: PySide2.QtGui.QTextItem): ...
    @typing.overload
    def drawTextItem(self, p: PySide2.QtCore.QPointF, ti: PySide2.QtGui.QTextItem): ...
    @typing.overload
    def drawTextItem(self, x: int, y: int, ti: PySide2.QtGui.QTextItem): ...
    @typing.overload
    def drawTiledPixmap(self, arg__1: PySide2.QtCore.QRect, arg__2: PySide2.QtGui.QPixmap, pos: PySide2.QtCore.QPoint = ...): ...
    @typing.overload
    def drawTiledPixmap(self, rect: PySide2.QtCore.QRectF, pm: PySide2.QtGui.QPixmap, offset: PySide2.QtCore.QPointF = ...): ...
    @typing.overload
    def drawTiledPixmap(self, x: int, y: int, w: int, h: int, arg__5: PySide2.QtGui.QPixmap, sx: int = ..., sy: int = ...): ...
    def end(self) -> bool: ...
    def endNativePainting(self): ...
    @typing.overload
    def eraseRect(self, arg__1: PySide2.QtCore.QRect): ...
    @typing.overload
    def eraseRect(self, arg__1: PySide2.QtCore.QRectF): ...
    @typing.overload
    def eraseRect(self, x: int, y: int, w: int, h: int): ...
    def fillPath(self, path: PySide2.QtGui.QPainterPath, brush: PySide2.QtGui.QBrush): ...
    @typing.overload
    def fillRect(self, arg__1: PySide2.QtCore.QRect, arg__2: PySide2.QtGui.QBrush): ...
    @typing.overload
    def fillRect(self, arg__1: PySide2.QtCore.QRect, color: PySide2.QtGui.QColor): ...
    @typing.overload
    def fillRect(self, arg__1: PySide2.QtCore.QRectF, arg__2: PySide2.QtGui.QBrush): ...
    @typing.overload
    def fillRect(self, arg__1: PySide2.QtCore.QRectF, color: PySide2.QtGui.QColor): ...
    @typing.overload
    def fillRect(self, r: PySide2.QtCore.QRect, c: PySide2.QtCore.Qt.GlobalColor): ...
    @typing.overload
    def fillRect(self, r: PySide2.QtCore.QRect, preset: PySide2.QtGui.QGradient.Preset): ...
    @typing.overload
    def fillRect(self, r: PySide2.QtCore.QRect, style: PySide2.QtCore.Qt.BrushStyle): ...
    @typing.overload
    def fillRect(self, r: PySide2.QtCore.QRectF, c: PySide2.QtCore.Qt.GlobalColor): ...
    @typing.overload
    def fillRect(self, r: PySide2.QtCore.QRectF, preset: PySide2.QtGui.QGradient.Preset): ...
    @typing.overload
    def fillRect(self, r: PySide2.QtCore.QRectF, style: PySide2.QtCore.Qt.BrushStyle): ...
    @typing.overload
    def fillRect(self, x: int, y: int, w: int, h: int, arg__5: PySide2.QtGui.QBrush): ...
    @typing.overload
    def fillRect(self, x: int, y: int, w: int, h: int, c: PySide2.QtCore.Qt.GlobalColor): ...
    @typing.overload
    def fillRect(self, x: int, y: int, w: int, h: int, color: PySide2.QtGui.QColor): ...
    @typing.overload
    def fillRect(self, x: int, y: int, w: int, h: int, preset: PySide2.QtGui.QGradient.Preset): ...
    @typing.overload
    def fillRect(self, x: int, y: int, w: int, h: int, style: PySide2.QtCore.Qt.BrushStyle): ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def fontInfo(self) -> PySide2.QtGui.QFontInfo: ...
    def fontMetrics(self) -> PySide2.QtGui.QFontMetrics: ...
    def hasClipping(self) -> bool: ...
    def initFrom(self, device: PySide2.QtGui.QPaintDevice): ...
    def isActive(self) -> bool: ...
    def layoutDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def matrix(self) -> PySide2.QtGui.QMatrix: ...
    def matrixEnabled(self) -> bool: ...
    def opacity(self) -> float: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def pen(self) -> PySide2.QtGui.QPen: ...
    @staticmethod
    def redirected(device: PySide2.QtGui.QPaintDevice, offset: PySide2.QtCore.QPoint = ...) -> PySide2.QtGui.QPaintDevice: ...
    def renderHints(self) -> PySide2.QtGui.QPainter.RenderHints: ...
    def resetMatrix(self): ...
    def resetTransform(self): ...
    def restore(self): ...
    @staticmethod
    def restoreRedirected(device: PySide2.QtGui.QPaintDevice): ...
    def rotate(self, a: float): ...
    def save(self): ...
    def scale(self, sx: float, sy: float): ...
    def setBackground(self, bg: PySide2.QtGui.QBrush): ...
    def setBackgroundMode(self, mode: PySide2.QtCore.Qt.BGMode): ...
    @typing.overload
    def setBrush(self, brush: PySide2.QtGui.QBrush): ...
    @typing.overload
    def setBrush(self, style: PySide2.QtCore.Qt.BrushStyle): ...
    @typing.overload
    def setBrushOrigin(self, arg__1: PySide2.QtCore.QPoint): ...
    @typing.overload
    def setBrushOrigin(self, arg__1: PySide2.QtCore.QPointF): ...
    @typing.overload
    def setBrushOrigin(self, x: int, y: int): ...
    def setClipPath(self, path: PySide2.QtGui.QPainterPath, op: PySide2.QtCore.Qt.ClipOperation = ...): ...
    @typing.overload
    def setClipRect(self, arg__1: PySide2.QtCore.QRect, op: PySide2.QtCore.Qt.ClipOperation = ...): ...
    @typing.overload
    def setClipRect(self, arg__1: PySide2.QtCore.QRectF, op: PySide2.QtCore.Qt.ClipOperation = ...): ...
    @typing.overload
    def setClipRect(self, x: int, y: int, w: int, h: int, op: PySide2.QtCore.Qt.ClipOperation = ...): ...
    def setClipRegion(self, arg__1: PySide2.QtGui.QRegion, op: PySide2.QtCore.Qt.ClipOperation = ...): ...
    def setClipping(self, enable: bool): ...
    def setCompositionMode(self, mode: PySide2.QtGui.QPainter.CompositionMode): ...
    def setFont(self, f: PySide2.QtGui.QFont): ...
    def setLayoutDirection(self, direction: PySide2.QtCore.Qt.LayoutDirection): ...
    def setMatrix(self, matrix: PySide2.QtGui.QMatrix, combine: bool = ...): ...
    def setMatrixEnabled(self, enabled: bool): ...
    def setOpacity(self, opacity: float): ...
    @typing.overload
    def setPen(self, color: PySide2.QtGui.QColor): ...
    @typing.overload
    def setPen(self, pen: PySide2.QtGui.QPen): ...
    @typing.overload
    def setPen(self, style: PySide2.QtCore.Qt.PenStyle): ...
    @staticmethod
    def setRedirected(device: PySide2.QtGui.QPaintDevice, replacement: PySide2.QtGui.QPaintDevice, offset: PySide2.QtCore.QPoint = ...): ...
    def setRenderHint(self, hint: PySide2.QtGui.QPainter.RenderHint, on: bool = ...): ...
    def setRenderHints(self, hints: PySide2.QtGui.QPainter.RenderHints, on: bool = ...): ...
    def setTransform(self, transform: PySide2.QtGui.QTransform, combine: bool = ...): ...
    def setViewTransformEnabled(self, enable: bool): ...
    @typing.overload
    def setViewport(self, viewport: PySide2.QtCore.QRect): ...
    @typing.overload
    def setViewport(self, x: int, y: int, w: int, h: int): ...
    @typing.overload
    def setWindow(self, window: PySide2.QtCore.QRect): ...
    @typing.overload
    def setWindow(self, x: int, y: int, w: int, h: int): ...
    def setWorldMatrix(self, matrix: PySide2.QtGui.QMatrix, combine: bool = ...): ...
    def setWorldMatrixEnabled(self, enabled: bool): ...
    def setWorldTransform(self, matrix: PySide2.QtGui.QTransform, combine: bool = ...): ...
    def shear(self, sh: float, sv: float): ...
    def strokePath(self, path: PySide2.QtGui.QPainterPath, pen: PySide2.QtGui.QPen): ...
    def testRenderHint(self, hint: PySide2.QtGui.QPainter.RenderHint) -> bool: ...
    def transform(self) -> PySide2.QtGui.QTransform: ...
    @typing.overload
    def translate(self, dx: float, dy: float): ...
    @typing.overload
    def translate(self, offset: PySide2.QtCore.QPoint): ...
    @typing.overload
    def translate(self, offset: PySide2.QtCore.QPointF): ...
    def viewTransformEnabled(self) -> bool: ...
    def viewport(self) -> PySide2.QtCore.QRect: ...
    def window(self) -> PySide2.QtCore.QRect: ...
    def worldMatrix(self) -> PySide2.QtGui.QMatrix: ...
    def worldMatrixEnabled(self) -> bool: ...
    def worldTransform(self) -> PySide2.QtGui.QTransform: ...

    class PixmapFragment(Shiboken.Object):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, PixmapFragment: PySide2.QtGui.QPainter.PixmapFragment): ...
        def __copy__(self): ...
        @staticmethod
        def create(pos: PySide2.QtCore.QPointF, sourceRect: PySide2.QtCore.QRectF, scaleX: float = ..., scaleY: float = ..., rotation: float = ..., opacity: float = ...) -> PySide2.QtGui.QPainter.PixmapFragment: ...


class QPainterPath(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QPainterPath): ...
    @typing.overload
    def __init__(self, startPoint: PySide2.QtCore.QPointF): ...
    def __add__(self, other: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    def __and__(self, other: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    def __copy__(self): ...
    def __iadd__(self, other: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    def __iand__(self, other: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    def __ior__(self, other: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    def __isub__(self, other: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, m: PySide2.QtGui.QMatrix) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def __mul__(self, m: PySide2.QtGui.QTransform) -> PySide2.QtGui.QPainterPath: ...
    def __or__(self, other: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __sub__(self, other: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def addEllipse(self, center: PySide2.QtCore.QPointF, rx: float, ry: float): ...
    @typing.overload
    def addEllipse(self, rect: PySide2.QtCore.QRectF): ...
    @typing.overload
    def addEllipse(self, x: float, y: float, w: float, h: float): ...
    def addPath(self, path: PySide2.QtGui.QPainterPath): ...
    def addPolygon(self, polygon: PySide2.QtGui.QPolygonF): ...
    @typing.overload
    def addRect(self, rect: PySide2.QtCore.QRectF): ...
    @typing.overload
    def addRect(self, x: float, y: float, w: float, h: float): ...
    def addRegion(self, region: PySide2.QtGui.QRegion): ...
    @typing.overload
    def addRoundRect(self, rect: PySide2.QtCore.QRectF, roundness: int): ...
    @typing.overload
    def addRoundRect(self, rect: PySide2.QtCore.QRectF, xRnd: int, yRnd: int): ...
    @typing.overload
    def addRoundRect(self, x: float, y: float, w: float, h: float, roundness: int): ...
    @typing.overload
    def addRoundRect(self, x: float, y: float, w: float, h: float, xRnd: int, yRnd: int): ...
    @typing.overload
    def addRoundedRect(self, rect: PySide2.QtCore.QRectF, xRadius: float, yRadius: float, mode: PySide2.QtCore.Qt.SizeMode = ...): ...
    @typing.overload
    def addRoundedRect(self, x: float, y: float, w: float, h: float, xRadius: float, yRadius: float, mode: PySide2.QtCore.Qt.SizeMode = ...): ...
    @typing.overload
    def addText(self, point: PySide2.QtCore.QPointF, f: PySide2.QtGui.QFont, text: str): ...
    @typing.overload
    def addText(self, x: float, y: float, f: PySide2.QtGui.QFont, text: str): ...
    def angleAtPercent(self, t: float) -> float: ...
    @typing.overload
    def arcMoveTo(self, rect: PySide2.QtCore.QRectF, angle: float): ...
    @typing.overload
    def arcMoveTo(self, x: float, y: float, w: float, h: float, angle: float): ...
    @typing.overload
    def arcTo(self, rect: PySide2.QtCore.QRectF, startAngle: float, arcLength: float): ...
    @typing.overload
    def arcTo(self, x: float, y: float, w: float, h: float, startAngle: float, arcLength: float): ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def closeSubpath(self): ...
    def connectPath(self, path: PySide2.QtGui.QPainterPath): ...
    @typing.overload
    def contains(self, p: PySide2.QtGui.QPainterPath) -> bool: ...
    @typing.overload
    def contains(self, pt: PySide2.QtCore.QPointF) -> bool: ...
    @typing.overload
    def contains(self, rect: PySide2.QtCore.QRectF) -> bool: ...
    def controlPointRect(self) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def cubicTo(self, ctrlPt1: PySide2.QtCore.QPointF, ctrlPt2: PySide2.QtCore.QPointF, endPt: PySide2.QtCore.QPointF): ...
    @typing.overload
    def cubicTo(self, ctrlPt1x: float, ctrlPt1y: float, ctrlPt2x: float, ctrlPt2y: float, endPtx: float, endPty: float): ...
    def currentPosition(self) -> PySide2.QtCore.QPointF: ...
    def elementAt(self, i: int) -> PySide2.QtGui.QPainterPath.Element: ...
    def elementCount(self) -> int: ...
    def fillRule(self) -> PySide2.QtCore.Qt.FillRule: ...
    def intersected(self, r: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def intersects(self, p: PySide2.QtGui.QPainterPath) -> bool: ...
    @typing.overload
    def intersects(self, rect: PySide2.QtCore.QRectF) -> bool: ...
    def isEmpty(self) -> bool: ...
    def length(self) -> float: ...
    @typing.overload
    def lineTo(self, p: PySide2.QtCore.QPointF): ...
    @typing.overload
    def lineTo(self, x: float, y: float): ...
    @typing.overload
    def moveTo(self, p: PySide2.QtCore.QPointF): ...
    @typing.overload
    def moveTo(self, x: float, y: float): ...
    def percentAtLength(self, t: float) -> float: ...
    def pointAtPercent(self, t: float) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def quadTo(self, ctrlPt: PySide2.QtCore.QPointF, endPt: PySide2.QtCore.QPointF): ...
    @typing.overload
    def quadTo(self, ctrlPtx: float, ctrlPty: float, endPtx: float, endPty: float): ...
    def setElementPositionAt(self, i: int, x: float, y: float): ...
    def setFillRule(self, fillRule: PySide2.QtCore.Qt.FillRule): ...
    def simplified(self) -> PySide2.QtGui.QPainterPath: ...
    def slopeAtPercent(self, t: float) -> float: ...
    def subtracted(self, r: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    def subtractedInverted(self, r: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    def swap(self, other: PySide2.QtGui.QPainterPath): ...
    @typing.overload
    def toFillPolygon(self, matrix: PySide2.QtGui.QMatrix = ...) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def toFillPolygon(self, matrix: PySide2.QtGui.QTransform) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def toFillPolygons(self, matrix: PySide2.QtGui.QMatrix = ...) -> typing.List[PySide2.QtGui.QPolygonF]: ...
    @typing.overload
    def toFillPolygons(self, matrix: PySide2.QtGui.QTransform) -> typing.List[PySide2.QtGui.QPolygonF]: ...
    def toReversed(self) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def toSubpathPolygons(self, matrix: PySide2.QtGui.QMatrix = ...) -> typing.List[PySide2.QtGui.QPolygonF]: ...
    @typing.overload
    def toSubpathPolygons(self, matrix: PySide2.QtGui.QTransform) -> typing.List[PySide2.QtGui.QPolygonF]: ...
    @typing.overload
    def translate(self, dx: float, dy: float): ...
    @typing.overload
    def translate(self, offset: PySide2.QtCore.QPointF): ...
    @typing.overload
    def translated(self, dx: float, dy: float) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def translated(self, offset: PySide2.QtCore.QPointF) -> PySide2.QtGui.QPainterPath: ...
    def united(self, r: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...

    class Element(Shiboken.Object):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, Element: PySide2.QtGui.QPainterPath.Element): ...
        def __copy__(self): ...
        def isCurveTo(self) -> bool: ...
        def isLineTo(self) -> bool: ...
        def isMoveTo(self) -> bool: ...


class QPainterPathStroker(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, pen: PySide2.QtGui.QPen): ...
    def capStyle(self) -> PySide2.QtCore.Qt.PenCapStyle: ...
    def createStroke(self, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    def curveThreshold(self) -> float: ...
    def dashOffset(self) -> float: ...
    def dashPattern(self) -> typing.List[float]: ...
    def joinStyle(self) -> PySide2.QtCore.Qt.PenJoinStyle: ...
    def miterLimit(self) -> float: ...
    def setCapStyle(self, style: PySide2.QtCore.Qt.PenCapStyle): ...
    def setCurveThreshold(self, threshold: float): ...
    def setDashOffset(self, offset: float): ...
    @typing.overload
    def setDashPattern(self, arg__1: PySide2.QtCore.Qt.PenStyle): ...
    @typing.overload
    def setDashPattern(self, dashPattern: typing.List[float]): ...
    def setJoinStyle(self, style: PySide2.QtCore.Qt.PenJoinStyle): ...
    def setMiterLimit(self, length: float): ...
    def setWidth(self, width: float): ...
    def width(self) -> float: ...


class QPalette(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, button: PySide2.QtCore.Qt.GlobalColor): ...
    @typing.overload
    def __init__(self, button: PySide2.QtGui.QColor): ...
    @typing.overload
    def __init__(self, button: PySide2.QtGui.QColor, window: PySide2.QtGui.QColor): ...
    @typing.overload
    def __init__(self, palette: PySide2.QtGui.QPalette): ...
    @typing.overload
    def __init__(self, windowText: PySide2.QtGui.QBrush, button: PySide2.QtGui.QBrush, light: PySide2.QtGui.QBrush, dark: PySide2.QtGui.QBrush, mid: PySide2.QtGui.QBrush, text: PySide2.QtGui.QBrush, bright_text: PySide2.QtGui.QBrush, base: PySide2.QtGui.QBrush, window: PySide2.QtGui.QBrush): ...
    @typing.overload
    def __init__(self, windowText: PySide2.QtGui.QColor, window: PySide2.QtGui.QColor, light: PySide2.QtGui.QColor, dark: PySide2.QtGui.QColor, mid: PySide2.QtGui.QColor, text: PySide2.QtGui.QColor, base: PySide2.QtGui.QColor): ...
    def __copy__(self): ...
    def __lshift__(self, ds: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, ds: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def alternateBase(self) -> PySide2.QtGui.QBrush: ...
    def background(self) -> PySide2.QtGui.QBrush: ...
    def base(self) -> PySide2.QtGui.QBrush: ...
    def brightText(self) -> PySide2.QtGui.QBrush: ...
    @typing.overload
    def brush(self, cg: PySide2.QtGui.QPalette.ColorGroup, cr: PySide2.QtGui.QPalette.ColorRole) -> PySide2.QtGui.QBrush: ...
    @typing.overload
    def brush(self, cr: PySide2.QtGui.QPalette.ColorRole) -> PySide2.QtGui.QBrush: ...
    def button(self) -> PySide2.QtGui.QBrush: ...
    def buttonText(self) -> PySide2.QtGui.QBrush: ...
    def cacheKey(self) -> int: ...
    @typing.overload
    def color(self, cg: PySide2.QtGui.QPalette.ColorGroup, cr: PySide2.QtGui.QPalette.ColorRole) -> PySide2.QtGui.QColor: ...
    @typing.overload
    def color(self, cr: PySide2.QtGui.QPalette.ColorRole) -> PySide2.QtGui.QColor: ...
    def currentColorGroup(self) -> PySide2.QtGui.QPalette.ColorGroup: ...
    def dark(self) -> PySide2.QtGui.QBrush: ...
    def foreground(self) -> PySide2.QtGui.QBrush: ...
    def highlight(self) -> PySide2.QtGui.QBrush: ...
    def highlightedText(self) -> PySide2.QtGui.QBrush: ...
    def isBrushSet(self, cg: PySide2.QtGui.QPalette.ColorGroup, cr: PySide2.QtGui.QPalette.ColorRole) -> bool: ...
    def isCopyOf(self, p: PySide2.QtGui.QPalette) -> bool: ...
    def isEqual(self, cr1: PySide2.QtGui.QPalette.ColorGroup, cr2: PySide2.QtGui.QPalette.ColorGroup) -> bool: ...
    def light(self) -> PySide2.QtGui.QBrush: ...
    def link(self) -> PySide2.QtGui.QBrush: ...
    def linkVisited(self) -> PySide2.QtGui.QBrush: ...
    def mid(self) -> PySide2.QtGui.QBrush: ...
    def midlight(self) -> PySide2.QtGui.QBrush: ...
    def placeholderText(self) -> PySide2.QtGui.QBrush: ...
    @typing.overload
    def resolve(self) -> int: ...
    @typing.overload
    def resolve(self, arg__1: PySide2.QtGui.QPalette) -> PySide2.QtGui.QPalette: ...
    @typing.overload
    def resolve(self, mask: int): ...
    @typing.overload
    def setBrush(self, cg: PySide2.QtGui.QPalette.ColorGroup, cr: PySide2.QtGui.QPalette.ColorRole, brush: PySide2.QtGui.QBrush): ...
    @typing.overload
    def setBrush(self, cr: PySide2.QtGui.QPalette.ColorRole, brush: PySide2.QtGui.QBrush): ...
    @typing.overload
    def setColor(self, cg: PySide2.QtGui.QPalette.ColorGroup, cr: PySide2.QtGui.QPalette.ColorRole, color: PySide2.QtGui.QColor): ...
    @typing.overload
    def setColor(self, cr: PySide2.QtGui.QPalette.ColorRole, color: PySide2.QtGui.QColor): ...
    def setColorGroup(self, cr: PySide2.QtGui.QPalette.ColorGroup, windowText: PySide2.QtGui.QBrush, button: PySide2.QtGui.QBrush, light: PySide2.QtGui.QBrush, dark: PySide2.QtGui.QBrush, mid: PySide2.QtGui.QBrush, text: PySide2.QtGui.QBrush, bright_text: PySide2.QtGui.QBrush, base: PySide2.QtGui.QBrush, window: PySide2.QtGui.QBrush): ...
    def setCurrentColorGroup(self, cg: PySide2.QtGui.QPalette.ColorGroup): ...
    def shadow(self) -> PySide2.QtGui.QBrush: ...
    def swap(self, other: PySide2.QtGui.QPalette): ...
    def text(self) -> PySide2.QtGui.QBrush: ...
    def toolTipBase(self) -> PySide2.QtGui.QBrush: ...
    def toolTipText(self) -> PySide2.QtGui.QBrush: ...
    def window(self) -> PySide2.QtGui.QBrush: ...
    def windowText(self) -> PySide2.QtGui.QBrush: ...


class QPdfWriter(PySide2.QtCore.QObject, PySide2.QtGui.QPagedPaintDevice):

    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice): ...
    @typing.overload
    def __init__(self, filename: str): ...
    def creator(self) -> str: ...
    def metric(self, id: PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def newPage(self) -> bool: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def pdfVersion(self) -> PySide2.QtGui.QPagedPaintDevice.PdfVersion: ...
    def resolution(self) -> int: ...
    def setCreator(self, creator: str): ...
    def setMargins(self, m: PySide2.QtGui.QPagedPaintDevice.Margins): ...
    def setPageSize(self, size: PySide2.QtGui.QPagedPaintDevice.PageSize): ...
    def setPageSizeMM(self, size: PySide2.QtCore.QSizeF): ...
    def setPdfVersion(self, version: PySide2.QtGui.QPagedPaintDevice.PdfVersion): ...
    def setResolution(self, resolution: int): ...
    def setTitle(self, title: str): ...
    def title(self) -> str: ...


class QPen(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.Qt.PenStyle): ...
    @typing.overload
    def __init__(self, brush: PySide2.QtGui.QBrush, width: float, s: PySide2.QtCore.Qt.PenStyle = ..., c: PySide2.QtCore.Qt.PenCapStyle = ..., j: PySide2.QtCore.Qt.PenJoinStyle = ...): ...
    @typing.overload
    def __init__(self, color: PySide2.QtGui.QColor): ...
    @typing.overload
    def __init__(self, pen: PySide2.QtGui.QPen): ...
    def __copy__(self): ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def brush(self) -> PySide2.QtGui.QBrush: ...
    def capStyle(self) -> PySide2.QtCore.Qt.PenCapStyle: ...
    def color(self) -> PySide2.QtGui.QColor: ...
    def dashOffset(self) -> float: ...
    def dashPattern(self) -> typing.List[float]: ...
    def isCosmetic(self) -> bool: ...
    def isSolid(self) -> bool: ...
    def joinStyle(self) -> PySide2.QtCore.Qt.PenJoinStyle: ...
    def miterLimit(self) -> float: ...
    def setBrush(self, brush: PySide2.QtGui.QBrush): ...
    def setCapStyle(self, pcs: PySide2.QtCore.Qt.PenCapStyle): ...
    def setColor(self, color: PySide2.QtGui.QColor): ...
    def setCosmetic(self, cosmetic: bool): ...
    def setDashOffset(self, doffset: float): ...
    def setDashPattern(self, pattern: typing.List[float]): ...
    def setJoinStyle(self, pcs: PySide2.QtCore.Qt.PenJoinStyle): ...
    def setMiterLimit(self, limit: float): ...
    def setStyle(self, arg__1: PySide2.QtCore.Qt.PenStyle): ...
    def setWidth(self, width: int): ...
    def setWidthF(self, width: float): ...
    def style(self) -> PySide2.QtCore.Qt.PenStyle: ...
    def swap(self, other: PySide2.QtGui.QPen): ...
    def width(self) -> int: ...
    def widthF(self) -> float: ...


class QPicture(PySide2.QtGui.QPaintDevice):

    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QPicture): ...
    @typing.overload
    def __init__(self, formatVersion: int = ...): ...
    def __copy__(self): ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def boundingRect(self) -> PySide2.QtCore.QRect: ...
    def data(self) -> str: ...
    def devType(self) -> int: ...
    @staticmethod
    def inputFormatList() -> typing.List[str]: ...
    @staticmethod
    def inputFormats() -> typing.List[PySide2.QtCore.QByteArray]: ...
    def isNull(self) -> bool: ...
    @typing.overload
    def load(self, dev: PySide2.QtCore.QIODevice, format: str = ...) -> bool: ...
    @typing.overload
    def load(self, fileName: str, format: str = ...) -> bool: ...
    def metric(self, m: PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    @staticmethod
    def outputFormatList() -> typing.List[str]: ...
    @staticmethod
    def outputFormats() -> typing.List[PySide2.QtCore.QByteArray]: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    @staticmethod
    def pictureFormat(fileName: str) -> str: ...
    def play(self, p: PySide2.QtGui.QPainter) -> bool: ...
    @typing.overload
    def save(self, dev: PySide2.QtCore.QIODevice, format: str = ...) -> bool: ...
    @typing.overload
    def save(self, fileName: str, format: str = ...) -> bool: ...
    def setBoundingRect(self, r: PySide2.QtCore.QRect): ...
    def setData(self, data: str, size: int): ...
    def size(self) -> int: ...
    def swap(self, other: PySide2.QtGui.QPicture): ...


class QPictureIO(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, fileName: str, format: str): ...
    @typing.overload
    def __init__(self, ioDevice: PySide2.QtCore.QIODevice, format: str): ...
    def description(self) -> str: ...
    def fileName(self) -> str: ...
    def format(self) -> str: ...
    def gamma(self) -> float: ...
    @staticmethod
    def inputFormats() -> typing.List[PySide2.QtCore.QByteArray]: ...
    def ioDevice(self) -> PySide2.QtCore.QIODevice: ...
    @staticmethod
    def outputFormats() -> typing.List[PySide2.QtCore.QByteArray]: ...
    def parameters(self) -> str: ...
    def picture(self) -> PySide2.QtGui.QPicture: ...
    @typing.overload
    @staticmethod
    def pictureFormat(arg__1: PySide2.QtCore.QIODevice) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def pictureFormat(fileName: str) -> PySide2.QtCore.QByteArray: ...
    def quality(self) -> int: ...
    def read(self) -> bool: ...
    def setDescription(self, arg__1: str): ...
    def setFileName(self, arg__1: str): ...
    def setFormat(self, arg__1: str): ...
    def setGamma(self, arg__1: float): ...
    def setIODevice(self, arg__1: PySide2.QtCore.QIODevice): ...
    def setParameters(self, arg__1: str): ...
    def setPicture(self, arg__1: PySide2.QtGui.QPicture): ...
    def setQuality(self, arg__1: int): ...
    def setStatus(self, arg__1: int): ...
    def status(self) -> int: ...
    def write(self) -> bool: ...


class QPixelFormat(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QPixelFormat: PySide2.QtGui.QPixelFormat): ...
    @typing.overload
    def __init__(self, colorModel: PySide2.QtGui.QPixelFormat.ColorModel, firstSize: typing.Char, secondSize: typing.Char, thirdSize: typing.Char, fourthSize: typing.Char, fifthSize: typing.Char, alphaSize: typing.Char, alphaUsage: PySide2.QtGui.QPixelFormat.AlphaUsage, alphaPosition: PySide2.QtGui.QPixelFormat.AlphaPosition, premultiplied: PySide2.QtGui.QPixelFormat.AlphaPremultiplied, typeInterpretation: PySide2.QtGui.QPixelFormat.TypeInterpretation, byteOrder: PySide2.QtGui.QPixelFormat.ByteOrder = ..., subEnum: typing.Char = ...): ...
    def __copy__(self): ...
    def alphaPosition(self) -> PySide2.QtGui.QPixelFormat.AlphaPosition: ...
    def alphaSize(self) -> typing.Char: ...
    def alphaUsage(self) -> PySide2.QtGui.QPixelFormat.AlphaUsage: ...
    def bitsPerPixel(self) -> typing.Char: ...
    def blackSize(self) -> typing.Char: ...
    def blueSize(self) -> typing.Char: ...
    def brightnessSize(self) -> typing.Char: ...
    def byteOrder(self) -> PySide2.QtGui.QPixelFormat.ByteOrder: ...
    def channelCount(self) -> typing.Char: ...
    def colorModel(self) -> PySide2.QtGui.QPixelFormat.ColorModel: ...
    def cyanSize(self) -> typing.Char: ...
    def greenSize(self) -> typing.Char: ...
    def hueSize(self) -> typing.Char: ...
    def lightnessSize(self) -> typing.Char: ...
    def magentaSize(self) -> typing.Char: ...
    def premultiplied(self) -> PySide2.QtGui.QPixelFormat.AlphaPremultiplied: ...
    def redSize(self) -> typing.Char: ...
    def saturationSize(self) -> typing.Char: ...
    def subEnum(self) -> typing.Char: ...
    def typeInterpretation(self) -> PySide2.QtGui.QPixelFormat.TypeInterpretation: ...
    def yellowSize(self) -> typing.Char: ...
    def yuvLayout(self) -> PySide2.QtGui.QPixelFormat.YUVLayout: ...


class QPixmap(PySide2.QtGui.QPaintDevice):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QSize): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QPixmap): ...
    @typing.overload
    def __init__(self, fileName: str, format: str = ..., flags: PySide2.QtCore.Qt.ImageConversionFlags = ...): ...
    @typing.overload
    def __init__(self, image: PySide2.QtGui.QImage): ...
    @typing.overload
    def __init__(self, w: int, h: int): ...
    @typing.overload
    def __init__(self, xpm: typing.List[typing.Char]): ...
    def __copy__(self): ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def cacheKey(self) -> int: ...
    def convertFromImage(self, img: PySide2.QtGui.QImage, flags: PySide2.QtCore.Qt.ImageConversionFlags = ...) -> bool: ...
    @typing.overload
    def copy(self, rect: PySide2.QtCore.QRect = ...) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def copy(self, x: int, y: int, width: int, height: int) -> PySide2.QtGui.QPixmap: ...
    def createHeuristicMask(self, clipTight: bool = ...) -> PySide2.QtGui.QBitmap: ...
    def createMaskFromColor(self, maskColor: PySide2.QtGui.QColor, mode: PySide2.QtCore.Qt.MaskMode = ...) -> PySide2.QtGui.QBitmap: ...
    @staticmethod
    def defaultDepth() -> int: ...
    def depth(self) -> int: ...
    def devType(self) -> int: ...
    def devicePixelRatio(self) -> float: ...
    @typing.overload
    def fill(self, device: PySide2.QtGui.QPaintDevice, ofs: PySide2.QtCore.QPoint): ...
    @typing.overload
    def fill(self, device: PySide2.QtGui.QPaintDevice, xofs: int, yofs: int): ...
    @typing.overload
    def fill(self, fillColor: PySide2.QtGui.QColor = ...): ...
    @staticmethod
    def fromImage(image: PySide2.QtGui.QImage, flags: PySide2.QtCore.Qt.ImageConversionFlags = ...) -> PySide2.QtGui.QPixmap: ...
    @staticmethod
    def fromImageInPlace(image: PySide2.QtGui.QImage, flags: PySide2.QtCore.Qt.ImageConversionFlags = ...) -> PySide2.QtGui.QPixmap: ...
    @staticmethod
    def fromImageReader(imageReader: PySide2.QtGui.QImageReader, flags: PySide2.QtCore.Qt.ImageConversionFlags = ...) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    @staticmethod
    def grabWidget(widget: PySide2.QtCore.QObject, rect: PySide2.QtCore.QRect) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    @staticmethod
    def grabWidget(widget: PySide2.QtCore.QObject, x: int = ..., y: int = ..., w: int = ..., h: int = ...) -> PySide2.QtGui.QPixmap: ...
    @staticmethod
    def grabWindow(arg__1: int, x: int = ..., y: int = ..., w: int = ..., h: int = ...) -> PySide2.QtGui.QPixmap: ...
    def hasAlpha(self) -> bool: ...
    def hasAlphaChannel(self) -> bool: ...
    def height(self) -> int: ...
    def isNull(self) -> bool: ...
    def isQBitmap(self) -> bool: ...
    def load(self, fileName: str, format: str = ..., flags: PySide2.QtCore.Qt.ImageConversionFlags = ...) -> bool: ...
    @typing.overload
    def loadFromData(self, buf: typing.Char, len: int, format: str = ..., flags: PySide2.QtCore.Qt.ImageConversionFlags = ...) -> bool: ...
    @typing.overload
    def loadFromData(self, data: PySide2.QtCore.QByteArray, format: str = ..., flags: PySide2.QtCore.Qt.ImageConversionFlags = ...) -> bool: ...
    def mask(self) -> PySide2.QtGui.QBitmap: ...
    def metric(self, arg__1: PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def rect(self) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def save(self, device: PySide2.QtCore.QIODevice, format: str = ..., quality: int = ...) -> bool: ...
    @typing.overload
    def save(self, fileName: str, format: str = ..., quality: int = ...) -> bool: ...
    @typing.overload
    def scaled(self, s: PySide2.QtCore.QSize, aspectMode: PySide2.QtCore.Qt.AspectRatioMode = ..., mode: PySide2.QtCore.Qt.TransformationMode = ...) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def scaled(self, w: int, h: int, aspectMode: PySide2.QtCore.Qt.AspectRatioMode = ..., mode: PySide2.QtCore.Qt.TransformationMode = ...) -> PySide2.QtGui.QPixmap: ...
    def scaledToHeight(self, h: int, mode: PySide2.QtCore.Qt.TransformationMode = ...) -> PySide2.QtGui.QPixmap: ...
    def scaledToWidth(self, w: int, mode: PySide2.QtCore.Qt.TransformationMode = ...) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def scroll(self, dx: int, dy: int, rect: PySide2.QtCore.QRect, exposed: PySide2.QtGui.QRegion = ...): ...
    @typing.overload
    def scroll(self, dx: int, dy: int, x: int, y: int, width: int, height: int, exposed: PySide2.QtGui.QRegion = ...): ...
    def setDevicePixelRatio(self, scaleFactor: float): ...
    def setMask(self, arg__1: PySide2.QtGui.QBitmap): ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def swap(self, other: PySide2.QtGui.QPixmap): ...
    def toImage(self) -> PySide2.QtGui.QImage: ...
    @typing.overload
    def transformed(self, arg__1: PySide2.QtGui.QMatrix, mode: PySide2.QtCore.Qt.TransformationMode = ...) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def transformed(self, arg__1: PySide2.QtGui.QTransform, mode: PySide2.QtCore.Qt.TransformationMode = ...) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    @staticmethod
    def trueMatrix(m: PySide2.QtGui.QMatrix, w: int, h: int) -> PySide2.QtGui.QMatrix: ...
    @typing.overload
    @staticmethod
    def trueMatrix(m: PySide2.QtGui.QTransform, w: int, h: int) -> PySide2.QtGui.QTransform: ...
    def width(self) -> int: ...


class QPixmapCache(Shiboken.Object):

    def __init__(self): ...
    @staticmethod
    def cacheLimit() -> int: ...
    @staticmethod
    def clear(): ...
    @typing.overload
    @staticmethod
    def find(arg__1: PySide2.QtGui.QPixmapCache.Key): ...
    @typing.overload
    @staticmethod
    def find(key: PySide2.QtGui.QPixmapCache.Key, pixmap: PySide2.QtGui.QPixmap) -> bool: ...
    @typing.overload
    @staticmethod
    def find(key: str) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    @staticmethod
    def find(key: str, pixmap: PySide2.QtGui.QPixmap) -> bool: ...
    @typing.overload
    @staticmethod
    def insert(key: str, pixmap: PySide2.QtGui.QPixmap) -> bool: ...
    @typing.overload
    @staticmethod
    def insert(pixmap: PySide2.QtGui.QPixmap) -> PySide2.QtGui.QPixmapCache.Key: ...
    @typing.overload
    @staticmethod
    def remove(key: PySide2.QtGui.QPixmapCache.Key): ...
    @typing.overload
    @staticmethod
    def remove(key: str): ...
    @staticmethod
    def replace(key: PySide2.QtGui.QPixmapCache.Key, pixmap: PySide2.QtGui.QPixmap) -> bool: ...
    @staticmethod
    def setCacheLimit(arg__1: int): ...

    class Key(Shiboken.Object):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, other: PySide2.QtGui.QPixmapCache.Key): ...
        def __copy__(self): ...
        def isValid(self) -> bool: ...
        def swap(self, other: PySide2.QtGui.QPixmapCache.Key): ...


class QPointingDeviceUniqueId(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QPointingDeviceUniqueId: PySide2.QtGui.QPointingDeviceUniqueId): ...
    def __copy__(self): ...
    @staticmethod
    def fromNumericId(id: int) -> PySide2.QtGui.QPointingDeviceUniqueId: ...
    def isValid(self) -> bool: ...
    def numericId(self) -> int: ...


class QPolygon(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QPolygon): ...
    @typing.overload
    def __init__(self, r: PySide2.QtCore.QRect, closed: bool = ...): ...
    @typing.overload
    def __init__(self, size: int): ...
    @typing.overload
    def __init__(self, v: typing.List[PySide2.QtCore.QPoint]): ...
    def __add__(self, l: typing.List[PySide2.QtCore.QPoint]) -> typing.List[PySide2.QtCore.QPoint]: ...
    def __copy__(self): ...
    def __iadd__(self, t: PySide2.QtCore.QPoint) -> typing.List[PySide2.QtCore.QPoint]: ...
    @typing.overload
    def __lshift__(self, l: typing.List[PySide2.QtCore.QPoint]) -> typing.List[PySide2.QtCore.QPoint]: ...
    @typing.overload
    def __lshift__(self, stream: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, t: PySide2.QtCore.QPoint) -> typing.List[PySide2.QtCore.QPoint]: ...
    @typing.overload
    def __mul__(self, m: PySide2.QtGui.QMatrix) -> PySide2.QtGui.QPolygon: ...
    @typing.overload
    def __mul__(self, m: PySide2.QtGui.QTransform) -> PySide2.QtGui.QPolygon: ...
    def __reduce__(self) -> object: ...
    def __rshift__(self, stream: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def append(self, l: typing.List[PySide2.QtCore.QPoint]): ...
    @typing.overload
    def append(self, t: PySide2.QtCore.QPoint): ...
    def at(self, i: int) -> PySide2.QtCore.QPoint: ...
    def back(self) -> PySide2.QtCore.QPoint: ...
    def boundingRect(self) -> PySide2.QtCore.QRect: ...
    def capacity(self) -> int: ...
    def clear(self): ...
    def constData(self) -> PySide2.QtCore.QPoint: ...
    def constFirst(self) -> PySide2.QtCore.QPoint: ...
    def constLast(self) -> PySide2.QtCore.QPoint: ...
    def contains(self, t: PySide2.QtCore.QPoint) -> bool: ...
    def containsPoint(self, pt: PySide2.QtCore.QPoint, fillRule: PySide2.QtCore.Qt.FillRule) -> bool: ...
    @typing.overload
    def count(self) -> int: ...
    @typing.overload
    def count(self, t: PySide2.QtCore.QPoint) -> int: ...
    def data(self) -> PySide2.QtCore.QPoint: ...
    def empty(self) -> bool: ...
    def endsWith(self, t: PySide2.QtCore.QPoint) -> bool: ...
    def fill(self, t: PySide2.QtCore.QPoint, size: int = ...) -> typing.List[PySide2.QtCore.QPoint]: ...
    def first(self) -> PySide2.QtCore.QPoint: ...
    @staticmethod
    def fromList(list: typing.List[PySide2.QtCore.QPoint]) -> typing.List[PySide2.QtCore.QPoint]: ...
    def front(self) -> PySide2.QtCore.QPoint: ...
    def indexOf(self, t: PySide2.QtCore.QPoint, from_: int = ...) -> int: ...
    @typing.overload
    def insert(self, i: int, n: int, t: PySide2.QtCore.QPoint): ...
    @typing.overload
    def insert(self, i: int, t: PySide2.QtCore.QPoint): ...
    def intersected(self, r: PySide2.QtGui.QPolygon) -> PySide2.QtGui.QPolygon: ...
    def intersects(self, r: PySide2.QtGui.QPolygon) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isSharedWith(self, other: typing.List[PySide2.QtCore.QPoint]) -> bool: ...
    def last(self) -> PySide2.QtCore.QPoint: ...
    def lastIndexOf(self, t: PySide2.QtCore.QPoint, from_: int = ...) -> int: ...
    def length(self) -> int: ...
    def mid(self, pos: int, len: int = ...) -> typing.List[PySide2.QtCore.QPoint]: ...
    def move(self, from_: int, to: int): ...
    def pop_back(self): ...
    def pop_front(self): ...
    def prepend(self, t: PySide2.QtCore.QPoint): ...
    def push_back(self, t: PySide2.QtCore.QPoint): ...
    def push_front(self, t: PySide2.QtCore.QPoint): ...
    @typing.overload
    def remove(self, i: int): ...
    @typing.overload
    def remove(self, i: int, n: int): ...
    def removeAll(self, t: PySide2.QtCore.QPoint) -> int: ...
    def removeAt(self, i: int): ...
    def removeFirst(self): ...
    def removeLast(self): ...
    def removeOne(self, t: PySide2.QtCore.QPoint) -> bool: ...
    def replace(self, i: int, t: PySide2.QtCore.QPoint): ...
    def reserve(self, size: int): ...
    def resize(self, size: int): ...
    def setSharable(self, sharable: bool): ...
    def shrink_to_fit(self): ...
    def size(self) -> int: ...
    def squeeze(self): ...
    def startsWith(self, t: PySide2.QtCore.QPoint) -> bool: ...
    def subtracted(self, r: PySide2.QtGui.QPolygon) -> PySide2.QtGui.QPolygon: ...
    def swap(self, other: PySide2.QtGui.QPolygon): ...
    def takeAt(self, i: int) -> PySide2.QtCore.QPoint: ...
    def takeFirst(self) -> PySide2.QtCore.QPoint: ...
    def takeLast(self) -> PySide2.QtCore.QPoint: ...
    def toList(self) -> typing.List[PySide2.QtCore.QPoint]: ...
    @typing.overload
    def translate(self, dx: int, dy: int): ...
    @typing.overload
    def translate(self, offset: PySide2.QtCore.QPoint): ...
    @typing.overload
    def translated(self, dx: int, dy: int) -> PySide2.QtGui.QPolygon: ...
    @typing.overload
    def translated(self, offset: PySide2.QtCore.QPoint) -> PySide2.QtGui.QPolygon: ...
    def united(self, r: PySide2.QtGui.QPolygon) -> PySide2.QtGui.QPolygon: ...
    @typing.overload
    def value(self, i: int) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def value(self, i: int, defaultValue: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...


class QPolygonF(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, a: PySide2.QtGui.QPolygon): ...
    @typing.overload
    def __init__(self, a: PySide2.QtGui.QPolygonF): ...
    @typing.overload
    def __init__(self, r: PySide2.QtCore.QRectF): ...
    @typing.overload
    def __init__(self, size: int): ...
    @typing.overload
    def __init__(self, v: typing.List[PySide2.QtCore.QPointF]): ...
    def __add__(self, l: typing.List[PySide2.QtCore.QPointF]) -> typing.List[PySide2.QtCore.QPointF]: ...
    def __copy__(self): ...
    def __iadd__(self, t: PySide2.QtCore.QPointF) -> typing.List[PySide2.QtCore.QPointF]: ...
    def __lshift__(self, stream: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, m: PySide2.QtGui.QMatrix) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def __mul__(self, m: PySide2.QtGui.QTransform) -> PySide2.QtGui.QPolygonF: ...
    def __rshift__(self, stream: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def append(self, l: typing.List[PySide2.QtCore.QPointF]): ...
    @typing.overload
    def append(self, t: PySide2.QtCore.QPointF): ...
    def at(self, i: int) -> PySide2.QtCore.QPointF: ...
    def back(self) -> PySide2.QtCore.QPointF: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def capacity(self) -> int: ...
    def clear(self): ...
    def constData(self) -> PySide2.QtCore.QPointF: ...
    def constFirst(self) -> PySide2.QtCore.QPointF: ...
    def constLast(self) -> PySide2.QtCore.QPointF: ...
    def contains(self, t: PySide2.QtCore.QPointF) -> bool: ...
    def containsPoint(self, pt: PySide2.QtCore.QPointF, fillRule: PySide2.QtCore.Qt.FillRule) -> bool: ...
    @typing.overload
    def count(self) -> int: ...
    @typing.overload
    def count(self, t: PySide2.QtCore.QPointF) -> int: ...
    def data(self) -> PySide2.QtCore.QPointF: ...
    def empty(self) -> bool: ...
    def endsWith(self, t: PySide2.QtCore.QPointF) -> bool: ...
    def fill(self, t: PySide2.QtCore.QPointF, size: int = ...) -> typing.List[PySide2.QtCore.QPointF]: ...
    def first(self) -> PySide2.QtCore.QPointF: ...
    @staticmethod
    def fromList(list: typing.List[PySide2.QtCore.QPointF]) -> typing.List[PySide2.QtCore.QPointF]: ...
    def front(self) -> PySide2.QtCore.QPointF: ...
    def indexOf(self, t: PySide2.QtCore.QPointF, from_: int = ...) -> int: ...
    @typing.overload
    def insert(self, i: int, n: int, t: PySide2.QtCore.QPointF): ...
    @typing.overload
    def insert(self, i: int, t: PySide2.QtCore.QPointF): ...
    def intersected(self, r: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    def intersects(self, r: PySide2.QtGui.QPolygonF) -> bool: ...
    def isClosed(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isSharedWith(self, other: typing.List[PySide2.QtCore.QPointF]) -> bool: ...
    def last(self) -> PySide2.QtCore.QPointF: ...
    def lastIndexOf(self, t: PySide2.QtCore.QPointF, from_: int = ...) -> int: ...
    def length(self) -> int: ...
    def mid(self, pos: int, len: int = ...) -> typing.List[PySide2.QtCore.QPointF]: ...
    def move(self, from_: int, to: int): ...
    def pop_back(self): ...
    def pop_front(self): ...
    def prepend(self, t: PySide2.QtCore.QPointF): ...
    def push_back(self, t: PySide2.QtCore.QPointF): ...
    def push_front(self, t: PySide2.QtCore.QPointF): ...
    @typing.overload
    def remove(self, i: int): ...
    @typing.overload
    def remove(self, i: int, n: int): ...
    def removeAll(self, t: PySide2.QtCore.QPointF) -> int: ...
    def removeAt(self, i: int): ...
    def removeFirst(self): ...
    def removeLast(self): ...
    def removeOne(self, t: PySide2.QtCore.QPointF) -> bool: ...
    def replace(self, i: int, t: PySide2.QtCore.QPointF): ...
    def reserve(self, size: int): ...
    def resize(self, size: int): ...
    def setSharable(self, sharable: bool): ...
    def shrink_to_fit(self): ...
    def size(self) -> int: ...
    def squeeze(self): ...
    def startsWith(self, t: PySide2.QtCore.QPointF) -> bool: ...
    def subtracted(self, r: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    def swap(self, other: PySide2.QtGui.QPolygonF): ...
    def takeAt(self, i: int) -> PySide2.QtCore.QPointF: ...
    def takeFirst(self) -> PySide2.QtCore.QPointF: ...
    def takeLast(self) -> PySide2.QtCore.QPointF: ...
    def toList(self) -> typing.List[PySide2.QtCore.QPointF]: ...
    def toPolygon(self) -> PySide2.QtGui.QPolygon: ...
    @typing.overload
    def translate(self, dx: float, dy: float): ...
    @typing.overload
    def translate(self, offset: PySide2.QtCore.QPointF): ...
    @typing.overload
    def translated(self, dx: float, dy: float) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def translated(self, offset: PySide2.QtCore.QPointF) -> PySide2.QtGui.QPolygonF: ...
    def united(self, r: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def value(self, i: int) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def value(self, i: int, defaultValue: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...


class QPyTextObject(PySide2.QtCore.QObject, PySide2.QtGui.QTextObjectInterface):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def drawObject(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRectF, doc: PySide2.QtGui.QTextDocument, posInDocument: int, format: PySide2.QtGui.QTextFormat): ...
    def intrinsicSize(self, doc: PySide2.QtGui.QTextDocument, posInDocument: int, format: PySide2.QtGui.QTextFormat) -> PySide2.QtCore.QSizeF: ...


class QQuaternion(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, scalar: float, vector: PySide2.QtGui.QVector3D): ...
    @typing.overload
    def __init__(self, scalar: float, xpos: float, ypos: float, zpos: float): ...
    @typing.overload
    def __init__(self, vector: PySide2.QtGui.QVector4D): ...
    def __add__(self, q2: PySide2.QtGui.QQuaternion) -> PySide2.QtGui.QQuaternion: ...
    def __copy__(self): ...
    def __iadd__(self, quaternion: PySide2.QtGui.QQuaternion) -> PySide2.QtGui.QQuaternion: ...
    @typing.overload
    def __imul__(self, factor: float) -> PySide2.QtGui.QQuaternion: ...
    @typing.overload
    def __imul__(self, quaternion: PySide2.QtGui.QQuaternion) -> PySide2.QtGui.QQuaternion: ...
    def __isub__(self, quaternion: PySide2.QtGui.QQuaternion) -> PySide2.QtGui.QQuaternion: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, factor: float) -> PySide2.QtGui.QQuaternion: ...
    @typing.overload
    def __mul__(self, q2: PySide2.QtGui.QQuaternion) -> PySide2.QtGui.QQuaternion: ...
    def __neg__(self) -> PySide2.QtGui.QQuaternion: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __sub__(self, q2: PySide2.QtGui.QQuaternion) -> PySide2.QtGui.QQuaternion: ...
    def conjugate(self) -> PySide2.QtGui.QQuaternion: ...
    def conjugated(self) -> PySide2.QtGui.QQuaternion: ...
    @staticmethod
    def dotProduct(q1: PySide2.QtGui.QQuaternion, q2: PySide2.QtGui.QQuaternion) -> float: ...
    @staticmethod
    def fromAxes(xAxis: PySide2.QtGui.QVector3D, yAxis: PySide2.QtGui.QVector3D, zAxis: PySide2.QtGui.QVector3D) -> PySide2.QtGui.QQuaternion: ...
    @typing.overload
    @staticmethod
    def fromAxisAndAngle(axis: PySide2.QtGui.QVector3D, angle: float) -> PySide2.QtGui.QQuaternion: ...
    @typing.overload
    @staticmethod
    def fromAxisAndAngle(x: float, y: float, z: float, angle: float) -> PySide2.QtGui.QQuaternion: ...
    @staticmethod
    def fromDirection(direction: PySide2.QtGui.QVector3D, up: PySide2.QtGui.QVector3D) -> PySide2.QtGui.QQuaternion: ...
    @typing.overload
    @staticmethod
    def fromEulerAngles(eulerAngles: PySide2.QtGui.QVector3D) -> PySide2.QtGui.QQuaternion: ...
    @typing.overload
    @staticmethod
    def fromEulerAngles(pitch: float, yaw: float, roll: float) -> PySide2.QtGui.QQuaternion: ...
    @staticmethod
    def fromRotationMatrix(rot3x3: PySide2.QtGui.QMatrix3x3) -> PySide2.QtGui.QQuaternion: ...
    def getAxes(self, xAxis: PySide2.QtGui.QVector3D, yAxis: PySide2.QtGui.QVector3D, zAxis: PySide2.QtGui.QVector3D): ...
    def inverted(self) -> PySide2.QtGui.QQuaternion: ...
    def isIdentity(self) -> bool: ...
    def isNull(self) -> bool: ...
    def length(self) -> float: ...
    def lengthSquared(self) -> float: ...
    @staticmethod
    def nlerp(q1: PySide2.QtGui.QQuaternion, q2: PySide2.QtGui.QQuaternion, t: float) -> PySide2.QtGui.QQuaternion: ...
    def normalize(self): ...
    def normalized(self) -> PySide2.QtGui.QQuaternion: ...
    def rotatedVector(self, vector: PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    @staticmethod
    def rotationTo(from_: PySide2.QtGui.QVector3D, to: PySide2.QtGui.QVector3D) -> PySide2.QtGui.QQuaternion: ...
    def scalar(self) -> float: ...
    def setScalar(self, scalar: float): ...
    @typing.overload
    def setVector(self, vector: PySide2.QtGui.QVector3D): ...
    @typing.overload
    def setVector(self, x: float, y: float, z: float): ...
    def setX(self, x: float): ...
    def setY(self, y: float): ...
    def setZ(self, z: float): ...
    @staticmethod
    def slerp(q1: PySide2.QtGui.QQuaternion, q2: PySide2.QtGui.QQuaternion, t: float) -> PySide2.QtGui.QQuaternion: ...
    def toEulerAngles(self) -> PySide2.QtGui.QVector3D: ...
    def toRotationMatrix(self) -> PySide2.QtGui.QMatrix3x3: ...
    def toVector4D(self) -> PySide2.QtGui.QVector4D: ...
    def vector(self) -> PySide2.QtGui.QVector3D: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...


class QRadialGradient(PySide2.QtGui.QGradient):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QRadialGradient: PySide2.QtGui.QRadialGradient): ...
    @typing.overload
    def __init__(self, center: PySide2.QtCore.QPointF, centerRadius: float, focalPoint: PySide2.QtCore.QPointF, focalRadius: float): ...
    @typing.overload
    def __init__(self, center: PySide2.QtCore.QPointF, radius: float): ...
    @typing.overload
    def __init__(self, center: PySide2.QtCore.QPointF, radius: float, focalPoint: PySide2.QtCore.QPointF): ...
    @typing.overload
    def __init__(self, cx: float, cy: float, centerRadius: float, fx: float, fy: float, focalRadius: float): ...
    @typing.overload
    def __init__(self, cx: float, cy: float, radius: float): ...
    @typing.overload
    def __init__(self, cx: float, cy: float, radius: float, fx: float, fy: float): ...
    def __copy__(self): ...
    def center(self) -> PySide2.QtCore.QPointF: ...
    def centerRadius(self) -> float: ...
    def focalPoint(self) -> PySide2.QtCore.QPointF: ...
    def focalRadius(self) -> float: ...
    def radius(self) -> float: ...
    @typing.overload
    def setCenter(self, center: PySide2.QtCore.QPointF): ...
    @typing.overload
    def setCenter(self, x: float, y: float): ...
    def setCenterRadius(self, radius: float): ...
    @typing.overload
    def setFocalPoint(self, focalPoint: PySide2.QtCore.QPointF): ...
    @typing.overload
    def setFocalPoint(self, x: float, y: float): ...
    def setFocalRadius(self, radius: float): ...
    def setRadius(self, radius: float): ...


class QRasterWindow(PySide2.QtGui.QPaintDeviceWindow):

    def __init__(self, parent: PySide2.QtGui.QWindow = ...): ...
    def metric(self, metric: PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def redirected(self, arg__1: PySide2.QtCore.QPoint) -> PySide2.QtGui.QPaintDevice: ...


class QRawFont(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, fileName: str, pixelSize: float, hintingPreference: PySide2.QtGui.QFont.HintingPreference = ...): ...
    @typing.overload
    def __init__(self, fontData: PySide2.QtCore.QByteArray, pixelSize: float, hintingPreference: PySide2.QtGui.QFont.HintingPreference = ...): ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QRawFont): ...
    def __copy__(self): ...
    @typing.overload
    def advancesForGlyphIndexes(self, glyphIndexes: typing.List[int]) -> typing.List[PySide2.QtCore.QPointF]: ...
    @typing.overload
    def advancesForGlyphIndexes(self, glyphIndexes: typing.List[int], layoutFlags: PySide2.QtGui.QRawFont.LayoutFlags) -> typing.List[PySide2.QtCore.QPointF]: ...
    def alphaMapForGlyph(self, glyphIndex: int, antialiasingType: PySide2.QtGui.QRawFont.AntialiasingType = ..., transform: PySide2.QtGui.QTransform = ...) -> PySide2.QtGui.QImage: ...
    def ascent(self) -> float: ...
    def averageCharWidth(self) -> float: ...
    def boundingRect(self, glyphIndex: int) -> PySide2.QtCore.QRectF: ...
    def capHeight(self) -> float: ...
    def descent(self) -> float: ...
    def familyName(self) -> str: ...
    def fontTable(self, tagName: str) -> PySide2.QtCore.QByteArray: ...
    @staticmethod
    def fromFont(font: PySide2.QtGui.QFont, writingSystem: PySide2.QtGui.QFontDatabase.WritingSystem = ...) -> PySide2.QtGui.QRawFont: ...
    def glyphIndexesForString(self, text: str) -> typing.List[int]: ...
    def hintingPreference(self) -> PySide2.QtGui.QFont.HintingPreference: ...
    def isValid(self) -> bool: ...
    def leading(self) -> float: ...
    def lineThickness(self) -> float: ...
    def loadFromData(self, fontData: PySide2.QtCore.QByteArray, pixelSize: float, hintingPreference: PySide2.QtGui.QFont.HintingPreference): ...
    def loadFromFile(self, fileName: str, pixelSize: float, hintingPreference: PySide2.QtGui.QFont.HintingPreference): ...
    def maxCharWidth(self) -> float: ...
    def pathForGlyph(self, glyphIndex: int) -> PySide2.QtGui.QPainterPath: ...
    def pixelSize(self) -> float: ...
    def setPixelSize(self, pixelSize: float): ...
    def style(self) -> PySide2.QtGui.QFont.Style: ...
    def styleName(self) -> str: ...
    def supportedWritingSystems(self) -> typing.List[PySide2.QtGui.QFontDatabase.WritingSystem]: ...
    @typing.overload
    def supportsCharacter(self, character: typing.Char) -> bool: ...
    @typing.overload
    def supportsCharacter(self, ucs4: int) -> bool: ...
    def swap(self, other: PySide2.QtGui.QRawFont): ...
    def underlinePosition(self) -> float: ...
    def unitsPerEm(self) -> float: ...
    def weight(self) -> int: ...
    def xHeight(self) -> float: ...


class QRegExpValidator(PySide2.QtGui.QValidator):

    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, rx: PySide2.QtCore.QRegExp, parent: PySide2.QtCore.QObject = ...): ...
    def regExp(self) -> PySide2.QtCore.QRegExp: ...
    def setRegExp(self, rx: PySide2.QtCore.QRegExp): ...
    def validate(self, input: str, pos: int) -> PySide2.QtGui.QValidator.State: ...


class QRegion(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, bitmap: PySide2.QtGui.QBitmap): ...
    @typing.overload
    def __init__(self, pa: PySide2.QtGui.QPolygon, fillRule: PySide2.QtCore.Qt.FillRule = ...): ...
    @typing.overload
    def __init__(self, r: PySide2.QtCore.QRect, t: PySide2.QtGui.QRegion.RegionType = ...): ...
    @typing.overload
    def __init__(self, region: PySide2.QtGui.QRegion): ...
    @typing.overload
    def __init__(self, x: int, y: int, w: int, h: int, t: PySide2.QtGui.QRegion.RegionType = ...): ...
    @typing.overload
    def __add__(self, r: PySide2.QtCore.QRect) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def __add__(self, r: PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def __and__(self, r: PySide2.QtCore.QRect) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def __and__(self, r: PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    def __copy__(self): ...
    @typing.overload
    def __iadd__(self, r: PySide2.QtCore.QRect) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def __iadd__(self, r: PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    def __ior__(self, r: PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    def __isub__(self, r: PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    def __ixor__(self, r: PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, m: PySide2.QtGui.QMatrix) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def __mul__(self, m: PySide2.QtGui.QTransform) -> PySide2.QtGui.QRegion: ...
    def __or__(self, r: PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __sub__(self, r: PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    def __xor__(self, r: PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    def begin(self) -> PySide2.QtCore.QRect: ...
    def boundingRect(self) -> PySide2.QtCore.QRect: ...
    def cbegin(self) -> PySide2.QtCore.QRect: ...
    def cend(self) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def contains(self, p: PySide2.QtCore.QPoint) -> bool: ...
    @typing.overload
    def contains(self, r: PySide2.QtCore.QRect) -> bool: ...
    def end(self) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def intersected(self, r: PySide2.QtCore.QRect) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def intersected(self, r: PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def intersects(self, r: PySide2.QtCore.QRect) -> bool: ...
    @typing.overload
    def intersects(self, r: PySide2.QtGui.QRegion) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def rectCount(self) -> int: ...
    def rects(self) -> typing.List[PySide2.QtCore.QRect]: ...
    def setRects(self, rect: PySide2.QtCore.QRect, num: int): ...
    def subtracted(self, r: PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    def swap(self, other: PySide2.QtGui.QRegion): ...
    @typing.overload
    def translate(self, dx: int, dy: int): ...
    @typing.overload
    def translate(self, p: PySide2.QtCore.QPoint): ...
    @typing.overload
    def translated(self, dx: int, dy: int) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def translated(self, p: PySide2.QtCore.QPoint) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def united(self, r: PySide2.QtCore.QRect) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def united(self, r: PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    def xored(self, r: PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...


class QResizeEvent(PySide2.QtCore.QEvent):

    def __init__(self, size: PySide2.QtCore.QSize, oldSize: PySide2.QtCore.QSize): ...
    def oldSize(self) -> PySide2.QtCore.QSize: ...
    def size(self) -> PySide2.QtCore.QSize: ...


class QScreen(PySide2.QtCore.QObject):

    def angleBetween(self, a: PySide2.QtCore.Qt.ScreenOrientation, b: PySide2.QtCore.Qt.ScreenOrientation) -> int: ...
    def availableGeometry(self) -> PySide2.QtCore.QRect: ...
    def availableSize(self) -> PySide2.QtCore.QSize: ...
    def availableVirtualGeometry(self) -> PySide2.QtCore.QRect: ...
    def availableVirtualSize(self) -> PySide2.QtCore.QSize: ...
    def depth(self) -> int: ...
    def devicePixelRatio(self) -> float: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def grabWindow(self, window: int, x: int = ..., y: int = ..., w: int = ..., h: int = ...) -> PySide2.QtGui.QPixmap: ...
    def isLandscape(self, orientation: PySide2.QtCore.Qt.ScreenOrientation) -> bool: ...
    def isPortrait(self, orientation: PySide2.QtCore.Qt.ScreenOrientation) -> bool: ...
    def logicalDotsPerInch(self) -> float: ...
    def logicalDotsPerInchX(self) -> float: ...
    def logicalDotsPerInchY(self) -> float: ...
    def manufacturer(self) -> str: ...
    def mapBetween(self, a: PySide2.QtCore.Qt.ScreenOrientation, b: PySide2.QtCore.Qt.ScreenOrientation, rect: PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    def model(self) -> str: ...
    def name(self) -> str: ...
    def nativeOrientation(self) -> PySide2.QtCore.Qt.ScreenOrientation: ...
    def orientation(self) -> PySide2.QtCore.Qt.ScreenOrientation: ...
    def orientationUpdateMask(self) -> PySide2.QtCore.Qt.ScreenOrientations: ...
    def physicalDotsPerInch(self) -> float: ...
    def physicalDotsPerInchX(self) -> float: ...
    def physicalDotsPerInchY(self) -> float: ...
    def physicalSize(self) -> PySide2.QtCore.QSizeF: ...
    def primaryOrientation(self) -> PySide2.QtCore.Qt.ScreenOrientation: ...
    def refreshRate(self) -> float: ...
    def serialNumber(self) -> str: ...
    def setOrientationUpdateMask(self, mask: PySide2.QtCore.Qt.ScreenOrientations): ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def transformBetween(self, a: PySide2.QtCore.Qt.ScreenOrientation, b: PySide2.QtCore.Qt.ScreenOrientation, target: PySide2.QtCore.QRect) -> PySide2.QtGui.QTransform: ...
    def virtualGeometry(self) -> PySide2.QtCore.QRect: ...
    def virtualSiblings(self) -> typing.List[PySide2.QtGui.QScreen]: ...
    def virtualSize(self) -> PySide2.QtCore.QSize: ...


class QScrollEvent(PySide2.QtCore.QEvent):

    def __init__(self, contentPos: PySide2.QtCore.QPointF, overshoot: PySide2.QtCore.QPointF, scrollState: PySide2.QtGui.QScrollEvent.ScrollState): ...
    def contentPos(self) -> PySide2.QtCore.QPointF: ...
    def overshootDistance(self) -> PySide2.QtCore.QPointF: ...
    def scrollState(self) -> PySide2.QtGui.QScrollEvent.ScrollState: ...


class QScrollPrepareEvent(PySide2.QtCore.QEvent):

    def __init__(self, startPos: PySide2.QtCore.QPointF): ...
    def contentPos(self) -> PySide2.QtCore.QPointF: ...
    def contentPosRange(self) -> PySide2.QtCore.QRectF: ...
    def setContentPos(self, pos: PySide2.QtCore.QPointF): ...
    def setContentPosRange(self, rect: PySide2.QtCore.QRectF): ...
    def setViewportSize(self, size: PySide2.QtCore.QSizeF): ...
    def startPos(self) -> PySide2.QtCore.QPointF: ...
    def viewportSize(self) -> PySide2.QtCore.QSizeF: ...


class QSessionManager(PySide2.QtCore.QObject):

    def allowsErrorInteraction(self) -> bool: ...
    def allowsInteraction(self) -> bool: ...
    def cancel(self): ...
    def discardCommand(self) -> typing.List[str]: ...
    def isPhase2(self) -> bool: ...
    def release(self): ...
    def requestPhase2(self): ...
    def restartCommand(self) -> typing.List[str]: ...
    def restartHint(self) -> PySide2.QtGui.QSessionManager.RestartHint: ...
    def sessionId(self) -> str: ...
    def sessionKey(self) -> str: ...
    def setDiscardCommand(self, arg__1: typing.List[str]): ...
    @typing.overload
    def setManagerProperty(self, name: str, value: str): ...
    @typing.overload
    def setManagerProperty(self, name: str, value: typing.List[str]): ...
    def setRestartCommand(self, arg__1: typing.List[str]): ...
    def setRestartHint(self, arg__1: PySide2.QtGui.QSessionManager.RestartHint): ...


class QShortcutEvent(PySide2.QtCore.QEvent):

    def __init__(self, key: PySide2.QtGui.QKeySequence, id: int, ambiguous: bool = ...): ...
    def isAmbiguous(self) -> bool: ...
    def key(self) -> PySide2.QtGui.QKeySequence: ...
    def shortcutId(self) -> int: ...


class QShowEvent(PySide2.QtCore.QEvent):

    def __init__(self): ...


class QStandardItem(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, icon: PySide2.QtGui.QIcon, text: str): ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QStandardItem): ...
    @typing.overload
    def __init__(self, rows: int, columns: int = ...): ...
    @typing.overload
    def __init__(self, text: str): ...
    def __lshift__(self, out: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, in_: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def accessibleDescription(self) -> str: ...
    def accessibleText(self) -> str: ...
    def appendColumn(self, items: typing.List[PySide2.QtGui.QStandardItem]): ...
    @typing.overload
    def appendRow(self, item: PySide2.QtGui.QStandardItem): ...
    @typing.overload
    def appendRow(self, items: typing.List[PySide2.QtGui.QStandardItem]): ...
    def appendRows(self, items: typing.List[PySide2.QtGui.QStandardItem]): ...
    def background(self) -> PySide2.QtGui.QBrush: ...
    def checkState(self) -> PySide2.QtCore.Qt.CheckState: ...
    def child(self, row: int, column: int = ...) -> PySide2.QtGui.QStandardItem: ...
    def clearData(self): ...
    def clone(self) -> PySide2.QtGui.QStandardItem: ...
    def column(self) -> int: ...
    def columnCount(self) -> int: ...
    def data(self, role: int = ...) -> typing.Any: ...
    def emitDataChanged(self): ...
    def flags(self) -> PySide2.QtCore.Qt.ItemFlags: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def foreground(self) -> PySide2.QtGui.QBrush: ...
    def hasChildren(self) -> bool: ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def index(self) -> PySide2.QtCore.QModelIndex: ...
    def insertColumn(self, column: int, items: typing.List[PySide2.QtGui.QStandardItem]): ...
    def insertColumns(self, column: int, count: int): ...
    @typing.overload
    def insertRow(self, row: int, item: PySide2.QtGui.QStandardItem): ...
    @typing.overload
    def insertRow(self, row: int, items: typing.List[PySide2.QtGui.QStandardItem]): ...
    @typing.overload
    def insertRows(self, row: int, count: int): ...
    @typing.overload
    def insertRows(self, row: int, items: typing.List[PySide2.QtGui.QStandardItem]): ...
    def isAutoTristate(self) -> bool: ...
    def isCheckable(self) -> bool: ...
    def isDragEnabled(self) -> bool: ...
    def isDropEnabled(self) -> bool: ...
    def isEditable(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isSelectable(self) -> bool: ...
    def isTristate(self) -> bool: ...
    def isUserTristate(self) -> bool: ...
    def model(self) -> PySide2.QtGui.QStandardItemModel: ...
    def parent(self) -> PySide2.QtGui.QStandardItem: ...
    def read(self, in_: PySide2.QtCore.QDataStream): ...
    def removeColumn(self, column: int): ...
    def removeColumns(self, column: int, count: int): ...
    def removeRow(self, row: int): ...
    def removeRows(self, row: int, count: int): ...
    def row(self) -> int: ...
    def rowCount(self) -> int: ...
    def setAccessibleDescription(self, accessibleDescription: str): ...
    def setAccessibleText(self, accessibleText: str): ...
    def setAutoTristate(self, tristate: bool): ...
    def setBackground(self, brush: PySide2.QtGui.QBrush): ...
    def setCheckState(self, checkState: PySide2.QtCore.Qt.CheckState): ...
    def setCheckable(self, checkable: bool): ...
    @typing.overload
    def setChild(self, row: int, column: int, item: PySide2.QtGui.QStandardItem): ...
    @typing.overload
    def setChild(self, row: int, item: PySide2.QtGui.QStandardItem): ...
    def setColumnCount(self, columns: int): ...
    def setData(self, value: typing.Any, role: int = ...): ...
    def setDragEnabled(self, dragEnabled: bool): ...
    def setDropEnabled(self, dropEnabled: bool): ...
    def setEditable(self, editable: bool): ...
    def setEnabled(self, enabled: bool): ...
    def setFlags(self, flags: PySide2.QtCore.Qt.ItemFlags): ...
    def setFont(self, font: PySide2.QtGui.QFont): ...
    def setForeground(self, brush: PySide2.QtGui.QBrush): ...
    def setIcon(self, icon: PySide2.QtGui.QIcon): ...
    def setRowCount(self, rows: int): ...
    def setSelectable(self, selectable: bool): ...
    def setSizeHint(self, sizeHint: PySide2.QtCore.QSize): ...
    def setStatusTip(self, statusTip: str): ...
    def setText(self, text: str): ...
    def setTextAlignment(self, textAlignment: PySide2.QtCore.Qt.Alignment): ...
    def setToolTip(self, toolTip: str): ...
    def setTristate(self, tristate: bool): ...
    def setUserTristate(self, tristate: bool): ...
    def setWhatsThis(self, whatsThis: str): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sortChildren(self, column: int, order: PySide2.QtCore.Qt.SortOrder = ...): ...
    def statusTip(self) -> str: ...
    def takeChild(self, row: int, column: int = ...) -> PySide2.QtGui.QStandardItem: ...
    def takeColumn(self, column: int) -> typing.List[PySide2.QtGui.QStandardItem]: ...
    def takeRow(self, row: int) -> typing.List[PySide2.QtGui.QStandardItem]: ...
    def text(self) -> str: ...
    def textAlignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def toolTip(self) -> str: ...
    def type(self) -> int: ...
    def whatsThis(self) -> str: ...
    def write(self, out: PySide2.QtCore.QDataStream): ...


class QStandardItemModel(PySide2.QtCore.QAbstractItemModel):

    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, rows: int, columns: int, parent: PySide2.QtCore.QObject = ...): ...
    def appendColumn(self, items: typing.List[PySide2.QtGui.QStandardItem]): ...
    @typing.overload
    def appendRow(self, item: PySide2.QtGui.QStandardItem): ...
    @typing.overload
    def appendRow(self, items: typing.List[PySide2.QtGui.QStandardItem]): ...
    def clear(self): ...
    def clearItemData(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def columnCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def data(self, index: PySide2.QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def dropMimeData(self, data: PySide2.QtCore.QMimeData, action: PySide2.QtCore.Qt.DropAction, row: int, column: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def findItems(self, text: str, flags: PySide2.QtCore.Qt.MatchFlags = ..., column: int = ...) -> typing.List[PySide2.QtGui.QStandardItem]: ...
    def flags(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.Qt.ItemFlags: ...
    def hasChildren(self, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def headerData(self, section: int, orientation: PySide2.QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def horizontalHeaderItem(self, column: int) -> PySide2.QtGui.QStandardItem: ...
    def index(self, row: int, column: int, parent: PySide2.QtCore.QModelIndex = ...) -> PySide2.QtCore.QModelIndex: ...
    def indexFromItem(self, item: PySide2.QtGui.QStandardItem) -> PySide2.QtCore.QModelIndex: ...
    @typing.overload
    def insertColumn(self, column: int, items: typing.List[PySide2.QtGui.QStandardItem]): ...
    @typing.overload
    def insertColumn(self, column: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def insertColumns(self, column: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    @typing.overload
    def insertRow(self, row: int, item: PySide2.QtGui.QStandardItem): ...
    @typing.overload
    def insertRow(self, row: int, items: typing.List[PySide2.QtGui.QStandardItem]): ...
    @typing.overload
    def insertRow(self, row: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def insertRows(self, row: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def invisibleRootItem(self) -> PySide2.QtGui.QStandardItem: ...
    def item(self, row: int, column: int = ...) -> PySide2.QtGui.QStandardItem: ...
    def itemData(self, index: PySide2.QtCore.QModelIndex) -> typing.Dict: ...
    def itemFromIndex(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtGui.QStandardItem: ...
    def itemPrototype(self) -> PySide2.QtGui.QStandardItem: ...
    def mimeData(self, indexes: typing.List[int]) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    @typing.overload
    def parent(self) -> PySide2.QtCore.QObject: ...
    @typing.overload
    def parent(self, child: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def removeColumns(self, column: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def removeRows(self, row: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def rowCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def setColumnCount(self, columns: int): ...
    def setData(self, index: PySide2.QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def setHeaderData(self, section: int, orientation: PySide2.QtCore.Qt.Orientation, value: typing.Any, role: int = ...) -> bool: ...
    def setHorizontalHeaderItem(self, column: int, item: PySide2.QtGui.QStandardItem): ...
    def setHorizontalHeaderLabels(self, labels: typing.List[str]): ...
    @typing.overload
    def setItem(self, row: int, column: int, item: PySide2.QtGui.QStandardItem): ...
    @typing.overload
    def setItem(self, row: int, item: PySide2.QtGui.QStandardItem): ...
    def setItemData(self, index: PySide2.QtCore.QModelIndex, roles: typing.Dict) -> bool: ...
    def setItemPrototype(self, item: PySide2.QtGui.QStandardItem): ...
    def setItemRoleNames(self, roleNames: typing.Dict): ...
    def setRowCount(self, rows: int): ...
    def setSortRole(self, role: int): ...
    def setVerticalHeaderItem(self, row: int, item: PySide2.QtGui.QStandardItem): ...
    def setVerticalHeaderLabels(self, labels: typing.List[str]): ...
    def sibling(self, row: int, column: int, idx: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def sort(self, column: int, order: PySide2.QtCore.Qt.SortOrder = ...): ...
    def sortRole(self) -> int: ...
    def supportedDropActions(self) -> PySide2.QtCore.Qt.DropActions: ...
    def takeColumn(self, column: int) -> typing.List[PySide2.QtGui.QStandardItem]: ...
    def takeHorizontalHeaderItem(self, column: int) -> PySide2.QtGui.QStandardItem: ...
    def takeItem(self, row: int, column: int = ...) -> PySide2.QtGui.QStandardItem: ...
    def takeRow(self, row: int) -> typing.List[PySide2.QtGui.QStandardItem]: ...
    def takeVerticalHeaderItem(self, row: int) -> PySide2.QtGui.QStandardItem: ...
    def verticalHeaderItem(self, row: int) -> PySide2.QtGui.QStandardItem: ...


class QStaticText(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QStaticText): ...
    @typing.overload
    def __init__(self, text: str): ...
    def __copy__(self): ...
    def performanceHint(self) -> PySide2.QtGui.QStaticText.PerformanceHint: ...
    def prepare(self, matrix: PySide2.QtGui.QTransform = ..., font: PySide2.QtGui.QFont = ...): ...
    def setPerformanceHint(self, performanceHint: PySide2.QtGui.QStaticText.PerformanceHint): ...
    def setText(self, text: str): ...
    def setTextFormat(self, textFormat: PySide2.QtCore.Qt.TextFormat): ...
    def setTextOption(self, textOption: PySide2.QtGui.QTextOption): ...
    def setTextWidth(self, textWidth: float): ...
    def size(self) -> PySide2.QtCore.QSizeF: ...
    def swap(self, other: PySide2.QtGui.QStaticText): ...
    def text(self) -> str: ...
    def textFormat(self) -> PySide2.QtCore.Qt.TextFormat: ...
    def textOption(self) -> PySide2.QtGui.QTextOption: ...
    def textWidth(self) -> float: ...


class QStatusTipEvent(PySide2.QtCore.QEvent):

    def __init__(self, tip: str): ...
    def tip(self) -> str: ...


class QStyleHints(PySide2.QtCore.QObject):

    def cursorFlashTime(self) -> int: ...
    def fontSmoothingGamma(self) -> float: ...
    def keyboardAutoRepeatRate(self) -> int: ...
    def keyboardInputInterval(self) -> int: ...
    def mouseDoubleClickInterval(self) -> int: ...
    def mousePressAndHoldInterval(self) -> int: ...
    def mouseQuickSelectionThreshold(self) -> int: ...
    def passwordMaskCharacter(self) -> typing.Char: ...
    def passwordMaskDelay(self) -> int: ...
    def setCursorFlashTime(self, cursorFlashTime: int): ...
    def setFocusOnTouchRelease(self) -> bool: ...
    def setKeyboardInputInterval(self, keyboardInputInterval: int): ...
    def setMouseDoubleClickInterval(self, mouseDoubleClickInterval: int): ...
    def setMousePressAndHoldInterval(self, mousePressAndHoldInterval: int): ...
    def setMouseQuickSelectionThreshold(self, threshold: int): ...
    def setStartDragDistance(self, startDragDistance: int): ...
    def setStartDragTime(self, startDragTime: int): ...
    def setTabFocusBehavior(self, tabFocusBehavior: PySide2.QtCore.Qt.TabFocusBehavior): ...
    def setUseHoverEffects(self, useHoverEffects: bool): ...
    def setWheelScrollLines(self, scrollLines: int): ...
    def showIsFullScreen(self) -> bool: ...
    def showIsMaximized(self) -> bool: ...
    def showShortcutsInContextMenus(self) -> bool: ...
    def singleClickActivation(self) -> bool: ...
    def startDragDistance(self) -> int: ...
    def startDragTime(self) -> int: ...
    def startDragVelocity(self) -> int: ...
    def tabFocusBehavior(self) -> PySide2.QtCore.Qt.TabFocusBehavior: ...
    def useHoverEffects(self) -> bool: ...
    def useRtlExtensions(self) -> bool: ...
    def wheelScrollLines(self) -> int: ...


class QSurface(Shiboken.Object):

    def __init__(self, type: PySide2.QtGui.QSurface.SurfaceClass): ...
    def format(self) -> PySide2.QtGui.QSurfaceFormat: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def supportsOpenGL(self) -> bool: ...
    def surfaceClass(self) -> PySide2.QtGui.QSurface.SurfaceClass: ...
    def surfaceHandle(self) -> int: ...
    def surfaceType(self) -> PySide2.QtGui.QSurface.SurfaceType: ...


class QSurfaceFormat(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, options: PySide2.QtGui.QSurfaceFormat.FormatOptions): ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QSurfaceFormat): ...
    def __copy__(self): ...
    def alphaBufferSize(self) -> int: ...
    def blueBufferSize(self) -> int: ...
    def colorSpace(self) -> PySide2.QtGui.QSurfaceFormat.ColorSpace: ...
    @staticmethod
    def defaultFormat() -> PySide2.QtGui.QSurfaceFormat: ...
    def depthBufferSize(self) -> int: ...
    def greenBufferSize(self) -> int: ...
    def hasAlpha(self) -> bool: ...
    def majorVersion(self) -> int: ...
    def minorVersion(self) -> int: ...
    def options(self) -> PySide2.QtGui.QSurfaceFormat.FormatOptions: ...
    def profile(self) -> PySide2.QtGui.QSurfaceFormat.OpenGLContextProfile: ...
    def redBufferSize(self) -> int: ...
    def renderableType(self) -> PySide2.QtGui.QSurfaceFormat.RenderableType: ...
    def samples(self) -> int: ...
    def setAlphaBufferSize(self, size: int): ...
    def setBlueBufferSize(self, size: int): ...
    def setColorSpace(self, colorSpace: PySide2.QtGui.QSurfaceFormat.ColorSpace): ...
    @staticmethod
    def setDefaultFormat(format: PySide2.QtGui.QSurfaceFormat): ...
    def setDepthBufferSize(self, size: int): ...
    def setGreenBufferSize(self, size: int): ...
    def setMajorVersion(self, majorVersion: int): ...
    def setMinorVersion(self, minorVersion: int): ...
    @typing.overload
    def setOption(self, opt: PySide2.QtGui.QSurfaceFormat.FormatOptions): ...
    @typing.overload
    def setOption(self, option: PySide2.QtGui.QSurfaceFormat.FormatOption, on: bool = ...): ...
    def setOptions(self, options: PySide2.QtGui.QSurfaceFormat.FormatOptions): ...
    def setProfile(self, profile: PySide2.QtGui.QSurfaceFormat.OpenGLContextProfile): ...
    def setRedBufferSize(self, size: int): ...
    def setRenderableType(self, type: PySide2.QtGui.QSurfaceFormat.RenderableType): ...
    def setSamples(self, numSamples: int): ...
    def setStencilBufferSize(self, size: int): ...
    def setStereo(self, enable: bool): ...
    def setSwapBehavior(self, behavior: PySide2.QtGui.QSurfaceFormat.SwapBehavior): ...
    def setSwapInterval(self, interval: int): ...
    def setVersion(self, major: int, minor: int): ...
    def stencilBufferSize(self) -> int: ...
    def stereo(self) -> bool: ...
    def swapBehavior(self) -> PySide2.QtGui.QSurfaceFormat.SwapBehavior: ...
    def swapInterval(self) -> int: ...
    @typing.overload
    def testOption(self, opt: PySide2.QtGui.QSurfaceFormat.FormatOptions) -> bool: ...
    @typing.overload
    def testOption(self, option: PySide2.QtGui.QSurfaceFormat.FormatOption) -> bool: ...
    def version(self) -> typing.Tuple: ...


class QSyntaxHighlighter(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtGui.QTextDocument): ...
    def currentBlock(self) -> PySide2.QtGui.QTextBlock: ...
    def currentBlockState(self) -> int: ...
    def currentBlockUserData(self) -> PySide2.QtGui.QTextBlockUserData: ...
    def document(self) -> PySide2.QtGui.QTextDocument: ...
    def format(self, pos: int) -> PySide2.QtGui.QTextCharFormat: ...
    def highlightBlock(self, text: str): ...
    def previousBlockState(self) -> int: ...
    def rehighlight(self): ...
    def rehighlightBlock(self, block: PySide2.QtGui.QTextBlock): ...
    def setCurrentBlockState(self, newState: int): ...
    def setCurrentBlockUserData(self, data: PySide2.QtGui.QTextBlockUserData): ...
    def setDocument(self, doc: PySide2.QtGui.QTextDocument): ...
    @typing.overload
    def setFormat(self, start: int, count: int, color: PySide2.QtGui.QColor): ...
    @typing.overload
    def setFormat(self, start: int, count: int, font: PySide2.QtGui.QFont): ...
    @typing.overload
    def setFormat(self, start: int, count: int, format: PySide2.QtGui.QTextCharFormat): ...


class QTabletEvent(PySide2.QtGui.QInputEvent):

    @typing.overload
    def __init__(self, t: PySide2.QtCore.QEvent.Type, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, device: int, pointerType: int, pressure: float, xTilt: int, yTilt: int, tangentialPressure: float, rotation: float, z: int, keyState: PySide2.QtCore.Qt.KeyboardModifiers, uniqueID: int): ...
    @typing.overload
    def __init__(self, t: PySide2.QtCore.QEvent.Type, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, device: int, pointerType: int, pressure: float, xTilt: int, yTilt: int, tangentialPressure: float, rotation: float, z: int, keyState: PySide2.QtCore.Qt.KeyboardModifiers, uniqueID: int, button: PySide2.QtCore.Qt.MouseButton, buttons: PySide2.QtCore.Qt.MouseButtons): ...
    def button(self) -> PySide2.QtCore.Qt.MouseButton: ...
    def buttons(self) -> PySide2.QtCore.Qt.MouseButtons: ...
    def device(self) -> PySide2.QtGui.QTabletEvent.TabletDevice: ...
    def globalPos(self) -> PySide2.QtCore.QPoint: ...
    def globalPosF(self) -> PySide2.QtCore.QPointF: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def hiResGlobalX(self) -> float: ...
    def hiResGlobalY(self) -> float: ...
    def pointerType(self) -> PySide2.QtGui.QTabletEvent.PointerType: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def posF(self) -> PySide2.QtCore.QPointF: ...
    def pressure(self) -> float: ...
    def rotation(self) -> float: ...
    def tangentialPressure(self) -> float: ...
    def uniqueId(self) -> int: ...
    def x(self) -> int: ...
    def xTilt(self) -> int: ...
    def y(self) -> int: ...
    def yTilt(self) -> int: ...
    def z(self) -> int: ...


class QTextBlock(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, o: PySide2.QtGui.QTextBlock): ...
    def __copy__(self): ...
    def __iter__(self) -> object: ...
    def begin(self) -> PySide2.QtGui.QTextBlock.iterator: ...
    def blockFormat(self) -> PySide2.QtGui.QTextBlockFormat: ...
    def blockFormatIndex(self) -> int: ...
    def blockNumber(self) -> int: ...
    def charFormat(self) -> PySide2.QtGui.QTextCharFormat: ...
    def charFormatIndex(self) -> int: ...
    def clearLayout(self): ...
    def contains(self, position: int) -> bool: ...
    def document(self) -> PySide2.QtGui.QTextDocument: ...
    def end(self) -> PySide2.QtGui.QTextBlock.iterator: ...
    def firstLineNumber(self) -> int: ...
    def fragmentIndex(self) -> int: ...
    def isValid(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def layout(self) -> PySide2.QtGui.QTextLayout: ...
    def length(self) -> int: ...
    def lineCount(self) -> int: ...
    def next(self) -> PySide2.QtGui.QTextBlock: ...
    def position(self) -> int: ...
    def previous(self) -> PySide2.QtGui.QTextBlock: ...
    def revision(self) -> int: ...
    def setLineCount(self, count: int): ...
    def setRevision(self, rev: int): ...
    def setUserData(self, data: PySide2.QtGui.QTextBlockUserData): ...
    def setUserState(self, state: int): ...
    def setVisible(self, visible: bool): ...
    def text(self) -> str: ...
    def textDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def textFormats(self) -> typing.List[PySide2.QtGui.QTextLayout.FormatRange]: ...
    def textList(self) -> PySide2.QtGui.QTextList: ...
    def userData(self) -> PySide2.QtGui.QTextBlockUserData: ...
    def userState(self) -> int: ...

    class iterator(Shiboken.Object):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, o: PySide2.QtGui.QTextBlock.iterator): ...
        def __copy__(self): ...
        def __iadd__(self, arg__1: int) -> PySide2.QtGui.QTextBlock.iterator: ...
        def __isub__(self, arg__1: int) -> PySide2.QtGui.QTextBlock.iterator: ...
        def __iter__(self) -> object: ...
        def __next__(self) -> object: ...
        def atEnd(self) -> bool: ...
        def fragment(self) -> PySide2.QtGui.QTextFragment: ...


class QTextBlockFormat(PySide2.QtGui.QTextFormat):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QTextBlockFormat: PySide2.QtGui.QTextBlockFormat): ...
    @typing.overload
    def __init__(self, fmt: PySide2.QtGui.QTextFormat): ...
    def __copy__(self): ...
    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def bottomMargin(self) -> float: ...
    def headingLevel(self) -> int: ...
    def indent(self) -> int: ...
    def isValid(self) -> bool: ...
    def leftMargin(self) -> float: ...
    @typing.overload
    def lineHeight(self) -> float: ...
    @typing.overload
    def lineHeight(self, scriptLineHeight: float, scaling: float) -> float: ...
    def lineHeightType(self) -> int: ...
    def nonBreakableLines(self) -> bool: ...
    def pageBreakPolicy(self) -> PySide2.QtGui.QTextFormat.PageBreakFlags: ...
    def rightMargin(self) -> float: ...
    def setAlignment(self, alignment: PySide2.QtCore.Qt.Alignment): ...
    def setBottomMargin(self, margin: float): ...
    def setHeadingLevel(self, alevel: int): ...
    def setIndent(self, indent: int): ...
    def setLeftMargin(self, margin: float): ...
    def setLineHeight(self, height: float, heightType: int): ...
    def setNonBreakableLines(self, b: bool): ...
    def setPageBreakPolicy(self, flags: PySide2.QtGui.QTextFormat.PageBreakFlags): ...
    def setRightMargin(self, margin: float): ...
    def setTabPositions(self, tabs: typing.List[PySide2.QtGui.QTextOption.Tab]): ...
    def setTextIndent(self, aindent: float): ...
    def setTopMargin(self, margin: float): ...
    def tabPositions(self) -> typing.List[PySide2.QtGui.QTextOption.Tab]: ...
    def textIndent(self) -> float: ...
    def topMargin(self) -> float: ...


class QTextBlockGroup(PySide2.QtGui.QTextObject):

    def __init__(self, doc: PySide2.QtGui.QTextDocument): ...
    def blockFormatChanged(self, block: PySide2.QtGui.QTextBlock): ...
    def blockInserted(self, block: PySide2.QtGui.QTextBlock): ...
    def blockList(self) -> typing.List[PySide2.QtGui.QTextBlock]: ...
    def blockRemoved(self, block: PySide2.QtGui.QTextBlock): ...


class QTextBlockUserData(Shiboken.Object):

    def __init__(self): ...


class QTextCharFormat(PySide2.QtGui.QTextFormat):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QTextCharFormat: PySide2.QtGui.QTextCharFormat): ...
    @typing.overload
    def __init__(self, fmt: PySide2.QtGui.QTextFormat): ...
    def __copy__(self): ...
    def anchorHref(self) -> str: ...
    def anchorName(self) -> str: ...
    def anchorNames(self) -> typing.List[str]: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def fontCapitalization(self) -> PySide2.QtGui.QFont.Capitalization: ...
    def fontFamily(self) -> str: ...
    def fontFixedPitch(self) -> bool: ...
    def fontHintingPreference(self) -> PySide2.QtGui.QFont.HintingPreference: ...
    def fontItalic(self) -> bool: ...
    def fontKerning(self) -> bool: ...
    def fontLetterSpacing(self) -> float: ...
    def fontLetterSpacingType(self) -> PySide2.QtGui.QFont.SpacingType: ...
    def fontOverline(self) -> bool: ...
    def fontPointSize(self) -> float: ...
    def fontStretch(self) -> int: ...
    def fontStrikeOut(self) -> bool: ...
    def fontStyleHint(self) -> PySide2.QtGui.QFont.StyleHint: ...
    def fontStyleStrategy(self) -> PySide2.QtGui.QFont.StyleStrategy: ...
    def fontUnderline(self) -> bool: ...
    def fontWeight(self) -> int: ...
    def fontWordSpacing(self) -> float: ...
    def isAnchor(self) -> bool: ...
    def isValid(self) -> bool: ...
    def setAnchor(self, anchor: bool): ...
    def setAnchorHref(self, value: str): ...
    def setAnchorName(self, name: str): ...
    def setAnchorNames(self, names: typing.List[str]): ...
    @typing.overload
    def setFont(self, font: PySide2.QtGui.QFont): ...
    @typing.overload
    def setFont(self, font: PySide2.QtGui.QFont, behavior: PySide2.QtGui.QTextCharFormat.FontPropertiesInheritanceBehavior): ...
    def setFontCapitalization(self, capitalization: PySide2.QtGui.QFont.Capitalization): ...
    def setFontFamily(self, family: str): ...
    def setFontFixedPitch(self, fixedPitch: bool): ...
    def setFontHintingPreference(self, hintingPreference: PySide2.QtGui.QFont.HintingPreference): ...
    def setFontItalic(self, italic: bool): ...
    def setFontKerning(self, enable: bool): ...
    def setFontLetterSpacing(self, spacing: float): ...
    def setFontLetterSpacingType(self, letterSpacingType: PySide2.QtGui.QFont.SpacingType): ...
    def setFontOverline(self, overline: bool): ...
    def setFontPointSize(self, size: float): ...
    def setFontStretch(self, factor: int): ...
    def setFontStrikeOut(self, strikeOut: bool): ...
    def setFontStyleHint(self, hint: PySide2.QtGui.QFont.StyleHint, strategy: PySide2.QtGui.QFont.StyleStrategy = ...): ...
    def setFontStyleStrategy(self, strategy: PySide2.QtGui.QFont.StyleStrategy): ...
    def setFontUnderline(self, underline: bool): ...
    def setFontWeight(self, weight: int): ...
    def setFontWordSpacing(self, spacing: float): ...
    def setTableCellColumnSpan(self, tableCellColumnSpan: int): ...
    def setTableCellRowSpan(self, tableCellRowSpan: int): ...
    def setTextOutline(self, pen: PySide2.QtGui.QPen): ...
    def setToolTip(self, tip: str): ...
    def setUnderlineColor(self, color: PySide2.QtGui.QColor): ...
    def setUnderlineStyle(self, style: PySide2.QtGui.QTextCharFormat.UnderlineStyle): ...
    def setVerticalAlignment(self, alignment: PySide2.QtGui.QTextCharFormat.VerticalAlignment): ...
    def tableCellColumnSpan(self) -> int: ...
    def tableCellRowSpan(self) -> int: ...
    def textOutline(self) -> PySide2.QtGui.QPen: ...
    def toolTip(self) -> str: ...
    def underlineColor(self) -> PySide2.QtGui.QColor: ...
    def underlineStyle(self) -> PySide2.QtGui.QTextCharFormat.UnderlineStyle: ...
    def verticalAlignment(self) -> PySide2.QtGui.QTextCharFormat.VerticalAlignment: ...


class QTextCursor(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, block: PySide2.QtGui.QTextBlock): ...
    @typing.overload
    def __init__(self, cursor: PySide2.QtGui.QTextCursor): ...
    @typing.overload
    def __init__(self, document: PySide2.QtGui.QTextDocument): ...
    @typing.overload
    def __init__(self, frame: PySide2.QtGui.QTextFrame): ...
    def __copy__(self): ...
    def anchor(self) -> int: ...
    def atBlockEnd(self) -> bool: ...
    def atBlockStart(self) -> bool: ...
    def atEnd(self) -> bool: ...
    def atStart(self) -> bool: ...
    def beginEditBlock(self): ...
    def block(self) -> PySide2.QtGui.QTextBlock: ...
    def blockCharFormat(self) -> PySide2.QtGui.QTextCharFormat: ...
    def blockFormat(self) -> PySide2.QtGui.QTextBlockFormat: ...
    def blockNumber(self) -> int: ...
    def charFormat(self) -> PySide2.QtGui.QTextCharFormat: ...
    def clearSelection(self): ...
    def columnNumber(self) -> int: ...
    @typing.overload
    def createList(self, format: PySide2.QtGui.QTextListFormat) -> PySide2.QtGui.QTextList: ...
    @typing.overload
    def createList(self, style: PySide2.QtGui.QTextListFormat.Style) -> PySide2.QtGui.QTextList: ...
    def currentFrame(self) -> PySide2.QtGui.QTextFrame: ...
    def currentList(self) -> PySide2.QtGui.QTextList: ...
    def currentTable(self) -> PySide2.QtGui.QTextTable: ...
    def deleteChar(self): ...
    def deletePreviousChar(self): ...
    def document(self) -> PySide2.QtGui.QTextDocument: ...
    def endEditBlock(self): ...
    def hasComplexSelection(self) -> bool: ...
    def hasSelection(self) -> bool: ...
    @typing.overload
    def insertBlock(self): ...
    @typing.overload
    def insertBlock(self, format: PySide2.QtGui.QTextBlockFormat): ...
    @typing.overload
    def insertBlock(self, format: PySide2.QtGui.QTextBlockFormat, charFormat: PySide2.QtGui.QTextCharFormat): ...
    def insertFragment(self, fragment: PySide2.QtGui.QTextDocumentFragment): ...
    def insertFrame(self, format: PySide2.QtGui.QTextFrameFormat) -> PySide2.QtGui.QTextFrame: ...
    def insertHtml(self, html: str): ...
    @typing.overload
    def insertImage(self, format: PySide2.QtGui.QTextImageFormat): ...
    @typing.overload
    def insertImage(self, format: PySide2.QtGui.QTextImageFormat, alignment: PySide2.QtGui.QTextFrameFormat.Position): ...
    @typing.overload
    def insertImage(self, image: PySide2.QtGui.QImage, name: str = ...): ...
    @typing.overload
    def insertImage(self, name: str): ...
    @typing.overload
    def insertList(self, format: PySide2.QtGui.QTextListFormat) -> PySide2.QtGui.QTextList: ...
    @typing.overload
    def insertList(self, style: PySide2.QtGui.QTextListFormat.Style) -> PySide2.QtGui.QTextList: ...
    @typing.overload
    def insertTable(self, rows: int, cols: int) -> PySide2.QtGui.QTextTable: ...
    @typing.overload
    def insertTable(self, rows: int, cols: int, format: PySide2.QtGui.QTextTableFormat) -> PySide2.QtGui.QTextTable: ...
    @typing.overload
    def insertText(self, text: str): ...
    @typing.overload
    def insertText(self, text: str, format: PySide2.QtGui.QTextCharFormat): ...
    def isCopyOf(self, other: PySide2.QtGui.QTextCursor) -> bool: ...
    def isNull(self) -> bool: ...
    def joinPreviousEditBlock(self): ...
    def keepPositionOnInsert(self) -> bool: ...
    def mergeBlockCharFormat(self, modifier: PySide2.QtGui.QTextCharFormat): ...
    def mergeBlockFormat(self, modifier: PySide2.QtGui.QTextBlockFormat): ...
    def mergeCharFormat(self, modifier: PySide2.QtGui.QTextCharFormat): ...
    def movePosition(self, op: PySide2.QtGui.QTextCursor.MoveOperation, arg__2: PySide2.QtGui.QTextCursor.MoveMode = ..., n: int = ...) -> bool: ...
    def position(self) -> int: ...
    def positionInBlock(self) -> int: ...
    def removeSelectedText(self): ...
    def select(self, selection: PySide2.QtGui.QTextCursor.SelectionType): ...
    def selectedTableCells(self, firstRow: int, numRows: int, firstColumn: int, numColumns: int): ...
    def selectedText(self) -> str: ...
    def selection(self) -> PySide2.QtGui.QTextDocumentFragment: ...
    def selectionEnd(self) -> int: ...
    def selectionStart(self) -> int: ...
    def setBlockCharFormat(self, format: PySide2.QtGui.QTextCharFormat): ...
    def setBlockFormat(self, format: PySide2.QtGui.QTextBlockFormat): ...
    def setCharFormat(self, format: PySide2.QtGui.QTextCharFormat): ...
    def setKeepPositionOnInsert(self, b: bool): ...
    def setPosition(self, pos: int, mode: PySide2.QtGui.QTextCursor.MoveMode = ...): ...
    def setVerticalMovementX(self, x: int): ...
    def setVisualNavigation(self, b: bool): ...
    def swap(self, other: PySide2.QtGui.QTextCursor): ...
    def verticalMovementX(self) -> int: ...
    def visualNavigation(self) -> bool: ...


class QTextDocument(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, text: str, parent: PySide2.QtCore.QObject = ...): ...
    def addResource(self, type: int, name: PySide2.QtCore.QUrl, resource: typing.Any): ...
    def adjustSize(self): ...
    def allFormats(self) -> typing.List[PySide2.QtGui.QTextFormat]: ...
    def availableRedoSteps(self) -> int: ...
    def availableUndoSteps(self) -> int: ...
    def baseUrl(self) -> PySide2.QtCore.QUrl: ...
    def begin(self) -> PySide2.QtGui.QTextBlock: ...
    def blockCount(self) -> int: ...
    def characterAt(self, pos: int) -> typing.Char: ...
    def characterCount(self) -> int: ...
    def clear(self): ...
    def clearUndoRedoStacks(self, historyToClear: PySide2.QtGui.QTextDocument.Stacks = ...): ...
    def clone(self, parent: PySide2.QtCore.QObject = ...) -> PySide2.QtGui.QTextDocument: ...
    def createObject(self, f: PySide2.QtGui.QTextFormat) -> PySide2.QtGui.QTextObject: ...
    def defaultCursorMoveStyle(self) -> PySide2.QtCore.Qt.CursorMoveStyle: ...
    def defaultFont(self) -> PySide2.QtGui.QFont: ...
    def defaultStyleSheet(self) -> str: ...
    def defaultTextOption(self) -> PySide2.QtGui.QTextOption: ...
    def documentLayout(self) -> PySide2.QtGui.QAbstractTextDocumentLayout: ...
    def documentMargin(self) -> float: ...
    def drawContents(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRectF = ...): ...
    def end(self) -> PySide2.QtGui.QTextBlock: ...
    @typing.overload
    def find(self, expr: PySide2.QtCore.QRegExp, cursor: PySide2.QtGui.QTextCursor, options: PySide2.QtGui.QTextDocument.FindFlags = ...) -> PySide2.QtGui.QTextCursor: ...
    @typing.overload
    def find(self, expr: PySide2.QtCore.QRegExp, from_: int = ..., options: PySide2.QtGui.QTextDocument.FindFlags = ...) -> PySide2.QtGui.QTextCursor: ...
    @typing.overload
    def find(self, expr: PySide2.QtCore.QRegularExpression, cursor: PySide2.QtGui.QTextCursor, options: PySide2.QtGui.QTextDocument.FindFlags = ...) -> PySide2.QtGui.QTextCursor: ...
    @typing.overload
    def find(self, expr: PySide2.QtCore.QRegularExpression, from_: int = ..., options: PySide2.QtGui.QTextDocument.FindFlags = ...) -> PySide2.QtGui.QTextCursor: ...
    @typing.overload
    def find(self, subString: str, cursor: PySide2.QtGui.QTextCursor, options: PySide2.QtGui.QTextDocument.FindFlags = ...) -> PySide2.QtGui.QTextCursor: ...
    @typing.overload
    def find(self, subString: str, from_: int = ..., options: PySide2.QtGui.QTextDocument.FindFlags = ...) -> PySide2.QtGui.QTextCursor: ...
    def findBlock(self, pos: int) -> PySide2.QtGui.QTextBlock: ...
    def findBlockByLineNumber(self, blockNumber: int) -> PySide2.QtGui.QTextBlock: ...
    def findBlockByNumber(self, blockNumber: int) -> PySide2.QtGui.QTextBlock: ...
    def firstBlock(self) -> PySide2.QtGui.QTextBlock: ...
    def frameAt(self, pos: int) -> PySide2.QtGui.QTextFrame: ...
    def idealWidth(self) -> float: ...
    def indentWidth(self) -> float: ...
    def isEmpty(self) -> bool: ...
    def isModified(self) -> bool: ...
    def isRedoAvailable(self) -> bool: ...
    def isUndoAvailable(self) -> bool: ...
    def isUndoRedoEnabled(self) -> bool: ...
    def lastBlock(self) -> PySide2.QtGui.QTextBlock: ...
    def lineCount(self) -> int: ...
    def loadResource(self, type: int, name: PySide2.QtCore.QUrl) -> typing.Any: ...
    def markContentsDirty(self, from_: int, length: int): ...
    def maximumBlockCount(self) -> int: ...
    def metaInformation(self, info: PySide2.QtGui.QTextDocument.MetaInformation) -> str: ...
    def object(self, objectIndex: int) -> PySide2.QtGui.QTextObject: ...
    def objectForFormat(self, arg__1: PySide2.QtGui.QTextFormat) -> PySide2.QtGui.QTextObject: ...
    def pageCount(self) -> int: ...
    def pageSize(self) -> PySide2.QtCore.QSizeF: ...
    def print_(self, printer: PySide2.QtGui.QPagedPaintDevice): ...
    @typing.overload
    def redo(self): ...
    @typing.overload
    def redo(self, cursor: PySide2.QtGui.QTextCursor): ...
    def resource(self, type: int, name: PySide2.QtCore.QUrl) -> typing.Any: ...
    def revision(self) -> int: ...
    def rootFrame(self) -> PySide2.QtGui.QTextFrame: ...
    def setBaseUrl(self, url: PySide2.QtCore.QUrl): ...
    def setDefaultCursorMoveStyle(self, style: PySide2.QtCore.Qt.CursorMoveStyle): ...
    def setDefaultFont(self, font: PySide2.QtGui.QFont): ...
    def setDefaultStyleSheet(self, sheet: str): ...
    def setDefaultTextOption(self, option: PySide2.QtGui.QTextOption): ...
    def setDocumentLayout(self, layout: PySide2.QtGui.QAbstractTextDocumentLayout): ...
    def setDocumentMargin(self, margin: float): ...
    def setHtml(self, html: str): ...
    def setIndentWidth(self, width: float): ...
    def setMaximumBlockCount(self, maximum: int): ...
    def setMetaInformation(self, info: PySide2.QtGui.QTextDocument.MetaInformation, arg__2: str): ...
    def setModified(self, m: bool = ...): ...
    def setPageSize(self, size: PySide2.QtCore.QSizeF): ...
    def setPlainText(self, text: str): ...
    def setTextWidth(self, width: float): ...
    def setUndoRedoEnabled(self, enable: bool): ...
    def setUseDesignMetrics(self, b: bool): ...
    def size(self) -> PySide2.QtCore.QSizeF: ...
    def textWidth(self) -> float: ...
    def toHtml(self, encoding: PySide2.QtCore.QByteArray = ...) -> str: ...
    def toPlainText(self) -> str: ...
    def toRawText(self) -> str: ...
    @typing.overload
    def undo(self): ...
    @typing.overload
    def undo(self, cursor: PySide2.QtGui.QTextCursor): ...
    def useDesignMetrics(self) -> bool: ...


class QTextDocumentFragment(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, document: PySide2.QtGui.QTextDocument): ...
    @typing.overload
    def __init__(self, range: PySide2.QtGui.QTextCursor): ...
    @typing.overload
    def __init__(self, rhs: PySide2.QtGui.QTextDocumentFragment): ...
    def __copy__(self): ...
    @typing.overload
    @staticmethod
    def fromHtml(html: str) -> PySide2.QtGui.QTextDocumentFragment: ...
    @typing.overload
    @staticmethod
    def fromHtml(html: str, resourceProvider: PySide2.QtGui.QTextDocument) -> PySide2.QtGui.QTextDocumentFragment: ...
    @staticmethod
    def fromPlainText(plainText: str) -> PySide2.QtGui.QTextDocumentFragment: ...
    def isEmpty(self) -> bool: ...
    def toHtml(self, encoding: PySide2.QtCore.QByteArray = ...) -> str: ...
    def toPlainText(self) -> str: ...


class QTextDocumentWriter(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice, format: PySide2.QtCore.QByteArray): ...
    @typing.overload
    def __init__(self, fileName: str, format: PySide2.QtCore.QByteArray = ...): ...
    def codec(self) -> PySide2.QtCore.QTextCodec: ...
    def device(self) -> PySide2.QtCore.QIODevice: ...
    def fileName(self) -> str: ...
    def format(self) -> PySide2.QtCore.QByteArray: ...
    def setCodec(self, codec: PySide2.QtCore.QTextCodec): ...
    def setDevice(self, device: PySide2.QtCore.QIODevice): ...
    def setFileName(self, fileName: str): ...
    def setFormat(self, format: PySide2.QtCore.QByteArray): ...
    @staticmethod
    def supportedDocumentFormats() -> typing.List[PySide2.QtCore.QByteArray]: ...
    @typing.overload
    def write(self, document: PySide2.QtGui.QTextDocument) -> bool: ...
    @typing.overload
    def write(self, fragment: PySide2.QtGui.QTextDocumentFragment) -> bool: ...


class QTextFormat(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, rhs: PySide2.QtGui.QTextFormat): ...
    @typing.overload
    def __init__(self, type: int): ...
    def __copy__(self): ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def background(self) -> PySide2.QtGui.QBrush: ...
    def boolProperty(self, propertyId: int) -> bool: ...
    def brushProperty(self, propertyId: int) -> PySide2.QtGui.QBrush: ...
    def clearBackground(self): ...
    def clearForeground(self): ...
    def clearProperty(self, propertyId: int): ...
    def colorProperty(self, propertyId: int) -> PySide2.QtGui.QColor: ...
    def doubleProperty(self, propertyId: int) -> float: ...
    def foreground(self) -> PySide2.QtGui.QBrush: ...
    def hasProperty(self, propertyId: int) -> bool: ...
    def intProperty(self, propertyId: int) -> int: ...
    def isBlockFormat(self) -> bool: ...
    def isCharFormat(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isFrameFormat(self) -> bool: ...
    def isImageFormat(self) -> bool: ...
    def isListFormat(self) -> bool: ...
    def isTableCellFormat(self) -> bool: ...
    def isTableFormat(self) -> bool: ...
    def isValid(self) -> bool: ...
    def layoutDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def lengthProperty(self, propertyId: int) -> PySide2.QtGui.QTextLength: ...
    def lengthVectorProperty(self, propertyId: int) -> typing.List[PySide2.QtGui.QTextLength]: ...
    def merge(self, other: PySide2.QtGui.QTextFormat): ...
    def objectIndex(self) -> int: ...
    def objectType(self) -> int: ...
    def penProperty(self, propertyId: int) -> PySide2.QtGui.QPen: ...
    def properties(self) -> typing.Dict: ...
    def property(self, propertyId: int) -> typing.Any: ...
    def propertyCount(self) -> int: ...
    def setBackground(self, brush: PySide2.QtGui.QBrush): ...
    def setForeground(self, brush: PySide2.QtGui.QBrush): ...
    def setLayoutDirection(self, direction: PySide2.QtCore.Qt.LayoutDirection): ...
    def setObjectIndex(self, object: int): ...
    def setObjectType(self, type: int): ...
    @typing.overload
    def setProperty(self, propertyId: int, lengths: typing.List[PySide2.QtGui.QTextLength]): ...
    @typing.overload
    def setProperty(self, propertyId: int, value: typing.Any): ...
    def stringProperty(self, propertyId: int) -> str: ...
    def swap(self, other: PySide2.QtGui.QTextFormat): ...
    def toBlockFormat(self) -> PySide2.QtGui.QTextBlockFormat: ...
    def toCharFormat(self) -> PySide2.QtGui.QTextCharFormat: ...
    def toFrameFormat(self) -> PySide2.QtGui.QTextFrameFormat: ...
    def toImageFormat(self) -> PySide2.QtGui.QTextImageFormat: ...
    def toListFormat(self) -> PySide2.QtGui.QTextListFormat: ...
    def toTableCellFormat(self) -> PySide2.QtGui.QTextTableCellFormat: ...
    def toTableFormat(self) -> PySide2.QtGui.QTextTableFormat: ...
    def type(self) -> int: ...


class QTextFragment(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, o: PySide2.QtGui.QTextFragment): ...
    def __copy__(self): ...
    def charFormat(self) -> PySide2.QtGui.QTextCharFormat: ...
    def charFormatIndex(self) -> int: ...
    def contains(self, position: int) -> bool: ...
    def isValid(self) -> bool: ...
    def length(self) -> int: ...
    def position(self) -> int: ...
    def text(self) -> str: ...


class QTextFrame(PySide2.QtGui.QTextObject):

    def __init__(self, doc: PySide2.QtGui.QTextDocument): ...
    def __iter__(self) -> object: ...
    def begin(self) -> PySide2.QtGui.QTextFrame.iterator: ...
    def childFrames(self) -> typing.List[PySide2.QtGui.QTextFrame]: ...
    def end(self) -> PySide2.QtGui.QTextFrame.iterator: ...
    def firstCursorPosition(self) -> PySide2.QtGui.QTextCursor: ...
    def firstPosition(self) -> int: ...
    def frameFormat(self) -> PySide2.QtGui.QTextFrameFormat: ...
    def lastCursorPosition(self) -> PySide2.QtGui.QTextCursor: ...
    def lastPosition(self) -> int: ...
    def parentFrame(self) -> PySide2.QtGui.QTextFrame: ...
    def setFrameFormat(self, format: PySide2.QtGui.QTextFrameFormat): ...

    class iterator(Shiboken.Object):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, o: PySide2.QtGui.QTextFrame.iterator): ...
        def __copy__(self): ...
        def __iadd__(self, arg__1: int) -> PySide2.QtGui.QTextFrame.iterator: ...
        def __isub__(self, arg__1: int) -> PySide2.QtGui.QTextFrame.iterator: ...
        def __iter__(self) -> object: ...
        def __next__(self) -> object: ...
        def atEnd(self) -> bool: ...
        def currentBlock(self) -> PySide2.QtGui.QTextBlock: ...
        def currentFrame(self) -> PySide2.QtGui.QTextFrame: ...
        def parentFrame(self) -> PySide2.QtGui.QTextFrame: ...


class QTextFrameFormat(PySide2.QtGui.QTextFormat):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QTextFrameFormat: PySide2.QtGui.QTextFrameFormat): ...
    @typing.overload
    def __init__(self, fmt: PySide2.QtGui.QTextFormat): ...
    def __copy__(self): ...
    def border(self) -> float: ...
    def borderBrush(self) -> PySide2.QtGui.QBrush: ...
    def borderStyle(self) -> PySide2.QtGui.QTextFrameFormat.BorderStyle: ...
    def bottomMargin(self) -> float: ...
    def height(self) -> PySide2.QtGui.QTextLength: ...
    def isValid(self) -> bool: ...
    def leftMargin(self) -> float: ...
    def margin(self) -> float: ...
    def padding(self) -> float: ...
    def pageBreakPolicy(self) -> PySide2.QtGui.QTextFormat.PageBreakFlags: ...
    def position(self) -> PySide2.QtGui.QTextFrameFormat.Position: ...
    def rightMargin(self) -> float: ...
    def setBorder(self, border: float): ...
    def setBorderBrush(self, brush: PySide2.QtGui.QBrush): ...
    def setBorderStyle(self, style: PySide2.QtGui.QTextFrameFormat.BorderStyle): ...
    def setBottomMargin(self, margin: float): ...
    @typing.overload
    def setHeight(self, height: PySide2.QtGui.QTextLength): ...
    @typing.overload
    def setHeight(self, height: float): ...
    def setLeftMargin(self, margin: float): ...
    def setMargin(self, margin: float): ...
    def setPadding(self, padding: float): ...
    def setPageBreakPolicy(self, flags: PySide2.QtGui.QTextFormat.PageBreakFlags): ...
    def setPosition(self, f: PySide2.QtGui.QTextFrameFormat.Position): ...
    def setRightMargin(self, margin: float): ...
    def setTopMargin(self, margin: float): ...
    @typing.overload
    def setWidth(self, length: PySide2.QtGui.QTextLength): ...
    @typing.overload
    def setWidth(self, width: float): ...
    def topMargin(self) -> float: ...
    def width(self) -> PySide2.QtGui.QTextLength: ...


class QTextImageFormat(PySide2.QtGui.QTextCharFormat):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QTextImageFormat: PySide2.QtGui.QTextImageFormat): ...
    @typing.overload
    def __init__(self, format: PySide2.QtGui.QTextFormat): ...
    def __copy__(self): ...
    def height(self) -> float: ...
    def isValid(self) -> bool: ...
    def name(self) -> str: ...
    def quality(self) -> int: ...
    def setHeight(self, height: float): ...
    def setName(self, name: str): ...
    def setQuality(self, quality: int = ...): ...
    def setWidth(self, width: float): ...
    def width(self) -> float: ...


class QTextInlineObject(Shiboken.Object):

    def __init__(self): ...
    def __copy__(self): ...
    def ascent(self) -> float: ...
    def descent(self) -> float: ...
    def format(self) -> PySide2.QtGui.QTextFormat: ...
    def formatIndex(self) -> int: ...
    def height(self) -> float: ...
    def isValid(self) -> bool: ...
    def rect(self) -> PySide2.QtCore.QRectF: ...
    def setAscent(self, a: float): ...
    def setDescent(self, d: float): ...
    def setWidth(self, w: float): ...
    def textDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def textPosition(self) -> int: ...
    def width(self) -> float: ...


class QTextItem(Shiboken.Object):

    def __init__(self): ...
    def ascent(self) -> float: ...
    def descent(self) -> float: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def renderFlags(self) -> PySide2.QtGui.QTextItem.RenderFlags: ...
    def text(self) -> str: ...
    def width(self) -> float: ...


class QTextLayout(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, b: PySide2.QtGui.QTextBlock): ...
    @typing.overload
    def __init__(self, text: str): ...
    @typing.overload
    def __init__(self, text: str, font: PySide2.QtGui.QFont, paintdevice: PySide2.QtGui.QPaintDevice = ...): ...
    def additionalFormats(self) -> typing.List[PySide2.QtGui.QTextLayout.FormatRange]: ...
    def beginLayout(self): ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def cacheEnabled(self) -> bool: ...
    def clearAdditionalFormats(self): ...
    def clearFormats(self): ...
    def clearLayout(self): ...
    def createLine(self) -> PySide2.QtGui.QTextLine: ...
    def cursorMoveStyle(self) -> PySide2.QtCore.Qt.CursorMoveStyle: ...
    def draw(self, p: PySide2.QtGui.QPainter, pos: PySide2.QtCore.QPointF, selections: typing.List[PySide2.QtGui.QTextLayout.FormatRange] = ..., clip: PySide2.QtCore.QRectF = ...): ...
    @typing.overload
    def drawCursor(self, p: PySide2.QtGui.QPainter, pos: PySide2.QtCore.QPointF, cursorPosition: int): ...
    @typing.overload
    def drawCursor(self, p: PySide2.QtGui.QPainter, pos: PySide2.QtCore.QPointF, cursorPosition: int, width: int): ...
    def endLayout(self): ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def formats(self) -> typing.List[PySide2.QtGui.QTextLayout.FormatRange]: ...
    def isValidCursorPosition(self, pos: int) -> bool: ...
    def leftCursorPosition(self, oldPos: int) -> int: ...
    def lineAt(self, i: int) -> PySide2.QtGui.QTextLine: ...
    def lineCount(self) -> int: ...
    def lineForTextPosition(self, pos: int) -> PySide2.QtGui.QTextLine: ...
    def maximumWidth(self) -> float: ...
    def minimumWidth(self) -> float: ...
    def nextCursorPosition(self, oldPos: int, mode: PySide2.QtGui.QTextLayout.CursorMode = ...) -> int: ...
    def position(self) -> PySide2.QtCore.QPointF: ...
    def preeditAreaPosition(self) -> int: ...
    def preeditAreaText(self) -> str: ...
    def previousCursorPosition(self, oldPos: int, mode: PySide2.QtGui.QTextLayout.CursorMode = ...) -> int: ...
    def rightCursorPosition(self, oldPos: int) -> int: ...
    def setAdditionalFormats(self, overrides: typing.List[PySide2.QtGui.QTextLayout.FormatRange]): ...
    def setCacheEnabled(self, enable: bool): ...
    def setCursorMoveStyle(self, style: PySide2.QtCore.Qt.CursorMoveStyle): ...
    def setFlags(self, flags: int): ...
    def setFont(self, f: PySide2.QtGui.QFont): ...
    def setFormats(self, overrides: typing.List[PySide2.QtGui.QTextLayout.FormatRange]): ...
    def setPosition(self, p: PySide2.QtCore.QPointF): ...
    def setPreeditArea(self, position: int, text: str): ...
    def setRawFont(self, rawFont: PySide2.QtGui.QRawFont): ...
    def setText(self, string: str): ...
    def setTextOption(self, option: PySide2.QtGui.QTextOption): ...
    def text(self) -> str: ...
    def textOption(self) -> PySide2.QtGui.QTextOption: ...

    class FormatRange(Shiboken.Object):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, FormatRange: PySide2.QtGui.QTextLayout.FormatRange): ...
        def __copy__(self): ...


class QTextLength(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QTextLength: PySide2.QtGui.QTextLength): ...
    @typing.overload
    def __init__(self, type: PySide2.QtGui.QTextLength.Type, value: float): ...
    def __copy__(self): ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def rawValue(self) -> float: ...
    def type(self) -> PySide2.QtGui.QTextLength.Type: ...
    def value(self, maximumLength: float) -> float: ...


class QTextLine(Shiboken.Object):

    def __init__(self): ...
    def __copy__(self): ...
    def ascent(self) -> float: ...
    def cursorToX(self, cursorPos: int, edge: PySide2.QtGui.QTextLine.Edge = ...) -> float: ...
    def descent(self) -> float: ...
    def draw(self, p: PySide2.QtGui.QPainter, point: PySide2.QtCore.QPointF, selection: PySide2.QtGui.QTextLayout.FormatRange = ...): ...
    def height(self) -> float: ...
    def horizontalAdvance(self) -> float: ...
    def isValid(self) -> bool: ...
    def leading(self) -> float: ...
    def leadingIncluded(self) -> bool: ...
    def lineNumber(self) -> int: ...
    def naturalTextRect(self) -> PySide2.QtCore.QRectF: ...
    def naturalTextWidth(self) -> float: ...
    def position(self) -> PySide2.QtCore.QPointF: ...
    def rect(self) -> PySide2.QtCore.QRectF: ...
    def setLeadingIncluded(self, included: bool): ...
    def setLineWidth(self, width: float): ...
    @typing.overload
    def setNumColumns(self, columns: int): ...
    @typing.overload
    def setNumColumns(self, columns: int, alignmentWidth: float): ...
    def setPosition(self, pos: PySide2.QtCore.QPointF): ...
    def textLength(self) -> int: ...
    def textStart(self) -> int: ...
    def width(self) -> float: ...
    def x(self) -> float: ...
    def xToCursor(self, x: float, edge: PySide2.QtGui.QTextLine.CursorPosition = ...) -> int: ...
    def y(self) -> float: ...


class QTextList(PySide2.QtGui.QTextBlockGroup):

    def __init__(self, doc: PySide2.QtGui.QTextDocument): ...
    def add(self, block: PySide2.QtGui.QTextBlock): ...
    def count(self) -> int: ...
    def format(self) -> PySide2.QtGui.QTextListFormat: ...
    def item(self, i: int) -> PySide2.QtGui.QTextBlock: ...
    def itemNumber(self, arg__1: PySide2.QtGui.QTextBlock) -> int: ...
    def itemText(self, arg__1: PySide2.QtGui.QTextBlock) -> str: ...
    def remove(self, arg__1: PySide2.QtGui.QTextBlock): ...
    def removeItem(self, i: int): ...
    @typing.overload
    def setFormat(self, format: PySide2.QtGui.QTextFormat): ...
    @typing.overload
    def setFormat(self, format: PySide2.QtGui.QTextListFormat): ...


class QTextListFormat(PySide2.QtGui.QTextFormat):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QTextListFormat: PySide2.QtGui.QTextListFormat): ...
    @typing.overload
    def __init__(self, fmt: PySide2.QtGui.QTextFormat): ...
    def __copy__(self): ...
    def indent(self) -> int: ...
    def isValid(self) -> bool: ...
    def numberPrefix(self) -> str: ...
    def numberSuffix(self) -> str: ...
    def setIndent(self, indent: int): ...
    def setNumberPrefix(self, numberPrefix: str): ...
    def setNumberSuffix(self, numberSuffix: str): ...
    def setStyle(self, style: PySide2.QtGui.QTextListFormat.Style): ...
    def style(self) -> PySide2.QtGui.QTextListFormat.Style: ...


class QTextObject(PySide2.QtCore.QObject):

    def __init__(self, doc: PySide2.QtGui.QTextDocument): ...
    def document(self) -> PySide2.QtGui.QTextDocument: ...
    def format(self) -> PySide2.QtGui.QTextFormat: ...
    def formatIndex(self) -> int: ...
    def objectIndex(self) -> int: ...
    def setFormat(self, format: PySide2.QtGui.QTextFormat): ...


class QTextObjectInterface(Shiboken.Object):

    def __init__(self): ...
    def drawObject(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRectF, doc: PySide2.QtGui.QTextDocument, posInDocument: int, format: PySide2.QtGui.QTextFormat): ...
    def intrinsicSize(self, doc: PySide2.QtGui.QTextDocument, posInDocument: int, format: PySide2.QtGui.QTextFormat) -> PySide2.QtCore.QSizeF: ...


class QTextOption(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, alignment: PySide2.QtCore.Qt.Alignment): ...
    @typing.overload
    def __init__(self, o: PySide2.QtGui.QTextOption): ...
    def __copy__(self): ...
    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def flags(self) -> PySide2.QtGui.QTextOption.Flags: ...
    def setAlignment(self, alignment: PySide2.QtCore.Qt.Alignment): ...
    def setFlags(self, flags: PySide2.QtGui.QTextOption.Flags): ...
    def setTabArray(self, tabStops: typing.List[float]): ...
    def setTabStop(self, tabStop: float): ...
    def setTabStopDistance(self, tabStopDistance: float): ...
    def setTabs(self, tabStops: typing.List[PySide2.QtGui.QTextOption.Tab]): ...
    def setTextDirection(self, aDirection: PySide2.QtCore.Qt.LayoutDirection): ...
    def setUseDesignMetrics(self, b: bool): ...
    def setWrapMode(self, wrap: PySide2.QtGui.QTextOption.WrapMode): ...
    def tabArray(self) -> typing.List[float]: ...
    def tabStop(self) -> float: ...
    def tabStopDistance(self) -> float: ...
    def tabs(self) -> typing.List[PySide2.QtGui.QTextOption.Tab]: ...
    def textDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def useDesignMetrics(self) -> bool: ...
    def wrapMode(self) -> PySide2.QtGui.QTextOption.WrapMode: ...

    class Tab(Shiboken.Object):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, Tab: PySide2.QtGui.QTextOption.Tab): ...
        @typing.overload
        def __init__(self, pos: float, tabType: PySide2.QtGui.QTextOption.TabType, delim: typing.Char = ...): ...
        def __copy__(self): ...


class QTextTable(PySide2.QtGui.QTextFrame):

    def __init__(self, doc: PySide2.QtGui.QTextDocument): ...
    def appendColumns(self, count: int): ...
    def appendRows(self, count: int): ...
    @typing.overload
    def cellAt(self, c: PySide2.QtGui.QTextCursor) -> PySide2.QtGui.QTextTableCell: ...
    @typing.overload
    def cellAt(self, position: int) -> PySide2.QtGui.QTextTableCell: ...
    @typing.overload
    def cellAt(self, row: int, col: int) -> PySide2.QtGui.QTextTableCell: ...
    def columns(self) -> int: ...
    def format(self) -> PySide2.QtGui.QTextTableFormat: ...
    def insertColumns(self, pos: int, num: int): ...
    def insertRows(self, pos: int, num: int): ...
    @typing.overload
    def mergeCells(self, cursor: PySide2.QtGui.QTextCursor): ...
    @typing.overload
    def mergeCells(self, row: int, col: int, numRows: int, numCols: int): ...
    def removeColumns(self, pos: int, num: int): ...
    def removeRows(self, pos: int, num: int): ...
    def resize(self, rows: int, cols: int): ...
    def rowEnd(self, c: PySide2.QtGui.QTextCursor) -> PySide2.QtGui.QTextCursor: ...
    def rowStart(self, c: PySide2.QtGui.QTextCursor) -> PySide2.QtGui.QTextCursor: ...
    def rows(self) -> int: ...
    @typing.overload
    def setFormat(self, format: PySide2.QtGui.QTextFormat): ...
    @typing.overload
    def setFormat(self, format: PySide2.QtGui.QTextTableFormat): ...
    def splitCell(self, row: int, col: int, numRows: int, numCols: int): ...


class QTextTableCell(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, o: PySide2.QtGui.QTextTableCell): ...
    def __copy__(self): ...
    def begin(self) -> PySide2.QtGui.QTextFrame.iterator: ...
    def column(self) -> int: ...
    def columnSpan(self) -> int: ...
    def end(self) -> PySide2.QtGui.QTextFrame.iterator: ...
    def firstCursorPosition(self) -> PySide2.QtGui.QTextCursor: ...
    def firstPosition(self) -> int: ...
    def format(self) -> PySide2.QtGui.QTextCharFormat: ...
    def isValid(self) -> bool: ...
    def lastCursorPosition(self) -> PySide2.QtGui.QTextCursor: ...
    def lastPosition(self) -> int: ...
    def row(self) -> int: ...
    def rowSpan(self) -> int: ...
    def setFormat(self, format: PySide2.QtGui.QTextCharFormat): ...
    def tableCellFormatIndex(self) -> int: ...


class QTextTableCellFormat(PySide2.QtGui.QTextCharFormat):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QTextTableCellFormat: PySide2.QtGui.QTextTableCellFormat): ...
    @typing.overload
    def __init__(self, fmt: PySide2.QtGui.QTextFormat): ...
    def __copy__(self): ...
    def bottomPadding(self) -> float: ...
    def isValid(self) -> bool: ...
    def leftPadding(self) -> float: ...
    def rightPadding(self) -> float: ...
    def setBottomPadding(self, padding: float): ...
    def setLeftPadding(self, padding: float): ...
    def setPadding(self, padding: float): ...
    def setRightPadding(self, padding: float): ...
    def setTopPadding(self, padding: float): ...
    def topPadding(self) -> float: ...


class QTextTableFormat(PySide2.QtGui.QTextFrameFormat):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QTextTableFormat: PySide2.QtGui.QTextTableFormat): ...
    @typing.overload
    def __init__(self, fmt: PySide2.QtGui.QTextFormat): ...
    def __copy__(self): ...
    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def cellPadding(self) -> float: ...
    def cellSpacing(self) -> float: ...
    def clearColumnWidthConstraints(self): ...
    def columnWidthConstraints(self) -> typing.List[PySide2.QtGui.QTextLength]: ...
    def columns(self) -> int: ...
    def headerRowCount(self) -> int: ...
    def isValid(self) -> bool: ...
    def setAlignment(self, alignment: PySide2.QtCore.Qt.Alignment): ...
    def setCellPadding(self, padding: float): ...
    def setCellSpacing(self, spacing: float): ...
    def setColumnWidthConstraints(self, constraints: typing.List[PySide2.QtGui.QTextLength]): ...
    def setColumns(self, columns: int): ...
    def setHeaderRowCount(self, count: int): ...


class QToolBarChangeEvent(PySide2.QtCore.QEvent):

    def __init__(self, t: bool): ...
    def toggle(self) -> bool: ...


class QTouchDevice(Shiboken.Object):

    def __init__(self): ...
    def capabilities(self) -> PySide2.QtGui.QTouchDevice.Capabilities: ...
    @staticmethod
    def devices() -> typing.List[PySide2.QtGui.QTouchDevice]: ...
    def maximumTouchPoints(self) -> int: ...
    def name(self) -> str: ...
    def setCapabilities(self, caps: PySide2.QtGui.QTouchDevice.Capabilities): ...
    def setMaximumTouchPoints(self, max: int): ...
    def setName(self, name: str): ...
    def setType(self, devType: PySide2.QtGui.QTouchDevice.DeviceType): ...
    def type(self) -> PySide2.QtGui.QTouchDevice.DeviceType: ...


class QTouchEvent(PySide2.QtGui.QInputEvent):

    def __init__(self, eventType: PySide2.QtCore.QEvent.Type, device: PySide2.QtGui.QTouchDevice = ..., modifiers: PySide2.QtCore.Qt.KeyboardModifiers = ..., touchPointStates: PySide2.QtCore.Qt.TouchPointStates = ..., touchPoints: typing.List[PySide2.QtGui.QTouchEvent.TouchPoint] = ...): ...
    def device(self) -> PySide2.QtGui.QTouchDevice: ...
    def setDevice(self, adevice: PySide2.QtGui.QTouchDevice): ...
    def setTarget(self, atarget: PySide2.QtCore.QObject): ...
    def setTouchPointStates(self, aTouchPointStates: PySide2.QtCore.Qt.TouchPointStates): ...
    def setTouchPoints(self, atouchPoints: typing.List[PySide2.QtGui.QTouchEvent.TouchPoint]): ...
    def setWindow(self, awindow: PySide2.QtGui.QWindow): ...
    def target(self) -> PySide2.QtCore.QObject: ...
    def touchPointStates(self) -> PySide2.QtCore.Qt.TouchPointStates: ...
    def touchPoints(self) -> typing.List[PySide2.QtGui.QTouchEvent.TouchPoint]: ...
    def window(self) -> PySide2.QtGui.QWindow: ...

    class TouchPoint(Shiboken.Object):

        @typing.overload
        def __init__(self, id: int = ...): ...
        @typing.overload
        def __init__(self, other: PySide2.QtGui.QTouchEvent.TouchPoint): ...
        def __copy__(self): ...
        def ellipseDiameters(self) -> PySide2.QtCore.QSizeF: ...
        def flags(self) -> PySide2.QtGui.QTouchEvent.TouchPoint.InfoFlags: ...
        def id(self) -> int: ...
        def lastNormalizedPos(self) -> PySide2.QtCore.QPointF: ...
        def lastPos(self) -> PySide2.QtCore.QPointF: ...
        def lastScenePos(self) -> PySide2.QtCore.QPointF: ...
        def lastScreenPos(self) -> PySide2.QtCore.QPointF: ...
        def normalizedPos(self) -> PySide2.QtCore.QPointF: ...
        def pos(self) -> PySide2.QtCore.QPointF: ...
        def pressure(self) -> float: ...
        def rawScreenPositions(self) -> typing.List[PySide2.QtCore.QPointF]: ...
        def rect(self) -> PySide2.QtCore.QRectF: ...
        def rotation(self) -> float: ...
        def scenePos(self) -> PySide2.QtCore.QPointF: ...
        def sceneRect(self) -> PySide2.QtCore.QRectF: ...
        def screenPos(self) -> PySide2.QtCore.QPointF: ...
        def screenRect(self) -> PySide2.QtCore.QRectF: ...
        def setEllipseDiameters(self, dia: PySide2.QtCore.QSizeF): ...
        def setFlags(self, flags: PySide2.QtGui.QTouchEvent.TouchPoint.InfoFlags): ...
        def setId(self, id: int): ...
        def setLastNormalizedPos(self, lastNormalizedPos: PySide2.QtCore.QPointF): ...
        def setLastPos(self, lastPos: PySide2.QtCore.QPointF): ...
        def setLastScenePos(self, lastScenePos: PySide2.QtCore.QPointF): ...
        def setLastScreenPos(self, lastScreenPos: PySide2.QtCore.QPointF): ...
        def setNormalizedPos(self, normalizedPos: PySide2.QtCore.QPointF): ...
        def setPos(self, pos: PySide2.QtCore.QPointF): ...
        def setPressure(self, pressure: float): ...
        def setRawScreenPositions(self, positions: typing.List[PySide2.QtCore.QPointF]): ...
        def setRect(self, rect: PySide2.QtCore.QRectF): ...
        def setRotation(self, angle: float): ...
        def setScenePos(self, scenePos: PySide2.QtCore.QPointF): ...
        def setSceneRect(self, sceneRect: PySide2.QtCore.QRectF): ...
        def setScreenPos(self, screenPos: PySide2.QtCore.QPointF): ...
        def setScreenRect(self, screenRect: PySide2.QtCore.QRectF): ...
        def setStartNormalizedPos(self, startNormalizedPos: PySide2.QtCore.QPointF): ...
        def setStartPos(self, startPos: PySide2.QtCore.QPointF): ...
        def setStartScenePos(self, startScenePos: PySide2.QtCore.QPointF): ...
        def setStartScreenPos(self, startScreenPos: PySide2.QtCore.QPointF): ...
        def setState(self, state: PySide2.QtCore.Qt.TouchPointStates): ...
        def setUniqueId(self, uid: int): ...
        def setVelocity(self, v: PySide2.QtGui.QVector2D): ...
        def startNormalizedPos(self) -> PySide2.QtCore.QPointF: ...
        def startPos(self) -> PySide2.QtCore.QPointF: ...
        def startScenePos(self) -> PySide2.QtCore.QPointF: ...
        def startScreenPos(self) -> PySide2.QtCore.QPointF: ...
        def state(self) -> PySide2.QtCore.Qt.TouchPointState: ...
        def swap(self, other: PySide2.QtGui.QTouchEvent.TouchPoint): ...
        def uniqueId(self) -> PySide2.QtGui.QPointingDeviceUniqueId: ...
        def velocity(self) -> PySide2.QtGui.QVector2D: ...


class QTransform(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, h11: float, h12: float, h13: float, h21: float, h22: float, h23: float, h31: float, h32: float, h33: float = ...): ...
    @typing.overload
    def __init__(self, h11: float, h12: float, h21: float, h22: float, dx: float, dy: float): ...
    @typing.overload
    def __init__(self, mtx: PySide2.QtGui.QMatrix): ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QTransform): ...
    def __add__(self, n: float) -> PySide2.QtGui.QTransform: ...
    def __copy__(self): ...
    def __iadd__(self, div: float) -> PySide2.QtGui.QTransform: ...
    @typing.overload
    def __imul__(self, arg__1: PySide2.QtGui.QTransform) -> PySide2.QtGui.QTransform: ...
    @typing.overload
    def __imul__(self, div: float) -> PySide2.QtGui.QTransform: ...
    def __isub__(self, div: float) -> PySide2.QtGui.QTransform: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, l: PySide2.QtCore.QLine) -> PySide2.QtCore.QLine: ...
    @typing.overload
    def __mul__(self, l: PySide2.QtCore.QLineF) -> PySide2.QtCore.QLineF: ...
    @typing.overload
    def __mul__(self, n: float) -> PySide2.QtGui.QTransform: ...
    @typing.overload
    def __mul__(self, o: PySide2.QtGui.QTransform) -> PySide2.QtGui.QTransform: ...
    @typing.overload
    def __mul__(self, p: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def __mul__(self, p: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __sub__(self, n: float) -> PySide2.QtGui.QTransform: ...
    def adjoint(self) -> PySide2.QtGui.QTransform: ...
    def det(self) -> float: ...
    def determinant(self) -> float: ...
    def dx(self) -> float: ...
    def dy(self) -> float: ...
    @staticmethod
    def fromScale(dx: float, dy: float) -> PySide2.QtGui.QTransform: ...
    @staticmethod
    def fromTranslate(dx: float, dy: float) -> PySide2.QtGui.QTransform: ...
    def inverted(self, invertible: bool = ...) -> PySide2.QtGui.QTransform: ...
    def isAffine(self) -> bool: ...
    def isIdentity(self) -> bool: ...
    def isInvertible(self) -> bool: ...
    def isRotating(self) -> bool: ...
    def isScaling(self) -> bool: ...
    def isTranslating(self) -> bool: ...
    def m11(self) -> float: ...
    def m12(self) -> float: ...
    def m13(self) -> float: ...
    def m21(self) -> float: ...
    def m22(self) -> float: ...
    def m23(self) -> float: ...
    def m31(self) -> float: ...
    def m32(self) -> float: ...
    def m33(self) -> float: ...
    @typing.overload
    def map(self, a: PySide2.QtGui.QPolygon) -> PySide2.QtGui.QPolygon: ...
    @typing.overload
    def map(self, a: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def map(self, l: PySide2.QtCore.QLine) -> PySide2.QtCore.QLine: ...
    @typing.overload
    def map(self, l: PySide2.QtCore.QLineF) -> PySide2.QtCore.QLineF: ...
    @typing.overload
    def map(self, p: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def map(self, p: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def map(self, p: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def map(self, r: PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def map(self, x: float, y: float, tx: float, ty: float): ...
    @typing.overload
    def mapRect(self, arg__1: PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def mapRect(self, arg__1: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def mapToPolygon(self, r: PySide2.QtCore.QRect) -> PySide2.QtGui.QPolygon: ...
    @typing.overload
    @staticmethod
    def quadToQuad(arg__1: PySide2.QtGui.QPolygonF, arg__2: PySide2.QtGui.QPolygonF) -> object: ...
    @typing.overload
    @staticmethod
    def quadToQuad(one: PySide2.QtGui.QPolygonF, two: PySide2.QtGui.QPolygonF, result: PySide2.QtGui.QTransform) -> bool: ...
    @typing.overload
    @staticmethod
    def quadToSquare(arg__1: PySide2.QtGui.QPolygonF) -> object: ...
    @typing.overload
    @staticmethod
    def quadToSquare(quad: PySide2.QtGui.QPolygonF, result: PySide2.QtGui.QTransform) -> bool: ...
    def reset(self): ...
    def rotate(self, a: float, axis: PySide2.QtCore.Qt.Axis = ...) -> PySide2.QtGui.QTransform: ...
    def rotateRadians(self, a: float, axis: PySide2.QtCore.Qt.Axis = ...) -> PySide2.QtGui.QTransform: ...
    def scale(self, sx: float, sy: float) -> PySide2.QtGui.QTransform: ...
    def setMatrix(self, m11: float, m12: float, m13: float, m21: float, m22: float, m23: float, m31: float, m32: float, m33: float): ...
    def shear(self, sh: float, sv: float) -> PySide2.QtGui.QTransform: ...
    @typing.overload
    @staticmethod
    def squareToQuad(arg__1: PySide2.QtGui.QPolygonF) -> object: ...
    @typing.overload
    @staticmethod
    def squareToQuad(square: PySide2.QtGui.QPolygonF, result: PySide2.QtGui.QTransform) -> bool: ...
    def toAffine(self) -> PySide2.QtGui.QMatrix: ...
    def translate(self, dx: float, dy: float) -> PySide2.QtGui.QTransform: ...
    def transposed(self) -> PySide2.QtGui.QTransform: ...
    def type(self) -> PySide2.QtGui.QTransform.TransformationType: ...


class QValidator(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def fixup(self, arg__1: str): ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    def setLocale(self, locale: PySide2.QtCore.QLocale): ...
    def validate(self, arg__1: str, arg__2: int) -> PySide2.QtGui.QValidator.State: ...


class QVector2D(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, point: PySide2.QtCore.QPoint): ...
    @typing.overload
    def __init__(self, point: PySide2.QtCore.QPointF): ...
    @typing.overload
    def __init__(self, vector: PySide2.QtGui.QVector3D): ...
    @typing.overload
    def __init__(self, vector: PySide2.QtGui.QVector4D): ...
    @typing.overload
    def __init__(self, xpos: float, ypos: float): ...
    def __add__(self, v2: PySide2.QtGui.QVector2D) -> PySide2.QtGui.QVector2D: ...
    def __copy__(self): ...
    def __iadd__(self, vector: PySide2.QtGui.QVector2D) -> PySide2.QtGui.QVector2D: ...
    @typing.overload
    def __imul__(self, factor: float) -> PySide2.QtGui.QVector2D: ...
    @typing.overload
    def __imul__(self, vector: PySide2.QtGui.QVector2D) -> PySide2.QtGui.QVector2D: ...
    def __isub__(self, vector: PySide2.QtGui.QVector2D) -> PySide2.QtGui.QVector2D: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, factor: float) -> PySide2.QtGui.QVector2D: ...
    @typing.overload
    def __mul__(self, v2: PySide2.QtGui.QVector2D) -> PySide2.QtGui.QVector2D: ...
    def __neg__(self) -> PySide2.QtGui.QVector2D: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __sub__(self, v2: PySide2.QtGui.QVector2D) -> PySide2.QtGui.QVector2D: ...
    def distanceToLine(self, point: PySide2.QtGui.QVector2D, direction: PySide2.QtGui.QVector2D) -> float: ...
    def distanceToPoint(self, point: PySide2.QtGui.QVector2D) -> float: ...
    @staticmethod
    def dotProduct(v1: PySide2.QtGui.QVector2D, v2: PySide2.QtGui.QVector2D) -> float: ...
    def isNull(self) -> bool: ...
    def length(self) -> float: ...
    def lengthSquared(self) -> float: ...
    def normalize(self): ...
    def normalized(self) -> PySide2.QtGui.QVector2D: ...
    def setX(self, x: float): ...
    def setY(self, y: float): ...
    def toPoint(self) -> PySide2.QtCore.QPoint: ...
    def toPointF(self) -> PySide2.QtCore.QPointF: ...
    def toTuple(self) -> object: ...
    def toVector3D(self) -> PySide2.QtGui.QVector3D: ...
    def toVector4D(self) -> PySide2.QtGui.QVector4D: ...
    def x(self) -> float: ...
    def y(self) -> float: ...


class QVector3D(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, point: PySide2.QtCore.QPoint): ...
    @typing.overload
    def __init__(self, point: PySide2.QtCore.QPointF): ...
    @typing.overload
    def __init__(self, vector: PySide2.QtGui.QVector2D): ...
    @typing.overload
    def __init__(self, vector: PySide2.QtGui.QVector2D, zpos: float): ...
    @typing.overload
    def __init__(self, vector: PySide2.QtGui.QVector4D): ...
    @typing.overload
    def __init__(self, xpos: float, ypos: float, zpos: float): ...
    def __add__(self, v2: PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    def __copy__(self): ...
    def __iadd__(self, vector: PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    @typing.overload
    def __imul__(self, factor: float) -> PySide2.QtGui.QVector3D: ...
    @typing.overload
    def __imul__(self, vector: PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    def __isub__(self, vector: PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, factor: float) -> PySide2.QtGui.QVector3D: ...
    @typing.overload
    def __mul__(self, matrix: PySide2.QtGui.QMatrix4x4) -> PySide2.QtGui.QVector3D: ...
    @typing.overload
    def __mul__(self, quaternion: PySide2.QtGui.QQuaternion) -> PySide2.QtGui.QVector3D: ...
    @typing.overload
    def __mul__(self, v2: PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    def __neg__(self) -> PySide2.QtGui.QVector3D: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __sub__(self, v2: PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    @staticmethod
    def crossProduct(v1: PySide2.QtGui.QVector3D, v2: PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    def distanceToLine(self, point: PySide2.QtGui.QVector3D, direction: PySide2.QtGui.QVector3D) -> float: ...
    @typing.overload
    def distanceToPlane(self, plane1: PySide2.QtGui.QVector3D, plane2: PySide2.QtGui.QVector3D, plane3: PySide2.QtGui.QVector3D) -> float: ...
    @typing.overload
    def distanceToPlane(self, plane: PySide2.QtGui.QVector3D, normal: PySide2.QtGui.QVector3D) -> float: ...
    def distanceToPoint(self, point: PySide2.QtGui.QVector3D) -> float: ...
    @staticmethod
    def dotProduct(v1: PySide2.QtGui.QVector3D, v2: PySide2.QtGui.QVector3D) -> float: ...
    def isNull(self) -> bool: ...
    def length(self) -> float: ...
    def lengthSquared(self) -> float: ...
    @typing.overload
    @staticmethod
    def normal(v1: PySide2.QtGui.QVector3D, v2: PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    @typing.overload
    @staticmethod
    def normal(v1: PySide2.QtGui.QVector3D, v2: PySide2.QtGui.QVector3D, v3: PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    def normalize(self): ...
    def normalized(self) -> PySide2.QtGui.QVector3D: ...
    def project(self, modelView: PySide2.QtGui.QMatrix4x4, projection: PySide2.QtGui.QMatrix4x4, viewport: PySide2.QtCore.QRect) -> PySide2.QtGui.QVector3D: ...
    def setX(self, x: float): ...
    def setY(self, y: float): ...
    def setZ(self, z: float): ...
    def toPoint(self) -> PySide2.QtCore.QPoint: ...
    def toPointF(self) -> PySide2.QtCore.QPointF: ...
    def toTuple(self) -> object: ...
    def toVector2D(self) -> PySide2.QtGui.QVector2D: ...
    def toVector4D(self) -> PySide2.QtGui.QVector4D: ...
    def unproject(self, modelView: PySide2.QtGui.QMatrix4x4, projection: PySide2.QtGui.QMatrix4x4, viewport: PySide2.QtCore.QRect) -> PySide2.QtGui.QVector3D: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...


class QVector4D(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, point: PySide2.QtCore.QPoint): ...
    @typing.overload
    def __init__(self, point: PySide2.QtCore.QPointF): ...
    @typing.overload
    def __init__(self, vector: PySide2.QtGui.QVector2D): ...
    @typing.overload
    def __init__(self, vector: PySide2.QtGui.QVector2D, zpos: float, wpos: float): ...
    @typing.overload
    def __init__(self, vector: PySide2.QtGui.QVector3D): ...
    @typing.overload
    def __init__(self, vector: PySide2.QtGui.QVector3D, wpos: float): ...
    @typing.overload
    def __init__(self, xpos: float, ypos: float, zpos: float, wpos: float): ...
    def __add__(self, v2: PySide2.QtGui.QVector4D) -> PySide2.QtGui.QVector4D: ...
    def __copy__(self): ...
    def __iadd__(self, vector: PySide2.QtGui.QVector4D) -> PySide2.QtGui.QVector4D: ...
    @typing.overload
    def __imul__(self, factor: float) -> PySide2.QtGui.QVector4D: ...
    @typing.overload
    def __imul__(self, vector: PySide2.QtGui.QVector4D) -> PySide2.QtGui.QVector4D: ...
    def __isub__(self, vector: PySide2.QtGui.QVector4D) -> PySide2.QtGui.QVector4D: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, factor: float) -> PySide2.QtGui.QVector4D: ...
    @typing.overload
    def __mul__(self, matrix: PySide2.QtGui.QMatrix4x4) -> PySide2.QtGui.QVector4D: ...
    @typing.overload
    def __mul__(self, v2: PySide2.QtGui.QVector4D) -> PySide2.QtGui.QVector4D: ...
    def __neg__(self) -> PySide2.QtGui.QVector4D: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __sub__(self, v2: PySide2.QtGui.QVector4D) -> PySide2.QtGui.QVector4D: ...
    @staticmethod
    def dotProduct(v1: PySide2.QtGui.QVector4D, v2: PySide2.QtGui.QVector4D) -> float: ...
    def isNull(self) -> bool: ...
    def length(self) -> float: ...
    def lengthSquared(self) -> float: ...
    def normalize(self): ...
    def normalized(self) -> PySide2.QtGui.QVector4D: ...
    def setW(self, w: float): ...
    def setX(self, x: float): ...
    def setY(self, y: float): ...
    def setZ(self, z: float): ...
    def toPoint(self) -> PySide2.QtCore.QPoint: ...
    def toPointF(self) -> PySide2.QtCore.QPointF: ...
    def toTuple(self) -> object: ...
    def toVector2D(self) -> PySide2.QtGui.QVector2D: ...
    def toVector2DAffine(self) -> PySide2.QtGui.QVector2D: ...
    def toVector3D(self) -> PySide2.QtGui.QVector3D: ...
    def toVector3DAffine(self) -> PySide2.QtGui.QVector3D: ...
    def w(self) -> float: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...


class QWhatsThisClickedEvent(PySide2.QtCore.QEvent):

    def __init__(self, href: str): ...
    def href(self) -> str: ...


class QWheelEvent(PySide2.QtGui.QInputEvent):

    @typing.overload
    def __init__(self, pos: PySide2.QtCore.QPointF, delta: int, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers, orient: PySide2.QtCore.Qt.Orientation = ...): ...
    @typing.overload
    def __init__(self, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, delta: int, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers, orient: PySide2.QtCore.Qt.Orientation = ...): ...
    @typing.overload
    def __init__(self, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, pixelDelta: PySide2.QtCore.QPoint, angleDelta: PySide2.QtCore.QPoint, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers, phase: PySide2.QtCore.Qt.ScrollPhase, inverted: bool, source: PySide2.QtCore.Qt.MouseEventSource = ...): ...
    @typing.overload
    def __init__(self, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, pixelDelta: PySide2.QtCore.QPoint, angleDelta: PySide2.QtCore.QPoint, qt4Delta: int, qt4Orientation: PySide2.QtCore.Qt.Orientation, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers): ...
    @typing.overload
    def __init__(self, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, pixelDelta: PySide2.QtCore.QPoint, angleDelta: PySide2.QtCore.QPoint, qt4Delta: int, qt4Orientation: PySide2.QtCore.Qt.Orientation, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers, phase: PySide2.QtCore.Qt.ScrollPhase): ...
    @typing.overload
    def __init__(self, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, pixelDelta: PySide2.QtCore.QPoint, angleDelta: PySide2.QtCore.QPoint, qt4Delta: int, qt4Orientation: PySide2.QtCore.Qt.Orientation, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers, phase: PySide2.QtCore.Qt.ScrollPhase, source: PySide2.QtCore.Qt.MouseEventSource): ...
    @typing.overload
    def __init__(self, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, pixelDelta: PySide2.QtCore.QPoint, angleDelta: PySide2.QtCore.QPoint, qt4Delta: int, qt4Orientation: PySide2.QtCore.Qt.Orientation, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers, phase: PySide2.QtCore.Qt.ScrollPhase, source: PySide2.QtCore.Qt.MouseEventSource, inverted: bool): ...
    def angleDelta(self) -> PySide2.QtCore.QPoint: ...
    def buttons(self) -> PySide2.QtCore.Qt.MouseButtons: ...
    def delta(self) -> int: ...
    def globalPos(self) -> PySide2.QtCore.QPoint: ...
    def globalPosF(self) -> PySide2.QtCore.QPointF: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def inverted(self) -> bool: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def phase(self) -> PySide2.QtCore.Qt.ScrollPhase: ...
    def pixelDelta(self) -> PySide2.QtCore.QPoint: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def posF(self) -> PySide2.QtCore.QPointF: ...
    def source(self) -> PySide2.QtCore.Qt.MouseEventSource: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QWindow(PySide2.QtCore.QObject, PySide2.QtGui.QSurface):

    @typing.overload
    def __init__(self, parent: PySide2.QtGui.QWindow): ...
    @typing.overload
    def __init__(self, screen: PySide2.QtGui.QScreen = ...): ...
    def accessibleRoot(self) -> PySide2.QtGui.QAccessibleInterface: ...
    def alert(self, msec: int): ...
    def baseSize(self) -> PySide2.QtCore.QSize: ...
    def close(self) -> bool: ...
    def contentOrientation(self) -> PySide2.QtCore.Qt.ScreenOrientation: ...
    def create(self): ...
    def cursor(self) -> PySide2.QtGui.QCursor: ...
    def destroy(self): ...
    def devicePixelRatio(self) -> float: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def exposeEvent(self, arg__1: PySide2.QtGui.QExposeEvent): ...
    def filePath(self) -> str: ...
    def flags(self) -> PySide2.QtCore.Qt.WindowFlags: ...
    def focusInEvent(self, arg__1: PySide2.QtGui.QFocusEvent): ...
    def focusObject(self) -> PySide2.QtCore.QObject: ...
    def focusOutEvent(self, arg__1: PySide2.QtGui.QFocusEvent): ...
    def format(self) -> PySide2.QtGui.QSurfaceFormat: ...
    def frameGeometry(self) -> PySide2.QtCore.QRect: ...
    def frameMargins(self) -> PySide2.QtCore.QMargins: ...
    def framePosition(self) -> PySide2.QtCore.QPoint: ...
    @staticmethod
    def fromWinId(id: int) -> PySide2.QtGui.QWindow: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def height(self) -> int: ...
    def hide(self): ...
    def hideEvent(self, arg__1: PySide2.QtGui.QHideEvent): ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def isActive(self) -> bool: ...
    def isAncestorOf(self, child: PySide2.QtGui.QWindow, mode: PySide2.QtGui.QWindow.AncestorMode = ...) -> bool: ...
    def isExposed(self) -> bool: ...
    def isModal(self) -> bool: ...
    def isTopLevel(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, arg__1: PySide2.QtGui.QKeyEvent): ...
    def lower(self): ...
    def mapFromGlobal(self, pos: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mapToGlobal(self, pos: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mask(self) -> PySide2.QtGui.QRegion: ...
    def maximumHeight(self) -> int: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def maximumWidth(self) -> int: ...
    def minimumHeight(self) -> int: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumWidth(self) -> int: ...
    def modality(self) -> PySide2.QtCore.Qt.WindowModality: ...
    def mouseDoubleClickEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent): ...
    def moveEvent(self, arg__1: PySide2.QtGui.QMoveEvent): ...
    def nativeEvent(self, eventType: PySide2.QtCore.QByteArray, message: int, result: int) -> bool: ...
    def opacity(self) -> float: ...
    @typing.overload
    def parent(self) -> PySide2.QtGui.QWindow: ...
    @typing.overload
    def parent(self, mode: PySide2.QtGui.QWindow.AncestorMode) -> PySide2.QtGui.QWindow: ...
    def position(self) -> PySide2.QtCore.QPoint: ...
    def raise_(self): ...
    def reportContentOrientationChange(self, orientation: PySide2.QtCore.Qt.ScreenOrientation): ...
    def requestActivate(self): ...
    def requestUpdate(self): ...
    def requestedFormat(self) -> PySide2.QtGui.QSurfaceFormat: ...
    @typing.overload
    def resize(self, newSize: PySide2.QtCore.QSize): ...
    @typing.overload
    def resize(self, w: int, h: int): ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent): ...
    def screen(self) -> PySide2.QtGui.QScreen: ...
    def setBaseSize(self, size: PySide2.QtCore.QSize): ...
    def setCursor(self, arg__1: PySide2.QtGui.QCursor): ...
    def setFilePath(self, filePath: str): ...
    def setFlag(self, arg__1: PySide2.QtCore.Qt.WindowType, on: bool = ...): ...
    def setFlags(self, flags: PySide2.QtCore.Qt.WindowFlags): ...
    def setFormat(self, format: PySide2.QtGui.QSurfaceFormat): ...
    def setFramePosition(self, point: PySide2.QtCore.QPoint): ...
    @typing.overload
    def setGeometry(self, posx: int, posy: int, w: int, h: int): ...
    @typing.overload
    def setGeometry(self, rect: PySide2.QtCore.QRect): ...
    def setHeight(self, arg: int): ...
    def setIcon(self, icon: PySide2.QtGui.QIcon): ...
    def setKeyboardGrabEnabled(self, grab: bool) -> bool: ...
    def setMask(self, region: PySide2.QtGui.QRegion): ...
    def setMaximumHeight(self, h: int): ...
    def setMaximumSize(self, size: PySide2.QtCore.QSize): ...
    def setMaximumWidth(self, w: int): ...
    def setMinimumHeight(self, h: int): ...
    def setMinimumSize(self, size: PySide2.QtCore.QSize): ...
    def setMinimumWidth(self, w: int): ...
    def setModality(self, modality: PySide2.QtCore.Qt.WindowModality): ...
    def setMouseGrabEnabled(self, grab: bool) -> bool: ...
    def setOpacity(self, level: float): ...
    def setParent(self, parent: PySide2.QtGui.QWindow): ...
    @typing.overload
    def setPosition(self, posx: int, posy: int): ...
    @typing.overload
    def setPosition(self, pt: PySide2.QtCore.QPoint): ...
    def setScreen(self, screen: PySide2.QtGui.QScreen): ...
    def setSizeIncrement(self, size: PySide2.QtCore.QSize): ...
    def setSurfaceType(self, surfaceType: PySide2.QtGui.QSurface.SurfaceType): ...
    def setTitle(self, arg__1: str): ...
    def setTransientParent(self, parent: PySide2.QtGui.QWindow): ...
    def setVisibility(self, v: PySide2.QtGui.QWindow.Visibility): ...
    def setVisible(self, visible: bool): ...
    def setWidth(self, arg: int): ...
    def setWindowState(self, state: PySide2.QtCore.Qt.WindowState): ...
    def setWindowStates(self, states: PySide2.QtCore.Qt.WindowStates): ...
    def setX(self, arg: int): ...
    def setY(self, arg: int): ...
    def show(self): ...
    def showEvent(self, arg__1: PySide2.QtGui.QShowEvent): ...
    def showFullScreen(self): ...
    def showMaximized(self): ...
    def showMinimized(self): ...
    def showNormal(self): ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def sizeIncrement(self) -> PySide2.QtCore.QSize: ...
    def surfaceHandle(self) -> int: ...
    def surfaceType(self) -> PySide2.QtGui.QSurface.SurfaceType: ...
    def tabletEvent(self, arg__1: PySide2.QtGui.QTabletEvent): ...
    def title(self) -> str: ...
    def touchEvent(self, arg__1: PySide2.QtGui.QTouchEvent): ...
    def transientParent(self) -> PySide2.QtGui.QWindow: ...
    def type(self) -> PySide2.QtCore.Qt.WindowType: ...
    def unsetCursor(self): ...
    def visibility(self) -> PySide2.QtGui.QWindow.Visibility: ...
    def wheelEvent(self, arg__1: PySide2.QtGui.QWheelEvent): ...
    def width(self) -> int: ...
    def winId(self) -> int: ...
    def windowState(self) -> PySide2.QtCore.Qt.WindowState: ...
    def windowStates(self) -> PySide2.QtCore.Qt.WindowStates: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QWindowStateChangeEvent(PySide2.QtCore.QEvent):

    def __init__(self, aOldState: PySide2.QtCore.Qt.WindowStates, isOverride: bool = ...): ...
    def isOverride(self) -> bool: ...
    def oldState(self) -> PySide2.QtCore.Qt.WindowStates: ...


class Qt(PySide2.QtCore.Qt):

    @staticmethod
    def codecForHtml(ba: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QTextCodec: ...
    @staticmethod
    def convertFromPlainText(plain: str, mode: PySide2.QtCore.Qt.WhiteSpaceMode = ...) -> str: ...
    @staticmethod
    def mightBeRichText(arg__1: str) -> bool: ...

# eof
