# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2019 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtNetwork, except for defaults which are replaced by "...".
"""

# Module PySide2.QtNetwork
import PySide2
from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken2 as Shiboken
Shiboken.Object = Object

import PySide2.QtNetwork


class QAbstractNetworkCache(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def cacheSize(self) -> int: ...
    def clear(self): ...
    def data(self, url: PySide2.QtCore.QUrl) -> PySide2.QtCore.QIODevice: ...
    def insert(self, device: PySide2.QtCore.QIODevice): ...
    def metaData(self, url: PySide2.QtCore.QUrl) -> PySide2.QtNetwork.QNetworkCacheMetaData: ...
    def prepare(self, metaData: PySide2.QtNetwork.QNetworkCacheMetaData) -> PySide2.QtCore.QIODevice: ...
    def remove(self, url: PySide2.QtCore.QUrl) -> bool: ...
    def updateMetaData(self, metaData: PySide2.QtNetwork.QNetworkCacheMetaData): ...


class QAbstractSocket(PySide2.QtCore.QIODevice):

    def __init__(self, socketType: PySide2.QtNetwork.QAbstractSocket.SocketType, parent: PySide2.QtCore.QObject): ...
    def abort(self): ...
    def atEnd(self) -> bool: ...
    @typing.overload
    def bind(self, address: PySide2.QtNetwork.QHostAddress, port: int = ..., mode: PySide2.QtNetwork.QAbstractSocket.BindMode = ...) -> bool: ...
    @typing.overload
    def bind(self, port: int = ..., mode: PySide2.QtNetwork.QAbstractSocket.BindMode = ...) -> bool: ...
    def bytesAvailable(self) -> int: ...
    def bytesToWrite(self) -> int: ...
    def canReadLine(self) -> bool: ...
    def close(self): ...
    @typing.overload
    def connectToHost(self, address: PySide2.QtNetwork.QHostAddress, port: int, mode: PySide2.QtCore.QIODevice.OpenMode = ...): ...
    @typing.overload
    def connectToHost(self, hostName: str, port: int, mode: PySide2.QtCore.QIODevice.OpenMode = ..., protocol: PySide2.QtNetwork.QAbstractSocket.NetworkLayerProtocol = ...): ...
    def disconnectFromHost(self): ...
    def error(self) -> PySide2.QtNetwork.QAbstractSocket.SocketError: ...
    def flush(self) -> bool: ...
    def isSequential(self) -> bool: ...
    def isValid(self) -> bool: ...
    def localAddress(self) -> PySide2.QtNetwork.QHostAddress: ...
    def localPort(self) -> int: ...
    def pauseMode(self) -> PySide2.QtNetwork.QAbstractSocket.PauseModes: ...
    def peerAddress(self) -> PySide2.QtNetwork.QHostAddress: ...
    def peerName(self) -> str: ...
    def peerPort(self) -> int: ...
    def proxy(self) -> PySide2.QtNetwork.QNetworkProxy: ...
    def readBufferSize(self) -> int: ...
    def readData(self, data: str, maxlen: int) -> int: ...
    def readLineData(self, data: str, maxlen: int) -> int: ...
    def resume(self): ...
    def setLocalAddress(self, address: PySide2.QtNetwork.QHostAddress): ...
    def setLocalPort(self, port: int): ...
    def setPauseMode(self, pauseMode: PySide2.QtNetwork.QAbstractSocket.PauseModes): ...
    def setPeerAddress(self, address: PySide2.QtNetwork.QHostAddress): ...
    def setPeerName(self, name: str): ...
    def setPeerPort(self, port: int): ...
    def setProxy(self, networkProxy: PySide2.QtNetwork.QNetworkProxy): ...
    def setReadBufferSize(self, size: int): ...
    def setSocketDescriptor(self, socketDescriptor: int, state: PySide2.QtNetwork.QAbstractSocket.SocketState = ..., openMode: PySide2.QtCore.QIODevice.OpenMode = ...) -> bool: ...
    def setSocketError(self, socketError: PySide2.QtNetwork.QAbstractSocket.SocketError): ...
    def setSocketOption(self, option: PySide2.QtNetwork.QAbstractSocket.SocketOption, value: typing.Any): ...
    def setSocketState(self, state: PySide2.QtNetwork.QAbstractSocket.SocketState): ...
    def socketDescriptor(self) -> int: ...
    def socketOption(self, option: PySide2.QtNetwork.QAbstractSocket.SocketOption) -> typing.Any: ...
    def socketType(self) -> PySide2.QtNetwork.QAbstractSocket.SocketType: ...
    def state(self) -> PySide2.QtNetwork.QAbstractSocket.SocketState: ...
    def waitForBytesWritten(self, msecs: int = ...) -> bool: ...
    def waitForConnected(self, msecs: int = ...) -> bool: ...
    def waitForDisconnected(self, msecs: int = ...) -> bool: ...
    def waitForReadyRead(self, msecs: int = ...) -> bool: ...
    def writeData(self, data: str, len: int) -> int: ...


class QAuthenticator(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QAuthenticator): ...
    def __copy__(self): ...
    def isNull(self) -> bool: ...
    def option(self, opt: str) -> typing.Any: ...
    def options(self) -> typing.Dict: ...
    def password(self) -> str: ...
    def realm(self) -> str: ...
    def setOption(self, opt: str, value: typing.Any): ...
    def setPassword(self, password: str): ...
    def setRealm(self, realm: str): ...
    def setUser(self, user: str): ...
    def user(self) -> str: ...


class QDnsDomainNameRecord(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QDnsDomainNameRecord): ...
    def __copy__(self): ...
    def name(self) -> str: ...
    def swap(self, other: PySide2.QtNetwork.QDnsDomainNameRecord): ...
    def timeToLive(self) -> int: ...
    def value(self) -> str: ...


class QDnsHostAddressRecord(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QDnsHostAddressRecord): ...
    def __copy__(self): ...
    def name(self) -> str: ...
    def swap(self, other: PySide2.QtNetwork.QDnsHostAddressRecord): ...
    def timeToLive(self) -> int: ...
    def value(self) -> PySide2.QtNetwork.QHostAddress: ...


class QDnsLookup(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, type: PySide2.QtNetwork.QDnsLookup.Type, name: str, nameserver: PySide2.QtNetwork.QHostAddress, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, type: PySide2.QtNetwork.QDnsLookup.Type, name: str, parent: PySide2.QtCore.QObject = ...): ...
    def abort(self): ...
    def canonicalNameRecords(self) -> typing.List[PySide2.QtNetwork.QDnsDomainNameRecord]: ...
    def error(self) -> PySide2.QtNetwork.QDnsLookup.Error: ...
    def errorString(self) -> str: ...
    def hostAddressRecords(self) -> typing.List[PySide2.QtNetwork.QDnsHostAddressRecord]: ...
    def isFinished(self) -> bool: ...
    def lookup(self): ...
    def mailExchangeRecords(self) -> typing.List[PySide2.QtNetwork.QDnsMailExchangeRecord]: ...
    def name(self) -> str: ...
    def nameServerRecords(self) -> typing.List[PySide2.QtNetwork.QDnsDomainNameRecord]: ...
    def nameserver(self) -> PySide2.QtNetwork.QHostAddress: ...
    def pointerRecords(self) -> typing.List[PySide2.QtNetwork.QDnsDomainNameRecord]: ...
    def serviceRecords(self) -> typing.List[PySide2.QtNetwork.QDnsServiceRecord]: ...
    def setName(self, name: str): ...
    def setNameserver(self, nameserver: PySide2.QtNetwork.QHostAddress): ...
    def setType(self, arg__1: PySide2.QtNetwork.QDnsLookup.Type): ...
    def textRecords(self) -> typing.List[PySide2.QtNetwork.QDnsTextRecord]: ...
    def type(self) -> PySide2.QtNetwork.QDnsLookup.Type: ...


class QDnsMailExchangeRecord(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QDnsMailExchangeRecord): ...
    def __copy__(self): ...
    def exchange(self) -> str: ...
    def name(self) -> str: ...
    def preference(self) -> int: ...
    def swap(self, other: PySide2.QtNetwork.QDnsMailExchangeRecord): ...
    def timeToLive(self) -> int: ...


class QDnsServiceRecord(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QDnsServiceRecord): ...
    def __copy__(self): ...
    def name(self) -> str: ...
    def port(self) -> int: ...
    def priority(self) -> int: ...
    def swap(self, other: PySide2.QtNetwork.QDnsServiceRecord): ...
    def target(self) -> str: ...
    def timeToLive(self) -> int: ...
    def weight(self) -> int: ...


class QDnsTextRecord(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QDnsTextRecord): ...
    def __copy__(self): ...
    def name(self) -> str: ...
    def swap(self, other: PySide2.QtNetwork.QDnsTextRecord): ...
    def timeToLive(self) -> int: ...
    def values(self) -> typing.List[PySide2.QtCore.QByteArray]: ...


class QDtls(PySide2.QtCore.QObject):

    def __init__(self, mode: PySide2.QtNetwork.QSslSocket.SslMode, parent: PySide2.QtCore.QObject = ...): ...
    def abortHandshake(self, socket: PySide2.QtNetwork.QUdpSocket) -> bool: ...
    def decryptDatagram(self, socket: PySide2.QtNetwork.QUdpSocket, dgram: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    def doHandshake(self, socket: PySide2.QtNetwork.QUdpSocket, dgram: PySide2.QtCore.QByteArray = ...) -> bool: ...
    def dtlsConfiguration(self) -> PySide2.QtNetwork.QSslConfiguration: ...
    def dtlsError(self) -> PySide2.QtNetwork.QDtlsError: ...
    def dtlsErrorString(self) -> str: ...
    def handleTimeout(self, socket: PySide2.QtNetwork.QUdpSocket) -> bool: ...
    def handshakeState(self) -> PySide2.QtNetwork.QDtls.HandshakeState: ...
    def ignoreVerificationErrors(self, errorsToIgnore: typing.List[PySide2.QtNetwork.QSslError]): ...
    def isConnectionEncrypted(self) -> bool: ...
    def mtuHint(self) -> int: ...
    def peerAddress(self) -> PySide2.QtNetwork.QHostAddress: ...
    def peerPort(self) -> int: ...
    def peerVerificationErrors(self) -> typing.List[PySide2.QtNetwork.QSslError]: ...
    def peerVerificationName(self) -> str: ...
    def resumeHandshake(self, socket: PySide2.QtNetwork.QUdpSocket) -> bool: ...
    def sessionCipher(self) -> PySide2.QtNetwork.QSslCipher: ...
    def sessionProtocol(self) -> PySide2.QtNetwork.QSsl.SslProtocol: ...
    def setDtlsConfiguration(self, configuration: PySide2.QtNetwork.QSslConfiguration) -> bool: ...
    def setMtuHint(self, mtuHint: int): ...
    def setPeer(self, address: PySide2.QtNetwork.QHostAddress, port: int, verificationName: str = ...) -> bool: ...
    def setPeerVerificationName(self, name: str) -> bool: ...
    def shutdown(self, socket: PySide2.QtNetwork.QUdpSocket) -> bool: ...
    def sslMode(self) -> PySide2.QtNetwork.QSslSocket.SslMode: ...
    def writeDatagramEncrypted(self, socket: PySide2.QtNetwork.QUdpSocket, dgram: PySide2.QtCore.QByteArray) -> int: ...


class QHostAddress(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, address: PySide2.QtNetwork.QHostAddress.SpecialAddress): ...
    @typing.overload
    def __init__(self, address: str): ...
    @typing.overload
    def __init__(self, copy: PySide2.QtNetwork.QHostAddress): ...
    @typing.overload
    def __init__(self, ip4Addr: int): ...
    @typing.overload
    def __init__(self, ip6Addr: PySide2.QtNetwork.QIPv6Address): ...
    def __copy__(self): ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def clear(self): ...
    def isBroadcast(self) -> bool: ...
    def isEqual(self, address: PySide2.QtNetwork.QHostAddress, mode: PySide2.QtNetwork.QHostAddress.ConversionMode = ...) -> bool: ...
    def isGlobal(self) -> bool: ...
    @typing.overload
    def isInSubnet(self, subnet: PySide2.QtNetwork.QHostAddress, netmask: int) -> bool: ...
    @typing.overload
    def isInSubnet(self, subnet: typing.Tuple) -> bool: ...
    def isLinkLocal(self) -> bool: ...
    def isLoopback(self) -> bool: ...
    def isMulticast(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isSiteLocal(self) -> bool: ...
    def isUniqueLocalUnicast(self) -> bool: ...
    @staticmethod
    def parseSubnet(subnet: str) -> typing.Tuple: ...
    def protocol(self) -> PySide2.QtNetwork.QAbstractSocket.NetworkLayerProtocol: ...
    def scopeId(self) -> str: ...
    @typing.overload
    def setAddress(self, address: PySide2.QtNetwork.QHostAddress.SpecialAddress): ...
    @typing.overload
    def setAddress(self, address: str) -> bool: ...
    @typing.overload
    def setAddress(self, ip4Addr: int): ...
    @typing.overload
    def setAddress(self, ip6Addr: PySide2.QtNetwork.QIPv6Address): ...
    def setScopeId(self, id: str): ...
    def swap(self, other: PySide2.QtNetwork.QHostAddress): ...
    @typing.overload
    def toIPv4Address(self) -> int: ...
    @typing.overload
    def toIPv4Address(self, ok: bool) -> int: ...
    def toIPv6Address(self) -> PySide2.QtNetwork.QIPv6Address: ...
    def toString(self) -> str: ...


class QHostInfo(Shiboken.Object):

    @typing.overload
    def __init__(self, d: PySide2.QtNetwork.QHostInfo): ...
    @typing.overload
    def __init__(self, lookupId: int = ...): ...
    def __copy__(self): ...
    @staticmethod
    def abortHostLookup(lookupId: int): ...
    def addresses(self) -> typing.List[PySide2.QtNetwork.QHostAddress]: ...
    def error(self) -> PySide2.QtNetwork.QHostInfo.HostInfoError: ...
    def errorString(self) -> str: ...
    @staticmethod
    def fromName(name: str) -> PySide2.QtNetwork.QHostInfo: ...
    def hostName(self) -> str: ...
    @staticmethod
    def localDomainName() -> str: ...
    @staticmethod
    def localHostName() -> str: ...
    def lookupId(self) -> int: ...
    def setAddresses(self, addresses: typing.List[PySide2.QtNetwork.QHostAddress]): ...
    def setError(self, error: PySide2.QtNetwork.QHostInfo.HostInfoError): ...
    def setErrorString(self, errorString: str): ...
    def setHostName(self, name: str): ...
    def setLookupId(self, id: int): ...
    def swap(self, other: PySide2.QtNetwork.QHostInfo): ...


class QHstsPolicy(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, expiry: PySide2.QtCore.QDateTime, flags: PySide2.QtNetwork.QHstsPolicy.PolicyFlags, host: str, mode: PySide2.QtCore.QUrl.ParsingMode = ...): ...
    @typing.overload
    def __init__(self, rhs: PySide2.QtNetwork.QHstsPolicy): ...
    def __copy__(self): ...
    def expiry(self) -> PySide2.QtCore.QDateTime: ...
    def host(self, options: PySide2.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    def includesSubDomains(self) -> bool: ...
    def isExpired(self) -> bool: ...
    def setExpiry(self, expiry: PySide2.QtCore.QDateTime): ...
    def setHost(self, host: str, mode: PySide2.QtCore.QUrl.ParsingMode = ...): ...
    def setIncludesSubDomains(self, include: bool): ...
    def swap(self, other: PySide2.QtNetwork.QHstsPolicy): ...


class QHttpMultiPart(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, contentType: PySide2.QtNetwork.QHttpMultiPart.ContentType, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def append(self, httpPart: PySide2.QtNetwork.QHttpPart): ...
    def boundary(self) -> PySide2.QtCore.QByteArray: ...
    def setBoundary(self, boundary: PySide2.QtCore.QByteArray): ...
    def setContentType(self, contentType: PySide2.QtNetwork.QHttpMultiPart.ContentType): ...


class QHttpPart(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QHttpPart): ...
    def __copy__(self): ...
    def setBody(self, body: PySide2.QtCore.QByteArray): ...
    def setBodyDevice(self, device: PySide2.QtCore.QIODevice): ...
    def setHeader(self, header: PySide2.QtNetwork.QNetworkRequest.KnownHeaders, value: typing.Any): ...
    def setRawHeader(self, headerName: PySide2.QtCore.QByteArray, headerValue: PySide2.QtCore.QByteArray): ...
    def swap(self, other: PySide2.QtNetwork.QHttpPart): ...


class QIPv6Address(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QIPv6Address: PySide2.QtNetwork.QIPv6Address): ...
    def __copy__(self): ...


class QLocalServer(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def close(self): ...
    def errorString(self) -> str: ...
    def fullServerName(self) -> str: ...
    def hasPendingConnections(self) -> bool: ...
    def incomingConnection(self, socketDescriptor: int): ...
    def isListening(self) -> bool: ...
    @typing.overload
    def listen(self, name: str) -> bool: ...
    @typing.overload
    def listen(self, socketDescriptor: int) -> bool: ...
    def maxPendingConnections(self) -> int: ...
    def nextPendingConnection(self) -> PySide2.QtNetwork.QLocalSocket: ...
    @staticmethod
    def removeServer(name: str) -> bool: ...
    def serverError(self) -> PySide2.QtNetwork.QAbstractSocket.SocketError: ...
    def serverName(self) -> str: ...
    def setMaxPendingConnections(self, numConnections: int): ...
    def setSocketOptions(self, options: PySide2.QtNetwork.QLocalServer.SocketOptions): ...
    def socketDescriptor(self) -> int: ...
    def socketOptions(self) -> PySide2.QtNetwork.QLocalServer.SocketOptions: ...
    def waitForNewConnection(self, msec: int, timedOut: bool) -> bool: ...


class QLocalSocket(PySide2.QtCore.QIODevice):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def abort(self): ...
    def bytesAvailable(self) -> int: ...
    def bytesToWrite(self) -> int: ...
    def canReadLine(self) -> bool: ...
    def close(self): ...
    @typing.overload
    def connectToServer(self, name: str, openMode: PySide2.QtCore.QIODevice.OpenMode = ...): ...
    @typing.overload
    def connectToServer(self, openMode: PySide2.QtCore.QIODevice.OpenMode = ...): ...
    def disconnectFromServer(self): ...
    def error(self) -> PySide2.QtNetwork.QLocalSocket.LocalSocketError: ...
    def flush(self) -> bool: ...
    def fullServerName(self) -> str: ...
    def isSequential(self) -> bool: ...
    def isValid(self) -> bool: ...
    def open(self, openMode: PySide2.QtCore.QIODevice.OpenMode = ...) -> bool: ...
    def readBufferSize(self) -> int: ...
    def readData(self, arg__1: str, arg__2: int) -> int: ...
    def serverName(self) -> str: ...
    def setReadBufferSize(self, size: int): ...
    def setServerName(self, name: str): ...
    def setSocketDescriptor(self, socketDescriptor: int, socketState: PySide2.QtNetwork.QLocalSocket.LocalSocketState = ..., openMode: PySide2.QtCore.QIODevice.OpenMode = ...) -> bool: ...
    def socketDescriptor(self) -> int: ...
    def state(self) -> PySide2.QtNetwork.QLocalSocket.LocalSocketState: ...
    def waitForBytesWritten(self, msecs: int = ...) -> bool: ...
    def waitForConnected(self, msecs: int = ...) -> bool: ...
    def waitForDisconnected(self, msecs: int = ...) -> bool: ...
    def waitForReadyRead(self, msecs: int = ...) -> bool: ...
    def writeData(self, arg__1: str, arg__2: int) -> int: ...


class QNetworkAccessManager(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def activeConfiguration(self) -> PySide2.QtNetwork.QNetworkConfiguration: ...
    def addStrictTransportSecurityHosts(self, knownHosts: typing.List[PySide2.QtNetwork.QHstsPolicy]): ...
    def cache(self) -> PySide2.QtNetwork.QAbstractNetworkCache: ...
    def clearAccessCache(self): ...
    def clearConnectionCache(self): ...
    def configuration(self) -> PySide2.QtNetwork.QNetworkConfiguration: ...
    def connectToHost(self, hostName: str, port: int = ...): ...
    def connectToHostEncrypted(self, hostName: str, port: int = ..., sslConfiguration: PySide2.QtNetwork.QSslConfiguration = ...): ...
    def cookieJar(self) -> PySide2.QtNetwork.QNetworkCookieJar: ...
    def createRequest(self, op: PySide2.QtNetwork.QNetworkAccessManager.Operation, request: PySide2.QtNetwork.QNetworkRequest, outgoingData: PySide2.QtCore.QIODevice = ...) -> PySide2.QtNetwork.QNetworkReply: ...
    def deleteResource(self, request: PySide2.QtNetwork.QNetworkRequest) -> PySide2.QtNetwork.QNetworkReply: ...
    def enableStrictTransportSecurityStore(self, enabled: bool, storeDir: str = ...): ...
    def get(self, request: PySide2.QtNetwork.QNetworkRequest) -> PySide2.QtNetwork.QNetworkReply: ...
    def head(self, request: PySide2.QtNetwork.QNetworkRequest) -> PySide2.QtNetwork.QNetworkReply: ...
    def isStrictTransportSecurityEnabled(self) -> bool: ...
    def isStrictTransportSecurityStoreEnabled(self) -> bool: ...
    def networkAccessible(self) -> PySide2.QtNetwork.QNetworkAccessManager.NetworkAccessibility: ...
    @typing.overload
    def post(self, request: PySide2.QtNetwork.QNetworkRequest, data: PySide2.QtCore.QByteArray) -> PySide2.QtNetwork.QNetworkReply: ...
    @typing.overload
    def post(self, request: PySide2.QtNetwork.QNetworkRequest, data: PySide2.QtCore.QIODevice) -> PySide2.QtNetwork.QNetworkReply: ...
    @typing.overload
    def post(self, request: PySide2.QtNetwork.QNetworkRequest, multiPart: PySide2.QtNetwork.QHttpMultiPart) -> PySide2.QtNetwork.QNetworkReply: ...
    def proxy(self) -> PySide2.QtNetwork.QNetworkProxy: ...
    def proxyFactory(self) -> PySide2.QtNetwork.QNetworkProxyFactory: ...
    @typing.overload
    def put(self, request: PySide2.QtNetwork.QNetworkRequest, data: PySide2.QtCore.QByteArray) -> PySide2.QtNetwork.QNetworkReply: ...
    @typing.overload
    def put(self, request: PySide2.QtNetwork.QNetworkRequest, data: PySide2.QtCore.QIODevice) -> PySide2.QtNetwork.QNetworkReply: ...
    @typing.overload
    def put(self, request: PySide2.QtNetwork.QNetworkRequest, multiPart: PySide2.QtNetwork.QHttpMultiPart) -> PySide2.QtNetwork.QNetworkReply: ...
    def redirectPolicy(self) -> PySide2.QtNetwork.QNetworkRequest.RedirectPolicy: ...
    @typing.overload
    def sendCustomRequest(self, request: PySide2.QtNetwork.QNetworkRequest, verb: PySide2.QtCore.QByteArray, data: PySide2.QtCore.QByteArray) -> PySide2.QtNetwork.QNetworkReply: ...
    @typing.overload
    def sendCustomRequest(self, request: PySide2.QtNetwork.QNetworkRequest, verb: PySide2.QtCore.QByteArray, data: PySide2.QtCore.QIODevice = ...) -> PySide2.QtNetwork.QNetworkReply: ...
    @typing.overload
    def sendCustomRequest(self, request: PySide2.QtNetwork.QNetworkRequest, verb: PySide2.QtCore.QByteArray, multiPart: PySide2.QtNetwork.QHttpMultiPart) -> PySide2.QtNetwork.QNetworkReply: ...
    def setCache(self, cache: PySide2.QtNetwork.QAbstractNetworkCache): ...
    def setConfiguration(self, config: PySide2.QtNetwork.QNetworkConfiguration): ...
    def setCookieJar(self, cookieJar: PySide2.QtNetwork.QNetworkCookieJar): ...
    def setNetworkAccessible(self, accessible: PySide2.QtNetwork.QNetworkAccessManager.NetworkAccessibility): ...
    def setProxy(self, proxy: PySide2.QtNetwork.QNetworkProxy): ...
    def setProxyFactory(self, factory: PySide2.QtNetwork.QNetworkProxyFactory): ...
    def setRedirectPolicy(self, policy: PySide2.QtNetwork.QNetworkRequest.RedirectPolicy): ...
    def setStrictTransportSecurityEnabled(self, enabled: bool): ...
    def strictTransportSecurityHosts(self) -> typing.List[PySide2.QtNetwork.QHstsPolicy]: ...
    def supportedSchemes(self) -> typing.List[str]: ...
    def supportedSchemesImplementation(self) -> typing.List[str]: ...


class QNetworkAddressEntry(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QNetworkAddressEntry): ...
    def __copy__(self): ...
    def broadcast(self) -> PySide2.QtNetwork.QHostAddress: ...
    def clearAddressLifetime(self): ...
    def dnsEligibility(self) -> PySide2.QtNetwork.QNetworkAddressEntry.DnsEligibilityStatus: ...
    def ip(self) -> PySide2.QtNetwork.QHostAddress: ...
    def isLifetimeKnown(self) -> bool: ...
    def isPermanent(self) -> bool: ...
    def isTemporary(self) -> bool: ...
    def netmask(self) -> PySide2.QtNetwork.QHostAddress: ...
    def prefixLength(self) -> int: ...
    def setBroadcast(self, newBroadcast: PySide2.QtNetwork.QHostAddress): ...
    def setDnsEligibility(self, status: PySide2.QtNetwork.QNetworkAddressEntry.DnsEligibilityStatus): ...
    def setIp(self, newIp: PySide2.QtNetwork.QHostAddress): ...
    def setNetmask(self, newNetmask: PySide2.QtNetwork.QHostAddress): ...
    def setPrefixLength(self, length: int): ...
    def swap(self, other: PySide2.QtNetwork.QNetworkAddressEntry): ...


class QNetworkCacheMetaData(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QNetworkCacheMetaData): ...
    def __copy__(self): ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def attributes(self) -> typing.Dict: ...
    def expirationDate(self) -> PySide2.QtCore.QDateTime: ...
    def isValid(self) -> bool: ...
    def lastModified(self) -> PySide2.QtCore.QDateTime: ...
    def rawHeaders(self) -> typing.List[typing.Tuple]: ...
    def saveToDisk(self) -> bool: ...
    def setAttributes(self, attributes: typing.Dict): ...
    def setExpirationDate(self, dateTime: PySide2.QtCore.QDateTime): ...
    def setLastModified(self, dateTime: PySide2.QtCore.QDateTime): ...
    def setRawHeaders(self, headers: typing.List[typing.Tuple]): ...
    def setSaveToDisk(self, allow: bool): ...
    def setUrl(self, url: PySide2.QtCore.QUrl): ...
    def swap(self, other: PySide2.QtNetwork.QNetworkCacheMetaData): ...
    def url(self) -> PySide2.QtCore.QUrl: ...


class QNetworkConfiguration(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QNetworkConfiguration): ...
    def __copy__(self): ...
    def bearerType(self) -> PySide2.QtNetwork.QNetworkConfiguration.BearerType: ...
    def bearerTypeFamily(self) -> PySide2.QtNetwork.QNetworkConfiguration.BearerType: ...
    def bearerTypeName(self) -> str: ...
    def children(self) -> typing.List[PySide2.QtNetwork.QNetworkConfiguration]: ...
    def connectTimeout(self) -> int: ...
    def identifier(self) -> str: ...
    def isRoamingAvailable(self) -> bool: ...
    def isValid(self) -> bool: ...
    def name(self) -> str: ...
    def purpose(self) -> PySide2.QtNetwork.QNetworkConfiguration.Purpose: ...
    def setConnectTimeout(self, timeout: int) -> bool: ...
    def state(self) -> PySide2.QtNetwork.QNetworkConfiguration.StateFlags: ...
    def swap(self, other: PySide2.QtNetwork.QNetworkConfiguration): ...
    def type(self) -> PySide2.QtNetwork.QNetworkConfiguration.Type: ...


class QNetworkConfigurationManager(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def allConfigurations(self, flags: PySide2.QtNetwork.QNetworkConfiguration.StateFlags = ...) -> typing.List[PySide2.QtNetwork.QNetworkConfiguration]: ...
    def capabilities(self) -> PySide2.QtNetwork.QNetworkConfigurationManager.Capabilities: ...
    def configurationFromIdentifier(self, identifier: str) -> PySide2.QtNetwork.QNetworkConfiguration: ...
    def defaultConfiguration(self) -> PySide2.QtNetwork.QNetworkConfiguration: ...
    def isOnline(self) -> bool: ...
    def updateConfigurations(self): ...


class QNetworkCookie(Shiboken.Object):

    @typing.overload
    def __init__(self, name: PySide2.QtCore.QByteArray = ..., value: PySide2.QtCore.QByteArray = ...): ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QNetworkCookie): ...
    def __copy__(self): ...
    def domain(self) -> str: ...
    def expirationDate(self) -> PySide2.QtCore.QDateTime: ...
    def hasSameIdentifier(self, other: PySide2.QtNetwork.QNetworkCookie) -> bool: ...
    def isHttpOnly(self) -> bool: ...
    def isSecure(self) -> bool: ...
    def isSessionCookie(self) -> bool: ...
    def name(self) -> PySide2.QtCore.QByteArray: ...
    def normalize(self, url: PySide2.QtCore.QUrl): ...
    @staticmethod
    def parseCookies(cookieString: PySide2.QtCore.QByteArray) -> typing.List[PySide2.QtNetwork.QNetworkCookie]: ...
    def path(self) -> str: ...
    def setDomain(self, domain: str): ...
    def setExpirationDate(self, date: PySide2.QtCore.QDateTime): ...
    def setHttpOnly(self, enable: bool): ...
    def setName(self, cookieName: PySide2.QtCore.QByteArray): ...
    def setPath(self, path: str): ...
    def setSecure(self, enable: bool): ...
    def setValue(self, value: PySide2.QtCore.QByteArray): ...
    def swap(self, other: PySide2.QtNetwork.QNetworkCookie): ...
    def toRawForm(self, form: PySide2.QtNetwork.QNetworkCookie.RawForm = ...) -> PySide2.QtCore.QByteArray: ...
    def value(self) -> PySide2.QtCore.QByteArray: ...


class QNetworkCookieJar(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def allCookies(self) -> typing.List[PySide2.QtNetwork.QNetworkCookie]: ...
    def cookiesForUrl(self, url: PySide2.QtCore.QUrl) -> typing.List[PySide2.QtNetwork.QNetworkCookie]: ...
    def deleteCookie(self, cookie: PySide2.QtNetwork.QNetworkCookie) -> bool: ...
    def insertCookie(self, cookie: PySide2.QtNetwork.QNetworkCookie) -> bool: ...
    def setAllCookies(self, cookieList: typing.List[PySide2.QtNetwork.QNetworkCookie]): ...
    def setCookiesFromUrl(self, cookieList: typing.List[PySide2.QtNetwork.QNetworkCookie], url: PySide2.QtCore.QUrl) -> bool: ...
    def updateCookie(self, cookie: PySide2.QtNetwork.QNetworkCookie) -> bool: ...
    def validateCookie(self, cookie: PySide2.QtNetwork.QNetworkCookie, url: PySide2.QtCore.QUrl) -> bool: ...


class QNetworkDatagram(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, data: PySide2.QtCore.QByteArray, destinationAddress: PySide2.QtNetwork.QHostAddress = ..., port: int = ...): ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QNetworkDatagram): ...
    def __copy__(self): ...
    def clear(self): ...
    def data(self) -> PySide2.QtCore.QByteArray: ...
    def destinationAddress(self) -> PySide2.QtNetwork.QHostAddress: ...
    def destinationPort(self) -> int: ...
    def hopLimit(self) -> int: ...
    def interfaceIndex(self) -> int: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    def makeReply(self, payload: PySide2.QtCore.QByteArray) -> PySide2.QtNetwork.QNetworkDatagram: ...
    def senderAddress(self) -> PySide2.QtNetwork.QHostAddress: ...
    def senderPort(self) -> int: ...
    def setData(self, data: PySide2.QtCore.QByteArray): ...
    def setDestination(self, address: PySide2.QtNetwork.QHostAddress, port: int): ...
    def setHopLimit(self, count: int): ...
    def setInterfaceIndex(self, index: int): ...
    def setSender(self, address: PySide2.QtNetwork.QHostAddress, port: int = ...): ...
    def swap(self, other: PySide2.QtNetwork.QNetworkDatagram): ...


class QNetworkDiskCache(PySide2.QtNetwork.QAbstractNetworkCache):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def cacheDirectory(self) -> str: ...
    def cacheSize(self) -> int: ...
    def clear(self): ...
    def data(self, url: PySide2.QtCore.QUrl) -> PySide2.QtCore.QIODevice: ...
    def expire(self) -> int: ...
    def fileMetaData(self, fileName: str) -> PySide2.QtNetwork.QNetworkCacheMetaData: ...
    def insert(self, device: PySide2.QtCore.QIODevice): ...
    def maximumCacheSize(self) -> int: ...
    def metaData(self, url: PySide2.QtCore.QUrl) -> PySide2.QtNetwork.QNetworkCacheMetaData: ...
    def prepare(self, metaData: PySide2.QtNetwork.QNetworkCacheMetaData) -> PySide2.QtCore.QIODevice: ...
    def remove(self, url: PySide2.QtCore.QUrl) -> bool: ...
    def setCacheDirectory(self, cacheDir: str): ...
    def setMaximumCacheSize(self, size: int): ...
    def updateMetaData(self, metaData: PySide2.QtNetwork.QNetworkCacheMetaData): ...


class QNetworkInterface(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QNetworkInterface): ...
    def __copy__(self): ...
    def addressEntries(self) -> typing.List[PySide2.QtNetwork.QNetworkAddressEntry]: ...
    @staticmethod
    def allAddresses() -> typing.List[PySide2.QtNetwork.QHostAddress]: ...
    @staticmethod
    def allInterfaces() -> typing.List[PySide2.QtNetwork.QNetworkInterface]: ...
    def flags(self) -> PySide2.QtNetwork.QNetworkInterface.InterfaceFlags: ...
    def hardwareAddress(self) -> str: ...
    def humanReadableName(self) -> str: ...
    def index(self) -> int: ...
    @staticmethod
    def interfaceFromIndex(index: int) -> PySide2.QtNetwork.QNetworkInterface: ...
    @staticmethod
    def interfaceFromName(name: str) -> PySide2.QtNetwork.QNetworkInterface: ...
    @staticmethod
    def interfaceIndexFromName(name: str) -> int: ...
    @staticmethod
    def interfaceNameFromIndex(index: int) -> str: ...
    def isValid(self) -> bool: ...
    def maximumTransmissionUnit(self) -> int: ...
    def name(self) -> str: ...
    def swap(self, other: PySide2.QtNetwork.QNetworkInterface): ...
    def type(self) -> PySide2.QtNetwork.QNetworkInterface.InterfaceType: ...


class QNetworkProxy(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QNetworkProxy): ...
    @typing.overload
    def __init__(self, type: PySide2.QtNetwork.QNetworkProxy.ProxyType, hostName: str = ..., port: int = ..., user: str = ..., password: str = ...): ...
    def __copy__(self): ...
    @staticmethod
    def applicationProxy() -> PySide2.QtNetwork.QNetworkProxy: ...
    def capabilities(self) -> PySide2.QtNetwork.QNetworkProxy.Capabilities: ...
    def hasRawHeader(self, headerName: PySide2.QtCore.QByteArray) -> bool: ...
    def header(self, header: PySide2.QtNetwork.QNetworkRequest.KnownHeaders) -> typing.Any: ...
    def hostName(self) -> str: ...
    def isCachingProxy(self) -> bool: ...
    def isTransparentProxy(self) -> bool: ...
    def password(self) -> str: ...
    def port(self) -> int: ...
    def rawHeader(self, headerName: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    def rawHeaderList(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    @staticmethod
    def setApplicationProxy(proxy: PySide2.QtNetwork.QNetworkProxy): ...
    def setCapabilities(self, capab: PySide2.QtNetwork.QNetworkProxy.Capabilities): ...
    def setHeader(self, header: PySide2.QtNetwork.QNetworkRequest.KnownHeaders, value: typing.Any): ...
    def setHostName(self, hostName: str): ...
    def setPassword(self, password: str): ...
    def setPort(self, port: int): ...
    def setRawHeader(self, headerName: PySide2.QtCore.QByteArray, value: PySide2.QtCore.QByteArray): ...
    def setType(self, type: PySide2.QtNetwork.QNetworkProxy.ProxyType): ...
    def setUser(self, userName: str): ...
    def swap(self, other: PySide2.QtNetwork.QNetworkProxy): ...
    def type(self) -> PySide2.QtNetwork.QNetworkProxy.ProxyType: ...
    def user(self) -> str: ...


class QNetworkProxyFactory(Shiboken.Object):

    def __init__(self): ...
    @staticmethod
    def proxyForQuery(query: PySide2.QtNetwork.QNetworkProxyQuery) -> typing.List[PySide2.QtNetwork.QNetworkProxy]: ...
    def queryProxy(self, query: PySide2.QtNetwork.QNetworkProxyQuery = ...) -> typing.List[PySide2.QtNetwork.QNetworkProxy]: ...
    @staticmethod
    def setApplicationProxyFactory(factory: PySide2.QtNetwork.QNetworkProxyFactory): ...
    @staticmethod
    def setUseSystemConfiguration(enable: bool): ...
    @staticmethod
    def systemProxyForQuery(query: PySide2.QtNetwork.QNetworkProxyQuery = ...) -> typing.List[PySide2.QtNetwork.QNetworkProxy]: ...
    @staticmethod
    def usesSystemConfiguration() -> bool: ...


class QNetworkProxyQuery(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, bindPort: int, protocolTag: str = ..., queryType: PySide2.QtNetwork.QNetworkProxyQuery.QueryType = ...): ...
    @typing.overload
    def __init__(self, hostname: str, port: int, protocolTag: str = ..., queryType: PySide2.QtNetwork.QNetworkProxyQuery.QueryType = ...): ...
    @typing.overload
    def __init__(self, networkConfiguration: PySide2.QtNetwork.QNetworkConfiguration, bindPort: int, protocolTag: str = ..., queryType: PySide2.QtNetwork.QNetworkProxyQuery.QueryType = ...): ...
    @typing.overload
    def __init__(self, networkConfiguration: PySide2.QtNetwork.QNetworkConfiguration, hostname: str, port: int, protocolTag: str = ..., queryType: PySide2.QtNetwork.QNetworkProxyQuery.QueryType = ...): ...
    @typing.overload
    def __init__(self, networkConfiguration: PySide2.QtNetwork.QNetworkConfiguration, requestUrl: PySide2.QtCore.QUrl, queryType: PySide2.QtNetwork.QNetworkProxyQuery.QueryType = ...): ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QNetworkProxyQuery): ...
    @typing.overload
    def __init__(self, requestUrl: PySide2.QtCore.QUrl, queryType: PySide2.QtNetwork.QNetworkProxyQuery.QueryType = ...): ...
    def __copy__(self): ...
    def localPort(self) -> int: ...
    def networkConfiguration(self) -> PySide2.QtNetwork.QNetworkConfiguration: ...
    def peerHostName(self) -> str: ...
    def peerPort(self) -> int: ...
    def protocolTag(self) -> str: ...
    def queryType(self) -> PySide2.QtNetwork.QNetworkProxyQuery.QueryType: ...
    def setLocalPort(self, port: int): ...
    def setNetworkConfiguration(self, networkConfiguration: PySide2.QtNetwork.QNetworkConfiguration): ...
    def setPeerHostName(self, hostname: str): ...
    def setPeerPort(self, port: int): ...
    def setProtocolTag(self, protocolTag: str): ...
    def setQueryType(self, type: PySide2.QtNetwork.QNetworkProxyQuery.QueryType): ...
    def setUrl(self, url: PySide2.QtCore.QUrl): ...
    def swap(self, other: PySide2.QtNetwork.QNetworkProxyQuery): ...
    def url(self) -> PySide2.QtCore.QUrl: ...


class QNetworkReply(PySide2.QtCore.QIODevice):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def abort(self): ...
    def attribute(self, code: PySide2.QtNetwork.QNetworkRequest.Attribute) -> typing.Any: ...
    def close(self): ...
    def error(self) -> PySide2.QtNetwork.QNetworkReply.NetworkError: ...
    def hasRawHeader(self, headerName: PySide2.QtCore.QByteArray) -> bool: ...
    def header(self, header: PySide2.QtNetwork.QNetworkRequest.KnownHeaders) -> typing.Any: ...
    @typing.overload
    def ignoreSslErrors(self): ...
    @typing.overload
    def ignoreSslErrors(self, errors: typing.List[PySide2.QtNetwork.QSslError]): ...
    def ignoreSslErrorsImplementation(self, arg__1: typing.List[PySide2.QtNetwork.QSslError]): ...
    def isFinished(self) -> bool: ...
    def isRunning(self) -> bool: ...
    def isSequential(self) -> bool: ...
    def manager(self) -> PySide2.QtNetwork.QNetworkAccessManager: ...
    def operation(self) -> PySide2.QtNetwork.QNetworkAccessManager.Operation: ...
    def rawHeader(self, headerName: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    def rawHeaderList(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def rawHeaderPairs(self) -> typing.List[typing.Tuple]: ...
    def readBufferSize(self) -> int: ...
    def request(self) -> PySide2.QtNetwork.QNetworkRequest: ...
    def setAttribute(self, code: PySide2.QtNetwork.QNetworkRequest.Attribute, value: typing.Any): ...
    def setError(self, errorCode: PySide2.QtNetwork.QNetworkReply.NetworkError, errorString: str): ...
    def setFinished(self, arg__1: bool): ...
    def setHeader(self, header: PySide2.QtNetwork.QNetworkRequest.KnownHeaders, value: typing.Any): ...
    def setOperation(self, operation: PySide2.QtNetwork.QNetworkAccessManager.Operation): ...
    def setRawHeader(self, headerName: PySide2.QtCore.QByteArray, value: PySide2.QtCore.QByteArray): ...
    def setReadBufferSize(self, size: int): ...
    def setRequest(self, request: PySide2.QtNetwork.QNetworkRequest): ...
    def setSslConfiguration(self, configuration: PySide2.QtNetwork.QSslConfiguration): ...
    def setSslConfigurationImplementation(self, arg__1: PySide2.QtNetwork.QSslConfiguration): ...
    def setUrl(self, url: PySide2.QtCore.QUrl): ...
    def sslConfiguration(self) -> PySide2.QtNetwork.QSslConfiguration: ...
    def sslConfigurationImplementation(self, arg__1: PySide2.QtNetwork.QSslConfiguration): ...
    def url(self) -> PySide2.QtCore.QUrl: ...
    def writeData(self, data: str, len: int) -> int: ...


class QNetworkRequest(Shiboken.Object):

    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QNetworkRequest): ...
    @typing.overload
    def __init__(self, url: PySide2.QtCore.QUrl = ...): ...
    def __copy__(self): ...
    def attribute(self, code: PySide2.QtNetwork.QNetworkRequest.Attribute, defaultValue: typing.Any = ...) -> typing.Any: ...
    def hasRawHeader(self, headerName: PySide2.QtCore.QByteArray) -> bool: ...
    def header(self, header: PySide2.QtNetwork.QNetworkRequest.KnownHeaders) -> typing.Any: ...
    def maximumRedirectsAllowed(self) -> int: ...
    def originatingObject(self) -> PySide2.QtCore.QObject: ...
    def priority(self) -> PySide2.QtNetwork.QNetworkRequest.Priority: ...
    def rawHeader(self, headerName: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    def rawHeaderList(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def setAttribute(self, code: PySide2.QtNetwork.QNetworkRequest.Attribute, value: typing.Any): ...
    def setHeader(self, header: PySide2.QtNetwork.QNetworkRequest.KnownHeaders, value: typing.Any): ...
    def setMaximumRedirectsAllowed(self, maximumRedirectsAllowed: int): ...
    def setOriginatingObject(self, object: PySide2.QtCore.QObject): ...
    def setPriority(self, priority: PySide2.QtNetwork.QNetworkRequest.Priority): ...
    def setRawHeader(self, headerName: PySide2.QtCore.QByteArray, value: PySide2.QtCore.QByteArray): ...
    def setSslConfiguration(self, configuration: PySide2.QtNetwork.QSslConfiguration): ...
    def setUrl(self, url: PySide2.QtCore.QUrl): ...
    def sslConfiguration(self) -> PySide2.QtNetwork.QSslConfiguration: ...
    def swap(self, other: PySide2.QtNetwork.QNetworkRequest): ...
    def url(self) -> PySide2.QtCore.QUrl: ...


class QNetworkSession(PySide2.QtCore.QObject):

    def __init__(self, connConfig: PySide2.QtNetwork.QNetworkConfiguration, parent: PySide2.QtCore.QObject = ...): ...
    def accept(self): ...
    def activeTime(self) -> int: ...
    def bytesReceived(self) -> int: ...
    def bytesWritten(self) -> int: ...
    def close(self): ...
    def configuration(self) -> PySide2.QtNetwork.QNetworkConfiguration: ...
    def connectNotify(self, signal: PySide2.QtCore.QMetaMethod): ...
    def disconnectNotify(self, signal: PySide2.QtCore.QMetaMethod): ...
    def error(self) -> PySide2.QtNetwork.QNetworkSession.SessionError: ...
    def errorString(self) -> str: ...
    def ignore(self): ...
    def interface(self) -> PySide2.QtNetwork.QNetworkInterface: ...
    def isOpen(self) -> bool: ...
    def migrate(self): ...
    def open(self): ...
    def reject(self): ...
    def sessionProperty(self, key: str) -> typing.Any: ...
    def setSessionProperty(self, key: str, value: typing.Any): ...
    def state(self) -> PySide2.QtNetwork.QNetworkSession.State: ...
    def stop(self): ...
    def usagePolicies(self) -> PySide2.QtNetwork.QNetworkSession.UsagePolicies: ...
    def waitForOpened(self, msecs: int = ...) -> bool: ...


class QPasswordDigestor(Shiboken.Object):

    @staticmethod
    def deriveKeyPbkdf1(algorithm: PySide2.QtCore.QCryptographicHash.Algorithm, password: PySide2.QtCore.QByteArray, salt: PySide2.QtCore.QByteArray, iterations: int, dkLen: int) -> PySide2.QtCore.QByteArray: ...
    @staticmethod
    def deriveKeyPbkdf2(algorithm: PySide2.QtCore.QCryptographicHash.Algorithm, password: PySide2.QtCore.QByteArray, salt: PySide2.QtCore.QByteArray, iterations: int, dkLen: int) -> PySide2.QtCore.QByteArray: ...


class QSsl: ...


class QSslCertificate(Shiboken.Object):

    @typing.overload
    def __init__(self, data: PySide2.QtCore.QByteArray = ..., format: PySide2.QtNetwork.QSsl.EncodingFormat = ...): ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice, format: PySide2.QtNetwork.QSsl.EncodingFormat = ...): ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QSslCertificate): ...
    def __copy__(self): ...
    def clear(self): ...
    def digest(self, algorithm: PySide2.QtCore.QCryptographicHash.Algorithm = ...) -> PySide2.QtCore.QByteArray: ...
    def effectiveDate(self) -> PySide2.QtCore.QDateTime: ...
    def expiryDate(self) -> PySide2.QtCore.QDateTime: ...
    def extensions(self) -> typing.List[PySide2.QtNetwork.QSslCertificateExtension]: ...
    @staticmethod
    def fromData(data: PySide2.QtCore.QByteArray, format: PySide2.QtNetwork.QSsl.EncodingFormat = ...) -> typing.List[PySide2.QtNetwork.QSslCertificate]: ...
    @staticmethod
    def fromDevice(device: PySide2.QtCore.QIODevice, format: PySide2.QtNetwork.QSsl.EncodingFormat = ...) -> typing.List[PySide2.QtNetwork.QSslCertificate]: ...
    @staticmethod
    def fromPath(path: str, format: PySide2.QtNetwork.QSsl.EncodingFormat = ..., syntax: PySide2.QtCore.QRegExp.PatternSyntax = ...) -> typing.List[PySide2.QtNetwork.QSslCertificate]: ...
    def handle(self) -> int: ...
    @staticmethod
    def importPkcs12(device: PySide2.QtCore.QIODevice, key: PySide2.QtNetwork.QSslKey, cert: PySide2.QtNetwork.QSslCertificate, caCertificates: typing.List[PySide2.QtNetwork.QSslCertificate] = ..., passPhrase: PySide2.QtCore.QByteArray = ...) -> bool: ...
    def isBlacklisted(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isSelfSigned(self) -> bool: ...
    def issuerDisplayName(self) -> str: ...
    @typing.overload
    def issuerInfo(self, attribute: PySide2.QtCore.QByteArray) -> typing.List[str]: ...
    @typing.overload
    def issuerInfo(self, info: PySide2.QtNetwork.QSslCertificate.SubjectInfo) -> typing.List[str]: ...
    def issuerInfoAttributes(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def publicKey(self) -> PySide2.QtNetwork.QSslKey: ...
    def serialNumber(self) -> PySide2.QtCore.QByteArray: ...
    def subjectAlternativeNames(self) -> typing.DefaultDict[str, typing.List[str]]: ...
    def subjectDisplayName(self) -> str: ...
    @typing.overload
    def subjectInfo(self, attribute: PySide2.QtCore.QByteArray) -> typing.List[str]: ...
    @typing.overload
    def subjectInfo(self, info: PySide2.QtNetwork.QSslCertificate.SubjectInfo) -> typing.List[str]: ...
    def subjectInfoAttributes(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def swap(self, other: PySide2.QtNetwork.QSslCertificate): ...
    def toDer(self) -> PySide2.QtCore.QByteArray: ...
    def toPem(self) -> PySide2.QtCore.QByteArray: ...
    def toText(self) -> str: ...
    @staticmethod
    def verify(certificateChain: typing.List[PySide2.QtNetwork.QSslCertificate], hostName: str = ...) -> typing.List[PySide2.QtNetwork.QSslError]: ...
    def version(self) -> PySide2.QtCore.QByteArray: ...


class QSslCertificateExtension(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QSslCertificateExtension): ...
    def __copy__(self): ...
    def isCritical(self) -> bool: ...
    def isSupported(self) -> bool: ...
    def name(self) -> str: ...
    def oid(self) -> str: ...
    def swap(self, other: PySide2.QtNetwork.QSslCertificateExtension): ...
    def value(self) -> typing.Any: ...


class QSslCipher(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, name: str): ...
    @typing.overload
    def __init__(self, name: str, protocol: PySide2.QtNetwork.QSsl.SslProtocol): ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QSslCipher): ...
    def __copy__(self): ...
    def authenticationMethod(self) -> str: ...
    def encryptionMethod(self) -> str: ...
    def isNull(self) -> bool: ...
    def keyExchangeMethod(self) -> str: ...
    def name(self) -> str: ...
    def protocol(self) -> PySide2.QtNetwork.QSsl.SslProtocol: ...
    def protocolString(self) -> str: ...
    def supportedBits(self) -> int: ...
    def swap(self, other: PySide2.QtNetwork.QSslCipher): ...
    def usedBits(self) -> int: ...


class QSslConfiguration(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QSslConfiguration): ...
    def __copy__(self): ...
    def allowedNextProtocols(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def backendConfiguration(self) -> typing.Dict: ...
    def caCertificates(self) -> typing.List[PySide2.QtNetwork.QSslCertificate]: ...
    def ciphers(self) -> typing.List[PySide2.QtNetwork.QSslCipher]: ...
    @staticmethod
    def defaultConfiguration() -> PySide2.QtNetwork.QSslConfiguration: ...
    @staticmethod
    def defaultDtlsConfiguration() -> PySide2.QtNetwork.QSslConfiguration: ...
    def diffieHellmanParameters(self) -> PySide2.QtNetwork.QSslDiffieHellmanParameters: ...
    def dtlsCookieVerificationEnabled(self) -> bool: ...
    def ephemeralServerKey(self) -> PySide2.QtNetwork.QSslKey: ...
    def isNull(self) -> bool: ...
    def localCertificate(self) -> PySide2.QtNetwork.QSslCertificate: ...
    def localCertificateChain(self) -> typing.List[PySide2.QtNetwork.QSslCertificate]: ...
    def nextNegotiatedProtocol(self) -> PySide2.QtCore.QByteArray: ...
    def nextProtocolNegotiationStatus(self) -> PySide2.QtNetwork.QSslConfiguration.NextProtocolNegotiationStatus: ...
    def peerCertificate(self) -> PySide2.QtNetwork.QSslCertificate: ...
    def peerCertificateChain(self) -> typing.List[PySide2.QtNetwork.QSslCertificate]: ...
    def peerVerifyDepth(self) -> int: ...
    def peerVerifyMode(self) -> PySide2.QtNetwork.QSslSocket.PeerVerifyMode: ...
    def preSharedKeyIdentityHint(self) -> PySide2.QtCore.QByteArray: ...
    def privateKey(self) -> PySide2.QtNetwork.QSslKey: ...
    def protocol(self) -> PySide2.QtNetwork.QSsl.SslProtocol: ...
    def sessionCipher(self) -> PySide2.QtNetwork.QSslCipher: ...
    def sessionProtocol(self) -> PySide2.QtNetwork.QSsl.SslProtocol: ...
    def sessionTicket(self) -> PySide2.QtCore.QByteArray: ...
    def sessionTicketLifeTimeHint(self) -> int: ...
    def setAllowedNextProtocols(self, protocols: typing.List[PySide2.QtCore.QByteArray]): ...
    def setBackendConfiguration(self, backendConfiguration: typing.Dict = ...): ...
    def setBackendConfigurationOption(self, name: PySide2.QtCore.QByteArray, value: typing.Any): ...
    def setCaCertificates(self, certificates: typing.List[PySide2.QtNetwork.QSslCertificate]): ...
    def setCiphers(self, ciphers: typing.List[PySide2.QtNetwork.QSslCipher]): ...
    @staticmethod
    def setDefaultConfiguration(configuration: PySide2.QtNetwork.QSslConfiguration): ...
    @staticmethod
    def setDefaultDtlsConfiguration(configuration: PySide2.QtNetwork.QSslConfiguration): ...
    def setDiffieHellmanParameters(self, dhparams: PySide2.QtNetwork.QSslDiffieHellmanParameters): ...
    def setDtlsCookieVerificationEnabled(self, enable: bool): ...
    def setLocalCertificate(self, certificate: PySide2.QtNetwork.QSslCertificate): ...
    def setLocalCertificateChain(self, localChain: typing.List[PySide2.QtNetwork.QSslCertificate]): ...
    def setPeerVerifyDepth(self, depth: int): ...
    def setPeerVerifyMode(self, mode: PySide2.QtNetwork.QSslSocket.PeerVerifyMode): ...
    def setPreSharedKeyIdentityHint(self, hint: PySide2.QtCore.QByteArray): ...
    def setPrivateKey(self, key: PySide2.QtNetwork.QSslKey): ...
    def setProtocol(self, protocol: PySide2.QtNetwork.QSsl.SslProtocol): ...
    def setSessionTicket(self, sessionTicket: PySide2.QtCore.QByteArray): ...
    def setSslOption(self, option: PySide2.QtNetwork.QSsl.SslOption, on: bool): ...
    @staticmethod
    def supportedCiphers() -> typing.List[PySide2.QtNetwork.QSslCipher]: ...
    def swap(self, other: PySide2.QtNetwork.QSslConfiguration): ...
    @staticmethod
    def systemCaCertificates() -> typing.List[PySide2.QtNetwork.QSslCertificate]: ...
    def testSslOption(self, option: PySide2.QtNetwork.QSsl.SslOption) -> bool: ...


class QSslDiffieHellmanParameters(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QSslDiffieHellmanParameters): ...
    def __copy__(self): ...
    @staticmethod
    def defaultParameters() -> PySide2.QtNetwork.QSslDiffieHellmanParameters: ...
    def error(self) -> PySide2.QtNetwork.QSslDiffieHellmanParameters.Error: ...
    def errorString(self) -> str: ...
    @typing.overload
    @staticmethod
    def fromEncoded(device: PySide2.QtCore.QIODevice, format: PySide2.QtNetwork.QSsl.EncodingFormat = ...) -> PySide2.QtNetwork.QSslDiffieHellmanParameters: ...
    @typing.overload
    @staticmethod
    def fromEncoded(encoded: PySide2.QtCore.QByteArray, format: PySide2.QtNetwork.QSsl.EncodingFormat = ...) -> PySide2.QtNetwork.QSslDiffieHellmanParameters: ...
    def isEmpty(self) -> bool: ...
    def isValid(self) -> bool: ...
    def swap(self, other: PySide2.QtNetwork.QSslDiffieHellmanParameters): ...


class QSslError(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, error: PySide2.QtNetwork.QSslError.SslError): ...
    @typing.overload
    def __init__(self, error: PySide2.QtNetwork.QSslError.SslError, certificate: PySide2.QtNetwork.QSslCertificate): ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QSslError): ...
    def __copy__(self): ...
    def certificate(self) -> PySide2.QtNetwork.QSslCertificate: ...
    def error(self) -> PySide2.QtNetwork.QSslError.SslError: ...
    def errorString(self) -> str: ...
    def swap(self, other: PySide2.QtNetwork.QSslError): ...


class QSslKey(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice, algorithm: PySide2.QtNetwork.QSsl.KeyAlgorithm, format: PySide2.QtNetwork.QSsl.EncodingFormat = ..., type: PySide2.QtNetwork.QSsl.KeyType = ..., passPhrase: PySide2.QtCore.QByteArray = ...): ...
    @typing.overload
    def __init__(self, encoded: PySide2.QtCore.QByteArray, algorithm: PySide2.QtNetwork.QSsl.KeyAlgorithm, format: PySide2.QtNetwork.QSsl.EncodingFormat = ..., type: PySide2.QtNetwork.QSsl.KeyType = ..., passPhrase: PySide2.QtCore.QByteArray = ...): ...
    @typing.overload
    def __init__(self, handle: int, type: PySide2.QtNetwork.QSsl.KeyType = ...): ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QSslKey): ...
    def __copy__(self): ...
    def algorithm(self) -> PySide2.QtNetwork.QSsl.KeyAlgorithm: ...
    def clear(self): ...
    def handle(self) -> int: ...
    def isNull(self) -> bool: ...
    def length(self) -> int: ...
    def swap(self, other: PySide2.QtNetwork.QSslKey): ...
    def toDer(self, passPhrase: PySide2.QtCore.QByteArray = ...) -> PySide2.QtCore.QByteArray: ...
    def toPem(self, passPhrase: PySide2.QtCore.QByteArray = ...) -> PySide2.QtCore.QByteArray: ...
    def type(self) -> PySide2.QtNetwork.QSsl.KeyType: ...


class QSslPreSharedKeyAuthenticator(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, authenticator: PySide2.QtNetwork.QSslPreSharedKeyAuthenticator): ...
    def __copy__(self): ...
    def identity(self) -> PySide2.QtCore.QByteArray: ...
    def identityHint(self) -> PySide2.QtCore.QByteArray: ...
    def maximumIdentityLength(self) -> int: ...
    def maximumPreSharedKeyLength(self) -> int: ...
    def preSharedKey(self) -> PySide2.QtCore.QByteArray: ...
    def setIdentity(self, identity: PySide2.QtCore.QByteArray): ...
    def setPreSharedKey(self, preSharedKey: PySide2.QtCore.QByteArray): ...
    def swap(self, other: PySide2.QtNetwork.QSslPreSharedKeyAuthenticator): ...


class QSslSocket(PySide2.QtNetwork.QTcpSocket):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def abort(self): ...
    def addCaCertificate(self, certificate: PySide2.QtNetwork.QSslCertificate): ...
    @typing.overload
    def addCaCertificates(self, certificates: typing.List[PySide2.QtNetwork.QSslCertificate]): ...
    @typing.overload
    def addCaCertificates(self, path: str, format: PySide2.QtNetwork.QSsl.EncodingFormat = ..., syntax: PySide2.QtCore.QRegExp.PatternSyntax = ...) -> bool: ...
    @staticmethod
    def addDefaultCaCertificate(certificate: PySide2.QtNetwork.QSslCertificate): ...
    @typing.overload
    @staticmethod
    def addDefaultCaCertificates(certificates: typing.List[PySide2.QtNetwork.QSslCertificate]): ...
    @typing.overload
    @staticmethod
    def addDefaultCaCertificates(path: str, format: PySide2.QtNetwork.QSsl.EncodingFormat = ..., syntax: PySide2.QtCore.QRegExp.PatternSyntax = ...) -> bool: ...
    def atEnd(self) -> bool: ...
    def bytesAvailable(self) -> int: ...
    def bytesToWrite(self) -> int: ...
    def caCertificates(self) -> typing.List[PySide2.QtNetwork.QSslCertificate]: ...
    def canReadLine(self) -> bool: ...
    def ciphers(self) -> typing.List[PySide2.QtNetwork.QSslCipher]: ...
    def close(self): ...
    @typing.overload
    def connectToHost(self, address: PySide2.QtNetwork.QHostAddress, port: int, mode: PySide2.QtCore.QIODevice.OpenMode = ...): ...
    @typing.overload
    def connectToHost(self, hostName: str, port: int, openMode: PySide2.QtCore.QIODevice.OpenMode = ..., protocol: PySide2.QtNetwork.QAbstractSocket.NetworkLayerProtocol = ...): ...
    @typing.overload
    def connectToHostEncrypted(self, hostName: str, port: int, mode: PySide2.QtCore.QIODevice.OpenMode = ..., protocol: PySide2.QtNetwork.QAbstractSocket.NetworkLayerProtocol = ...): ...
    @typing.overload
    def connectToHostEncrypted(self, hostName: str, port: int, sslPeerName: str, mode: PySide2.QtCore.QIODevice.OpenMode = ..., protocol: PySide2.QtNetwork.QAbstractSocket.NetworkLayerProtocol = ...): ...
    @staticmethod
    def defaultCaCertificates() -> typing.List[PySide2.QtNetwork.QSslCertificate]: ...
    @staticmethod
    def defaultCiphers() -> typing.List[PySide2.QtNetwork.QSslCipher]: ...
    def disconnectFromHost(self): ...
    def encryptedBytesAvailable(self) -> int: ...
    def encryptedBytesToWrite(self) -> int: ...
    def flush(self) -> bool: ...
    @typing.overload
    def ignoreSslErrors(self): ...
    @typing.overload
    def ignoreSslErrors(self, errors: typing.List[PySide2.QtNetwork.QSslError]): ...
    def isEncrypted(self) -> bool: ...
    def localCertificate(self) -> PySide2.QtNetwork.QSslCertificate: ...
    def localCertificateChain(self) -> typing.List[PySide2.QtNetwork.QSslCertificate]: ...
    def mode(self) -> PySide2.QtNetwork.QSslSocket.SslMode: ...
    def peerCertificate(self) -> PySide2.QtNetwork.QSslCertificate: ...
    def peerCertificateChain(self) -> typing.List[PySide2.QtNetwork.QSslCertificate]: ...
    def peerVerifyDepth(self) -> int: ...
    def peerVerifyMode(self) -> PySide2.QtNetwork.QSslSocket.PeerVerifyMode: ...
    def peerVerifyName(self) -> str: ...
    def privateKey(self) -> PySide2.QtNetwork.QSslKey: ...
    def protocol(self) -> PySide2.QtNetwork.QSsl.SslProtocol: ...
    def readData(self, data: str, maxlen: int) -> int: ...
    def resume(self): ...
    def sessionCipher(self) -> PySide2.QtNetwork.QSslCipher: ...
    def sessionProtocol(self) -> PySide2.QtNetwork.QSsl.SslProtocol: ...
    def setCaCertificates(self, certificates: typing.List[PySide2.QtNetwork.QSslCertificate]): ...
    @typing.overload
    def setCiphers(self, ciphers: typing.List[PySide2.QtNetwork.QSslCipher]): ...
    @typing.overload
    def setCiphers(self, ciphers: str): ...
    @staticmethod
    def setDefaultCaCertificates(certificates: typing.List[PySide2.QtNetwork.QSslCertificate]): ...
    @staticmethod
    def setDefaultCiphers(ciphers: typing.List[PySide2.QtNetwork.QSslCipher]): ...
    @typing.overload
    def setLocalCertificate(self, certificate: PySide2.QtNetwork.QSslCertificate): ...
    @typing.overload
    def setLocalCertificate(self, fileName: str, format: PySide2.QtNetwork.QSsl.EncodingFormat = ...): ...
    def setLocalCertificateChain(self, localChain: typing.List[PySide2.QtNetwork.QSslCertificate]): ...
    def setPeerVerifyDepth(self, depth: int): ...
    def setPeerVerifyMode(self, mode: PySide2.QtNetwork.QSslSocket.PeerVerifyMode): ...
    def setPeerVerifyName(self, hostName: str): ...
    @typing.overload
    def setPrivateKey(self, fileName: str, algorithm: PySide2.QtNetwork.QSsl.KeyAlgorithm = ..., format: PySide2.QtNetwork.QSsl.EncodingFormat = ..., passPhrase: PySide2.QtCore.QByteArray = ...): ...
    @typing.overload
    def setPrivateKey(self, key: PySide2.QtNetwork.QSslKey): ...
    def setProtocol(self, protocol: PySide2.QtNetwork.QSsl.SslProtocol): ...
    def setReadBufferSize(self, size: int): ...
    def setSocketDescriptor(self, socketDescriptor: int, state: PySide2.QtNetwork.QAbstractSocket.SocketState = ..., openMode: PySide2.QtCore.QIODevice.OpenMode = ...) -> bool: ...
    def setSocketOption(self, option: PySide2.QtNetwork.QAbstractSocket.SocketOption, value: typing.Any): ...
    def setSslConfiguration(self, config: PySide2.QtNetwork.QSslConfiguration): ...
    def socketOption(self, option: PySide2.QtNetwork.QAbstractSocket.SocketOption) -> typing.Any: ...
    def sslConfiguration(self) -> PySide2.QtNetwork.QSslConfiguration: ...
    def sslErrors(self) -> typing.List[PySide2.QtNetwork.QSslError]: ...
    @staticmethod
    def sslLibraryBuildVersionNumber() -> int: ...
    @staticmethod
    def sslLibraryBuildVersionString() -> str: ...
    @staticmethod
    def sslLibraryVersionNumber() -> int: ...
    @staticmethod
    def sslLibraryVersionString() -> str: ...
    def startClientEncryption(self): ...
    def startServerEncryption(self): ...
    @staticmethod
    def supportedCiphers() -> typing.List[PySide2.QtNetwork.QSslCipher]: ...
    @staticmethod
    def supportsSsl() -> bool: ...
    @staticmethod
    def systemCaCertificates() -> typing.List[PySide2.QtNetwork.QSslCertificate]: ...
    def waitForBytesWritten(self, msecs: int = ...) -> bool: ...
    def waitForConnected(self, msecs: int = ...) -> bool: ...
    def waitForDisconnected(self, msecs: int = ...) -> bool: ...
    def waitForEncrypted(self, msecs: int = ...) -> bool: ...
    def waitForReadyRead(self, msecs: int = ...) -> bool: ...
    def writeData(self, data: str, len: int) -> int: ...


class QTcpServer(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def addPendingConnection(self, socket: PySide2.QtNetwork.QTcpSocket): ...
    def close(self): ...
    def errorString(self) -> str: ...
    def hasPendingConnections(self) -> bool: ...
    def incomingConnection(self, handle: int): ...
    def isListening(self) -> bool: ...
    def listen(self, address: PySide2.QtNetwork.QHostAddress = ..., port: int = ...) -> bool: ...
    def maxPendingConnections(self) -> int: ...
    def nextPendingConnection(self) -> PySide2.QtNetwork.QTcpSocket: ...
    def pauseAccepting(self): ...
    def proxy(self) -> PySide2.QtNetwork.QNetworkProxy: ...
    def resumeAccepting(self): ...
    def serverAddress(self) -> PySide2.QtNetwork.QHostAddress: ...
    def serverError(self) -> PySide2.QtNetwork.QAbstractSocket.SocketError: ...
    def serverPort(self) -> int: ...
    def setMaxPendingConnections(self, numConnections: int): ...
    def setProxy(self, networkProxy: PySide2.QtNetwork.QNetworkProxy): ...
    def setSocketDescriptor(self, socketDescriptor: int) -> bool: ...
    def socketDescriptor(self) -> int: ...
    def waitForNewConnection(self, msec: int, timedOut: bool) -> bool: ...


class QTcpSocket(PySide2.QtNetwork.QAbstractSocket):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...


class QUdpSocket(PySide2.QtNetwork.QAbstractSocket):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def hasPendingDatagrams(self) -> bool: ...
    @typing.overload
    def joinMulticastGroup(self, groupAddress: PySide2.QtNetwork.QHostAddress) -> bool: ...
    @typing.overload
    def joinMulticastGroup(self, groupAddress: PySide2.QtNetwork.QHostAddress, iface: PySide2.QtNetwork.QNetworkInterface) -> bool: ...
    @typing.overload
    def leaveMulticastGroup(self, groupAddress: PySide2.QtNetwork.QHostAddress) -> bool: ...
    @typing.overload
    def leaveMulticastGroup(self, groupAddress: PySide2.QtNetwork.QHostAddress, iface: PySide2.QtNetwork.QNetworkInterface) -> bool: ...
    def multicastInterface(self) -> PySide2.QtNetwork.QNetworkInterface: ...
    def pendingDatagramSize(self) -> int: ...
    def readDatagram(self, data: str, maxlen: int, host: PySide2.QtNetwork.QHostAddress, port: int) -> int: ...
    def receiveDatagram(self, maxSize: int = ...) -> PySide2.QtNetwork.QNetworkDatagram: ...
    def setMulticastInterface(self, iface: PySide2.QtNetwork.QNetworkInterface): ...
    @typing.overload
    def writeDatagram(self, datagram: PySide2.QtCore.QByteArray, host: PySide2.QtNetwork.QHostAddress, port: int) -> int: ...
    @typing.overload
    def writeDatagram(self, datagram: PySide2.QtNetwork.QNetworkDatagram) -> int: ...

# eof
